/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.image;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.jmol.image.CRCEncoder;

public class PngEncoder
extends CRCEncoder {
    public static final int FILTER_NONE = 0;
    public static final int FILTER_SUB = 1;
    public static final int FILTER_UP = 2;
    public static final int FILTER_LAST = 2;
    private boolean encodeAlpha;
    private int filter = 0;
    private int bytesPerPixel;
    private int compressionLevel;
    private String type;
    private Integer transparentColor;
    private byte[] applicationData;
    private String applicationPrefix;
    private String version;
    private byte[] scanLines;
    private int byteWidth;

    @Override
    protected void setParams(Map<String, Object> map) {
        if (this.quality < 0) {
            this.quality = 2;
        } else if (this.quality > 9) {
            this.quality = 9;
        }
        this.encodeAlpha = false;
        this.filter = 0;
        this.compressionLevel = this.quality;
        this.transparentColor = (Integer)map.get("transparentColor");
        this.type = (map.get("type") + "0000").substring(0, 4);
        this.version = (String)map.get("comment");
        this.applicationData = (byte[])map.get("applicationData");
        this.applicationPrefix = (String)map.get("applicationPrefix");
    }

    @Override
    protected void generate() throws IOException {
        int[] nArray = new int[1];
        if (!this.pngEncode(nArray)) {
            this.out.cancel();
            return;
        }
        byte[] byArray = this.getBytes();
        int n = this.dataLen;
        if (this.applicationData != null) {
            PngEncoder.setJmolTypeText(this.applicationPrefix, nArray[0], byArray, n, this.applicationData.length, this.type);
            this.out.write(byArray, 0, n);
            byArray = this.applicationData;
            n = this.applicationData.length;
        }
        this.out.write(byArray, 0, n);
    }

    private boolean pngEncode(int[] nArray) {
        byte[] byArray = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        this.writeBytes(byArray);
        this.writeHeader();
        nArray[0] = this.bytePos + 4;
        this.writeText(PngEncoder.getApplicationText(this.applicationPrefix, this.type, 0, 0));
        this.writeText("Software\u0000Jmol " + this.version);
        this.writeText("Creation Time\u0000" + this.date);
        if (!this.encodeAlpha && this.transparentColor != null) {
            this.writeTransparentColor(this.transparentColor);
        }
        return this.writeImageData();
    }

    private static void setJmolTypeText(String string, int n, byte[] byArray, int n2, int n3, String string2) {
        String string3 = "iTXt" + PngEncoder.getApplicationText(string, string2, n2, n3);
        PngEncoder pngEncoder = new PngEncoder();
        pngEncoder.setData(byArray, n);
        pngEncoder.writeString(string3);
        pngEncoder.writeCRC();
    }

    private static String getApplicationText(String string, String string2, int n, int n2) {
        String string3 = "000000000" + n;
        string3 = string3.substring(string3.length() - 9);
        String string4 = "000000000" + n2;
        string4 = string4.substring(string4.length() - 9);
        return string + "\u0000" + string2 + (string2.equals("PNG") ? "0" : "") + string3 + "+" + string4;
    }

    private void writeHeader() {
        this.writeInt4(13);
        this.startPos = this.bytePos;
        this.writeString("IHDR");
        this.writeInt4(this.width);
        this.writeInt4(this.height);
        this.writeByte(8);
        this.writeByte(this.encodeAlpha ? 6 : 2);
        this.writeByte(0);
        this.writeByte(0);
        this.writeByte(0);
        this.writeCRC();
    }

    private void writeText(String string) {
        this.writeInt4(string.length());
        this.startPos = this.bytePos;
        this.writeString("iTXt" + string);
        this.writeCRC();
    }

    private void writeTransparentColor(int n) {
        this.writeInt4(6);
        this.startPos = this.bytePos;
        this.writeString("tRNS");
        this.writeInt2(n >> 16 & 0xFF);
        this.writeInt2(n >> 8 & 0xFF);
        this.writeInt2(n & 0xFF);
        this.writeCRC();
    }

    private boolean writeImageData() {
        this.bytesPerPixel = this.encodeAlpha ? 4 : 3;
        this.byteWidth = this.width * this.bytesPerPixel;
        int n = this.byteWidth + 1;
        Deflater deflater = new Deflater(this.compressionLevel);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater);
        int n2 = 0;
        try {
            int n3;
            for (int i = this.height; i > 0; i -= n3) {
                n3 = Math.max(1, Math.min(Short.MAX_VALUE / n, i));
                this.scanLines = new byte[n * n3];
                int n4 = this.width * n3;
                int n5 = 0;
                int n6 = 0;
                while (n6 < n4) {
                    if (n6 % this.width == 0) {
                        this.scanLines[n5++] = (byte)this.filter;
                    }
                    this.scanLines[n5++] = (byte)(this.pixels[n2] >> 16 & 0xFF);
                    this.scanLines[n5++] = (byte)(this.pixels[n2] >> 8 & 0xFF);
                    this.scanLines[n5++] = (byte)(this.pixels[n2] & 0xFF);
                    if (this.encodeAlpha) {
                        this.scanLines[n5++] = (byte)(this.pixels[n2] >> 24 & 0xFF);
                    }
                    ++n6;
                    ++n2;
                }
                deflaterOutputStream.write(this.scanLines, 0, n5);
            }
            deflaterOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.writeInt4(byArray.length);
            this.startPos = this.bytePos;
            this.writeString("IDAT");
            this.writeBytes(byArray);
            this.writeCRC();
            this.writeEnd();
            deflater.finish();
            return true;
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
            return false;
        }
    }

    private void writeEnd() {
        this.writeInt4(0);
        this.startPos = this.bytePos;
        this.writeString("IEND");
        this.writeCRC();
    }
}

