/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import javajs.util.AU;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomCollection;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondIterator;
import org.jmol.modelset.BondIteratorSelected;
import org.jmol.modelset.BondSet;
import org.jmol.modelset.HBond;
import org.jmol.modelset.ModelCollection;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.JmolEdge;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;

public abstract class BondCollection
extends AtomCollection {
    protected JmolMolecule[] molecules;
    protected int moleculeCount;
    public Bond[] bonds;
    public int bondCount;
    protected static final int BOND_GROWTH_INCREMENT = 250;
    protected static final int MAX_BONDS_LENGTH_TO_CACHE = 5;
    protected static final int MAX_NUM_TO_CACHE = 200;
    protected int[] numCached = new int[5];
    protected Bond[][][] freeBonds = new Bond[5][][];
    private boolean haveWarned;
    protected short defaultCovalentMad;
    private BS bsAromaticSingle;
    private BS bsAromaticDouble;
    protected BS bsAromatic;
    public boolean haveHiddenBonds;

    public BondCollection() {
        int n = 5;
        while (--n > 0) {
            this.freeBonds[n] = new Bond[200][];
        }
        this.haveWarned = false;
        this.bsAromatic = new BS();
    }

    @Override
    protected void releaseModelSet() {
        this.releaseModelSetBC();
    }

    protected void releaseModelSetBC() {
        this.bonds = null;
        this.freeBonds = null;
        this.releaseModelSetAC();
    }

    protected void resetMolecules() {
        this.molecules = null;
        this.moleculeCount = 0;
    }

    public Bond getBondAt(int n) {
        return this.bonds[n];
    }

    public BondIterator getBondIteratorForType(int n, BS bS) {
        return new BondIteratorSelected(this.bonds, this.bondCount, n, bS, this.viewer.getBoolean(0x24000024));
    }

    public BondIterator getBondIterator(BS bS) {
        return new BondIteratorSelected(this.bonds, this.bondCount, 131071, bS, false);
    }

    public Atom getBondAtom1(int n) {
        return this.bonds[n].atom1;
    }

    public Atom getBondAtom2(int n) {
        return this.bonds[n].atom2;
    }

    public float getBondRadius(int n) {
        return this.bonds[n].getRadius();
    }

    public int getBondOrder(int n) {
        return this.bonds[n].order;
    }

    public short getBondColix1(int n) {
        return this.bonds[n].getColix1();
    }

    public short getBondColix2(int n) {
        return this.bonds[n].getColix2();
    }

    public int getBondModelIndex(int n) {
        return this.bonds[n].atom1.modelIndex;
    }

    protected int getBondCountInModel(int n) {
        int n2 = 0;
        int n3 = this.bondCount;
        while (--n3 >= 0) {
            if (this.bonds[n3].atom1.modelIndex != n) continue;
            ++n2;
        }
        return n2;
    }

    public BS getBondsForSelectedAtoms(BS bS, boolean bl) {
        BS bS2 = new BS();
        for (int i = 0; i < this.bondCount; ++i) {
            boolean bl2;
            boolean bl3;
            Bond bond = this.bonds[i];
            if (!(!bl & (bl3 = bS.get(bond.atom1.index)) & (bl2 = bS.get(bond.atom2.index))) && !(bl & (bl3 | bl2))) continue;
            bS2.set(i);
        }
        return bS2;
    }

    public Bond bondAtoms(Atom atom, Atom atom2, int n, short s, BS bS, float f, boolean bl, boolean bl2) {
        Bond bond = this.getOrAddBond(atom, atom2, n, s, bS, f, true);
        if (bl2) {
            bond.order |= 0x20000;
            if (bl) {
                atom.group = atom2.group;
                atom.group.addAtoms(atom.index);
            }
        }
        return bond;
    }

    private Bond getOrAddBond(Atom atom, Atom atom2, int n, short s, BS bS, float f, boolean bl) {
        int n2;
        if (n == 131071 || n == 65535) {
            n = 1;
        }
        if (atom.isBonded(atom2)) {
            n2 = atom.getBond((Atom)atom2).index;
            if (bl) {
                this.bonds[n2].setOrder(n);
                this.bonds[n2].setMad(s);
                if (this.bonds[n2] instanceof HBond) {
                    ((HBond)this.bonds[n2]).energy = f;
                }
            }
        } else {
            if (this.bondCount == this.bonds.length) {
                this.bonds = (Bond[])AU.arrayCopyObject(this.bonds, this.bondCount + 250);
            }
            n2 = this.setBond((int)this.bondCount++, (Bond)this.bondMutually((Atom)atom, (Atom)atom2, (int)n, (short)s, (float)f)).index;
        }
        if (bS != null) {
            bS.set(n2);
        }
        return this.bonds[n2];
    }

    protected Bond setBond(int n, Bond bond) {
        bond.index = n;
        this.bonds[bond.index] = bond;
        return this.bonds[bond.index];
    }

    protected Bond bondMutually(Atom atom, Atom atom2, int n, short s, float f) {
        Bond bond = Bond.isOrderH(n) ? new HBond(atom, atom2, n, s, 0, f) : new Bond(atom, atom2, n, s, 0);
        this.addBondToAtom(atom, bond);
        this.addBondToAtom(atom2, bond);
        return bond;
    }

    private void addBondToAtom(Atom atom, Bond bond) {
        if (atom.bonds == null) {
            atom.bonds = new Bond[1];
            atom.bonds[0] = bond;
        } else {
            atom.bonds = this.addToBonds(bond, atom.bonds);
        }
    }

    private Bond[] addToBonds(Bond bond, Bond[] bondArray) {
        Bond[] bondArray2;
        if (bondArray == null) {
            if (this.numCached[1] > 0) {
                this.numCached[1] = this.numCached[1] - 1;
                bondArray2 = this.freeBonds[1][this.numCached[1]];
            } else {
                bondArray2 = new Bond[]{bond};
            }
        } else {
            int n = bondArray.length;
            int n2 = n + 1;
            if (n2 < 5 && this.numCached[n2] > 0) {
                int n3 = n2;
                int n4 = this.numCached[n3] - 1;
                this.numCached[n3] = n4;
                bondArray2 = this.freeBonds[n2][n4];
            } else {
                bondArray2 = new Bond[n2];
            }
            bondArray2[n] = bond;
            int n5 = n;
            while (--n5 >= 0) {
                bondArray2[n5] = bondArray[n5];
            }
            if (n < 5 && this.numCached[n] < 200) {
                int n6 = n;
                int n7 = this.numCached[n6];
                this.numCached[n6] = n7 + 1;
                this.freeBonds[n][n7] = bondArray;
            }
        }
        return bondArray2;
    }

    public int addHBond(Atom atom, Atom atom2, int n, float f) {
        if (this.bondCount == this.bonds.length) {
            this.bonds = (Bond[])AU.arrayCopyObject(this.bonds, this.bondCount + 250);
        }
        return this.setBond((int)this.bondCount++, (Bond)this.bondMutually((Atom)atom, (Atom)atom2, (int)n, (short)1, (float)f)).index;
    }

    protected static short getBondOrderFull(float f, float f2, float f3, float f4, float f5) {
        if (f == 0.0f || f2 == 0.0f || f3 < f4) {
            return 0;
        }
        float f6 = f + f2 + f5;
        float f7 = f6 * f6;
        return f3 > f7 ? (short)0 : 1;
    }

    protected boolean checkValencesAndBond(Atom atom, Atom atom2, int n, short s, BS bS) {
        if (atom.getCurrentBondCount() > 20 || atom2.getCurrentBondCount() > 20) {
            if (!this.haveWarned) {
                Logger.warn("maximum auto bond count reached");
            }
            this.haveWarned = true;
            return false;
        }
        int n2 = atom.getFormalCharge();
        if (n2 != 0) {
            int n3 = atom2.getFormalCharge();
            if (n2 < 0 && n3 < 0 || n2 > 0 && n3 > 0) {
                return false;
            }
        }
        if (atom.altloc != atom2.altloc && atom.altloc != '\u0000' && atom2.altloc != '\u0000') {
            return false;
        }
        this.getOrAddBond(atom, atom2, n, s, bS, 0.0f, false);
        return true;
    }

    protected void deleteAllBonds2() {
        this.viewer.setShapeProperty(1, "reset", null);
        int n = this.bondCount;
        while (--n >= 0) {
            this.bonds[n].deleteAtomReferences();
            this.bonds[n] = null;
        }
        this.bondCount = 0;
    }

    public short getDefaultMadFromOrder(int n) {
        return (short)(Bond.isOrderH(n) ? 1 : ((n & 0x8000) != 0 ? (int)Math.floor(this.viewer.getFloat(570425406) * 2000.0f) : this.defaultCovalentMad));
    }

    protected int[] deleteConnections(float f, float f2, int n, BS bS, BS bS2, boolean bl, boolean bl2, float f3, float f4) {
        Object object;
        int n2;
        BS bS3;
        boolean bl3 = f < 0.0f;
        boolean bl4 = f2 < 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (bl3) {
            f = -f;
        }
        if (bl4) {
            f2 = -f2;
        }
        BS bS4 = new BS();
        int n3 = 0;
        int n4 = n |= 0x20000;
        if (!bl2 && Bond.isOrderH(n)) {
            n = 30720;
        }
        if (bl) {
            bS3 = bS;
        } else {
            bS3 = new BS();
            n2 = bS.nextSetBit(0);
            while (n2 >= 0) {
                object = this.atoms[n2];
                if (((Atom)object).bonds != null) {
                    int n5 = ((Atom)object).bonds.length;
                    while (--n5 >= 0) {
                        if (!bS2.get(((Atom)object).getBondedAtomIndex(n5))) continue;
                        bS3.set(((Atom)object).bonds[n5].index);
                    }
                }
                n2 = bS.nextSetBit(n2 + 1);
            }
        }
        n2 = bS3.nextSetBit(0);
        while (n2 < this.bondCount && n2 >= 0) {
            object = this.bonds[n2];
            Atom atom = ((Bond)object).atom1;
            Atom atom2 = ((Bond)object).atom2;
            float f7 = atom.distanceSquared(atom2);
            if (bl3 || bl4) {
                f5 = atom.distance(atom2);
                f6 = atom.getBondingRadiusFloat() + atom2.getBondingRadiusFloat();
            }
            if (!(!bl3 ? f7 < f3 : f5 < f6 * f) && !(!bl4 ? f7 > f4 : f5 > f6 * f2)) {
                if (bl2 || n4 == (((Bond)object).order & 0xFFFFFEFF | 0x20000) || (n & ((Bond)object).order & 0x7800) != 0) {
                    bS4.set(n2);
                    ++n3;
                }
            }
            n2 = bS3.nextSetBit(n2 + 1);
        }
        if (n3 > 0) {
            this.dBm(bS4, false);
        }
        return new int[]{0, n3};
    }

    protected void dBm(BS bS, boolean bl) {
        ((ModelCollection)this).deleteBonds(bS, bl);
    }

    protected void dBb(BS bS, boolean bl) {
        int n;
        int n2 = bS.nextSetBit(0);
        if (n2 < 0) {
            return;
        }
        this.resetMolecules();
        short s = -1;
        int n3 = bS.cardinality();
        for (n = n2; n < this.bondCount; ++n) {
            Bond bond = this.bonds[n];
            if (n3 > 0 && bS.get(n)) {
                short s2;
                --n3;
                if (!bl && (s2 = bond.atom1.modelIndex) != s) {
                    s = s2;
                    ((ModelCollection)this).models[s].resetBoundCount();
                }
                bond.deleteAtomReferences();
                continue;
            }
            this.setBond(n2++, bond);
        }
        n = this.bondCount;
        while (--n >= n2) {
            this.bonds[n] = null;
        }
        this.bondCount = n2;
        BS[] bSArray = (BS[])this.viewer.getShapeProperty(1, "sets");
        if (bSArray != null) {
            for (int i = 0; i < bSArray.length; ++i) {
                BSUtil.deleteBits(bSArray[i], bS);
            }
        }
        BSUtil.deleteBits(this.bsAromatic, bS);
    }

    public void resetAromatic() {
        int n = this.bondCount;
        while (--n >= 0) {
            Bond bond = this.bonds[n];
            if (!bond.isAromatic()) continue;
            bond.setOrder(515);
        }
    }

    public void assignAromaticBonds() {
        this.assignAromaticBondsBs(true, null);
    }

    protected void assignAromaticBondsBs(boolean bl, BS bS) {
        int n;
        if (!bl) {
            this.bsAromatic = new BS();
        }
        this.bsAromaticSingle = new BS();
        this.bsAromaticDouble = new BS();
        boolean bl2 = bS == null;
        int n2 = n = bl2 ? this.bondCount - 1 : bS.nextSetBit(0);
        while (n2 >= 0) {
            Bond bond = this.bonds[n2];
            if (this.bsAromatic.get(n2)) {
                bond.setOrder(515);
            }
            switch (bond.order & 0xFFFDFFFF) {
                case 515: {
                    this.bsAromatic.set(n2);
                    break;
                }
                case 513: {
                    this.bsAromaticSingle.set(n2);
                    break;
                }
                case 514: {
                    this.bsAromaticDouble.set(n2);
                }
            }
            n2 = bl2 ? n2 - 1 : bS.nextSetBit(n2 + 1);
        }
        bl2 = bS == null;
        int n3 = n = bl2 ? this.bondCount - 1 : bS.nextSetBit(0);
        while (n3 >= 0) {
            Bond bond = this.bonds[n3];
            if (bond.is(515) && !this.bsAromaticDouble.get(n3) && !this.bsAromaticSingle.get(n3) && !this.assignAromaticDouble(bond)) {
                this.assignAromaticSingle(bond);
            }
            n3 = bl2 ? n3 - 1 : bS.nextSetBit(n3 + 1);
        }
        n3 = n;
        while (n3 >= 0) {
            Bond bond = this.bonds[n3];
            if (this.bsAromaticDouble.get(n3)) {
                if (!bond.is(514)) {
                    this.bsAromatic.set(n3);
                    bond.setOrder(514);
                }
            } else if ((this.bsAromaticSingle.get(n3) || bond.isAromatic()) && !bond.is(513)) {
                this.bsAromatic.set(n3);
                bond.setOrder(513);
            }
            n3 = bl2 ? n3 - 1 : bS.nextSetBit(n3 + 1);
        }
        this.assignAromaticNandO(bS);
        this.bsAromaticSingle = null;
        this.bsAromaticDouble = null;
    }

    private boolean assignAromaticDouble(Bond bond) {
        int n = bond.index;
        if (this.bsAromaticSingle.get(n)) {
            return false;
        }
        if (this.bsAromaticDouble.get(n)) {
            return true;
        }
        this.bsAromaticDouble.set(n);
        if (!this.assignAromaticSingleForAtom(bond.atom1, n) || !this.assignAromaticSingleForAtom(bond.atom2, n)) {
            this.bsAromaticDouble.clear(n);
            return false;
        }
        return true;
    }

    private boolean assignAromaticSingle(Bond bond) {
        int n = bond.index;
        if (this.bsAromaticDouble.get(n)) {
            return false;
        }
        if (this.bsAromaticSingle.get(n)) {
            return true;
        }
        this.bsAromaticSingle.set(n);
        if (!this.assignAromaticDoubleForAtom(bond.atom1) || !this.assignAromaticDoubleForAtom(bond.atom2)) {
            this.bsAromaticSingle.clear(n);
            return false;
        }
        return true;
    }

    private boolean assignAromaticSingleForAtom(Atom atom, int n) {
        Bond[] bondArray = atom.bonds;
        if (bondArray == null || this.assignAromaticSingleHetero(atom)) {
            return false;
        }
        int n2 = bondArray.length;
        while (--n2 >= 0) {
            Bond bond = bondArray[n2];
            int n3 = bond.index;
            if (n3 == n || !bond.isAromatic() || this.bsAromaticSingle.get(n3) || !this.bsAromaticDouble.get(n3) && this.assignAromaticSingle(bond)) continue;
            return false;
        }
        return true;
    }

    private boolean assignAromaticDoubleForAtom(Atom atom) {
        Bond[] bondArray = atom.bonds;
        if (bondArray == null) {
            return false;
        }
        boolean bl = this.assignAromaticSingleHetero(atom);
        int n = -1;
        int n2 = bondArray.length;
        while (--n2 >= 0) {
            if (this.bsAromaticDouble.get(bondArray[n2].index)) {
                bl = true;
            }
            if (!bondArray[n2].isAromatic()) continue;
            n = n2;
        }
        n2 = bondArray.length;
        while (--n2 >= 0) {
            Bond bond = bondArray[n2];
            int n3 = bond.index;
            if (!bond.isAromatic() || this.bsAromaticDouble.get(n3) || this.bsAromaticSingle.get(n3)) continue;
            if (!bl && this.assignAromaticDouble(bond)) {
                bl = true;
                continue;
            }
            if (!bl && n2 >= n || this.assignAromaticSingle(bond)) continue;
            return false;
        }
        return bl;
    }

    private boolean assignAromaticSingleHetero(Atom atom) {
        int n = atom.getElementNumber();
        switch (n) {
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                break;
            }
            default: {
                return true;
            }
        }
        int n2 = atom.getValence();
        switch (n) {
            case 6: {
                return n2 == 4;
            }
            case 7: 
            case 8: {
                return n2 == 10 - n && atom.getFormalCharge() < 1;
            }
            case 16: {
                return n2 == 18 - n && atom.getFormalCharge() < 1;
            }
        }
        return false;
    }

    private void assignAromaticNandO(BS bS) {
        int n;
        boolean bl = bS == null;
        int n2 = n = bl ? this.bondCount - 1 : bS.nextSetBit(0);
        while (n2 >= 0) {
            Bond bond = this.bonds[n2];
            if (bond.is(513)) {
                int n3;
                Atom atom;
                int n4;
                Atom atom2 = bond.atom2;
                int n5 = atom2.getElementNumber();
                if (n5 == 7 || n5 == 8) {
                    n4 = n5;
                    atom = atom2;
                    atom2 = bond.atom1;
                    n5 = atom2.getElementNumber();
                } else {
                    atom = bond.atom1;
                    n4 = atom.getElementNumber();
                }
                if ((n4 == 7 || n4 == 8) && (n3 = atom.getValence()) >= 0) {
                    int n6 = atom.getCovalentBondCount();
                    int n7 = atom.getFormalCharge();
                    switch (n4) {
                        case 7: {
                            if (n3 != 3 || n6 != 3 || n7 >= 1 || n5 != 6 || atom2.getValence() != 3) break;
                            bond.setOrder(514);
                            break;
                        }
                        case 8: {
                            if (n3 != 1 || n7 != 0 || n5 != 14 && n5 != 16) break;
                            bond.setOrder(514);
                        }
                    }
                }
            }
            n2 = bl ? n2 - 1 : bS.nextSetBit(n2 + 1);
        }
    }

    protected BS getAtomBitsMDb(int n, Object object) {
        switch (n) {
            default: {
                return this.getAtomBitsMDa(n, object);
            }
            case 1678770178: {
                BS bS = new BS();
                BS bS2 = (BS)object;
                int n2 = bS2.nextSetBit(0);
                while (n2 >= 0) {
                    bS.set(this.bonds[n2].atom1.index);
                    bS.set(this.bonds[n2].atom2.index);
                    n2 = bS2.nextSetBit(n2 + 1);
                }
                return bS;
            }
            case 0x100009: 
        }
        BS bS = new BS();
        int n3 = this.bondCount;
        while (--n3 >= 0) {
            if (!this.bonds[n3].isAromatic()) continue;
            bS.set(this.bonds[n3].atom1.index);
            bS.set(this.bonds[n3].atom2.index);
        }
        return bS;
    }

    public BS setBondOrder(int n, char c) {
        int n2 = c - 48;
        Bond bond = this.bonds[n];
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': {
                break;
            }
            case 'm': 
            case 'p': {
                n2 = JmolEdge.getBondOrderNumberFromOrder(bond.getCovalentOrder()).charAt(0) - 48 + (c == 'p' ? 1 : -1);
                if (n2 > 3) {
                    n2 = 1;
                    break;
                }
                if (n2 >= 0) break;
                n2 = 3;
                break;
            }
            default: {
                return null;
            }
        }
        BS bS = new BS();
        try {
            if (n2 == 0) {
                BS bS2 = new BS();
                bS2.set(bond.index);
                bS.set(bond.getAtomIndex1());
                bS.set(bond.getAtomIndex2());
                this.dBm(bS2, false);
                return bS;
            }
            bond.setOrder(n2 | 0x20000);
            this.removeUnnecessaryBonds(bond.atom1, false);
            this.removeUnnecessaryBonds(bond.atom2, false);
            bS.set(bond.getAtomIndex1());
            bS.set(bond.getAtomIndex2());
        }
        catch (Exception exception) {
            Logger.error("Exception in seBondOrder: " + exception.toString());
        }
        return bS;
    }

    protected void removeUnnecessaryBonds(Atom atom, boolean bl) {
        BS bS = new BS();
        BS bS2 = new BS();
        Bond[] bondArray = atom.bonds;
        if (bondArray == null) {
            return;
        }
        for (int i = 0; i < bondArray.length; ++i) {
            if (bondArray[i].isCovalent()) {
                Atom atom2 = bondArray[i].getOtherAtom(atom);
                if (atom2.getElementNumber() != 1) continue;
                bS.set(bondArray[i].getOtherAtom((Atom)atom).index);
                continue;
            }
            bS2.set(bondArray[i].index);
        }
        if (bS2.nextSetBit(0) >= 0) {
            this.dBm(bS2, false);
        }
        if (bl) {
            bS.set(atom.index);
        }
        if (bS.nextSetBit(0) >= 0) {
            this.viewer.deleteAtoms(bS, false);
        }
    }

    public void displayBonds(BondSet bondSet, boolean bl) {
        if (!bl) {
            this.haveHiddenBonds = true;
        }
        int n = bondSet.nextSetBit(0);
        while (n >= 0) {
            if (n < this.bondCount && this.bonds[n].mad != 0) {
                this.bonds[n].setShapeVisibility(bl);
            }
            n = bondSet.nextSetBit(n + 1);
        }
    }

    public void setBondParametersBS(int n, int n2, BS bS, float f, float f2, int n3, float f3) {
        if (bS == null) {
            this.setBondParameters(n, n2, f, f2, n3, f3);
        } else {
            int n4 = bS.nextSetBit(0);
            while (n4 >= 0) {
                this.setBondParameters(n, n4, f, f2, n3, f3);
                n4 = bS.nextSetBit(n4 + 1);
            }
        }
    }

    public void setBondParameters(int n, int n2, float f, float f2, int n3, float f3) {
        if (n2 < 0 || n2 >= this.bondCount) {
            return;
        }
        Bond bond = this.bonds[n2];
        if (n >= 0 && bond.atom1.modelIndex != n) {
            return;
        }
        if (!Float.isNaN(f)) {
            bond.mad = (short)(f * 2000.0f);
        }
        short s = bond.colix;
        if (n3 != Integer.MAX_VALUE) {
            s = C.getColix(n3);
        }
        if (!Float.isNaN(f3)) {
            bond.colix = C.getColixTranslucent3(s, f3 != 0.0f, f3);
        } else if (bond.colix != s) {
            bond.colix = C.copyColixTranslucency(bond.colix, s);
        }
        if (f2 == 1.0f) {
            bond.order &= 0xFFFEFFFF;
        } else if (f2 == 0.0f) {
            bond.order |= 0x10000;
        }
    }
}

