/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javajs.util.AU;
import javajs.util.List;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.SB;
import org.jmol.api.DSSPInterface;
import org.jmol.api.Interface;
import org.jmol.constant.EnumStructure;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomCollection;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.HBond;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.Resolver;
import org.jmol.util.BSUtil;
import org.jmol.util.Escape;
import org.jmol.util.Txt;
import org.jmol.viewer.Viewer;

public final class BioModel
extends Model {
    private int bioPolymerCount = 0;
    private BioPolymer[] bioPolymers;
    private static final String[] pdbRecords = new String[]{"ATOM  ", "MODEL ", "HETATM"};

    BioModel(ModelSet modelSet, int n, int n2, String string, Properties properties, Map<String, Object> map) {
        super(modelSet, n, n2, string, properties, map);
        this.isBioModel = true;
        this.clearBioPolymers();
    }

    @Override
    public void freeze() {
        this.freezeM();
        this.bioPolymers = (BioPolymer[])AU.arrayCopyObject(this.bioPolymers, this.bioPolymerCount);
    }

    public void addSecondaryStructure(EnumStructure enumStructure, String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, BS bS) {
        int n9 = this.bioPolymerCount;
        while (--n9 >= 0) {
            if (!(this.bioPolymers[n9] instanceof AlphaPolymer)) continue;
            ((AlphaPolymer)this.bioPolymers[n9]).addStructure(enumStructure, string, n, n2, n3, n4, n5, n6, n7, n8, bS);
        }
    }

    @Override
    public String calculateStructures(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        int n;
        if (this.bioPolymerCount == 0 || !bl4 && !bl) {
            return "";
        }
        this.structureTainted = true;
        this.modelSet.proteinStructureTainted = true;
        if (bl4) {
            n = this.bioPolymerCount;
            while (--n >= 0) {
                if (bl && this.bioPolymers[n].getGroups()[0].getNitrogenAtom() == null) continue;
                this.bioPolymers[n].clearStructures();
            }
        }
        if (!bl || bl5) {
            n = this.bioPolymerCount;
            while (--n >= 0) {
                if (!(this.bioPolymers[n] instanceof AlphaPolymer)) continue;
                ((AlphaPolymer)this.bioPolymers[n]).calculateStructures(bl5);
            }
        }
        return bl ? this.calculateDssp(null, bl2, bl3, bl4) : "";
    }

    private String calculateDssp(List<Bond> list, boolean bl, boolean bl2, boolean bl3) {
        return ((DSSPInterface)Interface.getOptionInterface("dssx.DSSP")).calculateDssp(this.bioPolymers, this.bioPolymerCount, list, bl, bl2, bl3);
    }

    @Override
    public void setConformation(BS bS) {
        if (this.nAltLocs > 0) {
            int n = this.bioPolymerCount;
            while (--n >= 0) {
                this.bioPolymers[n].setConformation(bS);
            }
        }
    }

    @Override
    public boolean getPdbConformation(BS bS, int n) {
        if (this.nAltLocs > 0) {
            int n2 = this.bioPolymerCount;
            while (--n2 >= 0) {
                this.bioPolymers[n2].getConformation(bS, n);
            }
        }
        return true;
    }

    @Override
    public int getBioPolymerCount() {
        return this.bioPolymerCount;
    }

    @Override
    public void calcSelectedMonomersCount(BS bS) {
        int n = this.bioPolymerCount;
        while (--n >= 0) {
            this.bioPolymers[n].calcSelectedMonomersCount(bS);
        }
    }

    public BioPolymer getBioPolymer(int n) {
        return this.bioPolymers[n];
    }

    @Override
    public void getDefaultLargePDBRendering(SB sB, int n) {
        BS bS = new BS();
        if (this.getBondCount() == 0) {
            bS = this.bsAtoms;
        }
        if (bS != this.bsAtoms) {
            for (int i = 0; i < this.bioPolymerCount; ++i) {
                this.bioPolymers[i].getRange(bS);
            }
        }
        if (bS.nextSetBit(0) < 0) {
            return;
        }
        BS bS2 = new BS();
        if (bS == this.bsAtoms) {
            bS2 = bS;
        } else {
            for (int i = 0; i < this.bioPolymerCount; ++i) {
                if (this.bioPolymers[i].getType() != 0) continue;
                this.bioPolymers[i].getRange(bS2);
            }
        }
        if (bS2.nextSetBit(0) >= 0) {
            sB.append("select ").append(Escape.eBS(bS2)).append(";backbone only;");
        }
        if (this.atomCount <= n) {
            return;
        }
        sB.append("select ").append(Escape.eBS(bS)).append(" & connected; wireframe only;");
        if (bS != this.bsAtoms) {
            bS2.clearAll();
            bS2.or(this.bsAtoms);
            bS2.andNot(bS);
            if (bS2.nextSetBit(0) >= 0) {
                sB.append("select " + Escape.eBS(bS2) + " & !connected;stars 0.5;");
            }
        }
    }

    @Override
    public void fixIndices(int n, int n2, BS bS) {
        this.fixIndicesM(n, n2, bS);
        for (int i = 0; i < this.bioPolymerCount; ++i) {
            this.bioPolymers[i].recalculateLeadMidpointsAndWingVectors();
        }
    }

    @Override
    public int calculateStruts(ModelSet modelSet, BS bS, BS bS2) {
        BS bS3;
        List<Atom> list = new List<Atom>();
        Atom atom = null;
        if (bS.equals(bS2)) {
            bS3 = bS;
        } else {
            bS3 = BSUtil.copy(bS);
            bS3.or(bS2);
        }
        Atom[] atomArray = modelSet.atoms;
        Viewer viewer = modelSet.viewer;
        bS3.and(viewer.getModelUndeletedAtomsBitSet(this.modelIndex));
        int n = bS3.nextSetBit(0);
        while (n >= 0) {
            if (atomArray[n].isVisible(0) && atomArray[n].atomID == 2 && atomArray[n].getGroupID() != 5) {
                atom = atomArray[n];
                list.addLast(atom);
            }
            n = bS3.nextSetBit(n + 1);
        }
        if (list.size() == 0) {
            return 0;
        }
        float f = viewer.getFloat(0x22000040);
        short s = (short)(viewer.getFloat(570425406) * 2000.0f);
        int n2 = viewer.getInt(553648184);
        boolean bl = viewer.getBoolean(603979955);
        List<Atom[]> list2 = this.getBioPolymer(atom.getPolymerIndexInModel()).calculateStruts(modelSet, bS, bS2, list, f, n2, bl);
        for (int i = 0; i < list2.size(); ++i) {
            Atom[] atomArray2 = (Atom[])list2.get(i);
            modelSet.bondAtoms(atomArray2[0], atomArray2[1], 32768, s, null, 0.0f, false, true);
        }
        return list2.size();
    }

    @Override
    public void setStructureList(Map<EnumStructure, float[]> map) {
        this.bioPolymers = (BioPolymer[])AU.arrayCopyObject(this.bioPolymers, this.bioPolymerCount);
        int n = this.bioPolymerCount;
        while (--n >= 0) {
            this.bioPolymers[n].setStructureList(map);
        }
    }

    @Override
    public void calculateStraightness(Viewer viewer, char c, char c2, int n) {
        for (int i = 0; i < this.bioPolymerCount; ++i) {
            this.bioPolymers[i].getPdbData(viewer, c, c2, n, 2, null, null, false, false, false, null, null, null, new BS());
        }
    }

    @Override
    public void getPolymerPointsAndVectors(BS bS, List<P3[]> list, boolean bl, float f) {
        int n = 0x7FFFFFFE;
        for (int i = 0; i < this.bioPolymerCount; ++i) {
            n = this.bioPolymers[i].getPolymerPointsAndVectors(n, bS, list, bl, f);
        }
    }

    @Override
    public P3[] getPolymerLeadMidPoints(int n) {
        return this.bioPolymers[n].getLeadMidpoints();
    }

    @Override
    public void recalculateLeadMidpointsAndWingVectors() {
        for (int i = 0; i < this.bioPolymerCount; ++i) {
            this.bioPolymers[i].recalculateLeadMidpointsAndWingVectors();
        }
    }

    @Override
    public List<BS> getBioBranches(List<BS> list) {
        for (int i = 0; i < this.bioPolymerCount; ++i) {
            BS bS = new BS();
            this.bioPolymers[i].getRange(bS);
            int n = bS.nextSetBit(0);
            if (n < 0) continue;
            if (list == null) {
                list = new List();
            }
            list.addLast(bS);
        }
        return list;
    }

    @Override
    public void getGroupsWithin(int n, BS bS, BS bS2) {
        int n2 = this.bioPolymerCount;
        while (--n2 >= 0) {
            this.bioPolymers[n2].getRangeGroups(n, bS, bS2);
        }
    }

    @Override
    public void getSequenceBits(String string, BS bS, BS bS2) {
        int n = string.length();
        block0: for (int i = 0; i < this.bioPolymerCount; ++i) {
            String string2 = this.bioPolymers[i].getSequence();
            int n2 = -1;
            while (true) {
                ++n2;
                if ((n2 = string2.indexOf(string, n2)) < 0) continue block0;
                this.bioPolymers[i].getPolymerSequenceAtoms(n2, n, bS, bS2);
            }
        }
    }

    @Override
    public void selectSeqcodeRange(int n, int n2, int n3, BS bS, boolean bl) {
        int n4 = this.chainCount;
        while (--n4 >= 0) {
            int n5;
            Chain chain = this.chains[n4];
            if (n3 != -1 && n3 != (n5 = chain.chainID) && (bl || n5 >= 256 || n3 != AtomCollection.chainToUpper(n5))) continue;
            int n6 = 0;
            while (n6 >= 0) {
                n6 = this.chains[n4].selectSeqcodeRange(n6, n, n2, bS);
            }
        }
    }

    @Override
    public void getRasmolHydrogenBonds(BS bS, BS bS2, List<Bond> list, boolean bl, int n, boolean bl2, BS bS3) {
        int n2;
        int n3;
        boolean bl3;
        boolean bl4;
        boolean bl5 = bl4 = list == null;
        if (bl4) {
            list = new List();
        }
        if (n < 0) {
            n = Integer.MAX_VALUE;
        }
        boolean bl6 = bl3 = bS2 == null;
        if (bl3 && this.bioPolymerCount > 0) {
            this.calculateDssp(list, false, bl2, false);
        } else {
            n3 = this.bioPolymerCount;
            while (--n3 >= 0) {
                boolean bl7;
                BioPolymer bioPolymer = this.bioPolymers[n3];
                int n4 = bioPolymer.getType();
                if ((bl || n4 != 1) && n4 != 2) continue;
                boolean bl8 = bioPolymer.isRna();
                boolean bl9 = bl7 = n4 == 1;
                if (bl7) {
                    bioPolymer.calcRasmolHydrogenBonds(null, bS, bS2, list, n, null, true, false);
                }
                n2 = this.bioPolymerCount;
                while (--n2 >= 0) {
                    BioPolymer bioPolymer2 = this.bioPolymers[n2];
                    if (bioPolymer2 == null || !bl8 && n3 == n2 || n4 != bioPolymer2.getType()) continue;
                    bioPolymer2.calcRasmolHydrogenBonds(bioPolymer, bS, bS2, list, n, null, true, false);
                }
            }
        }
        if (list.size() == 0 || !bl4) {
            return;
        }
        this.hasRasmolHBonds = true;
        for (n3 = 0; n3 < list.size(); ++n3) {
            Atom atom;
            HBond hBond = (HBond)list.get(n3);
            Atom atom2 = hBond.getAtom1();
            if (atom2.isBonded(atom = hBond.getAtom2())) continue;
            n2 = this.modelSet.addHBond(atom2, atom, hBond.order, hBond.getEnergy());
            if (bS3 == null) continue;
            bS3.set(n2);
        }
    }

    @Override
    public void clearRasmolHydrogenBonds(BS bS) {
        BS bS2 = new BS();
        this.hasRasmolHBonds = false;
        Model[] modelArray = this.modelSet.models;
        Bond[] bondArray = this.modelSet.bonds;
        int n = this.modelSet.bondCount;
        while (--n >= 0) {
            Bond bond = bondArray[n];
            Atom atom = bond.getAtom1();
            Model model = modelArray[atom.modelIndex];
            if (!model.isBioModel || model.trajectoryBaseIndex != this.modelIndex || (bond.order & 0x7000) == 0) continue;
            if (bS != null && !bS.get(atom.index)) {
                this.hasRasmolHBonds = true;
                continue;
            }
            bS2.set(n);
        }
        if (bS2.nextSetBit(0) >= 0) {
            this.modelSet.deleteBonds(bS2, false);
        }
    }

    @Override
    public void calculatePolymers(Group[] groupArray, int n, int n2, BS bS, boolean bl) {
        Object object;
        Group group;
        int n3;
        if (groupArray == null) {
            groupArray = this.modelSet.getGroups();
            n = groupArray.length;
        }
        if (bS != null) {
            for (n3 = 0; n3 < n; ++n3) {
                group = groupArray[n3];
                if (!(group instanceof Monomer) || ((Monomer)(object = (Monomer)group)).getBioPolymer() == null || bS.get(((Group)object).getModelIndex())) continue;
                ((Monomer)object).setBioPolymer(null, -1);
            }
        }
        for (n3 = n2; n3 < n; ++n3) {
            BioPolymer bioPolymer;
            group = groupArray[n3];
            object = group.getModel();
            if (!((Model)object).isBioModel || !(group instanceof Monomer)) continue;
            boolean bl2 = bl && !this.modelSet.isJmolDataFrameForModel(this.modelSet.atoms[group.firstAtomIndex].modelIndex);
            BioPolymer bioPolymer2 = bioPolymer = ((Monomer)group).getBioPolymer() == null ? Resolver.allocateBioPolymer(groupArray, n3, bl2) : null;
            if (bioPolymer == null || bioPolymer.monomerCount == 0) continue;
            ((BioModel)object).addBioPolymer(bioPolymer);
            n3 += bioPolymer.monomerCount - 1;
        }
    }

    private void addBioPolymer(BioPolymer bioPolymer) {
        if (this.bioPolymers.length == 0) {
            this.clearBioPolymers();
        }
        if (this.bioPolymerCount == this.bioPolymers.length) {
            this.bioPolymers = (BioPolymer[])AU.doubleLength(this.bioPolymers);
        }
        bioPolymer.bioPolymerIndexInModel = this.bioPolymerCount;
        this.bioPolymers[this.bioPolymerCount++] = bioPolymer;
    }

    @Override
    public void clearBioPolymers() {
        this.bioPolymers = new BioPolymer[8];
        this.bioPolymerCount = 0;
    }

    @Override
    public void getAllPolymerInfo(BS bS, Map<String, List<Map<String, Object>>> map, List<Map<String, Object>> list) {
        Hashtable<String, Serializable> hashtable = new Hashtable<String, Serializable>();
        List<Map<String, Object>> list2 = new List<Map<String, Object>>();
        for (int i = 0; i < this.bioPolymerCount; ++i) {
            Map<String, Object> map2 = this.bioPolymers[i].getPolymerInfo(bS);
            if (map2.isEmpty()) continue;
            list2.addLast(map2);
        }
        if (list2.size() > 0) {
            hashtable.put("modelIndex", Integer.valueOf(this.modelIndex));
            hashtable.put("polymers", list2);
            list.addLast((Map<String, Object>)hashtable);
        }
    }

    @Override
    public void getChimeInfo(SB sB, int n) {
        int n2 = 0;
        Model[] modelArray = this.modelSet.models;
        int n3 = this.modelSet.modelCount;
        int n4 = this.modelSet.getAtomCount();
        Atom[] atomArray = this.modelSet.atoms;
        sB.append("\nMolecule name ....... " + this.modelSet.getModelSetAuxiliaryInfoValue("COMPND"));
        sB.append("\nSecondary Structure . PDB Data Records");
        sB.append("\nBrookhaven Code ..... " + this.modelSet.modelSetName);
        int n5 = n3;
        while (--n5 >= 0) {
            n2 += modelArray[n5].getChainCount(false);
        }
        sB.append("\nNumber of Chains .... " + n2);
        n2 = 0;
        n5 = n3;
        while (--n5 >= 0) {
            n2 += modelArray[n5].getGroupCountHetero(false);
        }
        n = 0;
        n5 = n3;
        while (--n5 >= 0) {
            n += modelArray[n5].getGroupCountHetero(true);
        }
        sB.append("\nNumber of Groups .... " + n2);
        if (n > 0) {
            sB.append(" (" + n + ")");
        }
        n5 = n4;
        while (--n5 >= 0) {
            if (!atomArray[n5].isHetero()) continue;
            ++n;
        }
        this.getChimeInfoM(sB, n);
        n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = -1;
        block9: for (int i = 0; i < n4 && atomArray[i].modelIndex == 0; ++i) {
            int n9 = atomArray[i].getStrucNo();
            if (n9 == n8 || n9 == 0) continue;
            n8 = n9;
            switch (atomArray[i].getProteinStructureType()) {
                case HELIX: {
                    ++n5;
                    continue block9;
                }
                case SHEET: {
                    ++n6;
                    continue block9;
                }
                case TURN: {
                    ++n7;
                }
            }
        }
        sB.append("\nNumber of Helices ... " + n5);
        sB.append("\nNumber of Strands ... " + n6);
        sB.append("\nNumber of Turns ..... " + n7);
    }

    @Override
    public String getProteinStructureState(BS bS, boolean bl, boolean bl2, int n) {
        int n2;
        boolean bl3 = n == 3;
        boolean bl4 = n == 1;
        boolean bl5 = n == 0;
        BS bS2 = null;
        SB sB = new SB();
        SB sB2 = new SB();
        SB sB3 = new SB();
        SB sB4 = new SB();
        EnumStructure enumStructure = EnumStructure.NONE;
        EnumStructure enumStructure2 = EnumStructure.NONE;
        int n3 = 0;
        int n4 = 0;
        short s = -1;
        int n5 = -1;
        int n6 = 0;
        int n7 = 0;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        BS bS3 = null;
        Model[] modelArray = this.modelSet.models;
        Atom[] atomArray = this.modelSet.atoms;
        int n12 = this.modelSet.getAtomCount();
        if (bl) {
            if (!this.modelSet.proteinStructureTainted) {
                return "";
            }
            bS3 = new BS();
            for (n2 = this.firstAtomIndex; n2 < n12; ++n2) {
                if (!modelArray[atomArray[n2].modelIndex].isStructureTainted()) continue;
                bS3.set(n2);
            }
            bS3.set(n12);
        }
        for (n2 = 0; n2 <= n12; ++n2) {
            if (n2 != n12 && bS != null && !bS.get(n2) || bl && !bS3.get(n2)) continue;
            n3 = 0;
            if (n2 == n12 || (n3 = atomArray[n2].getStrucNo()) != n5) {
                if (bS2 != null) {
                    switch (enumStructure) {
                        case HELIX: 
                        case SHEET: 
                        case TURN: {
                            String string6;
                            Object object;
                            ++n8;
                            if (bl5) {
                                short s2 = atomArray[n4].modelIndex;
                                String string7 = "    \t# model=" + this.modelSet.getModelNumberDotted(s2);
                                if (s != s2) {
                                    s = s2;
                                    sB.append("  structure none ").append(Escape.eBS(this.modelSet.getModelAtomBitSetIncludingDeleted(s2, false))).append(string7).append(";\n");
                                }
                                string7 = string7 + " & (" + n6 + " - " + n7 + ")";
                                object = enumStructure2.getBioStructureTypeName(false);
                                sB.append("  structure ").append((String)object).append(" ").append(Escape.eBS(bS2)).append(string7).append(";\n");
                                break;
                            }
                            switch (enumStructure) {
                                case HELIX: {
                                    int n13 = ++n9;
                                    if (string == null || bl4) {
                                        string = Txt.formatStringI("%3N %3N", "N", n13);
                                    }
                                    string6 = "HELIX  %ID %3GROUPA %1CA %4RESA  %3GROUPB %1CB %4RESB";
                                    object = sB3;
                                    String string8 = null;
                                    switch (enumStructure2) {
                                        case HELIX: 
                                        case HELIXALPHA: {
                                            string8 = "  1";
                                            break;
                                        }
                                        case HELIX310: {
                                            string8 = "  5";
                                            break;
                                        }
                                        case HELIXPI: {
                                            string8 = "  3";
                                        }
                                    }
                                    if (string8 == null) break;
                                    string6 = string6 + string8;
                                    break;
                                }
                                case SHEET: {
                                    int n13 = ++n11;
                                    if (string == null || bl4) {
                                        string = Txt.formatStringI("%3N %3A 0", "N", n13);
                                        string = Txt.formatStringS(string, "A", "S" + n13);
                                    }
                                    string6 = "SHEET  %ID %3GROUPA %1CA%4RESA  %3GROUPB %1CB%4RESB";
                                    object = sB4;
                                    break;
                                }
                                default: {
                                    int n13 = ++n10;
                                    if (string == null || bl4) {
                                        string = Txt.formatStringI("%3N %3N", "N", n13);
                                    }
                                    string6 = "TURN   %ID %3GROUPA %1CA%4RESA  %3GROUPB %1CB%4RESB";
                                    object = sB2;
                                }
                            }
                            string6 = Txt.formatStringS(string6, "ID", string);
                            string6 = Txt.formatStringS(string6, "GROUPA", string2);
                            string6 = Txt.formatStringS(string6, "CA", string4);
                            string6 = Txt.formatStringI(string6, "RESA", n6);
                            string6 = Txt.formatStringS(string6, "GROUPB", string3);
                            string6 = Txt.formatStringS(string6, "CB", string5);
                            string6 = Txt.formatStringI(string6, "RESB", n7);
                            ((SB)object).append(string6);
                            if (bl3) {
                                ((SB)object).append(" strucno= ").appendI(n5);
                            }
                            ((SB)object).append("\n");
                        }
                    }
                    bS2 = null;
                }
                if (n3 == 0 || bS != null && bl2 && (Float.isNaN(atomArray[n2].getGroupParameter(1112539145)) || Float.isNaN(atomArray[n2].getGroupParameter(1112539146)))) continue;
            }
            String string9 = atomArray[n2].getChainIDStr();
            if (bS2 == null) {
                bS2 = new BS();
                n6 = atomArray[n2].getResno();
                string2 = atomArray[n2].getGroup3(false);
                string4 = string9;
            }
            enumStructure = atomArray[n2].getProteinStructureType();
            enumStructure2 = atomArray[n2].getProteinStructureSubType();
            string = atomArray[n2].getProteinStructureTag();
            bS2.set(n2);
            n5 = n3;
            n7 = atomArray[n2].getResno();
            string3 = atomArray[n2].getGroup3(false);
            string5 = string9;
            n4 = n2;
        }
        if (n8 > 0) {
            sB.append("\n");
        }
        return bl5 ? sB.toString() : sB3.appendSB(sB4).appendSB(sB2).appendSB(sB).toString();
    }

    @Override
    public String getFullPDBHeader() {
        if (this.modelIndex < 0) {
            return "";
        }
        String string = (String)this.auxiliaryInfo.get("fileHeader");
        if (string != null) {
            return string;
        }
        string = this.modelSet.viewer.getCurrentFileAsString();
        int n = string.length();
        int n2 = pdbRecords.length;
        block4: while (--n2 >= 0) {
            String string2 = pdbRecords[n2];
            int n3 = string.startsWith(string2) ? 0 : string.indexOf("\n" + string2);
            switch (n3) {
                case -1: {
                    continue block4;
                }
                case 0: {
                    this.auxiliaryInfo.put("fileHeader", "");
                    return "";
                }
            }
            if (n3 >= n) continue;
            n = ++n3;
        }
        string = string.substring(0, n);
        this.auxiliaryInfo.put("fileHeader", string);
        return string;
    }

    @Override
    public void getPdbData(Viewer viewer, String string, char c, boolean bl, BS bS, OC oC, LabelToken[] labelTokenArray, SB sB, BS bS2) {
        int n;
        char c2;
        boolean bl2 = false;
        char c3 = c != 'R' ? (char)'r' : (c2 = string.length() > 13 && string.indexOf("ramachandran ") >= 0 ? (char)string.charAt(13) : (char)'R');
        if (c2 == 'r') {
            c2 = viewer.getQuaternionFrame();
        }
        int n2 = viewer.getInt(0x21000012);
        int n3 = string.indexOf("diff") < 0 ? 0 : (n = string.indexOf("2") < 0 ? 1 : 2);
        if (!bl) {
            oC.append("REMARK   6 Jmol PDB-encoded data: " + string + ";");
            if (c != 'R') {
                oC.append("  quaternionFrame = \"" + c2 + "\"");
                bl2 = true;
            }
            oC.append("\nREMARK   6 Jmol Version ").append(Viewer.getJmolVersion()).append("\n");
            if (c == 'R') {
                oC.append("REMARK   6 Jmol data min = {-180 -180 -180} max = {180 180 180} unScaledXyz = xyz * {1 1 1} + {0 0 0} plotScale = {100 100 100}\n");
            } else {
                oC.append("REMARK   6 Jmol data min = {-1 -1 -1} max = {1 1 1} unScaledXyz = xyz * {0.1 0.1 0.1} + {0 0 0} plotScale = {100 100 100}\n");
            }
        }
        for (int i = 0; i < this.bioPolymerCount; ++i) {
            this.bioPolymers[i].getPdbData(viewer, c, c2, n2, n, this.bsAtoms, bS, bl2, bl, i == 0, labelTokenArray, oC, sB, bS2);
        }
    }
}

