/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javajs.awt.Font;
import javajs.util.A4;
import javajs.util.CU;
import javajs.util.List;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.T4;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.api.JmolParallelProcessor;
import org.jmol.api.JmolScriptEvaluator;
import org.jmol.api.JmolScriptFunction;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.RadiusData;
import org.jmol.constant.EnumAnimationMode;
import org.jmol.constant.EnumPalette;
import org.jmol.constant.EnumStereoMode;
import org.jmol.constant.EnumStructure;
import org.jmol.constant.EnumVdw;
import org.jmol.i18n.GT;
import org.jmol.io.JmolBinary;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondSet;
import org.jmol.modelset.Group;
import org.jmol.modelset.ModelCollection;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.TickInfo;
import org.jmol.script.ContextToken;
import org.jmol.script.FileLoadThread;
import org.jmol.script.JmolScriptExtension;
import org.jmol.script.SV;
import org.jmol.script.ScriptCompiler;
import org.jmol.script.ScriptContext;
import org.jmol.script.ScriptDelayThread;
import org.jmol.script.ScriptException;
import org.jmol.script.ScriptFunction;
import org.jmol.script.ScriptInterruption;
import org.jmol.script.ScriptMathProcessor;
import org.jmol.script.T;
import org.jmol.thread.JmolThread;
import org.jmol.util.BSUtil;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.GData;
import org.jmol.util.JmolEdge;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.Parser;
import org.jmol.util.Quaternion;
import org.jmol.util.SimpleUnitCell;
import org.jmol.util.Txt;
import org.jmol.viewer.ActionManager;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.JC;
import org.jmol.viewer.ShapeManager;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Viewer;

public class ScriptEvaluator
implements JmolScriptEvaluator {
    public boolean allowJSThreads = true;
    private boolean listCommands;
    public boolean isJS;
    public boolean tQuiet;
    public boolean chk;
    private boolean isCmdLine_C_Option;
    protected boolean isCmdLine_c_or_C_Option;
    public boolean historyDisabled;
    public boolean logMessages;
    private boolean debugScript;
    private boolean executionStopped;
    private boolean executionPaused;
    private boolean executionStepping;
    private boolean executing;
    private long timeBeginExecution;
    private long timeEndExecution;
    private boolean mustResumeEval;
    private static final String EXPRESSION_KEY = "e_x_p_r_e_s_s_i_o_n";
    public ShapeManager sm;
    private static final int scriptLevelMax = 100;
    private Thread currentThread;
    public Viewer viewer;
    public ScriptCompiler compiler;
    public Map<String, Object> definedAtomSets;
    private SB outputBuffer;
    private String contextPath = "";
    public String scriptFileName;
    public String functionName;
    private boolean isStateScript;
    public int scriptLevel;
    private int scriptReportingLevel = 0;
    public int commandHistoryLevelMax = 0;
    public T[][] aatoken;
    private short[] lineNumbers;
    private int[][] lineIndices;
    public Map<String, SV> contextVariables;
    private String script;
    protected int pc;
    public String thisCommand;
    public String fullCommand;
    public T[] st;
    public int slen;
    public int iToken;
    private int lineEnd;
    private int pcEnd;
    private String scriptExtensions;
    private boolean forceNoAddHydrogens;
    private JmolParallelProcessor parallelProcessor;
    static int tryPt;
    public ScriptContext thisContext;
    private boolean error;
    private String errorMessage;
    protected String errorMessageUntranslated;
    protected String errorType;
    protected int iCommandError;
    private boolean ignoreError;
    static final int ERROR_axisExpected = 0;
    static final int ERROR_backgroundModelError = 1;
    public static final int ERROR_badArgumentCount = 2;
    static final int ERROR_badMillerIndices = 3;
    public static final int ERROR_badRGBColor = 4;
    static final int ERROR_booleanExpected = 5;
    static final int ERROR_booleanOrNumberExpected = 6;
    static final int ERROR_booleanOrWhateverExpected = 7;
    static final int ERROR_colorExpected = 8;
    static final int ERROR_colorOrPaletteRequired = 9;
    static final int ERROR_commandExpected = 10;
    static final int ERROR_coordinateOrNameOrExpressionRequired = 11;
    static final int ERROR_drawObjectNotDefined = 12;
    public static final int ERROR_endOfStatementUnexpected = 13;
    public static final int ERROR_expressionExpected = 14;
    public static final int ERROR_expressionOrIntegerExpected = 15;
    static final int ERROR_filenameExpected = 16;
    public static final int ERROR_fileNotFoundException = 17;
    public static final int ERROR_incompatibleArguments = 18;
    public static final int ERROR_insufficientArguments = 19;
    static final int ERROR_integerExpected = 20;
    static final int ERROR_integerOutOfRange = 21;
    public static final int ERROR_invalidArgument = 22;
    public static final int ERROR_invalidParameterOrder = 23;
    public static final int ERROR_keywordExpected = 24;
    public static final int ERROR_moCoefficients = 25;
    public static final int ERROR_moIndex = 26;
    public static final int ERROR_moModelError = 27;
    public static final int ERROR_moOccupancy = 28;
    public static final int ERROR_moOnlyOne = 29;
    public static final int ERROR_multipleModelsDisplayedNotOK = 30;
    public static final int ERROR_noData = 31;
    public static final int ERROR_noPartialCharges = 32;
    static final int ERROR_noUnitCell = 33;
    public static final int ERROR_numberExpected = 34;
    static final int ERROR_numberMustBe = 35;
    static final int ERROR_numberOutOfRange = 36;
    static final int ERROR_objectNameExpected = 37;
    static final int ERROR_planeExpected = 38;
    static final int ERROR_propertyNameExpected = 39;
    static final int ERROR_spaceGroupNotFound = 40;
    static final int ERROR_stringExpected = 41;
    static final int ERROR_stringOrIdentifierExpected = 42;
    static final int ERROR_tooManyPoints = 43;
    static final int ERROR_tooManyScriptLevels = 44;
    static final int ERROR_unrecognizedAtomProperty = 45;
    static final int ERROR_unrecognizedBondProperty = 46;
    static final int ERROR_unrecognizedCommand = 47;
    static final int ERROR_unrecognizedExpression = 48;
    static final int ERROR_unrecognizedObject = 49;
    static final int ERROR_unrecognizedParameter = 50;
    static final int ERROR_unrecognizedParameterWarning = 51;
    static final int ERROR_unrecognizedShowParameter = 52;
    public static final int ERROR_what = 53;
    public static final int ERROR_writeWhat = 54;
    static final int ERROR_multipleModelsNotOK = 55;
    static final int ERROR_cannotSet = 56;
    private T[] tempStatement;
    private boolean isBondSet;
    public Object expressionResult;
    public int theTok;
    public T theToken;
    private boolean coordinatesAreFractional;
    private P3 fractionalPoint;
    private JmolScriptExtension scriptExt;
    static int iProcess;
    public int[] colorArgb = new int[]{Integer.MIN_VALUE};
    private JmolThread scriptDelayThread;
    private JmolThread fileLoadThread;

    @Override
    public boolean getAllowJSThreads() {
        return this.allowJSThreads;
    }

    @Override
    public JmolScriptEvaluator setViewer(Viewer viewer) {
        this.viewer = viewer;
        this.compiler = this.compiler == null ? (ScriptCompiler)viewer.compiler : this.compiler;
        this.isJS = viewer.isSingleThreaded;
        this.definedAtomSets = viewer.definedAtomSets;
        return this;
    }

    public ScriptEvaluator() {
        this.currentThread = Thread.currentThread();
    }

    @Override
    public void setCompiler() {
        this.compiler = new ScriptCompiler(this.viewer);
        this.viewer.compiler = this.compiler;
    }

    @Override
    public boolean compileScriptString(String string, boolean bl) {
        this.clearState(bl);
        this.contextPath = "[script]";
        return this.compileScript(null, string, this.debugScript);
    }

    @Override
    public boolean compileScriptFile(String string, boolean bl) {
        this.clearState(bl);
        this.contextPath = string;
        return this.compileScriptFileInternal(string, null, null, null);
    }

    @Override
    public void evaluateCompiledScript(boolean bl, boolean bl2, boolean bl3, boolean bl4, SB sB, boolean bl5) {
        boolean bl6 = this.isCmdLine_C_Option;
        this.isCmdLine_C_Option = bl2;
        this.chk = this.isCmdLine_c_or_C_Option = bl;
        this.historyDisabled = bl3;
        this.outputBuffer = sB;
        this.currentThread = Thread.currentThread();
        this.allowJSThreads = bl5;
        this.listCommands = bl4;
        this.startEval();
        this.isCmdLine_C_Option = bl6;
        this.viewer.setStateScriptVersion(null);
    }

    public boolean useThreads() {
        return !this.viewer.autoExit && this.viewer.haveDisplay && this.outputBuffer == null && this.allowJSThreads;
    }

    private void startEval() {
        this.timeBeginExecution = System.currentTimeMillis();
        this.executionPaused = false;
        this.executionStopped = false;
        this.executionStepping = false;
        this.executing = true;
        this.viewer.pushHoldRepaintWhy("runEval");
        this.setScriptExtensions();
        this.executeCommands(false);
    }

    private void executeCommands(boolean bl) {
        boolean bl2 = false;
        try {
            if (!this.dispatchCommands(false, false)) {
                return;
            }
        }
        catch (Error error) {
            this.viewer.handleError(error, false);
            this.setErrorMessage("" + error + " " + this.viewer.getShapeErrorState());
            this.errorMessageUntranslated = "" + error;
            this.scriptStatusOrBuffer(this.errorMessage);
            bl2 = true;
        }
        catch (ScriptException scriptException) {
            if (scriptException instanceof ScriptInterruption) {
                return;
            }
            if (bl) {
                this.viewer.setStringProperty("_errormessage", "" + scriptException);
                return;
            }
            this.setErrorMessage(scriptException.toString());
            this.errorMessageUntranslated = scriptException.getErrorMessageUntranslated();
            this.scriptStatusOrBuffer(this.errorMessage);
            this.viewer.notifyError(this.errorMessage != null && this.errorMessage.indexOf("java.lang.OutOfMemoryError") >= 0 ? "Error" : "ScriptException", this.errorMessage, this.errorMessageUntranslated);
            bl2 = true;
        }
        if (bl2 || !this.isJS || !this.allowJSThreads) {
            this.viewer.setTainted(true);
            this.viewer.popHoldRepaint("executeCommands " + (this.scriptLevel > 0 ? "\u0001## REPAINT_IGNORE ##" : ""));
        }
        this.timeEndExecution = System.currentTimeMillis();
        if (this.errorMessage == null && this.executionStopped) {
            this.setErrorMessage("execution interrupted");
        } else if (!this.tQuiet && !this.chk) {
            this.viewer.scriptStatus("Script completed");
        }
        this.historyDisabled = false;
        this.isCmdLine_c_or_C_Option = false;
        this.chk = false;
        this.executing = false;
        String string = this.getErrorMessageUntranslated();
        this.viewer.setErrorMessage(this.errorMessage, string);
        if (!this.tQuiet) {
            this.viewer.setScriptStatus("Jmol script terminated", this.errorMessage, 1 + this.getExecutionWalltime(), string);
        }
    }

    @Override
    public void resumeEval(ScriptContext scriptContext) {
        this.setErrorMessage(null);
        if (this.executionStopped || scriptContext == null || !scriptContext.mustResumeEval) {
            this.viewer.setTainted(true);
            this.viewer.popHoldRepaint("resumeEval");
            this.viewer.queueOnHold = false;
            return;
        }
        if (!this.executionPaused) {
            ++scriptContext.pc;
        }
        this.thisContext = scriptContext;
        if (scriptContext.scriptLevel > 0) {
            this.scriptLevel = scriptContext.scriptLevel - 1;
        }
        this.restoreScriptContext(scriptContext, true, false, false);
        this.executeCommands(scriptContext.isTryCatch);
    }

    @Override
    public void runScript(String string) throws ScriptException {
        if (!this.viewer.isPreviewOnly()) {
            this.runScriptBuffer(string, this.outputBuffer);
        }
    }

    @Override
    public void runScriptBuffer(String string, SB sB) throws ScriptException {
        this.pushContext(null, "runScriptBuffer");
        this.contextPath = this.contextPath + " >> script() ";
        this.outputBuffer = sB;
        this.allowJSThreads = false;
        if (this.compileScript(null, string + "\u0001## EDITOR_IGNORE ##" + "\u0001## REPAINT_IGNORE ##", false)) {
            this.dispatchCommands(false, false);
        }
        this.popContext(false, false);
    }

    @Override
    public ScriptContext checkScriptSilent(String string) {
        ScriptContext scriptContext = this.compiler.compile(null, string, false, true, false, true);
        if (scriptContext.errorType != null) {
            return scriptContext;
        }
        this.restoreScriptContext(scriptContext, false, false, false);
        this.chk = true;
        this.isCmdLine_C_Option = false;
        this.isCmdLine_c_or_C_Option = false;
        this.pc = 0;
        try {
            this.dispatchCommands(false, false);
        }
        catch (ScriptException scriptException) {
            this.setErrorMessage(scriptException.toString());
            scriptContext = this.getScriptContext("checkScriptSilent");
        }
        this.chk = false;
        return scriptContext;
    }

    static SB getContextTrace(Viewer viewer, ScriptContext scriptContext, SB sB, boolean bl) {
        if (sB == null) {
            sB = new SB();
        }
        sB.append(ScriptEvaluator.getErrorLineMessage(scriptContext.functionName, scriptContext.scriptFileName, scriptContext.lineNumbers[scriptContext.pc], scriptContext.pc, ScriptEvaluator.statementAsString(viewer, scriptContext.statement, bl ? scriptContext.iToken : 9999, false)));
        if (scriptContext.parentContext != null) {
            ScriptEvaluator.getContextTrace(viewer, scriptContext.parentContext, sB, false);
        }
        return sB;
    }

    @Override
    public void setDebugging() {
        this.debugScript = this.viewer.getBoolean(603979824);
        this.logMessages = this.debugScript && Logger.debugging;
    }

    private int getExecutionWalltime() {
        return (int)(this.timeEndExecution - this.timeBeginExecution);
    }

    @Override
    public void haltExecution() {
        this.resumePausedExecution();
        this.executionStopped = true;
    }

    @Override
    public void pauseExecution(boolean bl) {
        if (this.chk || this.viewer.isHeadless()) {
            return;
        }
        if (bl && !this.isJS) {
            this.delayScript(-100);
        }
        this.viewer.popHoldRepaint("pauseExecution " + bl);
        this.executionStepping = false;
        this.executionPaused = true;
    }

    @Override
    public void stepPausedExecution() {
        this.executionStepping = true;
        this.executionPaused = false;
    }

    @Override
    public void resumePausedExecution() {
        this.executionPaused = false;
        this.executionStepping = false;
    }

    @Override
    public boolean isExecuting() {
        return this.executing && !this.executionStopped;
    }

    @Override
    public boolean isPaused() {
        return this.executionPaused;
    }

    @Override
    public boolean isStepping() {
        return this.executionStepping;
    }

    @Override
    public boolean isStopped() {
        return this.executionStopped || !this.isJS && this.currentThread != Thread.currentThread();
    }

    @Override
    public String getNextStatement() {
        return this.pc < this.aatoken.length ? ScriptEvaluator.getErrorLineMessage(this.functionName, this.scriptFileName, this.getLinenumber(null), this.pc, ScriptEvaluator.statementAsString(this.viewer, this.aatoken[this.pc], -9999, this.logMessages)) : "";
    }

    private String getCommand(int n, boolean bl, boolean bl2) {
        if (n >= this.lineIndices.length) {
            return "";
        }
        if (bl) {
            String string;
            int n2 = -1;
            int n3 = this.script.length();
            for (int i = 0; i < this.lineNumbers.length; ++i) {
                if (this.lineNumbers[i] == this.lineNumbers[n]) {
                    if (n2 < 0) {
                        n2 = this.lineIndices[i][0];
                    }
                    n3 = this.lineIndices[i][1];
                    continue;
                }
                if (this.lineNumbers[i] == 0 || this.lineNumbers[i] > this.lineNumbers[n]) break;
            }
            if ((string = this.script).indexOf(1) >= 0) {
                string = string.substring(0, string.indexOf(1));
            }
            if (n3 == string.length() - 1 && string.endsWith("}")) {
                ++n3;
            }
            return n2 == string.length() || n3 < n2 ? "" : string.substring(Math.max(n2, 0), Math.min(string.length(), n3));
        }
        int n4 = this.lineIndices[n][0];
        int n5 = this.lineIndices[n][1];
        String string = "";
        if (n4 < 0 || n5 <= n4 || n5 > this.script.length()) {
            return "";
        }
        try {
            string = this.script.substring(n4, n5);
            if (string.indexOf("\\\n") >= 0) {
                string = PT.simpleReplace(string, "\\\n", "  ");
            }
            if (string.indexOf("\\\r") >= 0) {
                string = PT.simpleReplace(string, "\\\r", "  ");
            }
            if (string.length() > 0 && !string.endsWith(";")) {
                string = string + ";";
            }
        }
        catch (Exception exception) {
            Logger.error("darn problem in Eval getCommand: ichBegin=" + n4 + " ichEnd=" + n5 + " len = " + this.script.length() + "\n" + exception);
        }
        return string;
    }

    private void logDebugScript(int n) {
        if (this.logMessages) {
            if (this.st.length > 0) {
                Logger.debug(this.st[0].toString());
            }
            for (int i = 1; i < this.slen; ++i) {
                Logger.debug(this.st[i].toString());
            }
        }
        this.iToken = -9999;
        if (this.logMessages) {
            SB sB = new SB();
            String string = n > 0 ? "                          ".substring(0, n * 2) : "";
            sB.append(string).append(ScriptEvaluator.statementAsString(this.viewer, this.st, this.iToken, this.logMessages));
            this.viewer.scriptStatus(sB.toString());
        } else {
            String string = this.getCommand(this.pc, false, false);
            if (string != "") {
                this.viewer.scriptStatus(string);
            }
        }
    }

    @Override
    public Object evaluateExpression(Object object, boolean bl) {
        ScriptEvaluator scriptEvaluator = (ScriptEvaluator)new ScriptEvaluator().setViewer(this.viewer);
        try {
            scriptEvaluator.pushContext(null, "evalExp");
            scriptEvaluator.allowJSThreads = false;
        }
        catch (ScriptException scriptException) {
            // empty catch block
        }
        return scriptEvaluator.evaluate(object, bl);
    }

    private Object evaluate(Object object, boolean bl) {
        try {
            if (object instanceof String) {
                if (this.compileScript(null, "e_x_p_r_e_s_s_i_o_n = " + object, false)) {
                    this.contextVariables = this.viewer.getContextVariables();
                    this.setStatement(0);
                    return bl ? this.parameterExpressionList(2, -1, false).get(0) : this.parameterExpressionString(2, 0);
                }
            } else if (object instanceof T[]) {
                this.contextVariables = this.viewer.getContextVariables();
                BS bS = this.atomExpression((T[])object, 0, 0, true, false, true, false);
                return bl ? SV.newV(10, bS) : bS;
            }
        }
        catch (Exception exception) {
            Logger.error("Error evaluating: " + object + "\n" + exception);
        }
        return bl ? SV.getVariable("ERROR") : "ERROR";
    }

    @Override
    public BS getAtomBitSet(Object object) {
        if (object instanceof BS) {
            return (BS)object;
        }
        BS bS = new BS();
        try {
            this.pushContext(null, "getAtomBitSet");
            String string = "select (" + object + ")";
            string = PT.replaceAllCharacters(string, "\n\r", "),(");
            string = PT.simpleReplace(string, "()", "(none)");
            if (this.compileScript(null, string, false)) {
                this.st = this.aatoken[0];
                bS = this.atomExpression(this.st, 1, 0, false, false, true, true);
            }
            this.popContext(false, false);
        }
        catch (Exception exception) {
            Logger.error("getAtomBitSet " + object + "\n" + exception);
        }
        return bS;
    }

    @Override
    public List<Integer> getAtomBitSetVector(int n, Object object) {
        List<Integer> list = new List<Integer>();
        BS bS = this.getAtomBitSet(object);
        int n2 = bS.nextSetBit(0);
        while (n2 >= 0) {
            list.addLast(n2);
            n2 = bS.nextSetBit(n2 + 1);
        }
        return list;
    }

    private List<SV> parameterExpressionList(int n, int n2, boolean bl) throws ScriptException {
        return (List)this.parameterExpression(n, -1, null, true, true, n2, bl, null, null);
    }

    private String parameterExpressionString(int n, int n2) throws ScriptException {
        return (String)this.parameterExpression(n, n2, "", true, false, -1, false, null, null);
    }

    private boolean parameterExpressionBoolean(int n, int n2) throws ScriptException {
        return (Boolean)this.parameterExpression(n, n2, null, true, false, -1, false, null, null);
    }

    private SV parameterExpressionToken(int n) throws ScriptException {
        List<SV> list = this.parameterExpressionList(n, -1, false);
        return list.size() > 0 ? (SV)list.get(0) : SV.newS("");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object parameterExpression(int n, int n2, String string, boolean bl, boolean bl2, int n3, boolean bl3, Map<String, SV> map, String string2) throws ScriptException {
        SV sV;
        boolean bl4 = string2 != null;
        boolean bl5 = n < 0;
        boolean bl6 = !bl2 && string == null;
        boolean bl7 = !bl2 && string != null && string.length() == 0;
        int n4 = 0;
        if (bl5) {
            n = -n;
        }
        int n5 = 0;
        ScriptMathProcessor scriptMathProcessor = new ScriptMathProcessor(this, bl3, bl2, false);
        if (n == 0 && n2 == 0) {
            n = 2;
        }
        if (n2 < n) {
            n2 = this.slen;
        }
        block35: for (int i = n; i < n2; ++i) {
            void var10_19;
            Object var10_20 = null;
            int n6 = this.getToken((int)i).tok;
            if (bl4 && this.tokAt(i + 1) != 0x100008) {
                SV sV2;
                SV sV3 = sV2 = map != null && map.containsKey(this.theToken.value) ? null : this.getBitsetPropertySelector(i, false);
                if (sV2 != null) {
                    scriptMathProcessor.addXVar(map.get(string2));
                    if (!scriptMathProcessor.addOpAllowMath(sV2, this.tokAt(i + 1) == 0x10100010)) {
                        this.invArg();
                    }
                    if ((sV2.intValue == 135368713 || sV2.intValue == 102436) && this.tokAt(this.iToken + 1) != 0x10100010) {
                        scriptMathProcessor.addOp(T.tokenLeftParen);
                        scriptMathProcessor.addOp(T.tokenRightParen);
                    }
                    i = this.iToken;
                    continue;
                }
            }
            block1 : switch (n6) {
                case 1060866: {
                    void var10_24;
                    if (this.tokAt(++i) == 0x100001) {
                        SV sV4 = this.parameterExpressionToken(++i);
                        i = this.iToken;
                    } else {
                        if (this.tokAt(i) == 2) {
                            BS bS = this.viewer.getAtomBits(1095763969, this.st[i].intValue);
                            break;
                        }
                        Object object = this.getParameter(SV.sValue(this.st[i]), 1073742190);
                    }
                    Object object = this.getParameter(((SV)var10_24).asString(), 1073742190);
                    break;
                }
                case 135369225: {
                    if (this.getToken((int)(++i)).tok != 0x10100010) {
                        this.invArg();
                    }
                    if (map == null) {
                        map = new Hashtable<String, SV>();
                    }
                    Object object3 = this.parameterExpression(++i, -1, null, bl, false, -1, false, map, string2);
                    boolean bl8 = (Boolean)object3;
                    int n7 = this.iToken;
                    if (this.getToken((int)n7++).tok != 0x10000F) {
                        this.invArg();
                    }
                    this.parameterExpressionBoolean(n7, -1);
                    int n8 = this.iToken;
                    if (this.tokAt(n8++) != 0x10000F) {
                        this.invArg();
                    }
                    this.parameterExpression(-n8, -1, null, bl, false, 1, false, map, string2);
                    int n9 = this.iToken;
                    if (this.tokAt(n9) != 0x10100011) {
                        this.invArg();
                    }
                    Object object2 = this.parameterExpression(bl8 ? n7 : n8, bl8 ? n8 : n9, "XXX", bl, false, 1, false, map, string2);
                    i = n9;
                    break;
                }
                case 135280132: 
                case 135369224: {
                    int n10;
                    int n11;
                    String[] stringArray;
                    Object object;
                    String string3;
                    boolean bl9;
                    Object object3;
                    boolean bl10 = n > 0;
                    boolean bl11 = bl9 = bl10 && n6 == 135369224;
                    if (bl10) {
                        if (this.getToken((int)(++i)).tok != 0x10100010 || !T.tokAttr(this.getToken((int)(++i)).tok, 0x40000000)) {
                            this.invArg();
                        }
                        string3 = this.parameterAsString(i);
                        if (this.getToken((int)(++i)).tok != 0x10000F) {
                            this.invArg();
                        }
                    } else {
                        string3 = "_x";
                    }
                    if (!((object = this.parameterExpressionToken((int)(-(++i))).value) instanceof BS)) {
                        this.invArg();
                    }
                    BS bS = (BS)object;
                    i = this.iToken;
                    if (bl10 && this.getToken((int)i++).tok != 0x10000F) {
                        this.invArg();
                    }
                    BS bS2 = new BS();
                    BS bS3 = new BS();
                    String[] stringArray2 = stringArray = bl9 ? new String[BSUtil.cardinalityOf(bS)] : null;
                    if (map == null) {
                        map = new Hashtable<String, SV>();
                    }
                    bS3.set(0);
                    SV sV5 = SV.newV(10, bS3);
                    sV5.index = 0;
                    map.put(string3, sV5.setName(string3));
                    int n12 = -1;
                    if (bl10) {
                        n12 = i - 1;
                        n11 = 0;
                        while (n11 >= 0 && ++n12 < n2) {
                            n10 = this.tokAt(n12);
                            if (n10 == 0x10100011) {
                                --n11;
                                continue;
                            }
                            if (n10 != 0x10100010) continue;
                            ++n11;
                        }
                    }
                    n11 = 0;
                    n10 = 0;
                    int n13 = bS.nextSetBit(0);
                    if (n13 < 0) {
                        this.iToken = n12 - 1;
                    } else if (!this.chk) {
                        while (n13 >= 0) {
                            if (n10 >= 0) {
                                bS3.clear(n10);
                            }
                            n10 = n13;
                            bS3.set(n13);
                            sV5.index = n13;
                            object3 = this.parameterExpression(i, n12, bl9 ? "XXX" : null, bl, bl9, n13, false, map, bl10 ? null : string3);
                            if (bl9) {
                                if (object3 == null || ((List)object3).size() == 0) {
                                    this.invArg();
                                }
                                stringArray[n11++] = ((SV)((List)object3).get(0)).asString();
                            } else if (((Boolean)object3).booleanValue()) {
                                bS2.set(n13);
                            }
                            n13 = bS.nextSetBit(n13 + 1);
                        }
                    }
                    if (bl9) {
                        String[] stringArray3 = stringArray;
                    } else {
                        if (!bl10) return this.bitsetVariableVector(bS2);
                        BS bS4 = bS2;
                    }
                    i = this.iToken + 1;
                    break;
                }
                case 0x10000F: {
                    break block35;
                }
                case 3: {
                    scriptMathProcessor.addXNum(SV.newV(3, this.theToken.value));
                    break;
                }
                case 2: 
                case 1048614: {
                    scriptMathProcessor.addXNum(SV.newI(this.theToken.intValue));
                    break;
                }
                case 135266319: {
                    if (this.tokAt(this.iToken + 1) == 0x10100010) {
                        if (scriptMathProcessor.addOpAllowMath(this.theToken, true)) break;
                        this.invArg();
                        break;
                    }
                    scriptMathProcessor.addXVar(SV.newT(this.theToken));
                    break;
                }
                case 4: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 0x100004: 
                case 0x100006: 
                case 0x10000C: 
                case 0x10000D: 
                case 135267335: 
                case 135267336: 
                case 0x40D00004: 
                case 1087373318: 
                case 1087373320: 
                case 1087375361: 
                case 1087375362: 
                case 1087375365: 
                case 1095761936: 
                case 1095761940: 
                case 1095766030: 
                case 1238369286: 
                case 1641025539: 
                case 1679429641: {
                    scriptMathProcessor.addXVar(SV.newT(this.theToken));
                    break;
                }
                case 0x100007: {
                    this.ignoreError = true;
                    try {
                        P3 p3 = this.centerParameter(i);
                        scriptMathProcessor.addXVar(SV.newV(8, p3));
                    }
                    catch (Exception exception) {
                        scriptMathProcessor.addXStr("");
                    }
                    this.ignoreError = false;
                    i = this.iToken;
                    break;
                }
                case 0x10000A: {
                    if (this.tokAt(i + 1) == 4) {
                        Map<String, Object> map2 = this.getHash(i);
                    } else {
                        Object object = this.getPointOrPlane(i, false, true, true, false, 3, 4);
                    }
                    i = this.iToken;
                    break;
                }
                case 0x100001: {
                    if (this.tokAt(i + 1) == 0x100002) {
                        Hashtable hashtable = new Hashtable();
                        ++i;
                        break;
                    }
                    if (this.tokAt(i + 1) == 0x100003 && this.tokAt(i + 2) == 0x100002) {
                        n6 = 0x100003;
                        this.iToken += 2;
                    }
                }
                case 0x100003: {
                    void var10_37;
                    if (n6 == 0x100003) {
                        BS bS = this.viewer.getAllAtoms();
                    } else {
                        BS bS = this.atomExpression(this.st, i, 0, true, true, true, true);
                    }
                    i = this.iToken++;
                    if (n5 != 0 || !bl5) break;
                    return this.bitsetVariableVector(var10_37);
                }
                case 1073742195: {
                    scriptMathProcessor.addOp(this.theToken);
                    continue block35;
                }
                case 0x100002: {
                    ++i;
                    break block35;
                }
                case 0x10000E: {
                    if (!bl && n5 == 0 && n4 == 0) break block35;
                    this.invArg();
                    break;
                }
                case 0x10100030: {
                    if (!bl && n5 == 0 && n4 == 0) break block35;
                    if (scriptMathProcessor.addOp(this.theToken)) break;
                    this.invArg();
                    break;
                }
                case 0x100008: {
                    SV sV6 = this.getBitsetPropertySelector(i + 1, false);
                    if (sV6 == null) {
                        this.invArg();
                    }
                    boolean bl12 = sV6.intValue == 135368713;
                    boolean bl13 = true;
                    int n14 = this.tokAt(this.iToken + 2);
                    if (this.tokAt(this.iToken + 1) == 0x100008) {
                        switch (n14) {
                            case 0x100003: {
                                n14 = 480;
                                if (this.tokAt(this.iToken + 3) == 0x100008 && this.tokAt(this.iToken + 4) == 1276118529) {
                                    n14 = 224;
                                }
                            }
                            case 32: 
                            case 64: 
                            case 96: 
                            case 128: 
                            case 160: 
                            case 192: {
                                bl13 = bl12 || sV6.intValue == 1276118018 || n14 == 480 || n14 == 224;
                                sV6.intValue |= n14;
                                this.getToken(this.iToken + 2);
                                break;
                            }
                        }
                    }
                    if (!scriptMathProcessor.addOpAllowMath(sV6, bl13 &= this.tokAt(this.iToken + 1) == 0x10100010 || bl12)) {
                        this.invArg();
                    }
                    i = this.iToken;
                    if (sV6.intValue != 135368713 || this.tokAt(i + 1) == 0x10100010) break;
                    scriptMathProcessor.addOp(T.tokenLeftParen);
                    scriptMathProcessor.addOp(T.tokenRightParen);
                    break;
                }
                default: {
                    void var10_42;
                    SV sV7;
                    boolean bl14;
                    if (T.tokAttr(this.theTok, 0x10100000) || T.tokAttr(this.theTok, 0x8100000) && this.tokAt(this.iToken + 1) == 0x10100010) {
                        if (!scriptMathProcessor.addOp(this.theToken)) {
                            if (n3 >= 0) break block35;
                            this.invArg();
                        }
                        switch (this.theTok) {
                            case 0x10100010: {
                                ++n5;
                                break block1;
                            }
                            case 0x10100011: {
                                if (--n5 > 0 || n4 != 0 || !bl5) break;
                                ++this.iToken;
                                break block35;
                            }
                            case 0x10100040: {
                                ++n4;
                                break block1;
                            }
                            case 0x10100041: {
                                if (--n4 != 0 || n5 != 0 || !bl5) break;
                                ++this.iToken;
                                break block35;
                            }
                        }
                        break;
                    }
                    String string4 = this.parameterAsString(i).toLowerCase();
                    boolean bl15 = bl14 = this.tokAt(i + 1) == 0x10100010;
                    if (this.chk) {
                        String string5 = string4;
                    } else if (!(bl14 || map != null && (sV7 = map.get(string4)) != null)) {
                        SV sV8 = this.getContextVariableAsVariable(string4);
                    }
                    if (var10_42 != null) break;
                    if (T.tokAttr(this.theTok, 0x40000000) && this.viewer.isFunction(string4)) {
                        if (!scriptMathProcessor.addOp(SV.newV(135368713, this.theToken.value))) {
                            this.invArg();
                        }
                        if (bl14) break;
                        scriptMathProcessor.addOp(T.tokenLeftParen);
                        scriptMathProcessor.addOp(T.tokenRightParen);
                        break;
                    }
                    scriptMathProcessor.addXVar(this.viewer.getOrSetNewVariable(string4, false));
                }
            }
            if (var10_19 == null) continue;
            if (var10_19 instanceof BS) {
                scriptMathProcessor.addXBs((BS)var10_19);
                continue;
            }
            scriptMathProcessor.addXObj(var10_19);
        }
        if ((sV = scriptMathProcessor.getResult(false)) == null) {
            if (!this.chk) {
                scriptMathProcessor.dumpStacks("null result");
            }
            this.error(13);
        }
        if (sV.tok == 135198) {
            return sV.value;
        }
        if (bl6) {
            return sV.asBoolean();
        }
        if (bl7) {
            if (sV.tok != 4) return sV.asString();
            sV.intValue = Integer.MAX_VALUE;
            return sV.asString();
        }
        switch (sV.tok) {
            case 0x10000C: 
            case 0x10000D: {
                boolean bl16;
                if (sV.intValue == 1) {
                    bl16 = true;
                    return bl16;
                }
                bl16 = false;
                return bl16;
            }
            case 2: {
                return sV.intValue;
            }
        }
        return sV.value;
    }

    private Map<String, Object> getHash(int n) throws ScriptException {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        ++n;
        while (n < this.slen && this.tokAt(n) != 0x10000E) {
            String string = this.stringParameter(n++);
            if (this.tokAt(n++) != 0x10100022) {
                this.invArg();
            }
            List list = (List)this.parameterExpression(n, 0, null, false, true, -1, false, null, null);
            hashtable.put(string, list.get(0));
            n = this.iToken;
            if (this.tokAt(n) != 0x10100030) break;
            ++n;
        }
        this.iToken = n;
        if (this.tokAt(n) != 0x10000E) {
            this.invArg();
        }
        return hashtable;
    }

    List<SV> bitsetVariableVector(Object object) {
        List<SV> list = new List<SV>();
        if (object instanceof BS) {
            list.addLast(SV.newV(10, object));
        }
        return list;
    }

    private SV getBitsetPropertySelector(int n, boolean bl) throws ScriptException {
        int n2 = this.getToken((int)n).tok;
        switch (n2) {
            case 32: 
            case 64: 
            case 96: 
            case 128: 
            case 160: 
            case 192: 
            case 1716520985: {
                break;
            }
            default: {
                if (T.tokAttrOr(n2, 0x40500000, 0x44100000)) break;
                if (n2 != 806354977 && !T.tokAttr(n2, 0x40000000)) {
                    return null;
                }
                String string = this.parameterAsString(n);
                if (!bl && this.viewer.isFunction(string)) {
                    n2 = 135368713;
                    break;
                }
                if (!string.endsWith("?")) {
                    return null;
                }
                n2 = 0x40000000;
            }
        }
        if (bl && !T.tokAttr(n2, 2048)) {
            return null;
        }
        return SV.newSV(0x101000D1, n2, this.parameterAsString(n).toLowerCase());
    }

    public float[] getBitsetPropertyFloat(BS bS, int n, float f, float f2) throws ScriptException {
        int n2;
        float[] fArray = (float[])this.getBitsetProperty(bS, n, null, null, null, null, false, Integer.MAX_VALUE, false);
        if (!Float.isNaN(f)) {
            for (n2 = 0; n2 < fArray.length; ++n2) {
                if (!(fArray[n2] < f)) continue;
                fArray[n2] = Float.NaN;
            }
        }
        if (!Float.isNaN(f2)) {
            for (n2 = 0; n2 < fArray.length; ++n2) {
                if (!(fArray[n2] > f2)) continue;
                fArray[n2] = Float.NaN;
            }
        }
        return fArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object getBitsetProperty(BS bS, int n, P3 p3, P4 p4, Object object, Object object2, boolean bl, int n2, boolean bl2) throws ScriptException {
        int n3;
        int n4;
        List<Object> list;
        block129: {
            int n5;
            int n6;
            float[] fArray;
            block128: {
                double d;
                double d2;
                float f;
                int n7;
                int n8;
                P3 p32;
                boolean bl3;
                boolean bl4;
                int n9;
                block127: {
                    boolean bl5;
                    boolean bl6;
                    boolean bl7;
                    block124: {
                        float f2;
                        Object object3;
                        int n10;
                        ModelSet modelSet;
                        P3 p33;
                        block126: {
                            float[] fArray2;
                            SV sV;
                            BS bS2;
                            List list2;
                            String string;
                            int n11;
                            boolean bl8;
                            block125: {
                                bl8 = n2 != Integer.MAX_VALUE;
                                boolean bl9 = bl8 || !(object instanceof BondSet);
                                n9 = n & 0x1E0;
                                bl7 = n9 == 224;
                                n11 = this.viewer.getAtomCount();
                                fArray = n9 == 256 ? new float[n11] : null;
                                boolean bl10 = bl6 = n9 == 480 || bl7;
                                if ((n &= 0xFFFFFE1F) == 0) {
                                    n = bl9 ? 0x44100001 : 1678770178;
                                }
                                bl4 = false;
                                bl3 = false;
                                bl5 = false;
                                switch (n) {
                                    case 1146093582: 
                                    case 1146095626: 
                                    case 1146095627: 
                                    case 1146095628: 
                                    case 1146095629: 
                                    case 1146095631: 
                                    case 1766856708: {
                                        bl4 = true;
                                        break;
                                    }
                                    case 135368713: 
                                    case 1276118018: {
                                        break;
                                    }
                                    default: {
                                        bl3 = T.tokAttr(n, 1095761920) && !T.tokAttr(n, 1112539136);
                                        bl5 = !bl3 && T.tokAttr(n, 0x40D00000);
                                    }
                                }
                                P3 p34 = p32 = bl4 || !bl9 ? new P3() : null;
                                if (bl6 || bl5 && !bl8 && n9 != 256 && n9 != 32) {
                                    n9 = 0x100003;
                                }
                                list = n9 == 0x100003 ? new List<Object>() : null;
                                BS bS3 = null;
                                string = null;
                                list2 = null;
                                bS2 = null;
                                sV = null;
                                p33 = null;
                                fArray2 = null;
                                switch (n) {
                                    case 0x44100001: 
                                    case 1678770178: {
                                        int n12;
                                        if (this.chk) {
                                            return bS;
                                        }
                                        bS3 = n == 0x44100001 ? (bl9 ? bS : this.viewer.getAtomBits(1678770178, bS)) : (bl9 ? new BondSet(this.viewer.getBondsForSelectedAtoms(bS)) : bS);
                                        switch (n9) {
                                            case 32: {
                                                n12 = bS3.nextSetBit(0);
                                                break;
                                            }
                                            case 64: {
                                                n12 = bS3.length() - 1;
                                                break;
                                            }
                                            case 128: 
                                            case 160: 
                                            case 192: {
                                                return Float.valueOf(Float.NaN);
                                            }
                                            default: {
                                                return bS3;
                                            }
                                        }
                                        bS3.clearAll();
                                        if (n12 < 0) return bS3;
                                        bS3.set(n12);
                                        return bS3;
                                    }
                                    case 1087373321: {
                                        switch (n9) {
                                            case 0: 
                                            case 0x100003: {
                                                return this.getExtension().getBitsetIdent(bS, null, object, bl, n2, bl6);
                                            }
                                        }
                                        return "";
                                    }
                                    case 135368713: {
                                        string = (String)((Object[])object2)[0];
                                        list2 = (List)((Object[])object2)[1];
                                        bS2 = BSUtil.newBitSet(n11);
                                        sV = SV.newV(10, bS2);
                                        break;
                                    }
                                    case 1112539150: 
                                    case 1112539151: {
                                        this.viewer.autoCalculate(n);
                                        break;
                                    }
                                    case 1276118018: {
                                        if (p3 != null || p4 != null) break;
                                        return new P3();
                                    }
                                    case 1766856708: {
                                        p33 = new P3();
                                        break;
                                    }
                                    case 1716520985: {
                                        fArray2 = this.viewer.getDataFloat((String)object2);
                                        break;
                                    }
                                }
                                n8 = 0;
                                n7 = 0;
                                f = 0.0f;
                                d2 = 0.0;
                                d = 0.0;
                                switch (n9) {
                                    case 32: {
                                        n7 = Integer.MAX_VALUE;
                                        f = Float.MAX_VALUE;
                                        break;
                                    }
                                    case 64: {
                                        n7 = Integer.MIN_VALUE;
                                        f = -3.4028235E38f;
                                        break;
                                    }
                                }
                                modelSet = this.viewer.modelSet;
                                int n13 = bl4 ? 3 : (bl5 ? 2 : (n6 = bl3 ? 1 : 0));
                                if (bl9) break block125;
                                n4 = bS == null ? 1 : 0;
                                n5 = n4 != 0 ? 0 : bS.nextSetBit(0);
                                n3 = this.viewer.getBondCount();
                                n10 = n5;
                                break block126;
                            }
                            int n14 = n4 = bS != null ? 1 : 0;
                            if (bl8) {
                                n5 = n2;
                                n3 = n2 + 1;
                            } else if (n4 != 0) {
                                n5 = bS.nextSetBit(0);
                                n3 = Math.min(n11, bS.length());
                            } else {
                                n5 = 0;
                                n3 = n11;
                            }
                            if (this.chk) {
                                n3 = 0;
                            }
                            n10 = n5;
                            while (n10 >= 0 && n10 < n3) {
                                block123: {
                                    ++n8;
                                    object3 = modelSet.atoms[n10];
                                    block25 : switch (n6) {
                                        case 0: {
                                            f2 = Float.MAX_VALUE;
                                            switch (n) {
                                                case 135368713: {
                                                    bS2.set(n10);
                                                    f2 = SV.fValue(this.runFunctionRet(null, string, list2, sV, true, true, false));
                                                    bS2.clear(n10);
                                                    break;
                                                }
                                                case 1716520985: {
                                                    f2 = fArray2 == null ? 0.0f : fArray2[n10];
                                                    break;
                                                }
                                                case 1276118018: {
                                                    if (p4 != null) {
                                                        f2 = Measure.distanceToPlane(p4, (P3)object3);
                                                        break;
                                                    }
                                                    f2 = ((T3)object3).distance(p3);
                                                    break;
                                                }
                                                default: {
                                                    f2 = Atom.atomPropertyFloat(this.viewer, (Atom)object3, n);
                                                }
                                            }
                                            if (f2 == Float.MAX_VALUE || Float.isNaN(f2) && n9 != 0x100003) {
                                                --n8;
                                                break block123;
                                            } else {
                                                switch (n9) {
                                                    case 32: {
                                                        if (!(f2 < f)) break;
                                                        f = f2;
                                                        break;
                                                    }
                                                    case 64: {
                                                        if (!(f2 > f)) break;
                                                        f = f2;
                                                        break;
                                                    }
                                                    case 256: {
                                                        fArray[n10] = f2;
                                                        break;
                                                    }
                                                    case 0x100003: {
                                                        list.addLast(Float.valueOf(f2));
                                                        break;
                                                    }
                                                    case 160: 
                                                    case 192: {
                                                        d += (double)f2 * (double)f2;
                                                    }
                                                    default: {
                                                        d2 += (double)f2;
                                                        break;
                                                    }
                                                }
                                                break;
                                            }
                                        }
                                        case 1: {
                                            int n15 = 0;
                                            switch (n) {
                                                case 1095761925: 
                                                case 1095766024: {
                                                    this.errorStr(45, T.nameOf(n));
                                                    break;
                                                }
                                                default: {
                                                    n15 = Atom.atomPropertyInt((Atom)object3, n);
                                                }
                                            }
                                            switch (n9) {
                                                case 32: {
                                                    if (n15 >= n7) break;
                                                    n7 = n15;
                                                    break;
                                                }
                                                case 64: {
                                                    if (n15 <= n7) break;
                                                    n7 = n15;
                                                    break;
                                                }
                                                case 256: {
                                                    fArray[n10] = n15;
                                                    break;
                                                }
                                                case 0x100003: {
                                                    list.addLast(Integer.valueOf(n15));
                                                    break;
                                                }
                                                case 160: 
                                                case 192: {
                                                    d += (double)n15 * (double)n15;
                                                }
                                                default: {
                                                    d2 += (double)n15;
                                                    break;
                                                }
                                            }
                                            break;
                                        }
                                        case 2: {
                                            String string2 = Atom.atomPropertyString(this.viewer, (Atom)object3, n);
                                            switch (n9) {
                                                case 256: {
                                                    fArray[n10] = PT.parseFloat(string2);
                                                    break block25;
                                                }
                                            }
                                            if (list == null) {
                                                return string2;
                                            }
                                            list.addLast(string2);
                                            break;
                                        }
                                        case 3: {
                                            T3 t3 = Atom.atomPropertyTuple((Atom)object3, n);
                                            if (t3 == null) {
                                                this.errorStr(45, T.nameOf(n));
                                            }
                                            switch (n9) {
                                                case 256: {
                                                    fArray[n10] = (float)Math.sqrt(t3.x * t3.x + t3.y * t3.y + t3.z * t3.z);
                                                    break block25;
                                                }
                                                case 0x100003: {
                                                    list.addLast(P3.newP(t3));
                                                    break block25;
                                                }
                                            }
                                            p32.add(t3);
                                        }
                                    }
                                    if (bl8) break block124;
                                }
                                n10 = n4 != 0 ? bS.nextSetBit(n10 + 1) : n10 + 1;
                            }
                            break block124;
                        }
                        while (n10 >= 0 && n10 < n3) {
                            ++n8;
                            object3 = modelSet.getBondAt(n10);
                            block60 : switch (n) {
                                case 1141899267: {
                                    f2 = ((Bond)object3).getAtom1().distance(((Bond)object3).getAtom2());
                                    switch (n9) {
                                        case 32: {
                                            if (!(f2 < f)) break;
                                            f = f2;
                                            break;
                                        }
                                        case 64: {
                                            if (!(f2 > f)) break;
                                            f = f2;
                                            break;
                                        }
                                        case 0x100003: {
                                            list.addLast(Float.valueOf(f2));
                                            break;
                                        }
                                        case 160: 
                                        case 192: {
                                            d += (double)f2 * (double)f2;
                                        }
                                        default: {
                                            d2 += (double)f2;
                                            break;
                                        }
                                    }
                                    break;
                                }
                                case 1146095626: {
                                    switch (n9) {
                                        case 0x100003: {
                                            p32.ave(((Bond)object3).getAtom1(), ((Bond)object3).getAtom2());
                                            list.addLast(P3.newP(p32));
                                            break block60;
                                        }
                                    }
                                    p32.add(((Bond)object3).getAtom1());
                                    p32.add(((Bond)object3).getAtom2());
                                    ++n8;
                                    break;
                                }
                                case 1766856708: {
                                    CU.toRGBpt(this.viewer.getColorArgbOrGray(((Bond)object3).colix), p33);
                                    switch (n9) {
                                        case 0x100003: {
                                            list.addLast(P3.newP(p33));
                                            break block60;
                                        }
                                    }
                                    p32.add(p33);
                                    break;
                                }
                                default: {
                                    this.errorStr(46, T.nameOf(n));
                                }
                            }
                            n10 = n4 != 0 ? n10 + 1 : bS.nextSetBit(n10 + 1);
                        }
                    }
                    if (n9 == 256) {
                        return fArray;
                    }
                    if (n9 != 0x100003) break block127;
                    if (bl2) {
                        return list;
                    }
                    n4 = list.size();
                    if (bl5 && !bl6 && n4 == 1) {
                        return list.get(0);
                    }
                    if (bl7) break block128;
                    if (n == 1087373320) {
                        SB sB = new SB();
                        n3 = 0;
                        while (n3 < n4) {
                            sB.append((String)list.get(n3));
                            ++n3;
                        }
                        return sB.toString();
                    }
                    break block129;
                }
                if (bl4) {
                    P3 p35;
                    if (n8 == 0) {
                        p35 = p32;
                        return p35;
                    }
                    p35 = P3.new3(p32.x / (float)n8, p32.y / (float)n8, p32.z / (float)n8);
                    return p35;
                }
                if (n8 == 0) return Float.valueOf(Float.NaN);
                if (n8 == 1 && n9 == 192) {
                    return Float.valueOf(Float.NaN);
                }
                if (bl3) {
                    switch (n9) {
                        case 32: 
                        case 64: {
                            return n7;
                        }
                        case 160: 
                        case 192: {
                            break;
                        }
                        case 128: {
                            return (int)d2;
                        }
                        default: {
                            if (d2 / (double)n8 != (double)((int)(d2 / (double)n8))) return Float.valueOf((float)(d2 / (double)n8));
                            return (int)(d2 / (double)n8);
                        }
                    }
                }
                switch (n9) {
                    case 32: 
                    case 64: {
                        d2 = f;
                        return Float.valueOf((float)d2);
                    }
                    case 128: {
                        return Float.valueOf((float)d2);
                    }
                    case 160: {
                        d2 = d;
                        return Float.valueOf((float)d2);
                    }
                    case 192: {
                        d2 = Math.sqrt((d - d2 * d2 / (double)n8) / (double)(n8 - 1));
                        return Float.valueOf((float)d2);
                    }
                }
                d2 /= (double)n8;
                return Float.valueOf((float)d2);
            }
            fArray = new float[n4];
            n5 = n4;
            block97: while (--n5 >= 0) {
                Object e = list.get(n5);
                switch (n6) {
                    case 0: {
                        fArray[n5] = ((Float)e).floatValue();
                        break;
                    }
                    case 1: {
                        fArray[n5] = ((Integer)e).floatValue();
                        break;
                    }
                    case 2: {
                        fArray[n5] = PT.parseFloat((String)e);
                        break;
                    }
                    case 3: {
                        fArray[n5] = ((P3)e).length();
                        continue block97;
                    }
                }
            }
            return fArray;
        }
        String[] stringArray = new String[n4];
        n3 = n4;
        while (--n3 >= 0) {
            Object e = list.get(n3);
            if (e instanceof P3) {
                stringArray[n3] = Escape.eP((P3)e);
                continue;
            }
            stringArray[n3] = "" + list.get(n3);
        }
        return stringArray;
    }

    private void setBitsetProperty(BS bS, int n, int n2, float f, T t) throws ScriptException {
        if (this.chk || BSUtil.cardinalityOf(bS) == 0) {
            return;
        }
        String[] stringArray = null;
        String string = null;
        float[] fArray = null;
        List<SV> list = null;
        int n3 = 0;
        boolean bl = T.tokAttr(n, 0x40D00000);
        if (t.tok == 7 && (n3 = (list = ((SV)t).getList()).size()) == 0) {
            return;
        }
        switch (n) {
            case 1146095626: 
            case 1146095627: 
            case 1146095629: 
            case 1146095631: {
                switch (t.tok) {
                    case 8: {
                        this.viewer.setAtomCoords(bS, n, t.value);
                        break;
                    }
                    case 7: {
                        this.theToken = t;
                        this.viewer.setAtomCoords(bS, n, this.getPointArray(-1, n3));
                    }
                }
                return;
            }
            case 1766856708: {
                Object object = null;
                String string2 = "color";
                switch (t.tok) {
                    case 7: {
                        int[] nArray = new int[n3];
                        int n4 = n3;
                        while (--n4 >= 0) {
                            SV sV = (SV)list.get(n4);
                            P3 p3 = SV.ptValue(sV);
                            if (p3 != null) {
                                nArray[n4] = CU.colorPtToFFRGB(p3);
                            } else if (sV.tok == 2) {
                                nArray[n4] = sV.intValue;
                            } else {
                                nArray[n4] = CU.getArgbFromString(sV.asString());
                                if (nArray[n4] == 0) {
                                    nArray[n4] = sV.asInt();
                                }
                            }
                            if (nArray[n4] != 0) continue;
                            this.errorStr2(50, "ARRAY", sV.asString());
                        }
                        object = nArray;
                        string2 = "colorValues";
                        break;
                    }
                    case 8: {
                        object = CU.colorPtToFFRGB((P3)t.value);
                        break;
                    }
                    case 4: {
                        object = t.value;
                        break;
                    }
                    default: {
                        object = SV.iValue(t);
                    }
                }
                this.setShapePropertyBs(0, string2, object, bS);
                return;
            }
            case 1288701960: 
            case 1826248715: {
                if (t.tok == 7) break;
                string = SV.sValue(t);
                break;
            }
            case 1087375365: 
            case 1095763978: {
                this.clearDefinedVariableAtomSets();
                bl = false;
            }
        }
        switch (t.tok) {
            case 7: {
                if (bl) {
                    stringArray = SV.listValue(t);
                    break;
                }
                fArray = SV.flistValue(t, n3);
                break;
            }
            case 4: {
                if (string != null) break;
                stringArray = PT.getTokens(SV.sValue(t));
            }
        }
        if (stringArray != null) {
            n3 = stringArray.length;
            if (!bl) {
                fArray = new float[n3];
                int n5 = n3;
                while (--n5 >= 0) {
                    fArray[n5] = n == 1087375365 ? (float)Elements.elementNumberFromSymbol(stringArray[n5], false) : PT.parseFloat(stringArray[n5]);
                }
            }
            if (t.tok != 7 && n3 == 1) {
                if (bl) {
                    string = stringArray[0];
                } else {
                    f = fArray[0];
                }
                n2 = (int)f;
                stringArray = null;
                fArray = null;
            }
        }
        this.viewer.setAtomProperty(bS, n, n2, f, string, fArray, stringArray);
    }

    @Override
    public Map<String, Object> getDefinedAtomSets() {
        return this.definedAtomSets;
    }

    @Override
    public Map<String, SV> getContextVariables() {
        return this.contextVariables;
    }

    @Override
    public String getScript() {
        return this.script;
    }

    public boolean compileScript(String string, String string2, boolean bl) {
        this.scriptFileName = string;
        string2 = this.fixScriptPath(string2, string);
        this.restoreScriptContext(this.compiler.compile(string, string2, false, false, bl, false), false, false, false);
        this.isStateScript = this.script.indexOf("# Jmol state version ") >= 0;
        this.forceNoAddHydrogens = this.isStateScript && this.script.indexOf("pdbAddHydrogens") < 0;
        String string3 = this.script;
        this.pc = this.setScriptExtensions();
        if (!this.chk && this.viewer.scriptEditorVisible && string2.indexOf("\u0001## EDITOR_IGNORE ##") < 0) {
            this.viewer.scriptStatus("");
        }
        this.script = string3;
        return !this.error;
    }

    private String fixScriptPath(String string, String string2) {
        if (string2 != null && string.indexOf("$SCRIPT_PATH$") >= 0) {
            String string3 = string2;
            int n = Math.max(string2.lastIndexOf("|"), string2.lastIndexOf("/"));
            string3 = string3.substring(0, n + 1);
            string = PT.simpleReplace(string, "$SCRIPT_PATH$/", string3);
            string = PT.simpleReplace(string, "$SCRIPT_PATH$", string3);
        }
        return string;
    }

    private int setScriptExtensions() {
        String string = this.scriptExtensions;
        if (string == null) {
            return 0;
        }
        int n = string.indexOf("##SCRIPT_STEP");
        if (n >= 0) {
            this.executionStepping = true;
        }
        if ((n = string.indexOf("##SCRIPT_START=")) < 0) {
            return 0;
        }
        if ((n = PT.parseInt(string.substring(n + 15))) == Integer.MIN_VALUE) {
            return 0;
        }
        this.pc = 0;
        while (this.pc < this.lineIndices.length && this.lineIndices[this.pc][0] <= n && this.lineIndices[this.pc][1] < n) {
            ++this.pc;
        }
        if (this.pc > 0 && this.pc < this.lineIndices.length && this.lineIndices[this.pc][0] > n) {
            --this.pc;
        }
        return this.pc;
    }

    private boolean compileScriptFileInternal(String string, String string2, String string3, String string4) {
        String string5;
        if (string.toLowerCase().indexOf("javascript:") == 0) {
            return this.compileScript(string, this.viewer.jsEval(string.substring(11)), this.debugScript);
        }
        String[] stringArray = new String[2];
        stringArray[0] = string;
        if (!this.viewer.getFileAsStringBin(stringArray)) {
            this.setErrorMessage("io error reading " + stringArray[0] + ": " + stringArray[1]);
            return false;
        }
        if (("\n" + stringArray[1]).indexOf("\nJmolManifest.txt\n") >= 0) {
            if (string.endsWith(".all.pngj") || string.endsWith(".all.png")) {
                string5 = "|state.spt";
                string = string + "|";
            } else {
                stringArray[0] = string = string + "|JmolManifest.txt";
                if (!this.viewer.getFileAsStringBin(stringArray)) {
                    this.setErrorMessage("io error reading " + stringArray[0] + ": " + stringArray[1]);
                    return false;
                }
                string5 = JmolBinary.getManifestScriptPath(stringArray[1]);
            }
            if (string5 != null && string5.length() > 0) {
                stringArray[0] = string = string.substring(0, string.lastIndexOf("|")) + string5;
                if (!this.viewer.getFileAsStringBin(stringArray)) {
                    this.setErrorMessage("io error reading " + stringArray[0] + ": " + stringArray[1]);
                    return false;
                }
            }
        }
        this.scriptFileName = string;
        stringArray[1] = JmolBinary.getEmbeddedScript(stringArray[1]);
        string5 = this.fixScriptPath(stringArray[1], stringArray[0]);
        if (string4 == null) {
            string4 = this.viewer.getFilePath(string, false);
            string4 = string4.substring(0, Math.max(string4.lastIndexOf("|"), string4.lastIndexOf("/")));
        }
        string5 = FileManager.setScriptFileReferences(string5, string2, string3, string4);
        return this.compileScript(string, string5, this.debugScript);
    }

    public Object getParameter(String string, int n) {
        Object object = this.getContextVariableAsVariable(string);
        if (object == null) {
            object = this.viewer.getParameter(string);
        }
        switch (n) {
            case 1073742190: {
                return SV.getVariable(object);
            }
            case 4: {
                if (!(object instanceof List)) break;
                List list = (List)object;
                SB sB = new SB();
                for (int i = 0; i < list.size(); ++i) {
                    sB.append(((SV)list.get(i)).asString()).appendC('\n');
                }
                return sB.toString();
            }
        }
        return object instanceof SV ? SV.oValue((SV)object) : object;
    }

    private String getStringParameter(String string, boolean bl) {
        SV sV = this.getContextVariableAsVariable(string);
        if (sV != null) {
            return sV.asString();
        }
        String string2 = "" + this.viewer.getParameter(string);
        return string2.length() == 0 && bl ? string : string2;
    }

    private Object getNumericParameter(String string) {
        if (string.equalsIgnoreCase("_modelNumber")) {
            int n = this.viewer.getCurrentModelIndex();
            return n < 0 ? 0 : this.viewer.getModelFileNumber(n);
        }
        SV sV = this.getContextVariableAsVariable(string);
        if (sV == null) {
            Object object = this.viewer.getParameter(string);
            if (!(object instanceof String)) {
                return object;
            }
            sV = SV.newS((String)object);
        }
        return SV.nValue(sV);
    }

    public SV getContextVariableAsVariable(String string) {
        if (string.equals("expressionBegin")) {
            return null;
        }
        string = string.toLowerCase();
        if (this.contextVariables != null && this.contextVariables.containsKey(string)) {
            return this.contextVariables.get(string);
        }
        ScriptContext scriptContext = this.thisContext;
        while (scriptContext != null) {
            if (scriptContext.isFunction) {
                return null;
            }
            if (scriptContext.contextVariables != null && scriptContext.contextVariables.containsKey(string)) {
                return scriptContext.contextVariables.get(string);
            }
            scriptContext = scriptContext.parentContext;
        }
        return null;
    }

    private Object getStringObjectAsVariable(String string, String string2) {
        if (string == null || string.length() == 0) {
            return string;
        }
        Object object = SV.unescapePointOrBitsetAsVariable(string);
        if (object instanceof String && string2 != null) {
            object = this.viewer.setUserVariable(string2, SV.newS((String)object));
        }
        return object;
    }

    @Override
    public float evalFunctionFloat(Object object, Object object2, float[] fArray) {
        try {
            List list = (List)object2;
            for (int i = 0; i < fArray.length; ++i) {
                ((SV)list.get((int)i)).value = Float.valueOf(fArray[i]);
            }
            ScriptFunction scriptFunction = (ScriptFunction)object;
            return SV.fValue(this.runFunctionRet(scriptFunction, scriptFunction.name, list, null, true, false, false));
        }
        catch (Exception exception) {
            return Float.NaN;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SV runFunctionRet(JmolScriptFunction jmolScriptFunction, String string, List<SV> list, SV sV, boolean bl, boolean bl2, boolean bl3) throws ScriptException {
        JmolScriptFunction jmolScriptFunction2;
        boolean bl4;
        if (jmolScriptFunction == null) {
            jmolScriptFunction = this.viewer.getFunction(string);
            if (jmolScriptFunction == null) {
                return null;
            }
            if (bl2) {
                this.contextPath = this.contextPath + " >> function " + string;
            }
        } else if (bl2) {
            this.contextPath = this.contextPath + " >> " + string;
        }
        this.pushContext(null, "funcRet");
        if (this.allowJSThreads) {
            this.allowJSThreads = bl3;
        }
        this.thisContext.isTryCatch = bl4 = jmolScriptFunction.getTok() == 364558;
        this.thisContext.isFunction = !bl4;
        this.functionName = string;
        if (bl4) {
            this.viewer.resetError();
            this.thisContext.displayLoadErrorsSave = this.viewer.displayLoadErrors;
            this.thisContext.tryPt = ++tryPt;
            this.viewer.displayLoadErrors = false;
            this.restoreFunction(jmolScriptFunction, list, sV);
            this.contextVariables.put("_breakval", SV.newI(Integer.MAX_VALUE));
            this.contextVariables.put("_errorval", SV.newS(""));
            Map<String, SV> map = this.contextVariables;
            this.executeCommands(true);
            while (this.thisContext.tryPt > tryPt) {
                this.popContext(false, false);
            }
            this.processTry(map);
            return null;
        }
        if (jmolScriptFunction instanceof JmolParallelProcessor) {
            jmolScriptFunction2 = jmolScriptFunction;
            synchronized (jmolScriptFunction2) {
                this.parallelProcessor = (JmolParallelProcessor)((Object)jmolScriptFunction);
                this.restoreFunction(jmolScriptFunction, list, sV);
                this.dispatchCommands(false, true);
                ((JmolParallelProcessor)((Object)jmolScriptFunction)).runAllProcesses(this.viewer);
            }
        } else {
            this.restoreFunction(jmolScriptFunction, list, sV);
            this.dispatchCommands(false, true);
        }
        jmolScriptFunction2 = bl ? this.getContextVariableAsVariable("_retval") : null;
        this.popContext(false, false);
        return jmolScriptFunction2;
    }

    private void processTry(Map<String, SV> map) throws ScriptException {
        int n;
        this.viewer.displayLoadErrors = this.thisContext.displayLoadErrorsSave;
        this.popContext(false, false);
        String string = (String)this.viewer.getParameter("_errormessage");
        if (string.length() > 0) {
            map.put("_errorval", SV.newS(string));
            this.viewer.resetError();
        }
        map.put("_tryret", map.get("_retval"));
        SV sV = map.get("_tryret");
        if (sV.value != null || sV.intValue != Integer.MAX_VALUE) {
            this.returnCmd(sV);
            return;
        }
        String string2 = (String)map.get((Object)"_errorval").value;
        if (string2.length() == 0 && (n = map.get((Object)"_breakval").intValue) != Integer.MAX_VALUE) {
            this.breakCmd(this.pc - n);
            return;
        }
        if (this.pc + 1 < this.aatoken.length && this.aatoken[this.pc + 1][0].tok == 102412) {
            ContextToken contextToken = (ContextToken)this.aatoken[this.pc + 1][0];
            if (contextToken.contextVariables != null && contextToken.name0 != null) {
                contextToken.contextVariables.put(contextToken.name0, SV.newS(string2));
            }
            contextToken.intValue = (string2.length() > 0 ? 1 : -1) * Math.abs(contextToken.intValue);
        }
    }

    private void restoreFunction(JmolScriptFunction jmolScriptFunction, List<SV> list, SV sV) throws ScriptException {
        ScriptFunction scriptFunction = (ScriptFunction)jmolScriptFunction;
        this.aatoken = scriptFunction.aatoken;
        this.lineNumbers = scriptFunction.lineNumbers;
        this.lineIndices = scriptFunction.lineIndices;
        this.script = scriptFunction.script;
        this.pc = 0;
        if (scriptFunction.names != null) {
            this.contextVariables = new Hashtable<String, SV>();
            scriptFunction.setVariables(this.contextVariables, list);
        }
        if (sV != null) {
            this.contextVariables.put("_x", sV);
        }
    }

    public void clearDefinedVariableAtomSets() {
        this.definedAtomSets.remove("# variable");
    }

    private void defineSets() {
        String string;
        int n;
        if (!this.definedAtomSets.containsKey("# static")) {
            for (n = 0; n < JC.predefinedStatic.length; ++n) {
                this.defineAtomSet(JC.predefinedStatic[n]);
            }
            this.defineAtomSet("# static");
        }
        if (this.definedAtomSets.containsKey("# variable")) {
            return;
        }
        for (n = 0; n < JC.predefinedVariable.length; ++n) {
            this.defineAtomSet(JC.predefinedVariable[n]);
        }
        n = Elements.elementNumberMax;
        while (--n >= 0) {
            string = " elemno=" + n;
            this.defineAtomSet("@" + Elements.elementNameFromNumber(n) + string);
            this.defineAtomSet("@_" + Elements.elementSymbolFromNumber(n) + string);
        }
        n = 4;
        while (--n >= 0) {
            string = "@" + Elements.altElementNameFromIndex(n) + " _e=" + Elements.altElementNumberFromIndex(n);
            this.defineAtomSet(string);
        }
        n = Elements.altElementMax;
        while (--n >= 4) {
            int n2;
            int n3 = Elements.altElementNumberFromIndex(n);
            String string2 = " _e=" + n3;
            String string3 = "@_" + Elements.altElementSymbolFromIndex(n);
            this.defineAtomSet(string3 + string2);
            string3 = "@_" + Elements.altIsotopeSymbolFromIndex(n);
            this.defineAtomSet(string3 + string2);
            string3 = "@_" + Elements.altIsotopeSymbolFromIndex2(n);
            this.defineAtomSet(string3 + string2);
            string3 = "@" + Elements.altElementNameFromIndex(n);
            if (string3.length() > 1) {
                this.defineAtomSet(string3 + string2);
            }
            if ((n3 = Elements.getNaturalIsotope(n2 = Elements.getElementNumber(n3))) <= 0) continue;
            string2 = Elements.elementSymbolFromNumber(n2);
            this.defineAtomSet("@_" + string2 + n3 + " _e=" + n2);
            this.defineAtomSet("@_" + n3 + string2 + " _e=" + n2);
        }
        this.defineAtomSet("# variable");
    }

    private void defineAtomSet(String string) {
        if (string.indexOf("#") == 0) {
            this.definedAtomSets.put(string, Boolean.TRUE);
            return;
        }
        ScriptContext scriptContext = this.compiler.compile("#predefine", string, true, false, false, false);
        if (scriptContext.errorType != null) {
            this.viewer.scriptStatus("JmolConstants.java ERROR: predefined set compile error:" + string + "\ncompile error:" + scriptContext.errorMessageUntranslated);
            return;
        }
        if (scriptContext.aatoken.length != 1) {
            this.viewer.scriptStatus("JmolConstants.java ERROR: predefinition does not have exactly 1 command:" + string);
            return;
        }
        T[] tArray = scriptContext.aatoken[0];
        if (tArray.length <= 2) {
            this.viewer.scriptStatus("JmolConstants.java ERROR: bad predefinition length:" + string);
            return;
        }
        int n = tArray[1].tok;
        if (!T.tokAttr(n, 0x40000000) && !T.tokAttr(n, 0x300000)) {
            this.viewer.scriptStatus("JmolConstants.java ERROR: invalid variable name:" + string);
            return;
        }
        String string2 = ((String)tArray[1].value).toLowerCase();
        if (string2.startsWith("dynamic_")) {
            string2 = "!" + string2.substring(8);
        }
        this.definedAtomSets.put(string2, tArray);
    }

    public BS lookupIdentifierValue(String string) throws ScriptException {
        BS bS = this.lookupValue(string, false);
        if (bS != null) {
            return BSUtil.copy(bS);
        }
        bS = this.getAtomBits(0x40000000, string);
        return bS == null ? new BS() : bS;
    }

    private BS lookupValue(String string, boolean bl) throws ScriptException {
        if (this.chk) {
            return new BS();
        }
        this.defineSets();
        string = string.toLowerCase();
        Object object = this.definedAtomSets.get(string);
        boolean bl2 = false;
        if (object == null) {
            object = this.definedAtomSets.get("!" + string);
            boolean bl3 = bl2 = object != null;
        }
        if (object instanceof BS) {
            return (BS)object;
        }
        if (object instanceof T[]) {
            this.pushContext(null, "lookupValue");
            BS bS = this.atomExpression((T[])object, -2, 0, true, false, true, true);
            this.popContext(false, false);
            if (!bl2) {
                this.definedAtomSets.put(string, bS);
            }
            return bS;
        }
        if (bl) {
            return null;
        }
        int n = string.length();
        if (n < 5) {
            return null;
        }
        if (string.charAt(n - 1) != 's') {
            return null;
        }
        string = string.endsWith("ies") ? string.substring(0, n - 3) + 'y' : string.substring(0, n - 1);
        return this.lookupValue(string, true);
    }

    @Override
    public void deleteAtomsInVariables(BS bS) {
        for (Map.Entry<String, Object> entry : this.definedAtomSets.entrySet()) {
            Object object = entry.getValue();
            if (!(object instanceof BS)) continue;
            BSUtil.deleteBits((BS)object, bS);
            if (entry.getKey().startsWith("!")) continue;
            this.viewer.setUserVariable("@" + entry.getKey(), SV.newV(10, object));
        }
    }

    private boolean setStatement(int n) throws ScriptException {
        int n2;
        this.st = this.aatoken[n];
        this.slen = this.st.length;
        if (this.slen == 0) {
            return true;
        }
        for (n2 = 1; n2 < this.slen; ++n2) {
            if (this.st[n2] == null) {
                this.slen = n2;
                return true;
            }
            if (this.st[n2].tok == 1060866) break;
        }
        if (n2 == this.slen) {
            return n2 == this.slen;
        }
        switch (this.st[0].tok) {
            case 102436: 
            case 135368713: 
            case 0x40000000: {
                if (this.tokAt(1) != 0x10100010) break;
                return true;
            }
        }
        T[] tArray = new T[this.slen];
        tArray[0] = this.st[0];
        boolean bl = false;
        int n3 = 1;
        for (n2 = 1; n2 < this.slen; ++n2) {
            if (this.st[n2] == null) continue;
            int n4 = this.getToken((int)n2).tok;
            switch (n4) {
                default: {
                    tArray[n3] = this.st[n2];
                    break;
                }
                case 0x100001: 
                case 0x100002: {
                    bl = n4 == 0x100001;
                    tArray[n3] = this.st[n2];
                    break;
                }
                case 1060866: {
                    Object object;
                    Object object2;
                    boolean bl2;
                    if (++n2 == this.slen) {
                        this.invArg();
                    }
                    boolean bl3 = this.theToken.intValue == 4;
                    String string = this.parameterAsString(n2);
                    boolean bl4 = this.tokAt(n2) == 0x100001;
                    boolean bl5 = bl2 = n3 == 1 && this.st[0] == T.tokenSetCmd;
                    if (bl4) {
                        object2 = this.parameterExpressionToken(++n2);
                        n2 = this.iToken;
                        object = ((SV)object2).tok == 7 ? object2 : SV.oValue((SV)object2);
                    } else {
                        object = this.tokAt(n2) == 2 ? this.viewer.getAtomBits(1095763969, this.st[n2].intValue) : this.getParameter(string, 0);
                        if (!bl && !bl2) {
                            bl4 = true;
                        }
                    }
                    n4 = this.tokAt(0);
                    bl3 |= T.tokAttr(n4, 20480) || n4 == 135271429;
                    if (object instanceof SV) {
                        tArray[n3] = (T)object;
                        if (bl && tArray[n3].tok == 7) {
                            object2 = SV.getBitSet((SV)object, true);
                            tArray[n3] = SV.newV(10, object2 == null ? this.getAtomBitSet(SV.sValue(tArray[n3])) : object2);
                        }
                    } else if (object instanceof Boolean) {
                        tArray[n3] = (Boolean)object != false ? T.tokenOn : T.tokenOff;
                    } else if (object instanceof Integer) {
                        tArray[n3] = T.tv(2, (Integer)object, object);
                    } else if (object instanceof Float) {
                        tArray[n3] = T.tv(3, ScriptEvaluator.getFloatEncodedInt("" + object), object);
                    } else if (object instanceof String) {
                        if (!bl3) {
                            if ((n4 != 1085443 || n3 > 1 && this.st[1].tok != 537022465) && T.tokAttr(n4, 36864)) {
                                object = this.getParameter((String)object, 1073742190);
                            }
                            if (object instanceof String) {
                                object = this.getStringObjectAsVariable((String)object, null);
                            }
                        }
                        if (object instanceof SV) {
                            tArray[n3] = (T)object;
                        } else {
                            String string2 = (String)object;
                            if (bl && !bl3) {
                                tArray[n3] = T.o(10, this.getAtomBitSet(string2));
                            } else {
                                n4 = bl2 ? T.getTokFromName(string2) : (bl4 || bl3 || string2.length() == 0 || string2.indexOf(".") >= 0 || string2.indexOf(" ") >= 0 || string2.indexOf("=") >= 0 || string2.indexOf(";") >= 0 || string2.indexOf("[") >= 0 || string2.indexOf("{") >= 0 ? 4 : 0x40000000);
                                tArray[n3] = T.o(n4, object);
                            }
                        }
                    } else if (object instanceof BS) {
                        tArray[n3] = SV.newV(10, object);
                    } else if (object instanceof P3) {
                        tArray[n3] = SV.newV(8, object);
                    } else if (object instanceof P4) {
                        tArray[n3] = SV.newV(9, object);
                    } else if (object instanceof M3) {
                        tArray[n3] = SV.newV(11, object);
                    } else if (object instanceof M4) {
                        tArray[n3] = SV.newV(12, object);
                    } else if (object instanceof Map) {
                        tArray[n3] = SV.newV(6, object);
                    } else if (object instanceof List) {
                        object2 = (List)object;
                        BS bS = null;
                        for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
                            SV sV = (SV)((ArrayList)object2).get(i);
                            if (sV.tok != 10) {
                                bS = null;
                                break;
                            }
                            if (bS == null) {
                                bS = new BS();
                            }
                            bS.or((BS)sV.value);
                        }
                        tArray[n3] = bS == null ? SV.getVariable(object) : T.o(10, bS);
                    } else {
                        object2 = this.getObjectCenter(string, Integer.MIN_VALUE, Integer.MIN_VALUE);
                        if (object2 == null) {
                            this.invArg();
                        }
                        tArray[n3] = T.o(8, object2);
                    }
                    if (!bl2 || T.tokAttr(tArray[n3].tok, 0x20000000)) break;
                    this.invArg();
                }
            }
            ++n3;
        }
        this.st = tArray;
        for (n2 = n3; n2 < this.st.length; ++n2) {
            this.st[n2] = null;
        }
        this.slen = n3;
        return true;
    }

    private void clearState(boolean bl) {
        this.thisContext = null;
        this.scriptLevel = 0;
        this.setErrorMessage(null);
        this.contextPath = "";
        this.tQuiet = bl;
    }

    @Override
    public ScriptContext getThisContext() {
        return this.thisContext;
    }

    @Override
    public void pushContextDown(String string) {
        --this.scriptLevel;
        this.pushContext2(null, string);
    }

    private void pushContext(ContextToken contextToken, String string) throws ScriptException {
        if (this.scriptLevel == 100) {
            this.error(44);
        }
        this.pushContext2(contextToken, string);
    }

    private void pushContext2(ContextToken contextToken, String string) {
        this.thisContext = this.getScriptContext(string);
        this.thisContext.token = contextToken;
        if (contextToken == null) {
            this.scriptLevel = ++this.thisContext.scriptLevel;
        } else {
            this.thisContext.scriptLevel = -1;
            this.contextVariables = new Hashtable<String, SV>();
            if (contextToken.contextVariables != null) {
                for (String string2 : contextToken.contextVariables.keySet()) {
                    ScriptCompiler.addContextVariable(this.contextVariables, string2);
                }
            }
        }
        if (this.debugScript || this.isCmdLine_c_or_C_Option) {
            Logger.info("-->>-------------".substring(0, Math.max(17, this.scriptLevel + 5)) + this.scriptLevel + " " + this.scriptFileName + " " + contextToken + " " + this.thisContext.id);
        }
    }

    @Override
    public ScriptContext getScriptContext(String string) {
        ScriptContext scriptContext = new ScriptContext();
        if (this.debugScript) {
            Logger.info("creating context " + scriptContext.id + " for " + string);
        }
        scriptContext.scriptLevel = this.scriptLevel;
        scriptContext.parentContext = this.thisContext;
        scriptContext.contextPath = this.contextPath;
        scriptContext.scriptFileName = this.scriptFileName;
        scriptContext.parallelProcessor = this.parallelProcessor;
        scriptContext.functionName = this.functionName;
        scriptContext.script = this.script;
        scriptContext.lineNumbers = this.lineNumbers;
        scriptContext.lineIndices = this.lineIndices;
        scriptContext.aatoken = this.aatoken;
        scriptContext.statement = this.st;
        scriptContext.statementLength = this.slen;
        scriptContext.pc = this.pc;
        scriptContext.lineEnd = this.lineEnd;
        scriptContext.pcEnd = this.pcEnd;
        scriptContext.iToken = this.iToken;
        scriptContext.theToken = this.theToken;
        scriptContext.theTok = this.theTok;
        scriptContext.outputBuffer = this.outputBuffer;
        scriptContext.contextVariables = this.contextVariables;
        scriptContext.isStateScript = this.isStateScript;
        scriptContext.errorMessage = this.errorMessage;
        scriptContext.errorType = this.errorType;
        scriptContext.iCommandError = this.iCommandError;
        scriptContext.chk = this.chk;
        scriptContext.executionStepping = this.executionStepping;
        scriptContext.executionPaused = this.executionPaused;
        scriptContext.scriptExtensions = this.scriptExtensions;
        scriptContext.mustResumeEval = this.mustResumeEval;
        scriptContext.allowJSThreads = this.allowJSThreads;
        return scriptContext;
    }

    void popContext(boolean bl, boolean bl2) {
        if (this.thisContext == null) {
            return;
        }
        if (this.thisContext.scriptLevel > 0) {
            this.scriptLevel = this.thisContext.scriptLevel - 1;
        }
        ScriptContext scriptContext = bl ? this.getScriptContext("popFlow") : null;
        this.restoreScriptContext(this.thisContext, true, bl, bl2);
        if (scriptContext != null) {
            this.restoreScriptContext(scriptContext, true, false, true);
        }
        if (this.debugScript || this.isCmdLine_c_or_C_Option) {
            Logger.info("--<<-------------".substring(0, Math.max(17, this.scriptLevel + 5)) + this.scriptLevel + " " + this.scriptFileName + " " + (this.thisContext == null ? "" : "" + this.thisContext.id));
        }
    }

    public void restoreScriptContext(ScriptContext scriptContext, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = this.executing = !this.chk;
        if (scriptContext == null) {
            return;
        }
        if (this.debugScript || this.isCmdLine_c_or_C_Option) {
            Logger.info("--<<-------------".substring(0, Math.max(17, this.scriptLevel + 5)) + this.scriptLevel + " " + this.scriptFileName + " isPop " + bl + " " + scriptContext.id);
        }
        if (!bl2) {
            this.st = scriptContext.statement;
            this.slen = scriptContext.statementLength;
            this.pc = scriptContext.pc;
            this.lineEnd = scriptContext.lineEnd;
            this.pcEnd = scriptContext.pcEnd;
            if (bl3) {
                return;
            }
        }
        this.mustResumeEval = scriptContext.mustResumeEval;
        this.script = scriptContext.script;
        this.lineNumbers = scriptContext.lineNumbers;
        this.lineIndices = scriptContext.lineIndices;
        this.aatoken = scriptContext.aatoken;
        this.contextVariables = scriptContext.contextVariables;
        this.scriptExtensions = scriptContext.scriptExtensions;
        if (bl) {
            this.contextPath = scriptContext.contextPath;
            this.scriptFileName = scriptContext.scriptFileName;
            this.parallelProcessor = scriptContext.parallelProcessor;
            this.functionName = scriptContext.functionName;
            this.iToken = scriptContext.iToken;
            this.theToken = scriptContext.theToken;
            this.theTok = scriptContext.theTok;
            this.outputBuffer = scriptContext.outputBuffer;
            this.isStateScript = scriptContext.isStateScript;
            this.thisContext = scriptContext.parentContext;
            this.allowJSThreads = scriptContext.allowJSThreads;
        } else {
            this.error = scriptContext.errorType != null;
            this.errorMessage = scriptContext.errorMessage;
            this.errorMessageUntranslated = scriptContext.errorMessageUntranslated;
            this.iCommandError = scriptContext.iCommandError;
            this.errorType = scriptContext.errorType;
        }
    }

    public int getLinenumber(ScriptContext scriptContext) {
        return scriptContext == null ? this.lineNumbers[this.pc] : scriptContext.lineNumbers[scriptContext.pc];
    }

    @Override
    public void setException(ScriptException scriptException, String string, String string2) {
        scriptException.untranslated = string2 == null ? string : string2;
        this.errorType = string;
        this.iCommandError = this.pc;
        if (scriptException.message == null) {
            scriptException.message = "";
            return;
        }
        String string3 = ScriptEvaluator.getContextTrace(this.viewer, this.getScriptContext("setException"), null, true).toString();
        while (this.thisContext != null && !this.thisContext.isTryCatch) {
            this.popContext(false, false);
        }
        scriptException.message = scriptException.message + string3;
        scriptException.untranslated = scriptException.untranslated + string3;
        if (this.thisContext != null || this.chk || string.indexOf("NOTE: file recognized as a script file: ") >= 0) {
            return;
        }
        Logger.error("eval ERROR: " + this.toString());
        if (this.viewer.autoExit) {
            this.viewer.exitJmol();
        }
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public String getErrorMessageUntranslated() {
        return this.errorMessageUntranslated == null ? this.errorMessage : this.errorMessageUntranslated;
    }

    private void setErrorMessage(String string) {
        this.errorMessageUntranslated = null;
        if (string == null) {
            this.error = false;
            this.errorType = null;
            this.errorMessage = null;
            this.iCommandError = -1;
            return;
        }
        this.error = true;
        if (this.errorMessage == null) {
            this.errorMessage = GT._("script ERROR: ");
        }
        this.errorMessage = this.errorMessage + string;
    }

    private void planeExpected() throws ScriptException {
        this.errorMore(38, "{a b c d}", "\"xy\" \"xz\" \"yz\" \"x=...\" \"y=...\" \"z=...\"", "$xxxxx");
    }

    public void integerOutOfRange(int n, int n2) throws ScriptException {
        this.errorStr2(21, "" + n, "" + n2);
    }

    private void numberOutOfRange(float f, float f2) throws ScriptException {
        this.errorStr2(36, "" + f, "" + f2);
    }

    void errorAt(int n, int n2) throws ScriptException {
        this.iToken = n2;
        this.errorOrWarn(n, null, null, null, false);
    }

    private void invArg() throws ScriptException {
        this.error(22);
    }

    public void error(int n) throws ScriptException {
        this.errorOrWarn(n, null, null, null, false);
    }

    public void errorStr(int n, String string) throws ScriptException {
        this.errorOrWarn(n, string, null, null, false);
    }

    public void errorStr2(int n, String string, String string2) throws ScriptException {
        this.errorOrWarn(n, string, string2, null, false);
    }

    void errorMore(int n, String string, String string2, String string3) throws ScriptException {
        this.errorOrWarn(n, string, string2, string3, false);
    }

    private void warning(int n, String string, String string2) throws ScriptException {
        this.errorOrWarn(n, string, string2, null, true);
    }

    void errorOrWarn(int n, String string, String string2, String string3, boolean bl) throws ScriptException {
        String string4;
        String string5 = this.ignoreError ? null : ScriptEvaluator.errorString(n, string, string2, string3, true);
        String string6 = string4 = !this.ignoreError && GT.getDoTranslate() ? ScriptEvaluator.errorString(n, string, string2, string3, false) : null;
        if (!bl) {
            this.evalError(string5, string4);
        }
        this.showString(string5);
    }

    public void evalError(String string, String string2) throws ScriptException {
        if (this.ignoreError) {
            throw new NullPointerException();
        }
        if (!this.chk) {
            this.setCursorWait(false);
            this.viewer.setBooleanProperty("refreshing", true);
            this.viewer.setStringProperty("_errormessage", string2);
        }
        throw new ScriptException(this, string, string2, true);
    }

    static String errorString(int n, String string, String string2, String string3, boolean bl) {
        String string4;
        boolean bl2 = false;
        if (!bl && (bl2 = GT.getDoTranslate())) {
            GT.setDoTranslate(false);
        }
        switch (n) {
            default: {
                string4 = "Unknown error message number: " + n;
                break;
            }
            case 0: {
                string4 = GT._("x y z axis expected");
                break;
            }
            case 1: {
                string4 = GT._("{0} not allowed with background model displayed");
                break;
            }
            case 2: {
                string4 = GT._("bad argument count");
                break;
            }
            case 3: {
                string4 = GT._("Miller indices cannot all be zero.");
                break;
            }
            case 4: {
                string4 = GT._("bad [R,G,B] color");
                break;
            }
            case 5: {
                string4 = GT._("boolean expected");
                break;
            }
            case 6: {
                string4 = GT._("boolean or number expected");
                break;
            }
            case 7: {
                string4 = GT._("boolean, number, or {0} expected");
                break;
            }
            case 56: {
                string4 = GT._("cannot set value");
                break;
            }
            case 8: {
                string4 = GT._("color expected");
                break;
            }
            case 9: {
                string4 = GT._("a color or palette name (Jmol, Rasmol) is required");
                break;
            }
            case 10: {
                string4 = GT._("command expected");
                break;
            }
            case 11: {
                string4 = GT._("{x y z} or $name or (atom expression) required");
                break;
            }
            case 12: {
                string4 = GT._("draw object not defined");
                break;
            }
            case 13: {
                string4 = GT._("unexpected end of script command");
                break;
            }
            case 14: {
                string4 = GT._("valid (atom expression) expected");
                break;
            }
            case 15: {
                string4 = GT._("(atom expression) or integer expected");
                break;
            }
            case 16: {
                string4 = GT._("filename expected");
                break;
            }
            case 17: {
                string4 = GT._("file not found");
                break;
            }
            case 18: {
                string4 = GT._("incompatible arguments");
                break;
            }
            case 19: {
                string4 = GT._("insufficient arguments");
                break;
            }
            case 20: {
                string4 = GT._("integer expected");
                break;
            }
            case 21: {
                string4 = GT._("integer out of range ({0} - {1})");
                break;
            }
            case 22: {
                string4 = GT._("invalid argument");
                break;
            }
            case 23: {
                string4 = GT._("invalid parameter order");
                break;
            }
            case 24: {
                string4 = GT._("keyword expected");
                break;
            }
            case 25: {
                string4 = GT._("no MO coefficient data available");
                break;
            }
            case 26: {
                string4 = GT._("An MO index from 1 to {0} is required");
                break;
            }
            case 27: {
                string4 = GT._("no MO basis/coefficient data available for this frame");
                break;
            }
            case 28: {
                string4 = GT._("no MO occupancy data available");
                break;
            }
            case 29: {
                string4 = GT._("Only one molecular orbital is available in this file");
                break;
            }
            case 30: {
                string4 = GT._("{0} require that only one model be displayed");
                break;
            }
            case 55: {
                string4 = GT._("{0} requires that only one model be loaded");
                break;
            }
            case 31: {
                string4 = GT._("No data available");
                break;
            }
            case 32: {
                string4 = GT._("No partial charges were read from the file; Jmol needs these to render the MEP data.");
                break;
            }
            case 33: {
                string4 = GT._("No unit cell");
                break;
            }
            case 34: {
                string4 = GT._("number expected");
                break;
            }
            case 35: {
                string4 = GT._("number must be ({0} or {1})");
                break;
            }
            case 36: {
                string4 = GT._("decimal number out of range ({0} - {1})");
                break;
            }
            case 37: {
                string4 = GT._("object name expected after '$'");
                break;
            }
            case 38: {
                string4 = GT._("plane expected -- either three points or atom expressions or {0} or {1} or {2}");
                break;
            }
            case 39: {
                string4 = GT._("property name expected");
                break;
            }
            case 40: {
                string4 = GT._("space group {0} was not found.");
                break;
            }
            case 41: {
                string4 = GT._("quoted string expected");
                break;
            }
            case 42: {
                string4 = GT._("quoted string or identifier expected");
                break;
            }
            case 43: {
                string4 = GT._("too many rotation points were specified");
                break;
            }
            case 44: {
                string4 = GT._("too many script levels");
                break;
            }
            case 45: {
                string4 = GT._("unrecognized atom property");
                break;
            }
            case 46: {
                string4 = GT._("unrecognized bond property");
                break;
            }
            case 47: {
                string4 = GT._("unrecognized command");
                break;
            }
            case 48: {
                string4 = GT._("runtime unrecognized expression");
                break;
            }
            case 49: {
                string4 = GT._("unrecognized object");
                break;
            }
            case 50: {
                string4 = GT._("unrecognized {0} parameter");
                break;
            }
            case 51: {
                string4 = GT._("unrecognized {0} parameter in Jmol state script (set anyway)");
                break;
            }
            case 52: {
                string4 = GT._("unrecognized SHOW parameter --  use {0}");
                break;
            }
            case 53: {
                string4 = "{0}";
                break;
            }
            case 54: {
                string4 = GT._("write what? {0} or {1} \"filename\"");
            }
        }
        if (string4.indexOf("{0}") < 0) {
            if (string != null) {
                string4 = string4 + ": " + string;
            }
        } else {
            if ((string4 = PT.simpleReplace(string4, "{0}", string)).indexOf("{1}") >= 0) {
                string4 = PT.simpleReplace(string4, "{1}", string2);
            } else if (string2 != null) {
                string4 = string4 + ": " + string2;
            }
            if (string4.indexOf("{2}") >= 0) {
                string4 = PT.simpleReplace(string4, "{2}", string2);
            }
        }
        if (bl2) {
            GT.setDoTranslate(true);
        }
        return string4;
    }

    public static String getErrorLineMessage(String string, String string2, int n, int n2, String string3) {
        String string4 = "\n----";
        if (string2 != null || string != null) {
            string4 = string4 + "line " + n + " command " + (n2 + 1) + " of " + (string == null ? string2 : (string.equals("try") ? "try" : "function " + string)) + ":";
        }
        string4 = string4 + "\n         " + string3;
        return string4;
    }

    public String toString() {
        SB sB = new SB();
        sB.append("Eval\n pc:");
        sB.appendI(this.pc);
        sB.append("\n");
        sB.appendI(this.aatoken.length);
        sB.append(" statements\n");
        for (int i = 0; i < this.aatoken.length; ++i) {
            sB.append("----\n");
            T[] tArray = this.aatoken[i];
            for (int j = 0; j < tArray.length; ++j) {
                sB.appendO(tArray[j]);
                sB.appendC('\n');
            }
            sB.appendC('\n');
        }
        sB.append("END\n");
        return sB.toString();
    }

    public static String statementAsString(Viewer viewer, T[] tArray, int n, boolean bl) {
        if (tArray.length == 0) {
            return "";
        }
        SB sB = new SB();
        int n2 = tArray[0].tok;
        switch (n2) {
            case 0: {
                return (String)tArray[0].value;
            }
            case 0x119009: {
                if (tArray.length != 2 || tArray[1].tok != 135368713 && tArray[1].tok != 102436) break;
                return ((ScriptFunction)tArray[1].value).toString();
            }
        }
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = tArray.length > 1 && n2 == 1085443 && tArray[0].value.equals("") && (tArray[0].intValue == 61 || tArray[0].intValue == 35) && tArray[1].tok != 0x100001;
        int n3 = tArray.length;
        block32: for (int i = 0; i < n3; ++i) {
            T t = tArray[i];
            if (t == null) {
                n3 = i;
                break;
            }
            if (n == i - 1) {
                sB.append(" <<");
            }
            if (i != 0) {
                sB.appendC(' ');
            }
            if (i == 2 && bl5 && ((bl5 = t.tok != 269484436) || tArray[0].intValue == 35)) {
                sB.append(bl5 ? "= " : "== ");
                if (!bl5) continue;
            }
            if (n == i && t.tok != 0x100002) {
                sB.append(">> ");
            }
            switch (t.tok) {
                case 0x100001: {
                    if (!bl2) continue block32;
                    sB.append("{");
                    continue block32;
                }
                case 0x100002: {
                    if (bl4 && i == tArray.length - 1) {
                        bl2 = false;
                    }
                    if (!bl2) continue block32;
                    sB.append("}");
                    continue block32;
                }
                case 0x10100040: 
                case 0x10100041: {
                    break;
                }
                case 0x10000A: 
                case 0x10000E: {
                    bl3 = t.tok == 0x10000A;
                    break;
                }
                case 1060866: {
                    if (i <= 0 || !((String)t.value).equals("define")) break;
                    sB.append("@");
                    if (i + 1 >= tArray.length || tArray[i + 1].tok != 0x100001) continue block32;
                    if (!bl2) {
                        bl4 = true;
                    }
                    bl2 = true;
                    continue block32;
                }
                case 0x10000D: {
                    sB.append("true");
                    continue block32;
                }
                case 0x10000C: {
                    sB.append("false");
                    continue block32;
                }
                case 135280132: {
                    break;
                }
                case 2: {
                    sB.appendI(t.intValue);
                    continue block32;
                }
                case 8: 
                case 9: 
                case 10: {
                    sB.append(SV.sValue(t));
                    continue block32;
                }
                case 6: 
                case 7: {
                    sB.append(((SV)t).escape());
                    continue block32;
                }
                case 5: {
                    sB.appendC('^');
                    continue block32;
                }
                case 1048615: {
                    if (t.intValue != Integer.MAX_VALUE) {
                        sB.appendI(t.intValue);
                    } else {
                        sB.append(Group.getSeqcodeStringFor(ScriptEvaluator.getSeqCode(t)));
                    }
                    t = tArray[++i];
                    sB.appendC(' ');
                    sB.append(bl3 ? "-" : "- ");
                }
                case 1048614: {
                    if (t.intValue != Integer.MAX_VALUE) {
                        sB.appendI(t.intValue);
                        continue block32;
                    }
                    sB.append(Group.getSeqcodeStringFor(ScriptEvaluator.getSeqCode(t)));
                    continue block32;
                }
                case 0x100021: {
                    sB.append("*:");
                    sB.append(viewer.getChainIDStr(t.intValue));
                    continue block32;
                }
                case 0x10001F: {
                    sB.append("*%");
                    if (t.value == null) continue block32;
                    sB.append(t.value.toString());
                    continue block32;
                }
                case 0x100022: {
                    sB.append("*/");
                }
                case 3: 
                case 1048611: {
                    if (t.intValue < Integer.MAX_VALUE) {
                        sB.append(Escape.escapeModelFileNumber(t.intValue));
                        continue block32;
                    }
                    sB.append("" + t.value);
                    continue block32;
                }
                case 1048613: {
                    sB.appendC('[');
                    sB.append(Group.getGroup3For((short)t.intValue));
                    sB.appendC(']');
                    continue block32;
                }
                case 1048612: {
                    sB.appendC('[');
                    sB.appendO(t.value);
                    sB.appendC(']');
                    continue block32;
                }
                case 0x100020: {
                    sB.append("*.");
                    break;
                }
                case 1095761925: {
                    if (!(t.value instanceof P3)) break;
                    P3 p3 = (P3)t.value;
                    sB.append("cell=").append(Escape.eP(p3));
                    continue block32;
                }
                case 4: {
                    sB.append("\"").appendO(t.value).append("\"");
                    continue block32;
                }
                case 0x10100190: 
                case 0x10100191: 
                case 269484434: 
                case 269484435: 
                case 269484436: 
                case 269484438: {
                    if (t.intValue == 1716520985) {
                        sB.append((String)tArray[++i].value).append(" ");
                        break;
                    }
                    if (t.intValue == Integer.MAX_VALUE) break;
                    sB.append(T.nameOf(t.intValue)).append(" ");
                    break;
                }
                case 364558: {
                    continue block32;
                }
                case 0x119009: {
                    sB.append("end");
                    continue block32;
                }
                default: {
                    if (T.tokAttr(t.tok, 0x40000000) || !bl) break;
                    sB.appendC('\n').append(t.toString()).appendC('\n');
                    continue block32;
                }
            }
            if (t.value == null) continue;
            sB.append(t.value.toString());
        }
        if (n >= n3 - 1 && n != 9999) {
            sB.append(" <<");
        }
        return sB.toString();
    }

    public Object getShapeProperty(int n, String string) {
        return this.sm.getShapePropertyIndex(n, string, Integer.MIN_VALUE);
    }

    public boolean getShapePropertyData(int n, String string, Object[] objectArray) {
        return this.sm.getShapePropertyData(n, string, objectArray);
    }

    public void setObjectMad(int n, String string, int n2) {
        if (this.chk) {
            return;
        }
        this.viewer.setObjectMad(n, string, n2);
    }

    private void setObjectArgb(String string, int n) {
        if (this.chk) {
            return;
        }
        this.viewer.setObjectArgb(string, n);
    }

    public void setShapeProperty(int n, String string, Object object) {
        if (!this.chk) {
            this.sm.setShapePropertyBs(n, string, object, null);
        }
    }

    public void setShapePropertyBs(int n, String string, Object object, BS bS) {
        if (!this.chk) {
            this.sm.setShapePropertyBs(n, string, object, bS);
        }
    }

    public void setShapeSizeBs(int n, int n2, BS bS) {
        if (this.chk) {
            return;
        }
        this.sm.setShapeSizeBs(n, n2, null, bS);
    }

    private void setShapeSize(int n, RadiusData radiusData) {
        if (this.chk) {
            return;
        }
        this.sm.setShapeSizeBs(n, 0, radiusData, null);
    }

    public void setBooleanProperty(String string, boolean bl) {
        if (!this.chk) {
            this.viewer.setBooleanProperty(string, bl);
        }
    }

    private boolean setIntProperty(String string, int n) {
        if (!this.chk) {
            this.viewer.setIntProperty(string, n);
        }
        return true;
    }

    private boolean setFloatProperty(String string, float f) {
        if (!this.chk) {
            this.viewer.setFloatProperty(string, f);
        }
        return true;
    }

    private void setStringProperty(String string, String string2) {
        if (!this.chk) {
            this.viewer.setStringProperty(string, string2);
        }
    }

    public void showString(String string) {
        this.showStringPrint(string, false);
    }

    public void showStringPrint(String string, boolean bl) {
        if (this.chk || string == null) {
            return;
        }
        if (this.outputBuffer != null) {
            this.outputBuffer.append(string).appendC('\n');
        } else {
            this.viewer.showString(string, bl);
        }
    }

    public void scriptStatusOrBuffer(String string) {
        if (this.chk) {
            return;
        }
        if (this.outputBuffer != null) {
            this.outputBuffer.append(string).appendC('\n');
            return;
        }
        this.viewer.scriptStatus(string);
    }

    public BS atomExpressionAt(int n) throws ScriptException {
        if (!this.checkToken(n)) {
            this.errorAt(2, n);
        }
        return this.atomExpression(this.st, n, 0, true, false, true, true);
    }

    public BS atomExpression(T[] tArray, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws ScriptException {
        this.isBondSet = false;
        if (tArray != this.st) {
            this.tempStatement = this.st;
            this.st = tArray;
        }
        ScriptMathProcessor scriptMathProcessor = new ScriptMathProcessor(this, false, false, bl3);
        int n3 = Integer.MAX_VALUE;
        boolean bl5 = false;
        this.iToken = 1000;
        boolean bl6 = n < 0;
        boolean bl7 = false;
        int n4 = 0;
        int n5 = this.viewer.getAtomCount();
        if (bl6) {
            n = -n;
        }
        bl6 |= this.chk;
        if (n2 == 0 && tArray.length > n) {
            n2 = n + 1;
        }
        block37: for (int i = n; i < n2; ++i) {
            this.iToken = i;
            T t = tArray[i];
            if (t == null) break;
            Object object = t.value;
            switch (t.tok) {
                case 0x100001: {
                    n = i;
                    n2 = tArray.length;
                    ++n4;
                    continue block37;
                }
                case 0x100002: {
                    if (--n4 <= 0) break block37;
                    continue block37;
                }
                case 0x10000A: {
                    Object object2;
                    if (!this.isPoint3f(i) || (object2 = this.getPoint3f(i, true)) == null) continue block37;
                    scriptMathProcessor.addXPt((P3)object2);
                    i = this.iToken;
                    continue block37;
                }
                case 0x10000E: {
                    if (i <= 0 || tArray[i - 1].tok != 0x10000A) continue block37;
                    scriptMathProcessor.addXBs(new BS());
                    continue block37;
                }
                case 0x10100040: {
                    bl7 = true;
                    scriptMathProcessor.addOp(t);
                    continue block37;
                }
                case 0x10100041: {
                    bl7 = false;
                    scriptMathProcessor.addOp(t);
                    continue block37;
                }
                case 1060866: {
                    scriptMathProcessor.addXBs(this.getAtomBitSet(object));
                    continue block37;
                }
                case 135267841: {
                    scriptMathProcessor.addXVar(SV.newT(t));
                    scriptMathProcessor.addXVar(SV.newV(9, this.hklParameter(i + 2)));
                    i = this.iToken;
                    continue block37;
                }
                case 135266319: {
                    scriptMathProcessor.addXVar(SV.newT(t));
                    scriptMathProcessor.addXVar(SV.newV(9, this.planeParameter(i + 2)));
                    i = this.iToken;
                    continue block37;
                }
                case 0x100006: {
                    scriptMathProcessor.addXVar(SV.newT(t));
                    scriptMathProcessor.addXPt(this.getPoint3f(i + 2, true));
                    i = this.iToken;
                    continue block37;
                }
                case 4: {
                    BS bS;
                    Object object2 = (String)object;
                    if (((String)object2).indexOf("({") == 0 && (bS = Escape.uB((String)object2)) != null) {
                        scriptMathProcessor.addXBs(bS);
                        continue block37;
                    }
                    scriptMathProcessor.addXVar(SV.newT(t));
                    if (!((String)object2).equals("hkl")) continue block37;
                    scriptMathProcessor.addXVar(SV.newV(9, this.hklParameter(i + 2)));
                    i = this.iToken;
                    continue block37;
                }
                case 135266310: 
                case 135266325: 
                case 135267335: 
                case 135267336: 
                case 135402505: 
                case 0x10100030: 
                case 1238369286: {
                    scriptMathProcessor.addOp(t);
                    continue block37;
                }
                case 0x100003: {
                    scriptMathProcessor.addXBs(this.viewer.getAllAtoms());
                    continue block37;
                }
                case 0x10000B: {
                    scriptMathProcessor.addXBs(new BS());
                    continue block37;
                }
                case 0x10000C: 
                case 0x10000D: {
                    scriptMathProcessor.addXVar(SV.newT(t));
                    continue block37;
                }
                case 1114638363: {
                    scriptMathProcessor.addXBs(BSUtil.copy(this.viewer.getSelectionSet(false)));
                    continue block37;
                }
                case 3145770: {
                    scriptMathProcessor.addXBs(BSUtil.copy(this.viewer.getHiddenSet()));
                    continue block37;
                }
                case 1060869: {
                    scriptMathProcessor.addXBs(BSUtil.copy(this.viewer.getMotionFixedAtoms()));
                    continue block37;
                }
                case 3145768: {
                    scriptMathProcessor.addXBs(BSUtil.copyInvert(this.viewer.getHiddenSet(), n5));
                    continue block37;
                }
                case 0x300030: {
                    scriptMathProcessor.addXBs(this.viewer.getBaseModelBitSet());
                    continue block37;
                }
                case 3145774: {
                    if (!this.chk && !bl5) {
                        this.viewer.setModelVisibility();
                    }
                    bl5 = true;
                    scriptMathProcessor.addXBs(this.viewer.getVisibleSet());
                    continue block37;
                }
                case 3145766: {
                    if (!this.chk && bl) {
                        this.refresh();
                    }
                    scriptMathProcessor.addXBs(this.viewer.getClickableSet());
                    continue block37;
                }
                case 0x100020: {
                    if (this.viewer.allowSpecAtom()) {
                        int n6 = t.intValue;
                        if (n6 > 0) {
                            scriptMathProcessor.addXBs(this.compareInt(1095761922, 269484436, n6));
                            continue block37;
                        }
                        scriptMathProcessor.addXBs(this.getAtomBits(t.tok, object));
                        continue block37;
                    }
                    scriptMathProcessor.addXBs(this.lookupIdentifierValue("_" + object));
                    continue block37;
                }
                case 0x100009: 
                case 0x10001F: 
                case 1048612: 
                case 0x300004: 
                case 0x30000E: 
                case 0x300010: 
                case 3145746: 
                case 3145748: 
                case 3145750: 
                case 3145764: 
                case 3145772: 
                case 0x300032: 
                case 1089470478: 
                case 0x60300006: 
                case 1614417948: {
                    scriptMathProcessor.addXBs(this.getAtomBits(t.tok, object));
                    continue block37;
                }
                case 0x100022: 
                case 1048611: {
                    int n7 = t.intValue;
                    if (n7 == Integer.MAX_VALUE && object instanceof Integer) {
                        n7 = (Integer)object;
                        if (!this.viewer.haveFileSet()) {
                            scriptMathProcessor.addXBs(this.getAtomBits(0x100022, n7));
                            continue block37;
                        }
                        if (n7 <= 2147) {
                            n7 *= 1000000;
                        }
                    }
                    scriptMathProcessor.addXBs(this.bitSetForModelFileNumber(n7));
                    continue block37;
                }
                case 0x100021: 
                case 1048613: {
                    scriptMathProcessor.addXBs(this.getAtomBits(t.tok, t.intValue));
                    continue block37;
                }
                case 1048614: {
                    if (bl7) {
                        scriptMathProcessor.addXNum(SV.newI(t.intValue));
                        continue block37;
                    }
                    scriptMathProcessor.addXBs(this.getAtomBits(1048614, ScriptEvaluator.getSeqCode(t)));
                    continue block37;
                }
                case 1048615: {
                    if (bl7) {
                        scriptMathProcessor.addXNum(SV.newI(t.intValue));
                        scriptMathProcessor.addOp(T.tokenMinus);
                        scriptMathProcessor.addXNum(SV.newI(tArray[++i].intValue));
                        continue block37;
                    }
                    int n8 = i + 3 < tArray.length && tArray[i + 2].tok == 0x10100080 && tArray[i + 3].tok == 0x100021 ? tArray[i + 3].intValue : -1;
                    scriptMathProcessor.addXBs(this.getAtomBits(1048615, new int[]{ScriptEvaluator.getSeqCode(t), ScriptEvaluator.getSeqCode(tArray[++i]), n8}));
                    if (n8 == -1) continue block37;
                    i += 2;
                    continue block37;
                }
                case 1095761925: 
                case 1095761926: {
                    P3 p3 = (P3)object;
                    scriptMathProcessor.addXBs(this.getAtomBits(t.tok, new int[]{(int)Math.floor(p3.x * 1000.0f), (int)Math.floor(p3.y * 1000.0f), (int)Math.floor(p3.z * 1000.0f)}));
                    continue block37;
                }
                case 3145758: {
                    scriptMathProcessor.addXBs(this.viewer.getModelUndeletedAtomsBitSet(this.viewer.getCurrentModelIndex()));
                    continue block37;
                }
                case 0x300002: 
                case 0x300007: 
                case 0x300008: 
                case 0x30000A: 
                case 3145754: 
                case 3145756: 
                case 137363468: 
                case 1115297793: 
                case 1613758476: 
                case 1613758488: {
                    scriptMathProcessor.addXBs(this.lookupIdentifierValue((String)object));
                    continue block37;
                }
                case 0x10100190: 
                case 0x10100191: 
                case 269484434: 
                case 269484435: 
                case 269484436: 
                case 269484438: {
                    float[] fArray;
                    boolean bl8;
                    String string;
                    if (i + 1 == tArray.length) {
                        this.invArg();
                    }
                    Object object3 = tArray[++i].value;
                    int n9 = t.tok;
                    int n10 = t.intValue;
                    String string2 = string = n10 == 1716520985 ? (String)object3 : null;
                    if (string != null) {
                        if (i + 1 == tArray.length) {
                            this.invArg();
                        }
                        object3 = tArray[++i].value;
                    }
                    if (n10 == 1095766024 && n9 != 269484436) {
                        this.invArg();
                    }
                    if (this.chk) {
                        scriptMathProcessor.addXBs(new BS());
                        continue block37;
                    }
                    boolean bl9 = n10 == 1095766030;
                    boolean bl10 = T.tokAttr(n10, 1095761920);
                    boolean bl11 = T.tokAttr(n10, 1112539136);
                    boolean bl12 = bl10 && bl11;
                    boolean bl13 = bl8 = !bl10 && T.tokAttr(n10, 0x40D00000);
                    if (n10 == 1087375365) {
                        bl8 = false;
                        bl10 = !false;
                    }
                    int n11 = tArray[i].tok;
                    n3 = tArray[i].intValue;
                    float f = Float.NaN;
                    if (object3 instanceof P3) {
                        if (n10 == 1766856708) {
                            n3 = CU.colorPtToFFRGB((P3)object3);
                            n11 = 2;
                            bl10 = true;
                        }
                    } else if (object3 instanceof String) {
                        if (n10 == 1766856708) {
                            n3 = CU.getArgbFromString((String)object3);
                            if (n3 == 0 && T.tokAttr(n11, 0x40000000)) {
                                n3 = ((String)(object3 = this.getStringParameter((String)object3, true))).startsWith("{") ? ((object3 = Escape.uP((String)object3)) instanceof P3 ? CU.colorPtToFFRGB((P3)object3) : 0) : CU.getArgbFromString((String)object3);
                            }
                            n11 = 2;
                            bl10 = true;
                        } else if (bl8) {
                            if (T.tokAttr(n11, 0x40000000)) {
                                object3 = this.getStringParameter((String)object3, true);
                            }
                        } else {
                            if (T.tokAttr(n11, 0x40000000)) {
                                object3 = this.getNumericParameter((String)object3);
                            }
                            if (object3 instanceof String) {
                                if (n10 == 1641025539 || n10 == 1238369286 || n10 == 1087375365) {
                                    bl10 = n3 != Integer.MAX_VALUE;
                                    bl8 = !bl10;
                                } else {
                                    object3 = SV.nValue(tArray[i]);
                                }
                            }
                            if (object3 instanceof Integer) {
                                n3 = (Integer)object3;
                                f = n3;
                            } else if (object3 instanceof Float && bl9) {
                                n3 = ModelCollection.modelFileNumberFromFloat(((Float)object3).floatValue());
                            }
                        }
                    }
                    if (bl8 && !(object3 instanceof String)) {
                        object3 = "" + object3;
                    }
                    if (object3 instanceof Integer || n11 == 2) {
                        if (bl9) {
                            if (n3 >= 1000000) {
                                n10 = -1095766030;
                            }
                        } else if (bl12) {
                            bl11 = false;
                        } else if (bl11) {
                            f = n3;
                        }
                    } else if (object3 instanceof Float) {
                        if (bl9) {
                            n10 = -1095766030;
                        } else {
                            f = ((Float)object3).floatValue();
                            if (bl12) {
                                bl10 = false;
                            } else if (bl10) {
                                n3 = (int)f;
                            }
                        }
                    } else if (!bl8) {
                        ++this.iToken;
                        this.invArg();
                    }
                    if (bl9 && n3 >= 1000000 && n3 % 1000000 == 0) {
                        n3 /= 1000000;
                        n10 = 1229984263;
                        bl9 = false;
                    }
                    if (n10 == -1095766030 && n9 == 269484436) {
                        scriptMathProcessor.addXBs(this.bitSetForModelFileNumber(n3));
                        continue block37;
                    }
                    if (object != null && ((String)object).indexOf("-") >= 0) {
                        if (bl10) {
                            n3 = -n3;
                        } else if (!Float.isNaN(f)) {
                            f = -f;
                        }
                    }
                    float[] fArray2 = fArray = n10 == 1716520985 ? this.viewer.getDataFloat(string) : null;
                    scriptMathProcessor.addXBs(bl10 ? this.compareInt(n10, n9, n3) : (bl8 ? this.compareString(n10, n9, (String)object3) : this.compareFloatData(n10, fArray, n9, f)));
                    continue block37;
                }
                case 2: 
                case 3: {
                    scriptMathProcessor.addXNum(SV.newT(t));
                    continue block37;
                }
                case 10: {
                    BS bS = BSUtil.copy((BS)object);
                    scriptMathProcessor.addXBs(bS);
                    continue block37;
                }
                case 8: {
                    scriptMathProcessor.addXPt((P3)object);
                    continue block37;
                }
                default: {
                    if (T.tokAttr(t.tok, 0x10100000)) {
                        if (scriptMathProcessor.addOp(t)) continue block37;
                        this.invArg();
                        continue block37;
                    }
                    if (!(object instanceof String)) {
                        scriptMathProcessor.addXObj(object);
                        continue block37;
                    }
                    Object object3 = this.getParameter((String)object, 0);
                    if (bl7) {
                        scriptMathProcessor.addXObj(object3);
                        continue block37;
                    }
                    if (object3 instanceof String) {
                        object3 = this.getStringObjectAsVariable((String)object3, null);
                    }
                    if (object3 instanceof List) {
                        BS bS = SV.unEscapeBitSetArray((List)object3, true);
                        object3 = bS == null ? object : bS;
                    }
                    if (object3 instanceof String) {
                        object3 = this.lookupIdentifierValue((String)object);
                    }
                    scriptMathProcessor.addXObj(object3);
                }
            }
        }
        this.expressionResult = scriptMathProcessor.getResult(bl2);
        if (this.expressionResult == null) {
            if (bl2) {
                return null;
            }
            if (!this.chk) {
                scriptMathProcessor.dumpStacks("after getResult");
            }
            this.error(13);
        }
        this.expressionResult = ((SV)this.expressionResult).value;
        if (this.expressionResult instanceof String && (bl3 || ((String)this.expressionResult).startsWith("({"))) {
            Object object = this.expressionResult = this.chk ? new BS() : this.getAtomBitSet(this.expressionResult);
        }
        if (!bl3 && !(this.expressionResult instanceof BS)) {
            return null;
        }
        BS bS = this.expressionResult instanceof BS ? (BS)this.expressionResult : new BS();
        this.isBondSet = this.expressionResult instanceof BondSet;
        if (!this.isBondSet) {
            this.viewer.excludeAtoms(bS, bl6);
            if (bS.length() > this.viewer.getAtomCount()) {
                bS.clearAll();
            }
        }
        if (this.tempStatement != null) {
            this.st = this.tempStatement;
            this.tempStatement = null;
        }
        return bS;
    }

    private BS compareFloatData(int n, float[] fArray, int n2, float f) {
        BS bS = new BS();
        int n3 = this.viewer.getAtomCount();
        ModelSet modelSet = this.viewer.modelSet;
        Atom[] atomArray = modelSet.atoms;
        float f2 = 0.0f;
        this.viewer.autoCalculate(n);
        int n4 = n3;
        block3: while (--n4 >= 0) {
            boolean bl = false;
            Atom atom = atomArray[n4];
            switch (n) {
                default: {
                    f2 = Atom.atomPropertyFloat(this.viewer, atom, n);
                    break;
                }
                case 1716520985: {
                    if (fArray == null || fArray.length <= n4) continue block3;
                    f2 = fArray[n4];
                }
            }
            if (!(bl = ScriptEvaluator.compareFloat(n2, f2, f))) continue;
            bS.set(n4);
        }
        return bS;
    }

    private BS compareString(int n, int n2, String string) throws ScriptException {
        boolean bl;
        BS bS = new BS();
        Atom[] atomArray = this.viewer.modelSet.atoms;
        int n3 = this.viewer.getAtomCount();
        boolean bl2 = bl = n == 0x40D00004 && this.viewer.getBoolean(603979822);
        if (!bl) {
            string = string.toLowerCase();
        }
        int n4 = n3;
        while (--n4 >= 0) {
            String string2 = Atom.atomPropertyString(this.viewer, atomArray[n4], n);
            if (!bl) {
                string2 = string2.toLowerCase();
            }
            if (!this.compareStringValues(n2, string2, string)) continue;
            bS.set(n4);
        }
        return bS;
    }

    public BS compareInt(int n, int n2, int n3) {
        int n4 = Integer.MAX_VALUE;
        BS bS = null;
        int n5 = n2;
        int n6 = n3;
        int n7 = this.viewer.getAtomCount();
        ModelSet modelSet = this.viewer.modelSet;
        Atom[] atomArray = modelSet.atoms;
        int n8 = -1;
        int n9 = 0;
        int n10 = -1;
        int[] nArray = null;
        int n11 = 0;
        switch (n) {
            case 1297090050: {
                switch (n5) {
                    case 0x10100190: 
                    case 0x10100191: {
                        n8 = Integer.MAX_VALUE;
                    }
                }
                break;
            }
            case 1095761923: {
                try {
                    switch (n2) {
                        case 269484435: {
                            return BSUtil.newBitSet2(0, n3);
                        }
                        case 269484434: {
                            return BSUtil.newBitSet2(0, n3 + 1);
                        }
                        case 0x10100191: {
                            return BSUtil.newBitSet2(n3, n7);
                        }
                        case 0x10100190: {
                            return BSUtil.newBitSet2(n3 + 1, n7);
                        }
                        case 269484436: {
                            return n3 < n7 ? BSUtil.newBitSet2(n3, n3 + 1) : new BS();
                        }
                    }
                    BS bS2 = BSUtil.setAll(n7);
                    if (n3 >= 0) {
                        bS2.clear(n3);
                    }
                    return bS2;
                }
                catch (Exception exception) {
                    return new BS();
                }
            }
        }
        BS bS3 = BSUtil.newBitSet(n7);
        block37: for (int i = 0; i < n7; ++i) {
            boolean bl = false;
            Atom atom = atomArray[i];
            switch (n) {
                default: {
                    n4 = Atom.atomPropertyInt(atom, n);
                    break;
                }
                case 1095766024: {
                    return BSUtil.copy(this.viewer.getConformation(-1, n3 - 1, false));
                }
                case 1297090050: {
                    int n12;
                    bS = atom.getAtomSymmetry();
                    if (bS == null) continue block37;
                    if (atom.getModelIndex() != n10) {
                        n10 = atom.getModelIndex();
                        nArray = modelSet.getModelCellRange(n10);
                        n11 = modelSet.getModelSymmetryCount(n10);
                    }
                    if (n6 >= 200) {
                        if (nArray == null) continue block37;
                        n3 = n6 % 1000;
                        n12 = n6 / 1000 - 1;
                        if (n12 < 0) {
                            bl = true;
                        } else if (n11 == 0 || n12 >= 0 && !(bl = bS.get(n12))) continue block37;
                        n5 = 0x10000B;
                        n4 = n12 < 0 ? atom.getCellTranslation(n3, nArray, n11) : atom.getSymmetryTranslation(n12, nArray, n11);
                    } else if (n11 > 0) {
                        if (n3 > n11 && n5 != 269484435 && n5 != 269484434) continue block37;
                        if (n5 == 269484438) {
                            if (n3 <= 0 || n3 > n11 || bS.get(n3)) continue block37;
                            bS3.set(i);
                            continue block37;
                        }
                    }
                    switch (n5) {
                        case 269484435: {
                            n8 = n3 - 1;
                            break;
                        }
                        case 269484434: {
                            n8 = n3;
                            break;
                        }
                        case 0x10100191: {
                            n9 = n3 - 1;
                            break;
                        }
                        case 0x10100190: {
                            n9 = n3;
                            break;
                        }
                        case 269484436: {
                            n8 = n3;
                            n9 = n3 - 1;
                            break;
                        }
                        case 269484438: {
                            boolean bl2 = bl = !bS.get(n3);
                        }
                    }
                    if (n9 < 0) {
                        n9 = 0;
                    }
                    if (n9 < n8 && (n12 = bS.nextSetBit(n9)) >= 0 && n12 < n8) {
                        bl = true;
                    }
                    if (bl && n4 != Integer.MAX_VALUE) break;
                    n2 = 0x10000B;
                }
            }
            switch (n2) {
                case 0x10000B: {
                    break;
                }
                case 269484435: {
                    bl = n4 < n3;
                    break;
                }
                case 269484434: {
                    bl = n4 <= n3;
                    break;
                }
                case 0x10100191: {
                    bl = n4 >= n3;
                    break;
                }
                case 0x10100190: {
                    bl = n4 > n3;
                    break;
                }
                case 269484436: {
                    bl = n4 == n3;
                    break;
                }
                case 269484438: {
                    boolean bl3 = bl = n4 != n3;
                }
            }
            if (!bl) continue;
            bS3.set(i);
        }
        return bS3;
    }

    private boolean compareStringValues(int n, String string, String string2) throws ScriptException {
        switch (n) {
            case 269484436: 
            case 269484438: {
                return Txt.isMatch(string, string2, true, true) == (n == 269484436);
            }
        }
        this.invArg();
        return false;
    }

    private static boolean compareFloat(int n, float f, float f2) {
        switch (n) {
            case 269484435: {
                return f < f2;
            }
            case 269484434: {
                return f <= f2;
            }
            case 0x10100191: {
                return f >= f2;
            }
            case 0x10100190: {
                return f > f2;
            }
            case 269484436: {
                return f == f2;
            }
            case 269484438: {
                return f != f2;
            }
        }
        return false;
    }

    private BS getAtomBits(int n, Object object) {
        return this.chk ? new BS() : this.viewer.getAtomBits(n, object);
    }

    private static int getSeqCode(T t) {
        return t.intValue == Integer.MAX_VALUE ? (Integer)t.value : Group.getSeqcodeFor(t.intValue, ' ');
    }

    public int checkLast(int n) throws ScriptException {
        return this.checkLength(n + 1) - 1;
    }

    public int checkLength(int n) throws ScriptException {
        if (n >= 0) {
            return this.checkLengthErrorPt(n, 0);
        }
        if (this.slen > -n) {
            this.iToken = -n;
            this.error(2);
        }
        return this.slen;
    }

    private int checkLengthErrorPt(int n, int n2) throws ScriptException {
        if (this.slen != n) {
            this.iToken = n2 > 0 ? n2 : this.slen;
            this.error(n2 > 0 ? 22 : 2);
        }
        return this.slen;
    }

    public int checkLength23() throws ScriptException {
        this.iToken = this.slen;
        if (this.slen != 2 && this.slen != 3) {
            this.error(2);
        }
        return this.slen;
    }

    private int checkLength34() throws ScriptException {
        this.iToken = this.slen;
        if (this.slen != 3 && this.slen != 4) {
            this.error(2);
        }
        return this.slen;
    }

    public T getToken(int n) throws ScriptException {
        if (!this.checkToken(n)) {
            this.error(13);
        }
        this.theToken = this.st[n];
        this.theTok = this.theToken.tok;
        return this.theToken;
    }

    public int tokAt(int n) {
        return n < this.slen && this.st[n] != null ? this.st[n].tok : 0;
    }

    private boolean checkToken(int n) {
        this.iToken = n;
        return this.iToken < this.slen;
    }

    public int modelNumberParameter(int n) throws ScriptException {
        int n2 = 0;
        boolean bl = false;
        switch (this.tokAt(n)) {
            case 2: {
                bl = true;
            }
            case 3: {
                n2 = this.getToken((int)n).intValue;
                break;
            }
            case 4: {
                n2 = ScriptEvaluator.getFloatEncodedInt(this.stringParameter(n));
                break;
            }
            default: {
                this.invArg();
            }
        }
        return this.viewer.getModelNumberIndex(n2, bl, true);
    }

    public String optParameterAsString(int n) throws ScriptException {
        if (n >= this.slen) {
            return "";
        }
        return this.parameterAsString(n);
    }

    public String parameterAsString(int n) throws ScriptException {
        this.getToken(n);
        if (this.theToken == null) {
            this.error(13);
        }
        return SV.sValue(this.theToken);
    }

    public int intParameter(int n) throws ScriptException {
        if (this.checkToken(n) && this.getToken((int)n).tok == 2) {
            return this.theToken.intValue;
        }
        this.error(20);
        return 0;
    }

    public int intParameterRange(int n, int n2, int n3) throws ScriptException {
        int n4 = this.intParameter(n);
        if (n4 < n2 || n4 > n3) {
            this.integerOutOfRange(n2, n3);
        }
        return n4;
    }

    public boolean isFloatParameter(int n) {
        switch (this.tokAt(n)) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    private float floatParameterRange(int n, float f, float f2) throws ScriptException {
        float f3 = this.floatParameter(n);
        if (f3 < f || f3 > f2) {
            this.numberOutOfRange(f, f2);
        }
        return f3;
    }

    public float floatParameter(int n) throws ScriptException {
        if (this.checkToken(n)) {
            this.getToken(n);
            switch (this.theTok) {
                case 1048615: {
                    return -this.theToken.intValue;
                }
                case 2: 
                case 1048614: {
                    return this.theToken.intValue;
                }
                case 3: 
                case 1048611: {
                    return ((Float)this.theToken.value).floatValue();
                }
            }
        }
        this.error(34);
        return 0.0f;
    }

    public List<Object> listParameter(int n, int n2, int n3) throws ScriptException {
        boolean bl;
        List<Object> list = new List<Object>();
        int n4 = this.tokAt(n);
        if (n4 == 1073742195) {
            n4 = this.tokAt(++n);
        }
        boolean bl2 = n4 == 0x10000A;
        boolean bl3 = bl = n4 == 0x10100040;
        if (bl2 || bl) {
            ++n;
        }
        int n5 = 0;
        while (n5 < n3) {
            n4 = this.tokAt(n);
            if (bl2 && n4 == 0x10000E || bl && n4 == 0x10100041) break;
            switch (n4) {
                case 0x10000A: 
                case 0x10000E: 
                case 0x10100030: {
                    break;
                }
                case 4: {
                    break;
                }
                case 8: {
                    P3 p3 = this.getPoint3f(n, false);
                    list.addLast(Float.valueOf(p3.x));
                    list.addLast(Float.valueOf(p3.y));
                    list.addLast(Float.valueOf(p3.z));
                    n5 += 3;
                    break;
                }
                case 9: {
                    P4 p4 = this.getPoint4f(n);
                    list.addLast(Float.valueOf(p4.x));
                    list.addLast(Float.valueOf(p4.y));
                    list.addLast(Float.valueOf(p4.z));
                    list.addLast(Float.valueOf(p4.w));
                    n5 += 4;
                    break;
                }
                default: {
                    list.addLast(Float.valueOf(this.floatParameter(n)));
                    if (++n5 != n3 || !bl || this.tokAt(n + 1) != 0x10000E) break;
                    ++n;
                }
            }
            ++n;
        }
        if (bl2 && this.tokAt(n++) != 0x10000E || bl && this.tokAt(n++) != 0x10100041 || n5 < n2 || n5 > n3) {
            this.invArg();
        }
        this.iToken = n - 1;
        return list;
    }

    public float[] floatParameterSet(int n, int n2, int n3) throws ScriptException {
        List<Object> list = null;
        float[] fArray = null;
        int n4 = 0;
        String string = null;
        this.iToken = n;
        switch (this.tokAt(n)) {
            case 4: {
                string = SV.sValue(this.st[n]);
                string = PT.replaceAllCharacter(string, "{},[]\"'", ' ');
                fArray = PT.parseFloatArray(string);
                n4 = fArray.length;
                break;
            }
            case 7: {
                fArray = SV.flistValue(this.st[n], 0);
                n4 = fArray.length;
                break;
            }
            default: {
                list = this.listParameter(n, n2, n3);
                n4 = list.size();
            }
        }
        if (n4 < n2 || n4 > n3) {
            this.invArg();
        }
        if (fArray == null) {
            fArray = new float[n4];
            for (int i = 0; i < n4; ++i) {
                fArray[i] = ((Float)list.get(i)).floatValue();
            }
        }
        return fArray;
    }

    public boolean isArrayParameter(int n) {
        switch (this.tokAt(n)) {
            case 7: 
            case 11: 
            case 12: 
            case 0x10100040: 
            case 1073742195: {
                return true;
            }
        }
        return false;
    }

    public P3[] getPointArray(int n, int n2) throws ScriptException {
        P3[] p3Array = n2 < 0 ? null : new P3[n2];
        List<P3> list = n2 < 0 ? new List<P3>() : null;
        int n3 = n < 0 ? 7 : this.getToken((int)n++).tok;
        switch (n3) {
            case 7: {
                List<SV> list2 = ((SV)this.theToken).getList();
                if (n2 >= 0 && list2.size() != n2) {
                    this.invArg();
                }
                n2 = list2.size();
                if (p3Array == null) {
                    p3Array = new P3[n2];
                }
                for (int i = 0; i < n2; ++i) {
                    p3Array[i] = SV.ptValue((SV)list2.get(i));
                    if (p3Array[i] != null) continue;
                    this.invArg();
                }
                return p3Array;
            }
            case 1073742195: {
                n3 = this.tokAt(n++);
            }
        }
        if (n3 != 0x10100040) {
            this.invArg();
        }
        int n4 = 0;
        block9: while (n3 != 0x10100041 && n3 != 0) {
            n3 = this.getToken((int)n).tok;
            switch (n3) {
                case 0: 
                case 0x10100041: {
                    continue block9;
                }
                case 0x10100030: {
                    ++n;
                    continue block9;
                }
            }
            if (n2 >= 0 && n4 == n2) {
                n3 = 0;
                continue;
            }
            P3 p3 = this.getPoint3f(n, true);
            if (p3Array == null) {
                list.addLast(p3);
            } else {
                p3Array[n4] = p3;
            }
            ++n4;
            n = this.iToken + 1;
        }
        if (n3 != 0x10100041) {
            this.invArg();
        }
        if (p3Array == null) {
            p3Array = list.toArray(new P3[list.size()]);
        }
        return p3Array;
    }

    public String stringParameter(int n) throws ScriptException {
        if (!this.checkToken(n) || this.getToken((int)n).tok != 4) {
            this.error(41);
        }
        return (String)this.theToken.value;
    }

    public String[] stringParameterSet(int n) throws ScriptException {
        int n2;
        switch (this.tokAt(n)) {
            case 4: {
                Object object;
                String string = this.stringParameter(n);
                if (string.startsWith("[\"") && (object = this.viewer.evaluateExpression(string)) instanceof String) {
                    return PT.split((String)object, "\n");
                }
                return new String[]{string};
            }
            case 1073742195: {
                n += 2;
                break;
            }
            case 0x10100040: {
                ++n;
                break;
            }
            case 7: {
                return SV.listValue(this.getToken(n));
            }
            default: {
                this.invArg();
            }
        }
        List<String> list = new List<String>();
        while ((n2 = this.tokAt(n)) != 0x10100041) {
            switch (n2) {
                case 0x10100030: {
                    break;
                }
                case 4: {
                    list.addLast(this.stringParameter(n));
                    break;
                }
                default: {
                    this.invArg();
                }
            }
            ++n;
        }
        this.iToken = n;
        int n3 = list.size();
        String[] stringArray = new String[n3];
        for (int i = 0; i < n3; ++i) {
            stringArray[i] = (String)list.get(i);
        }
        return stringArray;
    }

    public String objectNameParameter(int n) throws ScriptException {
        if (!this.checkToken(n)) {
            this.error(37);
        }
        return this.parameterAsString(n);
    }

    private boolean booleanParameter(int n) throws ScriptException {
        if (this.slen == n) {
            return true;
        }
        switch (this.getToken((int)this.checkLast((int)n)).tok) {
            case 0x10000D: {
                return true;
            }
            case 0x10000C: {
                return false;
            }
        }
        this.error(5);
        return false;
    }

    private P3 atomCenterOrCoordinateParameter(int n) throws ScriptException {
        switch (this.getToken((int)n).tok) {
            case 10: 
            case 0x100001: {
                BS bS = this.atomExpression(this.st, n, 0, true, false, false, true);
                if (bS != null && bS.cardinality() == 1) {
                    return this.viewer.getAtomPoint3f(bS.nextSetBit(0));
                }
                if (bS != null) {
                    return this.viewer.getAtomSetCenter(bS);
                }
                if (this.expressionResult instanceof P3) {
                    return (P3)this.expressionResult;
                }
                this.invArg();
                break;
            }
            case 8: 
            case 0x10000A: {
                return this.getPoint3f(n, true);
            }
        }
        this.invArg();
        return null;
    }

    public boolean isCenterParameter(int n) {
        int n2 = this.tokAt(n);
        return n2 == 0x100007 || n2 == 0x10000A || n2 == 0x100001 || n2 == 8 || n2 == 10;
    }

    public P3 centerParameter(int n) throws ScriptException {
        return this.centerParameterForModel(n, Integer.MIN_VALUE);
    }

    private P3 centerParameterForModel(int n, int n2) throws ScriptException {
        P3 p3 = null;
        this.expressionResult = null;
        if (this.checkToken(n)) {
            switch (this.getToken((int)n).tok) {
                case 0x100007: {
                    String string = this.objectNameParameter(++n);
                    int n3 = Integer.MIN_VALUE;
                    if (this.tokAt(n + 1) == 0x10100040) {
                        n3 = ((SV)this.parameterExpressionList(-n - 1, -1, true).get(0)).asInt();
                        if (this.getToken((int)(--this.iToken)).tok != 0x10100041) {
                            this.invArg();
                        }
                    }
                    if (this.chk) {
                        return new P3();
                    }
                    if (this.tokAt(n + 1) == 0x100008 && (this.tokAt(n + 2) == 1141899267 || this.tokAt(n + 2) == 1141899270)) {
                        n3 = Integer.MAX_VALUE;
                        this.iToken = n + 2;
                    }
                    if ((p3 = this.getObjectCenter(string, n3, n2)) != null) break;
                    this.errorStr(12, string);
                    break;
                }
                case 8: 
                case 10: 
                case 0x100001: 
                case 0x10000A: {
                    p3 = this.atomCenterOrCoordinateParameter(n);
                }
            }
        }
        if (p3 == null) {
            this.error(11);
        }
        return p3;
    }

    public P4 planeParameter(int n) throws ScriptException {
        boolean bl;
        T4 t4;
        block28: {
            V3 v3 = new V3();
            V3 v32 = new V3();
            t4 = null;
            boolean bl2 = bl = this.tokAt(n) == 0x101000A0;
            if (bl) {
                ++n;
            }
            if (n >= this.slen) break block28;
            switch (this.getToken((int)n).tok) {
                case 9: {
                    t4 = P4.newPt((P4)this.theToken.value);
                    break;
                }
                case 0x100007: {
                    String string = this.objectNameParameter(++n);
                    if (this.chk) {
                        return new P4();
                    }
                    int n2 = this.sm.getShapeIdFromObjectName(string);
                    switch (n2) {
                        case 22: {
                            this.setShapeProperty(22, "thisID", string);
                            P3[] p3Array = (P3[])this.getShapeProperty(22, "vertices");
                            if (p3Array != null && p3Array.length >= 3 && p3Array[0] != null && p3Array[1] != null) {
                                if (p3Array[2] == null) break;
                                t4 = new P4();
                                Measure.getPlaneThroughPoints(p3Array[0], p3Array[1], p3Array[2], new V3(), v3, v32, (P4)t4);
                                break;
                            }
                            break block28;
                        }
                        case 24: {
                            this.setShapeProperty(24, "thisID", string);
                            t4 = (P4)this.getShapeProperty(24, "plane");
                        }
                    }
                    break;
                }
                case 1112541205: {
                    if (!this.checkToken(++n) || this.getToken((int)n++).tok != 269484436) {
                        this.evalError("x=?", null);
                    }
                    t4 = P4.new4(1.0f, 0.0f, 0.0f, -this.floatParameter(n));
                    break;
                }
                case 1112541206: {
                    if (!this.checkToken(++n) || this.getToken((int)n++).tok != 269484436) {
                        this.evalError("y=?", null);
                    }
                    t4 = P4.new4(0.0f, 1.0f, 0.0f, -this.floatParameter(n));
                    break;
                }
                case 1112541207: {
                    if (!this.checkToken(++n) || this.getToken((int)n++).tok != 269484436) {
                        this.evalError("z=?", null);
                    }
                    t4 = P4.new4(0.0f, 0.0f, 1.0f, -this.floatParameter(n));
                    break;
                }
                case 4: 
                case 0x40000000: {
                    String string = this.parameterAsString(n);
                    if (string.equalsIgnoreCase("xy")) {
                        return P4.new4(0.0f, 0.0f, 1.0f, 0.0f);
                    }
                    if (string.equalsIgnoreCase("xz")) {
                        return P4.new4(0.0f, 1.0f, 0.0f, 0.0f);
                    }
                    if (string.equalsIgnoreCase("yz")) {
                        return P4.new4(1.0f, 0.0f, 0.0f, 0.0f);
                    }
                    this.iToken += 2;
                    break;
                }
                case 0x10000A: {
                    if (!this.isPoint3f(n)) {
                        t4 = this.getPoint4f(n);
                        break;
                    }
                }
                case 10: 
                case 0x100001: {
                    P3 p3 = this.atomCenterOrCoordinateParameter(n);
                    if (this.getToken((int)(++this.iToken)).tok == 0x10100030) {
                        ++this.iToken;
                    }
                    P3 p32 = this.atomCenterOrCoordinateParameter(this.iToken);
                    if (this.getToken((int)(++this.iToken)).tok == 0x10100030) {
                        ++this.iToken;
                    }
                    P3 p33 = this.atomCenterOrCoordinateParameter(this.iToken);
                    n = this.iToken;
                    V3 v33 = new V3();
                    float f = Measure.getNormalThroughPoints(p3, p32, p33, v33, v3, v32);
                    t4 = new P4();
                    t4.set(v33.x, v33.y, v33.z, f);
                    if (this.chk || !Logger.debugging) break;
                    Logger.debug("points: " + p3 + p32 + p33 + " defined plane: " + t4);
                }
            }
        }
        if (t4 == null) {
            this.planeExpected();
        }
        if (bl) {
            t4.scale(-1.0f);
        }
        return t4;
    }

    public P4 hklParameter(int n) throws ScriptException {
        P3 p3;
        P4 p4;
        if (!this.chk && this.viewer.getCurrentUnitCell() == null) {
            this.error(33);
        }
        if ((p4 = this.getHklPlane(p3 = (P3)this.getPointOrPlane(n, false, true, false, true, 3, 3))) == null) {
            this.error(3);
        }
        if (!this.chk && Logger.debugging) {
            Logger.debug("defined plane: " + p4);
        }
        return p4;
    }

    public P4 getHklPlane(P3 p3) {
        V3 v3 = new V3();
        V3 v32 = new V3();
        P3 p32 = P3.new3(p3.x == 0.0f ? 1.0f : 1.0f / p3.x, 0.0f, 0.0f);
        P3 p33 = P3.new3(0.0f, p3.y == 0.0f ? 1.0f : 1.0f / p3.y, 0.0f);
        P3 p34 = P3.new3(0.0f, 0.0f, p3.z == 0.0f ? 1.0f : 1.0f / p3.z);
        if (p3.x == 0.0f && p3.y == 0.0f && p3.z == 0.0f) {
            return null;
        }
        if (p3.x == 0.0f && p3.y == 0.0f) {
            p32.set(1.0f, 0.0f, p34.z);
            p33.set(0.0f, 1.0f, p34.z);
        } else if (p3.y == 0.0f && p3.z == 0.0f) {
            p33.set(p32.x, 0.0f, 1.0f);
            p34.set(p32.x, 1.0f, 0.0f);
        } else if (p3.z == 0.0f && p3.x == 0.0f) {
            p34.set(0.0f, p33.y, 1.0f);
            p32.set(1.0f, p33.y, 0.0f);
        } else if (p3.x == 0.0f) {
            p32.set(1.0f, p33.y, 0.0f);
        } else if (p3.y == 0.0f) {
            p33.set(0.0f, 1.0f, p34.z);
        } else if (p3.z == 0.0f) {
            p34.set(p32.x, 0.0f, 1.0f);
        }
        this.viewer.toCartesian(p32, false);
        this.viewer.toCartesian(p33, false);
        this.viewer.toCartesian(p34, false);
        V3 v33 = new V3();
        float f = Measure.getNormalThroughPoints(p32, p33, p34, v33, v3, v32);
        P4 p4 = new P4();
        p4.set(v33.x, v33.y, v33.z, f);
        return p4;
    }

    public int getMadParameter() throws ScriptException {
        int n = 1;
        switch (this.getToken((int)1).tok) {
            case 1073742072: {
                this.restrictSelected(false, false);
                break;
            }
            case 0x10000D: {
                break;
            }
            case 0x10000C: {
                n = 0;
                break;
            }
            case 2: {
                int n2 = this.intParameterRange(1, 0, 750);
                n = n2 * 4 * 2;
                break;
            }
            case 3: {
                n = (int)Math.floor(this.floatParameterRange(1, -3.0f, 3.0f) * 1000.0f * 2.0f);
                if (n >= 0) break;
                this.restrictSelected(false, false);
                n = -n;
                break;
            }
            default: {
                this.error(6);
            }
        }
        return n;
    }

    private int getSetAxesTypeMad(int n) throws ScriptException {
        if (n == this.slen) {
            return 1;
        }
        switch (this.getToken((int)this.checkLast((int)n)).tok) {
            case 0x10000D: {
                return 1;
            }
            case 0x10000C: {
                return 0;
            }
            case 0x40000066: {
                return -1;
            }
            case 2: {
                return this.intParameterRange(n, -1, 19);
            }
            case 3: {
                float f = this.floatParameterRange(n, 0.0f, 2.0f);
                return (int)Math.floor(f * 1000.0f * 2.0f);
            }
        }
        this.errorStr(7, "\"DOTTED\"");
        return 0;
    }

    public boolean isColorParam(int n) {
        int n2 = this.tokAt(n);
        return n2 == 0x22000022 || n2 == 1073742195 || n2 == 0x10100040 || n2 == 7 || n2 == 8 || this.isPoint3f(n) || (n2 == 4 || T.tokAttr(n2, 0x40000000)) && CU.getArgbFromString((String)this.st[n].value) != 0;
    }

    public int getArgbParam(int n) throws ScriptException {
        return this.getArgbParamOrNone(n, false);
    }

    private int getArgbParamLast(int n, boolean bl) throws ScriptException {
        int n2 = this.getArgbParamOrNone(n, bl);
        this.checkLast(this.iToken);
        return n2;
    }

    private int getArgbParamOrNone(int n, boolean bl) throws ScriptException {
        P3 p3 = null;
        if (this.checkToken(n)) {
            switch (this.getToken((int)n).tok) {
                default: {
                    if (!T.tokAttr(this.theTok, 0x40000000)) break;
                }
                case 4: 
                case 0x22000022: {
                    return CU.getArgbFromString(this.parameterAsString(n));
                }
                case 1073742195: {
                    return this.getColorTriad(n + 2);
                }
                case 0x10100040: {
                    return this.getColorTriad(++n);
                }
                case 7: {
                    float[] fArray = SV.flistValue(this.theToken, 3);
                    if (fArray == null || fArray.length == 3) break;
                    p3 = P3.new3(fArray[0], fArray[1], fArray[2]);
                    break;
                }
                case 8: {
                    p3 = (P3)this.theToken.value;
                    break;
                }
                case 0x10000A: {
                    p3 = this.getPoint3f(n, false);
                    break;
                }
                case 0x10000B: {
                    if (!bl) break;
                    return 0;
                }
            }
        }
        if (p3 == null) {
            this.error(8);
        }
        return CU.colorPtToFFRGB(p3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getColorTriad(int n) throws ScriptException {
        P3 p3;
        String string;
        int n2;
        block22: {
            float[] fArray = new float[3];
            n2 = 0;
            string = "";
            this.getToken(n);
            p3 = null;
            float f = 0.0f;
            switch (this.theTok) {
                case 2: 
                case 3: 
                case 1048614: {
                    break;
                }
                case 8: {
                    p3 = (P3)this.theToken.value;
                    break block22;
                }
                case 0x40000000: {
                    string = this.parameterAsString(n);
                    break block22;
                }
                default: {
                    this.error(4);
                    break block22;
                }
            }
            while (n < this.slen) {
                block23: {
                    switch (this.getToken((int)n).tok) {
                        case 0x10100030: {
                            break block23;
                        }
                        case 0x40000000: {
                            if (n2 != 1 || fArray[0] != 0.0f) {
                                this.error(4);
                            }
                            string = "0" + this.parameterAsString(n);
                            break block22;
                        }
                        case 3: {
                            if (n2 > 2) {
                                this.error(4);
                            }
                            f = this.floatParameter(n);
                            break;
                        }
                        case 2: {
                            if (n2 > 2) {
                                this.error(4);
                            }
                            f = this.theToken.intValue;
                            break;
                        }
                        case 1048614: {
                            if (n2 > 2) {
                                this.error(4);
                            }
                            f = (Integer)this.theToken.value % 256;
                            break;
                        }
                        case 0x10100041: {
                            if (n2 != 3) {
                                this.error(4);
                            }
                            --n;
                            p3 = P3.new3(fArray[0], fArray[1], fArray[2]);
                            break block22;
                        }
                        default: {
                            this.error(4);
                        }
                    }
                    fArray[n2++] = f;
                }
                ++n;
            }
            this.error(4);
        }
        if (this.getToken((int)(++n)).tok != 0x10100041) {
            this.error(4);
        }
        if (p3 != null) {
            return CU.colorPtToFFRGB(p3);
        }
        n2 = CU.getArgbFromString("[" + string + "]");
        if (n2 == 0) {
            this.error(4);
        }
        return n2;
    }

    public boolean isPoint3f(int n) {
        boolean bl = this.tokAt(n) == 8;
        if (bl || this.tokAt(n) == 9 || this.isFloatParameter(n + 1) && this.isFloatParameter(n + 2) && this.isFloatParameter(n + 3) && this.isFloatParameter(n + 4)) {
            return bl;
        }
        this.ignoreError = true;
        int n2 = this.iToken;
        bl = true;
        try {
            this.getPoint3f(n, true);
        }
        catch (Exception exception) {
            bl = false;
        }
        this.ignoreError = false;
        this.iToken = n2;
        return bl;
    }

    public P3 getPoint3f(int n, boolean bl) throws ScriptException {
        return (P3)this.getPointOrPlane(n, false, bl, true, false, 3, 3);
    }

    public P4 getPoint4f(int n) throws ScriptException {
        return (P4)this.getPointOrPlane(n, false, false, false, false, 4, 4);
    }

    private Object getPointOrPlane(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2, int n3) throws ScriptException {
        float[] fArray = new float[6];
        int n4 = 0;
        this.coordinatesAreFractional = bl4;
        if (this.tokAt(n) == 8) {
            if (n2 <= 3 && n3 >= 3) {
                return this.getToken((int)n).value;
            }
            this.invArg();
        }
        if (this.tokAt(n) == 9) {
            if (n2 <= 4 && n3 >= 4) {
                return this.getToken((int)n).value;
            }
            this.invArg();
        }
        int n5 = 1;
        block10: for (int i = n; i < this.st.length; ++i) {
            switch (this.getToken((int)i).tok) {
                case 0x10000A: 
                case 0x10100030: 
                case 0x10100060: 
                case 0x10100080: {
                    continue block10;
                }
                case 0x10000E: {
                    break block10;
                }
                case 0x101000A0: {
                    n5 = -1;
                    continue block10;
                }
                case 1048615: {
                    if (n4 == 6) {
                        this.invArg();
                    }
                    fArray[n4++] = this.theToken.intValue;
                    n5 = -1;
                    continue block10;
                }
                case 2: 
                case 1048614: {
                    if (n4 == 6) {
                        this.invArg();
                    }
                    fArray[n4++] = this.theToken.intValue * n5;
                    n5 = 1;
                    continue block10;
                }
                case 0x100022: 
                case 0x101000B0: {
                    if (!bl2) {
                        this.invArg();
                    }
                    if (this.theTok == 0x101000B0) {
                        this.getToken(++i);
                    }
                    if (--n4 < 0 || bl) {
                        this.invArg();
                    }
                    if (this.theToken.value instanceof Integer || this.theTok == 2) {
                        int n6 = n4++;
                        fArray[n6] = fArray[n6] / (float)(this.theToken.intValue == Integer.MAX_VALUE ? (Integer)this.theToken.value : this.theToken.intValue);
                    } else if (this.theToken.value instanceof Float) {
                        int n7 = n4++;
                        fArray[n7] = fArray[n7] / ((Float)this.theToken.value).floatValue();
                    }
                    this.coordinatesAreFractional = true;
                    continue block10;
                }
                case 0x100021: 
                case 0x40000000: {
                    fArray[n4++] = Float.NaN;
                    continue block10;
                }
                case 3: 
                case 1048611: {
                    if (bl) {
                        this.invArg();
                    }
                    if (n4 == 6) {
                        this.invArg();
                    }
                    fArray[n4++] = ((Float)this.theToken.value).floatValue();
                    continue block10;
                }
                default: {
                    this.invArg();
                }
            }
        }
        if (n4 < n2 || n4 > n3) {
            this.invArg();
        }
        if (n4 == 3) {
            P3 p3 = P3.new3(fArray[0], fArray[1], fArray[2]);
            if (this.coordinatesAreFractional && bl3) {
                this.fractionalPoint = P3.newP(p3);
                if (!this.chk) {
                    this.viewer.toCartesian(p3, !this.viewer.getBoolean(603979848));
                }
            }
            return p3;
        }
        if (n4 == 4) {
            if (this.coordinatesAreFractional) {
                this.invArg();
            }
            P4 p4 = P4.new4(fArray[0], fArray[1], fArray[2], fArray[3]);
            return p4;
        }
        return fArray;
    }

    public P3 xypParameter(int n) throws ScriptException {
        boolean bl;
        int n2 = this.tokAt(n);
        if (n2 == 1073742195) {
            n2 = this.tokAt(++n);
        }
        if (n2 != 0x10100040 || !this.isFloatParameter(++n)) {
            return null;
        }
        P3 p3 = new P3();
        p3.x = this.floatParameter(n);
        if (this.tokAt(++n) == 0x10100030) {
            ++n;
        }
        if (!this.isFloatParameter(n)) {
            return null;
        }
        p3.y = this.floatParameter(n);
        boolean bl2 = bl = this.tokAt(++n) == 269484210;
        if (bl) {
            ++n;
        }
        if (this.tokAt(n) != 0x10100041) {
            return null;
        }
        this.iToken = n;
        p3.z = (float)(bl ? -1 : 1) * Float.MAX_VALUE;
        return p3;
    }

    private boolean isCommandDisplayable(int n) {
        if (n >= this.aatoken.length || n >= this.pcEnd || this.aatoken[n] == null) {
            return false;
        }
        return this.lineIndices[n][1] > this.lineIndices[n][0];
    }

    private boolean checkContinue() throws ScriptException {
        if (this.executionStopped) {
            return false;
        }
        if (this.executionStepping && this.isCommandDisplayable(this.pc)) {
            this.viewer.setScriptStatus("Next: " + this.getNextStatement(), "stepping -- type RESUME to continue", 0, null);
            this.executionPaused = true;
        } else if (!this.executionPaused) {
            return true;
        }
        if (Logger.debugging) {
            Logger.debug("script execution paused at command " + (this.pc + 1) + " level " + this.scriptLevel + ": " + this.thisCommand);
        }
        this.refresh();
        while (this.executionPaused) {
            this.viewer.popHoldRepaint("pause \u0001## REPAINT_IGNORE ##");
            String string = this.viewer.getInsertedCommand();
            if (string.length() > 0) {
                this.resumePausedExecution();
                this.setErrorMessage(null);
                ScriptContext scriptContext = this.getScriptContext("script insertion");
                --this.pc;
                try {
                    this.runScript(string);
                }
                catch (Exception exception) {
                    this.setErrorMessage("" + exception);
                }
                catch (Error error) {
                    this.setErrorMessage("" + error);
                }
                if (this.error) {
                    this.scriptStatusOrBuffer(this.errorMessage);
                    this.setErrorMessage(null);
                }
                this.restoreScriptContext(scriptContext, true, false, false);
                this.pauseExecution(false);
            }
            this.doDelay(-100);
            this.viewer.pushHoldRepaintWhy("pause");
        }
        this.notifyResumeStatus();
        return !this.error && !this.executionStopped;
    }

    @Override
    public void notifyResumeStatus() {
        if (!(this.chk || this.executionStopped || this.executionStepping)) {
            this.viewer.scriptStatus("script execution " + (this.error || this.executionStopped ? "interrupted" : "resumed"));
        }
        if (Logger.debugging) {
            Logger.debug("script execution resumed");
        }
    }

    private void doDelay(int n) throws ScriptException {
        if (!this.useThreads()) {
            return;
        }
        if (this.isJS && this.allowJSThreads) {
            throw new ScriptInterruption(this, "delay", n);
        }
        this.delayScript(n);
    }

    public boolean dispatchCommands(boolean bl, boolean bl2) throws ScriptException {
        if (this.sm == null) {
            this.sm = this.viewer.getShapeManager();
        }
        this.logMessages = false;
        this.debugScript = false;
        if (!this.chk) {
            this.setDebugging();
        }
        if (this.pcEnd == 0) {
            this.pcEnd = Integer.MAX_VALUE;
        }
        if (this.lineEnd == 0) {
            this.lineEnd = Integer.MAX_VALUE;
        }
        if (this.aatoken == null) {
            return true;
        }
        this.commandLoop(bl2);
        if (this.chk) {
            return true;
        }
        String string = this.viewer.getInsertedCommand();
        if (!"".equals(string)) {
            this.runScriptBuffer(string, null);
        } else if (bl && this.debugScript && this.viewer.getBoolean(603979880)) {
            this.viewer.scriptStatus("script <exiting>");
        }
        if (!this.isJS || !this.allowJSThreads || bl2) {
            return true;
        }
        if (this.mustResumeEval || this.thisContext == null) {
            boolean bl3 = this.thisContext == null;
            this.resumeEval(this.thisContext);
            this.mustResumeEval = false;
            return bl3;
        }
        return true;
    }

    private void commandLoop(boolean bl) throws ScriptException {
        String string = "";
        boolean bl2 = false;
        List<T[]> list = null;
        long l = System.currentTimeMillis();
        while (this.pc < this.aatoken.length && this.pc < this.pcEnd) {
            block104: {
                block107: {
                    block106: {
                        block105: {
                            block103: {
                                String string2;
                                if (!this.chk && this.isJS && this.useThreads() && !bl) {
                                    if (!this.executionPaused && System.currentTimeMillis() - l > 1000L) {
                                        --this.pc;
                                        this.doDelay(-1);
                                    }
                                    l = System.currentTimeMillis();
                                }
                                if (!this.chk && !this.checkContinue() || this.lineNumbers[this.pc] > this.lineEnd) break;
                                if (this.logMessages) {
                                    long l2 = 0L;
                                    l2 = System.currentTimeMillis();
                                    this.viewer.scriptStatus("Eval.dispatchCommands():" + l2);
                                    this.viewer.scriptStatus(this.script);
                                }
                                if (this.debugScript && !this.chk) {
                                    Logger.info("Command " + this.pc);
                                }
                                T t = this.theToken = this.aatoken[this.pc].length == 0 ? null : this.aatoken[this.pc][0];
                                if (!(this.historyDisabled || this.chk || this.scriptLevel > this.commandHistoryLevelMax || this.tQuiet)) {
                                    String string3 = this.getCommand(this.pc, true, true);
                                    if (!(this.theToken == null || string3.length() <= 0 || string3.equals(string) || this.theToken.tok != 135368713 && this.theToken.tok != 102436 && T.tokAttr(this.theToken.tok, 102400))) {
                                        string = string3;
                                        this.viewer.addCommand(string);
                                    }
                                }
                                if (!this.chk && !"".equals(string2 = this.viewer.getInsertedCommand())) {
                                    this.runScript(string2);
                                }
                                if (this.setStatement(this.pc)) break block103;
                                Logger.info(this.getCommand(this.pc, true, false) + " -- STATEMENT CONTAINING @{} SKIPPED");
                                break block104;
                            }
                            this.thisCommand = this.getCommand(this.pc, false, true);
                            String string4 = this.getCommand(this.pc + 1, false, true);
                            this.fullCommand = this.thisCommand + (string4.startsWith("#") ? string4 : "");
                            this.getToken(0);
                            this.iToken = 0;
                            if ((this.listCommands || !this.chk && this.scriptLevel > 0) && !this.isJS) {
                                int n = this.viewer.getInt(0x2000000A);
                                if (this.listCommands || n > 0) {
                                    if (n > 0) {
                                        this.delayScript(-n);
                                    }
                                    this.viewer.scriptEcho("$[" + this.scriptLevel + "." + this.lineNumbers[this.pc] + "." + (this.pc + 1) + "] " + this.thisCommand);
                                }
                            }
                            if (list == null || this.theTok == 0x119009 && this.slen >= 2 && this.st[1].tok == 102439) break block105;
                            list.addLast(this.st);
                            break block104;
                        }
                        if (!this.chk) break block106;
                        if (this.isCmdLine_c_or_C_Option) {
                            Logger.info(this.thisCommand);
                        }
                        if (this.slen != 1 || this.st[0].tok == 135368713 || this.st[0].tok == 102436) break block107;
                        break block104;
                    }
                    if (this.debugScript) {
                        this.logDebugScript(0);
                    }
                    if (this.scriptLevel == 0 && this.viewer.global.logCommands) {
                        this.viewer.log(this.thisCommand);
                    }
                    if (this.logMessages && this.theToken != null) {
                        Logger.debug(this.theToken.toString());
                    }
                }
                if (this.theToken != null) {
                    if (T.tokAttr(this.theToken.tok, 135168)) {
                        this.processShapeCommand(this.theToken.tok);
                    } else {
                        switch (this.theToken.tok) {
                            case 0: {
                                String string5;
                                if (this.chk || !this.viewer.getBoolean(603979880) || (string5 = (String)this.theToken.value) == null) break;
                                if (this.outputBuffer == null) {
                                    this.viewer.showMessage(string5);
                                }
                                this.scriptStatusOrBuffer(string5);
                                break;
                            }
                            case 1276383749: {
                                this.pushContext((ContextToken)this.theToken, "PUSH");
                                break;
                            }
                            case 1276383249: {
                                this.popContext(true, false);
                                break;
                            }
                            case 0x10100022: {
                                break;
                            }
                            case 20500: 
                            case 528410: {
                                if (this.viewer.isHeadless()) break;
                            }
                            case 102402: 
                            case 102406: 
                            case 102407: 
                            case 102408: 
                            case 102410: 
                            case 102411: 
                            case 102412: 
                            case 102413: 
                            case 364547: 
                            case 364548: 
                            case 0x119009: 
                            case 135369224: 
                            case 135369225: {
                                bl2 = this.flowControl(this.theToken.tok, bl2, list);
                                if (this.theTok != 102439) break;
                                list = null;
                                break;
                            }
                            case 4097: {
                                this.animation();
                                break;
                            }
                            case 4098: {
                                this.assign();
                                break;
                            }
                            case 1610616835: {
                                this.background(1);
                                break;
                            }
                            case 4100: {
                                this.bind();
                                break;
                            }
                            case 4101: {
                                this.bondorder();
                                break;
                            }
                            case 135270423: {
                                this.cache();
                                break;
                            }
                            case 1069064: {
                                this.cd();
                                break;
                            }
                            case 12289: {
                                this.center(1);
                                break;
                            }
                            case 4105: {
                                this.centerAt();
                                break;
                            }
                            case 1766856708: {
                                this.color();
                                break;
                            }
                            case 4106: {
                                this.connect(1);
                                break;
                            }
                            case 528395: {
                                this.console();
                                break;
                            }
                            case 1060866: {
                                this.define();
                                break;
                            }
                            case 528397: {
                                this.delay();
                                break;
                            }
                            case 12291: {
                                this.delete();
                                break;
                            }
                            case 554176526: {
                                this.slab(true);
                                break;
                            }
                            case 1610625028: {
                                this.display(true);
                                break;
                            }
                            case 266255: 
                            case 266281: {
                                if (this.chk) break;
                                if (this.pc > 0 && this.theToken.tok == 266255) {
                                    this.viewer.clearScriptQueue();
                                }
                                this.executionStopped = this.pc > 0 || !this.viewer.global.useScriptQueue;
                                break;
                            }
                            case 266256: {
                                if (this.chk) {
                                    return;
                                }
                                this.viewer.exitJmol();
                                break;
                            }
                            case 1229984263: {
                                this.file();
                                break;
                            }
                            case 1060869: {
                                this.fixed();
                                break;
                            }
                            case 4114: {
                                this.font(-1, 0.0f);
                                break;
                            }
                            case 4115: 
                            case 1095766030: {
                                this.model(1);
                                break;
                            }
                            case 102436: 
                            case 135368713: 
                            case 0x40000000: {
                                this.function();
                                break;
                            }
                            case 135270410: {
                                this.getProperty();
                                break;
                            }
                            case 20482: {
                                this.help();
                                break;
                            }
                            case 12294: {
                                this.display(false);
                                break;
                            }
                            case 1612189718: {
                                this.hbond();
                                break;
                            }
                            case 1610616855: {
                                this.history(1);
                                break;
                            }
                            case 544771: {
                                this.hover();
                                break;
                            }
                            case 266264: {
                                if (this.chk) break;
                                this.viewer.initialize(!this.isStateScript);
                                break;
                            }
                            case 4121: {
                                this.invertSelected();
                                break;
                            }
                            case 135287308: {
                                this.script(135287308, null, null);
                                break;
                            }
                            case 135271426: {
                                this.load();
                                break;
                            }
                            case 36869: {
                                this.log();
                                break;
                            }
                            case 20485: {
                                this.message();
                                break;
                            }
                            case 4128: {
                                this.move();
                                break;
                            }
                            case 4130: {
                                this.moveto();
                                break;
                            }
                            case 20487: {
                                this.pause();
                                break;
                            }
                            case 36865: {
                                this.print();
                                break;
                            }
                            case 102439: {
                                this.pushContext((ContextToken)this.theToken, "PROCESS");
                                if (this.parallelProcessor == null) break;
                                list = new List<T[]>();
                                break;
                            }
                            case 135304707: {
                                this.prompt();
                                break;
                            }
                            case 4139: 
                            case 4165: {
                                this.undoRedoMove();
                                break;
                            }
                            case 266284: {
                                this.refresh();
                                break;
                            }
                            case 4141: {
                                this.reset();
                                break;
                            }
                            case 4142: {
                                this.restore();
                                break;
                            }
                            case 12295: {
                                this.restrict();
                                break;
                            }
                            case 266287: {
                                if (this.chk) break;
                                this.resumePausedExecution();
                                break;
                            }
                            case 36866: {
                                this.returnCmd(null);
                                break;
                            }
                            case 528432: {
                                this.rotate(false, false);
                                break;
                            }
                            case 4145: {
                                this.rotate(false, true);
                                break;
                            }
                            case 4146: {
                                this.save();
                                break;
                            }
                            case 1085443: {
                                this.set();
                                break;
                            }
                            case 135271429: {
                                this.script(135271429, null, null);
                                break;
                            }
                            case 135280132: {
                                this.select(1);
                                break;
                            }
                            case 1611141171: {
                                this.selectionHalo(1);
                                break;
                            }
                            case 554176565: {
                                this.slab(false);
                                break;
                            }
                            case 1611141175: {
                                this.rotate(true, false);
                                break;
                            }
                            case 1611141176: {
                                this.ssbond();
                                break;
                            }
                            case 266298: {
                                if (!this.pause()) break;
                                this.stepPausedExecution();
                                break;
                            }
                            case 528443: {
                                this.stereo();
                                break;
                            }
                            case 1641025539: {
                                this.structure();
                                break;
                            }
                            case 0x303008: {
                                this.subset();
                                break;
                            }
                            case 4156: {
                                this.sync();
                                break;
                            }
                            case 536875070: {
                                this.timeout(1);
                                break;
                            }
                            case 4160: {
                                this.translate(false);
                                break;
                            }
                            case 4162: {
                                this.translate(true);
                                break;
                            }
                            case 4164: {
                                this.unbind();
                                break;
                            }
                            case 4166: {
                                this.vibration();
                                break;
                            }
                            case 1060873: {
                                this.zap(true);
                                break;
                            }
                            case 4168: {
                                this.zoom(false);
                                break;
                            }
                            case 4170: {
                                this.zoom(true);
                                break;
                            }
                            case 4102: 
                            case 4103: 
                            case 4126: 
                            case 4131: 
                            case 4133: 
                            case 4148: 
                            case 0x10101C: 
                            case 1052714: 
                            case 135270405: 
                            case 135270407: 
                            case 135270418: 
                            case 135270422: 
                            case 1095766024: 
                            case 1276121113: {
                                this.getExtension().dispatch(this.theToken.tok, false, this.st);
                                break;
                            }
                            default: {
                                this.error(47);
                            }
                        }
                    }
                    this.setCursorWait(false);
                    if (this.executionStepping) {
                        this.executionPaused = this.isCommandDisplayable(this.pc + 1);
                    }
                }
            }
            ++this.pc;
        }
    }

    private void cache() throws ScriptException {
        int n = this.tokAt(1);
        String string = null;
        int n2 = 2;
        switch (n) {
            case 1073742119: 
            case 1276118017: {
                string = this.optParameterAsString(n2++);
            }
            case 1073741882: {
                int n3;
                this.checkLength(n2);
                if (this.chk) break;
                if ("all".equals(string)) {
                    string = null;
                }
                this.showString((n3 = this.viewer.cacheFileByName(string, n == 1276118017)) < 0 ? "cache cleared" : n3 + " bytes " + (n == 1276118017 ? " cached" : " removed"));
                break;
            }
            default: {
                this.invArg();
            }
        }
    }

    public void setCursorWait(boolean bl) {
        if (!this.chk) {
            this.viewer.setCursor(bl ? 3 : 0);
        }
    }

    private void processShapeCommand(int n) throws ScriptException {
        int n2 = 0;
        switch (n) {
            case 1611272194: {
                n2 = 31;
                break;
            }
            case 1115297793: {
                n2 = 9;
                break;
            }
            case 1679429641: {
                n2 = 32;
                break;
            }
            case 1113200642: {
                n2 = 11;
                break;
            }
            case 135174: {
                n2 = 23;
                break;
            }
            case 135402505: {
                n2 = 25;
                break;
            }
            case 135175: {
                n2 = 17;
                break;
            }
            case 1113198595: {
                n2 = 16;
                break;
            }
            case 135176: {
                n2 = 22;
                break;
            }
            case 537022465: {
                n2 = 30;
                break;
            }
            case 1113198596: {
                n2 = 20;
                break;
            }
            case 1611272202: {
                n2 = 35;
                break;
            }
            case 1113198597: {
                n2 = 19;
                break;
            }
            case 1113200646: {
                n2 = 8;
                break;
            }
            case 135180: {
                n2 = 24;
                break;
            }
            case 1826248715: {
                n2 = 5;
                break;
            }
            case 135182: {
                n2 = 26;
                break;
            }
            case 0x20021010: 
            case 1746538509: {
                n2 = 6;
                break;
            }
            case 1113200647: {
                n2 = 13;
                break;
            }
            case 0x121012: {
                n2 = 27;
                break;
            }
            case 135190: {
                n2 = 29;
                break;
            }
            case 135188: {
                n2 = 28;
                break;
            }
            case 135192: {
                n2 = 21;
                break;
            }
            case 1113200649: {
                n2 = 14;
                break;
            }
            case 1113200650: {
                n2 = 15;
                break;
            }
            case 1113200651: {
                n2 = 0;
                break;
            }
            case 1113200652: {
                n2 = 7;
                break;
            }
            case 1650071565: {
                n2 = 12;
                break;
            }
            case 0x1A101A: {
                n2 = 4;
                break;
            }
            case 1113200654: {
                n2 = 10;
                break;
            }
            case 1614417948: {
                n2 = 33;
                break;
            }
            case 135198: {
                n2 = 18;
                break;
            }
            case 659488: {
                n2 = 1;
                break;
            }
            default: {
                this.error(47);
            }
        }
        if (this.sm.getShape(n2) == null && this.slen == 2) {
            switch (this.st[1].tok) {
                case 12291: 
                case 0x10000B: 
                case 0x10000C: {
                    return;
                }
            }
        }
        switch (n) {
            case 1113200642: 
            case 1113200647: 
            case 1113200649: 
            case 1113200650: 
            case 1113200654: 
            case 1115297793: 
            case 1650071565: {
                this.proteinShape(n2);
                return;
            }
            case 1113198595: 
            case 1113198597: {
                this.dots(n2);
                return;
            }
            case 1113198596: {
                this.ellipsoid();
                return;
            }
            case 1113200646: 
            case 1113200651: 
            case 1113200652: {
                this.setAtomShapeSize(n2, n == 1113200646 ? -1.0f : 1.0f);
                return;
            }
            case 1826248715: {
                this.label(1);
                return;
            }
            case 135198: {
                this.vector();
                return;
            }
            case 659488: {
                this.wireframe();
                return;
            }
        }
        switch (n) {
            case 1611272194: {
                this.axes(1);
                return;
            }
            case 1679429641: {
                this.boundbox(1);
                return;
            }
            case 537022465: {
                this.echo(1, null, false);
                return;
            }
            case 1611272202: {
                this.frank(1);
                return;
            }
            case 1614417948: {
                this.unitcell(1);
                return;
            }
            case 135174: 
            case 135175: 
            case 135176: 
            case 135180: 
            case 135182: 
            case 135188: 
            case 135190: 
            case 135192: 
            case 0x121012: 
            case 0x1A101A: 
            case 135402505: 
            case 0x20021010: 
            case 1746538509: {
                this.getExtension().dispatch(n2, false, this.st);
                return;
            }
        }
    }

    JmolScriptExtension getExtension() {
        JmolScriptExtension jmolScriptExtension;
        if (this.scriptExt == null) {
            this.scriptExt = (JmolScriptExtension)Interface.getOptionInterface("scriptext.ScriptExt");
            jmolScriptExtension = this.scriptExt.init(this);
        } else {
            jmolScriptExtension = this.scriptExt;
        }
        return jmolScriptExtension;
    }

    private boolean flowControl(int n, boolean bl, List<T[]> list) throws ScriptException {
        int n2;
        switch (n) {
            case 20500: {
                this.gotoCmd(this.parameterAsString(this.checkLast(1)));
                return bl;
            }
            case 528410: {
                if (!this.chk) {
                    this.pc = -1;
                }
                this.delay();
                return bl;
            }
        }
        boolean bl2 = n2 < 0 && !this.chk;
        boolean bl3 = true;
        int n3 = 0;
        switch (n) {
            case 102412: {
                ContextToken contextToken = (ContextToken)this.theToken;
                this.pushContext(contextToken, "CATCH");
                if (!bl2 && contextToken.name0 != null) {
                    this.contextVariables.put(contextToken.name0, contextToken.contextVariables.get(contextToken.name0));
                }
                bl3 = !bl2;
                break;
            }
            case 102410: 
            case 102411: 
            case 102413: {
                n3 = Math.abs(this.aatoken[Math.abs((int)n2)][0].intValue);
                switch (bl2 ? 0 : this.switchCmd((ContextToken)this.theToken, n)) {
                    case 0: {
                        n3 = -n3;
                        bl3 = false;
                        break;
                    }
                    case -1: {
                        bl3 = false;
                        break;
                    }
                }
                this.aatoken[this.pc][0].intValue = Math.abs(n2);
                this.theToken = this.aatoken[Math.abs(n2)][0];
                if (this.theToken.tok == 0x119009) break;
                this.theToken.intValue = n3;
                break;
            }
            case 102402: 
            case 135369225: {
                boolean bl4 = bl3 = !bl2 && this.ifCmd();
                if (this.chk) break;
                n3 = Math.abs(this.aatoken[Math.abs((int)n2)][0].intValue);
                this.aatoken[Math.abs((int)n2)][0].intValue = n3 = bl2 || bl3 ? -n3 : n3;
                if (n != 102412) break;
                this.aatoken[this.pc][0].intValue = -n2;
                break;
            }
            case 364547: {
                this.checkLength(1);
                if (n2 >= 0 || this.chk) break;
                this.pc = -n2 - 1;
                break;
            }
            case 364548: {
                this.checkLength(1);
                break;
            }
            case 102406: {
                if (!bl) {
                    this.pushContext((ContextToken)this.theToken, "WHILE");
                }
                bl = false;
                if (this.ifCmd() || this.chk) break;
                this.pc = n2;
                this.popContext(true, false);
                break;
            }
            case 102407: {
                if (!this.chk) {
                    this.breakCmd(n2);
                    break;
                }
                if (this.slen == 1) break;
                int n4 = this.intParameter(this.checkLast(1));
                if (this.chk) break;
                for (int i = 0; i < n4; ++i) {
                    this.popContext(true, false);
                }
                break;
            }
            case 102408: {
                bl = true;
                if (!this.chk) {
                    this.pc = n2 - 1;
                }
                if (this.slen <= 1) break;
                this.intParameter(this.checkLast(1));
                break;
            }
            case 135369224: {
                String string;
                Object object;
                List<SV> list2;
                T t = this.theToken;
                int[] nArray = new int[2];
                int n5 = 0;
                Cloneable cloneable = null;
                int n6 = 0;
                block37: for (int i = 1; i < this.slen && n5 < 2; ++i) {
                    switch (this.tokAt(i)) {
                        case 0x10000F: {
                            if (n6 > 0) {
                                --n6;
                                continue block37;
                            }
                            nArray[n5++] = i;
                            continue block37;
                        }
                        case 1073741980: {
                            n6 -= 2;
                            if (this.tokAt(++i) == 0x100001 || this.tokAt(i) == 10) {
                                cloneable = this.atomExpressionAt(i);
                                if (this.isBondSet) {
                                    cloneable = new BondSet((BS)cloneable);
                                }
                            } else {
                                list2 = this.parameterExpressionList(-i, 1, false);
                                if (list2 == null || list2.size() < 1) {
                                    this.invArg();
                                }
                                object = (SV)list2.get(0);
                                switch (((SV)object).tok) {
                                    case 10: {
                                        cloneable = SV.getBitSet((SV)object, false);
                                        break;
                                    }
                                    case 7: {
                                        cloneable = ((SV)object).getList();
                                        break;
                                    }
                                    default: {
                                        this.invArg();
                                    }
                                }
                            }
                            i = this.iToken;
                            continue block37;
                        }
                        case 135280132: {
                            n6 += 2;
                        }
                    }
                }
                if (bl) {
                    n5 = cloneable == null ? nArray[1] + 1 : 2;
                } else {
                    this.pushContext((ContextToken)t, "FOR");
                    n5 = 2;
                }
                if (this.tokAt(n5) == 36868) {
                    ++n5;
                }
                int n7 = n6 = (string = this.parameterAsString(n5)).equals("--") || string.equals("++") ? 1 : 0;
                if (n6 != 0) {
                    string = this.parameterAsString(++n5);
                }
                list2 = null;
                if (T.tokAttr(this.tokAt(n5), 0x40000000) || (list2 = this.getContextVariableAsVariable(string)) != null) {
                    if (cloneable == null && n6 == 0 && this.getToken((int)(++n5)).tok != 269484436) {
                        this.invArg();
                    }
                    if (cloneable == null) {
                        if (n6 != 0) {
                            n5 -= 2;
                        }
                        this.setVariable(++n5, this.slen - 1, string, 0);
                    } else {
                        bl3 = true;
                        object = string + "_incr";
                        if (list2 == null) {
                            list2 = this.getContextVariableAsVariable((String)object);
                        }
                        if (list2 == null) {
                            if (string.startsWith("_")) {
                                this.invArg();
                            }
                            list2 = this.viewer.getOrSetNewVariable((String)object, true);
                        }
                        if (!bl || ((SV)((Object)list2)).tok != 10 && ((SV)((Object)list2)).tok != 7 || ((SV)((Object)list2)).intValue == Integer.MAX_VALUE) {
                            if (bl) {
                                bl3 = false;
                            } else {
                                ((SV)((Object)list2)).setv(SV.getVariable(cloneable), false);
                                ((SV)((Object)list2)).intValue = 1;
                            }
                        } else {
                            ++((SV)((Object)list2)).intValue;
                        }
                        boolean bl5 = bl3 && (cloneable instanceof BS ? SV.bsSelectVar((SV)((Object)list2)).cardinality() == 1 : ((SV)((Object)list2)).intValue <= ((SV)((Object)list2)).getList().size()) ? true : (bl3 = false);
                        if (bl3) {
                            list2 = SV.selectItemVar((SV)((Object)list2));
                            SV sV = this.getContextVariableAsVariable(string);
                            if (sV == null) {
                                sV = this.viewer.getOrSetNewVariable(string, true);
                            }
                            sV.setv((SV)((Object)list2), false);
                        }
                    }
                }
                if (cloneable == null) {
                    bl3 = this.parameterExpressionBoolean(nArray[0] + 1, nArray[1]);
                }
                ++n2;
                if (!bl3) {
                    this.popContext(true, false);
                }
                bl = false;
                break;
            }
            case 0x119009: {
                switch (this.getToken((int)this.checkLast((int)1)).tok) {
                    case 364558: {
                        ScriptFunction scriptFunction = (ScriptFunction)this.getToken((int)1).value;
                        if (this.chk) {
                            return false;
                        }
                        this.runFunctionRet(scriptFunction, "try", null, null, true, true, true);
                        return false;
                    }
                    case 102412: {
                        this.popContext(true, false);
                        break;
                    }
                    case 102436: 
                    case 135368713: {
                        this.viewer.addFunction((ScriptFunction)this.theToken.value);
                        return bl;
                    }
                    case 102439: {
                        this.addProcess(list, n2, this.pc);
                        this.popContext(true, false);
                        break;
                    }
                    case 102410: {
                        if (n2 <= 0 || this.switchCmd((ContextToken)this.aatoken[n2][0], 0) != -1) break;
                        for (n2 = this.st[0].intValue; n2 < this.pc && ((n = this.aatoken[n2][0].tok) == 102413 || n == 102411); ++n2) {
                        }
                        boolean bl6 = bl3 = this.pc == n2;
                    }
                }
                if (bl3) {
                    bl3 = this.theTok == 102412 || this.theTok == 102439 || this.theTok == 135369225 || this.theTok == 102410;
                }
                boolean bl7 = bl = this.theTok == 135369224 || this.theTok == 102406;
            }
        }
        if (!bl3 && !this.chk) {
            this.pc = Math.abs(n2) - 1;
        }
        return bl;
    }

    private void gotoCmd(String string) throws ScriptException {
        int n;
        int n2;
        int n3 = string == null ? this.aatoken.length - 1 : -1;
        String string2 = null;
        block11: for (n2 = n3 + 1; n2 < this.aatoken.length; ++n2) {
            T[] tArray = this.aatoken[n2];
            n = tArray[0].tok;
            switch (n) {
                case 0: 
                case 20485: {
                    string2 = (String)tArray[tArray.length - 1].value;
                    if (n != 0) break;
                    string2 = string2.substring(string2.startsWith("#") ? 1 : 2);
                    break;
                }
                default: {
                    continue block11;
                }
            }
            if (!string2.equalsIgnoreCase(string)) continue;
            n3 = n2;
            break;
        }
        if (n3 < 0) {
            this.invArg();
        }
        if (string == null) {
            n3 = 0;
        }
        n2 = n3 < this.pc ? 1 : -1;
        int n4 = 0;
        block12: for (n = n3; n != this.pc; n += n2) {
            switch (this.aatoken[n][0].tok) {
                case 102406: 
                case 102412: 
                case 102439: 
                case 135369224: 
                case 1276383749: {
                    ++n4;
                    continue block12;
                }
                case 1276383249: {
                    --n4;
                    continue block12;
                }
                case 0x119009: {
                    switch (this.aatoken[n][1].tok) {
                        case 102406: 
                        case 102412: 
                        case 102439: 
                        case 135369224: {
                            --n4;
                        }
                    }
                }
            }
        }
        if (string == null) {
            n3 = Integer.MAX_VALUE;
            while (n4 > 0) {
                this.popContext(false, false);
                --n4;
            }
        }
        if (n4 != 0) {
            this.invArg();
        }
        if (!this.chk) {
            this.pc = n3 - 1;
        }
    }

    private void breakCmd(int n) {
        if (n < 0) {
            this.getContextVariableAsVariable((String)"_breakval").intValue = -n;
            this.pcEnd = this.pc;
            return;
        }
        this.pc = Math.abs(this.aatoken[n][0].intValue);
        int n2 = this.aatoken[n][0].tok;
        if (n2 == 102411 || n2 == 102413) {
            this.theToken = this.aatoken[this.pc--][0];
            int n3 = Math.abs(this.theToken.intValue);
            if (this.theToken.tok != 0x119009) {
                this.theToken.intValue = -n3;
            }
        } else {
            while (this.thisContext != null && !ScriptCompiler.isBreakableContext(this.thisContext.token.tok)) {
                this.popContext(true, false);
            }
            this.popContext(true, false);
        }
    }

    private void addProcess(List<T[]> list, int n, int n2) {
        if (this.parallelProcessor == null) {
            return;
        }
        T[][] tArrayArray = new T[n2][];
        for (int i = 0; i < list.size(); ++i) {
            tArrayArray[i + 1 - n] = (T[])list.get(i);
        }
        ScriptContext scriptContext = this.getScriptContext("addProcess");
        scriptContext.aatoken = tArrayArray;
        scriptContext.pc = 1 - n;
        scriptContext.pcEnd = n2;
        this.parallelProcessor.addProcess("p" + ++iProcess, scriptContext);
    }

    private int switchCmd(ContextToken contextToken, int n) throws ScriptException {
        SV sV;
        if (n == 102410) {
            contextToken.addName("_var");
        }
        if ((sV = contextToken.contextVariables.get("_var")) == null) {
            return 1;
        }
        if (n == 0) {
            contextToken.contextVariables.remove("_var");
            return -1;
        }
        if (n == 102413) {
            return -1;
        }
        SV sV2 = this.parameterExpressionToken(1);
        if (n == 102411) {
            boolean bl = SV.areEqual(sV, sV2);
            if (bl) {
                contextToken.contextVariables.remove("_var");
            }
            return bl ? 1 : -1;
        }
        contextToken.contextVariables.put("_var", sV2);
        return 1;
    }

    private boolean ifCmd() throws ScriptException {
        return this.parameterExpressionBoolean(1, 0);
    }

    private void returnCmd(SV sV) throws ScriptException {
        SV sV2;
        SV sV3 = this.getContextVariableAsVariable("_retval");
        if (sV3 == null) {
            if (!this.chk) {
                this.gotoCmd(null);
            }
            return;
        }
        SV sV4 = sV2 = sV != null || this.slen == 1 ? null : this.parameterExpressionToken(1);
        if (this.chk) {
            return;
        }
        if (sV == null) {
            sV = sV2 == null ? SV.newI(0) : sV2;
        }
        sV3.value = sV.value;
        sV3.intValue = sV.intValue;
        sV3.tok = sV.tok;
        this.gotoCmd(null);
    }

    private void help() throws ScriptException {
        if (this.chk) {
            return;
        }
        String string = this.optParameterAsString(1).toLowerCase();
        int n = 0;
        if (string.startsWith("mouse") && (n = string.indexOf(" ")) >= 0 && n == string.lastIndexOf(" ")) {
            this.showString(this.viewer.getBindingInfo(string.substring(n + 1)));
            return;
        }
        if (T.tokAttr(T.getTokFromName(string), 4096)) {
            string = "?command=" + string;
        }
        this.viewer.getHelp(string);
    }

    private void move() throws ScriptException {
        int n;
        this.checkLength(-11);
        V3 v3 = V3.new3(this.floatParameter(1), this.floatParameter(2), this.floatParameter(3));
        float f = this.floatParameter(4);
        V3 v32 = V3.new3(this.intParameter(5), this.intParameter(6), this.intParameter(7));
        float f2 = this.floatParameter(8);
        float f3 = this.floatParameter(9);
        int n2 = n = this.slen == 11 ? this.intParameter(10) : 30;
        if (this.chk) {
            return;
        }
        this.refresh();
        if (!this.useThreads()) {
            f3 = 0.0f;
        }
        this.viewer.move(this, v3, f, v32, f2, f3, n);
        if (f3 > 0.0f && this.isJS) {
            throw new ScriptInterruption(this, "move", 1);
        }
    }

    private void moveto() throws ScriptException {
        if (this.slen == 2 && this.tokAt(1) == 1073742162) {
            if (!this.chk) {
                this.viewer.stopMotion();
            }
            return;
        }
        if (this.slen == 2 && this.isFloatParameter(1)) {
            float f = this.floatParameter(1);
            if (this.chk) {
                return;
            }
            if (!this.useThreads()) {
                f = 0.0f;
            }
            if (f > 0.0f) {
                this.refresh();
            }
            this.viewer.moveTo(this, f, null, JC.axisZ, 0.0f, null, 100.0f, 0.0f, 0.0f, 0.0f, null, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN);
            if (this.isJS && f > 0.0f && this.viewer.global.waitForMoveTo) {
                throw new ScriptInterruption(this, "moveTo", 1);
            }
            return;
        }
        V3 v3 = V3.new3(Float.NaN, 0.0f, 0.0f);
        P3 p3 = null;
        int n = 1;
        float f = this.isFloatParameter(n) ? this.floatParameter(n++) : 2.0f;
        float f2 = 90.0f;
        BS bS = null;
        boolean bl = true;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = Float.NaN;
        float f6 = Float.NaN;
        float f7 = this.viewer.getZoomSetting();
        P3 p32 = null;
        float f8 = Float.NaN;
        float f9 = Float.NaN;
        float f10 = Float.NaN;
        float f11 = Float.NaN;
        float f12 = Float.NaN;
        float f13 = Float.NaN;
        float[] fArray = null;
        switch (this.getToken((int)n).tok) {
            case 1073742110: {
                fArray = this.floatParameterSet(++n, 18, 21);
                n = this.iToken + 1;
                if (!this.chk || this.checkLength(n) <= 0) break;
                return;
            }
            case 135270418: {
                Quaternion quaternion;
                boolean bl2 = false;
                if (this.tokAt(++n) == 1073742029) {
                    bl2 = true;
                    ++n;
                }
                if (this.tokAt(n) == 10 || this.tokAt(n) == 0x100001) {
                    bl2 = true;
                    p3 = this.centerParameter(n);
                    if (!(this.expressionResult instanceof BS)) {
                        this.invArg();
                    }
                    bS = (BS)this.expressionResult;
                    quaternion = this.chk ? new Quaternion() : this.viewer.getAtomQuaternion(bS.nextSetBit(0));
                } else {
                    quaternion = this.getQuaternionParameter(n);
                }
                n = this.iToken + 1;
                if (quaternion == null) {
                    this.invArg();
                }
                A4 a4 = quaternion.toAxisAngle4f();
                v3.set(a4.x, a4.y, a4.z);
                f2 = (float)(bl2 ? -1 : 1) * (float)((double)a4.angle * 180.0 / Math.PI);
                break;
            }
            case 8: 
            case 9: 
            case 0x10000A: {
                if (this.isPoint3f(n)) {
                    v3.setT(this.getPoint3f(n, true));
                    n = this.iToken + 1;
                    f2 = this.floatParameter(n++);
                    break;
                }
                P4 p4 = this.getPoint4f(n);
                n = this.iToken + 1;
                v3.set(p4.x, p4.y, p4.z);
                f2 = p4.x == 0.0f && p4.y == 0.0f && p4.z == 0.0f ? Float.NaN : p4.w;
                break;
            }
            case 1073741954: {
                v3.set(1.0f, 0.0f, 0.0f);
                f2 = 0.0f;
                this.checkLength(++n);
                break;
            }
            case 1073741859: {
                v3.set(0.0f, 1.0f, 0.0f);
                f2 = 180.0f;
                this.checkLength(++n);
                break;
            }
            case 1073741996: {
                v3.set(0.0f, 1.0f, 0.0f);
                this.checkLength(++n);
                break;
            }
            case 1073742128: {
                v3.set(0.0f, -1.0f, 0.0f);
                this.checkLength(++n);
                break;
            }
            case 1074790748: {
                v3.set(1.0f, 0.0f, 0.0f);
                this.checkLength(++n);
                break;
            }
            case 1073741871: {
                v3.set(-1.0f, 0.0f, 0.0f);
                this.checkLength(++n);
                break;
            }
            default: {
                v3 = V3.new3(this.floatParameter(n++), this.floatParameter(n++), this.floatParameter(n++));
                f2 = this.floatParameter(n++);
            }
        }
        if (Float.isNaN(v3.x) || Float.isNaN(v3.y) || Float.isNaN(v3.z)) {
            v3.set(0.0f, 0.0f, 0.0f);
        } else if (v3.length() == 0.0f && f2 == 0.0f) {
            f2 = Float.NaN;
        }
        boolean bl3 = bl = !this.viewer.isInPosition(v3, f2);
        if (this.isFloatParameter(n)) {
            f5 = this.floatParameter(n++);
        }
        if (this.isFloatParameter(n) && !this.isCenterParameter(n)) {
            f3 = this.floatParameter(n++);
            f4 = this.floatParameter(n++);
            if (!bl && Math.abs(f3 - this.viewer.getTranslationXPercent()) >= 1.0f) {
                bl = true;
            }
            if (!bl && Math.abs(f4 - this.viewer.getTranslationYPercent()) >= 1.0f) {
                bl = true;
            }
        }
        if (bS == null && n != this.slen) {
            p3 = this.centerParameter(n);
            if (this.expressionResult instanceof BS) {
                bS = (BS)this.expressionResult;
            }
            n = this.iToken + 1;
        }
        if (p3 != null) {
            if (!bl && (double)p3.distance(this.viewer.getRotationCenter()) >= 0.1) {
                bl = true;
            }
            if (this.isFloatParameter(n)) {
                f6 = this.floatParameter(n++);
            }
            if (!this.isCenterParameter(n)) {
                if ((f6 == 0.0f || Float.isNaN(f6)) && (f5 == 0.0f || Float.isNaN(f5))) {
                    float f14 = Math.abs(this.getZoom(0, n, bS, f5 == 0.0f ? 0.0f : f7));
                    n = this.iToken + 1;
                    f5 = f14;
                } else if (!bl && (double)Math.abs(f6 - this.viewer.getFloat(0x2200002C)) >= 0.1) {
                    bl = true;
                }
            }
            if (f5 == 0.0f || Float.isNaN(f5)) {
                f5 = 100.0f;
            }
            if (Float.isNaN(f6)) {
                f6 = 0.0f;
            }
            if (!bl && Math.abs(f5 - f7) >= 1.0f) {
                bl = true;
            }
            if (n != this.slen) {
                p32 = this.centerParameter(n);
                n = this.iToken + 1;
                if (n != this.slen) {
                    f8 = this.floatParameter(n++);
                    f9 = this.floatParameter(n++);
                }
                if (n != this.slen) {
                    f10 = this.floatParameter(n++);
                }
                if (n != this.slen) {
                    f11 = this.floatParameter(n++);
                    if (!bl && Math.abs(f11 - this.viewer.getCameraDepth()) >= 0.01f) {
                        bl = true;
                    }
                }
                if (n + 1 < this.slen) {
                    f12 = this.floatParameter(n++);
                    f13 = this.floatParameter(n++);
                    if (!bl && Math.abs(f12 - this.viewer.getCamera().x) >= 0.01f) {
                        bl = true;
                    }
                    if (!bl && Math.abs(f13 - this.viewer.getCamera().y) >= 0.01f) {
                        bl = true;
                    }
                }
            }
        }
        this.checkLength(n);
        if (this.chk) {
            return;
        }
        if (!bl) {
            f = 0.0f;
        }
        if (f > 0.0f) {
            this.refresh();
        }
        if (!this.useThreads()) {
            f = 0.0f;
        }
        if (f11 == 0.0f) {
            f13 = Float.NaN;
            f12 = Float.NaN;
            f11 = Float.NaN;
        }
        if (fArray != null) {
            this.viewer.movePyMOL(this, f, fArray);
        } else {
            this.viewer.moveTo(this, f, p3, v3, f2, null, f5, f3, f4, f6, p32, f8, f9, f10, f11, f12, f13);
        }
        if (this.isJS && f > 0.0f && this.viewer.global.waitForMoveTo) {
            throw new ScriptInterruption(this, "moveTo", 1);
        }
    }

    private void bondorder() throws ScriptException {
        this.checkLength(-3);
        int n = 0;
        switch (this.getToken((int)1).tok) {
            case 2: 
            case 3: {
                n = JmolEdge.getBondOrderFromFloat(this.floatParameter(1));
                if (n != 131071) break;
                this.invArg();
                break;
            }
            default: {
                n = ScriptEvaluator.getBondOrderFromString(this.parameterAsString(1));
                if (n == 131071) {
                    this.invArg();
                }
                if (n != 33 || this.tokAt(2) != 3) break;
                n = ScriptEvaluator.getPartialBondOrderFromFloatEncodedInt(this.st[2].intValue);
            }
        }
        this.setShapeProperty(1, "bondOrder", n);
    }

    private void console() throws ScriptException {
        switch (this.getToken((int)1).tok) {
            case 0x10000C: {
                if (this.chk) break;
                this.viewer.showConsole(false);
                break;
            }
            case 0x10000D: {
                if (this.chk) break;
                this.viewer.showConsole(true);
                break;
            }
            case 1073741882: {
                if (this.chk) break;
                this.viewer.clearConsole();
                break;
            }
            case 135270422: {
                this.showString(this.stringParameter(2));
                break;
            }
            default: {
                this.invArg();
            }
        }
    }

    private void centerAt() throws ScriptException {
        String string = null;
        switch (this.getToken((int)1).tok) {
            case 0x40000002: {
                string = "absolute";
                break;
            }
            case 96: {
                string = "average";
                break;
            }
            case 1679429641: {
                string = "boundbox";
                break;
            }
            default: {
                this.invArg();
            }
        }
        P3 p3 = P3.new3(0.0f, 0.0f, 0.0f);
        if (this.slen == 5) {
            p3.x = this.floatParameter(2);
            p3.y = this.floatParameter(3);
            p3.z = this.floatParameter(4);
        } else if (this.isCenterParameter(2)) {
            p3 = this.centerParameter(2);
            this.checkLast(this.iToken);
        } else {
            this.checkLength(2);
        }
        if (!this.chk) {
            this.viewer.setCenterAt(string, p3);
        }
    }

    private void stereo() throws ScriptException {
        EnumStereoMode enumStereoMode = EnumStereoMode.DOUBLE;
        float f = -5.0f;
        boolean bl = false;
        int[] nArray = null;
        int n = 0;
        block6: for (int i = 1; i < this.slen; ++i) {
            if (this.isColorParam(i)) {
                if (n > 1) {
                    this.error(2);
                }
                if (n == 0) {
                    nArray = new int[2];
                }
                if (!bl) {
                    f = 3.0f;
                }
                nArray[n] = this.getArgbParam(i);
                if (n++ == 0) {
                    nArray[1] = ~nArray[0];
                }
                i = this.iToken;
                continue;
            }
            switch (this.getToken((int)i).tok) {
                case 0x10000D: {
                    this.iToken = 1;
                    this.checkLast(1);
                    this.iToken = 1;
                    continue block6;
                }
                case 0x10000C: {
                    this.iToken = 1;
                    this.checkLast(1);
                    enumStereoMode = EnumStereoMode.NONE;
                    continue block6;
                }
                case 2: 
                case 3: {
                    f = this.floatParameter(i);
                    bl = true;
                    continue block6;
                }
                case 0x40000000: {
                    if (!bl) {
                        f = 3.0f;
                    }
                    if ((enumStereoMode = EnumStereoMode.getStereoMode(this.parameterAsString(i))) != null) continue block6;
                }
                default: {
                    this.invArg();
                }
            }
        }
        if (this.chk) {
            return;
        }
        this.viewer.setStereoMode(nArray, enumStereoMode, f);
    }

    private void connect(int n) throws ScriptException {
        int n2;
        float[] fArray = new float[2];
        BS[] bSArray = new BS[2];
        bSArray[0] = bSArray[1] = this.viewer.getSelectionSet(false);
        float f = Float.NaN;
        this.colorArgb[0] = Integer.MIN_VALUE;
        int n3 = 0;
        int n4 = 131071;
        int n5 = 1073742026;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        float f2 = Float.MAX_VALUE;
        boolean bl4 = false;
        int n6 = 0;
        int n7 = 0;
        BS bS = new BS();
        boolean bl5 = false;
        int n8 = 0;
        int n9 = 0;
        float f3 = 0.0f;
        boolean bl6 = false;
        if (this.slen == 1) {
            if (!this.chk) {
                this.viewer.rebondState(this.isStateScript);
            }
            return;
        }
        for (n2 = n; n2 < this.slen; ++n2) {
            switch (this.getToken((int)n2).tok) {
                case 0x10000C: 
                case 0x10000D: {
                    this.checkLength(2);
                    if (!this.chk) {
                        this.viewer.rebondState(this.isStateScript);
                    }
                    return;
                }
                case 2: 
                case 3: {
                    int n10;
                    if (n6 > 0) {
                        if (bl2 || bl4) {
                            this.error(23);
                        }
                        if ((n10 = JmolEdge.getBondOrderFromFloat(this.floatParameter(n2))) == 131071) {
                            this.invArg();
                        }
                        n4 = n10;
                        bl2 = true;
                        break;
                    }
                    if (++n7 > 2) {
                        this.error(2);
                    }
                    float f4 = this.floatParameter(n2);
                    if (this.tokAt(n2 + 1) == 269484210) {
                        f4 = -f4 / 100.0f;
                        ++n2;
                    }
                    fArray[n3++] = f4;
                    break;
                }
                case 10: 
                case 0x100001: {
                    int n11;
                    if (n6 > 2 || bl5 && n6 > 0) {
                        this.error(2);
                    }
                    if (bl2 || bl4) {
                        this.error(23);
                    }
                    bSArray[n6++] = this.atomExpressionAt(n2);
                    bl5 = this.isBondSet;
                    if (n6 == 2) {
                        n11 = this.iToken;
                        for (int i = n2; i < n11; ++i) {
                            if (this.tokAt(i) != 0x40000000 || !this.parameterAsString(i).equals("_1")) continue;
                            n8 = n2;
                            break;
                        }
                        this.iToken = n11;
                    }
                    n2 = this.iToken;
                    break;
                }
                case 1087373318: {
                    bl6 = true;
                    break;
                }
                case 603979967: 
                case 1073742074: 
                case 1766856708: {
                    bl4 = true;
                    f2 = this.getColorTrans(n2, false);
                    n2 = this.iToken;
                    break;
                }
                case 1074790662: {
                    int n11 = this.tokAt(2) == 1073741852 ? 1 : 0;
                    this.checkLength(n11 != 0 ? 3 : 2);
                    if (!this.chk) {
                        this.viewer.setPdbConectBonding(n11 != 0, this.isStateScript);
                    }
                    return;
                }
                case 0x40000006: 
                case 1073741852: 
                case 0x40000050: 
                case 1073742025: 
                case 1073742026: {
                    bl3 = true;
                    if (++n2 != this.slen) {
                        this.error(23);
                    }
                    n5 = this.theTok;
                    if (this.theTok != 1073741852 || n4 == 131071 || n4 == 2048 || n4 == 515) break;
                    this.invArg();
                    break;
                }
                case 0x1A101A: {
                    if (!bl4) {
                        this.colorArgb[0] = 0xFFFFFF;
                        f2 = 0.5f;
                        f = this.viewer.getFloat(570425406);
                        bl4 = true;
                    }
                    if (!bl3) {
                        n5 = 1073742026;
                    }
                    bl3 = true;
                }
                case 0x40000000: {
                    if (this.isColorParam(n2)) {
                        n9 = -n2;
                        break;
                    }
                }
                case 1076887572: 
                case 1612189718: {
                    String string = this.parameterAsString(n2);
                    int n10 = ScriptEvaluator.getBondOrderFromString(string);
                    if (n10 == 131071) {
                        this.invArg();
                    }
                    if (bl2) {
                        this.error(18);
                    }
                    bl2 = true;
                    switch (n10) {
                        case 33: {
                            switch (this.tokAt(n2 + 1)) {
                                case 3: {
                                    n10 = ScriptEvaluator.getPartialBondOrderFromFloatEncodedInt(this.st[++n2].intValue);
                                    break;
                                }
                                case 2: {
                                    n10 = (short)this.intParameter(++n2);
                                }
                            }
                            break;
                        }
                        case 2048: {
                            if (this.tokAt(n2 + 1) != 2) break;
                            n10 = (short)(this.intParameter(++n2) << 11);
                            f3 = this.floatParameter(++n2);
                        }
                    }
                    n4 = n10;
                    break;
                }
                case 1666189314: {
                    f = this.floatParameter(++n2);
                    bl4 = true;
                    break;
                }
                case 12291: 
                case 0x10000B: {
                    if (++n2 != this.slen) {
                        this.error(23);
                    }
                    n5 = 12291;
                    bl = true;
                    bl4 = false;
                    break;
                }
                default: {
                    n9 = n2;
                }
            }
            if (n2 <= 0) continue;
            if (n9 == -n2 || n9 == n2 && this.isColorParam(n2)) {
                bl4 = true;
                this.colorArgb[0] = this.getArgbParam(n2);
                n2 = this.iToken;
                continue;
            }
            if (n9 != n2) continue;
            this.invArg();
        }
        if (this.chk) {
            return;
        }
        if (n3 < 2) {
            if (n3 == 0) {
                fArray[0] = 1.0E8f;
            }
            fArray[1] = fArray[0];
            fArray[0] = 0.1f;
        }
        if (bl4) {
            if (!bl2) {
                n4 = 65535;
            }
            if (!bl3) {
                n5 = 1073742025;
            }
        }
        n2 = 0;
        int n12 = 0;
        if (n8 > 0) {
            BS bS2 = new BS();
            this.definedAtomSets.put("_1", bS2);
            BS bS3 = bSArray[0];
            int n13 = bS3.nextSetBit(0);
            while (n13 >= 0) {
                bS2.set(n13);
                int[] nArray = this.viewer.makeConnections(fArray[0], fArray[1], n4, n5, bS2, this.atomExpressionAt(n8), bS, bl5, false, 0.0f);
                n2 += Math.abs(nArray[0]);
                n12 += nArray[1];
                bS2.clear(n13);
                n13 = bS3.nextSetBit(n13 + 1);
            }
        } else {
            int[] nArray = this.viewer.makeConnections(fArray[0], fArray[1], n4, n5, bSArray[0], bSArray[1], bS, bl5, bl6, f3);
            n2 += Math.abs(nArray[0]);
            n12 += nArray[1];
        }
        if (bl) {
            if (!this.tQuiet && this.scriptLevel <= this.scriptReportingLevel) {
                this.scriptStatusOrBuffer(GT.i(GT._("{0} connections deleted"), n12));
            }
            return;
        }
        if (bl4) {
            this.viewer.selectBonds(bS);
            if (!Float.isNaN(f)) {
                this.setShapeSizeBs(1, Math.round(f * 2000.0f), null);
            }
            this.finalizeObject(1, this.colorArgb[0], f2, 0, false, null, 0, bS);
            this.viewer.selectBonds(null);
        }
        if (!this.tQuiet && this.scriptLevel <= this.scriptReportingLevel) {
            this.scriptStatusOrBuffer(GT.o(GT._("{0} new bonds; {1} modified"), new Object[]{n2, n12}));
        }
    }

    private float getTranslucentLevel(int n) throws ScriptException {
        float f = this.floatParameter(n);
        return this.theTok == 2 && f > 0.0f && f < 9.0f ? f + 1.0f : f;
    }

    private void getProperty() throws ScriptException {
        if (this.chk) {
            return;
        }
        String string = "";
        String string2 = this.optParameterAsString(1);
        String string3 = string2;
        if (string3.indexOf(".") >= 0) {
            string3 = string3.substring(0, string3.indexOf("."));
        }
        if (string3.indexOf("[") >= 0) {
            string3 = string3.substring(0, string3.indexOf("["));
        }
        int n = this.viewer.getPropertyNumber(string3);
        Object object = "";
        switch (this.tokAt(2)) {
            default: {
                object = this.optParameterAsString(2);
                break;
            }
            case 10: 
            case 0x100001: {
                object = this.atomExpressionAt(2);
                if (!string2.equalsIgnoreCase("bondInfo")) break;
                switch (this.tokAt(++this.iToken)) {
                    case 10: 
                    case 0x100001: {
                        object = new BS[]{(BS)object, this.atomExpressionAt(this.iToken)};
                    }
                }
            }
        }
        if (string2.length() > 0 && n < 0) {
            string2 = "";
            object = "";
        } else if (n >= 0 && this.slen < 3) {
            object = this.viewer.getDefaultPropertyParam(n);
            if (object.equals("(visible)")) {
                this.viewer.setModelVisibility();
                object = this.viewer.getVisibleSet();
            }
        } else if (n == this.viewer.getPropertyNumber("fileContents")) {
            String string4 = object.toString();
            for (int i = 3; i < this.slen; ++i) {
                string4 = string4 + this.parameterAsString(i);
            }
            object = string4;
        }
        string = (String)this.viewer.getProperty("readable", string2, object);
        this.showString(string);
    }

    private void background(int n) throws ScriptException {
        this.getToken(n);
        if (this.theTok == 1073741979) {
            String string = this.parameterAsString(this.checkLast(++n));
            if (!this.chk && !string.equalsIgnoreCase("none") && string.length() > 0) {
                this.viewer.loadImage(string, null);
            }
            return;
        }
        if (this.isColorParam(n) || this.theTok == 0x10000B) {
            int n2 = this.getArgbParamLast(n, true);
            if (this.chk) {
                return;
            }
            this.setObjectArgb("background", n2);
            this.viewer.setBackgroundImage(null, null);
            return;
        }
        int n3 = this.getShapeType(this.theTok);
        this.colorShape(n3, n + 1, true);
    }

    private void center(int n) throws ScriptException {
        if (this.slen == 1) {
            this.viewer.setNewRotationCenter(null);
            return;
        }
        P3 p3 = this.centerParameter(n);
        if (p3 == null) {
            this.invArg();
        }
        if (!this.chk) {
            this.viewer.setNewRotationCenter(p3);
        }
    }

    public String setObjectProperty() throws ScriptException {
        String string = this.getShapeNameParameter(2);
        if (this.chk) {
            return "";
        }
        int n = this.iToken;
        int n2 = this.tokAt(0);
        return this.setObjectProp(string, n2, n);
    }

    @Override
    public String setObjectPropSafe(String string, int n, int n2) {
        try {
            return this.setObjectProp(string, n, n2);
        }
        catch (ScriptException scriptException) {
            return null;
        }
    }

    public String setObjectProp(String string, int n, int n2) throws ScriptException {
        Object[] objectArray = new Object[]{string, null};
        String string2 = "";
        boolean bl = Txt.isWild(string);
        int n3 = 17;
        do {
            if (n3 != 27 && this.getShapePropertyData(n3, "checkID", objectArray)) {
                this.setShapeProperty(n3, "thisID", string);
                switch (n) {
                    case 12291: {
                        this.setShapeProperty(n3, "delete", null);
                        break;
                    }
                    case 12294: 
                    case 1610625028: {
                        this.setShapeProperty(n3, "hidden", n == 1610625028 ? Boolean.FALSE : Boolean.TRUE);
                        break;
                    }
                    case 4148: {
                        string2 = string2 + (String)this.getShapeProperty(n3, "command") + "\n";
                        break;
                    }
                    case 1766856708: {
                        if (n2 < 0) break;
                        this.colorShape(n3, n2 + 1, false);
                    }
                }
                if (!bl) break;
            }
            if (n3 != 17) continue;
            n3 = 31;
        } while (--n3 >= 22);
        return string2;
    }

    private void color() throws ScriptException {
        int n = 1;
        if (this.isColorParam(1)) {
            this.theTok = 0x44100001;
        } else {
            int n2 = 0;
            n = 2;
            int n3 = this.getToken((int)1).tok;
            switch (n3) {
                case 0x100007: {
                    this.setObjectProperty();
                    return;
                }
                case 0x10000B: 
                case 0x300002: 
                case 603979967: 
                case 1073741946: 
                case 1073741992: 
                case 1073742030: 
                case 1073742074: 
                case 1073742116: 
                case 0x40000140: 
                case 1073742186: 
                case 1087373315: 
                case 0x40D00004: 
                case 1087373318: 
                case 1087373322: 
                case 1095761936: 
                case 1095761937: 
                case 1112539150: 
                case 1112539151: 
                case 1112541196: 
                case 1112541199: 
                case 1113200651: 
                case 1114638362: 
                case 1632634891: 
                case 1641025539: 
                case 1649412120: 
                case 1716520985: {
                    this.theTok = 0x44100001;
                    n = 1;
                    break;
                }
                case 4: {
                    boolean bl;
                    n = 1;
                    String string = this.stringParameter(n++);
                    if (this.isArrayParameter(n)) {
                        string = string + "=" + SV.sValue(SV.getVariableAS(this.stringParameterSet(n))).replace('\n', ' ');
                        n = this.iToken + 1;
                    }
                    boolean bl2 = bl = this.tokAt(n) == 603979967;
                    if (!this.chk) {
                        this.viewer.setPropertyColorScheme(string, bl, true);
                    }
                    if (bl) {
                        ++n;
                    }
                    if (this.tokAt(n) == 1073742114 || this.tokAt(n) == 0x40000002) {
                        float f = this.floatParameter(++n);
                        float f2 = this.floatParameter(++n);
                        if (!this.chk) {
                            this.viewer.setCurrentColorRange(f, f2);
                        }
                    }
                    return;
                }
                case 0x40000002: 
                case 1073742114: {
                    float f = this.floatParameter(2);
                    float f3 = this.floatParameter(this.checkLast(3));
                    if (!this.chk) {
                        this.viewer.setCurrentColorRange(f, f3);
                    }
                    return;
                }
                case 1610616835: {
                    n2 = this.getArgbParamLast(2, true);
                    if (!this.chk) {
                        this.setObjectArgb("background", n2);
                    }
                    return;
                }
                case 10: 
                case 0x100001: {
                    n = -1;
                    this.theTok = 0x44100001;
                    break;
                }
                case 1073742134: {
                    n2 = this.getArgbParamLast(2, false);
                    if (!this.chk) {
                        this.viewer.setRubberbandArgb(n2);
                    }
                    return;
                }
                case 0x20000008: 
                case 1611141171: {
                    n = 2;
                    if (this.tokAt(2) == 1073742074) {
                        ++n;
                    }
                    n2 = this.getArgbParamLast(n, true);
                    if (this.chk) {
                        return;
                    }
                    this.sm.loadShape(8);
                    this.setShapeProperty(8, n3 == 1611141171 ? "argbSelection" : "argbHighlight", n2);
                    return;
                }
                case 0x40000000: 
                case 1611272194: 
                case 1613758476: 
                case 1614417948: 
                case 1679429641: {
                    String string = this.parameterAsString(1);
                    if (this.checkToken(2)) {
                        switch (this.getToken((int)2).tok) {
                            case 1073742116: {
                                n2 = 1073742116;
                                break;
                            }
                            case 0x10000B: 
                            case 1073741992: {
                                n2 = 1073741992;
                                break;
                            }
                            default: {
                                n2 = this.getArgbParam(2);
                            }
                        }
                    }
                    if (n2 == 0) {
                        this.error(9);
                    }
                    this.checkLast(this.iToken);
                    if (string.equalsIgnoreCase("axes") || StateManager.getObjectIdFromName(string) >= 0) {
                        this.setObjectArgb(string, n2);
                        return;
                    }
                    if (this.changeElementColor(string, n2)) {
                        return;
                    }
                    this.invArg();
                    break;
                }
                case 135180: 
                case 135402505: {
                    this.setShapeProperty(JC.shapeTokenIndex(n3), "thisID", "+PREVIOUS_MESH+");
                }
            }
        }
        this.colorShape(this.getShapeType(this.theTok), n, false);
    }

    private boolean changeElementColor(String string, int n) {
        int n2 = Elements.elementNumberMax;
        while (--n2 >= 0) {
            if (!string.equalsIgnoreCase(Elements.elementNameFromNumber(n2))) continue;
            if (!this.chk) {
                this.viewer.setElementArgb(n2, n);
            }
            return true;
        }
        n2 = Elements.altElementMax;
        while (--n2 >= 0) {
            if (!string.equalsIgnoreCase(Elements.altElementNameFromIndex(n2))) continue;
            if (!this.chk) {
                this.viewer.setElementArgb(Elements.altElementNumberFromIndex(n2), n);
            }
            return true;
        }
        if (string.charAt(0) != '_') {
            return false;
        }
        n2 = Elements.elementNumberMax;
        while (--n2 >= 0) {
            if (!string.equalsIgnoreCase("_" + Elements.elementSymbolFromNumber(n2))) continue;
            if (!this.chk) {
                this.viewer.setElementArgb(n2, n);
            }
            return true;
        }
        n2 = Elements.altElementMax;
        while (--n2 >= 4) {
            if (string.equalsIgnoreCase("_" + Elements.altElementSymbolFromIndex(n2))) {
                if (!this.chk) {
                    this.viewer.setElementArgb(Elements.altElementNumberFromIndex(n2), n);
                }
                return true;
            }
            if (!string.equalsIgnoreCase("_" + Elements.altIsotopeSymbolFromIndex(n2))) continue;
            if (!this.chk) {
                this.viewer.setElementArgb(Elements.altElementNumberFromIndex(n2), n);
            }
            return true;
        }
        return false;
    }

    private void colorShape(int n, int n2, boolean bl) throws ScriptException {
        int n3;
        String string = null;
        Object object = null;
        Integer n4 = null;
        BS bS = null;
        String string2 = n2 == 2 && this.tokAt(1) == 0x40000024 ? "ball" : "";
        boolean bl2 = false;
        boolean bl3 = n == 24 || n == 25;
        int n5 = 0;
        boolean bl4 = false;
        float f = Float.MAX_VALUE;
        if (n2 < 0) {
            bS = this.atomExpressionAt(-n2);
            n2 = this.iToken + 1;
            if (this.isBondSet) {
                bl4 = true;
                n = 1;
            }
        }
        int n6 = this.getToken((int)n2).tok;
        if (bl) {
            this.getToken(n2);
        } else {
            bl = n6 == 1610616835;
            if (bl) {
                this.getToken(++n2);
            }
        }
        if (bl) {
            string2 = "bg";
        } else if (bl3) {
            switch (this.theTok) {
                case 1073742018: {
                    this.getToken(++n2);
                    string2 = "mesh";
                    break;
                }
                case 1073742094: {
                    n3 = this.getArgbParamOrNone(++n2, false);
                    n4 = n3 == 0 ? null : Integer.valueOf(n3);
                    n2 = this.iToken + 1;
                    this.getToken(n2);
                    break;
                }
                case 10: 
                case 0x100001: {
                    if (this.theToken.value instanceof BondSet) {
                        bS = (BondSet)this.theToken.value;
                        string2 = "vertex";
                    } else {
                        bS = this.atomExpressionAt(n2);
                        string2 = "atom";
                    }
                    n2 = this.iToken + 1;
                    this.getToken(n2);
                }
            }
        }
        if (!this.chk && n == 27 && !this.getExtension().dispatch(27, true, this.st)) {
            return;
        }
        int n7 = n3 = this.theTok == 603979967 ? 1 : 0;
        if (n3 != 0 || this.theTok == 1073742074) {
            if (f == Float.MIN_VALUE) {
                this.invArg();
            }
            string = this.parameterAsString(n2++);
            if (n3 != 0 && this.isFloatParameter(n2)) {
                f = this.getTranslucentLevel(n2++);
            }
        }
        n6 = 0;
        if (n2 < this.slen && this.tokAt(n2) != 0x10000D && this.tokAt(n2) != 0x10000C) {
            bl2 = true;
            n6 = this.getToken((int)n2).tok;
            if ((!bl3 || this.tokAt(n2 + 1) != 1074790746) && this.isColorParam(n2)) {
                int n8 = this.getArgbParamOrNone(n2, false);
                Integer n9 = object = n8 == 0 ? null : Integer.valueOf(n8);
                if (string == null && this.tokAt(n2 = this.iToken + 1) != 0) {
                    this.getToken(n2);
                    int n10 = n3 = this.theTok == 603979967 ? 1 : 0;
                    if (n3 != 0 || this.theTok == 1073742074) {
                        string = this.parameterAsString(n2);
                        if (n3 != 0 && this.isFloatParameter(n2 + 1)) {
                            f = this.getTranslucentLevel(++n2);
                        }
                    } else if (this.isColorParam(n2)) {
                        n8 = this.getArgbParamOrNone(n2, false);
                        n4 = n8 == 0 ? null : Integer.valueOf(n8);
                    }
                }
            } else if (n == 26) {
                --this.iToken;
            } else {
                BS bS2;
                EnumPalette enumPalette;
                boolean bl5;
                String string3 = this.parameterAsString(n2).toLowerCase();
                boolean bl6 = string3.indexOf("byelement") == 0;
                boolean bl7 = bl5 = bl6 || string3.indexOf("byresidue") == 0;
                EnumPalette enumPalette2 = bl5 || bl3 ? EnumPalette.PROPERTY : (enumPalette = n6 == 1113200651 ? EnumPalette.CPK : EnumPalette.getPalette(string3));
                if (enumPalette == EnumPalette.UNKNOWN || (enumPalette == EnumPalette.TYPE || enumPalette == EnumPalette.ENERGY) && n != 2) {
                    this.invArg();
                }
                float[] fArray = null;
                BS bS3 = bS2 = enumPalette != EnumPalette.PROPERTY && enumPalette != EnumPalette.VARIABLE || !this.viewer.global.rangeSelected ? null : this.viewer.getSelectionSet(false);
                if (enumPalette == EnumPalette.PROPERTY) {
                    if (bl5) {
                        if (!this.chk) {
                            fArray = this.getBitsetPropertyFloat(bS2, (bl6 ? 1095763978 : 1095761932) | 0x100, Float.NaN, Float.NaN);
                        }
                    } else {
                        if (!bl5 && !bl3) {
                            ++n2;
                        }
                        if (string3.equals("property") && T.tokAttr(n6 = this.getToken((int)n2).tok, 0x40500000) && !T.tokAttr(n6, 0x40D00000) && !this.chk) {
                            fArray = this.getBitsetPropertyFloat(bS2, this.getToken((int)n2++).tok | 0x100, Float.NaN, Float.NaN);
                        }
                    }
                } else if (enumPalette == EnumPalette.VARIABLE) {
                    int n11 = ++n2;
                    ++n2;
                    string3 = this.parameterAsString(n11);
                    fArray = new float[this.viewer.getAtomCount()];
                    Parser.parseStringInfestedFloatArray("" + this.getParameter(string3, 4), null, fArray);
                    enumPalette = EnumPalette.PROPERTY;
                }
                if (enumPalette == EnumPalette.PROPERTY) {
                    Object object2;
                    String string4 = null;
                    if (this.tokAt(n2) == 4) {
                        string4 = this.parameterAsString(n2++).toLowerCase();
                        if (this.isArrayParameter(n2)) {
                            string4 = string4 + "=" + SV.sValue(SV.getVariableAS(this.stringParameterSet(n2))).replace('\n', ' ');
                            n2 = this.iToken + 1;
                        }
                    } else if (bl3 && this.isColorParam(n2)) {
                        string4 = this.getColorRange(n2);
                        n2 = this.iToken + 1;
                    }
                    if (string4 != null && !bl3) {
                        this.setStringProperty("propertyColorScheme", (n3 != 0 && f == Float.MAX_VALUE ? "translucent " : "") + string4);
                        bl5 = string4.indexOf("byelement") == 0 || string4.indexOf("byresidue") == 0;
                    }
                    Object object3 = 0.0f;
                    Object object4 = Float.MAX_VALUE;
                    if (!(bl5 || this.tokAt(n2) != 0x40000002 && this.tokAt(n2) != 1073742114)) {
                        object3 = this.floatParameter(n2 + 1);
                        object4 = this.floatParameter(n2 + 2);
                        n2 += 3;
                        if (object3 == object4 && bl3) {
                            object2 = (float[])this.getShapeProperty(n, "dataRange");
                            if (object2 != null) {
                                object3 = object2[0];
                                object4 = object2[1];
                            }
                        } else if (object3 == object4) {
                            object4 = Float.MAX_VALUE;
                        }
                    }
                    if (!this.chk) {
                        if (!bl3) {
                            if (fArray == null) {
                                this.viewer.setCurrentColorRange(string3);
                            } else {
                                this.viewer.setCurrentColorRangeData(fArray, bS2);
                            }
                        }
                        if (bl3) {
                            this.checkLength(n2);
                            bl2 = false;
                            object2 = this.viewer.getColorEncoder(string4);
                            if (object2 == null) {
                                return;
                            }
                            ((ColorEncoder)object2).isTranslucent = n3 != 0 && f == Float.MAX_VALUE;
                            ((ColorEncoder)object2).setRange((float)object3, (float)object4, object3 > object4);
                            if (object4 == Float.MAX_VALUE) {
                                ((ColorEncoder)object2).hi = object4;
                            }
                            this.setShapeProperty(n, "remapColor", object2);
                            this.showString(this.getIsosurfaceDataRange(n, ""));
                            if (f == Float.MAX_VALUE) {
                                return;
                            }
                        } else if (object4 != Float.MAX_VALUE) {
                            this.viewer.setCurrentColorRange((float)object3, (float)object4);
                        }
                    }
                } else {
                    ++n2;
                }
                this.checkLength(n2);
                object = enumPalette;
            }
        }
        if (this.chk || n < 0) {
            return;
        }
        switch (n) {
            case 4: {
                n5 = 32768;
                break;
            }
            case 2: {
                n5 = 30720;
                break;
            }
            case 3: {
                n5 = 256;
                break;
            }
            case 1: {
                n5 = 1023;
                break;
            }
            default: {
                n5 = 0;
            }
        }
        if (n5 == 0) {
            this.sm.loadShape(n);
            if (n == 5) {
                this.setShapeProperty(5, "setDefaults", this.viewer.getNoneSelected());
            }
        } else {
            if (bS != null) {
                this.viewer.selectBonds(bS);
                bS = null;
            }
            n = 1;
            this.setShapeProperty(n, "type", n5);
        }
        if (bl2) {
            switch (n6) {
                case 1112539150: 
                case 1112539151: {
                    this.viewer.autoCalculate(n6);
                    break;
                }
                case 1112541199: {
                    if (!this.viewer.global.rangeSelected) break;
                    this.viewer.clearBfactorRange();
                    break;
                }
                case 1087373318: {
                    this.viewer.calcSelectedGroupsCount();
                    break;
                }
                case 1073742030: 
                case 1095761937: {
                    this.viewer.calcSelectedMonomersCount();
                    break;
                }
                case 1095761936: {
                    this.viewer.calcSelectedMoleculesCount();
                }
            }
            if (n4 != null && (bl3 || n == 11 || n == 14)) {
                this.setShapeProperty(n, "colorPhase", new Object[]{n4, object});
            } else if (bS == null) {
                this.setShapeProperty(n, string2 + "color", object);
            } else {
                this.setShapePropertyBs(n, string2 + "color", object, bS);
            }
        }
        if (string != null) {
            this.setShapeTranslucency(n, string2, string, f, bS);
        }
        if (n5 != 0) {
            this.setShapeProperty(1, "type", 1023);
        }
        if (bl4) {
            this.viewer.selectBonds(null);
        }
        if (n == 0) {
            this.viewer.checkInheritedShapes();
        }
    }

    public void setShapeTranslucency(int n, String string, String string2, float f, BS bS) {
        if (f == Float.MAX_VALUE) {
            f = this.viewer.getFloat(0x2200000A);
        }
        this.setShapeProperty(n, "translucentLevel", Float.valueOf(f));
        if (string == null) {
            return;
        }
        if (bS == null) {
            this.setShapeProperty(n, string + "translucency", string2);
        } else if (!this.chk) {
            this.setShapePropertyBs(n, string + "translucency", string2, bS);
        }
    }

    private void cd() throws ScriptException {
        if (this.chk) {
            return;
        }
        String string = this.slen == 1 ? null : this.parameterAsString(1);
        this.showString(this.viewer.cd(string));
    }

    private void define() throws ScriptException {
        boolean bl;
        String string;
        if (this.slen < 3 || !(this.getToken((int)1).value instanceof String)) {
            this.invArg();
        }
        if (PT.parseInt(string = ((String)this.getToken((int)1).value).toLowerCase()) != Integer.MIN_VALUE) {
            this.invArg();
        }
        if (this.chk) {
            return;
        }
        boolean bl2 = string.startsWith("site_");
        boolean bl3 = bl = string.indexOf("dynamic_") == 0;
        if (bl || bl2) {
            T[] tArray = new T[this.slen];
            int n = this.slen;
            while (--n >= 0) {
                tArray[n] = this.st[n];
            }
            this.definedAtomSets.put("!" + (bl2 ? string : string.substring(8)), tArray);
        } else {
            BS bS = this.atomExpressionAt(2);
            this.definedAtomSets.put(string, bS);
            if (!this.chk) {
                this.viewer.setUserVariable("@" + string, SV.newV(10, bS));
            }
        }
    }

    private void echo(int n, String string, boolean bl) throws ScriptException {
        if (this.chk) {
            return;
        }
        String string2 = this.optParameterAsString(n);
        if (this.viewer.getEchoStateActive()) {
            if (bl) {
                this.viewer.loadImage(string2, string);
                return;
            }
            if (string2.startsWith("\u0001")) {
                string2 = string2.substring(1);
                bl = true;
            }
            if (string2 != null) {
                this.setShapeProperty(30, "text", string2);
            }
        }
        if (!bl && this.viewer.getRefreshing()) {
            this.showString(this.viewer.formatText(string2));
        }
    }

    private void message() throws ScriptException {
        String string = this.parameterAsString(this.checkLast(1));
        if (this.chk) {
            return;
        }
        String string2 = this.viewer.formatText(string);
        if (this.outputBuffer == null) {
            this.viewer.showMessage(string2);
        }
        if (!string2.startsWith("_")) {
            this.scriptStatusOrBuffer(string2);
        }
    }

    private void log() throws ScriptException {
        if (this.slen == 1) {
            this.error(2);
        }
        if (this.chk) {
            return;
        }
        String string = this.parameterExpressionString(1, 0);
        if (this.tokAt(1) == 0x10000C) {
            this.setStringProperty("logFile", "");
        } else {
            this.viewer.log(string);
        }
    }

    private void label(int n) throws ScriptException {
        if (this.chk) {
            return;
        }
        this.sm.loadShape(5);
        String string = null;
        switch (this.getToken((int)n).tok) {
            case 0x10000D: {
                string = this.viewer.getStandardLabelFormat(0);
                break;
            }
            case 0x10000C: {
                break;
            }
            case 12294: 
            case 1610625028: {
                this.setShapeProperty(5, "display", this.theTok == 1610625028 ? Boolean.TRUE : Boolean.FALSE);
                return;
            }
            default: {
                string = this.parameterAsString(n);
            }
        }
        this.sm.setLabel(string, this.viewer.getSelectionSet(false));
    }

    private void hover() throws ScriptException {
        if (this.chk) {
            return;
        }
        String string = this.parameterAsString(1);
        if (string.equalsIgnoreCase("on")) {
            string = "%U";
        } else if (string.equalsIgnoreCase("off")) {
            string = null;
        }
        this.viewer.setHoverLabel(string);
    }

    public void load() throws ScriptException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n;
        String string;
        String string2;
        int n2;
        boolean bl = !this.chk || this.isCmdLine_C_Option;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n3 = this.tokAt(0) == 135270407 ? 0 : 1;
        boolean bl6 = this.viewer.getBoolean(603979792);
        String string3 = null;
        List<Object> list = null;
        int n4 = this.viewer.getModelCount() - (this.viewer.getFileName().equals("zapped") ? 1 : 0);
        int n5 = this.viewer.getAtomCount();
        SB sB = new SB().append("load");
        int n6 = 1;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (this.isStateScript) {
            hashtable.put("isStateScript", Boolean.TRUE);
            if (this.forceNoAddHydrogens) {
                hashtable.put("doNotAddHydrogens", Boolean.TRUE);
            }
        }
        String string4 = null;
        String[] stringArray = null;
        String[] stringArray2 = null;
        String string5 = null;
        String string6 = "";
        int n7 = 0;
        if (this.slen == 1) {
            n3 = 0;
        } else {
            string4 = this.parameterAsString(n3);
            if (this.slen == 2 && !this.chk && (string4.endsWith(".spt") || string4.endsWith(".png") || string4.endsWith(".pngj"))) {
                this.script(0, string4, null);
                return;
            }
            n2 = this.tokAt(n3);
            switch (n2) {
                case 1073742015: {
                    String string7 = this.parameterAsString(this.checkLast(2));
                    if (!this.chk) {
                        this.viewer.setMenu(string7, true);
                    }
                    return;
                }
                case 135270407: {
                    bl5 = true;
                    sB.append(" /*data*/ data");
                    string2 = this.stringParameter(++n3).toLowerCase();
                    sB.append(" ").append(Escape.eS(string2));
                    bl2 = string2.startsWith("append");
                    string = string2.indexOf("@") >= 0 ? "" + this.getParameter(string2.substring(string2.indexOf("@") + 1), 4) : this.parameterAsString(++n3);
                    string = Viewer.fixInlineString(string, this.viewer.getInlineChar());
                    hashtable.put("fileData", string);
                    hashtable.put("isData", Boolean.TRUE);
                    sB.appendC('\n');
                    sB.append(string);
                    if (string2.indexOf("@") >= 0) break;
                    sB.append(" end ").append(Escape.eS(string2));
                    n3 += 2;
                    break;
                }
                case 0x4000000F: {
                    bl2 = true;
                    sB.append(" append");
                    string4 = this.optParameterAsString(++n3);
                    n2 = T.getTokFromName(string4);
                    break;
                }
                case 0x40000000: {
                    ++n3;
                    sB.append(" " + string4);
                    int n8 = n7 = n2 == 0x40000000 && PT.isOneOf(string4.toLowerCase(), ";xyz;vxyz;vibration;temperature;occupancy;partialcharge;") ? T.getTokFromName(string4) : 0;
                    if (n7 == 0) break;
                    hashtable.put("atomDataOnly", Boolean.TRUE);
                    hashtable.put("modelNumber", 1);
                    if (n7 == 4166) {
                        n7 = 1146095631;
                    }
                    stringArray2 = this.viewer.getFileInfo();
                    bl2 = true;
                }
            }
            switch (n2) {
                case 1229984263: {
                    sB.append(" " + string4);
                    if (this.tokAt(++n3) != 7) break;
                    stringArray = this.stringParameterSet(n3);
                    n3 = this.iToken;
                    if (n3 + 1 != this.slen) {
                        this.invArg();
                    }
                    if (stringArray == null) break;
                    n6 = stringArray.length;
                    break;
                }
                case 1073741983: {
                    bl3 = true;
                    ++n3;
                    sB.append(" " + string4);
                    break;
                }
                case 135267336: {
                    bl4 = true;
                    ++n3;
                    break;
                }
                case 4156: {
                    hashtable.put("async", Boolean.TRUE);
                    ++n3;
                    break;
                }
                case 0x2000000E: 
                case 1095766030: {
                    ++n3;
                    sB.append(" " + string4);
                    if (n2 == 0x2000000E) {
                        hashtable.put("isTrajectory", Boolean.TRUE);
                    }
                    if (this.isPoint3f(n3)) {
                        P3 p3 = this.getPoint3f(n3, false);
                        n3 = this.iToken + 1;
                        hashtable.put("firstLastStep", new int[]{(int)p3.x, (int)p3.y, (int)p3.z});
                        sB.append(" " + Escape.eP(p3));
                        break;
                    }
                    if (this.tokAt(n3) == 10) {
                        BS bS = (BS)this.getToken((int)n3++).value;
                        hashtable.put("bsModels", bS);
                        sB.append(" " + Escape.eBS(bS));
                        break;
                    }
                    hashtable.put("firstLastStep", new int[]{0, -1, 1});
                    break;
                }
                case 0x40000000: {
                    break;
                }
                default: {
                    string4 = "fileset";
                }
            }
            if (stringArray == null && this.getToken((int)n3).tok != 4) {
                this.error(16);
            }
        }
        int n9 = n3;
        string2 = null;
        if (this.tokAt(n9 + 1) == 1073741848) {
            string2 = this.stringParameter(n3 += 2);
            if (this.viewer.getPathForAllFiles() != "") {
                string2 = null;
                n9 = n3;
            }
        }
        string = null;
        String string8 = null;
        String string9 = null;
        if (this.slen == n3 + 1) {
            if (n3 == 0 || stringArray == null && (string = this.parameterAsString(n9)).length() == 0) {
                string = this.viewer.getFullPathName();
            }
            if (string == null && stringArray == null) {
                this.zap(false);
                return;
            }
            if (stringArray == null && !bl3) {
                if (bl4) {
                    string = "$" + string;
                } else {
                    if (string.indexOf("[]") >= 0) {
                        return;
                    }
                    if (string.indexOf("[") == 0 && (stringArray = Escape.unescapeStringArray(string)) != null) {
                        if (n3 == 1) {
                            sB.append(" files");
                        }
                        n6 = stringArray.length;
                    }
                }
            }
            if (stringArray != null) {
                for (n = 0; n < n6; ++n) {
                    sB.append(" /*file*/").append(Escape.eS(stringArray[n]));
                }
            }
        } else if (this.getToken((int)(n3 + 1)).tok == 1073742010 || this.theTok == 2 || this.theTok == 7 || this.theTok == 0x10100040 || this.theTok == 1073742195 || this.theTok == 0x10000A || this.theTok == 8 || this.theTok == 0x40000100 || this.theTok == 1095761926 || this.theTok == 1073742163 || this.theTok == 1073742114 || this.theTok == 1073742152 || this.theTok == 1614417948 || this.theTok == 1073742066 || this.theTok == 0x40000074 && this.tokAt(n3 + 3) != 0x100006 || this.theTok == 0x4000000F || this.theTok == 0x40000000 && this.tokAt(n3 + 3) != 0x100006) {
            int n10;
            string = this.parameterAsString(n9);
            if (string.length() == 0 && (string = this.viewer.getFullPathName()) == null) {
                this.zap(false);
                return;
            }
            if (n9 == n3) {
                ++n3;
            }
            if (string.indexOf("[]") >= 0) {
                return;
            }
            n2 = this.tokAt(n3);
            if (n2 == 1073742010) {
                String string10 = this.stringParameter(++n3);
                hashtable.put("manifest", string10);
                string6 = string6 + " MANIFEST " + Escape.eS(string10);
                n2 = this.tokAt(++n3);
            }
            switch (n2) {
                case 2: {
                    int n11 = this.intParameter(n3);
                    string6 = string6 + " " + n11;
                    if (n11 < 0) {
                        hashtable.put("vibrationNumber", -n11);
                    } else {
                        hashtable.put("modelNumber", n11);
                    }
                    n2 = this.tokAt(++n3);
                    break;
                }
                case 7: 
                case 0x10100040: 
                case 1073742195: {
                    object4 = this.floatParameterSet(n3, 1, Integer.MAX_VALUE);
                    n3 = this.iToken;
                    object3 = new BS();
                    for (int i = 0; i < ((float[])object4).length; ++i) {
                        if (!(object4[i] >= 1.0f) || object4[i] != (float)((int)object4[i])) continue;
                        ((BS)object3).set((int)object4[i] - 1);
                    }
                    hashtable.put("bsModels", object3);
                    object2 = new int[((BS)object3).cardinality()];
                    int n12 = 0;
                    n10 = ((BS)object3).nextSetBit(0);
                    while (n10 >= 0) {
                        object2[n12++] = n10 + 1;
                        n10 = ((BS)object3).nextSetBit(n10 + 1);
                    }
                    string6 = string6 + " " + Escape.eAI((int[])object2);
                    n2 = this.tokAt(n3);
                }
            }
            P3 p3 = null;
            if (n2 == 0x10000A || n2 == 8) {
                p3 = this.getPoint3f(n3, false);
                n3 = this.iToken + 1;
                n2 = this.tokAt(n3);
            }
            switch (n2) {
                case 0x40000100: 
                case 1073742114: 
                case 1073742152: 
                case 1073742163: 
                case 1095761926: 
                case 1614417948: {
                    if (p3 == null) {
                        p3 = P3.new3(555.0f, 555.0f, -1.0f);
                    }
                    this.iToken = n3 - 1;
                }
            }
            object4 = null;
            if (p3 != null) {
                hashtable.put("lattice", p3);
                n3 = this.iToken + 1;
                string6 = string6 + " {" + (int)p3.x + " " + (int)p3.y + " " + (int)p3.z + "}";
                if (this.tokAt(n3) == 0x40000100) {
                    hashtable.put("packed", Boolean.TRUE);
                    string6 = string6 + " PACKED";
                    ++n3;
                }
                if (this.tokAt(n3) == 1095761926) {
                    hashtable.put("centroid", Boolean.TRUE);
                    string6 = string6 + " CENTROID";
                    if (this.tokAt(++n3) == 0x40000100 && !hashtable.containsKey("packed")) {
                        hashtable.put("packed", Boolean.TRUE);
                        string6 = string6 + " PACKED";
                        ++n3;
                    }
                }
                if (this.tokAt(n3) == 1073742163) {
                    if (this.isPoint3f(++n3)) {
                        object2 = this.getPoint3f(n3, false);
                        if (((P3)object2).x != (float)((int)((P3)object2).x) || ((P3)object2).y != (float)((int)((P3)object2).y) || ((P3)object2).z != (float)((int)((P3)object2).z) || ((P3)object2).x < 1.0f || ((P3)object2).y < 1.0f || ((P3)object2).z < 1.0f) {
                            this.iToken = n3;
                            this.invArg();
                        }
                        object3 = object2;
                        n3 = this.iToken + 1;
                    } else {
                        object3 = this.stringParameter(n3++);
                    }
                    hashtable.put("supercell", object3);
                }
                float f = 0.0f;
                if (this.tokAt(n3) == 1073742114) {
                    int n13 = ++n3;
                    ++n3;
                    f = this.floatParameter(n13);
                    string6 = string6 + " range " + f;
                }
                hashtable.put("symmetryRange", Float.valueOf(f));
                object2 = null;
                n10 = Integer.MIN_VALUE;
                if (this.tokAt(n3) == 1073742152) {
                    int n14 = ++n3;
                    ++n3;
                    object2 = PT.simpleReplace(this.parameterAsString(n14), "''", "\"");
                    string6 = string6 + " spacegroup " + Escape.eS((String)object2);
                    if (((String)object2).equalsIgnoreCase("ignoreOperators")) {
                        n10 = -999;
                    } else {
                        if (((String)object2).length() == 0) {
                            SymmetryInterface symmetryInterface = this.viewer.getCurrentUnitCell();
                            if (symmetryInterface != null) {
                                object2 = symmetryInterface.getSpaceGroupName();
                            }
                        } else if (((String)object2).indexOf(",") >= 0 && p3.x < 9.0f && p3.y < 9.0f && p3.z == 0.0f) {
                            object2 = (String)object2 + "#doNormalize=0";
                        }
                        hashtable.put("spaceGroupName", object2);
                        n10 = -2;
                    }
                }
                object = null;
                if (this.tokAt(n3) == 1614417948) {
                    if (this.optParameterAsString(++n3).length() == 0) {
                        SymmetryInterface symmetryInterface = this.viewer.getCurrentUnitCell();
                        if (symmetryInterface != null) {
                            object = symmetryInterface.getUnitCellAsArray(true);
                            object4 = symmetryInterface.getCartesianOffset();
                        }
                    } else {
                        object = this.floatParameterSet(n3, 6, 9);
                    }
                    if (object == null || ((Object)object).length != 6 && ((Object)object).length != 9) {
                        this.invArg();
                    }
                    string6 = string6 + " unitcell {";
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        string6 = string6 + (i == 0 ? "" : " ") + (float)object[i];
                    }
                    string6 = string6 + "}";
                    hashtable.put("unitcell", object);
                    if (n10 == Integer.MIN_VALUE) {
                        n10 = -1;
                    }
                    n3 = this.iToken + 1;
                }
                if (n10 != Integer.MIN_VALUE) {
                    hashtable.put("spaceGroupIndex", n10);
                }
            }
            if (object4 != null) {
                this.coordinatesAreFractional = false;
            } else if (this.tokAt(n3) == 1073742066) {
                object4 = this.getPoint3f(++n3, true);
            }
            if (object4 != null) {
                if (this.coordinatesAreFractional) {
                    ((T3)object4).setT(this.fractionalPoint);
                    hashtable.put("unitCellOffsetFractional", this.coordinatesAreFractional ? Boolean.TRUE : Boolean.FALSE);
                    string6 = string6 + " offset {" + ((P3)object4).x + " " + ((P3)object4).y + " " + ((P3)object4).z + "/1}";
                } else {
                    string6 = string6 + " offset " + Escape.eP((T3)object4);
                }
                hashtable.put("unitCellOffset", object4);
                n3 = this.iToken + 1;
            }
            if (this.tokAt(n3) == 0x4000000F) {
                if (this.tokAt(++n3) == 135270407) {
                    n3 += 2;
                    string8 = (String)this.getToken((int)n3++).value;
                    string9 = this.stringParameter(++n3);
                    ++n3;
                } else {
                    string9 = this.stringParameter(n3++);
                    string8 = this.stringParameter(n3++);
                }
                hashtable.put(string9, string8);
            }
            if (this.tokAt(n3) == 0x40000074) {
                string3 = this.stringParameter(++n3);
            }
        } else {
            if (n3 == 1) {
                ++n3;
                sB.append(" " + string4);
            }
            P3 p3 = null;
            object4 = null;
            object3 = new List();
            block30: while (n3 < this.slen) {
                switch (this.tokAt(n3)) {
                    case 0x40000074: {
                        string3 = this.stringParameter(++n3);
                        ++n3;
                        continue block30;
                    }
                    case 0x100006: {
                        hashtable.remove("isTrajectory");
                        if (list == null) {
                            list = new List<Object>();
                            p3 = P3.new3(0.0f, -1.0f, 1.0f);
                        }
                        if (this.isPoint3f(++n3)) {
                            p3 = this.getPoint3f(n3, false);
                            n3 = this.iToken + 1;
                            break;
                        }
                        if (this.tokAt(n3) != 10) break;
                        object4 = (BS)this.getToken((int)n3).value;
                        p3 = null;
                        n3 = this.iToken + 1;
                        break;
                    }
                    case 0x40000000: {
                        this.invArg();
                    }
                }
                string = this.parameterAsString(n3++);
                ((List)object3).addLast(string);
                if (p3 != null) {
                    list.addLast(new int[]{(int)p3.x, (int)p3.y, (int)p3.z});
                    sB.append(" COORD " + Escape.eP(p3));
                } else if (object4 != null) {
                    list.addLast(object4);
                    sB.append(" COORD " + Escape.eBS((BS)object4));
                }
                sB.append(" /*file*/$FILENAME" + ((ArrayList)object3).size() + "$");
            }
            if (list != null) {
                hashtable.put("firstLastSteps", list);
            }
            n6 = ((ArrayList)object3).size();
            stringArray = ((ArrayList)object3).toArray(new String[n6]);
        }
        if (!bl) {
            return;
        }
        if (stringArray != null) {
            string = "fileSet";
        }
        if (string8 != null) {
            string6 = string6 + " APPEND data \"" + string9 + "\"\n" + string8 + (string8.endsWith("\n") ? "" : "\n") + "end \"" + string9 + "\"";
        }
        if (string3 == null) {
            string3 = this.viewer.getDefaultLoadFilter();
        }
        if (string3.length() > 0) {
            if (string3.toUpperCase().indexOf("DOCACHE") >= 0 && !this.isStateScript && !bl2) {
                this.viewer.cacheClear();
            }
            hashtable.put("filter", string3);
            if (string3.equalsIgnoreCase("2d")) {
                string3 = "2D-noMin";
            }
            string6 = string6 + " FILTER " + Escape.eS(string3);
        }
        n = 0;
        if (stringArray == null) {
            if (bl3) {
                hashtable.put("fileData", string);
            } else if (string.startsWith("@") && string.length() > 1) {
                n = 1;
                object4 = this.getStringParameter(string.substring(1), false);
                hashtable.put("fileData", object4);
                sB = new SB().append("{\n    var ").append(string.substring(1)).append(" = ").append(Escape.eS((String)object4)).append(";\n    ").appendSB(sB);
            } else if (string.startsWith("?") && this.viewer.isJS) {
                string2 = null;
                string = this.loadFileAsync("LOAD" + (bl2 ? "_APPEND_" : "_"), string, n3, !bl2);
            }
        }
        object4 = null;
        if (string2 != null) {
            if (string2.equals(".")) {
                string2 = this.viewer.getFilePath(string, true);
            }
            if (string2.length() == 0 || this.viewer.getFilePath(string2, false).equalsIgnoreCase(this.viewer.getFilePath(string, false))) {
                this.invArg();
            }
            if ((object4 = (Object)this.viewer.getOutputChannel(string2, (String[])(object3 = new String[]{string2}))) == null) {
                Logger.error("Could not create output stream for " + object3[0]);
            } else {
                hashtable.put("outputChannel", object4);
            }
        }
        if (stringArray == null && n7 == 0) {
            sB.append(" ");
            if (n != 0 || bl3) {
                sB.append(Escape.eS(string));
            } else if (!bl5) {
                if (!string.equals("string") && !string.equals("string[]")) {
                    sB.append("/*file*/");
                }
                if (string2 != null) {
                    string2 = this.viewer.getFilePath(string2, false);
                }
                sB.append(string2 != null ? Escape.eS(string2) : "$FILENAME$");
            }
            if (string6.length() > 0) {
                sB.append(" /*options*/ ").append(string6);
            }
            if (n != 0) {
                sB.append("\n  }");
            }
            hashtable.put("loadScript", sB);
        }
        this.setCursorWait(true);
        boolean bl7 = this.viewer.getBoolean(603979934);
        if (bl7) {
            Logger.startTimer("load");
        }
        string5 = this.viewer.loadModelFromFile(null, string, stringArray, null, bl2, hashtable, sB, n7);
        if (object4 != null) {
            this.viewer.setFileInfo(new String[]{string2, string2, string2});
            Logger.info(GT.o(GT._("file {0} created"), string2));
            this.showString(this.viewer.getFilePath(string2, false) + " created");
            ((OC)object4).closeChannel();
        }
        if (n7 > 0) {
            this.viewer.setFileInfo(stringArray2);
            if (string5 != null && !this.isCmdLine_c_or_C_Option) {
                this.evalError(string5, null);
            }
            return;
        }
        if (string5 != null && !this.isCmdLine_c_or_C_Option) {
            if (string5.indexOf("NOTE: file recognized as a script file: ") == 0) {
                string = string5.substring("NOTE: file recognized as a script file: ".length()).trim();
                this.script(0, string, null);
                return;
            }
            this.evalError(string5, null);
        }
        if (bl2 && (bl6 || n6 > 1)) {
            this.viewer.setAnimationRange(-1, -1);
            this.viewer.setCurrentModelIndex(n4);
        }
        if (this.scriptLevel == 0 && !bl2 && n6 < 2) {
            this.showString((String)this.viewer.getModelSetAuxiliaryInfoValue("modelLoadNote"));
        }
        if (this.logMessages) {
            this.scriptStatusOrBuffer("Successfully loaded:" + (stringArray == null ? hashtable.get("fullPathName") : string4));
        }
        if ((object2 = (Object)this.viewer.getModelSetAuxiliaryInfo()) != null && object2.containsKey("centroidMinMax") && this.viewer.getAtomCount() > 0) {
            BS bS = BSUtil.newBitSet2(bl2 ? n5 : 0, this.viewer.getAtomCount());
            this.viewer.setCentroid(bS, (int[])object2.get("centroidMinMax"));
        }
        String string11 = this.viewer.getDefaultLoadScript();
        String string12 = "";
        if (string11.length() > 0) {
            string12 = string12 + "\nUsing defaultLoadScript: " + string11;
        }
        if (object2 != null && this.viewer.allowEmbeddedScripts()) {
            object = (String)object2.remove("jmolscript");
            if (object != null && ((String)object).length() > 0) {
                string12 = string12 + "\nAdding embedded #jmolscript: " + (String)object;
                string11 = string11 + ";" + (String)object;
                this.setStringProperty("_loadScript", string11);
                string11 = "allowEmbeddedScripts = false;try{" + string11 + "} allowEmbeddedScripts = true;";
            }
        } else {
            this.setStringProperty("_loadScript", "");
        }
        this.logLoadInfo(string12);
        Object object5 = object = object2 == null ? null : (String)object2.remove("sitescript");
        if (object != null) {
            string11 = (String)object + ";" + string11;
        }
        if (string11.length() > 0 && !this.isCmdLine_c_or_C_Option) {
            this.runScript(string11);
        }
        if (bl7) {
            this.showString(Logger.getTimerMsg("load", 0));
        }
    }

    public String loadFileAsync(String string, String string2, int n, boolean bl) throws ScriptException {
        String string3;
        string = "cache://local" + string;
        String string4 = this.pc + "_" + n;
        if (this.thisContext == null || this.thisContext.htFileCache == null) {
            this.pushContext(null, "loadFileAsync");
            this.thisContext.htFileCache = new Hashtable<String, String>();
        }
        if ((string3 = this.thisContext.htFileCache.get(string4)) != null && string3.length() > 0) {
            this.fileLoadThread = null;
            this.popContext(false, false);
            this.viewer.queueOnHold = false;
            if ("#CANCELED#".equals(this.viewer.cacheGet(string3))) {
                this.evalError("#CANCELED#", null);
            }
            return string3;
        }
        string3 = string + System.currentTimeMillis();
        this.thisContext.htFileCache.put(string4, string3);
        if (this.fileLoadThread != null) {
            this.evalError("#CANCELED#", null);
        }
        if (bl) {
            this.viewer.cacheFileByName(string + "*", false);
        }
        this.fileLoadThread = new FileLoadThread(this, this.viewer, string2, string4, string3);
        this.fileLoadThread.run();
        throw new ScriptInterruption(this, "load", 1);
    }

    private void logLoadInfo(String string) {
        if (string.length() > 0) {
            Logger.info(string);
        }
        SB sB = new SB();
        int n = this.viewer.getModelCount();
        if (n > 1) {
            sB.append((this.viewer.isMovie() ? this.viewer.getFrameCount() + " frames" : n + " models") + "\n");
        }
        for (int i = 0; i < n; ++i) {
            Map map = (Map)this.viewer.getModelAuxiliaryInfoValue(i, "moData");
            if (map == null) continue;
            sB.appendI(((List)map.get("mos")).size()).append(" molecular orbitals in model ").append(this.viewer.getModelNumberDotted(i)).append("\n");
        }
        if (sB.length() > 0) {
            this.showString(sB.toString());
        }
    }

    public String getFullPathName() throws ScriptException {
        String string;
        String string2 = string = !this.chk || this.isCmdLine_C_Option ? this.viewer.getFullPathName() : "test.xyz";
        if (string == null) {
            this.invArg();
        }
        return string;
    }

    private boolean pause() throws ScriptException {
        if (this.chk || this.isJS && !this.allowJSThreads) {
            return false;
        }
        String string = this.optParameterAsString(1);
        if (!this.viewer.getBooleanProperty("_useCommandThread")) {
            // empty if block
        }
        if (this.viewer.autoExit || !this.viewer.haveDisplay && !this.viewer.isWebGL) {
            return false;
        }
        if (this.scriptLevel == 0 && this.pc == this.aatoken.length - 1) {
            this.viewer.scriptStatus("nothing to pause: " + string);
            return false;
        }
        string = string.length() == 0 ? ": RESUME to continue." : ": " + this.viewer.formatText(string);
        this.pauseExecution(true);
        this.viewer.scriptStatusMsg("script execution paused" + string, "script paused for RESUME");
        return true;
    }

    private void print() throws ScriptException {
        if (this.slen == 1) {
            this.error(2);
        }
        this.showStringPrint(this.parameterExpressionString(1, 0), true);
    }

    private void prompt() throws ScriptException {
        String string = null;
        if (this.slen == 1) {
            if (!this.chk) {
                string = ScriptEvaluator.getContextTrace(this.viewer, this.getScriptContext("prompt"), null, true).toString();
            }
        } else {
            string = this.parameterExpressionString(1, 0);
        }
        if (!this.chk) {
            this.viewer.prompt(string, "OK", null, true);
        }
    }

    public void refresh() {
        if (this.chk) {
            return;
        }
        this.viewer.setTainted(true);
        this.viewer.requestRepaintAndWait("refresh cmd");
    }

    private void reset() throws ScriptException {
        if (this.slen == 3 && this.tokAt(1) == 135368713) {
            if (!this.chk) {
                this.viewer.removeFunction(this.stringParameter(2));
            }
            return;
        }
        this.checkLength(-2);
        if (this.chk) {
            return;
        }
        if (this.slen == 1) {
            this.viewer.reset(false);
            return;
        }
        switch (this.tokAt(1)) {
            case 135270423: {
                this.viewer.cacheClear();
                return;
            }
            case 1073741935: {
                this.viewer.resetError();
                return;
            }
            case 1087373323: {
                this.viewer.resetShapes(true);
                return;
            }
            case 135368713: {
                this.viewer.clearFunctions();
                return;
            }
            case 1641025539: {
                BS bS = new BS();
                this.runScript(this.viewer.getDefaultStructure(null, bS));
                this.viewer.resetBioshapes(bS);
                return;
            }
            case 1649412120: {
                this.viewer.setData("element_vdw", new Object[]{null, ""}, 0, 0, 0, 0, 0);
                return;
            }
            case 1076887572: {
                this.viewer.resetAromatic();
                return;
            }
            case 1611141175: {
                this.viewer.reset(true);
                return;
            }
        }
        String string = this.parameterAsString(1);
        if (string.charAt(0) == '_') {
            this.invArg();
        }
        this.viewer.unsetProperty(string);
    }

    private void restrict() throws ScriptException {
        boolean bl = this.tokAt(1) == 1678770178;
        this.select(bl ? 2 : 1);
        this.restrictSelected(bl, true);
    }

    private void restrictSelected(boolean bl, boolean bl2) {
        if (!this.chk) {
            this.sm.restrictSelected(bl, bl2);
        }
    }

    private void rotate(boolean bl, boolean bl2) throws ScriptException {
        float f;
        Object[] objectArray;
        if (this.slen == 2) {
            switch (this.getToken((int)1).tok) {
                case 0x10000D: {
                    if (!this.chk) {
                        this.viewer.setSpinOn(true);
                    }
                    return;
                }
                case 0x10000C: {
                    if (!this.chk) {
                        this.viewer.setSpinOn(false);
                    }
                    return;
                }
            }
        }
        BS bS = null;
        float f2 = Float.MIN_VALUE;
        int n = 0;
        float f3 = Float.MAX_VALUE;
        boolean bl3 = false;
        boolean bl4 = false;
        float[] fArray = null;
        List<P3> list = null;
        P3[] p3Array = new P3[2];
        V3 v3 = V3.new3(0.0f, 1.0f, 0.0f);
        V3 v32 = null;
        M4 m4 = null;
        M3 m3 = null;
        int n2 = 1;
        Quaternion quaternion = null;
        boolean bl5 = false;
        List<P3> list2 = null;
        BS bS2 = null;
        P3 p3 = null;
        P4 p4 = null;
        boolean bl6 = this.viewer.getBoolean(603979806);
        block23: for (int i = 1; i < this.slen; ++i) {
            int n3 = this.getToken((int)i).tok;
            switch (n3) {
                case 8: 
                case 10: 
                case 0x100001: 
                case 0x100007: 
                case 0x10000A: {
                    if (!(n3 != 10 && n3 != 0x100001 || v32 == null && quaternion == null && n != 2)) {
                        bS = this.atomExpressionAt(i);
                        list2 = null;
                        bl2 = true;
                        break;
                    }
                    bl4 = true;
                    if (n == 2) {
                        n = 0;
                    }
                    objectArray = this.centerParameterForModel(i, this.viewer.getCurrentModelIndex());
                    if (!this.chk && n3 == 0x100007 && this.tokAt(i + 2) != 0x10100040) {
                        bl3 = true;
                        v3 = this.getDrawObjectAxis(this.objectNameParameter(++i), this.viewer.getCurrentModelIndex());
                    }
                    p3Array[n++] = objectArray;
                    break;
                }
                case 1611141175: {
                    bl = true;
                    continue block23;
                }
                case 0x400000A4: 
                case 1073742029: {
                    bl3 = true;
                    continue block23;
                }
                case 1114638363: {
                    bl2 = true;
                    break;
                }
                case 0x10100030: {
                    continue block23;
                }
                case 2: 
                case 3: {
                    if (bl) {
                        if (f2 == Float.MIN_VALUE) {
                            f2 = this.floatParameter(i);
                            continue block23;
                        }
                        if (f3 == Float.MAX_VALUE) {
                            f3 = f2;
                            f2 = this.floatParameter(i);
                            continue block23;
                        }
                    } else {
                        if (f3 == Float.MAX_VALUE) {
                            f3 = this.floatParameter(i);
                            continue block23;
                        }
                        if (f2 == Float.MIN_VALUE) {
                            f2 = this.floatParameter(i);
                            bl = true;
                            continue block23;
                        }
                    }
                    this.invArg();
                    break;
                }
                case 0x101000A0: {
                    n2 = -1;
                    continue block23;
                }
                case 1112541205: {
                    bl4 = true;
                    v3.set(n2, 0.0f, 0.0f);
                    continue block23;
                }
                case 1112541206: {
                    bl4 = true;
                    v3.set(0.0f, n2, 0.0f);
                    continue block23;
                }
                case 1112541207: {
                    bl4 = true;
                    v3.set(0.0f, 0.0f, bl6 && !bl3 ? -n2 : n2);
                    continue block23;
                }
                case 9: 
                case 135270418: 
                case 1073741863: {
                    if (n3 == 135270418) {
                        ++i;
                    }
                    bl4 = true;
                    quaternion = this.getQuaternionParameter(i);
                    if (quaternion == null) break;
                    if (n3 == 1073741863 && !(bl3 = bl2)) {
                        quaternion = quaternion.mulQ(this.viewer.getRotationQuaternion().mul(-1.0f));
                    }
                    v3.setT(quaternion.getNormal());
                    f3 = quaternion.getTheta();
                    break;
                }
                case 135266307: {
                    bl4 = true;
                    if (this.isPoint3f(++i)) {
                        v3.setT(this.centerParameter(i));
                        break;
                    }
                    P4 p42 = this.getPoint4f(i);
                    v3.set(p42.x, p42.y, p42.z);
                    f3 = p42.w;
                    quaternion = Quaternion.newVA(v3, f3);
                    break;
                }
                case 0x100004: {
                    bl2 = true;
                    bl3 = true;
                    bl4 = true;
                    if (this.isArrayParameter(++i)) {
                        fArray = this.floatParameterSet(i, 6, Integer.MAX_VALUE);
                        i = this.iToken;
                        break;
                    }
                    int n4 = this.atomExpressionAt(i).nextSetBit(0);
                    int n5 = this.atomExpressionAt(++this.iToken).nextSetBit(0);
                    if (n4 < 0 || n5 < 0) {
                        return;
                    }
                    bS = this.viewer.getBranchBitSet(n5, n4, true);
                    p3Array[0] = this.viewer.getAtomPoint3f(n4);
                    p3Array[1] = this.viewer.getAtomPoint3f(n5);
                    n = 2;
                    break;
                }
                case 4160: {
                    v32 = V3.newV(this.centerParameter(++i));
                    bl2 = true;
                    bl3 = true;
                    break;
                }
                case 137363468: {
                    bl5 = true;
                    continue block23;
                }
                case 1297090050: {
                    Object[] objectArray2;
                    int n4 = this.intParameter(++i);
                    if (this.chk) continue block23;
                    Map<String, Object> map = this.viewer.getSpaceGroupInfo(null);
                    Object[] objectArray3 = objectArray2 = map == null ? null : (Object[])map.get("operations");
                    if (n4 == 0 || objectArray2 == null || objectArray2.length < Math.abs(n4)) {
                        this.invArg();
                    }
                    objectArray2 = (Object[])objectArray2[Math.abs(n4) - 1];
                    v32 = (V3)objectArray2[5];
                    p3 = (P3)objectArray2[6];
                    p3Array[0] = (P3)objectArray2[7];
                    if (objectArray2[8] != null) {
                        v3 = (V3)objectArray2[8];
                    }
                    f3 = ((Integer)objectArray2[9]).intValue();
                    if (n4 < 0) {
                        f3 = -f3;
                        if (v32 != null) {
                            v32.scale(-1.0f);
                        }
                    }
                    if (f3 == 0.0f && p3Array[0] != null) {
                        v3.normalize();
                        p4 = new P4();
                        Measure.getPlaneThroughPoint(p3Array[0], v3, p4);
                    }
                    quaternion = Quaternion.newVA(v3, f3);
                    n = p3Array[0] == null ? 0 : 1;
                    bl3 = true;
                    bl4 = true;
                    bl2 = true;
                    continue block23;
                }
                case 11: 
                case 12: 
                case 135270405: {
                    bl4 = true;
                    if (n3 == 135270405) {
                        float f4;
                        if ((list = this.viewer.getAtomPointVector(bS2 = this.atomExpressionAt(++i))) == null) {
                            this.errorAt(22, i);
                        }
                        i = this.iToken;
                        if ((list2 = this.getPointVector(this.getToken(++i), i)) == null || list.size() != list2.size()) {
                            this.errorAt(22, i);
                        }
                        m4 = new M4();
                        p3Array[0] = new P3();
                        n = 1;
                        float f5 = f4 = this.chk ? 0.0f : Measure.getTransformMatrix4(list, list2, m4, p3Array[0]);
                        if ((double)f4 > 0.001) {
                            list2 = null;
                        }
                    } else if (n3 == 12) {
                        m4 = (M4)this.theToken.value;
                    }
                    m3 = new M3();
                    if (m4 != null) {
                        v32 = new V3();
                        m4.get(v32);
                        m4.getRotationScale(m3);
                    } else {
                        m3 = (M3)this.theToken.value;
                    }
                    quaternion = this.chk ? new Quaternion() : Quaternion.newM(m3);
                    v3.setT(quaternion.getNormal());
                    f3 = quaternion.getTheta();
                    bl3 = true;
                    break;
                }
                default: {
                    this.invArg();
                }
            }
            i = this.iToken;
        }
        if (this.chk) {
            return;
        }
        if (fArray != null && f3 != Float.MAX_VALUE) {
            bl = true;
            f2 = f3;
        }
        if (bl2 && bS == null) {
            bS = this.viewer.getSelectionSet(false);
        }
        if (bS2 != null) {
            bl2 = true;
            if (bS == null) {
                bS = bS2;
            }
        }
        float f6 = f2 == Float.MIN_VALUE ? 10.0f : (f3 == Float.MAX_VALUE ? f2 : (f = f2 < 0.0f == f3 > 0.0f ? -f3 / f2 : f2));
        if (fArray != null) {
            if (!bl) {
                this.viewer.setDihedrals(fArray, null, 1.0f);
                return;
            }
            v32 = null;
        }
        if (quaternion != null) {
            if (n == 0 && v32 != null) {
                p3Array[0] = this.viewer.getAtomSetCenter(bS != null ? bS : (bl2 ? this.viewer.getSelectionSet(false) : this.viewer.getAllAtoms()));
            }
            if (bl5 && v32 != null) {
                p3Array[1] = P3.newP(p3Array[0]);
                p3Array[1].add(v32);
                objectArray = (Object[])Measure.computeHelicalAxis(null, 135266306, p3Array[0], p3Array[1], quaternion);
                p3Array[0] = (P3)objectArray[0];
                float f7 = ((P3)objectArray[3]).x;
                if (f7 != 0.0f) {
                    v32 = (V3)objectArray[1];
                    v3 = V3.newV(v32);
                    if (f7 < 0.0f) {
                        v3.scale(-1.0f);
                    }
                }
                m4 = null;
            }
            if (bl && m4 == null) {
                m4 = ScriptMathProcessor.getMatrix4f(quaternion.getMatrix(), v32);
            }
            if (p3Array[0] != null) {
                n = 1;
            }
        }
        if (p3 != null) {
            this.viewer.invertAtomCoordPt(p3, bS);
            if (v3 == null) {
                return;
            }
        }
        if (p4 != null) {
            this.viewer.invertAtomCoordPlane(p4, bS);
            if (v3 == null) {
                return;
            }
        }
        if (n < 2 && fArray == null) {
            if (!bl3) {
                if (bl && bS == null && !this.useThreads()) {
                    return;
                }
                if (this.viewer.rotateAxisAngleAtCenter(this, p3Array[0], v3, f, f3, bl, bS) && this.isJS && bl && bS == null) {
                    throw new ScriptInterruption(this, "rotate", 1);
                }
                return;
            }
            if (n == 0) {
                p3Array[0] = new P3();
            }
            p3Array[1] = P3.newP(p3Array[0]);
            p3Array[1].add(v3);
            n = 2;
        }
        if (n == 0) {
            p3Array[0] = new P3();
        }
        if (n < 2 || p3Array[0].distance(p3Array[1]) == 0.0f) {
            p3Array[1] = P3.newP(p3Array[0]);
            p3Array[1].y = (float)((double)p3Array[1].y + 1.0);
        }
        if (f3 == Float.MAX_VALUE) {
            f3 = 0.0f;
        }
        if (f3 != 0.0f && v32 != null && !bl4) {
            v32.scale(f3 / v32.length());
        }
        if (bl && v32 != null && (f3 == 0.0f || f2 == 0.0f)) {
            f3 = 0.01f;
            f = f2 == Float.MIN_VALUE ? 0.01f : (f2 < 0.0f ? -f3 / f2 : f2 * 0.01f / v32.length());
            f2 = 0.01f;
        }
        if (bS != null && bl && list2 == null && m4 != null) {
            list = this.viewer.getAtomPointVector(bS);
            list2 = Measure.transformPoints(list, m4, p3Array[0]);
        }
        if (bS != null && !bl && list2 != null) {
            this.viewer.setAtomCoords(bS, 1146095626, list2);
        } else {
            if (!this.useThreads()) {
                return;
            }
            if (this.viewer.rotateAboutPointsInternal(this, p3Array[0], p3Array[1], f, f3, bl, bS, v32, list2, fArray) && this.isJS && bl) {
                throw new ScriptInterruption(this, "rotate", 1);
            }
        }
    }

    private Quaternion getQuaternionParameter(int n) throws ScriptException {
        switch (this.tokAt(n)) {
            case 7: {
                List<SV> list = ((SV)this.getToken(n)).getList();
                P4 p4 = null;
                if (list.size() == 0 || (p4 = SV.pt4Value((SV)list.get(0))) == null) {
                    this.invArg();
                }
                return Quaternion.newP4(p4);
            }
            case 1073741863: {
                return this.chk ? null : Quaternion.newP4((P4)Escape.uP(this.viewer.getOrientationText(1073741863, null)));
            }
        }
        return Quaternion.newP4(this.getPoint4f(n));
    }

    public List<P3> getPointVector(T t, int n) throws ScriptException {
        switch (t.tok) {
            case 10: {
                return this.viewer.getAtomPointVector((BS)t.value);
            }
            case 7: {
                List<P3> list = new List<P3>();
                List<SV> list2 = ((SV)t).getList();
                for (int i = 0; i < list2.size(); ++i) {
                    P3 p3 = SV.ptValue((SV)list2.get(i));
                    if (p3 == null) {
                        return null;
                    }
                    list.addLast(p3);
                }
                return list;
            }
        }
        if (n > 0) {
            return this.viewer.getAtomPointVector(this.atomExpressionAt(n));
        }
        return null;
    }

    private P3 getObjectCenter(String string, int n, int n2) {
        Object[] objectArray = new Object[]{string, n, n2};
        return this.getShapePropertyData(22, "getCenter", objectArray) || this.getShapePropertyData(24, "getCenter", objectArray) || this.getShapePropertyData(28, "getCenter", objectArray) || this.getShapePropertyData(25, "getCenter", objectArray) || this.getShapePropertyData(27, "getCenter", objectArray) ? (P3)objectArray[2] : null;
    }

    private P3[] getObjectBoundingBox(String string) {
        Object[] objectArray = new Object[]{string, null, null};
        return this.getShapePropertyData(24, "getBoundingBox", objectArray) || this.getShapePropertyData(28, "getBoundingBox", objectArray) || this.getShapePropertyData(25, "getBoundingBox", objectArray) || this.getShapePropertyData(27, "getBoundingBox", objectArray) ? (P3[])objectArray[2] : null;
    }

    private V3 getDrawObjectAxis(String string, int n) {
        Object[] objectArray = new Object[]{string, n, null};
        return this.getShapePropertyData(22, "getSpinAxis", objectArray) ? (V3)objectArray[2] : null;
    }

    public void script(int n, String string, String string2) throws ScriptException {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 2;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        List<SV> list = null;
        if (n == 135287308) {
            this.checkLength(2);
            if (!this.chk) {
                this.viewer.jsEval(this.parameterAsString(1));
            }
            return;
        }
        if (string == null && string2 == null) {
            n = this.tokAt(1);
            if (n != 4) {
                this.error(16);
            }
            if ((string = this.parameterAsString(1)).equalsIgnoreCase("applet")) {
                String string6 = this.parameterAsString(2);
                string2 = this.parameterExpressionString(3, 0);
                this.checkLast(this.iToken);
                if (this.chk) {
                    return;
                }
                if (string6.length() == 0 || string6.equals("all")) {
                    string6 = "*";
                }
                if (!string6.equals(".")) {
                    this.viewer.jsEval(string6 + "\u0001" + string2);
                    if (!string6.equals("*")) {
                        return;
                    }
                }
            } else {
                n = this.tokAt(this.slen - 1);
                boolean bl4 = bl3 = n == 266298;
                if (string.equalsIgnoreCase("inline")) {
                    string2 = this.parameterExpressionString(2, bl3 ? this.slen - 1 : 0);
                    n6 = this.iToken + 1;
                }
                while (string.equalsIgnoreCase("localPath") || string.equalsIgnoreCase("remotePath") || string.equalsIgnoreCase("scriptPath")) {
                    if (string.equalsIgnoreCase("localPath")) {
                        string3 = this.parameterAsString(n6++);
                    } else if (string.equalsIgnoreCase("scriptPath")) {
                        string5 = this.parameterAsString(n6++);
                    } else {
                        string4 = this.parameterAsString(n6++);
                    }
                    string = this.parameterAsString(n6++);
                }
                if (string.startsWith("?") && this.viewer.isJS) {
                    string = this.loadFileAsync("SCRIPT_", string, n6, true);
                }
                if ((n = this.tokAt(n6)) == 1073741878) {
                    bl2 = true;
                    n = this.tokAt(++n6);
                }
                if (n == 1073742050) {
                    bl = false;
                    n = this.tokAt(++n6);
                }
                if (n == 1073741998 || n == 0x44100004) {
                    int n7 = ++n6;
                    n4 = n2 = Math.max(this.intParameter(n7), 0);
                    if (this.checkToken(++n6) && (n4 = this.getToken((int)n6).tok == 0x101000A0 ? (this.checkToken(++n6) ? this.intParameter(n6++) : 0) : -this.intParameter(n6++)) <= 0) {
                        this.invArg();
                    }
                } else if (n == 0x40000042 || n == 0x40000044) {
                    int n8 = ++n6;
                    n3 = Math.max(this.intParameter(n8) - 1, 0);
                    n5 = n3 + 1;
                    if (this.checkToken(++n6) && (n5 = this.getToken((int)n6).tok == 0x101000A0 ? (this.checkToken(++n6) ? this.intParameter(n6++) : 0) : -this.intParameter(n6++)) <= 0) {
                        this.invArg();
                    }
                }
                if (this.tokAt(n6) == 0x10100010) {
                    list = this.parameterExpressionList(n6, -1, false);
                    n6 = this.iToken + 1;
                }
                this.checkLength(bl3 ? n6 + 1 : n6);
            }
        }
        if (this.chk && !this.isCmdLine_c_or_C_Option) {
            return;
        }
        if (this.isCmdLine_c_or_C_Option) {
            bl2 = true;
        }
        boolean bl5 = this.chk;
        boolean bl6 = this.isCmdLine_c_or_C_Option;
        if (bl2) {
            this.isCmdLine_c_or_C_Option = true;
            this.chk = true;
        }
        this.pushContext(null, "SCRIPT");
        this.contextPath = this.contextPath + " >> " + string;
        if (string2 == null ? this.compileScriptFileInternal(string, string3, string4, string5) : this.compileScript(null, string2, false)) {
            boolean bl7;
            this.pcEnd = n5;
            this.lineEnd = n4;
            while (n3 < this.lineNumbers.length && this.lineNumbers[n3] < n2) {
                ++n3;
            }
            this.pc = n3;
            boolean bl8 = this.isCmdLine_C_Option;
            this.isCmdLine_C_Option &= bl;
            this.executionStepping |= bl3;
            this.contextVariables = new Hashtable<String, SV>();
            this.contextVariables.put("_arguments", list == null ? SV.getVariableAI(new int[0]) : SV.getVariableList(list));
            if (bl2) {
                this.listCommands = true;
            }
            if (bl7 = this.viewer.getBoolean(603979934)) {
                Logger.startTimer("script");
            }
            this.dispatchCommands(false, false);
            if (bl7) {
                this.showString(Logger.getTimerMsg("script", 0));
            }
            this.isCmdLine_C_Option = bl8;
            this.popContext(false, false);
        } else {
            Logger.error(GT._("script ERROR: ") + this.errorMessage);
            this.popContext(false, false);
            if (bl6) {
                this.setErrorMessage(null);
            } else {
                this.evalError(null, null);
            }
        }
        this.chk = bl5;
        this.isCmdLine_c_or_C_Option = bl6;
    }

    private void function() throws ScriptException {
        List<SV> list;
        if (this.chk && !this.isCmdLine_c_or_C_Option) {
            return;
        }
        String string = (String)this.getToken((int)0).value;
        if (!this.viewer.isFunction(string)) {
            this.error(10);
        }
        List<SV> list2 = list = this.slen == 1 || this.slen == 3 && this.tokAt(1) == 0x10100010 && this.tokAt(2) == 0x10100011 ? null : this.parameterExpressionList(1, -1, false);
        if (this.chk) {
            return;
        }
        this.runFunctionRet(null, string, list, null, false, true, true);
    }

    private void sync() throws ScriptException {
        this.checkLength(-3);
        String string = "";
        String string2 = "";
        int n = PT.parseInt(this.optParameterAsString(1));
        if (n == Integer.MIN_VALUE) {
            n = 0;
            switch (this.slen) {
                case 1: {
                    string2 = "*";
                    string = "ON";
                    break;
                }
                case 2: {
                    string2 = this.parameterAsString(1);
                    if (string2.indexOf("jmolApplet") == 0 || PT.isOneOf(string2, ";*;.;^;")) {
                        string = "ON";
                        if (!this.chk) {
                            this.viewer.syncScript(string, string2, 0);
                        }
                        string2 = ".";
                        break;
                    }
                    string = string2;
                    string2 = "*";
                    break;
                }
                case 3: {
                    string2 = this.parameterAsString(1);
                    string = this.tokAt(2) == 528443 ? "GET_GRAPHICS" : this.parameterAsString(2);
                }
            }
        } else {
            string = this.slen == 2 ? null : this.parameterAsString(2);
            string2 = null;
        }
        if (this.chk) {
            return;
        }
        this.viewer.syncScript(string, string2, n);
    }

    private void history(int n) throws ScriptException {
        if (this.slen == 1) {
            this.showString(this.viewer.getSetHistory(Integer.MAX_VALUE));
            return;
        }
        if (n == 2) {
            int n2 = this.intParameter(this.checkLast(2));
            if (n2 < 0) {
                this.invArg();
            }
            if (!this.chk) {
                this.viewer.getSetHistory(n2 == 0 ? 0 : -2 - n2);
            }
            return;
        }
        switch (this.getToken((int)this.checkLast((int)1)).tok) {
            case 0x10000D: 
            case 1073741882: {
                if (!this.chk) {
                    this.viewer.getSetHistory(Integer.MIN_VALUE);
                }
                return;
            }
            case 0x10000C: {
                if (this.chk) break;
                this.viewer.getSetHistory(0);
                break;
            }
            default: {
                this.errorStr(24, "ON, OFF, CLEAR");
            }
        }
    }

    private void display(boolean bl) throws ScriptException {
        boolean bl2;
        BS bS = null;
        int n = 0;
        int n2 = 1;
        int n3 = this.tokAt(1);
        switch (n3) {
            case 1073742119: 
            case 1276118017: {
                n = n3;
                n3 = this.tokAt(++n2);
            }
        }
        boolean bl3 = bl2 = n3 == 1087373318;
        if (bl2) {
            n3 = this.tokAt(++n2);
        }
        switch (n3) {
            case 0x100007: {
                this.setObjectProperty();
                return;
            }
            case 0: {
                break;
            }
            default: {
                bS = this.slen == 4 && this.tokAt(2) == 1678770178 ? new BondSet(BSUtil.newBitSet2(0, this.viewer.modelSet.bondCount)) : this.atomExpressionAt(n2);
            }
        }
        if (this.chk) {
            return;
        }
        if (bS instanceof BondSet) {
            this.viewer.displayBonds((BondSet)bS, bl);
            return;
        }
        this.viewer.displayAtoms(bS, bl, bl2, n, this.tQuiet);
    }

    private void delete() throws ScriptException {
        BS bS;
        if (this.tokAt(1) == 0x100007) {
            this.setObjectProperty();
            return;
        }
        BS bS2 = bS = this.slen == 1 ? null : this.atomExpression(this.st, 1, 0, true, false, true, false);
        if (this.chk) {
            return;
        }
        if (bS == null) {
            bS = this.viewer.getAllAtoms();
        }
        int n = this.viewer.deleteAtoms(bS, false);
        if (!this.tQuiet && this.scriptLevel <= this.scriptReportingLevel) {
            this.scriptStatusOrBuffer(GT.i(GT._("{0} atoms deleted"), n));
        }
    }

    private void select(int n) throws ScriptException {
        Object object;
        Object object2;
        if (this.slen == 1) {
            this.viewer.select(null, false, 0, this.tQuiet || this.scriptLevel > this.scriptReportingLevel);
            return;
        }
        if (this.slen == 2 && this.tokAt(1) == 1073742072) {
            return;
        }
        this.viewer.setNoneSelected(this.slen == 4 && this.tokAt(2) == 0x10000B);
        if (this.tokAt(2) == 10 && this.getToken((int)2).value instanceof BondSet || this.getToken((int)2).tok == 1678770178 && this.getToken((int)3).tok == 10) {
            if (this.slen == this.iToken + 2) {
                if (!this.chk) {
                    this.viewer.selectBonds((BS)this.theToken.value);
                }
                return;
            }
            this.invArg();
        }
        if (this.getToken((int)2).tok == 1746538509) {
            if (this.slen == 5 && this.getToken((int)3).tok == 10) {
                if (!this.chk) {
                    this.setShapeProperty(6, "select", this.theToken.value);
                }
                return;
            }
            this.invArg();
        }
        int n2 = 0;
        boolean bl = false;
        if (this.getToken((int)1).intValue == 0 && this.theTok != 0x10000C) {
            object2 = this.parameterExpressionToken((int)0).value;
            if (!(object2 instanceof BS)) {
                this.invArg();
            }
            this.checkLast(this.iToken);
            object = (BS)object2;
        } else {
            int n3 = this.tokAt(n);
            switch (n3) {
                case 0x10000C: 
                case 0x10000D: {
                    if (!this.chk) {
                        this.viewer.setSelectionHalos(n3 == 0x10000D);
                    }
                    n3 = this.tokAt(++n);
                }
            }
            switch (n3) {
                case 1073742119: 
                case 1276118017: {
                    n2 = n3;
                    n3 = this.tokAt(++n);
                }
            }
            boolean bl2 = bl = n3 == 1087373318;
            if (bl) {
                n3 = this.tokAt(++n);
            }
            object = this.atomExpressionAt(n);
        }
        if (this.chk) {
            return;
        }
        if (this.isBondSet) {
            this.viewer.selectBonds((BS)object);
        } else {
            if (((BS)object).length() > this.viewer.getAtomCount()) {
                object2 = this.viewer.getAllAtoms();
                ((BS)object2).and((BS)object);
                object = object2;
            }
            this.viewer.select((BS)object, bl, n2, this.tQuiet || this.scriptLevel > this.scriptReportingLevel);
        }
    }

    private void subset() throws ScriptException {
        BS bS = null;
        if (!this.chk) {
            this.viewer.setSelectionSubset(null);
        }
        if (!(this.slen == 1 || this.slen == 4 && this.getToken((int)2).value.equals("off"))) {
            bS = this.atomExpressionAt(1);
        }
        if (!this.chk) {
            this.viewer.setSelectionSubset(bS);
        }
    }

    private void invertSelected() throws ScriptException {
        P3 p3 = null;
        P4 p4 = null;
        BS bS = null;
        int n = Integer.MIN_VALUE;
        switch (this.tokAt(1)) {
            case 0: {
                if (this.chk) {
                    return;
                }
                bS = this.viewer.getSelectionSet(false);
                p3 = this.viewer.getAtomSetCenter(bS);
                this.viewer.invertAtomCoordPt(p3, bS);
                return;
            }
            case 528443: {
                n = this.atomExpressionAt(2).nextSetBit(0);
                bS = this.atomExpressionAt(this.iToken + 1);
                break;
            }
            case 0x8100010: {
                p3 = this.centerParameter(2);
                break;
            }
            case 135266319: {
                p4 = this.planeParameter(2);
                break;
            }
            case 135267841: {
                p4 = this.hklParameter(2);
            }
        }
        this.checkLengthErrorPt(this.iToken + 1, 1);
        if (p4 == null && p3 == null && n == Integer.MIN_VALUE) {
            this.invArg();
        }
        if (this.chk) {
            return;
        }
        if (n == -1) {
            return;
        }
        this.viewer.invertSelected(p3, p4, n, bS);
    }

    private void translate(boolean bl) throws ScriptException {
        char c;
        BS bS = null;
        int n = 1;
        int n2 = 0;
        if (this.tokAt(1) == 1114638363) {
            bl = true;
            n2 = 1;
            n = 2;
        }
        if (this.isPoint3f(n)) {
            P3 p3 = this.getPoint3f(n, true);
            bS = !bl && this.iToken + 1 < this.slen ? this.atomExpressionAt(++this.iToken) : null;
            this.checkLast(this.iToken);
            if (!this.chk) {
                this.viewer.setAtomCoordsRelative(p3, bS);
            }
            return;
        }
        char c2 = (this.parameterAsString(n).toLowerCase() + " ").charAt(0);
        if ("xyz".indexOf(c2) < 0) {
            this.error(0);
        }
        float f = this.floatParameter(++n);
        switch (this.tokAt(++n)) {
            case 0: 
            case 10: 
            case 0x100001: {
                c = '\u0000';
                break;
            }
            default: {
                c = (this.optParameterAsString(n).toLowerCase() + '\u0000').charAt(0);
            }
        }
        if (f == 0.0f && c != '\u0000') {
            return;
        }
        this.iToken = n2 + (c == '\u0000' ? 2 : 3);
        bS = bl ? this.viewer.getSelectionSet(false) : (this.iToken + 1 < this.slen ? this.atomExpressionAt(++this.iToken) : null);
        this.checkLast(this.iToken);
        if (!this.chk) {
            this.viewer.translate(c2, f, c, bS);
        }
    }

    private void zap(boolean bl) throws ScriptException {
        boolean bl2;
        if (this.slen == 1 || !bl) {
            boolean bl3;
            boolean bl4 = bl3 = bl && !this.isStateScript;
            if (bl3) {
                this.viewer.cacheFileByName(null, false);
            }
            this.viewer.zap(true, bl3, true);
            this.refresh();
            return;
        }
        BS bS = this.atomExpressionAt(1);
        if (this.chk) {
            return;
        }
        int n = this.viewer.deleteAtoms(bS, true);
        boolean bl5 = bl2 = this.tQuiet || this.scriptLevel > this.scriptReportingLevel;
        if (!bl2) {
            this.scriptStatusOrBuffer(GT.i(GT._("{0} atoms deleted"), n));
        }
        this.viewer.select(null, false, 0, bl2);
    }

    private void zoom(boolean bl) throws ScriptException {
        float f;
        if (!bl) {
            int n = this.slen > 1 ? this.getToken((int)1).tok : 0x10000D;
            switch (n) {
                case 1073741980: 
                case 0x400000FF: {
                    break;
                }
                case 0x10000C: 
                case 0x10000D: {
                    if (this.slen > 2) {
                        this.error(2);
                    }
                    if (!this.chk) {
                        this.setBooleanProperty("zoomEnabled", n == 0x10000D);
                    }
                    return;
                }
            }
        }
        P3 p3 = null;
        int n = 1;
        float f2 = bl ? (this.isFloatParameter(n) ? this.floatParameter(n++) : 2.0f) : (f = 0.0f);
        if (f < 0.0f) {
            --n;
            f = 0.0f;
        }
        int n2 = 0;
        BS bS = null;
        if (this.isCenterParameter(n)) {
            n2 = n;
            p3 = this.centerParameter(n);
            if (this.expressionResult instanceof BS) {
                bS = (BS)this.expressionResult;
            }
            n = this.iToken + 1;
        } else if (this.tokAt(n) == 2 && this.getToken((int)n).intValue == 0) {
            bS = this.viewer.getAtomBitSet("visible");
            p3 = this.viewer.getAtomSetCenter(bS);
        }
        boolean bl2 = false;
        float f3 = this.viewer.getZoomSetting();
        float f4 = this.getZoom(n2, n, bS, f3);
        n = this.iToken + 1;
        float f5 = Float.NaN;
        float f6 = Float.NaN;
        if (n != this.slen) {
            f5 = this.floatParameter(n++);
            f6 = this.floatParameter(n++);
        }
        if (n != this.slen) {
            this.invArg();
        }
        if (f4 < 0.0f) {
            f4 = -f4;
            if (bl) {
                if (this.slen == 1 || bl2) {
                    f4 *= 2.0f;
                } else if (p3 == null) {
                    f4 /= 2.0f;
                }
            }
        }
        float f7 = this.viewer.getMaxZoomPercent();
        if (f4 < 5.0f || f4 > f7) {
            this.numberOutOfRange(5.0f, f7);
        }
        if (!this.viewer.isWindowCentered()) {
            if (p3 != null) {
                BS bS2 = this.atomExpressionAt(n2);
                if (!this.chk) {
                    this.viewer.setCenterBitSet(bS2, false);
                }
            }
            p3 = this.viewer.getRotationCenter();
            if (Float.isNaN(f5)) {
                f5 = this.viewer.getTranslationXPercent();
            }
            if (Float.isNaN(f6)) {
                f6 = this.viewer.getTranslationYPercent();
            }
        }
        if (this.chk) {
            return;
        }
        if (bl2 && Math.abs(f3 - f4) < 1.0f) {
            f = 0.0f;
        }
        this.viewer.moveTo(this, f, p3, JC.center, Float.NaN, null, f4, f5, f6, Float.NaN, null, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN);
        if (this.isJS && f > 0.0f && this.viewer.global.waitForMoveTo) {
            throw new ScriptInterruption(this, "zoomTo", 1);
        }
    }

    private float getZoom(int n, int n2, BS bS, float f) throws ScriptException {
        float f2;
        float f3 = f2 = this.isFloatParameter(n2) ? this.floatParameter(n2++) : Float.NaN;
        if (f2 == 0.0f || f == 0.0f) {
            float f4 = Float.NaN;
            if (bS == null) {
                P3[] p3Array;
                if (this.tokAt(n) == 0x100007 && ((p3Array = this.getObjectBoundingBox(this.objectNameParameter(n + 1))) == null || (f4 = p3Array[0].distance(p3Array[1]) / 2.0f) == 0.0f)) {
                    this.invArg();
                }
            } else {
                f4 = this.viewer.calcRotationRadiusBs(bS);
            }
            if (Float.isNaN(f4)) {
                this.invArg();
            }
            f = this.viewer.getFloat(0x2200002C) / f4 * 100.0f;
            f2 = Float.NaN;
        }
        if (f2 < 0.0f) {
            f2 += f;
        } else if (Float.isNaN(f2)) {
            int n3 = this.tokAt(n2);
            switch (n3) {
                case 1073741980: 
                case 0x400000FF: {
                    f2 = f * (n3 == 0x400000FF ? 0.5f : 2.0f);
                    ++n2;
                    break;
                }
                case 0x101000A1: 
                case 0x101000B0: 
                case 0x101000B1: {
                    float f5 = this.floatParameter(++n2);
                    ++n2;
                    switch (n3) {
                        case 0x101000B0: {
                            f2 = f / f5;
                            break;
                        }
                        case 0x101000B1: {
                            f2 = f * f5;
                            break;
                        }
                        case 0x101000A1: {
                            f2 = f + f5;
                        }
                    }
                    break;
                }
                default: {
                    f2 = bS == null ? -f : f;
                }
            }
        }
        this.iToken = n2 - 1;
        return f2;
    }

    private void delay() throws ScriptException {
        int n = 0;
        switch (this.getToken((int)1).tok) {
            case 0x10000D: {
                n = 1;
                break;
            }
            case 2: {
                n = this.intParameter(1) * 1000;
                break;
            }
            case 3: {
                n = (int)(this.floatParameter(1) * 1000.0f);
                break;
            }
            default: {
                this.error(34);
            }
        }
        if (this.chk || this.viewer.isHeadless() || this.viewer.autoExit) {
            return;
        }
        this.refresh();
        this.doDelay(Math.abs(n));
    }

    private void slab(boolean bl) throws ScriptException {
        boolean bl2 = false;
        P4 p4 = null;
        if (this.isCenterParameter(1) || this.tokAt(1) == 9) {
            p4 = this.planeParameter(1);
        } else {
            block0 : switch (this.getToken((int)1).tok) {
                case 2: {
                    int n = this.intParameter(this.checkLast(1));
                    if (!this.chk) {
                        if (bl) {
                            this.viewer.depthToPercent(n);
                        } else {
                            this.viewer.slabToPercent(n);
                        }
                    }
                    return;
                }
                case 0x10000D: {
                    this.checkLength(2);
                    bl2 = true;
                }
                case 0x10000C: {
                    this.checkLength(2);
                    this.setBooleanProperty("slabEnabled", bl2);
                    return;
                }
                case 4141: {
                    this.checkLength(2);
                    if (this.chk) {
                        return;
                    }
                    this.viewer.slabReset();
                    this.setBooleanProperty("slabEnabled", true);
                    return;
                }
                case 1085443: {
                    this.checkLength(2);
                    if (this.chk) {
                        return;
                    }
                    this.viewer.setSlabDepthInternal(bl);
                    this.setBooleanProperty("slabEnabled", true);
                    return;
                }
                case 0x101000A0: {
                    String string = this.parameterAsString(2);
                    if (string.equalsIgnoreCase("hkl")) {
                        p4 = this.hklParameter(3);
                    } else if (string.equalsIgnoreCase("plane")) {
                        p4 = this.planeParameter(3);
                    }
                    if (p4 == null) {
                        this.invArg();
                    }
                    p4.scale(-1.0f);
                    break;
                }
                case 135266319: {
                    switch (this.getToken((int)2).tok) {
                        case 0x10000B: {
                            break block0;
                        }
                    }
                    p4 = this.planeParameter(2);
                    break;
                }
                case 135267841: {
                    p4 = this.getToken((int)2).tok == 0x10000B ? null : this.hklParameter(2);
                    break;
                }
                case 1073742118: {
                    return;
                }
                default: {
                    this.invArg();
                }
            }
        }
        if (!this.chk) {
            this.viewer.slabInternal(p4, bl);
        }
    }

    private void ellipsoid() throws ScriptException {
        int n = 0;
        int n2 = 1;
        float f = Float.MAX_VALUE;
        boolean bl = false;
        boolean bl2 = false;
        this.setShapeProperty(20, "thisID", null);
        switch (this.getToken((int)1).tok) {
            case 0x10000D: {
                n = Integer.MAX_VALUE;
                break;
            }
            case 0x10000C: {
                break;
            }
            case 2: {
                n = this.intParameter(1);
                break;
            }
            case 1085443: {
                this.sm.loadShape(20);
                this.setShapeProperty(20, "select", this.parameterAsString(2));
                n2 = this.iToken;
                bl = true;
                bl2 = true;
                break;
            }
            case 0x101000B1: 
            case 0x40000000: 
            case 1074790550: {
                this.sm.loadShape(20);
                if (this.theTok == 1074790550) {
                    ++n2;
                }
                this.setShapeId(20, n2, false);
                n2 = this.iToken;
                bl = true;
                break;
            }
            default: {
                this.invArg();
            }
        }
        if (!bl) {
            this.setShapeSizeBs(20, n, null);
            return;
        }
        block22: while (++n2 < this.slen) {
            String string = this.parameterAsString(n2);
            Object[] objectArray = null;
            this.getToken(n2);
            if (!bl2) {
                switch (this.theTok) {
                    case 0x100007: {
                        string = "points";
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = this.objectNameParameter(++n2);
                        if (this.chk) continue block22;
                        this.getShapePropertyData(24, "getVertices", objectArray2);
                        objectArray = objectArray2;
                        break;
                    }
                    case 1611272194: {
                        V3[] v3Array = new V3[3];
                        for (int i = 0; i < 3; ++i) {
                            v3Array[i] = new V3();
                            v3Array[i].setT(this.centerParameter(++n2));
                            n2 = this.iToken;
                        }
                        objectArray = v3Array;
                        break;
                    }
                    case 12289: {
                        objectArray = this.centerParameter(++n2);
                        n2 = this.iToken;
                        break;
                    }
                    case 1095761935: {
                        objectArray = this.intParameter(++n2);
                        break;
                    }
                    case 12291: {
                        objectArray = Boolean.TRUE;
                        this.checkLength(n2 + 1);
                    }
                }
            }
            if (objectArray == null) {
                switch (this.theTok) {
                    case 0x10000D: {
                        string = "on";
                        objectArray = Boolean.TRUE;
                        break;
                    }
                    case 0x10000C: {
                        string = "on";
                        objectArray = Boolean.FALSE;
                        break;
                    }
                    case 1073742138: {
                        objectArray = Float.valueOf(this.floatParameter(++n2));
                        break;
                    }
                    case 10: 
                    case 0x100001: {
                        string = "atoms";
                        objectArray = this.atomExpressionAt(n2);
                        n2 = this.iToken;
                        break;
                    }
                    case 603979967: 
                    case 1073742074: 
                    case 1766856708: {
                        f = this.getColorTrans(n2, true);
                        n2 = this.iToken;
                        continue block22;
                    }
                    case 1073742075: {
                        objectArray = this.parameterAsString(++n2);
                    }
                }
            }
            if (objectArray == null) {
                this.invArg();
            }
            this.setShapeProperty(20, string.toLowerCase(), objectArray);
        }
        this.finalizeObject(20, this.colorArgb[0], f, 0, false, null, 0, null);
        this.setShapeProperty(20, "thisID", null);
    }

    public String getShapeNameParameter(int n) throws ScriptException {
        String string = this.parameterAsString(n);
        boolean bl = string.equals("*");
        if (string.length() == 0) {
            this.invArg();
        }
        if (bl) {
            switch (this.tokAt(n + 1)) {
                case 0: 
                case 12291: 
                case 0x10000C: 
                case 0x10000D: 
                case 3145768: 
                case 3145770: 
                case 1766856708: {
                    break;
                }
                default: {
                    if (this.setMeshDisplayProperty(-1, 0, this.tokAt(n + 1))) break;
                    string = string + this.optParameterAsString(++n);
                }
            }
        }
        if (this.tokAt(n + 1) == 0x101000B1) {
            string = string + this.parameterAsString(++n);
        }
        this.iToken = n;
        return string;
    }

    public String setShapeId(int n, int n2, boolean bl) throws ScriptException {
        if (bl) {
            this.invArg();
        }
        String string = this.getShapeNameParameter(n2).toLowerCase();
        this.setShapeProperty(n, "thisID", string);
        return string;
    }

    private void setAtomShapeSize(int n, float f) throws ScriptException {
        RadiusData radiusData = null;
        int n2 = this.tokAt(1);
        boolean bl = false;
        switch (n2) {
            case 1073742072: {
                this.restrictSelected(false, false);
                break;
            }
            case 0x10000D: {
                break;
            }
            case 0x10000C: {
                f = 0.0f;
                break;
            }
            case 3: {
                bl = this.floatParameter(1) < 0.0f;
            }
            default: {
                radiusData = this.encodeRadiusParameter(1, bl, true);
                if (!Float.isNaN(radiusData.value)) break;
                this.invArg();
            }
        }
        if (radiusData == null) {
            radiusData = new RadiusData(null, f, RadiusData.EnumType.FACTOR, EnumVdw.AUTO);
        }
        if (bl) {
            this.restrictSelected(false, false);
        }
        this.setShapeSize(n, radiusData);
    }

    public RadiusData encodeRadiusParameter(int n, boolean bl, boolean bl2) throws ScriptException {
        float f = Float.NaN;
        RadiusData.EnumType enumType = RadiusData.EnumType.ABSOLUTE;
        EnumVdw enumVdw = null;
        int n2 = n == -1 ? 1649412120 : this.getToken((int)n).tok;
        switch (n2) {
            case 1112539137: 
            case 1112539138: 
            case 1112541195: 
            case 1112541199: 
            case 1114638362: 
            case 1649412120: {
                f = 1.0f;
                enumType = RadiusData.EnumType.FACTOR;
                enumVdw = n2 == 1649412120 ? null : EnumVdw.getVdwType2(T.nameOf(n2));
                n2 = this.tokAt(++n);
            }
        }
        switch (n2) {
            case 4141: {
                return this.viewer.getDefaultRadiusData();
            }
            case 1073741852: 
            case 0x40000020: 
            case 0x40000022: 
            case 1073741992: 
            case 1073742116: {
                f = 1.0f;
                enumType = RadiusData.EnumType.FACTOR;
                this.iToken = n - 1;
                break;
            }
            case 2: 
            case 3: 
            case 0x101000A1: {
                float f2;
                if (n2 == 0x101000A1) {
                    ++n;
                } else {
                    if (this.tokAt(n + 1) == 269484210) {
                        f = Math.round(this.floatParameter(n));
                        this.iToken = ++n;
                        enumType = RadiusData.EnumType.FACTOR;
                        if (f < 0.0f || f > 200.0f) {
                            this.integerOutOfRange(0, 200);
                        }
                        f /= 100.0f;
                        break;
                    }
                    if (n2 == 2) {
                        f = this.intParameter(n);
                        if (f > 749.0f || f < -200.0f) {
                            this.integerOutOfRange(-200, 749);
                        }
                        if (f > 0.0f) {
                            f /= 250.0f;
                            enumType = RadiusData.EnumType.ABSOLUTE;
                            break;
                        }
                        f /= -100.0f;
                        enumType = RadiusData.EnumType.FACTOR;
                        break;
                    }
                }
                if (n2 == 0x101000A1 || !bl2) {
                    enumType = RadiusData.EnumType.OFFSET;
                    f2 = 16.0f;
                } else {
                    enumType = RadiusData.EnumType.ABSOLUTE;
                    enumVdw = EnumVdw.NADA;
                    f2 = 100.0f;
                }
                f = this.floatParameterRange(n, bl || !bl2 ? -f2 : 0.0f, f2);
                if (bl) {
                    f = -f;
                }
                if (!(f > 16.0f)) break;
                f = 16.1f;
                break;
            }
            default: {
                if (f != 1.0f) break;
                --n;
            }
        }
        if (enumVdw == null && (enumVdw = EnumVdw.getVdwType(this.optParameterAsString(++this.iToken))) == null) {
            this.iToken = n;
            enumVdw = EnumVdw.AUTO;
        }
        return new RadiusData(null, f, enumType, enumVdw);
    }

    private void structure() throws ScriptException {
        EnumStructure enumStructure = EnumStructure.getProteinStructureType(this.parameterAsString(1));
        if (enumStructure == EnumStructure.NOT) {
            this.invArg();
        }
        BS bS = null;
        switch (this.tokAt(2)) {
            case 10: 
            case 0x100001: {
                bS = this.atomExpressionAt(2);
                this.checkLast(this.iToken);
                break;
            }
            default: {
                this.checkLength(2);
            }
        }
        if (this.chk) {
            return;
        }
        this.clearDefinedVariableAtomSets();
        this.viewer.setProteinType(enumStructure, bS);
    }

    private void wireframe() throws ScriptException {
        int n = Integer.MIN_VALUE;
        if (this.tokAt(1) == 4141) {
            this.checkLast(1);
        } else {
            n = this.getMadParameter();
        }
        if (this.chk) {
            return;
        }
        this.setShapeProperty(1, "type", 1023);
        this.setShapeSizeBs(1, n == Integer.MIN_VALUE ? 300 : n, null);
    }

    private void ssbond() throws ScriptException {
        int n = this.getMadParameter();
        this.setShapeProperty(1, "type", 256);
        this.setShapeSizeBs(1, n, null);
        this.setShapeProperty(1, "type", 1023);
    }

    private void hbond() throws ScriptException {
        if (this.slen == 2 && this.getToken((int)1).tok == 4102) {
            if (this.chk) {
                return;
            }
            int n = this.viewer.autoHbond(null, null, false);
            this.scriptStatusOrBuffer(GT.i(GT._("{0} hydrogen bonds"), Math.abs(n)));
            return;
        }
        if (this.slen == 2 && this.getToken((int)1).tok == 12291) {
            if (this.chk) {
                return;
            }
            this.connect(0);
            return;
        }
        int n = this.getMadParameter();
        this.setShapeProperty(1, "type", 30720);
        this.setShapeSizeBs(1, n, null);
        this.setShapeProperty(1, "type", 1023);
    }

    private void vector() throws ScriptException {
        RadiusData.EnumType enumType = RadiusData.EnumType.SCREEN;
        float f = 1.0f;
        this.checkLength(-3);
        this.iToken = this.slen;
        block0 : switch (this.iToken) {
            case 1: {
                break;
            }
            case 2: {
                switch (this.getToken((int)1).tok) {
                    case 0x10000D: {
                        break block0;
                    }
                    case 0x10000C: {
                        f = 0.0f;
                        break block0;
                    }
                    case 2: {
                        f = this.intParameterRange(1, 0, 19);
                        break block0;
                    }
                    case 3: {
                        enumType = RadiusData.EnumType.ABSOLUTE;
                        f = this.floatParameterRange(1, 0.0f, 3.0f);
                        break block0;
                    }
                }
                this.error(6);
                break;
            }
            case 3: {
                if (this.tokAt(1) != 1073742138) break;
                this.setFloatProperty("vectorScale", this.floatParameterRange(2, -100.0f, 100.0f));
                return;
            }
        }
        this.setShapeSize(18, new RadiusData(null, f, enumType, null));
    }

    private void vibration() throws ScriptException {
        this.checkLength(-3);
        float f = 0.0f;
        switch (this.getToken((int)1).tok) {
            case 0x10000D: {
                this.checkLength(2);
                f = this.viewer.getFloat(0x22000044);
                break;
            }
            case 0x10000C: {
                this.checkLength(2);
                f = 0.0f;
                break;
            }
            case 2: 
            case 3: {
                this.checkLength(2);
                f = this.floatParameter(1);
                break;
            }
            case 1073742138: {
                this.setFloatProperty("vibrationScale", this.floatParameterRange(2, -100.0f, 100.0f));
                return;
            }
            case 1073742090: {
                this.setFloatProperty("vibrationPeriod", this.floatParameter(2));
                return;
            }
            case 0x40000000: {
                this.invArg();
                break;
            }
            default: {
                f = -1.0f;
            }
        }
        if (f < 0.0f) {
            this.invArg();
        }
        if (this.chk) {
            return;
        }
        if (f == 0.0f) {
            this.viewer.setVibrationOff();
            return;
        }
        this.viewer.setVibrationPeriod(-f);
    }

    private void dots(int n) throws ScriptException {
        RadiusData radiusData;
        if (!this.chk) {
            this.sm.loadShape(n);
        }
        this.setShapeProperty(n, "init", null);
        float f = Float.NaN;
        RadiusData.EnumType enumType = RadiusData.EnumType.ABSOLUTE;
        int n2 = 1;
        block7: while (true) {
            switch (this.getToken((int)n2).tok) {
                case 1073742072: {
                    this.restrictSelected(false, false);
                    f = 1.0f;
                    enumType = RadiusData.EnumType.FACTOR;
                    break block7;
                }
                case 0x10000D: {
                    f = 1.0f;
                    enumType = RadiusData.EnumType.FACTOR;
                    break block7;
                }
                case 0x10000C: {
                    f = 0.0f;
                    break block7;
                }
                case 1073741976: {
                    this.setShapeProperty(n, "ignore", this.atomExpressionAt(n2 + 1));
                    n2 = this.iToken + 1;
                    continue block7;
                }
                case 2: {
                    int n3 = this.intParameter(n2);
                    if (this.tokAt(n2 + 1) != 1666189314) break block7;
                    ++n2;
                    this.setShapeProperty(n, "atom", n3);
                    this.setShapeProperty(n, "radius", Float.valueOf(this.floatParameter(++n2)));
                    if (this.tokAt(++n2) == 1766856708) {
                        this.setShapeProperty(n, "colorRGB", this.getArgbParam(++n2));
                        ++n2;
                    }
                    if (this.getToken((int)n2).tok != 10) {
                        this.invArg();
                    }
                    this.setShapeProperty(n, "dots", this.st[n2].value);
                    return;
                }
            }
            break;
        }
        RadiusData radiusData2 = radiusData = Float.isNaN(f) ? this.encodeRadiusParameter(n2, false, true) : new RadiusData(null, f, enumType, EnumVdw.AUTO);
        if (Float.isNaN(radiusData.value)) {
            this.invArg();
        }
        this.setShapeSize(n, radiusData);
    }

    private void proteinShape(int n) throws ScriptException {
        int n2 = 0;
        switch (this.getToken((int)1).tok) {
            case 1073742072: {
                if (this.chk) {
                    return;
                }
                this.restrictSelected(false, false);
                n2 = -1;
                break;
            }
            case 0x10000D: {
                n2 = -1;
                break;
            }
            case 0x10000C: {
                break;
            }
            case 1641025539: {
                n2 = -2;
                break;
            }
            case 1073741922: 
            case 1112541199: {
                n2 = -4;
                break;
            }
            case 2: {
                n2 = this.intParameterRange(1, 0, 1000) * 8;
                break;
            }
            case 3: {
                n2 = Math.round(this.floatParameterRange(1, -4.0f, 4.0f) * 2000.0f);
                if (n2 >= 0) break;
                this.restrictSelected(false, false);
                n2 = -n2;
                break;
            }
            case 10: {
                if (!this.chk) {
                    this.sm.loadShape(n);
                }
                this.setShapeProperty(n, "bitset", this.theToken.value);
                return;
            }
            default: {
                this.error(6);
            }
        }
        this.setShapeSizeBs(n, n2, null);
    }

    private void animation() throws ScriptException {
        boolean bl = false;
        switch (this.getToken((int)1).tok) {
            case 0x10000D: {
                bl = true;
            }
            case 0x10000C: {
                if (this.chk) break;
                this.viewer.setAnimationOn(bl);
                break;
            }
            case 1073742031: {
                int n = (int)this.floatParameter(2);
                if (this.chk) break;
                this.viewer.setAnimMorphCount(Math.abs(n));
                break;
            }
            case 1610625028: {
                this.iToken = 2;
                BS bS = this.tokAt(2) == 0x100003 ? null : this.atomExpressionAt(2);
                this.checkLength(this.iToken + 1);
                if (!this.chk) {
                    this.viewer.setAnimDisplay(bS);
                }
                return;
            }
            case 4115: {
                if (this.isArrayParameter(2)) {
                    float[] fArray = this.floatParameterSet(2, 0, Integer.MAX_VALUE);
                    this.checkLength(this.iToken + 1);
                    if (this.chk) {
                        return;
                    }
                    int[] nArray = new int[fArray.length];
                    int n = fArray.length;
                    while (--n >= 0) {
                        nArray[n] = (int)fArray[n];
                    }
                    Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                    hashtable.put("frames", nArray);
                    hashtable.put("currentFrame", 0);
                    this.viewer.setMovie(hashtable);
                    break;
                }
                this.model(2);
                break;
            }
            case 1073742024: {
                float f = 1.0f;
                float f2 = 1.0f;
                if (this.slen > 5) {
                    this.error(2);
                }
                EnumAnimationMode enumAnimationMode = null;
                switch (T.getTokFromName(this.parameterAsString(2))) {
                    case 1073742070: {
                        enumAnimationMode = EnumAnimationMode.ONCE;
                        f2 = 0.0f;
                        f = 0.0f;
                        break;
                    }
                    case 528410: {
                        enumAnimationMode = EnumAnimationMode.LOOP;
                        break;
                    }
                    case 1073742082: {
                        enumAnimationMode = EnumAnimationMode.PALINDROME;
                        break;
                    }
                    default: {
                        this.invArg();
                    }
                }
                if (this.slen >= 4) {
                    f = f2 = this.floatParameter(3);
                    if (this.slen == 5) {
                        f2 = this.floatParameter(4);
                    }
                }
                if (this.chk) break;
                this.viewer.setAnimationReplayMode(enumAnimationMode, f, f2);
                break;
            }
            case 1073741918: {
                int n = 2;
                int n2 = 0;
                switch (this.tokAt(n)) {
                    case 0x101000A0: {
                        n2 = -this.intParameter(++n);
                        break;
                    }
                    case 0x101000A1: {
                        n2 = this.intParameter(++n);
                        break;
                    }
                    case 2: {
                        n2 = this.intParameter(n);
                        break;
                    }
                    default: {
                        this.invArg();
                    }
                }
                this.checkLength(++n);
                if (n2 != 1 && n2 != -1) {
                    this.errorStr2(35, "-1", "1");
                }
                if (this.chk) break;
                this.viewer.setAnimationDirection(n2);
                break;
            }
            case 1074790526: {
                this.setIntProperty("animationFps", this.intParameter(this.checkLast(2)));
                break;
            }
            default: {
                this.frameControl(1);
            }
        }
    }

    private void assign() throws ScriptException {
        P3 p3;
        int n = this.tokAt(1);
        int n2 = this.atomExpressionAt(2).nextSetBit(0);
        int n3 = -1;
        String string = null;
        if (n2 < 0) {
            return;
        }
        if (n == 4106) {
            n3 = this.atomExpressionAt(++this.iToken).nextSetBit(0);
        } else {
            string = this.parameterAsString(++this.iToken);
        }
        P3 p32 = p3 = ++this.iToken < this.slen ? this.centerParameter(this.iToken) : null;
        if (this.chk) {
            return;
        }
        switch (n) {
            case 0x44100001: {
                this.clearDefinedVariableAtomSets();
                this.viewer.assignAtom(n2, p3, string);
                break;
            }
            case 1678770178: {
                this.viewer.assignBond(n2, (string + "p").charAt(0));
                break;
            }
            case 4106: {
                this.viewer.assignConnect(n2, n3);
            }
        }
    }

    private void file() throws ScriptException {
        int n = this.intParameter(this.checkLast(1));
        if (this.chk) {
            return;
        }
        int n2 = this.viewer.getModelNumberIndex(n * 1000000 + 1, false, false);
        int n3 = -1;
        if (n2 >= 0) {
            n3 = this.viewer.getModelNumberIndex((n + 1) * 1000000 + 1, false, false);
            if (n3 < 0) {
                n3 = this.viewer.getModelCount();
            }
            --n3;
        }
        this.viewer.setAnimationOn(false);
        this.viewer.setAnimationDirection(1);
        this.viewer.setAnimationRange(n2, n3);
        this.viewer.setCurrentModelIndex(-1);
    }

    private void fixed() throws ScriptException {
        BS bS;
        BS bS2 = bS = this.slen == 1 ? null : this.atomExpressionAt(1);
        if (this.chk) {
            return;
        }
        this.viewer.setMotionFixedAtoms(bS);
    }

    private void model(int n) throws ScriptException {
        int n2;
        int n3;
        boolean bl = this.theTok == 4115;
        boolean bl2 = true;
        if (this.slen == 1 && n == 1) {
            int n4;
            int n5 = this.viewer.getCurrentModelIndex();
            if (!this.chk && n5 >= 0 && (n4 = this.viewer.getJmolDataSourceFrame(n5)) >= 0) {
                this.viewer.setCurrentModelIndex(n4 == n5 ? Integer.MIN_VALUE : n4);
            }
            return;
        }
        switch (this.tokAt(1)) {
            case 2: {
                if (!bl || this.slen != 2) break;
                if (!this.chk) {
                    this.viewer.setFrame(this.intParameter(1));
                }
                return;
            }
            case 10: 
            case 0x100001: {
                int n6 = this.atomExpressionAt(1).nextSetBit(0);
                this.checkLength(this.iToken + 1);
                if (this.chk || n6 < 0) {
                    return;
                }
                BS bS = new BS();
                bS.set(n6);
                this.viewer.setCurrentModelIndex(this.viewer.getModelBitSet(bS, false).nextSetBit(0));
                return;
            }
            case 0x40000050: {
                this.iToken = 1;
                int n7 = this.tokAt(2) == 2 ? this.intParameter(++this.iToken) : 1;
                this.checkLength(this.iToken + 1);
                if (!this.chk && n7 > 0) {
                    this.viewer.createModels(n7);
                }
                return;
            }
            case 1074790550: {
                this.checkLength(3);
                String string = this.stringParameter(2);
                if (!this.chk) {
                    this.viewer.setCurrentModelID(string);
                }
                return;
            }
            case 528397: {
                long l = 0L;
                this.checkLength(3);
                switch (this.getToken((int)2).tok) {
                    case 2: 
                    case 3: {
                        l = (long)(this.floatParameter(2) * 1000.0f);
                        break;
                    }
                    default: {
                        this.error(20);
                    }
                }
                if (!this.chk) {
                    this.viewer.setFrameDelayMs(l);
                }
                return;
            }
            case 1073742166: {
                if (this.checkLength23() > 0 && !this.chk) {
                    this.viewer.setFrameTitleObj(this.slen == 2 ? "@{_modelName}" : (this.tokAt(2) == 7 ? SV.listValue(this.st[2]) : this.parameterAsString(2)));
                }
                return;
            }
            case 0x40000008: {
                BS bS;
                BS bS2 = bS = this.slen == 2 || this.tokAt(2) == 0x10000B ? null : this.atomExpressionAt(2);
                if (!this.chk) {
                    this.viewer.setFrameOffsets(bS);
                }
                return;
            }
        }
        if (this.getToken((int)n).tok == 0x101000A0) {
            if (this.getToken((int)this.checkLast((int)(++n))).tok != 2 || this.intParameter(n) != 1) {
                this.invArg();
            }
            if (!this.chk) {
                this.viewer.setAnimation(1073742108);
            }
            return;
        }
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int[] nArray = new int[]{-1, -1};
        int n8 = 0;
        float f = 0.0f;
        boolean bl7 = this.viewer.haveFileSet();
        block21: for (n3 = n; n3 < this.slen; ++n3) {
            switch (this.getToken((int)n3).tok) {
                case 0x100003: 
                case 0x101000B1: {
                    this.checkLength(n + (bl4 ? 2 : 1));
                    bl5 = true;
                    continue block21;
                }
                case 0x101000A0: {
                    if (n8 != 1) {
                        this.invArg();
                    }
                    bl6 = true;
                    continue block21;
                }
                case 0x10000B: {
                    this.checkLength(n + 1);
                    continue block21;
                }
                case 3: {
                    float f2;
                    bl2 = false;
                    f = this.floatParameter(n3);
                    if (f2 < 0.0f) {
                        this.checkLength(n3 + 1);
                        if (!this.chk) {
                            this.viewer.morph(-f);
                        }
                        return;
                    }
                }
                case 2: 
                case 4: {
                    if (n8 == 2) {
                        this.invArg();
                    }
                    int n9 = n2 = this.theTok == 4 ? ScriptEvaluator.getFloatEncodedInt((String)this.theToken.value) : this.theToken.intValue;
                    if (n2 < 0 && n8 == 1) {
                        bl6 = true;
                        n2 = -n2;
                        if (bl7 && n2 < 1000000) {
                            n2 *= 1000000;
                        }
                    }
                    if (this.theTok == 3 && bl7 && f == (float)((int)f)) {
                        n2 = (int)f * 1000000;
                    }
                    if (n2 == Integer.MAX_VALUE) {
                        if (n3 == 1) {
                            int n10;
                            String string = this.theToken.value.toString();
                            int n11 = n10 = this.chk ? -1 : this.viewer.getModelIndexFromId(string);
                            if (n10 >= 0) {
                                this.checkLength(2);
                                this.viewer.setCurrentModelIndex(n10);
                                return;
                            }
                        }
                        n2 = 0;
                    }
                    if (n2 == -1) {
                        this.checkLength(n + 1);
                        if (!this.chk) {
                            this.viewer.setAnimation(1073742108);
                        }
                        return;
                    }
                    if (n2 >= 1000 && n2 < 1000000 && bl7) {
                        n2 = n2 / 1000 * 1000000 + n2 % 1000;
                    }
                    if (!bl2 && n2 == 0 && n8 == 0) {
                        bl5 = true;
                    }
                    if (n2 >= 1000000) {
                        bl2 = false;
                    }
                    nArray[n8++] = n2;
                    continue block21;
                }
                case 0x40000110: {
                    bl3 = true;
                    continue block21;
                }
                case 1073742114: {
                    bl4 = true;
                    continue block21;
                }
                default: {
                    this.frameControl(n);
                    return;
                }
            }
        }
        if (bl4 && n8 == 0) {
            bl5 = true;
        }
        if (this.chk) {
            return;
        }
        if (bl5) {
            this.viewer.setAnimationOn(false);
            this.viewer.setAnimationRange(-1, -1);
            if (!bl4) {
                this.viewer.setCurrentModelIndex(-1);
            }
            return;
        }
        if (n8 == 2 && !bl4) {
            bl6 = true;
        }
        if (bl7) {
            bl2 = false;
        } else if (bl2) {
            for (n3 = 0; n3 < n8; ++n3) {
                if (nArray[n3] < 0) continue;
                int n12 = n3;
                nArray[n12] = nArray[n12] % 1000000;
            }
        }
        n3 = this.viewer.getModelNumberIndex(nArray[0], bl2, false);
        n2 = -1;
        if (bl7 && n3 < 0 && nArray[0] != 0) {
            if (nArray[0] < 1000000) {
                nArray[0] = nArray[0] * 1000000;
            }
            if (n8 == 2 && nArray[1] < 1000000) {
                nArray[1] = nArray[1] * 1000000;
            }
            if (nArray[0] % 1000000 == 0) {
                nArray[0] = nArray[0] + 1;
                n3 = this.viewer.getModelNumberIndex(nArray[0], false, false);
                if (n3 >= 0) {
                    int n13 = n8 == 1 ? nArray[0] + 1000000 : (nArray[1] == 0 ? -1 : (nArray[1] % 1000000 == 0 ? nArray[1] + 1000001 : nArray[1] + 1));
                    n2 = this.viewer.getModelNumberIndex(n13, false, false);
                    if (n2 < 0) {
                        n2 = this.viewer.getModelCount();
                    }
                    --n2;
                    if (bl4) {
                        n8 = 2;
                    } else if (!bl6 && n2 != n3) {
                        bl6 = true;
                    }
                    bl4 = bl4 || n3 == n2;
                }
            } else {
                return;
            }
        }
        if (!bl3 && !bl4 || n3 >= 0) {
            this.viewer.setCurrentModelIndexClear(n3, false);
        }
        if (bl3 && n8 == 2 || bl4 || bl6) {
            if (n2 < 0) {
                n2 = this.viewer.getModelNumberIndex(nArray[1], bl2, false);
            }
            this.viewer.setAnimationOn(false);
            this.viewer.setAnimationDirection(1);
            this.viewer.setAnimationRange(n3, n2);
            this.viewer.setCurrentModelIndexClear(bl6 && !bl4 ? -1 : (n3 >= 0 ? n3 : 0), false);
        }
        if (bl3) {
            this.viewer.setAnimation(266287);
        }
    }

    BS bitSetForModelFileNumber(int n) {
        int n2;
        BS bS = BSUtil.newBitSet(this.viewer.getAtomCount());
        if (this.chk) {
            return bS;
        }
        int n3 = this.viewer.getModelCount();
        boolean bl = this.viewer.haveFileSet();
        if (n < 1000000 && bl) {
            n *= 1000000;
        }
        if ((n2 = n % 1000000) == 0) {
            int n4;
            int n5 = this.viewer.getModelNumberIndex(n + 1, false, false);
            if (n5 < 0) {
                return bS;
            }
            int n6 = n4 = n == 0 ? n3 : this.viewer.getModelNumberIndex(n + 1000001, false, false);
            if (n5 < 0) {
                n5 = 0;
            }
            if (n4 < 0) {
                n4 = n3;
            }
            if (this.viewer.isTrajectory(n5)) {
                n4 = n5 + 1;
            }
            for (int i = n5; i < n4; ++i) {
                bS.or(this.viewer.getModelUndeletedAtomsBitSet(i));
            }
        } else {
            int n7 = this.viewer.getModelNumberIndex(n, false, true);
            if (n7 >= 0) {
                bS.or(this.viewer.getModelUndeletedAtomsBitSet(n7));
            }
        }
        return bS;
    }

    private void frameControl(int n) throws ScriptException {
        switch (this.getToken((int)this.checkLast((int)n)).tok) {
            case 20487: 
            case 266287: 
            case 1073741942: 
            case 1073741993: 
            case 1073742037: 
            case 0x40000110: 
            case 1073742098: 
            case 1073742108: 
            case 1073742126: {
                if (!this.chk) {
                    this.viewer.setAnimation(this.theTok);
                }
                return;
            }
        }
        this.invArg();
    }

    private int getShapeType(int n) throws ScriptException {
        int n2 = JC.shapeTokenIndex(n);
        if (n2 < 0) {
            this.error(49);
        }
        return n2;
    }

    private void font(int n, float f) throws ScriptException {
        String string = "SansSerif";
        String string2 = "Plain";
        int n2 = 0;
        float f2 = -1.0f;
        this.iToken = this.slen;
        switch (this.iToken) {
            case 6: {
                f2 = this.floatParameter(5);
                if (f2 >= 5.0f) {
                    f2 = this.viewer.getZoomSetting() / f2 / this.viewer.getScalePixelsPerAngstrom(false);
                }
            }
            case 5: {
                if (this.getToken((int)4).tok != 0x40000000) {
                    this.invArg();
                }
                string2 = this.parameterAsString(4);
            }
            case 4: {
                if (this.getToken((int)3).tok != 0x40000000) {
                    this.invArg();
                }
                string = this.parameterAsString(3);
                if (!this.isFloatParameter(2)) {
                    this.error(34);
                }
                f = this.floatParameter(2);
                n = this.getShapeType(this.getToken((int)1).tok);
                break;
            }
            case 3: {
                if (!this.isFloatParameter(2)) {
                    this.error(34);
                }
                if (n == -1) {
                    n = this.getShapeType(this.getToken((int)1).tok);
                    f = this.floatParameter(2);
                    break;
                }
                if (!(f >= 1.0f)) break;
                n2 = 5;
                f += (float)5;
                break;
            }
            default: {
                if (n == 5) {
                    f = 13.0f;
                    break;
                }
                this.error(2);
            }
        }
        if (n == 5) {
            if (f < 0.0f || f >= 1.0f && (f < 6.0f || f > 63.0f)) {
                this.integerOutOfRange(6 - n2, 63 - n2);
            }
            this.setShapeProperty(5, "setDefaults", this.viewer.getNoneSelected());
        }
        if (this.chk) {
            return;
        }
        if (GData.getFontStyleID(string) >= 0) {
            string2 = string;
            string = "SansSerif";
        }
        Font font = this.viewer.getFont3D(string, string2, f);
        this.sm.loadShape(n);
        this.setShapeProperty(n, "font", font);
        if (f2 >= 0.0f) {
            this.setShapeProperty(n, "scalereference", Float.valueOf(f2));
        }
    }

    private void set() throws ScriptException {
        boolean bl;
        int n;
        Object object;
        String string;
        if (this.slen == 1) {
            this.showString(this.viewer.getAllSettings(null));
            return;
        }
        boolean bl2 = this.parameterAsString(0).equals("set");
        String string2 = this.optParameterAsString(1);
        if (bl2 && this.slen == 2 && string2.indexOf("?") >= 0) {
            this.showString(this.viewer.getAllSettings(string2.substring(0, string2.indexOf("?"))));
            return;
        }
        int n2 = this.getToken((int)1).tok;
        int n3 = 0;
        int n4 = Integer.MAX_VALUE;
        boolean bl3 = !this.chk && !this.tQuiet && this.scriptLevel <= this.scriptReportingLevel && !((String)this.st[0].value).equals("var");
        switch (n2) {
            case 1611272194: {
                this.axes(2);
                return;
            }
            case 1610616835: {
                this.background(2);
                return;
            }
            case 1679429641: {
                this.boundbox(2);
                return;
            }
            case 1611272202: {
                this.frank(2);
                return;
            }
            case 1610616855: {
                this.history(2);
                return;
            }
            case 1826248715: {
                this.label(2);
                return;
            }
            case 1614417948: {
                this.unitcell(2);
                return;
            }
            case 0x20000008: {
                this.sm.loadShape(8);
                this.setShapeProperty(8, "highlight", this.tokAt(2) == 0x10000C ? null : this.atomExpressionAt(2));
                return;
            }
            case 1610625028: 
            case 1611141171: {
                this.selectionHalo(2);
                return;
            }
            case 536875070: {
                this.timeout(2);
                return;
            }
        }
        switch (n2) {
            case 1641025539: {
                float[] fArray;
                EnumStructure enumStructure = EnumStructure.getProteinStructureType(this.parameterAsString(2));
                if (enumStructure == EnumStructure.NOT) {
                    this.invArg();
                }
                if ((fArray = this.floatParameterSet(3, 0, Integer.MAX_VALUE)).length % 4 != 0) {
                    this.invArg();
                }
                this.viewer.setStructureList(fArray, enumStructure);
                this.checkLast(this.iToken);
                return;
            }
            case 545259526: {
                n4 = this.getArgbParam(2);
                if (!this.chk) {
                    this.setObjectArgb("axes", n4);
                }
                return;
            }
            case 0x60000001: {
                this.setBondmode();
                return;
            }
            case 0x20000004: {
                if (this.chk) {
                    return;
                }
                int n5 = this.tokAt(2) == 0x10000C || this.tokAt(2) == 2 && this.intParameter(2) == 0 ? 4 : 5;
                Logger.setLogLevel(n5);
                this.setIntProperty("logLevel", n5);
                if (n5 == 4) {
                    this.viewer.setDebugScript(false);
                    if (bl3) {
                        this.viewer.showParameter("debugScript", true, 80);
                    }
                }
                this.setDebugging();
                if (bl3) {
                    this.viewer.showParameter("logLevel", true, 80);
                }
                return;
            }
            case 537022465: {
                this.setEcho();
                return;
            }
            case 0x60000002: {
                this.font(5, this.checkLength23() == 2 ? 0.0f : this.floatParameter(2));
                return;
            }
            case 1612189718: {
                this.setHbond();
                return;
            }
            case 0x20021010: 
            case 1746538509: {
                this.setMonitor();
                return;
            }
            case 1611141176: {
                this.setSsbond();
                return;
            }
            case 0x60000005: {
                this.setLabel("toggle");
                return;
            }
            case 0x20000012: {
                this.setUserColors();
                return;
            }
            case 553648188: {
                this.setZslab();
                return;
            }
        }
        boolean bl4 = true;
        switch (n2) {
            case 0x20000002: {
                int n6;
                if (this.slen <= 2) break;
                String string3 = this.stringSetting(2, false);
                boolean bl5 = false;
                if (string3.indexOf(".") < 0) {
                    n6 = PT.parseInt(string3);
                    bl5 = true;
                } else {
                    n6 = ScriptEvaluator.getFloatEncodedInt(string3);
                }
                if (this.chk) {
                    return;
                }
                int n7 = this.viewer.getModelNumberIndex(n6, bl5, true);
                this.viewer.setBackgroundModelIndex(n7);
                return;
            }
            case 1649412120: {
                if (this.chk) {
                    return;
                }
                this.viewer.setAtomProperty(this.viewer.getAllAtoms(), 1649412120, -1, Float.NaN, null, null, null);
                switch (this.tokAt(2)) {
                    case 1073742109: {
                        this.runScript("#VDW radii for PROBE;{_H}.vdw = 1.0;{_H and connected(_C) and not connected(within(smiles,'[a]'))}.vdw = 1.17;{_C}.vdw = 1.75;{_C and connected(3) and connected(_O)}.vdw = 1.65;{_N}.vdw = 1.55;{_O}.vdw = 1.4;{_P}.vdw = 1.8;{_S}.vdw = 1.8;message VDW radii for H, C, N, O, P, and S set according to Word, et al., J. Mol. Biol. (1999) 285, 1711-1733");
                        return;
                    }
                }
                n3 = 545259555;
            }
            case 545259555: {
                if (this.slen <= 2) break;
                String string4 = string = this.slen == 3 && EnumVdw.getVdwType(this.parameterAsString(2)) == null ? this.stringSetting(2, false) : this.parameterAsString(2);
                if (EnumVdw.getVdwType(string) == null) {
                    this.invArg();
                }
                this.setStringProperty(string2, string);
                break;
            }
            case 0x20000006: {
                P3 p3;
                if (this.slen <= 2) break;
                object = this.parameterExpressionToken(2);
                if (((SV)object).tok == 8) {
                    p3 = (P3)((SV)object).value;
                } else {
                    n = ((SV)object).asInt();
                    p3 = new P3();
                    if (n >= 555) {
                        SimpleUnitCell.ijkToPoint3f(n + 111, p3, 0);
                    }
                }
                if (this.chk) break;
                this.viewer.setDefaultLattice(p3);
                break;
            }
            case 545259545: 
            case 0x20800020: {
                if (this.slen <= 2) break;
                this.theTok = this.tokAt(2);
                string = this.theTok == 1073741992 || this.theTok == 1073742116 ? this.parameterAsString(this.checkLast(2)) : this.stringSetting(2, false);
                this.setStringProperty(string2, string);
                break;
            }
            case 1632634891: {
                n4 = this.intSetting(2);
                if (n4 == Integer.MIN_VALUE) {
                    this.invArg();
                }
                if (!this.chk) {
                    this.viewer.setFormalCharges(n4);
                }
                return;
            }
            case 553648148: {
                n4 = this.intSetting(2);
                if (this.chk) break;
                if (n4 != Integer.MIN_VALUE) {
                    this.commandHistoryLevelMax = n4;
                }
                this.setIntProperty(string2, n4);
                break;
            }
            case 545259564: {
                if (this.slen <= 2) break;
                this.setStringProperty(string2, this.stringSetting(2, bl2));
                break;
            }
            case 545259558: 
            case 545259568: {
                if (this.slen <= 2) break;
                this.setUnits(this.stringSetting(2, bl2), n2);
                break;
            }
            case 545259572: {
                if (!this.chk) {
                    this.viewer.setPicked(-1);
                }
                if (this.slen <= 2) break;
                this.setPicking();
                return;
            }
            case 545259574: {
                if (this.slen <= 2) break;
                this.setPickingStyle();
                return;
            }
            case 1716520985: {
                break;
            }
            case 553648168: {
                n4 = this.intSetting(2);
                if (this.chk || n4 == Integer.MIN_VALUE) break;
                this.scriptReportingLevel = n4;
                this.setIntProperty(string2, this.scriptReportingLevel);
                break;
            }
            case 0x2000000C: {
                n4 = this.intSetting(2);
                if (n4 == Integer.MIN_VALUE || n4 == 0 || n4 == 1) {
                    bl4 = false;
                    break;
                }
                n2 = 553648174;
                string2 = "specularPercent";
                this.setIntProperty(string2, n4);
                break;
            }
            case 1650071565: {
                n2 = 553648178;
                string2 = "strandCount";
                this.setIntProperty(string2, this.intSetting(2));
                break;
            }
            default: {
                bl4 = false;
            }
        }
        if (bl4 && !bl3) {
            return;
        }
        boolean bl6 = bl = !bl4 && !bl2 && this.getContextVariableAsVariable(string2) != null;
        if (!bl4 && !bl) {
            switch (n2) {
                case 1678770178: {
                    n3 = 603979928;
                    break;
                }
                case 0x60300006: {
                    n3 = 603979908;
                    break;
                }
                case 1613758476: {
                    n3 = 603979910;
                    break;
                }
                case 0x60000003: {
                    n3 = 603979879;
                    break;
                }
                case 1666189314: {
                    n3 = 0x22000032;
                    this.setFloatProperty("solventProbeRadius", this.floatSetting(2));
                    bl4 = true;
                    break;
                }
                case 0x60000004: {
                    n3 = 0x2200002E;
                    break;
                }
                case 1613758488: {
                    n3 = 603979948;
                    break;
                }
                case 1766856708: {
                    n3 = 545259545;
                    break;
                }
                case 1611141175: {
                    string = this.parameterAsString(2).toLowerCase();
                    switch ("x;y;z;fps".indexOf(string + ";")) {
                        case 0: {
                            n3 = 570425398;
                            break;
                        }
                        case 2: {
                            n3 = 570425400;
                            break;
                        }
                        case 4: {
                            n3 = 570425402;
                            break;
                        }
                        case 6: {
                            n3 = 570425396;
                            break;
                        }
                        default: {
                            this.errorStr2(50, "set SPIN ", string);
                        }
                    }
                    if (!this.chk) {
                        this.viewer.setSpin(string, (int)this.floatParameter(this.checkLast(3)));
                    }
                    bl4 = true;
                }
            }
        }
        if (n3 != 0) {
            n2 = n3;
            string2 = T.nameOf(n2);
        } else if (!bl4 && !bl) {
            if (string2.length() == 0 || string2.charAt(0) == '_') {
                this.error(56);
            }
            if (((String)(object = string2.toLowerCase())).indexOf("label") == 0 && PT.isOneOf(string2.substring(5).toLowerCase(), ";front;group;atom;offset;offsetexact;pointer;alignment;toggle;scalereference;") && this.setLabel(string2.substring(5))) {
                return;
            }
            if (bl2 && ((String)object).indexOf("shift_") == 0) {
                float f = this.floatParameter(2);
                this.checkLength(3);
                if (!this.chk) {
                    this.viewer.getNMRCalculation().setChemicalShiftReference(((String)object).substring(6), f);
                }
                return;
            }
            if (((String)object).endsWith("callback")) {
                n2 = 0x20000000;
            }
        }
        if (bl2 && !T.tokAttr(n2, 0x20000000)) {
            this.iToken = 1;
            if (!this.isStateScript) {
                this.errorStr2(50, "SET", string2);
            }
            this.warning(51, "SET", string2);
        }
        if (!bl4 && bl2) {
            switch (this.slen) {
                case 2: {
                    this.setBooleanProperty(string2, true);
                    bl4 = true;
                    break;
                }
                case 3: {
                    if (n4 == Integer.MAX_VALUE) break;
                    this.setIntProperty(string2, n4);
                    bl4 = true;
                }
            }
        }
        if (!bl4 && !bl2 && this.tokAt(2) == 0x10000B) {
            if (!this.chk) {
                this.viewer.removeUserVariable(string2.toLowerCase());
            }
            bl4 = true;
        }
        if (!bl4) {
            int n8 = this.tokAt(1) == 0x100001 ? 0 : this.tokAt(2);
            n = this.st[0].intValue;
            int n9 = n8 == 269484436 ? 3 : (n == 61 && !string2.equals("return") && n8 != 269484436 ? 0 : 2);
            this.setVariable(n9, 0, string2, n);
            if (!bl2) {
                return;
            }
        }
        if (bl3) {
            this.viewer.showParameter(string2, true, 80);
        }
    }

    private void setZslab() throws ScriptException {
        P3 p3 = null;
        if (this.isFloatParameter(2)) {
            this.checkLength(3);
            this.setIntProperty("zSlab", (int)this.floatParameter(2));
        } else {
            if (!this.isCenterParameter(2)) {
                this.invArg();
            }
            p3 = this.centerParameter(2);
            this.checkLength(this.iToken + 1);
        }
        if (!this.chk) {
            this.viewer.setZslabPoint(p3);
        }
    }

    private void setBondmode() throws ScriptException {
        boolean bl = false;
        switch (this.getToken((int)this.checkLast((int)2)).tok) {
            case 0x10100060: {
                break;
            }
            case 0x10100050: {
                bl = true;
                break;
            }
            default: {
                this.invArg();
            }
        }
        this.setBooleanProperty("bondModeOr", bl);
    }

    private void setEcho() throws ScriptException {
        String string = null;
        Object object = null;
        Object object2 = null;
        boolean bl = true;
        int n = 2;
        switch (this.getToken((int)2).tok) {
            case 0x10000C: {
                string = "allOff";
                object2 = "allOff";
                this.checkLength(++n);
                break;
            }
            case 0x10000B: {
                bl = false;
            }
            case 0x100003: {
                object2 = this.parameterAsString(2);
                this.checkLength(++n);
                break;
            }
            case 4: 
            case 12289: 
            case 0x40000000: 
            case 1073741871: 
            case 1073741996: 
            case 1073742019: 
            case 1073742128: 
            case 1074790550: 
            case 1074790748: {
                if (this.theTok == 1074790550) {
                    // empty if block
                }
                int n2 = ++n;
                ++n;
                object2 = this.parameterAsString(n2);
            }
        }
        if (!this.chk) {
            this.viewer.setEchoStateActive(bl);
            this.sm.loadShape(30);
            if (object2 != null) {
                this.setShapeProperty(30, string == null ? "target" : string, object2);
            }
        }
        if (n < this.slen) {
            block6 : switch (this.getToken((int)n++).tok) {
                case 0x40000008: {
                    string = "align";
                    switch (this.getToken((int)n).tok) {
                        case 12289: 
                        case 1073741996: 
                        case 1073742128: {
                            object = this.parameterAsString(n++);
                            break block6;
                        }
                    }
                    this.invArg();
                    break;
                }
                case 12289: 
                case 1073741996: 
                case 1073742128: {
                    string = "align";
                    object = this.parameterAsString(n - 1);
                    break;
                }
                case 554176526: {
                    string = "%zpos";
                    object = (int)this.floatParameter(n++);
                    break;
                }
                case 0x10000D: 
                case 3145768: 
                case 1610625028: {
                    string = "hidden";
                    object = Boolean.FALSE;
                    break;
                }
                case 12294: 
                case 3145770: {
                    string = "hidden";
                    object = Boolean.TRUE;
                    break;
                }
                case 1095766030: {
                    int n3;
                    int n4 = n3 = this.chk ? 0 : this.modelNumberParameter(n++);
                    if (n3 >= this.viewer.getModelCount()) {
                        this.invArg();
                    }
                    string = "model";
                    object = n3;
                    break;
                }
                case 0x10100040: 
                case 1073742195: {
                    string = "xypos";
                    object = this.xypParameter(--n);
                    if (object == null) {
                        --n;
                        break;
                    }
                    n = this.iToken + 1;
                    break;
                }
                case 2: {
                    int n5 = --n;
                    int n6 = this.intParameter(n5);
                    String string2 = "xpos";
                    if (this.tokAt(++n) == 269484210) {
                        string2 = "%xpos";
                    }
                    string = "ypos";
                    int n7 = ++n;
                    object = this.intParameter(n7);
                    if (this.tokAt(++n) == 269484210) {
                        string = "%ypos";
                        ++n;
                    }
                    this.checkLength(n);
                    this.setShapeProperty(30, string2, n6);
                    break;
                }
                case 0x10000C: {
                    string = "off";
                    break;
                }
                case 1073742138: {
                    string = "scale";
                    object = Float.valueOf(this.floatParameter(n++));
                    break;
                }
                case 135271429: {
                    string = "script";
                    object = this.parameterAsString(n++);
                    break;
                }
                case 4: 
                case 1073741979: {
                    boolean bl2;
                    boolean bl3 = bl2 = this.theTok == 1073741979;
                    if (bl2) {
                        ++n;
                    }
                    this.checkLength(n);
                    if (object2 == null && bl2) {
                        Object[] objectArray = new String[1];
                        this.getShapePropertyData(30, "currentTarget", objectArray);
                        object2 = objectArray[0];
                    }
                    this.echo(n - 1, (String)object2, bl2);
                    return;
                }
                case 0x8100010: {
                    string = "point";
                    object = this.isCenterParameter(n) ? this.centerParameter(n) : null;
                    n = this.iToken + 1;
                    break;
                }
                default: {
                    if (this.isCenterParameter(n - 1)) {
                        string = "xyz";
                        object = this.centerParameter(n - 1);
                        n = this.iToken + 1;
                        break;
                    }
                    this.invArg();
                }
            }
        }
        this.checkLength(n);
        if (!this.chk && string != null) {
            this.setShapeProperty(30, string, object);
        }
    }

    private int intSetting(int n) throws ScriptException {
        if (n == this.slen) {
            return Integer.MIN_VALUE;
        }
        return this.parameterExpressionToken(n).asInt();
    }

    private float floatSetting(int n) throws ScriptException {
        if (n == this.slen) {
            return Float.NaN;
        }
        return SV.fValue(this.parameterExpressionToken(n));
    }

    private String stringSetting(int n, boolean bl) throws ScriptException {
        if (bl && this.slen == n + 1) {
            return this.parameterAsString(n);
        }
        return this.parameterExpressionToken(n).asString();
    }

    private boolean setLabel(String string) throws ScriptException {
        this.sm.loadShape(5);
        Object object = null;
        this.setShapeProperty(5, "setDefaults", this.viewer.getNoneSelected());
        if (string.equals("scalereference")) {
            float f = this.floatParameter(2);
            if (f >= 5.0f) {
                f = this.viewer.getZoomSetting() / f / this.viewer.getScalePixelsPerAngstrom(false);
            }
            object = Float.valueOf(f);
        } else if (string.equals("offset") || string.equals("offsetexact")) {
            if (this.isPoint3f(2)) {
                P3 p3 = this.getPoint3f(2, false);
                object = new float[]{1.0f, p3.x, p3.y, p3.z, 0.0f, 0.0f, 0.0f};
            } else if (this.isArrayParameter(2)) {
                object = this.floatParameterSet(2, 7, 7);
            } else {
                int n = this.intParameterRange(2, -127, 127);
                int n2 = this.intParameterRange(3, -127, 127);
                object = JC.getOffset(n, n2);
            }
        } else if (string.equals("alignment")) {
            switch (this.getToken((int)2).tok) {
                case 12289: 
                case 1073741996: 
                case 1073742128: {
                    string = "align";
                    object = this.theToken.value;
                    break;
                }
                default: {
                    this.invArg();
                    break;
                }
            }
        } else if (string.equals("pointer")) {
            int n = 0;
            switch (this.getToken((int)2).tok) {
                case 0x10000B: 
                case 0x10000C: {
                    break;
                }
                case 1610616835: {
                    n |= 2;
                }
                case 0x10000D: {
                    n |= 1;
                    break;
                }
                default: {
                    this.invArg();
                }
            }
            object = n;
        } else {
            boolean bl;
            if (string.equals("toggle")) {
                this.iToken = 1;
                BS bS = this.slen == 2 ? null : this.atomExpressionAt(2);
                this.checkLast(this.iToken);
                if (!this.chk) {
                    this.viewer.togglePickingLabel(bS);
                }
                return true;
            }
            this.iToken = 1;
            boolean bl2 = bl = this.slen == 2 || this.getToken((int)2).tok == 0x10000D;
            if (string.equals("front") || string.equals("group")) {
                if (!bl && this.tokAt(2) != 0x10000C) {
                    this.invArg();
                }
                if (!bl) {
                    string = "front";
                }
                object = bl ? Boolean.TRUE : Boolean.FALSE;
            } else if (string.equals("atom")) {
                if (!bl && this.tokAt(2) != 0x10000C) {
                    this.invArg();
                }
                string = "front";
                object = bl ? Boolean.FALSE : Boolean.TRUE;
            } else {
                return false;
            }
        }
        BS bS = this.iToken + 1 < this.slen ? this.atomExpressionAt(++this.iToken) : null;
        this.checkLast(this.iToken);
        if (this.chk) {
            return true;
        }
        if (bS == null) {
            this.setShapeProperty(5, string, object);
        } else {
            this.setShapePropertyBs(5, string, object, bS);
        }
        return true;
    }

    private void setMonitor() throws ScriptException {
        int n = this.tokAt(this.checkLast(2));
        switch (n) {
            case 0x10000C: 
            case 0x10000D: {
                this.setBooleanProperty("measurementlabels", n == 0x10000D);
                return;
            }
            case 2: 
            case 3: 
            case 0x40000066: {
                this.viewer.loadShape(6);
                this.setShapeSizeBs(6, this.getSetAxesTypeMad(2), null);
                return;
            }
        }
        this.setUnits(this.parameterAsString(2), 545259568);
    }

    private boolean setUnits(String string, int n) throws ScriptException {
        if (n == 545259568 && (string.endsWith("hz") || PT.isOneOf(string.toLowerCase(), ";angstroms;au;bohr;nanometers;nm;picometers;pm;vanderwaals;vdw;"))) {
            if (!this.chk) {
                this.viewer.setUnits(string, true);
            }
        } else if (n == 545259558 && PT.isOneOf(string.toLowerCase(), ";kcal;kj;")) {
            if (!this.chk) {
                this.viewer.setUnits(string, false);
            }
        } else {
            this.errorStr2(50, "set " + T.nameOf(n), string);
        }
        return true;
    }

    private void setSsbond() throws ScriptException {
        boolean bl = false;
        switch (this.tokAt(this.checkLast(2))) {
            case 1115297793: {
                bl = true;
                break;
            }
            case 3145754: {
                break;
            }
            default: {
                this.invArg();
            }
        }
        this.setBooleanProperty("ssbondsBackbone", bl);
    }

    private void setHbond() throws ScriptException {
        boolean bl = false;
        switch (this.tokAt(this.checkLast(2))) {
            case 1115297793: {
                bl = true;
            }
            case 3145754: {
                this.setBooleanProperty("hbondsBackbone", bl);
                break;
            }
            case 1073742150: {
                bl = true;
            }
            case 0x40000066: {
                this.setBooleanProperty("hbondsSolid", bl);
                break;
            }
            default: {
                this.invArg();
            }
        }
    }

    private void setPicking() throws ScriptException {
        if (this.slen == 2) {
            this.setStringProperty("picking", "identify");
            return;
        }
        if (this.slen > 4 || this.tokAt(2) == 4) {
            this.setStringProperty("picking", this.stringSetting(2, false));
            return;
        }
        int n = 2;
        String string = "SELECT";
        switch (this.getToken((int)2).tok) {
            case 135280132: 
            case 1611141175: 
            case 1746538509: {
                if (this.checkLength34() != 4) break;
                string = this.parameterAsString(2).toUpperCase();
                if (string.equals("SPIN")) {
                    this.setIntProperty("pickingSpinRate", this.intParameter(3));
                    break;
                }
                n = 3;
                break;
            }
            case 12291: {
                break;
            }
            default: {
                this.checkLength(3);
            }
        }
        String string2 = this.parameterAsString(n);
        switch (this.getToken((int)n).tok) {
            case 0x10000D: 
            case 1073742056: {
                string2 = "identify";
                break;
            }
            case 0x10000B: 
            case 0x10000C: {
                string2 = "off";
                break;
            }
            case 135280132: {
                string2 = "atom";
                break;
            }
            case 1826248715: {
                string2 = "label";
                break;
            }
            case 1678770178: {
                string2 = "bond";
                break;
            }
            case 12291: {
                this.checkLength(4);
                if (this.tokAt(3) != 1678770178) {
                    this.invArg();
                }
                string2 = "deleteBond";
            }
        }
        int n2 = string2.indexOf("_");
        n2 = n2 >= 0 ? n2 : string2.length();
        n2 = ActionManager.getPickingMode(string2.substring(0, n2));
        if (n2 < 0) {
            this.errorStr2(50, "SET PICKING " + string, string2);
        }
        this.setStringProperty("picking", string2);
    }

    private void setPickingStyle() throws ScriptException {
        if (this.slen > 4 || this.tokAt(2) == 4) {
            this.setStringProperty("pickingStyle", this.stringSetting(2, false));
            return;
        }
        int n = 2;
        boolean bl = false;
        String string = "SELECT";
        switch (this.getToken((int)2).tok) {
            case 1746538509: {
                bl = true;
                string = "MEASURE";
            }
            case 135280132: {
                if (this.checkLength34() != 4) break;
                n = 3;
                break;
            }
            default: {
                this.checkLength(3);
            }
        }
        String string2 = this.parameterAsString(n);
        switch (this.getToken((int)n).tok) {
            case 0x10000B: 
            case 0x10000C: {
                string2 = bl ? "measureoff" : "toggle";
                break;
            }
            case 0x10000D: {
                if (!bl) break;
                string2 = "measure";
            }
        }
        if (ActionManager.getPickingStyleIndex(string2) < 0) {
            this.errorStr2(50, "SET PICKINGSTYLE " + string, string2);
        }
        this.setStringProperty("pickingStyle", string2);
    }

    private void timeout(int n) throws ScriptException {
        String string = null;
        String string2 = null;
        int n2 = 0;
        if (this.slen == n) {
            this.showString(this.viewer.showTimeout(null));
            return;
        }
        block6: for (int i = n; i < this.slen; ++i) {
            switch (this.getToken((int)i).tok) {
                case 1074790550: {
                    string = this.parameterAsString(++i);
                    if (this.slen != 3) continue block6;
                    if (!this.chk) {
                        this.viewer.triggerTimeout(string);
                    }
                    return;
                }
                case 0x10000C: {
                    continue block6;
                }
                case 2: {
                    n2 = this.intParameter(i);
                    continue block6;
                }
                case 3: {
                    n2 = Math.round(this.floatParameter(i) * 1000.0f);
                    continue block6;
                }
                default: {
                    if (string == null) {
                        string = this.parameterAsString(i);
                        continue block6;
                    }
                    if (string2 == null) {
                        string2 = this.parameterAsString(i);
                        continue block6;
                    }
                    this.invArg();
                }
            }
        }
        if (!this.chk) {
            this.viewer.setTimeout(string, n2, string2);
        }
    }

    private void setUserColors() throws ScriptException {
        int n;
        List<Integer> list = new List<Integer>();
        for (n = 2; n < this.slen; ++n) {
            int n2 = this.getArgbParam(n);
            list.addLast(n2);
            n = this.iToken;
        }
        if (this.chk) {
            return;
        }
        n = list.size();
        int[] nArray = new int[n];
        int n3 = n;
        while (--n3 >= 0) {
            nArray[n3] = (Integer)list.get(n3);
        }
        this.viewer.setUserScale(nArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setVariable(int n, int n2, String string, int n3) throws ScriptException {
        boolean bl;
        Object object;
        boolean bl2;
        BS bS = null;
        String string2 = "";
        int n4 = 0;
        boolean bl3 = n3 == 91;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = string.startsWith("property_");
        boolean bl7 = string.equals("all");
        SV sV = bl6 || bl7 ? null : this.getContextVariableAsVariable(string);
        boolean bl8 = bl2 = sV != null;
        if (n > 0 && this.tokAt(n - 1) == 0x100001) {
            bS = this.atomExpressionAt(n - 1);
            n = this.iToken + 1;
            bl5 = true;
        }
        if (this.tokAt(n) == 0x100008) {
            bl4 = true;
            if ((object = this.getBitsetPropertySelector(++n, true)) == null) {
                this.invArg();
            }
            if (this.tokAt(++n) != 269484436) {
                this.invArg();
            }
            ++n;
            n4 = ((SV)object).intValue;
            string2 = (String)((SV)object).value;
        }
        if (bl5 && !bl4) {
            this.invArg();
        }
        object = (List)this.parameterExpression(n, n2, string, true, true, -1, bl3, null, null);
        if (bl7) {
            return;
        }
        int n5 = ((ArrayList)object).size();
        if (n5 == 0 || !bl3 && n5 > 1 || bl3 && (n5 < 3 || n5 % 2 != 1)) {
            this.invArg();
        }
        if (this.chk) {
            return;
        }
        SV sV2 = (SV)((ArrayList)object).get(bl3 ? ((ArrayList)object).size() - 1 : 0);
        boolean bl9 = bl = !bl2 && !bl5 && !bl6 && (bl3 || bl4 || !(sV2.value instanceof String) && sV2.tok != 2 && !(sV2.value instanceof Integer) && !(sV2.value instanceof Float) && !(sV2.value instanceof Boolean));
        if (bl) {
            if (string.startsWith("_")) {
                this.errorStr(22, string);
            }
            sV = this.viewer.getOrSetNewVariable(string, true);
            bl2 = true;
        }
        if (!bl3) {
            if (bl4) {
                if (!bl5 && (bS = SV.getBitSet(sV, true)) == null) {
                    this.invArg();
                }
                if (!string2.startsWith("property_")) {
                    this.setBitsetProperty(bS, n4, sV2.asInt(), sV2.asFloat(), sV2);
                    return;
                }
                this.viewer.setData(string2, new Object[]{string2, sV2.tok == 7 ? (Object)SV.flistValue(sV2, ((List)sV2.value).size() == bS.cardinality() ? bS.cardinality() : this.viewer.getAtomCount()) : sV2.asString(), BSUtil.copy(bS), sV2.tok == 7 ? 1 : 0}, this.viewer.getAtomCount(), 0, 0, sV2.tok == 7 ? Integer.MAX_VALUE : Integer.MIN_VALUE, 0);
                return;
            }
            if (bl2) {
                sV.setv(sV2, false);
                return;
            }
            Object object2 = SV.oValue(sV2);
            if (string.startsWith("property_")) {
                if (sV2.tok == 7) {
                    object2 = sV2.asString();
                }
                this.viewer.setData(string, new Object[]{string, "" + object2, BSUtil.copy(this.viewer.getSelectionSet(false)), 0}, this.viewer.getAtomCount(), 0, 0, Integer.MIN_VALUE, 0);
                return;
            }
            if (object2 instanceof Boolean) {
                this.setBooleanProperty(string, (Boolean)object2);
                return;
            }
            if (object2 instanceof Integer) {
                this.setIntProperty(string, (Integer)object2);
                return;
            }
            if (object2 instanceof Float) {
                this.setFloatProperty(string, ((Float)object2).floatValue());
                return;
            }
            if (object2 instanceof String) {
                this.setStringProperty(string, (String)object2);
                return;
            }
            if (object2 instanceof BondSet) {
                this.setStringProperty(string, Escape.eBond((BS)object2));
                return;
            }
            if (!(object2 instanceof BS || object2 instanceof P3 || object2 instanceof P4)) {
                Logger.error("ERROR -- return from propertyExpression was " + object2);
                return;
            }
            this.setStringProperty(string, Escape.e(object2));
            return;
        }
        SV sV3 = SV.newS("").setv(sV2, false);
        int n6 = ((ArrayList)object).size() / 2;
        int n7 = 0;
        while (n7 < n6) {
            block35: {
                Object object3;
                SV sV4;
                boolean bl10;
                block34: {
                    bl10 = n7 + 1 == n6;
                    sV4 = (SV)((ArrayList)object).get(n7 * 2);
                    if (sV.tok == 10) {
                        sV.tok = 6;
                        sV.value = new Hashtable();
                    }
                    if (sV.tok != 6) break block34;
                    String string3 = sV4.asString();
                    object3 = (Map)sV.value;
                    if (bl10) {
                        object3.put(string3, sV3);
                        return;
                    }
                    sV = (SV)object3.get(string3);
                    break block35;
                }
                int n8 = sV4.asInt();
                if (sV.tok == 7) {
                    sV = SV.selectItemVar(sV);
                }
                switch (sV.tok) {
                    case 7: {
                        object3 = sV.getList();
                        if (n8 > ((ArrayList)object3).size() || bl10) break;
                        if (n8 <= 0) {
                            n8 = ((ArrayList)object3).size() + n8;
                        }
                        if (--n8 < 0) {
                            n8 = 0;
                        }
                        sV = (SV)((ArrayList)object3).get(n8);
                        break block35;
                    }
                    case 11: 
                    case 12: {
                        int n9;
                        int n10;
                        int n11 = n10 = sV.tok == 11 ? 3 : 4;
                        if (n6 == 1 && Math.abs(n8) >= 1 && Math.abs(n8) <= n10 && sV3.tok == 7 && sV3.getList().size() == n10) break;
                        if (n6 == 2 && (n9 = ((SV)((ArrayList)object).get(2)).asInt()) >= 1 && n9 <= n10 && (sV3.tok == 2 || sV3.tok == 3)) {
                            ++n7;
                            n8 = n8 * 10 + n9;
                            break;
                        }
                        sV.toArray();
                        --n7;
                        break block35;
                    }
                }
                sV.setSelectedValue(n8, sV3);
                return;
            }
            ++n7;
        }
    }

    private void axes(int n) throws ScriptException {
        TickInfo tickInfo = this.checkTicks(n, true, true, false);
        n = this.iToken + 1;
        int n2 = this.tokAt(n);
        String string = this.optParameterAsString(n).toLowerCase();
        if (this.slen == n + 1 && PT.isOneOf(string, ";window;unitcell;molecular;")) {
            this.setBooleanProperty("axes" + string, true);
            return;
        }
        switch (n2) {
            case 12289: {
                P3 p3 = this.centerParameter(n + 1);
                this.setShapeProperty(31, "origin", p3);
                this.checkLast(this.iToken);
                return;
            }
            case 1073742138: {
                this.setFloatProperty("axesScale", this.floatParameter(this.checkLast(++n)));
                return;
            }
            case 1826248715: {
                n2 = this.tokAt(n + 1);
                switch (n2) {
                    case 0x10000C: 
                    case 0x10000D: {
                        this.checkLength(n + 2);
                        this.setShapeProperty(31, "labels" + (n2 == 0x10000D ? "On" : "Off"), null);
                        return;
                    }
                }
                String string2 = null;
                switch (this.slen - n) {
                    case 7: {
                        this.setShapeProperty(31, "labels", new String[]{this.parameterAsString(++n), this.parameterAsString(++n), this.parameterAsString(++n), this.parameterAsString(++n), this.parameterAsString(++n), this.parameterAsString(++n)});
                        break;
                    }
                    case 5: {
                        string2 = this.parameterAsString(n + 4);
                    }
                    case 4: {
                        this.setShapeProperty(31, "labels", new String[]{this.parameterAsString(++n), this.parameterAsString(++n), this.parameterAsString(++n), string2});
                        break;
                    }
                    default: {
                        this.error(2);
                    }
                }
                return;
            }
        }
        if (string.equals("position")) {
            P3 p3;
            if (this.tokAt(++n) == 0x10000C) {
                p3 = new P3();
            } else {
                p3 = this.xypParameter(n);
                if (p3 == null) {
                    this.invArg();
                }
                n = this.iToken;
            }
            this.setShapeProperty(31, "position", p3);
            return;
        }
        int n3 = this.getSetAxesTypeMad(n);
        if (this.chk) {
            return;
        }
        this.setObjectMad(31, "axes", n3);
        if (tickInfo != null) {
            this.setShapeProperty(31, "tickInfo", tickInfo);
        }
    }

    private void boundbox(int n) throws ScriptException {
        int n2;
        boolean bl;
        TickInfo tickInfo = this.checkTicks(n, false, true, false);
        n = this.iToken + 1;
        float f = 1.0f;
        if (this.tokAt(n) == 1073742138) {
            f = this.floatParameter(++n);
            if (!this.chk && f == 0.0f) {
                this.invArg();
            }
            if (++n == this.slen) {
                if (!this.chk) {
                    this.viewer.setBoundBox(null, null, true, f);
                }
                return;
            }
        }
        boolean bl2 = bl = this.tokAt(n) == 0x4000004E;
        if (bl) {
            ++n;
        }
        if (this.isCenterParameter(n)) {
            this.expressionResult = null;
            n2 = n;
            P3 p3 = this.centerParameter(n);
            n = this.iToken + 1;
            if (bl || this.isCenterParameter(n)) {
                P3 p32 = bl ? this.centerParameter(n) : this.getPoint3f(n, true);
                n = this.iToken + 1;
                if (!this.chk) {
                    this.viewer.setBoundBox(p3, p32, bl, f);
                }
            } else if (this.expressionResult != null && this.expressionResult instanceof BS) {
                if (!this.chk) {
                    this.viewer.calcBoundBoxDimensions((BS)this.expressionResult, f);
                }
            } else if (this.expressionResult == null && this.tokAt(n2) == 0x100007) {
                P3[] p3Array;
                if (this.chk) {
                    return;
                }
                if ((p3Array = this.getObjectBoundingBox(this.objectNameParameter(++n2))) == null) {
                    this.invArg();
                }
                this.viewer.setBoundBox(p3Array[0], p3Array[1], true, f);
                n = this.iToken + 1;
            } else {
                this.invArg();
            }
            if (n == this.slen) {
                return;
            }
        }
        n2 = this.getSetAxesTypeMad(n);
        if (this.chk) {
            return;
        }
        if (tickInfo != null) {
            this.setShapeProperty(32, "tickInfo", tickInfo);
        }
        this.setObjectMad(32, "boundbox", n2);
    }

    public TickInfo checkTicks(int n, boolean bl, boolean bl2, boolean bl3) throws ScriptException {
        this.iToken = n - 1;
        if (this.tokAt(n) != 1073742164) {
            return null;
        }
        String string = " ";
        switch (this.tokAt(n + 1)) {
            case 1112541205: 
            case 1112541206: 
            case 1112541207: {
                string = this.parameterAsString(++n).toLowerCase();
                break;
            }
            case 0x40000000: {
                this.invArg();
            }
        }
        if (this.tokAt(++n) == 0x10000B) {
            TickInfo tickInfo = new TickInfo(null);
            tickInfo.type = string;
            this.iToken = n;
            return tickInfo;
        }
        TickInfo tickInfo = new TickInfo((P3)this.getPointOrPlane(n, false, true, false, false, 3, 3));
        if (this.coordinatesAreFractional || this.tokAt(this.iToken + 1) == 1614417948) {
            tickInfo.scale = P3.new3(Float.NaN, Float.NaN, Float.NaN);
            bl2 = false;
        }
        if (this.tokAt(this.iToken + 1) == 1614417948) {
            ++this.iToken;
        }
        tickInfo.type = string;
        if (this.tokAt(this.iToken + 1) == 1288701960) {
            tickInfo.tickLabelFormats = this.stringParameterSet(this.iToken + 2);
        }
        if (!bl2) {
            return tickInfo;
        }
        if (this.tokAt(this.iToken + 1) == 1073742138) {
            if (this.isFloatParameter(this.iToken + 2)) {
                float f = this.floatParameter(this.iToken + 2);
                tickInfo.scale = P3.new3(f, f, f);
            } else {
                tickInfo.scale = this.getPoint3f(this.iToken + 2, true);
            }
        }
        if (bl3 && this.tokAt(this.iToken + 1) == 1073741942) {
            tickInfo.first = this.floatParameter(this.iToken + 2);
        }
        return tickInfo;
    }

    private void unitcell(int n) throws ScriptException {
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MAX_VALUE;
        P3 p3 = null;
        TickInfo tickInfo = this.checkTicks(n, true, false, false);
        n = this.iToken;
        String string = null;
        P3[] p3Array = null;
        switch (this.tokAt(n + 1)) {
            case 4: {
                string = this.objectNameParameter(++n);
                break;
            }
            case 0x100007: {
                ++n;
                string = this.objectNameParameter(++n);
                break;
            }
            case 12289: {
                ++n;
                switch (this.tokAt(++n)) {
                    case 10: 
                    case 0x100001: {
                        p3 = P3.newP(this.viewer.getAtomSetCenter(this.atomExpressionAt(n)));
                        this.viewer.toFractional(p3, true);
                        n = this.iToken;
                        break;
                    }
                    default: {
                        if (this.isCenterParameter(n)) {
                            p3 = this.centerParameter(n);
                            n = this.iToken;
                            break;
                        }
                        this.invArg();
                    }
                }
                p3.x -= 0.5f;
                p3.y -= 0.5f;
                p3.z -= 0.5f;
                break;
            }
            default: {
                if (this.isArrayParameter(n + 1)) {
                    p3Array = this.getPointArray(++n, 4);
                    n = this.iToken;
                    break;
                }
                if (this.slen == n + 2) {
                    if (this.getToken((int)(n + 1)).tok != 2 || this.intParameter(n + 1) < 111) break;
                    n2 = this.intParameter(++n);
                    break;
                }
                if (this.slen <= n + 1) break;
                p3 = (P3)this.getPointOrPlane(++n, false, true, false, true, 3, 3);
                n = this.iToken;
            }
        }
        n3 = this.getSetAxesTypeMad(++n);
        this.checkLast(this.iToken);
        if (this.chk) {
            return;
        }
        if (n2 != Integer.MAX_VALUE) {
            this.viewer.setCurrentUnitCellOffset(n2);
        } else if (string != null) {
            this.viewer.setCurrentCage(string);
        } else if (p3Array != null) {
            this.viewer.setCurrentCagePts(p3Array);
        }
        this.setObjectMad(33, "unitCell", n3);
        if (p3 != null) {
            this.viewer.setCurrentUnitCellOffsetPt(p3);
        }
        if (tickInfo != null) {
            this.setShapeProperty(33, "tickInfo", tickInfo);
        }
    }

    private void frank(int n) throws ScriptException {
        this.setBooleanProperty("frank", this.booleanParameter(n));
    }

    private void selectionHalo(int n) throws ScriptException {
        boolean bl = false;
        switch (n == this.slen ? 0x10000D : this.getToken((int)n).tok) {
            case 0x10000D: 
            case 1114638363: {
                bl = true;
            }
            case 0x10000B: 
            case 0x10000C: 
            case 1073742056: {
                this.setBooleanProperty("selectionHalos", bl);
                break;
            }
            default: {
                this.invArg();
            }
        }
    }

    private void save() throws ScriptException {
        if (this.slen > 1) {
            String string = this.optParameterAsString(2);
            switch (this.tokAt(1)) {
                case 1073742077: 
                case 1073742132: {
                    if (!this.chk) {
                        this.viewer.saveOrientation(string, null);
                    }
                    return;
                }
                case 1678770178: {
                    if (!this.chk) {
                        this.viewer.saveBonds(string);
                    }
                    return;
                }
                case 1073742158: {
                    if (!this.chk) {
                        this.viewer.saveState(string);
                    }
                    return;
                }
                case 1641025539: {
                    if (!this.chk) {
                        this.viewer.saveStructure(string);
                    }
                    return;
                }
                case 0x100006: {
                    if (!this.chk) {
                        this.viewer.saveCoordinates(string, this.viewer.getSelectionSet(false));
                    }
                    return;
                }
                case 1073742140: {
                    if (!this.chk) {
                        this.viewer.saveSelection(string);
                    }
                    return;
                }
            }
        }
        this.errorStr2(53, "SAVE", "bonds? coordinates? orientation? selection? state? structure?");
    }

    private void restore() throws ScriptException {
        if (this.slen > 1) {
            String string = this.optParameterAsString(2);
            int n = this.tokAt(1);
            switch (n) {
                case 1073742077: 
                case 1073742132: 
                case 1073742139: {
                    float f;
                    float f2 = f = this.slen > 3 ? this.floatParameter(3) : 0.0f;
                    if (f < 0.0f) {
                        this.invArg();
                    }
                    if (this.chk) {
                        return;
                    }
                    String string2 = "";
                    switch (n) {
                        case 1073742077: {
                            string2 = "Orientation";
                            this.viewer.restoreOrientation(string, f);
                            break;
                        }
                        case 1073742132: {
                            string2 = "Rotation";
                            this.viewer.restoreRotation(string, f);
                            break;
                        }
                        case 1073742139: {
                            string2 = "Scene";
                            this.viewer.restoreScene(string, f);
                        }
                    }
                    if (this.isJS && f > 0.0f && this.viewer.global.waitForMoveTo) {
                        throw new ScriptInterruption(this, "restore" + string2, 1);
                    }
                    return;
                }
            }
            this.checkLength23();
            switch (n) {
                case 1678770178: {
                    if (!this.chk) {
                        this.viewer.restoreBonds(string);
                    }
                    return;
                }
                case 0x100006: {
                    if (this.chk) {
                        return;
                    }
                    String string3 = this.viewer.getSavedCoordinates(string);
                    if (string3 == null) {
                        this.invArg();
                    }
                    this.runScript(string3);
                    this.viewer.checkCoordinatesChanged();
                    return;
                }
                case 1073742140: {
                    if (!this.chk) {
                        this.viewer.restoreSelection(string);
                    }
                    return;
                }
                case 1073742158: {
                    if (this.chk) {
                        return;
                    }
                    String string4 = this.viewer.getSavedState(string);
                    if (string4 == null) {
                        this.invArg();
                    }
                    this.runScript(string4);
                    return;
                }
                case 1641025539: {
                    if (this.chk) {
                        return;
                    }
                    String string5 = this.viewer.getSavedStructure(string);
                    if (string5 == null) {
                        this.invArg();
                    }
                    this.runScript(string5);
                    return;
                }
            }
        }
        this.errorStr2(53, "RESTORE", "bonds? coords? orientation? rotation? scene? selection? state? structure?");
    }

    public float getColorTrans(int n, boolean bl) throws ScriptException {
        float f = Float.MAX_VALUE;
        if (this.theTok != 1766856708) {
            --n;
        }
        switch (this.tokAt(n + 1)) {
            case 603979967: {
                f = this.isFloatParameter(++n + 1) ? this.getTranslucentLevel(++n) : this.viewer.getFloat(0x2200000A);
                break;
            }
            case 1073742074: {
                ++n;
                f = 0.0f;
            }
        }
        if (this.isColorParam(n + 1)) {
            this.colorArgb[0] = this.getArgbParam(++n);
        } else if (this.tokAt(n + 1) == 0x10000B) {
            this.colorArgb[0] = 0;
            this.iToken = n + 1;
        } else if (f == Float.MAX_VALUE) {
            this.invArg();
        } else {
            this.colorArgb[0] = Integer.MIN_VALUE;
        }
        n = this.iToken;
        return f;
    }

    public void finalizeObject(int n, int n2, float f, int n3, boolean bl, Object object, int n4, BS bS) throws ScriptException {
        if (bl) {
            this.setShapeProperty(n, "set", object);
        }
        if (n2 != Integer.MIN_VALUE) {
            this.setShapePropertyBs(n, "color", n2, bS);
        }
        if (f != Float.MAX_VALUE) {
            this.setShapeTranslucency(n, "", "translucent", f, bS);
        }
        if (n3 != 0) {
            this.setShapeProperty(n, "scale", n3);
        }
        if (n4 > 0 && !this.setMeshDisplayProperty(n, n4, 0)) {
            this.invArg();
        }
    }

    public String getColorRange(int n) throws ScriptException {
        int n2 = this.getArgbParam(n);
        if (this.tokAt(++this.iToken) != 1074790746) {
            this.invArg();
        }
        int n3 = this.getArgbParam(++this.iToken);
        int n4 = this.tokAt(this.iToken + 1) == 2 ? this.intParameter(++this.iToken) : 0;
        return ColorEncoder.getColorSchemeList(ColorEncoder.getPaletteAtoB(n2, n3, n4));
    }

    public String getIsosurfaceDataRange(int n, String string) {
        float[] fArray = (float[])this.getShapeProperty(n, "dataRange");
        return fArray != null && fArray[0] != Float.MAX_VALUE && fArray[0] != fArray[1] ? string + "isosurface" + " full data range " + fArray[0] + " to " + fArray[1] + " with color scheme spanning " + fArray[2] + " to " + fArray[3] : "";
    }

    public boolean setMeshDisplayProperty(int n, int n2, int n3) throws ScriptException {
        boolean bl;
        String string = null;
        Integer n4 = null;
        boolean bl2 = n == 25;
        boolean bl3 = bl = n2 == 0;
        if (!bl) {
            n3 = this.getToken((int)n2).tok;
        }
        switch (n3) {
            case 1766856708: {
                if (!bl2) break;
                ++this.iToken;
            }
            case 603979967: 
            case 1073742074: {
                if (!bl) {
                    this.colorShape(n, this.iToken, false);
                }
                return true;
            }
            case 0: 
            case 12291: 
            case 12294: 
            case 0x10000C: 
            case 0x10000D: 
            case 3145768: 
            case 3145770: 
            case 1610625028: {
                if (this.iToken == 1 && n >= 0 && this.tokAt(2) == 0) {
                    this.setShapeProperty(n, "thisID", null);
                }
                if (n3 == 0) {
                    return this.iToken == 1;
                }
                if (bl) {
                    return true;
                }
                switch (n3) {
                    case 12291: {
                        this.setShapeProperty(n, "delete", null);
                        return true;
                    }
                    case 12294: 
                    case 3145770: {
                        n3 = 0x10000C;
                        break;
                    }
                    case 3145768: {
                        n3 = 0x10000D;
                        break;
                    }
                    case 1610625028: {
                        if (n2 + 1 != this.slen) break;
                        n3 = 0x10000D;
                    }
                }
            }
            case 1073741862: 
            case 0x4000004A: 
            case 1073741938: 
            case 1073741958: 
            case 0x40000088: 
            case 1073741964: 
            case 1073742018: 
            case 1073742039: 
            case 1073742042: 
            case 1073742046: 
            case 0x400000E4: 
            case 1073742058: 
            case 1073742060: 
            case 1073742182: 
            case 1113198595: {
                string = "token";
                n4 = n3;
            }
        }
        if (string == null) {
            return false;
        }
        if (bl) {
            return true;
        }
        this.setShapeProperty(n, string, n4);
        if (this.tokAt(this.iToken + 1) != 0 && !this.setMeshDisplayProperty(n, ++this.iToken, 0)) {
            --this.iToken;
        }
        return true;
    }

    private void bind() throws ScriptException {
        String string = this.stringParameter(1);
        String string2 = this.parameterAsString(2);
        this.checkLength(3);
        if (!this.chk) {
            this.viewer.bindAction(string, string2);
        }
    }

    private void unbind() throws ScriptException {
        if (this.slen != 1) {
            this.checkLength23();
        }
        String string = this.optParameterAsString(1);
        String string2 = this.optParameterAsString(2);
        if (string.length() == 0 || this.tokAt(1) == 0x100003) {
            string = null;
        }
        if (string2.length() == 0 || this.tokAt(2) == 0x100003) {
            string2 = null;
        }
        if (string2 == null && string != null && ActionManager.getActionFromName(string) >= 0) {
            string2 = string;
            string = null;
        }
        if (!this.chk) {
            this.viewer.unBindAction(string, string2);
        }
    }

    private void undoRedoMove() throws ScriptException {
        int n = 1;
        int n2 = 2;
        switch (this.tokAt(1)) {
            case 0: {
                n2 = 1;
                break;
            }
            case 0x100003: {
                n = 0;
                break;
            }
            case 2: {
                n = this.intParameter(1);
                break;
            }
            default: {
                this.invArg();
            }
        }
        this.checkLength(n2);
        if (!this.chk) {
            this.viewer.undoMoveAction(this.tokAt(0), n);
        }
    }

    static int getFloatEncodedInt(String string) {
        int n = string.indexOf(".");
        if (n < 1 || string.charAt(0) == '-' || string.endsWith(".") || string.contains(".0")) {
            return Integer.MAX_VALUE;
        }
        int n2 = 0;
        int n3 = 0;
        if (n > 0) {
            try {
                n2 = Integer.parseInt(string.substring(0, n));
                if (n2 < 0) {
                    n2 = -n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                n2 = -1;
            }
        }
        if (n < string.length() - 1) {
            try {
                n3 = Integer.parseInt(string.substring(n + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return (n2 = n2 * 1000000 + n3) < 0 ? Integer.MAX_VALUE : n2;
    }

    static int getPartialBondOrderFromFloatEncodedInt(int n) {
        return (n / 1000000 % 6 << 5) + (n % 1000000 & 0x1F);
    }

    public static int getBondOrderFromString(String string) {
        return string.indexOf(32) < 0 ? JmolEdge.getBondOrderFromString(string) : (string.toLowerCase().indexOf("partial ") == 0 ? ScriptEvaluator.getPartialBondOrderFromString(string.substring(8).trim()) : 131071);
    }

    private static int getPartialBondOrderFromString(String string) {
        return ScriptEvaluator.getPartialBondOrderFromFloatEncodedInt(ScriptEvaluator.getFloatEncodedInt(string));
    }

    @Override
    public BS addHydrogensInline(BS bS, List<Atom> list, P3[] p3Array) throws Exception {
        int n = this.viewer.getAtomModelIndex(bS.nextSetBit(0));
        if (n != this.viewer.modelSet.modelCount - 1) {
            return new BS();
        }
        BS bS2 = this.viewer.getModelUndeletedAtomsBitSet(n);
        this.viewer.setAppendNew(false);
        int n2 = this.viewer.modelSet.getAtomCount();
        int n3 = this.viewer.modelSet.getAtomCountInModel(n);
        SB sB = new SB();
        for (int i = 0; i < list.size(); ++i) {
            Atom atom = (Atom)list.get(i);
            sB.append(";  connect 0 100 ").append("({" + n2++ + "}) ").append("({" + atom.index + "}) group;");
        }
        SB sB2 = new SB();
        sB2.appendI(p3Array.length).append("\n").append("Viewer.AddHydrogens").append("#noautobond").append("\n");
        for (int i = 0; i < p3Array.length; ++i) {
            sB2.append("H ").appendF(p3Array[i].x).append(" ").appendF(p3Array[i].y).append(" ").appendF(p3Array[i].z).append(" - - - - ").appendI(++n3).appendC('\n');
        }
        this.viewer.openStringInlineParamsAppend(sB2.toString(), null, true);
        this.runScriptBuffer(sB.toString(), null);
        BS bS3 = this.viewer.getModelUndeletedAtomsBitSet(n);
        bS3.andNot(bS2);
        return bS3;
    }

    @Override
    public void stopScriptThreads() {
        if (this.scriptDelayThread != null) {
            this.scriptDelayThread.interrupt();
            this.scriptDelayThread = null;
        }
        if (this.fileLoadThread != null) {
            this.fileLoadThread.interrupt();
            this.fileLoadThread.resumeEval();
            if (this.thisContext != null) {
                this.popContext(false, false);
            }
            this.fileLoadThread = null;
        }
    }

    public void delayScript(int n) {
        if (this.viewer.autoExit) {
            return;
        }
        this.stopScriptThreads();
        this.scriptDelayThread = new ScriptDelayThread(this, this.viewer, n);
        this.scriptDelayThread.run();
    }

    public String getErrorLineMessage2() {
        return ScriptEvaluator.getErrorLineMessage(this.functionName, this.scriptFileName, this.getLinenumber(null), this.pc, ScriptEvaluator.statementAsString(this.viewer, this.st, -9999, this.logMessages));
    }

    @Override
    public boolean evaluateParallel(ScriptContext scriptContext, ShapeManager shapeManager) {
        return this.getExtension().evaluateParallel(scriptContext, shapeManager);
    }
}

