/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.util.Tensor;

public class Ellipsoid {
    public short colix = (short)23;
    public boolean visible;
    public boolean isValid;
    public P3 center = P3.new3(0.0f, 0.0f, 0.0f);
    public Tensor tensor;
    public String options;
    boolean isOn = true;
    String id;
    int modelIndex;
    byte pid;
    float[] lengths;
    float scale = 1.0f;
    int percent;
    private static final float[] crtval = new float[]{0.3389f, 0.4299f, 0.4951f, 0.5479f, 0.5932f, 0.6334f, 0.6699f, 0.7035f, 0.7349f, 0.7644f, 0.7924f, 0.8192f, 0.8447f, 0.8694f, 0.8932f, 0.9162f, 0.9386f, 0.9605f, 0.9818f, 1.0026f, 1.023f, 1.043f, 1.0627f, 1.0821f, 1.1012f, 1.12f, 1.1386f, 1.157f, 1.1751f, 1.1932f, 1.211f, 1.2288f, 1.2464f, 1.2638f, 1.2812f, 1.2985f, 1.3158f, 1.333f, 1.3501f, 1.3672f, 1.3842f, 1.4013f, 1.4183f, 1.4354f, 1.4524f, 1.4695f, 1.4866f, 1.5037f, 1.5209f, 1.5382f, 1.5555f, 1.5729f, 1.5904f, 1.608f, 1.6257f, 1.6436f, 1.6616f, 1.6797f, 1.698f, 1.7164f, 1.7351f, 1.754f, 1.773f, 1.7924f, 1.8119f, 1.8318f, 1.8519f, 1.8724f, 1.8932f, 1.9144f, 1.936f, 1.958f, 1.9804f, 2.0034f, 2.0269f, 2.051f, 2.0757f, 2.1012f, 2.1274f, 2.1544f, 2.1824f, 2.2114f, 2.2416f, 2.273f, 2.3059f, 2.3404f, 2.3767f, 2.4153f, 2.4563f, 2.5003f, 2.5478f, 2.5997f, 2.6571f, 2.7216f, 2.7955f, 2.8829f, 2.9912f, 3.1365f, 3.3682f};

    private Ellipsoid() {
    }

    public static Ellipsoid getEmptyEllipsoid(String string, int n) {
        Ellipsoid ellipsoid = new Ellipsoid();
        ellipsoid.id = string;
        ellipsoid.modelIndex = n;
        return ellipsoid;
    }

    public static Ellipsoid getEllipsoidForAtomTensor(Tensor tensor, P3 p3) {
        Ellipsoid ellipsoid = new Ellipsoid();
        ellipsoid.tensor = tensor;
        ellipsoid.modelIndex = tensor.modelIndex;
        ellipsoid.colix = 0;
        ellipsoid.center = p3;
        return ellipsoid;
    }

    public void setCenter(P3 p3) {
        this.center = p3;
        this.validate(false);
    }

    public float getLength(int n) {
        if (this.lengths == null) {
            this.setLengths();
        }
        return this.lengths == null ? Float.NaN : this.lengths[n];
    }

    public void setLengths() {
        if (this.tensor == null) {
            return;
        }
        if (this.lengths == null) {
            this.lengths = new float[3];
        }
        for (int i = 0; i < this.lengths.length; ++i) {
            this.lengths[i] = this.tensor.getFactoredValue(i) * this.scale;
        }
    }

    public void setScale(float f, boolean bl) {
        if (f <= 0.0f) {
            this.isValid = false;
            return;
        }
        if (bl) {
            if (f == 2.1474836E9f) {
                f = this.tensor.forThermalEllipsoid ? 50 : 100;
            }
            this.percent = (int)f;
            f = this.tensor.forThermalEllipsoid ? Ellipsoid.getThermalRadius(this.percent) : (this.percent < 1 ? 0.0f : (float)this.percent / 100.0f);
        }
        this.scale = f;
        this.validate(true);
    }

    public static final float getThermalRadius(int n) {
        return crtval[n < 1 ? 0 : (n > 99 ? 98 : n - 1)];
    }

    protected void setEquation(double[] dArray) {
        this.isValid = false;
        this.tensor = ((Tensor)Interface.getOptionInterface("util.Tensor")).setFromThermalEquation(dArray, null);
        this.validate(true);
    }

    protected void setAxes(V3[] v3Array) {
        this.isValid = false;
        this.tensor = ((Tensor)Interface.getOptionInterface("util.Tensor")).setFromAxes(v3Array);
        this.validate(this.tensor != null);
    }

    private void validate(boolean bl) {
        if (this.tensor == null) {
            return;
        }
        if (bl) {
            this.setLengths();
        }
        this.isValid = true;
    }

    public static void getEquationForQuadricWithCenter(float f, float f2, float f3, M3 m3, V3 v3, M3 m32, double[] dArray, M4 m4) {
        v3.set(f, f2, f3);
        m3.transform(v3);
        double d = 1.0f - v3.dot(v3);
        m32.transposeM(m3);
        m32.transform(v3);
        m32.mul(m3);
        dArray[0] = (double)m32.m00 / d;
        dArray[1] = (double)m32.m11 / d;
        dArray[2] = (double)m32.m22 / d;
        dArray[3] = (double)(m32.m01 * 2.0f) / d;
        dArray[4] = (double)(m32.m02 * 2.0f) / d;
        dArray[5] = (double)(m32.m12 * 2.0f) / d;
        dArray[6] = (double)(-2.0f * v3.x) / d;
        dArray[7] = (double)(-2.0f * v3.y) / d;
        dArray[8] = (double)(-2.0f * v3.z) / d;
        dArray[9] = -1.0;
        if (m4 == null) {
            return;
        }
        m4.setIdentity();
        m4.m00 = (float)(2.0 * dArray[0]);
        m4.m11 = (float)(2.0 * dArray[1]);
        m4.m22 = (float)(2.0 * dArray[2]);
        m4.m01 = m4.m10 = (float)dArray[3];
        m4.m02 = m4.m20 = (float)dArray[4];
        m4.m12 = m4.m21 = (float)dArray[5];
        m4.m03 = (float)dArray[6];
        m4.m13 = (float)dArray[7];
        m4.m23 = (float)dArray[8];
    }
}

