/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.util.BoxInfo;
import org.jmol.util.Escape;
import org.jmol.util.SimpleUnitCell;
import org.jmol.util.Tensor;
import org.jmol.viewer.JC;

class UnitCell
extends SimpleUnitCell {
    private P3[] vertices;
    private P3 cartesianOffset = new P3();
    private P3 fractionalOffset;
    private boolean allFractionalRelative = false;
    private P3 unitCellMultiplier = null;
    private static final double twoP2 = 19.739208802178716;
    private static final V3[] unitVectors = new V3[]{JC.axisX, JC.axisY, JC.axisZ};

    UnitCell() {
    }

    static UnitCell newP(T3[] t3Array) {
        UnitCell unitCell = new UnitCell();
        float[] fArray = new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, t3Array[1].x, t3Array[1].y, t3Array[1].z, t3Array[2].x, t3Array[2].y, t3Array[2].z, t3Array[3].x, t3Array[3].y, t3Array[3].z};
        unitCell.set(fArray);
        unitCell.allFractionalRelative = true;
        unitCell.calcUnitcellVertices();
        unitCell.setCartesianOffset(t3Array[0]);
        return unitCell;
    }

    public static UnitCell newA(float[] fArray) {
        UnitCell unitCell = new UnitCell();
        unitCell.set(fArray);
        unitCell.calcUnitcellVertices();
        return unitCell;
    }

    void setOrientation(M3 m3) {
        if (m3 == null) {
            return;
        }
        M4 m4 = new M4();
        m4.setM3(m3);
        this.matrixFractionalToCartesian.mul2(m4, this.matrixFractionalToCartesian);
        this.matrixCartesianToFractional.invertM(this.matrixFractionalToCartesian);
        this.calcUnitcellVertices();
    }

    final void toUnitCell(P3 p3, P3 p32) {
        if (this.matrixCartesianToFractional == null) {
            return;
        }
        if (p32 == null) {
            this.matrixCartesianToFractional.transform(p3);
            this.unitize(p3);
            this.matrixFractionalToCartesian.transform(p3);
        } else {
            this.matrixCtoFAbsolute.transform(p3);
            this.unitize(p3);
            p3.add(p32);
            this.matrixFtoCAbsolute.transform(p3);
        }
    }

    public void unitize(P3 p3) {
        switch (this.dimension) {
            case 3: {
                p3.z = UnitCell.toFractionalX(p3.z);
            }
            case 2: {
                p3.y = UnitCell.toFractionalX(p3.y);
            }
            case 1: {
                p3.x = UnitCell.toFractionalX(p3.x);
            }
        }
    }

    void setAllFractionalRelative(boolean bl) {
        this.allFractionalRelative = bl;
    }

    void setOffset(P3 p3) {
        if (p3 == null) {
            return;
        }
        if (p3.x >= 100.0f || p3.y >= 100.0f) {
            this.unitCellMultiplier = p3.z == 0.0f ? null : P3.newP(p3);
            return;
        }
        this.fractionalOffset = new P3();
        this.fractionalOffset.setT(p3);
        this.matrixCartesianToFractional.m03 = -p3.x;
        this.matrixCartesianToFractional.m13 = -p3.y;
        this.matrixCartesianToFractional.m23 = -p3.z;
        this.cartesianOffset.setT(p3);
        this.matrixFractionalToCartesian.m03 = 0.0f;
        this.matrixFractionalToCartesian.m13 = 0.0f;
        this.matrixFractionalToCartesian.m23 = 0.0f;
        this.matrixFractionalToCartesian.transform(this.cartesianOffset);
        this.matrixFractionalToCartesian.m03 = this.cartesianOffset.x;
        this.matrixFractionalToCartesian.m13 = this.cartesianOffset.y;
        this.matrixFractionalToCartesian.m23 = this.cartesianOffset.z;
        if (this.allFractionalRelative) {
            this.matrixCtoFAbsolute.setM(this.matrixCartesianToFractional);
            this.matrixFtoCAbsolute.setM(this.matrixFractionalToCartesian);
        }
    }

    public void setCartesianOffset(T3 t3) {
        this.cartesianOffset.setT(t3);
        this.matrixFractionalToCartesian.m03 = this.cartesianOffset.x;
        this.matrixFractionalToCartesian.m13 = this.cartesianOffset.y;
        this.matrixFractionalToCartesian.m23 = this.cartesianOffset.z;
        this.fractionalOffset = new P3();
        this.fractionalOffset.setT(this.cartesianOffset);
        this.matrixCartesianToFractional.m03 = 0.0f;
        this.matrixCartesianToFractional.m13 = 0.0f;
        this.matrixCartesianToFractional.m23 = 0.0f;
        this.matrixCartesianToFractional.transform(this.fractionalOffset);
        this.matrixCartesianToFractional.m03 = -this.fractionalOffset.x;
        this.matrixCartesianToFractional.m13 = -this.fractionalOffset.y;
        this.matrixCartesianToFractional.m23 = -this.fractionalOffset.z;
        if (this.allFractionalRelative) {
            this.matrixCtoFAbsolute.setM(this.matrixCartesianToFractional);
            this.matrixFtoCAbsolute.setM(this.matrixFractionalToCartesian);
        }
    }

    void setMinMaxLatticeParameters(P3i p3i, P3i p3i2) {
        if (p3i2.x <= 555 && p3i2.y >= 555) {
            P3 p3 = new P3();
            UnitCell.ijkToPoint3f(p3i2.x, p3, 0);
            p3i.x = (int)p3.x;
            p3i.y = (int)p3.y;
            p3i.z = (int)p3.z;
            UnitCell.ijkToPoint3f(p3i2.y, p3, 1);
            p3i2.x = (int)p3.x;
            p3i2.y = (int)p3.y;
            p3i2.z = (int)p3.z;
        }
        switch (this.dimension) {
            case 1: {
                p3i.y = 0;
                p3i2.y = 1;
            }
            case 2: {
                p3i.z = 0;
                p3i2.z = 1;
            }
        }
    }

    final String dumpInfo(boolean bl) {
        return "a=" + this.a + ", b=" + this.b + ", c=" + this.c + ", alpha=" + this.alpha + ", beta=" + this.beta + ", gamma=" + this.gamma + (bl ? "\nfractional to cartesian: " + this.matrixFractionalToCartesian + "\ncartesian to fractional: " + this.matrixCartesianToFractional : "");
    }

    P3[] getVertices() {
        return this.vertices;
    }

    P3 getCartesianOffset() {
        return this.cartesianOffset;
    }

    P3 getFractionalOffset() {
        return this.fractionalOffset;
    }

    Tensor getTensor(float[] fArray) {
        if (fArray == null) {
            return null;
        }
        Tensor tensor = (Tensor)Interface.getOptionInterface("util.Tensor");
        if (fArray[0] == 0.0f) {
            float f = fArray[7];
            float[] fArray2 = new float[]{f, f, f};
            return tensor.setFromEigenVectors(unitVectors, fArray2, "iso", "Uiso=" + f);
        }
        double[] dArray = new double[6];
        int n = (int)fArray[6];
        if (n == 12) {
            dArray[0] = (double)fArray[0] * 19.739208802178716;
            dArray[1] = (double)fArray[1] * 19.739208802178716;
            dArray[2] = (double)fArray[2] * 19.739208802178716;
            dArray[3] = (double)fArray[3] * 19.739208802178716 * 2.0;
            dArray[4] = (double)fArray[4] * 19.739208802178716 * 2.0;
            dArray[5] = (double)fArray[5] * 19.739208802178716 * 2.0;
            fArray[7] = (fArray[0] + fArray[1] + fArray[3]) / 3.0f;
        } else {
            boolean bl = n == 4 || n == 5 || n == 8 || n == 9;
            double d = 2 - n % 2;
            double d2 = n == 8 || n == 9 || n == 10 ? 19.739208802178716 : (n == 4 || n == 5 ? 0.25 : (n == 2 || n == 3 ? Math.log(2.0) : 1.0));
            double d3 = (double)fArray[0] * d2 * (bl ? this.a_ * this.a_ : 1.0);
            double d4 = (double)fArray[1] * d2 * (bl ? this.b_ * this.b_ : 1.0);
            double d5 = (double)fArray[2] * d2 * (bl ? this.c_ * this.c_ : 1.0);
            double d6 = (double)fArray[3] * d2 * (bl ? this.a_ * this.b_ : 1.0) * d;
            double d7 = (double)fArray[4] * d2 * (bl ? this.a_ * this.c_ : 1.0) * d;
            double d8 = (double)fArray[5] * d2 * (bl ? this.b_ * this.c_ : 1.0) * d;
            fArray[7] = (float)Math.pow(d3 / 19.739208802178716 / this.a_ / this.a_ * d4 / 19.739208802178716 / this.b_ / this.b_ * d5 / 19.739208802178716 / this.c_ / this.c_, 0.3333);
            dArray[0] = (double)(this.a * this.a) * d3 + (double)(this.b * this.b) * this.cosGamma * this.cosGamma * d4 + (double)(this.c * this.c) * this.cosBeta * this.cosBeta * d5 + (double)(this.a * this.b) * this.cosGamma * d6 + (double)(this.b * this.c) * this.cosGamma * this.cosBeta * d8 + (double)(this.a * this.c) * this.cosBeta * d7;
            dArray[1] = (double)(this.b * this.b) * this.sinGamma * this.sinGamma * d4 + (double)(this.c * this.c) * this.cA_ * this.cA_ * d5 + (double)(this.b * this.c) * this.cA_ * this.sinGamma * d8;
            dArray[2] = (double)(this.c * this.c) * this.cB_ * this.cB_ * d5;
            dArray[3] = (double)(2.0f * this.b * this.b) * this.cosGamma * this.sinGamma * d4 + (double)(2.0f * this.c * this.c) * this.cA_ * this.cosBeta * d5 + (double)(this.a * this.b) * this.sinGamma * d6 + (double)(this.b * this.c) * (this.cA_ * this.cosGamma + this.sinGamma * this.cosBeta) * d8 + (double)(this.a * this.c) * this.cA_ * d7;
            dArray[4] = (double)(2.0f * this.c * this.c) * this.cB_ * this.cosBeta * d5 + (double)(this.b * this.c) * this.cosGamma * d8 + (double)(this.a * this.c) * this.cB_ * d7;
            dArray[5] = (double)(2.0f * this.c * this.c) * this.cA_ * this.cB_ * d5 + (double)(this.b * this.c) * this.cB_ * this.sinGamma * d8;
        }
        return tensor.setFromThermalEquation(dArray, Escape.eAF(fArray));
    }

    P3[] getCanonicalCopy(float f) {
        P3[] p3Array = new P3[8];
        for (int i = 0; i < 8; ++i) {
            p3Array[i] = P3.newP(BoxInfo.unitCubePoints[i]);
            this.matrixFractionalToCartesian.transform(p3Array[i]);
        }
        return BoxInfo.getCanonicalCopy(p3Array, f);
    }

    private static float toFractionalX(float f) {
        if ((f = (float)((double)f - Math.floor(f))) > 0.9999f || f < 1.0E-4f) {
            f = 0.0f;
        }
        return f;
    }

    private void calcUnitcellVertices() {
        if (this.matrixFractionalToCartesian == null) {
            return;
        }
        this.matrixCtoFAbsolute = M4.newM(this.matrixCartesianToFractional);
        this.matrixFtoCAbsolute = M4.newM(this.matrixFractionalToCartesian);
        this.vertices = new P3[8];
        int n = 8;
        while (--n >= 0) {
            this.vertices[n] = new P3();
            this.matrixFractionalToCartesian.transform2(BoxInfo.unitCubePoints[n], this.vertices[n]);
        }
    }

    public boolean checkDistance(P3 p3, P3 p32, float f, float f2, int n, int n2, int n3, P3 p33) {
        P3 p34 = P3.newP(p3);
        this.toCartesian(p34, true);
        for (int i = -n; i <= n; ++i) {
            for (int j = -n2; j <= n2; ++j) {
                for (int k = -n3; k <= n3; ++k) {
                    p33.set(p32.x + (float)i, p32.y + (float)j, p32.z + (float)k);
                    this.toCartesian(p33, true);
                    float f3 = p34.distance(p33);
                    if (!(f2 > 0.0f ? Math.abs(f3 - f) <= f2 : f3 <= f && f3 > 0.1f)) continue;
                    p33.set(i, j, k);
                    return true;
                }
            }
        }
        return false;
    }

    public P3 getUnitCellMultiplier() {
        return this.unitCellMultiplier;
    }

    public P3[] getUnitCellVectors() {
        M4 m4 = this.matrixFractionalToCartesian;
        return new P3[]{P3.newP(this.cartesianOffset), P3.new3(m4.m00, m4.m10, m4.m20), P3.new3(m4.m01, m4.m11, m4.m21), P3.new3(m4.m02, m4.m12, m4.m22)};
    }

    public boolean isSameAs(UnitCell unitCell) {
        if (unitCell.notionalUnitcell.length != this.notionalUnitcell.length) {
            return false;
        }
        int n = this.notionalUnitcell.length;
        while (--n >= 0) {
            if (this.notionalUnitcell[n] == unitCell.notionalUnitcell[n] || Float.isNaN(this.notionalUnitcell[n]) && Float.isNaN(unitCell.notionalUnitcell[n])) continue;
            return false;
        }
        if (this.fractionalOffset == null) {
            return unitCell.fractionalOffset == null;
        }
        if (unitCell.fractionalOffset == null) {
            return false;
        }
        return this.fractionalOffset.distanceSquared(unitCell.fractionalOffset) == 0.0f;
    }
}

