/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Hashtable;
import javajs.util.P3;
import javajs.util.T3;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.ModulationSet;

public class Modulation {
    private static final double TWOPI = Math.PI * 2;
    private P3 qCoefs;
    private double a1;
    private double a2;
    private double center;
    private double left;
    private double right;
    private char axis;
    private final char type;
    private P3 params;
    private String utens;
    private static final String typeNames = "DF DS OF OC UF";
    public static final char TYPE_DISP_FOURIER = 'f';
    public static final char TYPE_DISP_SAWTOOTH = 's';
    public static final char TYPE_OCC_FOURIER = 'o';
    public static final char TYPE_OCC_CRENEL = 'c';
    public static final char TYPE_U_FOURIER = 'u';

    public Modulation(char c, char c2, P3 p3, String string, P3 p32) {
        if (Logger.debuggingHigh) {
            Logger.debug("MOD create " + Escape.eP(p32) + " axis=" + c + " type=" + c2 + " params=" + p3 + " utens=" + string);
        }
        this.axis = c;
        this.type = c2;
        this.utens = string;
        this.params = p3;
        this.qCoefs = p32;
        switch (c2) {
            case 'f': 
            case 'o': 
            case 'u': {
                this.a1 = p3.x;
                this.a2 = p3.y;
                break;
            }
            case 'c': 
            case 's': {
                this.center = p3.x;
                float f = p3.y;
                if (f > 1.0f) {
                    f = 1.0f;
                }
                this.left = this.center - (double)(f / 2.0f);
                this.right = this.center + (double)(f / 2.0f);
                if (this.left < 0.0) {
                    this.left += 1.0;
                }
                if (this.right > 1.0) {
                    this.right -= 1.0;
                }
                if (this.left >= this.right && this.left - this.right < (double)0.01f) {
                    this.left = this.right + (double)0.01f;
                }
                this.a1 = 2.0f * p3.z / p3.y;
            }
        }
    }

    void apply(ModulationSet modulationSet, T3 t3) {
        double d = this.qCoefs.dot(t3);
        double d2 = 0.0;
        switch (this.type) {
            case 'f': 
            case 'o': 
            case 'u': {
                double d3 = Math.PI * 2 * d;
                if (this.a1 != 0.0) {
                    d2 += this.a1 * Math.cos(d3);
                }
                if (this.a2 != 0.0) {
                    d2 += this.a2 * Math.sin(d3);
                }
                if (!Logger.debuggingHigh) break;
                Logger.debug("MOD " + modulationSet.id + " " + Escape.eP(this.qCoefs) + " axis=" + this.axis + " v=" + d2 + " ccos,csin=" + this.a1 + "," + this.a2 + " / theta=" + d3);
                break;
            }
            case 'c': {
                d -= Math.floor(d);
                modulationSet.vOcc = this.range(d) ? 1 : 0;
                modulationSet.vOcc0 = Float.NaN;
                return;
            }
            case 's': {
                d -= Math.floor(d);
                if (!this.range(d)) {
                    return;
                }
                if (this.left > this.right) {
                    if (d < this.left && this.left < this.center) {
                        d += 1.0;
                    } else if (d > this.right && this.right > this.center) {
                        d -= 1.0;
                    }
                }
                d2 = this.a1 * (d - this.center);
            }
        }
        switch (this.axis) {
            case 'x': {
                modulationSet.x = (float)((double)modulationSet.x + d2);
                break;
            }
            case 'y': {
                modulationSet.y = (float)((double)modulationSet.y + d2);
                break;
            }
            case 'z': {
                modulationSet.z = (float)((double)modulationSet.z + d2);
                break;
            }
            case 'U': {
                modulationSet.addUTens(this.utens, (float)d2);
                break;
            }
            default: {
                if (Float.isNaN(modulationSet.vOcc)) {
                    modulationSet.vOcc = 0.0f;
                }
                modulationSet.vOcc += (float)d2;
            }
        }
    }

    private boolean range(double d) {
        return this.left < this.right ? this.left <= d && d <= this.right : this.left <= d || d <= this.right;
    }

    public Hashtable<String, Object> getInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        int n = ('\u0000' + this.type) * 3;
        hashtable.put("type", typeNames.substring(n, n + 2).trim() + this.axis);
        hashtable.put("params", this.params);
        hashtable.put("qCoefs", this.qCoefs);
        if (this.utens != null) {
            hashtable.put("Utens", this.utens);
        }
        return hashtable;
    }
}

