/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javajs.util.A4;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Txt;

public class Quaternion {
    public float q0 = 1.0f;
    public float q1;
    public float q2;
    public float q3;
    private M3 mat;
    private static final P4 qZero = new P4();
    private static final double RAD_PER_DEG = Math.PI / 180;

    public static Quaternion newQ(Quaternion quaternion) {
        Quaternion quaternion2 = new Quaternion();
        quaternion2.set(quaternion);
        return quaternion2;
    }

    public static Quaternion newVA(T3 t3, float f) {
        Quaternion quaternion = new Quaternion();
        quaternion.setTA(t3, f);
        return quaternion;
    }

    public static Quaternion newM(M3 m3) {
        Quaternion quaternion = new Quaternion();
        quaternion.setM(m3);
        return quaternion;
    }

    public static Quaternion newAA(A4 a4) {
        Quaternion quaternion = new Quaternion();
        quaternion.setAA(a4);
        return quaternion;
    }

    public static Quaternion newP4(P4 p4) {
        Quaternion quaternion = new Quaternion();
        quaternion.setP4(p4);
        return quaternion;
    }

    public static Quaternion new4(float f, float f2, float f3, float f4) {
        Quaternion quaternion = new Quaternion();
        if (f < -1.0f) {
            quaternion.q0 = -1.0f;
            return quaternion;
        }
        if (f > 1.0f) {
            quaternion.q0 = 1.0f;
            return quaternion;
        }
        quaternion.q0 = f;
        quaternion.q1 = f2;
        quaternion.q2 = f3;
        quaternion.q3 = f4;
        return quaternion;
    }

    public void set(Quaternion quaternion) {
        this.q0 = quaternion.q0;
        this.q1 = quaternion.q1;
        this.q2 = quaternion.q2;
        this.q3 = quaternion.q3;
    }

    private void setP4(P4 p4) {
        float f;
        float f2 = f = p4 == null ? 0.0f : p4.distance(qZero);
        if (f == 0.0f) {
            this.q0 = 1.0f;
            return;
        }
        this.q0 = p4.w / f;
        this.q1 = p4.x / f;
        this.q2 = p4.y / f;
        this.q3 = p4.z / f;
    }

    public void setTA(T3 t3, float f) {
        if (t3.x == 0.0f && t3.y == 0.0f && t3.z == 0.0f) {
            this.q0 = 1.0f;
            return;
        }
        double d = Math.sin((double)(f / 2.0f) * (Math.PI / 180)) / Math.sqrt(t3.x * t3.x + t3.y * t3.y + t3.z * t3.z);
        this.q0 = (float)Math.cos((double)(f / 2.0f) * (Math.PI / 180));
        this.q1 = (float)((double)t3.x * d);
        this.q2 = (float)((double)t3.y * d);
        this.q3 = (float)((double)t3.z * d);
    }

    public void setAA(A4 a4) {
        A4 a42 = A4.newAA(a4);
        if (a42.angle == 0.0f) {
            a42.y = 1.0f;
        }
        M3 m3 = new M3();
        m3.setAA(a42);
        this.setM(m3);
    }

    public void setM(M3 m3) {
        double d;
        double d2;
        double d3;
        double d4;
        this.mat = m3;
        double d5 = m3.m00 + m3.m11 + m3.m22;
        if (d5 >= 0.5) {
            d4 = Math.sqrt(1.0 + d5);
            d3 = (double)(m3.m21 - m3.m12) / d4;
            d2 = (double)(m3.m02 - m3.m20) / d4;
            d = (double)(m3.m10 - m3.m01) / d4;
        } else {
            double d6;
            double d7 = (double)(m3.m00 + m3.m00) - d5;
            if (d6 >= 0.5) {
                d3 = Math.sqrt(1.0 + d7);
                d4 = (double)(m3.m21 - m3.m12) / d3;
                d2 = (double)(m3.m10 + m3.m01) / d3;
                d = (double)(m3.m20 + m3.m02) / d3;
            } else {
                d7 = (double)(m3.m11 + m3.m11) - d5;
                if (d7 >= 0.5 || m3.m11 > m3.m22) {
                    d2 = Math.sqrt(1.0 + d7);
                    d4 = (double)(m3.m02 - m3.m20) / d2;
                    d3 = (double)(m3.m10 + m3.m01) / d2;
                    d = (double)(m3.m21 + m3.m12) / d2;
                } else {
                    d = Math.sqrt(1.0 + (double)m3.m22 + (double)m3.m22 - d5);
                    d4 = (double)(m3.m10 - m3.m01) / d;
                    d3 = (double)(m3.m20 + m3.m02) / d;
                    d2 = (double)(m3.m21 + m3.m12) / d;
                }
            }
        }
        this.q0 = (float)(d4 * 0.5);
        this.q1 = (float)(d3 * 0.5);
        this.q2 = (float)(d2 * 0.5);
        this.q3 = (float)(d * 0.5);
    }

    public void setRef(Quaternion quaternion) {
        if (quaternion == null) {
            this.mul(this.getFixFactor());
            return;
        }
        if (this.dot(quaternion) >= 0.0f) {
            return;
        }
        this.q0 *= -1.0f;
        this.q1 *= -1.0f;
        this.q2 *= -1.0f;
        this.q3 *= -1.0f;
    }

    public static final Quaternion getQuaternionFrame(P3 p3, T3 t3, T3 t32) {
        V3 v3 = V3.newV(t3);
        V3 v32 = V3.newV(t32);
        if (p3 != null) {
            v3.sub(p3);
            v32.sub(p3);
        }
        return Quaternion.getQuaternionFrameV(v3, v32, null, false);
    }

    public static final Quaternion getQuaternionFrameV(V3 v3, V3 v32, V3 v33, boolean bl) {
        if (v33 == null) {
            v33 = new V3();
            v33.cross(v3, v32);
            if (bl) {
                v3.cross(v32, v33);
            }
        }
        V3 v34 = new V3();
        v34.cross(v33, v3);
        v3.normalize();
        v34.normalize();
        v33.normalize();
        M3 m3 = new M3();
        m3.setColumnV(0, v3);
        m3.setColumnV(1, v34);
        m3.setColumnV(2, v33);
        Quaternion quaternion = Quaternion.newM(m3);
        return quaternion;
    }

    public M3 getMatrix() {
        if (this.mat == null) {
            this.setMatrix();
        }
        return this.mat;
    }

    private void setMatrix() {
        this.mat = new M3();
        this.mat.m00 = this.q0 * this.q0 + this.q1 * this.q1 - this.q2 * this.q2 - this.q3 * this.q3;
        this.mat.m01 = 2.0f * this.q1 * this.q2 - 2.0f * this.q0 * this.q3;
        this.mat.m02 = 2.0f * this.q1 * this.q3 + 2.0f * this.q0 * this.q2;
        this.mat.m10 = 2.0f * this.q1 * this.q2 + 2.0f * this.q0 * this.q3;
        this.mat.m11 = this.q0 * this.q0 - this.q1 * this.q1 + this.q2 * this.q2 - this.q3 * this.q3;
        this.mat.m12 = 2.0f * this.q2 * this.q3 - 2.0f * this.q0 * this.q1;
        this.mat.m20 = 2.0f * this.q1 * this.q3 - 2.0f * this.q0 * this.q2;
        this.mat.m21 = 2.0f * this.q2 * this.q3 + 2.0f * this.q0 * this.q1;
        this.mat.m22 = this.q0 * this.q0 - this.q1 * this.q1 - this.q2 * this.q2 + this.q3 * this.q3;
    }

    public Quaternion add(float f) {
        return Quaternion.newVA(this.getNormal(), this.getTheta() + f);
    }

    public Quaternion mul(float f) {
        return f == 1.0f ? Quaternion.new4(this.q0, this.q1, this.q2, this.q3) : Quaternion.newVA(this.getNormal(), this.getTheta() * f);
    }

    public Quaternion mulQ(Quaternion quaternion) {
        return Quaternion.new4(this.q0 * quaternion.q0 - this.q1 * quaternion.q1 - this.q2 * quaternion.q2 - this.q3 * quaternion.q3, this.q0 * quaternion.q1 + this.q1 * quaternion.q0 + this.q2 * quaternion.q3 - this.q3 * quaternion.q2, this.q0 * quaternion.q2 + this.q2 * quaternion.q0 + this.q3 * quaternion.q1 - this.q1 * quaternion.q3, this.q0 * quaternion.q3 + this.q3 * quaternion.q0 + this.q1 * quaternion.q2 - this.q2 * quaternion.q1);
    }

    public Quaternion div(Quaternion quaternion) {
        return this.mulQ(quaternion.inv());
    }

    public Quaternion divLeft(Quaternion quaternion) {
        return this.inv().mulQ(quaternion);
    }

    public float dot(Quaternion quaternion) {
        return this.q0 * quaternion.q0 + this.q1 * quaternion.q1 + this.q2 * quaternion.q2 + this.q3 * quaternion.q3;
    }

    public Quaternion inv() {
        return Quaternion.new4(this.q0, -this.q1, -this.q2, -this.q3);
    }

    public Quaternion negate() {
        return Quaternion.new4(-this.q0, -this.q1, -this.q2, -this.q3);
    }

    private float getFixFactor() {
        return this.q0 < 0.0f || this.q0 == 0.0f && (this.q1 < 0.0f || this.q1 == 0.0f && (this.q2 < 0.0f || this.q2 == 0.0f && this.q3 < 0.0f)) ? -1 : 1;
    }

    public V3 getVector(int n) {
        return this.getVectorS(n, 1.0f);
    }

    private V3 getVectorS(int n, float f) {
        if (n == -1) {
            return V3.new3(this.q1 * (f *= this.getFixFactor()), this.q2 * f, this.q3 * f);
        }
        if (this.mat == null) {
            this.setMatrix();
        }
        V3 v3 = new V3();
        this.mat.getColumnV(n, v3);
        if (f != 1.0f) {
            v3.scale(f);
        }
        return v3;
    }

    public V3 getNormal() {
        V3 v3 = Quaternion.getRawNormal(this);
        v3.scale(this.getFixFactor());
        return v3;
    }

    private static V3 getRawNormal(Quaternion quaternion) {
        V3 v3 = V3.new3(quaternion.q1, quaternion.q2, quaternion.q3);
        if (v3.length() == 0.0f) {
            return V3.new3(0.0f, 0.0f, 1.0f);
        }
        v3.normalize();
        return v3;
    }

    public float getTheta() {
        return (float)(Math.acos(Math.abs(this.q0)) * 2.0 * 180.0 / Math.PI);
    }

    public float getThetaRadians() {
        return (float)(Math.acos(Math.abs(this.q0)) * 2.0);
    }

    public V3 getNormalDirected(V3 v3) {
        V3 v32 = this.getNormal();
        if (v32.x * v3.x + v32.y * v3.y + v32.z * v3.z < 0.0f) {
            v32.scale(-1.0f);
        }
        return v32;
    }

    public V3 get3dProjection(V3 v3) {
        v3.set(this.q1, this.q2, this.q3);
        return v3;
    }

    public P4 getThetaDirected(P4 p4) {
        float f = this.getTheta();
        V3 v3 = this.getNormal();
        if (p4.x * this.q1 + p4.y * this.q2 + p4.z * this.q3 < 0.0f) {
            v3.scale(-1.0f);
            f = -f;
        }
        p4.set(v3.x, v3.y, v3.z, f);
        return p4;
    }

    public float getThetaDirectedV(V3 v3) {
        float f = this.getTheta();
        V3 v32 = this.getNormal();
        if (v3.x * this.q1 + v3.y * this.q2 + v3.z * this.q3 < 0.0f) {
            v32.scale(-1.0f);
            f = -f;
        }
        return f;
    }

    public P4 toPoint4f() {
        return P4.new4(this.q1, this.q2, this.q3, this.q0);
    }

    public A4 toAxisAngle4f() {
        double d = 2.0 * Math.acos(Math.abs(this.q0));
        double d2 = Math.sin(d / 2.0);
        V3 v3 = this.getNormal();
        if (d2 < 0.0) {
            v3.scale(-1.0f);
            d = Math.PI - d;
        }
        return A4.newVA(v3, (float)d);
    }

    public P3 transformPt(P3 p3) {
        if (this.mat == null) {
            this.setMatrix();
        }
        P3 p32 = P3.newP(p3);
        this.mat.transform(p32);
        return p32;
    }

    public T3 transformP2(T3 t3, T3 t32) {
        if (this.mat == null) {
            this.setMatrix();
        }
        this.mat.transform2(t3, t32);
        return t32;
    }

    public V3 transform(V3 v3) {
        if (this.mat == null) {
            this.setMatrix();
        }
        V3 v32 = V3.newV(v3);
        this.mat.transform(v32);
        return v32;
    }

    public Quaternion leftDifference(Quaternion quaternion) {
        Quaternion quaternion2 = this.dot(quaternion) < 0.0f ? quaternion.negate() : quaternion;
        return this.inv().mulQ(quaternion2);
    }

    public Quaternion rightDifference(Quaternion quaternion) {
        Quaternion quaternion2 = this.dot(quaternion) < 0.0f ? quaternion.negate() : quaternion;
        return this.mulQ(quaternion2.inv());
    }

    public String getInfo() {
        A4 a4 = this.toAxisAngle4f();
        return Txt.sprintf("%10.6f%10.6f%10.6f%10.6f  %6.2f  %10.5f %10.5f %10.5f", "F", new Object[]{new float[]{this.q0, this.q1, this.q2, this.q3, (float)((double)(a4.angle * 180.0f) / Math.PI), a4.x, a4.y, a4.z}});
    }

    public String draw(String string, String string2, P3 p3, float f) {
        String string3 = " VECTOR " + Escape.eP(p3) + " ";
        if (f == 0.0f) {
            f = 1.0f;
        }
        return "draw " + string + "x" + string2 + string3 + Escape.eP(this.getVectorS(0, f)) + " color red\n" + "draw " + string + "y" + string2 + string3 + Escape.eP(this.getVectorS(1, f)) + " color green\n" + "draw " + string + "z" + string2 + string3 + Escape.eP(this.getVectorS(2, f)) + " color blue\n";
    }

    public String toString() {
        return "{" + this.q1 + " " + this.q2 + " " + this.q3 + " " + this.q0 + "}";
    }

    public static Quaternion[] div(Quaternion[] quaternionArray, Quaternion[] quaternionArray2, int n, boolean bl) {
        int n2;
        if (quaternionArray == null || quaternionArray2 == null || (n2 = Math.min(quaternionArray.length, quaternionArray2.length)) == 0) {
            return null;
        }
        if (n > 0 && n2 > n) {
            n2 = n;
        }
        Quaternion[] quaternionArray3 = new Quaternion[n2];
        for (int i = 0; i < n2; ++i) {
            if (quaternionArray[i] == null || quaternionArray2[i] == null) {
                return null;
            }
            quaternionArray3[i] = bl ? quaternionArray[i].divLeft(quaternionArray2[i]) : quaternionArray[i].div(quaternionArray2[i]);
        }
        return quaternionArray3;
    }

    public static Quaternion sphereMean(Quaternion[] quaternionArray, float[] fArray, float f) {
        if (quaternionArray == null || quaternionArray.length == 0) {
            return new Quaternion();
        }
        if (fArray == null) {
            fArray = new float[1];
        }
        if (quaternionArray.length == 1) {
            fArray[0] = 0.0f;
            return Quaternion.newQ(quaternionArray[0]);
        }
        float f2 = Float.MAX_VALUE;
        float f3 = Float.MAX_VALUE;
        Quaternion quaternion = Quaternion.simpleAverage(quaternionArray);
        int n = 100;
        int n2 = 0;
        while (f2 > f && f3 != 0.0f && n2 < n) {
            quaternion = Quaternion.newMean(quaternionArray, quaternion);
            fArray[0] = Quaternion.stdDev(quaternionArray, quaternion);
            f2 = Math.abs(fArray[0] - f3);
            f3 = fArray[0];
            Logger.info(++n2 + " sphereMean " + quaternion + " stddev=" + f3 + " diff=" + f2);
        }
        return quaternion;
    }

    private static Quaternion simpleAverage(Quaternion[] quaternionArray) {
        V3 v3 = V3.new3(0.0f, 0.0f, 1.0f);
        V3 v32 = quaternionArray[0].getNormal();
        v3.add(v32);
        int n = quaternionArray.length;
        while (--n >= 0) {
            v3.add(quaternionArray[n].getNormalDirected(v3));
        }
        v3.sub(v32);
        v3.normalize();
        float f = 0.0f;
        int n2 = quaternionArray.length;
        while (--n2 >= 0) {
            f += Math.abs(quaternionArray[n2].get3dProjection(v32).dot(v3));
        }
        if (f != 0.0f) {
            v3.scale(f / (float)quaternionArray.length);
        }
        if (Float.isNaN(f = (float)Math.sqrt(1.0f - v3.lengthSquared()))) {
            f = 0.0f;
        }
        return Quaternion.newP4(P4.new4(v3.x, v3.y, v3.z, f));
    }

    private static Quaternion newMean(Quaternion[] quaternionArray, Quaternion quaternion) {
        V3 v3 = new V3();
        int n = quaternionArray.length;
        while (--n >= 0) {
            Quaternion quaternion2 = quaternionArray[n];
            Quaternion quaternion3 = quaternion2.div(quaternion);
            V3 v32 = quaternion3.getNormal();
            v32.scale(quaternion3.getTheta());
            v3.add(v32);
        }
        v3.scale(1.0f / (float)quaternionArray.length);
        Quaternion quaternion4 = Quaternion.newVA(v3, v3.length());
        return quaternion4.mulQ(quaternion);
    }

    private static float stdDev(Quaternion[] quaternionArray, Quaternion quaternion) {
        int n;
        double d = 0.0;
        int n2 = n = quaternionArray.length;
        while (--n2 >= 0) {
            float f = quaternionArray[n2].div(quaternion).getTheta();
            d += (double)(f * f);
        }
        return (float)Math.sqrt(d / (double)n);
    }

    public float[] getEulerZYZ() {
        double d = Math.atan2(2.0f * (this.q2 * this.q3 - this.q0 * this.q1), 2.0f * (this.q1 * this.q3 + this.q0 * this.q2));
        double d2 = Math.acos(this.q3 * this.q3 - this.q2 * this.q2 - this.q1 * this.q1 + this.q0 * this.q0);
        double d3 = Math.atan2(2.0f * (this.q2 * this.q3 + this.q0 * this.q1), 2.0f * (this.q0 * this.q2 - this.q1 * this.q3));
        return new float[]{(float)(d / (Math.PI / 180)), (float)(d2 / (Math.PI / 180)), (float)(d3 / (Math.PI / 180))};
    }

    public float[] getEulerZXZ() {
        double d = Math.atan2(2.0f * (this.q1 * this.q3 + this.q0 * this.q2), 2.0f * (this.q0 * this.q1 - this.q2 * this.q3));
        double d2 = Math.acos(this.q3 * this.q3 - this.q2 * this.q2 - this.q1 * this.q1 + this.q0 * this.q0);
        double d3 = Math.atan2(2.0f * (this.q1 * this.q3 - this.q0 * this.q2), 2.0f * (this.q2 * this.q3 + this.q0 * this.q1));
        return new float[]{(float)(d / (Math.PI / 180)), (float)(d2 / (Math.PI / 180)), (float)(d3 / (Math.PI / 180))};
    }
}

