/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javajs.util.AU;
import org.jmol.constant.EnumPalette;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.util.C;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Elements;
import org.jmol.util.GData;
import org.jmol.util.Logger;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

class ColorManager {
    ColorEncoder propertyColorEncoder = new ColorEncoder(null);
    private Viewer viewer;
    private GData g3d;
    private int[] argbsCpk;
    private int[] altArgbsCpk;
    private float[] colorData;
    private boolean isDefaultColorRasmol;
    short colixRubberband = (short)22;
    short colixBackgroundContrast;

    ColorManager(Viewer viewer, GData gData) {
        this.viewer = viewer;
        this.g3d = gData;
        this.argbsCpk = EnumPalette.argbsCpk;
        this.altArgbsCpk = AU.arrayCopyRangeI(JC.altArgbsCpk, 0, -1);
    }

    void clear() {
    }

    boolean getDefaultColorRasmol() {
        return this.isDefaultColorRasmol;
    }

    void resetElementColors() {
        this.setDefaultColors(false);
    }

    void setDefaultColors(boolean bl) {
        if (bl) {
            this.isDefaultColorRasmol = true;
            this.argbsCpk = AU.arrayCopyI(ColorEncoder.getRasmolScale(), -1);
        } else {
            this.isDefaultColorRasmol = false;
            this.argbsCpk = EnumPalette.argbsCpk;
        }
        this.altArgbsCpk = AU.arrayCopyRangeI(JC.altArgbsCpk, 0, -1);
        this.propertyColorEncoder.createColorScheme(bl ? "Rasmol=" : "Jmol=", true, true);
        int n = EnumPalette.argbsCpk.length;
        while (--n >= 0) {
            this.g3d.changeColixArgb(n, this.argbsCpk[n]);
        }
        n = JC.altArgbsCpk.length;
        while (--n >= 0) {
            this.g3d.changeColixArgb(Elements.elementNumberMax + n, this.altArgbsCpk[n]);
        }
    }

    void setRubberbandArgb(int n) {
        this.colixRubberband = n == 0 ? (short)0 : C.getColix(n);
    }

    void setColixBackgroundContrast(int n) {
        this.colixBackgroundContrast = C.getBgContrast(n);
    }

    short getColixBondPalette(Bond bond, int n) {
        int n2 = 0;
        switch (n) {
            case 19: {
                return this.propertyColorEncoder.getColorIndexFromPalette(bond.getEnergy(), -2.5f, -0.5f, 7, false);
            }
        }
        return n2 == 0 ? (short)10 : (short)C.getColix(n2);
    }

    short getColixAtomPalette(Atom atom, byte by) {
        int n = 0;
        switch (by) {
            case 84: {
                return this.colorData == null || atom.index >= this.colorData.length ? (short)12 : this.getColixForPropertyValue(this.colorData[atom.index]);
            }
            case 0: 
            case 1: {
                int n2 = atom.getAtomicAndIsotopeNumber();
                if (n2 < Elements.elementNumberMax) {
                    return this.g3d.getChangeableColix(n2, this.argbsCpk[n2]);
                }
                int n3 = n2;
                if ((n2 = Elements.altElementIndexFromNumber(n2)) == 0) {
                    n2 = Elements.getElementNumber(n3);
                    return this.g3d.getChangeableColix(n2, this.argbsCpk[n2]);
                }
                return this.g3d.getChangeableColix(Elements.elementNumberMax + n2, this.altArgbsCpk[n2]);
            }
            case 2: {
                int n4 = ColorEncoder.quantize(atom.getPartialCharge(), -1.0f, 1.0f, JC.PARTIAL_CHARGE_RANGE_SIZE);
                return this.g3d.getChangeableColix(JC.PARTIAL_CHARGE_COLIX_RED + n4, JC.argbsRwbScale[n4]);
            }
            case 3: {
                int n5 = atom.getFormalCharge() - -4;
                return this.g3d.getChangeableColix(JC.FORMAL_CHARGE_COLIX_RED + n5, JC.argbsFormalCharge[n5]);
            }
            case 5: 
            case 68: {
                float f;
                float f2;
                if (by == 68) {
                    ModelSet modelSet = this.viewer.getModelSet();
                    f2 = modelSet.getBfactor100Lo();
                    f = modelSet.getBfactor100Hi();
                } else {
                    f2 = 0.0f;
                    f = 10000.0f;
                }
                return this.propertyColorEncoder.getColorIndexFromPalette(atom.getBfactor100(), f2, f, 7, false);
            }
            case 86: {
                return this.propertyColorEncoder.getColorIndexFromPalette(atom.getGroupParameter(1112539150), -1.0f, 1.0f, 7, false);
            }
            case 70: {
                float f = this.viewer.getSurfaceDistanceMax();
                return this.propertyColorEncoder.getColorIndexFromPalette(atom.getSurfaceDistance100(), 0.0f, f, 7, false);
            }
            case 8: {
                return this.propertyColorEncoder.getColorIndexFromPalette(atom.getGroupID(), 0.0f, 0.0f, 5, false);
            }
            case 9: {
                return this.propertyColorEncoder.getColorIndexFromPalette(atom.getGroupID(), 0.0f, 0.0f, 4, false);
            }
            case 75: {
                return this.propertyColorEncoder.getColorIndexFromPalette(atom.getSelectedGroupIndexWithinChain(), 0.0f, atom.getSelectedGroupCountWithinChain() - 1, 1, false);
            }
            case 87: {
                Model model = this.viewer.getModelSet().models[atom.modelIndex];
                return this.propertyColorEncoder.getColorIndexFromPalette(atom.getPolymerIndexInModel(), 0.0f, model.getBioPolymerCount() - 1, 1, false);
            }
            case 76: {
                return this.propertyColorEncoder.getColorIndexFromPalette(atom.getSelectedMonomerIndexWithinPolymer(), 0.0f, atom.getSelectedMonomerCountWithinPolymer() - 1, 1, false);
            }
            case 77: {
                ModelSet modelSet = this.viewer.getModelSet();
                return this.propertyColorEncoder.getColorIndexFromPalette(modelSet.getMoleculeIndex(atom.getIndex(), true), 0.0f, modelSet.getMoleculeCountInModel(atom.getModelIndex()) - 1, 0, false);
            }
            case 14: {
                ModelSet modelSet = this.viewer.getModelSet();
                int n6 = atom.getModelIndex();
                return this.propertyColorEncoder.getColorIndexFromPalette(modelSet.getAltLocIndexInModel(n6, atom.getAlternateLocationID()), 0.0f, modelSet.getAltLocCountInModel(n6), 0, false);
            }
            case 15: {
                ModelSet modelSet = this.viewer.getModelSet();
                int n7 = atom.getModelIndex();
                return this.propertyColorEncoder.getColorIndexFromPalette(modelSet.getInsertionCodeIndexInModel(n7, atom.getInsertionCode()), 0.0f, modelSet.getInsertionCountInModel(n7), 0, false);
            }
            case 16: {
                int n8 = atom.getAtomicAndIsotopeNumber();
                n = this.getJmolOrRasmolArgb(n8, 1073741992);
                break;
            }
            case 17: {
                int n9 = atom.getAtomicAndIsotopeNumber();
                n = this.getJmolOrRasmolArgb(n9, 1073742116);
                break;
            }
            case 7: {
                n = atom.getProteinStructureSubType().getColor();
                break;
            }
            case 10: {
                int n10 = atom.getChainID();
                n10 = ((n10 < 0 ? 0 : (n10 >= 256 ? n10 - 256 : n10)) & 0x1F) % JC.argbsChainAtom.length;
                n = (atom.isHetero() ? JC.argbsChainHetero : JC.argbsChainAtom)[n10];
            }
        }
        return n == 0 ? (short)22 : (short)C.getColix(n);
    }

    private int getJmolOrRasmolArgb(int n, int n2) {
        switch (n2) {
            case 1073741992: {
                if (n >= Elements.elementNumberMax) break;
                return this.propertyColorEncoder.getArgbFromPalette(n, 0.0f, 0.0f, 2);
            }
            case 1073742116: {
                if (n >= Elements.elementNumberMax) break;
                return this.propertyColorEncoder.getArgbFromPalette(n, 0.0f, 0.0f, 3);
            }
            default: {
                return n2;
            }
        }
        return JC.altArgbsCpk[Elements.altElementIndexFromNumber(n)];
    }

    void setElementArgb(int n, int n2) {
        if (n2 == 1073741992 && this.argbsCpk == EnumPalette.argbsCpk) {
            return;
        }
        n2 = this.getJmolOrRasmolArgb(n, n2);
        if (this.argbsCpk == EnumPalette.argbsCpk) {
            this.argbsCpk = AU.arrayCopyRangeI(EnumPalette.argbsCpk, 0, -1);
            this.altArgbsCpk = AU.arrayCopyRangeI(JC.altArgbsCpk, 0, -1);
        }
        if (n < Elements.elementNumberMax) {
            this.argbsCpk[n] = n2;
            this.g3d.changeColixArgb(n, n2);
            return;
        }
        n = Elements.altElementIndexFromNumber(n);
        this.altArgbsCpk[n] = n2;
        this.g3d.changeColixArgb(Elements.elementNumberMax + n, n2);
    }

    float[] getPropertyColorRange() {
        if (this.propertyColorEncoder.isReversed) {
            return new float[]{this.propertyColorEncoder.hi, this.propertyColorEncoder.lo};
        }
        return new float[]{this.propertyColorEncoder.lo, this.propertyColorEncoder.hi};
    }

    void setPropertyColorRangeData(float[] fArray, BS bS, String string) {
        int n;
        this.colorData = fArray;
        this.propertyColorEncoder.currentPalette = this.propertyColorEncoder.createColorScheme(string, true, false);
        this.propertyColorEncoder.hi = -3.4028235E38f;
        this.propertyColorEncoder.lo = Float.MAX_VALUE;
        if (fArray == null) {
            return;
        }
        boolean bl = bS == null;
        int n2 = n = bl ? fArray.length - 1 : bS.nextSetBit(0);
        while (n2 >= 0) {
            float f = fArray[n2];
            if (!Float.isNaN(f)) {
                this.propertyColorEncoder.hi = Math.max(this.propertyColorEncoder.hi, f);
                this.propertyColorEncoder.lo = Math.min(this.propertyColorEncoder.lo, f);
            }
            n2 = bl ? n2 - 1 : bS.nextSetBit(n2 + 1);
        }
        this.setPropertyColorRange(this.propertyColorEncoder.lo, this.propertyColorEncoder.hi);
    }

    void setPropertyColorRange(float f, float f2) {
        this.propertyColorEncoder.setRange(f, f2, f > f2);
        if (Logger.debugging) {
            Logger.debug("ColorManager: color \"" + this.propertyColorEncoder.getCurrentColorSchemeName() + "\" range " + f + " " + f2);
        }
    }

    void setPropertyColorScheme(String string, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = string.length() == 0;
        if (bl3) {
            string = "=";
        }
        float[] fArray = this.getPropertyColorRange();
        this.propertyColorEncoder.currentPalette = this.propertyColorEncoder.createColorScheme(string, true, bl2);
        if (!bl3) {
            this.setPropertyColorRange(fArray[0], fArray[1]);
        }
        this.propertyColorEncoder.isTranslucent = bl;
    }

    void setUserScale(int[] nArray) {
        this.propertyColorEncoder.setUserScale(nArray);
    }

    String getColorSchemeList(String string) {
        int n = string == null || string.length() == 0 ? this.propertyColorEncoder.currentPalette : this.propertyColorEncoder.createColorScheme(string, true, false);
        return ColorEncoder.getColorSchemeList(this.propertyColorEncoder.getColorSchemeArray(n));
    }

    short getColixForPropertyValue(float f) {
        return this.propertyColorEncoder.getColorIndex(f);
    }

    public ColorEncoder getColorEncoder(String string) {
        if (string == null || string.length() == 0) {
            return this.propertyColorEncoder;
        }
        ColorEncoder colorEncoder = new ColorEncoder(this.propertyColorEncoder);
        colorEncoder.currentPalette = colorEncoder.createColorScheme(string, false, true);
        return colorEncoder.currentPalette == Integer.MAX_VALUE ? null : colorEncoder;
    }
}

