/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javajs.J2SIgnoreImport;
import javajs.api.GenericMenuInterface;
import javajs.api.GenericMouseInterface;
import javajs.api.GenericPlatform;
import javajs.api.PlatformViewer;
import javajs.awt.Dimension;
import javajs.awt.Font;
import javajs.util.A4;
import javajs.util.AU;
import javajs.util.CU;
import javajs.util.DF;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.AtomIndexIterator;
import org.jmol.api.Interface;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolAppConsoleInterface;
import org.jmol.api.JmolCallbackListener;
import org.jmol.api.JmolDataManager;
import org.jmol.api.JmolJSpecView;
import org.jmol.api.JmolNMRInterface;
import org.jmol.api.JmolParallelProcessor;
import org.jmol.api.JmolPropertyManager;
import org.jmol.api.JmolRendererInterface;
import org.jmol.api.JmolRepaintManager;
import org.jmol.api.JmolScriptEditorInterface;
import org.jmol.api.JmolScriptEvaluator;
import org.jmol.api.JmolScriptFunction;
import org.jmol.api.JmolScriptManager;
import org.jmol.api.JmolSelectionListener;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolViewer;
import org.jmol.api.MinimizerInterface;
import org.jmol.api.SmilesMatcherInterface;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.AtomData;
import org.jmol.atomdata.AtomDataServer;
import org.jmol.atomdata.RadiusData;
import org.jmol.constant.EnumAnimationMode;
import org.jmol.constant.EnumAxesMode;
import org.jmol.constant.EnumFileStatus;
import org.jmol.constant.EnumStereoMode;
import org.jmol.constant.EnumStructure;
import org.jmol.constant.EnumVdw;
import org.jmol.i18n.GT;
import org.jmol.io.CifDataReader;
import org.jmol.io.JmolBinary;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondSet;
import org.jmol.modelset.Group;
import org.jmol.modelset.Measurement;
import org.jmol.modelset.MeasurementPending;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.Orientation;
import org.jmol.modelset.StateScript;
import org.jmol.modelset.TickInfo;
import org.jmol.script.SV;
import org.jmol.script.ScriptContext;
import org.jmol.script.T;
import org.jmol.shape.AtomShape;
import org.jmol.shape.Measures;
import org.jmol.shape.Shape;
import org.jmol.thread.TimeoutThread;
import org.jmol.util.BSUtil;
import org.jmol.util.BoxInfo;
import org.jmol.util.C;
import org.jmol.util.ColorEncoder;
import org.jmol.util.CommandHistory;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.GData;
import org.jmol.util.JmolMolecule;
import org.jmol.util.JmolNode;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.Parser;
import org.jmol.util.Point3fi;
import org.jmol.util.Quaternion;
import org.jmol.util.Rectangle;
import org.jmol.util.TempArray;
import org.jmol.util.Txt;
import org.jmol.util.Vibration;
import org.jmol.viewer.ActionManager;
import org.jmol.viewer.AnimationManager;
import org.jmol.viewer.ColorManager;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.GlobalSettings;
import org.jmol.viewer.JC;
import org.jmol.viewer.JmolStateCreator;
import org.jmol.viewer.ModelManager;
import org.jmol.viewer.OutputManager;
import org.jmol.viewer.SelectionManager;
import org.jmol.viewer.ShapeManager;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.StatusManager;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.binding.Binding;

@J2SIgnoreImport(value={Runtime.class})
public class Viewer
extends JmolViewer
implements AtomDataServer,
PlatformViewer {
    public boolean autoExit = false;
    public boolean haveDisplay = false;
    public boolean isJS;
    public boolean isWebGL;
    public boolean isSingleThreaded;
    public boolean queueOnHold = false;
    public String fullName = "";
    public String appletDocumentBase = "";
    public String appletCodeBase = "";
    public String appletIdiomaBase;
    public static String jsDocumentBase = "";
    public Object compiler;
    public Map<String, Object> definedAtomSets;
    public ModelSet modelSet;
    public FileManager fileManager;
    private boolean isApplet;
    private boolean isJNLP;
    public boolean isSyntaxAndFileCheck = false;
    public boolean isSyntaxCheck = false;
    public boolean listCommands = false;
    boolean mustRender = false;
    String htmlName = "";
    private String insertedCommand = "";
    GData gdata;
    Object applet;
    ActionManager actionManager;
    AnimationManager animationManager;
    ColorManager colorManager;
    JmolDataManager dataManager;
    ShapeManager shapeManager;
    SelectionManager selectionManager;
    JmolRepaintManager repaintManager;
    public GlobalSettings global;
    public StatusManager statusManager;
    TransformManager transformManager;
    private static final String strJavaVendor = System.getProperty("java.vendor", "j2s");
    private static final String strOSName = System.getProperty("os.name", "j2s");
    private static final String strJavaVersion = System.getProperty("java.version", "0.0");
    private String syncId = "";
    private String logFilePath = "";
    private boolean allowScripting;
    private boolean isPrintOnly = false;
    private boolean isSignedApplet = false;
    private boolean isSignedAppletLocal = false;
    private boolean isSilent;
    private boolean multiTouch;
    private boolean noGraphicsAllowed;
    private boolean useCommandThread = false;
    private String commandOptions;
    private Map<String, Object> viewerOptions;
    private Object display;
    private JmolAdapter modelAdapter;
    private ACCESS access;
    private CommandHistory commandHistory = new CommandHistory();
    private SymmetryInterface symmetry;
    private SmilesMatcherInterface smilesMatcher;
    private ModelManager modelManager;
    private StateManager stateManager;
    private JmolScriptManager scriptManager;
    public JmolScriptEvaluator eval;
    private TempArray tempArray;
    private static String version_date;
    private boolean isPreviewOnly = false;
    private GenericMouseInterface mouse;
    private boolean mouseEnabled = true;
    private boolean noneSelected;
    Map<String, Object> ligandModels;
    Map<String, Boolean> ligandModelSet;
    JmolStateCreator sc;
    BS bsFrameOffsets;
    P3[] frameOffsets;
    private int motionEventNumber;
    private boolean inMotion;
    private boolean refreshing = true;
    private boolean axesAreTainted = false;
    final Dimension dimScreen = new Dimension(0, 0);
    private int maximumSize = Integer.MAX_VALUE;
    private float imageFontScaling = 1.0f;
    public Map<String, Object> captureParams;
    private Map<String, Object> jsParams;
    private boolean antialiasDisplay;
    int hoverAtomIndex = -1;
    String hoverText;
    public boolean hoverEnabled = true;
    private int currentCursor = 0;
    int prevFrame = Integer.MIN_VALUE;
    private boolean haveJDX;
    private JmolJSpecView jsv;
    private String language = GT.getLanguage();
    private RadiusData rd = new RadiusData(null, 0.0f, null, null);
    private boolean frankOn = true;
    public boolean scriptEditorVisible;
    JmolAppConsoleInterface appConsole;
    JmolScriptEditorInterface scriptEditor;
    GenericMenuInterface jmolpopup;
    private GenericMenuInterface modelkitPopup;
    private Map<String, Object> headlessImageParams;
    JmolPropertyManager pm;
    boolean isTainted = true;
    private boolean movingSelected;
    private boolean showSelected;
    private int rotateBondIndex = -1;
    private int rotatePrev1 = -1;
    private int rotatePrev2 = -1;
    private BS bsRotateBranch;
    public boolean creatingImage;
    private OutputManager outputManager;
    public static final String SYNC_GRAPHICS_MESSAGE = "GET_GRAPHICS";
    public static final String SYNC_NO_GRAPHICS_MESSAGE = "SET_GRAPHICS_OFF";
    BS bsUserVdws;
    float[] userVdws;
    int[] userVdwMars;
    EnumVdw defaultVdw = EnumVdw.JMOL;
    private String errorMessage;
    private String errorMessageUntranslated;
    private int currentShapeID = -1;
    private String currentShapeState;
    static final Map<String, JmolScriptFunction> staticFunctions;
    Map<String, JmolScriptFunction> localFunctions = new Hashtable<String, JmolScriptFunction>();
    private double privateKey = Math.random();
    boolean isKiosk;
    private MinimizerInterface minimizer;
    private Object executor;
    public static int nProcessors;
    public boolean displayLoadErrors = true;
    boolean isParallel;
    final javajs.util.List<String> actionStates = new javajs.util.List();
    final javajs.util.List<String> actionStatesRedo = new javajs.util.List();
    private int stateScriptVersionInt;
    private JmolRendererInterface jsExporter3D;
    Map<String, String[][]> htPdbBondInfo;
    Map<String, Object> timeouts;
    public Map<Object, Object> chainMap = new Hashtable<Object, Object>();
    public javajs.util.List<String> chainList = new javajs.util.List();
    JmolNMRInterface nmrCalculation;
    String logFileName;

    protected void finalize() throws Throwable {
        if (Logger.debugging) {
            Logger.debug("viewer finalize " + this);
        }
        super.finalize();
    }

    public boolean hasDisplay() {
        return this.haveDisplay;
    }

    @Override
    public boolean isApplet() {
        return this.isApplet;
    }

    public void setInsertedCommand(String string) {
        this.insertedCommand = string;
    }

    public ActionManager getActionManager() {
        return this.actionManager;
    }

    String getLogFilePath() {
        return this.logFilePath;
    }

    public boolean isSignedApplet() {
        return this.isSignedApplet;
    }

    public static String getJmolVersion() {
        return version_date == null ? (version_date = JC.version + "  " + JC.date) : version_date;
    }

    protected static JmolViewer allocateViewer(Object object, JmolAdapter jmolAdapter, String string, URL uRL, URL uRL2, String string2, JmolStatusListener jmolStatusListener, GenericPlatform genericPlatform) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("display", object);
        hashtable.put("adapter", jmolAdapter);
        hashtable.put("statusListener", jmolStatusListener);
        hashtable.put("platform", genericPlatform);
        hashtable.put("options", string2);
        hashtable.put("fullName", string);
        hashtable.put("documentBase", uRL);
        hashtable.put("codeBase", uRL2);
        return new Viewer(hashtable);
    }

    public Viewer(Map<String, Object> map) {
        this.setOptions(map);
    }

    StatusManager getStatusManager() {
        return this.statusManager;
    }

    public boolean haveAccess(ACCESS aCCESS) {
        return this.access == aCCESS;
    }

    @Override
    public JmolAdapter getModelAdapter() {
        if (this.modelAdapter == null) {
            this.modelAdapter = new SmarterJmolAdapter();
        }
        return this.modelAdapter;
    }

    public SymmetryInterface getSymmetry() {
        if (this.symmetry == null) {
            this.symmetry = (SymmetryInterface)Interface.getOptionInterface("symmetry.Symmetry");
        }
        return this.symmetry;
    }

    public Object getSymmetryInfo(BS bS, String string, int n, P3 p3, P3 p32, String string2, int n2) {
        return this.getPropertyManager().getSymmetryInfo(bS, string, n, p3, p32, string2, n2);
    }

    public SmilesMatcherInterface getSmilesMatcher() {
        if (this.smilesMatcher == null) {
            this.smilesMatcher = (SmilesMatcherInterface)Interface.getOptionInterface("smiles.SmilesMatcher");
        }
        return this.smilesMatcher;
    }

    @Override
    public BS getSmartsMatch(String string, BS bS) {
        if (bS == null) {
            bS = this.getSelectionSet(false);
        }
        return this.getSmilesMatcher().getSubstructureSet(string, this.modelSet.atoms, this.getAtomCount(), bS, true, false);
    }

    public Map<String, Object> getViewerOptions() {
        return this.viewerOptions;
    }

    private void setOptions(Map<String, Object> map) {
        Object object;
        this.viewerOptions = map;
        if (Logger.debugging) {
            Logger.debug("Viewer constructor " + this);
        }
        this.modelAdapter = (JmolAdapter)map.get("adapter");
        JmolStatusListener jmolStatusListener = (JmolStatusListener)map.get("statusListener");
        this.fullName = (String)map.get("fullName");
        if (this.fullName == null) {
            this.fullName = "";
        }
        if ((object = map.get("codePath")) == null) {
            object = "../java/";
        }
        this.appletCodeBase = object.toString();
        this.appletIdiomaBase = this.appletCodeBase.substring(0, this.appletCodeBase.lastIndexOf("/", this.appletCodeBase.length() - 2) + 1) + "idioma";
        object = map.get("documentBase");
        this.appletDocumentBase = object == null ? "" : object.toString();
        object = map.get("options");
        String string = this.commandOptions = object == null ? "" : object.toString();
        if (map.containsKey("debug") || this.commandOptions.indexOf("-debug") >= 0) {
            Logger.setLogLevel(5);
        }
        this.isJNLP = this.checkOption2("isJNLP", "-jnlp");
        if (this.isJNLP) {
            Logger.info("setting JNLP mode TRUE");
        }
        this.isSignedApplet = this.isJNLP || this.checkOption2("signedApplet", "-signed");
        this.isApplet = this.isSignedApplet || this.checkOption2("applet", "-applet");
        this.allowScripting = !this.checkOption2("noscripting", "-noscripting");
        int n = this.fullName.indexOf("__");
        this.htmlName = n < 0 ? this.fullName : this.fullName.substring(0, n);
        String string2 = this.syncId = n < 0 ? "" : this.fullName.substring(n + 2, this.fullName.length() - 2);
        if (this.isApplet && map.containsKey("maximumSize")) {
            this.setMaximumSize((Integer)map.get("maximumSize"));
        }
        this.access = this.checkOption2("access:READSPT", "-r") ? ACCESS.READSPT : (this.checkOption2("access:NONE", "-R") ? ACCESS.NONE : ACCESS.ALL);
        this.isPreviewOnly = map.containsKey("previewOnly");
        if (this.isPreviewOnly) {
            map.remove("previewOnly");
        }
        this.isPrintOnly = this.checkOption2("printOnly", "-p");
        object = map.get("platform");
        String string3 = "unknown";
        if (object == null) {
            Object object2 = object = this.commandOptions.contains("platform=") ? this.commandOptions.substring(this.commandOptions.indexOf("platform=") + 9) : "org.jmol.awt.Platform";
        }
        if (object instanceof String) {
            string3 = (String)object;
            this.isWebGL = string3.indexOf(".awtjs.") >= 0;
            this.isJS = this.isWebGL || string3.indexOf(".awtjs2d.") >= 0;
            object = Interface.getInterface(string3);
        }
        this.apiPlatform = (GenericPlatform)object;
        this.display = map.get("display");
        this.isSingleThreaded = this.apiPlatform.isSingleThreaded();
        this.noGraphicsAllowed = this.checkOption2("noGraphics", "-n");
        this.haveDisplay = this.isWebGL || this.display != null && !this.noGraphicsAllowed && !this.isHeadless() && !this.checkOption2("isDataOnly", "\u0000");
        this.noGraphicsAllowed &= this.display == null;
        if (this.haveDisplay) {
            this.mustRender = true;
            this.multiTouch = this.checkOption2("multiTouch", "-multitouch");
        } else {
            this.display = null;
        }
        this.apiPlatform.setViewer(this, this.display);
        object = map.get("graphicsAdapter");
        if (object == null && !this.isWebGL) {
            object = Interface.getInterface("org.jmol.g3d.Graphics3D");
        }
        this.gdata = object == null ? new GData() : (GData)object;
        this.gdata.initialize(this.apiPlatform);
        this.stateManager = new StateManager(this);
        this.colorManager = new ColorManager(this, this.gdata);
        this.statusManager = new StatusManager(this);
        this.transformManager = new TransformManager(this, Integer.MAX_VALUE, 0);
        this.selectionManager = new SelectionManager(this);
        if (this.haveDisplay) {
            this.actionManager = this.multiTouch ? (ActionManager)Interface.getOptionInterface("multitouch.ActionManagerMT") : new ActionManager();
            this.actionManager.setViewer(this, this.commandOptions + "-multitouch-" + map.get("multiTouch"));
            this.mouse = this.apiPlatform.getMouseManager(this.privateKey, this.display);
            if (this.multiTouch && !this.checkOption2("-simulated", "-simulated")) {
                this.apiPlatform.setTransparentCursor(this.display);
            }
        }
        this.modelManager = new ModelManager(this);
        this.shapeManager = new ShapeManager(this);
        this.tempArray = new TempArray();
        this.animationManager = new AnimationManager(this);
        object = map.get("repaintManager");
        if (object == null) {
            object = Interface.getOptionInterface("render.RepaintManager");
        }
        if (object != null && !object.equals("")) {
            this.repaintManager = (JmolRepaintManager)object;
            this.repaintManager.set(this, this.shapeManager);
        }
        this.initialize(true);
        this.fileManager = new FileManager(this);
        this.definedAtomSets = new Hashtable<String, Object>();
        this.setJmolStatusListener(jmolStatusListener);
        if (this.isApplet) {
            Logger.info("viewerOptions: \n" + Escape.escapeMap(this.viewerOptions));
            String string4 = (String)this.viewerOptions.get("documentLocation");
            if (!this.isJS && string4 != null && string4.startsWith("file:/")) {
                string4 = string4.substring(0, string4.substring(0, (string4 + "?").indexOf("?")).lastIndexOf("/"));
                Logger.info("setting current directory to " + string4);
                this.cd(string4);
            }
            if ((n = (string4 = this.appletDocumentBase).indexOf("#")) >= 0) {
                string4 = string4.substring(0, n);
            }
            if ((n = string4.lastIndexOf("?")) >= 0) {
                string4 = string4.substring(0, n);
            }
            if ((n = string4.lastIndexOf("/")) >= 0) {
                string4 = string4.substring(0, n);
            }
            jsDocumentBase = string4;
            this.fileManager.setAppletContext(this.appletDocumentBase);
            String string5 = (String)map.get("appletProxy");
            if (string5 != null) {
                this.setStringProperty("appletProxy", string5);
            }
            if (this.isSignedApplet) {
                this.logFilePath = PT.simpleReplace(this.appletCodeBase, "file://", "");
                this.logFilePath = PT.simpleReplace(this.logFilePath, "file:/", "");
                if (this.logFilePath.indexOf("//") >= 0) {
                    this.logFilePath = null;
                } else {
                    this.isSignedAppletLocal = true;
                }
            } else if (!this.isJS) {
                this.logFilePath = null;
            }
        } else {
            this.gdata.setBackgroundTransparent(this.checkOption2("backgroundTransparent", "-b"));
            this.isSilent = this.checkOption2("silent", "-i");
            if (this.isSilent) {
                Logger.setLogLevel(3);
            }
            this.isSyntaxAndFileCheck = this.checkOption2("checkLoad", "-C");
            this.isSyntaxCheck = this.isSyntaxAndFileCheck || this.checkOption2("check", "-c");
            this.listCommands = this.checkOption2("listCommands", "-l");
            this.autoExit = this.checkOption2("exit", "-x");
            this.cd(".");
            if (this.isHeadless()) {
                this.headlessImageParams = (Map)map.get("headlessImage");
                object = map.get("headlistMaxTimeMs");
                if (object == null) {
                    object = 60000;
                }
                this.setTimeout("" + Math.random(), (Integer)object, "exitJmol");
            }
        }
        this.useCommandThread = !this.isHeadless() && this.checkOption2("useCommandThread", "-threaded");
        this.setStartupBooleans();
        this.setIntProperty("_nProcessors", nProcessors);
        object = map.get("menuFile");
        if (object != null) {
            this.getProperty("DATA_API", "setMenu", this.getFileAsString((String)object));
        }
        if (!this.isSilent) {
            Logger.info("(C) 2012 Jmol Development\nJmol Version: " + Viewer.getJmolVersion() + "\njava.vendor: " + strJavaVendor + "\njava.version: " + strJavaVersion + "\nos.name: " + strOSName + "\nAccess: " + (Object)((Object)this.access) + "\nmemory: " + this.getParameter("_memory") + "\nprocessors available: " + nProcessors + "\nuseCommandThread: " + this.useCommandThread + (!this.isApplet ? "" : "\nappletId:" + this.htmlName + (this.isSignedApplet ? " (signed)" : "")));
        }
        this.zap(false, true, false);
        this.global.setS("language", GT.getLanguage());
        this.stateManager.setJmolDefaults();
    }

    public void setDisplay(Object object) {
        this.display = object;
        this.apiPlatform.setViewer(this, object);
    }

    private JmolDataManager getDataManager() {
        return this.dataManager == null ? (this.dataManager = ((JmolDataManager)Interface.getOptionInterface("viewer.DataManager")).set(this)) : this.dataManager;
    }

    private JmolScriptManager getScriptManager() {
        if (this.allowScripting && this.scriptManager == null) {
            this.scriptManager = (JmolScriptManager)Interface.getOptionInterface("script.ScriptManager");
            this.scriptManager.setViewer(this);
            this.eval = this.scriptManager.getEval();
            if (this.useCommandThread) {
                this.scriptManager.startCommandWatcher(true);
            }
        }
        return this.scriptManager;
    }

    private boolean checkOption2(String string, String string2) {
        return this.viewerOptions.containsKey(string) || this.commandOptions.indexOf(string2) >= 0;
    }

    public boolean isPreviewOnly() {
        return this.isPreviewOnly;
    }

    public boolean isHeadless() {
        return this.apiPlatform.isHeadless();
    }

    private void setStartupBooleans() {
        this.setBooleanProperty("_applet", this.isApplet);
        this.setBooleanProperty("_JSpecView".toLowerCase(), false);
        this.setBooleanProperty("_signedApplet", this.isSignedApplet);
        this.setBooleanProperty("_headless", this.apiPlatform.isHeadless());
        this.setStringProperty("_restrict", "\"" + (Object)((Object)this.access) + "\"");
        this.setBooleanProperty("_useCommandThread", this.useCommandThread);
    }

    public boolean noGraphicsAllowed() {
        return this.noGraphicsAllowed;
    }

    public String getExportDriverList() {
        return this.haveAccess(ACCESS.ALL) ? (String)this.global.getParameter("exportDrivers") : "";
    }

    public String getHtmlName() {
        return this.htmlName;
    }

    @Override
    public Object getDisplay() {
        return this.display;
    }

    public void clearMouse() {
        this.mouse.clear();
    }

    public void disposeMouse() {
        this.actionManager.dispose();
        this.mouse.dispose();
        this.mouse = null;
    }

    @Override
    public void processTwoPointGesture(float[][][] fArray) {
        this.mouse.processTwoPointGesture(fArray);
    }

    @Override
    public boolean processMouseEvent(int n, int n2, int n3, int n4, long l) {
        return this.mouse.processEvent(n, n2, n3, n4, l);
    }

    public void reset(boolean bl) {
        this.modelSet.calcBoundBoxDimensions(null, 1.0f);
        this.axesAreTainted = true;
        this.transformManager.homePosition(bl);
        if (this.modelSet.setCrystallographicDefaults()) {
            this.stateManager.setCrystallographicDefaults();
        } else {
            this.setAxesModeMolecular(false);
        }
        this.prevFrame = Integer.MIN_VALUE;
        if (!this.getSpinOn()) {
            this.refresh(-1, "Viewer:homePosition()");
        }
    }

    @Override
    public void homePosition() {
        this.evalString("reset spin");
    }

    Map<String, Object> getAppletInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("htmlName", this.htmlName);
        hashtable.put("syncId", this.syncId);
        hashtable.put("fullName", this.fullName);
        if (this.isApplet) {
            hashtable.put("documentBase", this.appletDocumentBase);
            hashtable.put("codeBase", this.appletCodeBase);
            hashtable.put("registry", this.statusManager.getRegistryInfo());
        }
        hashtable.put("version", JC.version);
        hashtable.put("date", JC.date);
        hashtable.put("javaVendor", strJavaVendor);
        hashtable.put("javaVersion", strJavaVersion + (!this.isJS ? "" : (this.isWebGL ? "(WebGL)" : "(HTML5)")));
        hashtable.put("operatingSystem", strOSName);
        return hashtable;
    }

    public void initialize(boolean bl) {
        this.global = this.stateManager.getGlobalSettings(this.global, bl);
        this.setStartupBooleans();
        this.global.setI("_width", this.dimScreen.width);
        this.global.setI("_height", this.dimScreen.height);
        if (this.haveDisplay) {
            this.global.setB("_is2D", this.isJS && !this.isWebGL);
            this.global.setB("_multiTouchClient", this.actionManager.isMTClient());
            this.global.setB("_multiTouchServer", this.actionManager.isMTServer());
        }
        this.colorManager.resetElementColors();
        this.setObjectColor("background", "black");
        this.setObjectColor("axis1", "red");
        this.setObjectColor("axis2", "green");
        this.setObjectColor("axis3", "blue");
        this.gdata.setAmbientPercent(this.global.ambientPercent);
        this.gdata.setDiffusePercent(this.global.diffusePercent);
        this.gdata.setSpecular(this.global.specular);
        this.gdata.setCel(this.global.celShading);
        this.gdata.setCelPower(this.global.celShadingPower);
        this.gdata.setSpecularPercent(this.global.specularPercent);
        this.gdata.setSpecularPower(-this.global.specularExponent);
        this.gdata.setPhongExponent(this.global.phongExponent);
        this.gdata.setSpecularPower(this.global.specularPower);
        if (this.modelSet != null) {
            this.animationManager.setAnimationOn(false);
        }
        this.animationManager.setAnimationFps(this.global.animationFps);
        this.statusManager.setAllowStatusReporting(this.global.statusReporting);
        this.setBooleanProperty("antialiasDisplay", this.global.antialiasDisplay);
        this.setTransformManagerDefaults();
    }

    public String listSavedStates() {
        return this.stateManager.listSavedStates();
    }

    public void saveOrientation(String string, float[] fArray) {
        this.stateManager.saveOrientation(string, fArray);
    }

    public void saveScene(String string, Map<String, Object> map) {
        this.stateManager.saveScene(string, map);
    }

    public void restoreScene(String string, float f) {
        this.stateManager.restoreScene(string, f);
    }

    public boolean restoreOrientation(String string, float f) {
        return this.stateManager.restoreOrientation(string, f, true);
    }

    public void restoreRotation(String string, float f) {
        this.stateManager.restoreOrientation(string, f, false);
    }

    void saveModelOrientation() {
        this.modelSet.saveModelOrientation(this.animationManager.currentModelIndex, this.stateManager.getOrientation());
    }

    public Orientation getOrientation() {
        return this.stateManager.getOrientation();
    }

    void restoreModelOrientation(int n) {
        Orientation orientation = this.modelSet.getModelOrientation(n);
        if (orientation != null) {
            orientation.restore(-1.0f, true);
        }
    }

    void restoreModelRotation(int n) {
        Orientation orientation = this.modelSet.getModelOrientation(n);
        if (orientation != null) {
            orientation.restore(-1.0f, false);
        }
    }

    public void saveBonds(String string) {
        this.stateManager.saveBonds(string);
    }

    public boolean restoreBonds(String string) {
        this.clearModelDependentObjects();
        return this.stateManager.restoreBonds(string);
    }

    public void saveState(String string) {
        this.stateManager.saveState(string);
    }

    public void deleteSavedState(String string) {
        this.stateManager.deleteSaved("State_" + string);
    }

    public String getSavedState(String string) {
        return this.stateManager.getSavedState(string);
    }

    public void saveStructure(String string) {
        this.stateManager.saveStructure(string);
    }

    public String getSavedStructure(String string) {
        return this.stateManager.getSavedStructure(string);
    }

    public void saveCoordinates(String string, BS bS) {
        this.stateManager.saveCoordinates(string, bS);
    }

    public String getSavedCoordinates(String string) {
        return this.stateManager.getSavedCoordinates(string);
    }

    public void saveSelection(String string) {
        this.stateManager.saveSelection(string, this.getSelectionSet(false));
        this.stateManager.restoreSelection(string);
    }

    public boolean restoreSelection(String string) {
        return this.stateManager.restoreSelection(string);
    }

    public M4 getMatrixtransform() {
        return this.transformManager.getMatrixtransform();
    }

    public Quaternion getRotationQuaternion() {
        return this.transformManager.getRotationQuaternion();
    }

    public void setRotationRadius(float f, boolean bl) {
        if (bl) {
            f = this.transformManager.setRotationRadius(f, false);
        }
        if (this.modelSet.setRotationRadius(this.animationManager.currentModelIndex, f)) {
            this.global.setF("rotationRadius", f);
        }
    }

    public P3 getRotationCenter() {
        return this.transformManager.getRotationCenter();
    }

    public void setCenterAt(String string, P3 p3) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.setCenterAt(string, p3);
    }

    public void setCenterBitSet(BS bS, boolean bl) {
        P3 p3;
        P3 p32 = p3 = BSUtil.cardinalityOf(bS) > 0 ? this.getAtomSetCenter(bS) : null;
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.setNewRotationCenter(p3, bl);
    }

    public void setNewRotationCenter(P3 p3) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.setNewRotationCenter(p3, true);
    }

    public P3 getNavigationCenter() {
        return this.transformManager.getNavigationCenter();
    }

    public float getNavigationDepthPercent() {
        return this.transformManager.getNavigationDepthPercent();
    }

    void navigate(int n, int n2) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.navigateKey(n, n2);
        if (!this.transformManager.vibrationOn && n != 0) {
            this.refresh(1, "Viewer:navigate()");
        }
    }

    public P3 getNavigationOffset() {
        return this.transformManager.getNavigationOffset();
    }

    public float getNavigationOffsetPercent(char c) {
        return this.transformManager.getNavigationOffsetPercent(c);
    }

    public boolean isNavigating() {
        return this.transformManager.isNavigating();
    }

    public boolean isInPosition(V3 v3, float f) {
        return this.transformManager.isInPosition(v3, f);
    }

    public void move(JmolScriptEvaluator jmolScriptEvaluator, V3 v3, float f, V3 v32, float f2, float f3, int n) {
        this.transformManager.move(jmolScriptEvaluator, v3, f, v32, f2, f3, n);
        this.moveUpdate(f3);
    }

    public void stopMotion() {
        this.transformManager.stopMotion();
    }

    public void setRotationMatrix(M3 m3) {
        this.transformManager.setRotation(m3);
    }

    public void moveTo(JmolScriptEvaluator jmolScriptEvaluator, float f, P3 p3, V3 v3, float f2, M3 m3, float f3, float f4, float f5, float f6, P3 p32, float f7, float f8, float f9, float f10, float f11, float f12) {
        if (!this.haveDisplay) {
            f = 0.0f;
        }
        this.setTainted(true);
        this.transformManager.moveTo(jmolScriptEvaluator, f, p3, v3, f2, m3, f3, f4, f5, f6, p32, f7, f8, f9, f10, f11, f12);
    }

    public void moveUpdate(float f) {
        if (f > 0.0f) {
            this.requestRepaintAndWait("moveUpdate");
        } else if (f == 0.0f) {
            this.setSync();
        }
    }

    public String getMoveToText(float f) {
        return this.transformManager.getMoveToText(f, false);
    }

    public void navigateList(JmolScriptEvaluator jmolScriptEvaluator, javajs.util.List<Object[]> list) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.navigateList(jmolScriptEvaluator, list);
    }

    public void navigatePt(P3 p3) {
        this.transformManager.setNavigatePt(p3);
        this.setSync();
    }

    public void navigateAxis(V3 v3, float f) {
        this.transformManager.navigateAxis(v3, f);
        this.setSync();
    }

    public void navTranslatePercent(float f, float f2) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.navTranslatePercentOrTo(0.0f, f, f2);
        this.setSync();
    }

    public void setMouseEnabled(boolean bl) {
        this.mouseEnabled = bl;
    }

    @Override
    public void processMultitouchEvent(int n, int n2, int n3, int n4, P3 p3, long l) {
        this.actionManager.processMultitouchEvent(n, n2, n3, n4, p3, l);
    }

    void zoomBy(int n) {
        if (this.mouseEnabled) {
            this.transformManager.zoomBy(n);
        }
        this.refresh(2, this.statusManager.syncingMouse ? "Mouse: zoomBy " + n : "");
    }

    void zoomByFactor(float f, int n, int n2) {
        if (this.mouseEnabled) {
            this.transformManager.zoomByFactor(f, n, n2);
        }
        this.refresh(2, !this.statusManager.syncingMouse ? "" : "Mouse: zoomByFactor " + f + (n == Integer.MAX_VALUE ? "" : " " + n + " " + n2));
    }

    void rotateXYBy(float f, float f2) {
        if (this.mouseEnabled) {
            this.transformManager.rotateXYBy(f, f2, null);
        }
        this.refresh(2, this.statusManager.syncingMouse ? "Mouse: rotateXYBy " + f + " " + f2 : "");
    }

    public void spinXYBy(int n, int n2, float f) {
        if (this.mouseEnabled) {
            this.transformManager.spinXYBy(n, n2, f);
        }
        if (n == 0 && n2 == 0) {
            return;
        }
        this.refresh(2, this.statusManager.syncingMouse ? "Mouse: spinXYBy " + n + " " + n2 + " " + f : "");
    }

    public void rotateZBy(int n, int n2, int n3) {
        if (this.mouseEnabled) {
            this.transformManager.rotateZBy(n, n2, n3);
        }
        this.refresh(2, this.statusManager.syncingMouse ? "Mouse: rotateZBy " + n + (n2 == Integer.MAX_VALUE ? "" : " " + n2 + " " + n3) : "");
    }

    void rotateSelected(float f, float f2, BS bS) {
        if (this.isJmolDataFrame()) {
            return;
        }
        if (this.mouseEnabled) {
            this.transformManager.rotateXYBy(f, f2, this.setMovableBitSet(bS, false));
            this.refreshMeasures(true);
        }
        this.refresh(2, this.statusManager.syncingMouse ? "Mouse: rotateMolecule " + f + " " + f2 : "");
    }

    private BS setMovableBitSet(BS bS, boolean bl) {
        if (bS == null) {
            bS = this.getSelectionSet(false);
        }
        bS = BSUtil.copy(bS);
        BSUtil.andNot(bS, this.getMotionFixedAtoms());
        if (bl && !this.global.allowMoveAtoms) {
            bS = this.modelSet.getMoleculeBitSet(bS);
        }
        return bS;
    }

    public void translateXYBy(int n, int n2) {
        if (this.mouseEnabled) {
            this.transformManager.translateXYBy(n, n2);
        }
        this.refresh(2, this.statusManager.syncingMouse ? "Mouse: translateXYBy " + n + " " + n2 : "");
    }

    @Override
    public void rotateFront() {
        this.transformManager.rotateFront();
        this.refresh(1, "Viewer:rotateFront()");
    }

    @Override
    public void rotateX(float f) {
        this.transformManager.rotateX(f);
        this.refresh(1, "Viewer:rotateX()");
    }

    @Override
    public void rotateY(float f) {
        this.transformManager.rotateY(f);
        this.refresh(1, "Viewer:rotateY()");
    }

    @Override
    public void rotateZ(float f) {
        this.transformManager.rotateZ(f);
        this.refresh(1, "Viewer:rotateZ()");
    }

    @Override
    public void rotateXDeg(int n) {
        this.rotateX((float)n * ((float)Math.PI / 180));
    }

    @Override
    public void rotateYDeg(int n) {
        this.rotateY((float)n * ((float)Math.PI / 180));
    }

    public void translate(char c, float f, char c2, BS bS) {
        int n;
        int n2 = c2 == '\u0000' ? (int)f : (c2 == '%' ? this.transformManager.percentToPixels(c, f) : (n = this.transformManager.angstromsToPixels(f * (c2 == 'n' ? 10.0f : 1.0f))));
        if (bS != null) {
            if (n == 0) {
                return;
            }
            this.transformManager.setSelectedTranslation(bS, c, n);
        } else {
            switch (c) {
                case 'X': 
                case 'x': {
                    if (c2 == '\u0000') {
                        this.transformManager.translateToPercent('x', f);
                        break;
                    }
                    this.transformManager.translateXYBy(n, 0);
                    break;
                }
                case 'Y': 
                case 'y': {
                    if (c2 == '\u0000') {
                        this.transformManager.translateToPercent('y', f);
                        break;
                    }
                    this.transformManager.translateXYBy(0, n);
                    break;
                }
                case 'Z': 
                case 'z': {
                    if (c2 == '\u0000') {
                        this.transformManager.translateToPercent('z', f);
                        break;
                    }
                    this.transformManager.translateZBy(n);
                }
            }
        }
        this.refresh(1, "Viewer:translate()");
    }

    public float getTranslationXPercent() {
        return this.transformManager.getTranslationXPercent();
    }

    public float getTranslationYPercent() {
        return this.transformManager.getTranslationYPercent();
    }

    float getTranslationZPercent() {
        return this.transformManager.getTranslationZPercent();
    }

    public String getTranslationScript() {
        return this.transformManager.getTranslationScript();
    }

    public int getZShadeStart() {
        return this.transformManager.getZShadeStart();
    }

    public boolean isWindowCentered() {
        return this.transformManager.isWindowCentered();
    }

    @Override
    public int getZoomPercent() {
        return (int)this.getZoomSetting();
    }

    public float getZoomSetting() {
        return this.transformManager.getZoomSetting();
    }

    @Override
    public float getZoomPercentFloat() {
        return this.transformManager.getZoomPercentFloat();
    }

    public float getMaxZoomPercent() {
        return 200000.0f;
    }

    public void slabReset() {
        this.transformManager.slabReset();
    }

    public boolean getZoomEnabled() {
        return this.transformManager.zoomEnabled;
    }

    public boolean getSlabEnabled() {
        return this.transformManager.slabEnabled;
    }

    void slabByPixels(int n) {
        this.transformManager.slabByPercentagePoints(n);
        this.refresh(3, "slabByPixels");
    }

    void depthByPixels(int n) {
        this.transformManager.depthByPercentagePoints(n);
        this.refresh(3, "depthByPixels");
    }

    void slabDepthByPixels(int n) {
        this.transformManager.slabDepthByPercentagePoints(n);
        this.refresh(3, "slabDepthByPixels");
    }

    public void slabInternal(P4 p4, boolean bl) {
        this.transformManager.slabInternal(p4, bl);
    }

    public void slabToPercent(int n) {
        this.transformManager.slabToPercent(n);
    }

    public void depthToPercent(int n) {
        this.transformManager.depthToPercent(n);
    }

    public void setSlabDepthInternal(boolean bl) {
        this.transformManager.setSlabDepthInternal(bl);
    }

    public int zValueFromPercent(int n) {
        return this.transformManager.zValueFromPercent(n);
    }

    @Override
    public M4 getUnscaledTransformMatrix() {
        return this.transformManager.getUnscaledTransformMatrix();
    }

    public void finalizeTransformParameters() {
        this.transformManager.finalizeTransformParameters();
        this.gdata.setSlab(this.transformManager.slabValue);
        this.gdata.setDepth(this.transformManager.depthValue);
        this.gdata.setZShade(this.transformManager.zShadeEnabled, this.transformManager.zSlabValue, this.transformManager.zDepthValue, this.global.zShadePower);
    }

    public void rotatePoint(P3 p3, P3 p32) {
        this.transformManager.rotatePoint(p3, p32);
    }

    public P3i transformPt(P3 p3) {
        return this.transformManager.transformPoint(p3);
    }

    public P3i transformPtVib(P3 p3, Vibration vibration) {
        return this.transformManager.transformPointVib(p3, vibration);
    }

    public void transformPtScr(P3 p3, P3i p3i) {
        this.transformManager.transformPointScr(p3, p3i);
    }

    public void transformPtNoClip(P3 p3, P3 p32) {
        this.transformManager.transformPointNoClip(p3, p32);
    }

    public void transformPt3f(P3 p3, P3 p32) {
        this.transformManager.transformPoint2(p3, p32);
    }

    public void transformPoints(P3[] p3Array, P3i[] p3iArray) {
        this.transformManager.transformPoints(p3Array.length, p3Array, p3iArray);
    }

    public void transformVector(V3 v3, V3 v32) {
        this.transformManager.transformVector(v3, v32);
    }

    public void unTransformPoint(P3 p3, P3 p32) {
        this.transformManager.unTransformPoint(p3, p32);
    }

    public float getScalePixelsPerAngstrom(boolean bl) {
        return this.transformManager.scalePixelsPerAngstrom * (bl || !this.antialiasDisplay ? 1.0f : 0.5f);
    }

    public float scaleToScreen(int n, int n2) {
        return this.transformManager.scaleToScreen(n, n2);
    }

    public float unscaleToScreen(float f, float f2) {
        return this.transformManager.unscaleToScreen(f, f2);
    }

    public float scaleToPerspective(int n, float f) {
        return this.transformManager.scaleToPerspective(n, f);
    }

    public void setSpin(String string, int n) {
        if (!PT.isOneOf(string, "x;y;z;fps;X;Y;Z;FPS")) {
            return;
        }
        int n2 = "x;y;z;fps;X;Y;Z;FPS".indexOf(string);
        switch (n2) {
            case 0: {
                this.transformManager.setSpinXYZ(n, Float.NaN, Float.NaN);
                break;
            }
            case 2: {
                this.transformManager.setSpinXYZ(Float.NaN, n, Float.NaN);
                break;
            }
            case 4: {
                this.transformManager.setSpinXYZ(Float.NaN, Float.NaN, n);
                break;
            }
            default: {
                this.transformManager.setSpinFps(n);
                break;
            }
            case 10: {
                this.transformManager.setNavXYZ(n, Float.NaN, Float.NaN);
                break;
            }
            case 12: {
                this.transformManager.setNavXYZ(Float.NaN, n, Float.NaN);
                break;
            }
            case 14: {
                this.transformManager.setNavXYZ(Float.NaN, Float.NaN, n);
                break;
            }
            case 16: {
                this.transformManager.setNavFps(n);
            }
        }
        this.global.setI((n2 < 10 ? "spin" : "nav") + string, n);
    }

    public String getSpinState() {
        return this.getStateCreator().getSpinState(false);
    }

    public void setSpinOn(boolean bl) {
        if (bl) {
            this.transformManager.setSpinOn();
        } else {
            this.transformManager.setSpinOff();
        }
    }

    public boolean getSpinOn() {
        return this.transformManager.getSpinOn();
    }

    public void setNavOn(boolean bl) {
        this.transformManager.setNavOn(bl);
    }

    public boolean getNavOn() {
        return this.transformManager.getNavOn();
    }

    public void setNavXYZ(float f, float f2, float f3) {
        this.transformManager.setNavXYZ((int)f, (int)f2, (int)f3);
    }

    public String getOrientationText(int n, String string) {
        switch (n) {
            case 135270418: 
            case 1073741863: 
            case 1112541205: 
            case 1112541206: 
            case 1112541207: 
            case 1313866249: {
                return this.modelSet.getBoundBoxOrientation(n, this.getSelectionSet(false));
            }
            case 1073742035: {
                return this.stateManager.getSavedOrientationText(string);
            }
        }
        return this.transformManager.getOrientationText(n);
    }

    Map<String, Object> getOrientationInfo() {
        return this.transformManager.getOrientationInfo();
    }

    M3 getMatrixRotate() {
        return this.transformManager.getMatrixRotate();
    }

    public void getAxisAngle(A4 a4) {
        this.transformManager.getAxisAngle(a4);
    }

    public String getTransformText() {
        return this.transformManager.getTransformText();
    }

    public void getRotation(M3 m3) {
        this.transformManager.getRotation(m3);
    }

    public float[] getCurrentColorRange() {
        return this.colorManager.getPropertyColorRange();
    }

    private void setDefaultColors(boolean bl) {
        this.colorManager.setDefaultColors(bl);
        this.global.setB("colorRasmol", bl);
        this.global.setS("defaultColorScheme", bl ? "rasmol" : "jmol");
    }

    public int getColorArgbOrGray(short s) {
        return this.gdata.getColorArgbOrGray(s);
    }

    public void setRubberbandArgb(int n) {
        this.colorManager.setRubberbandArgb(n);
    }

    public short getColixRubberband() {
        return this.colorManager.colixRubberband;
    }

    public void setElementArgb(int n, int n2) {
        this.global.setS("=color " + Elements.elementNameFromNumber(n), Escape.escapeColor(n2));
        this.colorManager.setElementArgb(n, n2);
    }

    @Override
    public void setVectorScale(float f) {
        this.global.setF("vectorScale", f);
        this.global.vectorScale = f;
    }

    public boolean isVibrationOn() {
        return this.transformManager.vibrationOn;
    }

    @Override
    public void setVibrationScale(float f) {
        this.transformManager.setVibrationScale(f);
        this.global.vibrationScale = f;
        this.global.setF("vibrationScale", f);
    }

    public void setVibrationOff() {
        this.transformManager.setVibrationPeriod(0.0f);
    }

    @Override
    public void setVibrationPeriod(float f) {
        this.transformManager.setVibrationPeriod(f);
        this.global.vibrationPeriod = f = Math.abs(f);
        this.global.setF("vibrationPeriod", f);
    }

    void setObjectColor(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return;
        }
        this.setObjectArgb(string, CU.getArgbFromString(string2));
    }

    public void setObjectVisibility(String string, boolean bl) {
        int n = StateManager.getObjectIdFromName(string);
        if (n >= 0) {
            this.setShapeProperty(n, "display", bl ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public void setObjectArgb(String string, int n) {
        int n2 = StateManager.getObjectIdFromName(string);
        if (n2 < 0) {
            if (string.equalsIgnoreCase("axes")) {
                this.setObjectArgb("axis1", n);
                this.setObjectArgb("axis2", n);
                this.setObjectArgb("axis3", n);
            }
            return;
        }
        this.global.objColors[n2] = n;
        switch (n2) {
            case 0: {
                this.gdata.setBackgroundArgb(n);
                this.colorManager.setColixBackgroundContrast(n);
            }
        }
        this.global.setS(string + "Color", Escape.escapeColor(n));
    }

    public void setBackgroundImage(String string, Object object) {
        this.global.backgroundImageFileName = string;
        this.gdata.setBackgroundImage(object);
    }

    int getObjectArgb(int n) {
        return this.global.objColors[n];
    }

    public short getObjectColix(int n) {
        int n2 = this.getObjectArgb(n);
        if (n2 == 0) {
            return this.getColixBackgroundContrast();
        }
        return C.getColix(n2);
    }

    public String getFontState(String string, Font font) {
        return this.getStateCreator().getFontState(string, font);
    }

    @Override
    public void setColorBackground(String string) {
        this.setObjectColor("background", string);
    }

    @Override
    public int getBackgroundArgb() {
        return this.getObjectArgb(0);
    }

    public void setObjectMad(int n, String string, int n2) {
        int n3 = StateManager.getObjectIdFromName(string.equalsIgnoreCase("axes") ? "axis" : string);
        if (n3 < 0) {
            return;
        }
        if (n2 == -2 || n2 == -4) {
            int n4 = n2 + 3;
            n2 = this.getObjectMad(n3);
            if (n2 == 0) {
                n2 = n4;
            }
        }
        this.global.setB("show" + string, n2 != 0);
        boolean bl = this.global.objStateOn[n3] = n2 != 0;
        if (n2 == 0) {
            return;
        }
        this.global.objMad[n3] = n2;
        this.setShapeSize(n, n2, null);
    }

    public int getObjectMad(int n) {
        return this.global.objStateOn[n] ? this.global.objMad[n] : 0;
    }

    public void setPropertyColorScheme(String string, boolean bl, boolean bl2) {
        this.global.propertyColorScheme = string;
        if (string.startsWith("translucent ")) {
            bl = true;
            string = string.substring(12).trim();
        }
        this.colorManager.setPropertyColorScheme(string, bl, bl2);
    }

    public String getPropertyColorScheme() {
        return this.global.propertyColorScheme;
    }

    public short getColixBackgroundContrast() {
        return this.colorManager.colixBackgroundContrast;
    }

    public String getSpecularState() {
        return this.getStateCreator().getSpecularState();
    }

    public short getColixAtomPalette(Atom atom, byte by) {
        return this.colorManager.getColixAtomPalette(atom, by);
    }

    public short getColixBondPalette(Bond bond, int n) {
        return this.colorManager.getColixBondPalette(bond, n);
    }

    public String getColorSchemeList(String string) {
        return this.colorManager.getColorSchemeList(string);
    }

    public void setUserScale(int[] nArray) {
        this.colorManager.setUserScale(nArray);
    }

    public short getColixForPropertyValue(float f) {
        return this.colorManager.getColixForPropertyValue(f);
    }

    public P3 getColorPointForPropertyValue(float f) {
        return CU.colorPtFromInt2(this.gdata.getColorArgbOrGray(this.colorManager.getColixForPropertyValue(f)));
    }

    public void select(BS bS, boolean bl, int n, boolean bl2) {
        if (bl) {
            bS = this.getUndeletedGroupAtomBits(bS);
        }
        this.selectionManager.select(bS, n, bl2);
        this.shapeManager.setShapeSizeBs(1, Integer.MAX_VALUE, null, null);
    }

    @Override
    public void setSelectionSet(BS bS) {
        this.select(bS, false, 0, true);
    }

    public void selectBonds(BS bS) {
        this.shapeManager.setShapeSizeBs(1, Integer.MAX_VALUE, null, bS);
    }

    public void displayAtoms(BS bS, boolean bl, boolean bl2, int n, boolean bl3) {
        if (bl2) {
            bS = this.getUndeletedGroupAtomBits(bS);
        }
        if (bl) {
            this.selectionManager.display(this.modelSet, bS, n, bl3);
        } else {
            this.selectionManager.hide(this.modelSet, bS, n, bl3);
        }
    }

    private BS getUndeletedGroupAtomBits(BS bS) {
        bS = this.getAtomBits(1087373318, bS);
        BSUtil.andNot(bS, this.selectionManager.getDeletedAtoms());
        return bS;
    }

    public BS getHiddenSet() {
        return this.selectionManager.getHiddenSet();
    }

    public boolean isSelected(int n) {
        return this.selectionManager.isSelected(n);
    }

    boolean isInSelectionSubset(int n) {
        return this.selectionManager.isInSelectionSubset(n);
    }

    void reportSelection(String string) {
        if (this.modelSet.getSelectionHaloEnabled()) {
            this.setTainted(true);
        }
        if (this.isScriptQueued() || this.global.debugScript) {
            this.scriptStatus(string);
        }
    }

    public P3 getAtomSetCenter(BS bS) {
        return this.modelSet.getAtomSetCenter(bS);
    }

    private void clearAtomSets() {
        this.setSelectionSubset(null);
        this.definedAtomSets.clear();
    }

    public BS getDefinedAtomSet(String string) {
        Object object = this.definedAtomSets.get(string.toLowerCase());
        return object instanceof BS ? (BS)object : new BS();
    }

    @Override
    public void selectAll() {
        this.selectionManager.selectAll(false);
    }

    public void setNoneSelected(boolean bl) {
        this.noneSelected = bl;
    }

    public Boolean getNoneSelected() {
        return this.noneSelected ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public void clearSelection() {
        this.selectionManager.clearSelection(true);
        this.global.setB("hideNotSelected", false);
    }

    public void setSelectionSubset(BS bS) {
        this.selectionManager.setSelectionSubset(bS);
    }

    public BS getSelectionSubset() {
        return this.selectionManager.getSelectionSubset();
    }

    public void invertSelection() {
        this.selectionManager.invertSelection();
    }

    public BS getSelectionSet(boolean bl) {
        return this.selectionManager.getSelectionSet(bl);
    }

    public void setSelectedAtom(int n, boolean bl) {
        this.selectionManager.setSelectedAtom(n, bl);
    }

    public boolean isAtomSelected(int n) {
        return this.selectionManager.isAtomSelected(n);
    }

    @Override
    public int getSelectionCount() {
        return this.selectionManager.getSelectionCount();
    }

    public void setFormalCharges(int n) {
        this.modelSet.setFormalCharges(this.getSelectionSet(false), n);
    }

    @Override
    public void addSelectionListener(JmolSelectionListener jmolSelectionListener) {
        this.selectionManager.addListener(jmolSelectionListener);
    }

    @Override
    public void removeSelectionListener(JmolSelectionListener jmolSelectionListener) {
        this.selectionManager.addListener(jmolSelectionListener);
    }

    BS getAtomBitSetEval(JmolScriptEvaluator jmolScriptEvaluator, Object object) {
        if (!this.allowScripting) {
            System.out.println("viewer.getAtomBitSetEval not allowed");
            return new BS();
        }
        return this.getScriptManager().getAtomBitSetEval(jmolScriptEvaluator, object);
    }

    @Override
    public void setModeMouse(int n) {
        if (n == -1) {
            if (this.mouse != null) {
                this.disposeMouse();
            }
            this.clearScriptQueue();
            this.clearThreads();
            this.haltScriptExecution();
            if (this.scriptManager != null) {
                this.scriptManager.clear(true);
            }
            this.gdata.destroy();
            if (this.jmolpopup != null) {
                this.jmolpopup.jpiDispose();
            }
            if (this.modelkitPopup != null) {
                this.modelkitPopup.jpiDispose();
            }
            try {
                if (this.appConsole != null) {
                    this.appConsole.dispose();
                    this.appConsole = null;
                }
                if (this.scriptEditor != null) {
                    this.scriptEditor.dispose();
                    this.scriptEditor = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Rectangle getRubberBandSelection() {
        return this.haveDisplay ? this.actionManager.getRubberBand() : null;
    }

    public boolean isBound(int n, int n2) {
        return this.haveDisplay && this.actionManager.isBound(n, n2);
    }

    public int getCursorX() {
        return this.haveDisplay ? this.actionManager.getCurrentX() : 0;
    }

    public int getCursorY() {
        return this.haveDisplay ? this.actionManager.getCurrentY() : 0;
    }

    String getDefaultDirectory() {
        return this.global.defaultDirectory;
    }

    public String getLocalUrl(String string) {
        return this.apiPlatform.getLocalUrl(string);
    }

    @Override
    public BufferedInputStream getBufferedInputStream(String string) {
        return this.fileManager.getBufferedInputStream(string);
    }

    public Object getBufferedReaderOrErrorMessageFromName(String string, String[] stringArray, boolean bl) {
        return this.fileManager.getBufferedReaderOrErrorMessageFromName(string, stringArray, bl, true);
    }

    private Map<String, Object> setLoadParameters(Map<String, Object> map, boolean bl) {
        String string;
        if (map == null) {
            map = new Hashtable<String, Object>();
        }
        map.put("viewer", this);
        if (this.global.atomTypes.length() > 0) {
            map.put("atomTypes", this.global.atomTypes);
        }
        if (!map.containsKey("lattice")) {
            map.put("lattice", this.global.ptDefaultLattice);
        }
        if (this.global.applySymmetryToBonds) {
            map.put("applySymmetryToBonds", Boolean.TRUE);
        }
        if (this.global.pdbGetHeader) {
            map.put("getHeader", Boolean.TRUE);
        }
        if (this.global.pdbSequential) {
            map.put("isSequential", Boolean.TRUE);
        }
        map.put("stateScriptVersionInt", this.stateScriptVersionInt);
        if (!map.containsKey("filter") && (string = this.getDefaultLoadFilter()).length() > 0) {
            map.put("filter", string);
        }
        boolean bl2 = bl && !this.global.appendNew && this.getAtomCount() > 0;
        map.put("baseAtomIndex", bl ? this.getAtomCount() : 0);
        map.put("baseModelIndex", this.getAtomCount() == 0 ? 0 : this.getModelCount() + (bl2 ? -1 : 0));
        if (bl2) {
            map.put("merging", Boolean.TRUE);
        }
        return map;
    }

    @Override
    public void openFileAsyncSpecial(String string, int n) {
        this.getScriptManager().openFileAsync(string, n);
    }

    @Override
    public String openFile(String string) {
        this.zap(true, true, false);
        return this.loadModelFromFileRepaint(null, string, null, null);
    }

    @Override
    public String openFiles(String[] stringArray) {
        this.zap(true, true, false);
        return this.loadModelFromFileRepaint(null, null, stringArray, null);
    }

    @Override
    public String openReader(String string, String string2, Reader reader) {
        this.zap(true, true, false);
        return this.loadModelFromFileRepaint(string, string2, null, reader);
    }

    @Override
    public String openDOM(Object object) {
        this.zap(true, true, false);
        return this.loadModelFromFileRepaint("?", "?", null, object);
    }

    private String loadModelFromFileRepaint(String string, String string2, String[] stringArray, Object object) {
        String string3 = this.loadModelFromFile(string, string2, stringArray, object, false, null, null, 0);
        this.refresh(1, "loadModelFromFileRepaint");
        return string3;
    }

    public String loadModelFromFile(String string, String string2, String[] stringArray, Object object, boolean bl, Map<String, Object> map, SB sB, int n) {
        Object object2;
        if (map == null) {
            map = this.setLoadParameters(null, bl);
        }
        String[] stringArray2 = this.fileManager.getFileInfo();
        if (stringArray != null) {
            if (sB == null) {
                sB = new SB().append("load files");
                for (int i = 0; i < stringArray.length; ++i) {
                    sB.append(" /*file*/$FILENAME" + (i + 1) + "$");
                }
            }
            long l = System.currentTimeMillis();
            object2 = this.fileManager.createAtomSetCollectionFromFiles(stringArray, this.setLoadParameters(map, bl), bl);
            long l2 = System.currentTimeMillis() - l;
            Logger.info("openFiles(" + stringArray.length + ") " + l2 + " ms");
            stringArray = (String[])map.get("fullPathNames");
            String[] stringArray3 = (String[])map.get("fileTypes");
            String string3 = sB.toString();
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = stringArray[i];
                if (stringArray3 != null && stringArray3[i] != null) {
                    string4 = stringArray3[i] + "::" + string4;
                }
                string3 = PT.simpleReplace(string3, "$FILENAME" + (i + 1) + "$", Escape.eS(string4.replace('\\', '/')));
            }
            sB = new SB().append(string3);
        } else if (object == null) {
            if (sB == null) {
                sB = new SB().append("load /*file*/$FILENAME$");
            }
            object2 = this.openFileFull(string2, bl, map, sB);
        } else {
            object2 = object instanceof Reader ? this.fileManager.createAtomSetCollectionFromReader(string, string2, object, map) : this.fileManager.createAtomSetCollectionFromDOM(object, map);
        }
        if (n != 0) {
            this.fileManager.setFileInfo(stringArray2);
            return this.loadAtomDataAndReturnError(object2, n);
        }
        if (map.containsKey("isData")) {
            return (String)object2;
        }
        if (sB != null) {
            String string5 = (String)map.get("fullPathName");
            if (string5 == null) {
                string5 = "";
            }
            if (map.containsKey("loadScript")) {
                sB = (SB)map.get("loadScript");
            }
            sB = new SB().append(PT.simpleReplace(sB.toString(), "$FILENAME$", Escape.eS(string5.replace('\\', '/'))));
            map.put("loadScript", sB);
        }
        return this.createModelSetAndReturnError(object2, bl, sB, map);
    }

    public void setLigandModel(String string, String string2) {
        if (this.ligandModels == null) {
            this.ligandModels = new Hashtable<String, Object>();
        }
        this.ligandModels.put(string, string2);
    }

    public Object getLigandModel(String string, String string2, String string3, String string4) {
        String string5;
        Object object;
        if (string == null) {
            if (this.ligandModelSet != null) {
                Iterator<Map.Entry<String, Object>> iterator = this.ligandModels.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Object> entry = iterator.next();
                    if (!(entry.getValue() instanceof Boolean)) continue;
                    iterator.remove();
                }
            }
            return null;
        }
        boolean bl = string2.equals("ligand_");
        if (bl) {
            string = string.toUpperCase();
        }
        if (this.ligandModelSet == null) {
            this.ligandModelSet = new Hashtable<String, Boolean>();
        }
        this.ligandModelSet.put(string, Boolean.TRUE);
        if (this.ligandModels == null) {
            this.ligandModels = new Hashtable<String, Object>();
        }
        Object object2 = this.ligandModels.get(string);
        String string6 = null;
        if (object2 instanceof Boolean) {
            return null;
        }
        if (object2 == null) {
            object2 = this.ligandModels.get(string + string3);
        }
        boolean bl2 = false;
        if (object2 == null) {
            if (bl) {
                string6 = (String)this.setLoadFormat("#" + string, '#', false);
                if (string6.length() == 0) {
                    return null;
                }
                this.scriptEcho("fetching " + string6);
                object = this.getFileAsString(string6);
            } else {
                int n;
                object = this.getFileAsString(string2);
                int n2 = n = string4 == null ? -1 : ((String)object).indexOf(string4);
                if (n >= 0) {
                    object = ((String)object).substring(0, n);
                }
            }
            bl2 = ((String)object).indexOf("java.") == 0;
            object2 = object;
            if (!bl2) {
                this.ligandModels.put(string + string3, object2);
            }
        }
        if (!bl) {
            return object2;
        }
        if (!bl2 && object2 instanceof String && (string5 = (String)object2).length() != 0) {
            object = new Hashtable();
            object.put("modelOnly", Boolean.TRUE);
            object2 = this.getModelAdapter().getAtomSetCollectionReader("ligand", null, JmolBinary.getBR(string5), (Map<String, Object>)object);
            bl2 = object2 instanceof String;
            if (!bl2) {
                object2 = this.getModelAdapter().getAtomSetCollection(object2);
                bl2 = object2 instanceof String;
                if (string6 != null && !bl2) {
                    this.scriptEcho((String)this.getModelAdapter().getAtomSetCollectionAuxiliaryInfo(object2).get("modelLoadNote"));
                }
            }
        }
        if (bl2) {
            this.scriptEcho(object2.toString());
            this.ligandModels.put(string, Boolean.FALSE);
            return null;
        }
        return object2;
    }

    private Object openFileFull(String string, boolean bl, Map<String, Object> map, SB sB) {
        Object object;
        if (string == null) {
            return null;
        }
        if (string.indexOf("[]") >= 0) {
            return null;
        }
        String string2 = "openFile(" + string + ")";
        Logger.startTimer(string2);
        map = this.setLoadParameters(map, bl);
        boolean bl2 = string.startsWith("@");
        boolean bl3 = map.containsKey("fileData");
        if (string.indexOf(36) == 0) {
            map.put("smilesString", string.substring(1));
        }
        boolean bl4 = string.equalsIgnoreCase("string") || string.equals("Jmol Model Kit");
        String string3 = null;
        if (bl3) {
            string3 = (String)map.get("fileData");
            if (map.containsKey("isData")) {
                return this.loadInlineScript(string3, '\u0000', bl, map);
            }
        } else if (bl4) {
            string3 = this.modelSet.getInlineData(-1);
            if (string3 == null) {
                if (this.global.modelKitMode) {
                    string3 = "5\n\nC 0 0 0\nH .63 .63 .63\nH -.63 -.63 .63\nH -.63 .63 -.63\nH .63 -.63 -.63";
                } else {
                    return "cannot find string data";
                }
            }
            if (sB != null) {
                sB = new SB().append(PT.simpleReplace(sB.toString(), "$FILENAME$", "data \"model inline\"\n" + string3 + "end \"model inline\""));
                map.put("loadScript", sB);
            }
        }
        if (string3 != null) {
            if (!bl) {
                this.zap(true, false, false);
            }
            if (!(bl2 || bl3 && !bl4)) {
                this.getStateCreator().getInlineData(sB, string3, bl, this.getDefaultLoadFilter());
            }
            object = this.fileManager.createAtomSetCollectionFromString(string3, map, bl);
        } else {
            object = this.fileManager.createAtomSetCollectionFromFile(string, map, bl);
        }
        Logger.checkTimer(string2, false);
        return object;
    }

    @Override
    public String openStringInline(String string) {
        String string2 = this.openStringInlineParamsAppend(string, null, false);
        this.refresh(1, "openStringInline");
        return string2;
    }

    @Override
    public String loadInline(String string) {
        return this.loadInlineScriptRepaint(string, this.global.inlineNewlineChar, false);
    }

    @Override
    public String loadInline(String string, char c) {
        return this.loadInlineScriptRepaint(string, c, false);
    }

    @Override
    public String loadInlineAppend(String string, boolean bl) {
        return this.loadInlineScriptRepaint(string, '\u0000', bl);
    }

    private String loadInlineScriptRepaint(String string, char c, boolean bl) {
        String string2 = this.loadInlineScript(string, c, bl, null);
        this.refresh(1, "loadInlineScript");
        return string2;
    }

    @Override
    public String loadInline(String[] stringArray) {
        return this.loadInline(stringArray, false);
    }

    @Override
    public String loadInline(String[] stringArray, boolean bl) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        String string = this.openStringsInlineParamsAppend(stringArray, null, bl);
        this.refresh(1, "loadInline String[]");
        return string;
    }

    @Override
    public String loadInline(List<Object> list, boolean bl) {
        if (list == null || list.size() == 0) {
            return null;
        }
        if (!bl) {
            this.zap(true, false, false);
        }
        javajs.util.List<Object> list2 = new javajs.util.List<Object>();
        for (int i = 0; i < list.size(); ++i) {
            list2.addLast(list.get(i));
        }
        Object object = this.fileManager.createAtomSeCollectionFromArrayData(list2, this.setLoadParameters(null, bl), bl);
        String string = this.createModelSetAndReturnError(object, bl, null, null);
        this.refresh(1, "loadInline");
        return string;
    }

    private String loadInlineScript(String string, char c, boolean bl, Map<String, Object> map) {
        int n;
        String string2;
        if (string == null || string.length() == 0) {
            return null;
        }
        string = Viewer.fixInlineString(string, c);
        if (c != '\u0000') {
            Logger.info("loading model inline, " + string.length() + " bytes, with newLine character " + c + " isAppend=" + bl);
        }
        if (Logger.debugging) {
            Logger.debug(string);
        }
        if ((string2 = this.getDataSeparator()) != null && string2 != "" && (n = string.indexOf(string2)) >= 0 && string.indexOf("# Jmol state") < 0) {
            int n2 = 2;
            while ((n = string.indexOf(string2, n + 1)) >= 0) {
                ++n2;
            }
            String[] stringArray = new String[n2];
            int n3 = 0;
            int n4 = 0;
            for (n = 0; n < n2; ++n) {
                n3 = string.indexOf(string2, n4);
                if (n3 < 0) {
                    n3 = string.length();
                }
                stringArray[n] = string.substring(n4, n3);
                n4 = n3 + string2.length();
            }
            return this.openStringsInlineParamsAppend(stringArray, map, bl);
        }
        return this.openStringInlineParamsAppend(string, map, bl);
    }

    public static String fixInlineString(String string, char c) {
        if (string.indexOf("\\/n") >= 0) {
            string = PT.simpleReplace(string, "\n", "");
            string = PT.simpleReplace(string, "\\/n", "\n");
            c = '\u0000';
        }
        if (c != '\u0000' && c != '\n') {
            int n;
            boolean bl = string.indexOf(10) >= 0;
            int n2 = string.length();
            for (n = 0; n < n2 && string.charAt(n) == ' '; ++n) {
            }
            if (n < n2 && string.charAt(n) == c) {
                string = string.substring(n + 1);
            }
            string = bl ? PT.simpleReplace(string, "" + c, "") : string.replace(c, '\n');
        }
        return string;
    }

    public String openStringInlineParamsAppend(String string, Map<String, Object> map, boolean bl) {
        BufferedReader bufferedReader = JmolBinary.getBR(string);
        String string2 = this.getModelAdapter().getFileTypeName(bufferedReader);
        if (string2 == null) {
            return "unknown file type";
        }
        if (string2.equals("spt")) {
            return "cannot open script inline";
        }
        map = this.setLoadParameters(map, bl);
        SB sB = (SB)map.get("loadScript");
        boolean bl2 = map.containsKey("isData");
        if (sB == null) {
            sB = new SB();
        }
        if (!bl) {
            this.zap(true, false, false);
        }
        if (!bl2) {
            this.getStateCreator().getInlineData(sB, string, bl, this.getDefaultLoadFilter());
        }
        Object object = this.fileManager.createAtomSetCollectionFromString(string, map, bl);
        return this.createModelSetAndReturnError(object, bl, sB, null);
    }

    private String openStringsInlineParamsAppend(String[] stringArray, Map<String, Object> map, boolean bl) {
        SB sB = new SB();
        if (!bl) {
            this.zap(true, false, false);
        }
        Object object = this.fileManager.createAtomSeCollectionFromStrings(stringArray, sB, this.setLoadParameters(map, bl), bl);
        return this.createModelSetAndReturnError(object, bl, sB, null);
    }

    public char getInlineChar() {
        return this.global.inlineNewlineChar;
    }

    String getDataSeparator() {
        return (String)this.global.getParameter("dataseparator");
    }

    private String createModelSetAndReturnError(Object object, boolean bl, SB sB, Map<String, Object> map) {
        String string;
        String string2 = this.fileManager.getFullPathName();
        String string3 = this.fileManager.getFileName();
        if (sB == null) {
            this.setBooleanProperty("preserveState", false);
            sB = new SB().append("load \"???\"");
        }
        if (object instanceof String) {
            String string4 = (String)object;
            this.setFileLoadStatus(EnumFileStatus.NOT_LOADED, string2, null, null, string4, null);
            if (this.displayLoadErrors && !bl && !string4.equals("#CANCELED#")) {
                this.zapMsg(string4);
            }
            return string4;
        }
        if (bl) {
            this.clearAtomSets();
        } else if (this.global.modelKitMode && !string3.equals("Jmol Model Kit")) {
            this.setModelKitMode(false);
        }
        this.setFileLoadStatus(EnumFileStatus.CREATING_MODELSET, string2, string3, null, null, null);
        this.pushHoldRepaintWhy("createModelSet");
        this.setErrorMessage(null, null);
        try {
            BS bS = new BS();
            this.modelManager.createModelSet(string2, string3, sB, object, bS, bl);
            if (bS.cardinality() > 0) {
                String string5 = (String)this.modelSet.getModelSetAuxiliaryInfoValue("jmolscript");
                if (this.modelSet.getModelSetAuxiliaryInfoBoolean("doMinimize")) {
                    this.minimize(Integer.MAX_VALUE, 0.0f, bS, null, 0.0f, true, true, true, true);
                } else {
                    this.addHydrogens(bS, false, true);
                }
                if (string5 != null) {
                    this.modelSet.getModelSetAuxiliaryInfo().put("jmolscript", string5);
                }
            }
            this.initializeModel(bl);
        }
        catch (Error error) {
            this.handleError(error, true);
            string = this.getShapeErrorState();
            string = "ERROR creating model: " + error + (string.length() == 0 ? "" : "|" + string);
            this.zapMsg(string);
            this.setErrorMessage(string, null);
        }
        this.popHoldRepaint("createModelSet \u0001## REPAINT_IGNORE ##");
        string = this.getErrorMessage();
        this.setFileLoadStatus(EnumFileStatus.CREATED, string2, string3, this.getModelSetName(), string, map == null ? null : (Boolean)map.get("async"));
        if (bl) {
            this.selectAll();
            this.setTainted(true);
            this.axesAreTainted = true;
        }
        object = null;
        System.gc();
        return string;
    }

    private String loadAtomDataAndReturnError(Object object, int n) {
        if (object instanceof String) {
            return (String)object;
        }
        this.setErrorMessage(null, null);
        try {
            this.modelManager.createAtomDataSet(object, n);
            switch (n) {
                case 4166: {
                    this.setStatusFrameChanged(true, true);
                    break;
                }
                case 1649412120: {
                    this.shapeManager.deleteVdwDependentShapes(null);
                }
            }
        }
        catch (Error error) {
            this.handleError(error, true);
            String string = this.getShapeErrorState();
            string = "ERROR adding atom data: " + error + (string.length() == 0 ? "" : "|" + string);
            this.zapMsg(string);
            this.setErrorMessage(string, null);
            this.setParallel(false);
        }
        return this.getErrorMessage();
    }

    @Override
    public String getEmbeddedFileState(String string) {
        return this.fileManager.getEmbeddedFileState(string);
    }

    @Override
    public Object getFileAsBytes(String string, OC oC) {
        return this.fileManager.getFileAsBytes(string, oC, true);
    }

    public String getCurrentFileAsString() {
        String string = this.getFullPathName();
        if (string.equals("string") || string.equals("Jmol Model Kit")) {
            return this.modelSet.getInlineData(this.getCurrentModelIndex());
        }
        if (string.indexOf("[]") >= 0) {
            return string;
        }
        if (string == "JSNode") {
            return "<DOM NODE>";
        }
        String string2 = this.modelManager.getModelSetPathName();
        if (string2 == null) {
            return null;
        }
        return this.getFileAsString4(string2, -1, true, false, false);
    }

    public String getFullPathName() {
        return this.fileManager.getFullPathName();
    }

    public String getFileName() {
        return this.fileManager.getFileName();
    }

    public String[] getFullPathNameOrError(String string) {
        return this.fileManager.getFullPathNameOrError(string);
    }

    @Override
    public String getFileAsString(String string) {
        return this.getFileAsString4(string, -1, false, false, false);
    }

    public String getFileAsString4(String string, int n, boolean bl, boolean bl2, boolean bl3) {
        if (string == null) {
            return this.getCurrentFileAsString();
        }
        String[] stringArray = new String[2];
        stringArray[0] = string;
        this.fileManager.getFileDataOrErrorAsString(stringArray, n, bl, bl2, bl3);
        return stringArray[1];
    }

    public boolean getFileAsStringBin(String[] stringArray) {
        return this.fileManager.getFileDataOrErrorAsString(stringArray, -1, false, true, false);
    }

    public String getFilePath(String string, boolean bl) {
        return this.fileManager.getFilePath(string, false, bl);
    }

    public String[] getFileInfo() {
        return this.fileManager.getFileInfo();
    }

    public void setFileInfo(String[] stringArray) {
        this.fileManager.setFileInfo(stringArray);
    }

    public void autoCalculate(int n) {
        switch (n) {
            case 1112539151: {
                this.modelSet.getSurfaceDistanceMax();
                break;
            }
            case 1112539150: {
                this.modelSet.calculateStraightness();
            }
        }
    }

    int getSurfaceDistanceMax() {
        return this.modelSet.getSurfaceDistanceMax();
    }

    public void calculateStraightness() {
        this.modelSet.setHaveStraightness(false);
        this.modelSet.calculateStraightness();
    }

    public P3[] calculateSurface(BS bS, float f) {
        if (bS == null) {
            bS = this.getSelectionSet(false);
        }
        if (f == Float.MAX_VALUE || f == -1.0f) {
            this.addStateScriptRet("calculate surfaceDistance " + (f == Float.MAX_VALUE ? "FROM" : "WITHIN"), null, bS, null, "", false, true);
        }
        return this.modelSet.calculateSurface(bS, f);
    }

    public Map<EnumStructure, float[]> getStructureList() {
        return this.global.getStructureList();
    }

    public void setStructureList(float[] fArray, EnumStructure enumStructure) {
        this.global.setStructureList(fArray, enumStructure);
        this.modelSet.setStructureList(this.getStructureList());
    }

    public String getDefaultStructure(BS bS, BS bS2) {
        if (bS == null) {
            bS = this.getSelectionSet(false);
        }
        return this.modelSet.getDefaultStructure(bS, bS2);
    }

    public String calculateStructures(BS bS, boolean bl, boolean bl2) {
        if (bS == null) {
            bS = this.getSelectionSet(false);
        }
        return this.modelSet.calculateStructures(bS, bl, this.global.dsspCalcHydrogen, bl2);
    }

    @Override
    public AtomIndexIterator getSelectedAtomIterator(BS bS, boolean bl, boolean bl2, boolean bl3) {
        return this.modelSet.getSelectedAtomIterator(bS, bl, bl2, false, bl3);
    }

    @Override
    public void setIteratorForAtom(AtomIndexIterator atomIndexIterator, int n, float f) {
        this.modelSet.setIteratorForAtom(atomIndexIterator, -1, n, f, null);
    }

    @Override
    public void setIteratorForPoint(AtomIndexIterator atomIndexIterator, int n, P3 p3, float f) {
        this.modelSet.setIteratorForPoint(atomIndexIterator, n, p3, f);
    }

    @Override
    public void fillAtomData(AtomData atomData, int n) {
        atomData.programInfo = "Jmol Version " + Viewer.getJmolVersion();
        atomData.fileName = this.getFileName();
        this.modelSet.fillAtomData(atomData, n);
    }

    public StateScript addStateScript(String string, boolean bl, boolean bl2) {
        return this.addStateScriptRet(string, null, null, null, null, bl, bl2);
    }

    public StateScript addStateScriptRet(String string, BS bS, BS bS2, BS bS3, String string2, boolean bl, boolean bl2) {
        return this.modelSet.addStateScript(string, bS, bS2, bS3, string2, bl, bl2);
    }

    public boolean getEchoStateActive() {
        return this.modelSet.getEchoStateActive();
    }

    public void setEchoStateActive(boolean bl) {
        this.modelSet.setEchoStateActive(bl);
    }

    private void clearModelDependentObjects() {
        this.setFrameOffsets(null);
        this.stopMinimization();
        this.minimizer = null;
        if (this.smilesMatcher != null) {
            this.smilesMatcher = null;
        }
        if (this.symmetry != null) {
            this.symmetry = null;
        }
    }

    public void zap(boolean bl, boolean bl2, boolean bl3) {
        this.clearThreads();
        if (this.modelSet != null) {
            this.ligandModelSet = null;
            this.clearModelDependentObjects();
            this.fileManager.clear();
            this.clearRepaintManager(-1);
            this.animationManager.clear();
            this.transformManager.clear();
            this.selectionManager.clear();
            this.clearAllMeasurements();
            this.clearMinimization();
            this.gdata.clear();
            this.modelManager.zap();
            if (this.scriptManager != null) {
                this.scriptManager.clear(false);
            }
            if (this.nmrCalculation != null) {
                this.getNMRCalculation().setChemicalShiftReference(null, 0.0f);
            }
            if (this.haveDisplay) {
                this.mouse.clear();
                this.clearTimeouts();
                this.actionManager.clear();
            }
            this.stateManager.clear(this.global);
            this.tempArray.clear();
            this.chainMap.clear();
            this.chainList.clear();
            this.colorManager.clear();
            this.definedAtomSets.clear();
            if (this.dataManager != null) {
                this.dataManager.clear();
            }
            if (bl2) {
                if (bl3 && this.global.modelKitMode) {
                    this.openStringInlineParamsAppend("5\n\nC 0 0 0\nH .63 .63 .63\nH -.63 -.63 .63\nH -.63 .63 -.63\nH .63 -.63 -.63", null, true);
                    this.setRotationRadius(5.0f, true);
                    this.setStringProperty("picking", "assignAtom_C");
                    this.setStringProperty("picking", "assignBond_p");
                }
                this.undoClear();
            }
            System.gc();
        } else {
            this.modelManager.zap();
        }
        this.initializeModel(false);
        if (bl) {
            this.setFileLoadStatus(EnumFileStatus.ZAPPED, null, bl2 ? "resetUndo" : this.getZapName(), null, null, null);
        }
        if (Logger.debugging) {
            Logger.checkMemory();
        }
    }

    private void zapMsg(String string) {
        this.zap(true, true, false);
        this.echoMessage(string);
    }

    void echoMessage(String string) {
        int n = 30;
        this.loadShape(n);
        this.setShapeProperty(n, "font", this.getFont3D("SansSerif", "Plain", 9.0f));
        this.setShapeProperty(n, "target", "error");
        this.setShapeProperty(n, "text", string);
    }

    private void initializeModel(boolean bl) {
        this.clearThreads();
        if (bl) {
            this.animationManager.initializePointers(1);
            return;
        }
        this.reset(true);
        this.selectAll();
        this.rotateBondIndex = -1;
        this.rotatePrev1 = -1;
        this.movingSelected = false;
        this.noneSelected = false;
        this.hoverEnabled = true;
        this.transformManager.setCenter();
        this.animationManager.initializePointers(1);
        if (!this.modelSet.getModelSetAuxiliaryInfoBoolean("isPyMOL")) {
            this.clearAtomSets();
            this.setCurrentModelIndex(0);
        }
        this.setBackgroundModelIndex(-1);
        this.setFrankOn(this.getShowFrank());
        this.startHoverWatcher(true);
        this.setTainted(true);
        this.finalizeTransformParameters();
    }

    @Override
    public void startHoverWatcher(boolean bl) {
        if (bl && this.inMotion || !this.haveDisplay || bl && (!this.hoverEnabled || this.animationManager.animationOn)) {
            return;
        }
        this.actionManager.startHoverWatcher(bl);
    }

    @Override
    public String getModelSetName() {
        if (this.modelSet == null) {
            return null;
        }
        return this.modelSet.modelSetName;
    }

    @Override
    public String getModelSetFileName() {
        return this.modelManager.getModelSetFileName();
    }

    public String getUnitCellInfoText() {
        return this.modelSet.getUnitCellInfoText();
    }

    public float getUnitCellInfo(int n) {
        SymmetryInterface symmetryInterface = this.getCurrentUnitCell();
        if (symmetryInterface == null) {
            return Float.NaN;
        }
        return symmetryInterface.getUnitCellInfoType(n);
    }

    public Map<String, Object> getSpaceGroupInfo(String string) {
        return this.modelSet.getSymTemp(true).getSpaceGroupInfo(this.modelSet, -1, string, 0, null, null, null);
    }

    public void getPolymerPointsAndVectors(BS bS, javajs.util.List<P3[]> list) {
        this.modelSet.getPolymerPointsAndVectors(bS, list, this.global.traceAlpha, this.global.sheetSmoothing);
    }

    public String getModelSetProperty(String string) {
        return this.modelSet.getModelSetProperty(string);
    }

    public Object getModelSetAuxiliaryInfoValue(String string) {
        return this.modelSet.getModelSetAuxiliaryInfoValue(string);
    }

    @Override
    public String getModelSetPathName() {
        return this.modelManager.getModelSetPathName();
    }

    public String getModelSetTypeName() {
        return this.modelSet.getModelSetTypeName();
    }

    @Override
    public boolean haveFrame() {
        return this.haveModelSet();
    }

    boolean haveModelSet() {
        return this.modelSet != null;
    }

    public void clearBfactorRange() {
        this.modelSet.clearBfactorRange();
    }

    public String getHybridizationAndAxes(int n, V3 v3, V3 v32, String string) {
        return this.modelSet.getHybridizationAndAxes(n, 0, v3, v32, string, true, true);
    }

    public BS getMoleculeBitSet(int n) {
        return this.modelSet.getMoleculeBitSetForAtom(n);
    }

    public BS getAllAtoms() {
        return this.getModelUndeletedAtomsBitSet(-1);
    }

    public BS getModelUndeletedAtomsBitSet(int n) {
        BS bS = this.modelSet.getModelAtomBitSetIncludingDeleted(n, true);
        this.excludeAtoms(bS, false);
        return bS;
    }

    public BS getModelBitSet(BS bS, boolean bl) {
        return this.modelSet.getModelBitSet(bS, bl);
    }

    public BS getModelUndeletedAtomsBitSetBs(BS bS) {
        BS bS2 = this.modelSet.getModelAtomBitSetIncludingDeletedBs(bS);
        this.excludeAtoms(bS2, false);
        return bS2;
    }

    public void excludeAtoms(BS bS, boolean bl) {
        this.selectionManager.excludeAtoms(bS, bl);
    }

    public ModelSet getModelSet() {
        return this.modelSet;
    }

    public String getBoundBoxCommand(boolean bl) {
        return this.modelSet.getBoundBoxCommand(bl);
    }

    public void setBoundBox(P3 p3, P3 p32, boolean bl, float f) {
        this.modelSet.setBoundBox(p3, p32, bl, f);
    }

    @Override
    public P3 getBoundBoxCenter() {
        return this.modelSet.getBoundBoxCenter(this.animationManager.currentModelIndex);
    }

    P3 getAverageAtomPoint() {
        return this.modelSet.getAverageAtomPoint();
    }

    public void calcBoundBoxDimensions(BS bS, float f) {
        this.modelSet.calcBoundBoxDimensions(bS, f);
        this.axesAreTainted = true;
    }

    public BoxInfo getBoxInfo(BS bS, float f) {
        return this.modelSet.getBoxInfo(bS, f);
    }

    public float calcRotationRadius(P3 p3) {
        return this.modelSet.calcRotationRadius(this.animationManager.currentModelIndex, p3);
    }

    public float calcRotationRadiusBs(BS bS) {
        return this.modelSet.calcRotationRadiusBs(bS);
    }

    @Override
    public V3 getBoundBoxCornerVector() {
        return this.modelSet.getBoundBoxCornerVector();
    }

    public P3[] getBoundBoxVertices() {
        return this.modelSet.getBboxVertices();
    }

    Map<String, Object> getBoundBoxInfo() {
        return this.modelSet.getBoundBoxInfo();
    }

    public BS getBoundBoxModels() {
        return this.modelSet.getBoundBoxModels();
    }

    public int getBoundBoxCenterX() {
        return this.dimScreen.width / 2;
    }

    public int getBoundBoxCenterY() {
        return this.dimScreen.height / 2;
    }

    @Override
    public int getModelCount() {
        return this.modelSet == null ? 0 : this.modelSet.modelCount;
    }

    public String getModelInfoAsString() {
        return this.modelSet.getModelInfoAsString();
    }

    public String getSymmetryInfoAsString() {
        return this.modelSet.getSymmetryInfoAsString();
    }

    public String getSymmetryOperation(String string, int n, P3 p3, P3 p32, boolean bl) {
        return this.modelSet.getSymmetryInfoString(this.animationManager.currentModelIndex, string, n, p3, p32, null, bl);
    }

    @Override
    public Properties getModelSetProperties() {
        return this.modelSet.getModelSetProperties();
    }

    @Override
    public Map<String, Object> getModelSetAuxiliaryInfo() {
        return this.modelSet.getModelSetAuxiliaryInfo();
    }

    @Override
    public int getModelNumber(int n) {
        return n < 0 ? n : this.modelSet.getModelNumber(n);
    }

    public int getModelFileNumber(int n) {
        return n < 0 ? 0 : this.modelSet.getModelFileNumber(n);
    }

    @Override
    public String getModelNumberDotted(int n) {
        return n < 0 ? "0" : (this.modelSet == null ? null : this.modelSet.getModelNumberDotted(n));
    }

    @Override
    public String getModelName(int n) {
        return this.modelSet == null ? null : this.modelSet.getModelName(n);
    }

    @Override
    public Properties getModelProperties(int n) {
        return this.modelSet.getModelProperties(n);
    }

    @Override
    public String getModelProperty(int n, String string) {
        return this.modelSet.getModelProperty(n, string);
    }

    public String getModelFileInfo() {
        return this.getPropertyManager().getModelFileInfo(this.getVisibleFramesBitSet());
    }

    public String getModelFileInfoAll() {
        return this.getPropertyManager().getModelFileInfo(null);
    }

    @Override
    public Map<String, Object> getModelAuxiliaryInfo(int n) {
        return this.modelSet.getModelAuxiliaryInfo(n);
    }

    @Override
    public Object getModelAuxiliaryInfoValue(int n, String string) {
        return this.modelSet.getModelAuxiliaryInfoValue(n, string);
    }

    public int getModelNumberIndex(int n, boolean bl, boolean bl2) {
        return this.modelSet.getModelNumberIndex(n, bl, bl2);
    }

    boolean modelSetHasVibrationVectors() {
        return this.modelSet.modelSetHasVibrationVectors();
    }

    @Override
    public int modelGetLastVibrationIndex(int n, int n2) {
        return this.modelSet.getLastVibrationVector(n, n2);
    }

    @Override
    public boolean modelHasVibrationVectors(int n) {
        return this.modelSet.getLastVibrationVector(n, 4166) >= 0;
    }

    @Override
    public int getChainCount() {
        return this.modelSet.getChainCount(true);
    }

    @Override
    public int getChainCountInModel(int n) {
        return this.modelSet.getChainCountInModel(n, false);
    }

    public int getChainCountInModelWater(int n, boolean bl) {
        return this.modelSet.getChainCountInModel(n, bl);
    }

    @Override
    public int getGroupCount() {
        return this.modelSet.getGroupCount();
    }

    @Override
    public int getGroupCountInModel(int n) {
        return this.modelSet.getGroupCountInModel(n);
    }

    @Override
    public int getPolymerCount() {
        return this.modelSet.getBioPolymerCount();
    }

    @Override
    public int getPolymerCountInModel(int n) {
        return this.modelSet.getBioPolymerCountInModel(n);
    }

    @Override
    public int getAtomCount() {
        return this.modelSet.getAtomCount();
    }

    @Override
    public int getAtomCountInModel(int n) {
        return this.modelSet.getAtomCountInModel(n);
    }

    @Override
    public int getBondCount() {
        return this.modelSet.bondCount;
    }

    @Override
    public int getBondCountInModel(int n) {
        return this.modelSet.getBondCountInModel(n);
    }

    public BS getBondsForSelectedAtoms(BS bS) {
        return this.modelSet.getBondsForSelectedAtoms(bS, this.global.bondModeOr || BSUtil.cardinalityOf(bS) == 1);
    }

    public boolean frankClicked(int n, int n2) {
        return !this.global.disablePopupMenu && this.getShowFrank() && this.shapeManager.checkFrankclicked(n, n2);
    }

    public boolean frankClickedModelKit(int n, int n2) {
        return !this.global.disablePopupMenu && this.global.modelKitMode && n >= 0 && n2 >= 0 && n < 40 && n2 < 80;
    }

    @Override
    public int findNearestAtomIndex(int n, int n2) {
        return this.findNearestAtomIndexMovable(n, n2, false);
    }

    public int findNearestAtomIndexMovable(int n, int n2, boolean bl) {
        return this.modelSet == null || !this.global.atomPicking ? -1 : this.modelSet.findNearestAtomIndex(n, n2, bl ? this.selectionManager.getMotionFixedAtoms() : null, this.global.minPixelSelRadius);
    }

    BS findAtomsInRectangle(Rectangle rectangle) {
        return this.modelSet.findAtomsInRectangle(rectangle, this.getVisibleFramesBitSet());
    }

    public void toCartesian(P3 p3, boolean bl) {
        SymmetryInterface symmetryInterface = this.getCurrentUnitCell();
        if (symmetryInterface != null) {
            symmetryInterface.toCartesian(p3, bl);
        }
    }

    public void toFractional(P3 p3, boolean bl) {
        SymmetryInterface symmetryInterface = this.getCurrentUnitCell();
        if (symmetryInterface != null) {
            symmetryInterface.toFractional(p3, bl);
        }
    }

    public void toUnitCell(P3 p3, P3 p32) {
        SymmetryInterface symmetryInterface = this.getCurrentUnitCell();
        if (symmetryInterface != null) {
            symmetryInterface.toUnitCell(p3, p32);
        }
    }

    public void setCurrentCage(String string) {
        Object[] objectArray = new Object[]{string, null};
        this.shapeManager.getShapePropertyData(24, "unitCell", objectArray);
        this.modelSet.setModelCage(this.getCurrentModelIndex(), (SymmetryInterface)objectArray[1]);
    }

    public void setCurrentCagePts(P3[] p3Array) {
        this.modelSet.setModelCage(this.getCurrentModelIndex(), this.getSymmetry().getUnitCell(p3Array));
    }

    public void setCurrentUnitCellOffset(int n) {
        this.modelSet.setUnitCellOffset(this.animationManager.currentModelIndex, null, n);
    }

    public void setCurrentUnitCellOffsetPt(P3 p3) {
        this.modelSet.setUnitCellOffset(this.animationManager.currentModelIndex, p3, 0);
    }

    public void addUnitCellOffset(P3 p3) {
        SymmetryInterface symmetryInterface = this.getCurrentUnitCell();
        if (symmetryInterface == null) {
            return;
        }
        p3.add(symmetryInterface.getCartesianOffset());
    }

    public void setAtomData(int n, String string, String string2, boolean bl) {
        this.modelSet.setAtomData(n, string, string2, bl);
        if (n == 2) {
            this.checkCoordinatesChanged();
        }
        this.refreshMeasures(true);
    }

    @Override
    public void setCenterSelected() {
        this.setCenterBitSet(this.getSelectionSet(false), true);
    }

    void setApplySymmetryToBonds(boolean bl) {
        this.global.applySymmetryToBonds = bl;
    }

    @Override
    public void setBondTolerance(float f) {
        this.global.setF("bondTolerance", f);
        this.global.bondTolerance = f;
    }

    @Override
    public void setMinBondDistance(float f) {
        this.global.setF("minBondDistance", f);
        this.global.minBondDistance = f;
    }

    public int[] getAtomIndices(BS bS) {
        return this.modelSet.getAtomIndices(bS);
    }

    public BS getAtomBits(int n, Object object) {
        return this.modelSet.getAtomBits(n, object);
    }

    public BS getSequenceBits(String string, BS bS) {
        return this.modelSet.getSequenceBits(string, bS);
    }

    public BS getAtomsNearPt(float f, P3 p3) {
        BS bS = new BS();
        this.modelSet.getAtomsWithin(f, p3, bS, -1);
        return bS;
    }

    public BS getAtomsNearPts(float f, P3[] p3Array, BS bS) {
        return this.modelSet.getAtomsWithinBs(f, p3Array, bS);
    }

    public BS getAtomsNearPlane(float f, P4 p4) {
        return this.modelSet.getAtomsWithin(f, p4);
    }

    public BS getAtomsWithinRadius(float f, BS bS, boolean bl, RadiusData radiusData) {
        return this.modelSet.getAtomsWithinRD(f, bS, bl, radiusData);
    }

    public BS getAtomsConnected(float f, float f2, int n, BS bS) {
        return this.modelSet.getAtomsConnected(f, f2, n, bS);
    }

    public BS getBranchBitSet(int n, int n2, boolean bl) {
        if (n < 0 || n >= this.getAtomCount()) {
            return new BS();
        }
        return JmolMolecule.getBranchBitSet(this.modelSet.atoms, n, this.getModelUndeletedAtomsBitSet(this.modelSet.atoms[n].modelIndex), null, n2, bl, true);
    }

    public int getAtomIndexFromAtomNumber(int n) {
        return this.modelSet.getAtomIndexFromAtomNumber(n, this.getVisibleFramesBitSet());
    }

    @Override
    public BS getElementsPresentBitSet(int n) {
        return this.modelSet.getElementsPresentBitSet(n);
    }

    @Override
    public Map<String, String> getHeteroList(int n) {
        return this.modelSet.getHeteroList(n);
    }

    public BS getVisibleSet() {
        return this.modelSet.getVisibleSet();
    }

    public BS getClickableSet() {
        return this.modelSet.getClickableSet();
    }

    public void calcSelectedGroupsCount() {
        this.modelSet.calcSelectedGroupsCount(this.getSelectionSet(false));
    }

    public void calcSelectedMonomersCount() {
        this.modelSet.calcSelectedMonomersCount(this.getSelectionSet(false));
    }

    public void calcSelectedMoleculesCount() {
        this.modelSet.calcSelectedMoleculesCount(this.getSelectionSet(false));
    }

    String getFileHeader() {
        return this.modelSet.getFileHeader(this.animationManager.currentModelIndex);
    }

    Object getFileData() {
        return this.modelSet.getFileData(this.animationManager.currentModelIndex);
    }

    public Map<String, Object> getCifData(int n) {
        String string = this.getModelFileName(n);
        String string2 = this.getFileAsString(string);
        if (string2 == null) {
            return null;
        }
        return CifDataReader.readCifData(JmolBinary.getBR(string2));
    }

    public String getPDBHeader() {
        return this.modelSet.getPDBHeader(this.animationManager.currentModelIndex);
    }

    public Map<String, Object> getAuxiliaryInfo(Object object) {
        return this.modelSet.getAuxiliaryInfo(this.getModelBitSet(this.getAtomBitSet(object), false));
    }

    public String getChimeInfo(int n) {
        return this.getPropertyManager().getChimeInfo(n, this.getSelectionSet(false));
    }

    public JmolStateCreator getStateCreator() {
        if (this.sc == null) {
            this.sc = (JmolStateCreator)Interface.getOptionInterface("viewer.StateCreator");
            this.sc.setViewer(this);
        }
        return this.sc;
    }

    public String getWrappedStateScript() {
        return (String)this.getOutputManager().getWrappedState(null, null, null, null);
    }

    @Override
    public String getStateInfo() {
        return this.getStateInfo3(null, 0, 0);
    }

    public String getStateInfo3(String string, int n, int n2) {
        return this.global.preserveState ? this.getStateCreator().getStateScript(string, n, n2) : "";
    }

    public String getStructureState() {
        return this.getStateCreator().getModelState(null, false, true);
    }

    public String getProteinStructureState() {
        return this.modelSet.getProteinStructureState(this.getSelectionSet(false), false, false, 3);
    }

    public String getCoordinateState(BS bS) {
        return this.getStateCreator().getAtomicPropertyState((byte)2, bS);
    }

    public void setCurrentColorRange(String string) {
        BS bS;
        float[] fArray = this.getDataFloat(string);
        BS bS2 = bS = fArray == null ? null : (BS)this.getDataManager().getData(string)[2];
        if (bS != null && this.global.rangeSelected) {
            bS.and(this.getSelectionSet(false));
        }
        this.setCurrentColorRangeData(fArray, bS);
    }

    public void setCurrentColorRangeData(float[] fArray, BS bS) {
        this.colorManager.setPropertyColorRangeData(fArray, bS, this.global.propertyColorScheme);
    }

    public void setCurrentColorRange(float f, float f2) {
        this.colorManager.setPropertyColorRange(f, f2);
    }

    public int getArgbMinMax(float f, float f2, float f3) {
        return this.colorManager.propertyColorEncoder.getArgbMinMax(f, f2, f3);
    }

    public void setData(String string, Object[] objectArray, int n, int n2, int n3, int n4, int n5) {
        this.getDataManager().setData(string, objectArray, n, this.getAtomCount(), n2, n3, n4, n5);
    }

    public Object[] getData(String string) {
        return this.getDataManager().getData(string);
    }

    public float[] getDataFloat(String string) {
        return this.getDataManager().getDataFloatA(string);
    }

    public float[][] getDataFloat2D(String string) {
        return this.getDataManager().getDataFloat2D(string);
    }

    public float[][][] getDataFloat3D(String string) {
        return this.getDataManager().getDataFloat3D(string);
    }

    public float getDataFloatAt(String string, int n) {
        return this.getDataManager().getDataFloat(string, n);
    }

    @Override
    public String getAltLocListInModel(int n) {
        return this.modelSet.getAltLocListInModel(n);
    }

    public BS setConformation() {
        return this.modelSet.setConformation(this.getSelectionSet(false));
    }

    public BS getConformation(int n, int n2, boolean bl) {
        return this.modelSet.getConformation(n, n2, bl);
    }

    public int autoHbond(BS bS, BS bS2, boolean bl) {
        if (bS == null) {
            bS = bS2 = this.getSelectionSet(false);
        }
        return this.modelSet.autoHbond(bS, bS2, bl);
    }

    @Override
    public boolean havePartialCharges() {
        return this.modelSet.getPartialCharges() != null;
    }

    public SymmetryInterface getCurrentUnitCell() {
        if (this.animationManager.currentModelIndex >= 0) {
            return this.modelSet.getUnitCell(this.animationManager.currentModelIndex);
        }
        BS bS = this.getVisibleFramesBitSet();
        SymmetryInterface symmetryInterface = null;
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            SymmetryInterface symmetryInterface2 = this.modelSet.getUnitCell(n);
            if (symmetryInterface2 != null) {
                if (symmetryInterface == null) {
                    symmetryInterface = symmetryInterface2;
                } else if (!symmetryInterface.unitCellEquals(symmetryInterface2)) {
                    return null;
                }
            }
            n = bS.nextSetBit(n + 1);
        }
        return symmetryInterface;
    }

    public SymmetryInterface getModelUnitCell(int n) {
        return this.modelSet.getUnitCell(n);
    }

    public String getDefaultMeasurementLabel(int n) {
        switch (n) {
            case 2: {
                return this.global.defaultDistanceLabel;
            }
            case 3: {
                return this.global.defaultAngleLabel;
            }
        }
        return this.global.defaultTorsionLabel;
    }

    @Override
    public int getMeasurementCount() {
        int n = this.getShapePropertyAsInt(6, "count");
        return n <= 0 ? 0 : n;
    }

    @Override
    public String getMeasurementStringValue(int n) {
        String string = "" + this.getShapePropertyIndex(6, "stringValue", n);
        return string;
    }

    javajs.util.List<Map<String, Object>> getMeasurementInfo() {
        return (javajs.util.List)this.getShapeProperty(6, "info");
    }

    public String getMeasurementInfoAsString() {
        return (String)this.getShapeProperty(6, "infostring");
    }

    @Override
    public int[] getMeasurementCountPlusIndices(int n) {
        int[] nArray = (int[])this.getShapePropertyIndex(6, "countPlusIndices", n);
        return nArray;
    }

    void setPendingMeasurement(MeasurementPending measurementPending) {
        this.loadShape(6);
        this.setShapeProperty(6, "pending", measurementPending);
    }

    MeasurementPending getPendingMeasurement() {
        return (MeasurementPending)this.getShapeProperty(6, "pending");
    }

    public void clearAllMeasurements() {
        this.setShapeProperty(6, "clear", null);
    }

    @Override
    public void clearMeasurements() {
        this.evalString("measures delete");
    }

    public void setAnimation(int n) {
        switch (n) {
            case 1073742098: {
                this.animationManager.reverseAnimation();
            }
            case 266287: 
            case 0x40000110: {
                if (!this.animationManager.animationOn) {
                    this.animationManager.resumeAnimation();
                }
                return;
            }
            case 20487: {
                if (this.animationManager.animationOn && !this.animationManager.animationPaused) {
                    this.animationManager.pauseAnimation();
                }
                return;
            }
            case 1073742037: {
                this.animationManager.setAnimationNext();
                return;
            }
            case 1073742108: {
                this.animationManager.setAnimationPrevious();
                return;
            }
            case 1073741942: 
            case 1073742126: {
                this.animationManager.rewindAnimation();
                return;
            }
            case 1073741993: {
                this.animationManager.setAnimationLast();
                return;
            }
        }
    }

    public void setAnimationDirection(int n) {
        this.animationManager.setAnimationDirection(n);
    }

    int getAnimationDirection() {
        return this.animationManager.animationDirection;
    }

    Map<String, Object> getAnimationInfo() {
        return this.getStateCreator().getInfo(this.animationManager);
    }

    @Override
    public void setAnimationFps(int n) {
        if (n < 1) {
            n = 1;
        }
        if (n > 50) {
            n = 50;
        }
        this.animationManager.setAnimationFps(n);
    }

    private void setAnimationMode(String string) {
        if (string.equalsIgnoreCase("once")) {
            this.setAnimationReplayMode(EnumAnimationMode.ONCE, 0.0f, 0.0f);
        } else if (string.equalsIgnoreCase("loop")) {
            this.setAnimationReplayMode(EnumAnimationMode.LOOP, 1.0f, 1.0f);
        } else if (string.startsWith("pal")) {
            this.setAnimationReplayMode(EnumAnimationMode.PALINDROME, 1.0f, 1.0f);
        }
    }

    public void setAnimationReplayMode(EnumAnimationMode enumAnimationMode, float f, float f2) {
        this.animationManager.setAnimationReplayMode(enumAnimationMode, f, f2);
    }

    public EnumAnimationMode getAnimationReplayMode() {
        return this.animationManager.animationReplayMode;
    }

    public void setAnimationOn(boolean bl) {
        boolean bl2 = this.animationManager.animationOn;
        if (bl == bl2) {
            return;
        }
        this.animationManager.setAnimationOn(bl);
    }

    public void setAnimationRange(int n, int n2) {
        this.animationManager.setAnimationRange(n, n2);
    }

    @Override
    public BS getVisibleFramesBitSet() {
        return this.modelSet.selectDisplayedTrajectories(BSUtil.copy(this.animationManager.bsVisibleModels));
    }

    boolean isAnimationOn() {
        return this.animationManager.animationOn;
    }

    public void setMovie(Map<String, Object> map) {
        this.animationManager.setMovie(map);
    }

    public void setAnimMorphCount(int n) {
        this.animationManager.setMorphCount(n);
    }

    public boolean isMovie() {
        return this.animationManager.isMovie;
    }

    public int getFrameCount() {
        return this.animationManager.getFrameCount();
    }

    public void defineAtomSets(Map<String, Object> map) {
        this.definedAtomSets.putAll(map);
    }

    public void morph(float f) {
        this.animationManager.morph(f);
    }

    public void setAnimDisplay(BS bS) {
        this.animationManager.setDisplay(bS);
        if (!this.isAnimationOn()) {
            this.animationManager.morph(this.animationManager.currentMorphModel + 1.0f);
        }
    }

    public void setCurrentModelIndex(int n) {
        if (n == Integer.MIN_VALUE) {
            this.prevFrame = Integer.MIN_VALUE;
            this.setCurrentModelIndexClear(this.animationManager.currentModelIndex, true);
            return;
        }
        this.animationManager.setModel(n, true);
    }

    void setTrajectory(int n) {
        this.modelSet.setTrajectory(n);
    }

    public void setTrajectoryBs(BS bS) {
        this.modelSet.setTrajectoryBs(bS);
    }

    public boolean isTrajectory(int n) {
        return this.modelSet.isTrajectory(n);
    }

    public BS getBitSetTrajectories() {
        return this.modelSet.getBitSetTrajectories();
    }

    public String getTrajectoryState() {
        return this.getStateCreator().getTrajectoryState();
    }

    void setFrameOffset(int n) {
        this.transformManager.setFrameOffset(n);
    }

    public void setFrameOffsets(BS bS) {
        this.bsFrameOffsets = bS;
        this.frameOffsets = this.modelSet.getFrameOffsets(this.bsFrameOffsets);
        this.transformManager.setFrameOffsets(this.frameOffsets);
    }

    public BS getFrameOffsets() {
        return this.bsFrameOffsets;
    }

    public void setCurrentModelIndexClear(int n, boolean bl) {
        this.animationManager.setModel(n, bl);
    }

    public int getCurrentModelIndex() {
        return this.animationManager.currentModelIndex;
    }

    @Override
    public int getDisplayModelIndex() {
        return this.animationManager.currentModelIndex;
    }

    public boolean haveFileSet() {
        return this.getModelCount() > 1 && this.getModelNumber(Integer.MAX_VALUE) > 2000000;
    }

    public void setBackgroundModelIndex(int n) {
        this.animationManager.setBackgroundModelIndex(n);
        this.global.setS("backgroundModel", this.modelSet.getModelNumberDotted(n));
    }

    void setFrameVariables() {
        this.global.setS("animationMode", this.animationManager.animationReplayMode.name());
        this.global.setI("animationFps", this.animationManager.animationFps);
        this.global.setS("_firstFrame", this.animationManager.getModelSpecial(-1));
        this.global.setS("_lastFrame", this.animationManager.getModelSpecial(1));
        this.global.setF("_animTimeSec", this.animationManager.getAnimRunTimeSeconds());
        this.global.setB("_animMovie", this.animationManager.isMovie);
    }

    public boolean getInMotion(boolean bl) {
        return this.inMotion || bl && this.animationManager.animationOn;
    }

    @Override
    public int getMotionEventNumber() {
        return this.motionEventNumber;
    }

    @Override
    public void setInMotion(boolean bl) {
        if (this.inMotion ^ bl) {
            this.inMotion = bl;
            this.resizeImage(0, 0, false, false, true);
            if (bl) {
                this.startHoverWatcher(false);
                ++this.motionEventNumber;
            } else {
                this.startHoverWatcher(true);
                this.refresh(3, "viewer setInMotion " + bl);
            }
        }
    }

    private void setRefreshing(boolean bl) {
        this.refreshing = bl;
    }

    public boolean getRefreshing() {
        return this.refreshing;
    }

    @Override
    public void pushHoldRepaint() {
        this.pushHoldRepaintWhy(null);
    }

    public void pushHoldRepaintWhy(String string) {
        if (this.repaintManager != null) {
            this.repaintManager.pushHoldRepaint(string);
        }
    }

    @Override
    public void popHoldRepaint(String string) {
        if (this.repaintManager != null) {
            this.repaintManager.popHoldRepaint(string.indexOf("\u0001## REPAINT_IGNORE ##") < 0, string);
        }
    }

    @Override
    public void refresh(int n, String string) {
        if (this.repaintManager == null || !this.refreshing) {
            return;
        }
        if (n == 6 && this.getInMotion(true)) {
            return;
        }
        if (this.isWebGL) {
            if (n == 2 || n == 7) {
                this.transformManager.finalizeTransformParameters();
            }
        } else if (n > 0 && n != 7) {
            this.repaintManager.repaintIfReady("refresh " + n + " " + string);
        }
        if (n == 7) {
            return;
        }
        if (n % 3 != 0 && this.statusManager.doSync()) {
            this.statusManager.setSync(n == 2 ? string : null);
        }
    }

    public void requestRepaintAndWait(String string) {
        if (!this.haveDisplay || this.repaintManager == null) {
            return;
        }
        this.repaintManager.requestRepaintAndWait(string);
        this.setSync();
    }

    public void clearShapeRenderers() {
        this.clearRepaintManager(-1);
    }

    public boolean isRepaintPending() {
        return this.repaintManager == null ? false : this.repaintManager.isRepaintPending();
    }

    @Override
    public void notifyViewerRepaintDone() {
        if (this.repaintManager != null) {
            this.repaintManager.repaintDone();
        }
        this.animationManager.repaintDone();
    }

    public boolean areAxesTainted() {
        boolean bl = this.axesAreTainted;
        this.axesAreTainted = false;
        return bl;
    }

    private void setMaximumSize(int n) {
        this.maximumSize = Math.max(n, 100);
    }

    @Override
    public void setScreenDimension(int n, int n2) {
        n2 = Math.min(n2, this.maximumSize);
        n = Math.min(n, this.maximumSize);
        if (this.isStereoDouble()) {
            n = (n + 1) / 2;
        }
        if (this.dimScreen.width == n && this.dimScreen.height == n2) {
            return;
        }
        this.resizeImage(n, n2, false, false, true);
    }

    public float getImageFontScaling() {
        return this.imageFontScaling;
    }

    void resizeImage(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        if (!bl && this.creatingImage) {
            return;
        }
        if (!bl2 && !bl) {
            this.setShapeProperty(5, "clearBoxes", null);
        }
        boolean bl4 = bl3 ? this.global.antialiasDisplay && this.checkMotionRendering(603979786) : (this.antialiasDisplay = bl && !bl2 ? this.global.antialiasImages : false);
        this.imageFontScaling = (bl3 || n <= 0 ? 1 : (this.global.zoomLarge == n2 > n ? n2 : n) / this.getScreenDim()) * (this.antialiasDisplay ? 2 : 1);
        if (n > 0) {
            this.dimScreen.width = n;
            this.dimScreen.height = n2;
            if (!bl) {
                this.global.setI("_width", n);
                this.global.setI("_height", n2);
                this.setStatusResized(n, n2);
            }
        } else {
            n = this.dimScreen.width == 0 ? (this.dimScreen.width = 500) : this.dimScreen.width;
            n2 = this.dimScreen.height == 0 ? (this.dimScreen.height = 500) : this.dimScreen.height;
        }
        this.transformManager.setScreenParameters(n, n2, bl || bl3 ? this.global.zoomLarge : false, this.antialiasDisplay, false, false);
        this.gdata.setWindowParameters(n, n2, this.antialiasDisplay);
    }

    @Override
    public int getScreenWidth() {
        return this.dimScreen.width;
    }

    @Override
    public int getScreenHeight() {
        return this.dimScreen.height;
    }

    public int getScreenDim() {
        return this.global.zoomLarge == this.dimScreen.height > this.dimScreen.width ? this.dimScreen.height : this.dimScreen.width;
    }

    @Override
    public String generateOutputForExport(Map<String, Object> map) {
        return this.noGraphicsAllowed || this.repaintManager == null ? null : this.getOutputManager().getOutputFromExport(map);
    }

    private void clearRepaintManager(int n) {
        if (this.repaintManager != null) {
            this.repaintManager.clear(n);
        }
    }

    @Override
    public void renderScreenImageStereo(Object object, Object object2, int n, int n2) {
        if (this.updateWindow(n, n2)) {
            if (object2 == null) {
                this.getScreenImageBuffer(object, false);
            } else {
                this.render1(object2, this.getImage(true, false), 0, 0);
                this.render1(object, this.getImage(false, false), 0, 0);
            }
        }
        if (this.captureParams != null && Boolean.FALSE != this.captureParams.get("captureEnabled")) {
            if (System.currentTimeMillis() >= (Long)this.captureParams.get("endTime")) {
                this.captureParams.put("captureMode", 0x119009);
            }
            this.processWriteOrCapture(this.captureParams);
        }
        this.notifyViewerRepaintDone();
    }

    @Override
    public void updateJS(int n, int n2) {
        if (this.isWebGL) {
            if (this.jsParams == null) {
                this.jsParams = new Hashtable<String, Object>();
                this.jsParams.put("type", "JS");
            }
            if (this.updateWindow(n, n2)) {
                this.render();
            }
            this.notifyViewerRepaintDone();
        } else {
            Object var3_3 = null;
            Object var4_4 = null;
            this.renderScreenImageStereo(var3_3, var4_4, n, n2);
        }
    }

    private boolean updateWindow(int n, int n2) {
        if (!this.refreshing || this.creatingImage) {
            return false;
        }
        if (this.isTainted || this.getSlabEnabled()) {
            this.setModelVisibility();
        }
        this.isTainted = false;
        if (this.repaintManager != null && n != 0) {
            this.setScreenDimension(n, n2);
        }
        return true;
    }

    @Override
    public void renderScreenImage(Object object, int n, int n2) {
        this.renderScreenImageStereo(object, null, n, n2);
    }

    private Object getImage(boolean bl, boolean bl2) {
        if (this.isWebGL) {
            return null;
        }
        Object object = null;
        try {
            this.beginRendering(bl, bl2);
            this.render();
            this.gdata.endRendering();
            object = this.gdata.getScreenImage(bl2);
        }
        catch (Error error) {
            this.gdata.getScreenImage(bl2);
            this.handleError(error, false);
            this.setErrorMessage("Error during rendering: " + error, null);
        }
        return object;
    }

    private void beginRendering(boolean bl, boolean bl2) {
        this.gdata.beginRendering(this.transformManager.getStereoRotationMatrix(bl), this.global.translucent, bl2, !this.checkMotionRendering(603979967));
    }

    public boolean isAntialiased() {
        return this.antialiasDisplay;
    }

    private void render() {
        if (this.modelSet == null || !this.mustRender || !this.refreshing && !this.creatingImage || this.repaintManager == null) {
            return;
        }
        boolean bl = this.antialiasDisplay && this.global.antialiasTranslucent;
        this.finalizeTransformParameters();
        this.shapeManager.finalizeAtoms(this.transformManager.bsSelectedAtoms, this.transformManager.ptOffset);
        int[] nArray = this.shapeManager.transformAtoms();
        this.transformManager.bsSelectedAtoms = null;
        if (this.isWebGL) {
            this.repaintManager.renderExport(this.gdata, this.modelSet, this.jsParams);
            this.notifyViewerRepaintDone();
            return;
        }
        this.repaintManager.render(this.gdata, this.modelSet, true, nArray);
        if (this.gdata.setPass2(bl)) {
            this.transformManager.setAntialias(bl);
            this.repaintManager.render(this.gdata, this.modelSet, false, null);
            this.transformManager.setAntialias(this.antialiasDisplay);
        }
    }

    private void render1(Object object, Object object2, int n, int n2) {
        if (object != null && object2 != null) {
            this.apiPlatform.drawImage(object, object2, n, n2, this.dimScreen.width, this.dimScreen.height);
        }
        this.gdata.releaseScreenImage();
    }

    @Override
    public Object getScreenImageBuffer(Object object, boolean bl) {
        Object object2;
        boolean bl2;
        if (this.isWebGL) {
            return null;
        }
        boolean bl3 = bl2 = object == null && this.isStereoDouble();
        if (this.transformManager.stereoMode.isBiColor()) {
            this.beginRendering(true, bl);
            this.render();
            this.gdata.endRendering();
            this.gdata.snapshotAnaglyphChannelBytes();
            this.beginRendering(false, bl);
            this.render();
            this.gdata.endRendering();
            this.gdata.applyAnaglygh(this.transformManager.stereoMode, this.transformManager.stereoColors);
            object2 = this.gdata.getScreenImage(bl);
        } else {
            object2 = this.getImage(this.isStereoDouble(), bl);
        }
        Object object3 = null;
        if (bl2) {
            object3 = this.apiPlatform.newBufferedImage(object2, this.dimScreen.width << 1, this.dimScreen.height);
            object = this.apiPlatform.getGraphics(object3);
        }
        if (object != null) {
            if (this.isStereoDouble()) {
                this.render1(object, object2, this.dimScreen.width, 0);
                object2 = this.getImage(false, false);
            }
            this.render1(object, object2, 0, 0);
        }
        return bl2 ? object3 : object2;
    }

    @Override
    public byte[] getImageAsBytes(String string, int n, int n2, int n3, String[] stringArray) {
        return this.isWebGL ? null : this.getOutputManager().getImageAsBytes(string, n, n2, n3, stringArray);
    }

    @Override
    public void releaseScreenImage() {
        this.gdata.releaseScreenImage();
    }

    @Override
    public String evalFile(String string) {
        if (!this.allowScripting) {
            return null;
        }
        int n = string.indexOf(" -noqueue");
        if (n >= 0) {
            return (String)this.evalStringWaitStatusQueued("String", string.substring(0, n), "", true, false, false);
        }
        return this.getScriptManager().addScript(string, true, false);
    }

    public String getInsertedCommand() {
        String string = this.insertedCommand;
        this.insertedCommand = "";
        if (Logger.debugging && string != "") {
            Logger.debug("inserting: " + string);
        }
        return string;
    }

    @Override
    public String script(String string) {
        return this.evalStringQuietSync(string, false, true);
    }

    @Override
    public String evalString(String string) {
        return this.evalStringQuietSync(string, false, true);
    }

    @Override
    public String evalStringQuiet(String string) {
        return this.evalStringQuietSync(string, true, true);
    }

    public String evalStringQuietSync(String string, boolean bl, boolean bl2) {
        return this.getScriptManager() == null ? null : this.scriptManager.evalStringQuietSync(string, bl, bl2);
    }

    public void clearScriptQueue() {
        if (this.scriptManager != null) {
            this.scriptManager.clearQueue();
        }
    }

    private void setScriptQueue(boolean bl) {
        this.global.useScriptQueue = bl;
        if (!bl) {
            this.clearScriptQueue();
        }
    }

    @Override
    public boolean checkHalt(String string, boolean bl) {
        return this.scriptManager != null && this.scriptManager.checkHalt(string, bl);
    }

    @Override
    public String scriptWait(String string) {
        return (String)this.evalWait("JSON", string, "+scriptStarted,+scriptStatus,+scriptEcho,+scriptTerminated");
    }

    @Override
    public Object scriptWaitStatus(String string, String string2) {
        return this.evalWait("object", string, string2);
    }

    private Object evalWait(String string, String string2, String string3) {
        if (this.getScriptManager() == null) {
            return null;
        }
        this.scriptManager.waitForQueue();
        boolean bl = GT.setDoTranslate(false);
        Object object = this.evalStringWaitStatusQueued(string, string2, string3, false, false, false);
        GT.setDoTranslate(bl);
        return object;
    }

    public synchronized Object evalStringWaitStatusQueued(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3) {
        return this.getScriptManager() == null ? null : this.scriptManager.evalStringWaitStatusQueued(string, string2, string3, bl, bl2, bl3);
    }

    public void exitJmol() {
        if (this.isApplet && !this.isJNLP) {
            return;
        }
        if (this.headlessImageParams != null) {
            try {
                if (this.isHeadless()) {
                    this.outputToFile(this.headlessImageParams);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (Logger.debugging) {
            Logger.debug("exitJmol -- exiting");
        }
        System.out.flush();
        System.exit(0);
    }

    private Object scriptCheckRet(String string, boolean bl) {
        if (this.getScriptManager() == null) {
            return null;
        }
        return this.scriptManager.scriptCheckRet(string, bl);
    }

    @Override
    public synchronized Object scriptCheck(String string) {
        if (this.getScriptManager() == null) {
            return null;
        }
        return this.scriptCheckRet(string, false);
    }

    @Override
    public boolean isScriptExecuting() {
        return this.eval != null && this.eval.isExecuting();
    }

    @Override
    public void haltScriptExecution() {
        if (this.eval != null) {
            this.eval.haltExecution();
            this.eval.stopScriptThreads();
        }
        this.setStringPropertyTok("pathForAllFiles", 545259571, "");
        this.clearTimeouts();
    }

    public void pauseScriptExecution() {
        if (this.eval != null) {
            this.eval.pauseExecution(true);
        }
    }

    public String getDefaultLoadFilter() {
        return this.global.defaultLoadFilter;
    }

    public String getDefaultLoadScript() {
        return this.global.defaultLoadScript;
    }

    String resolveDatabaseFormat(String string) {
        if (Viewer.hasDatabasePrefix(string)) {
            string = (String)this.setLoadFormat(string, string.charAt(0), false);
        }
        return string;
    }

    public static boolean isDatabaseCode(char c) {
        return c == '$' || c == '=' || c == ':';
    }

    public static boolean hasDatabasePrefix(String string) {
        return string.length() != 0 && Viewer.isDatabaseCode(string.charAt(0));
    }

    /*
     * Unable to fully structure code
     */
    public Object setLoadFormat(String var1_1, char var2_2, boolean var3_3) {
        var5_4 = var1_1.substring(1);
        switch (var2_2) {
            case '=': {
                if (!var1_1.startsWith("==")) ** GOTO lbl8
                var5_4 = var5_4.substring(1);
                var2_2 = (char)35;
                ** GOTO lbl16
lbl8:
                // 1 sources

                if (var5_4.indexOf("/") > 0) {
                    try {
                        var6_5 = var5_4.indexOf("/");
                        var7_8 = var5_4.substring(0, var6_5);
                        var5_4 = this.global.resolveDataBase(var7_8, var5_4.substring(var6_5 + 1));
                        return var5_4 == null ? var1_1 : var5_4;
                    }
                    catch (Exception var6_6) {
                        return var1_1;
                    }
                }
            }
lbl16:
            // 4 sources

            case '#': {
                v0 = var6_7 = var2_2 == '=' ? this.global.loadFormat : this.global.loadLigandFormat;
                if (var5_4.indexOf(".") > 0 && var6_7.indexOf("%FILE.") >= 0) {
                    var6_7 = var6_7.substring(0, var6_7.indexOf("%FILE") + 5);
                }
                return Txt.formatStringS(var6_7, "FILE", var5_4);
            }
            case ':': {
                var4_10 = this.global.pubChemFormat;
                var7_9 = var5_4.toLowerCase();
                var8_13 = -2147483648;
                try {
                    var8_13 = Integer.parseInt(var5_4);
                }
                catch (Exception var9_14) {
                    // empty catch block
                }
                if (var8_13 != -2147483648) {
                    var5_4 = "cid/" + var8_13;
                } else if (var7_9.startsWith("smiles:")) {
                    var4_10 = var4_10 + "?POST?smiles=" + var5_4.substring(7);
                    var5_4 = "smiles";
                } else if (var7_9.startsWith("cid:")) {
                    var5_4 = "cid/" + var5_4.substring(4);
                } else {
                    if (var7_9.startsWith("name:")) {
                        var5_4 = var5_4.substring(5);
                    }
                    if (var7_9.startsWith("cas:")) {
                        var5_4 = var5_4.substring(4);
                    }
                    var5_4 = "name/" + PT.escapeUrl(var5_4);
                }
                return Txt.formatStringS(var4_10, "FILE", var5_4);
            }
            case '$': {
                if (var1_1.startsWith("$$")) {
                    var5_4 = var5_4.substring(1);
                    var4_11 = PT.simpleReplace(this.global.smilesUrlFormat, "&get3d=True", "");
                    return Txt.formatStringS(var4_11, "FILE", PT.escapeUrl(var5_4));
                }
            }
            case '/': 
            case '2': 
            case 'I': 
            case 'K': 
            case 'N': {
                var5_4 = PT.escapeUrl(var5_4);
                switch (var2_2) {
                    case 'N': {
                        var4_12 = this.global.nihResolverFormat + "/names";
                        break;
                    }
                    case '2': {
                        var4_12 = this.global.nihResolverFormat + "/image";
                        break;
                    }
                    case 'I': {
                        var4_12 = this.global.nihResolverFormat + "/stdinchi";
                        break;
                    }
                    case 'K': {
                        var4_12 = this.global.nihResolverFormat + "/inchikey";
                        break;
                    }
                    case '/': {
                        var4_12 = this.global.nihResolverFormat + "/";
                        break;
                    }
                    default: {
                        var4_12 = this.global.smilesUrlFormat;
                    }
                }
                return (var3_3 != false ? "MOL3D::" : "") + Txt.formatStringS(var4_12, "FILE", var5_4);
            }
            case '_': {
                var9_15 = FileManager.fixFileNameVariables(this.global.edsUrlFormat, var5_4);
                var10_16 = FileManager.fixFileNameVariables(this.global.edsUrlCutoff, var5_4);
                return new String[]{var9_15, var10_16};
            }
        }
        return var5_4;
    }

    public String[] getElectronDensityLoadInfo() {
        return new String[]{this.global.edsUrlFormat, this.global.edsUrlCutoff, this.global.edsUrlOptions};
    }

    public String getStandardLabelFormat(int n) {
        switch (n) {
            default: {
                return "%[identify]";
            }
            case 1: {
                return this.global.defaultLabelXYZ;
            }
            case 2: 
        }
        return this.global.defaultLabelPDB;
    }

    public P3[] getAdditionalHydrogens(BS bS, boolean bl, boolean bl2, javajs.util.List<Atom> list) {
        if (bS == null) {
            bS = this.getSelectionSet(false);
        }
        int[] nArray = new int[1];
        P3[][] p3Array = this.modelSet.calculateHydrogens(bS, nArray, bl, bl2, list);
        P3[] p3Array2 = new P3[nArray[0]];
        int n = 0;
        for (int i = 0; i < p3Array.length; ++i) {
            if (p3Array[i] == null) continue;
            for (int j = 0; j < p3Array[i].length; ++j) {
                p3Array2[n++] = p3Array[i][j];
            }
        }
        return p3Array2;
    }

    @Override
    public void setMarBond(short s) {
        this.global.bondRadiusMilliAngstroms = s;
        this.global.setI("bondRadiusMilliAngstroms", s);
        this.setShapeSize(1, s * 2, BSUtil.setAll(this.getAtomCount()));
    }

    public void setHoverLabel(String string) {
        this.loadShape(34);
        this.setShapeProperty(34, "label", string);
        boolean bl = this.hoverEnabled = string != null;
        if (!this.hoverEnabled) {
            this.startHoverWatcher(false);
        }
    }

    void hoverOn(int n, boolean bl) {
        this.setStatusAtomHovered(n, this.getAtomInfoXYZ(n, false));
        if (!this.hoverEnabled) {
            return;
        }
        if (this.global.modelKitMode) {
            if (this.isAtomAssignable(n)) {
                this.highlight(BSUtil.newAndSetBit(n));
            }
            this.refresh(3, "hover on atom");
            return;
        }
        if (this.eval != null && this.isScriptExecuting() || n == this.hoverAtomIndex || this.global.hoverDelayMs == 0) {
            return;
        }
        if (!this.isInSelectionSubset(n)) {
            return;
        }
        this.loadShape(34);
        if (bl && this.modelSet.atoms[n].isShapeVisible(JC.getShapeVisibilityFlag(5))) {
            this.setShapeProperty(34, "specialLabel", GT._("Drag to move label"));
        }
        this.setShapeProperty(34, "text", null);
        this.setShapeProperty(34, "target", n);
        this.hoverText = null;
        this.hoverAtomIndex = n;
        this.refresh(3, "hover on atom");
    }

    public void hoverOnPt(int n, int n2, String string, String string2, P3 p3) {
        if (!this.hoverEnabled) {
            return;
        }
        if (this.eval != null && this.isScriptExecuting()) {
            return;
        }
        this.loadShape(34);
        this.setShapeProperty(34, "xy", P3i.new3(n, n2, 0));
        this.setShapeProperty(34, "target", null);
        this.setShapeProperty(34, "specialLabel", null);
        this.setShapeProperty(34, "text", string);
        this.hoverAtomIndex = -1;
        this.hoverText = string;
        if (string2 != null && p3 != null) {
            this.setStatusObjectHovered(string2, string, p3);
        }
        this.refresh(3, "hover on point");
    }

    void hoverOff() {
        try {
            boolean bl;
            if (this.global.modelKitMode) {
                this.highlight(null);
            }
            if (!this.hoverEnabled) {
                return;
            }
            boolean bl2 = bl = this.hoverText != null || this.hoverAtomIndex >= 0;
            if (this.hoverAtomIndex >= 0) {
                this.setShapeProperty(34, "target", null);
                this.hoverAtomIndex = -1;
            }
            if (this.hoverText != null) {
                this.setShapeProperty(34, "text", null);
                this.hoverText = null;
            }
            this.setShapeProperty(34, "specialLabel", null);
            if (bl) {
                this.refresh(3, "hover off");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getBfactor100Hi() {
        return this.modelSet.getBfactor100Hi();
    }

    short getColix(Object object) {
        return C.getColixO(object);
    }

    @Override
    public void setDebugScript(boolean bl) {
        this.global.debugScript = bl;
        this.global.setB("debugScript", bl);
        if (this.eval != null) {
            this.eval.setDebugging();
        }
    }

    void clearClickCount() {
        this.setTainted(true);
    }

    public int getCursor() {
        return this.currentCursor;
    }

    public void setCursor(int n) {
        if (this.isKiosk || this.currentCursor == n || this.multiTouch || !this.haveDisplay) {
            return;
        }
        this.currentCursor = n;
        this.apiPlatform.setCursor(this.currentCursor, this.display);
    }

    void setPickingMode(String string, int n) {
        if (!this.haveDisplay) {
            return;
        }
        this.showSelected = false;
        String string2 = null;
        if (string != null) {
            int n2 = string.indexOf("_");
            if (n2 >= 0) {
                string2 = string.substring(n2 + 1);
                string = string.substring(0, n2);
            }
            n = ActionManager.getPickingMode(string);
        }
        if (n < 0) {
            n = 1;
        }
        this.actionManager.setPickingMode(n);
        this.global.setS("picking", ActionManager.getPickingModeName(this.actionManager.getAtomPickingMode()));
        if (string2 == null || string2.length() == 0) {
            return;
        }
        string2 = Character.toUpperCase(string2.charAt(0)) + (string2.length() == 1 ? "" : string2.substring(1, 2));
        switch (n) {
            case 32: {
                this.setAtomPickingOption(string2);
                break;
            }
            case 33: {
                this.setBondPickingOption(string2);
                break;
            }
            default: {
                Logger.error("Bad picking mode: " + string + "_" + string2);
            }
        }
    }

    public int getPickingMode() {
        return this.haveDisplay ? this.actionManager.getAtomPickingMode() : 0;
    }

    void setPickingStyle(String string, int n) {
        if (!this.haveDisplay) {
            return;
        }
        if (string != null) {
            n = ActionManager.getPickingStyleIndex(string);
        }
        if (n < 0) {
            n = 0;
        }
        this.actionManager.setPickingStyle(n);
        this.global.setS("pickingStyle", ActionManager.getPickingStyleName(this.actionManager.getPickingStyle()));
    }

    public boolean getDrawHover() {
        return this.haveDisplay && this.global.drawHover;
    }

    @Override
    public String getAtomInfo(int n) {
        return n >= 0 ? this.modelSet.getAtomInfo(n, null) : (String)this.shapeManager.getShapePropertyIndex(6, "pointInfo", -n);
    }

    public String getAtomInfoXYZ(int n, boolean bl) {
        return this.modelSet.getAtomInfoXYZ(n, bl);
    }

    private void setSync() {
        if (this.statusManager.doSync()) {
            this.statusManager.setSync(null);
        }
    }

    @Override
    public void setJmolCallbackListener(JmolCallbackListener jmolCallbackListener) {
        this.statusManager.setJmolCallbackListener(jmolCallbackListener);
    }

    @Override
    public void setJmolStatusListener(JmolStatusListener jmolStatusListener) {
        this.statusManager.setJmolStatusListener(jmolStatusListener, null);
    }

    public Map<String, javajs.util.List<javajs.util.List<Object>>> getMessageQueue() {
        return this.statusManager.getMessageQueue();
    }

    public javajs.util.List<javajs.util.List<javajs.util.List<Object>>> getStatusChanged(String string) {
        return string == null ? null : this.statusManager.getStatusChanged(string);
    }

    public boolean menuEnabled() {
        return !this.global.disablePopupMenu && this.getPopupMenu() != null;
    }

    void popupMenu(int n, int n2, char c) {
        if (!this.haveDisplay || !this.refreshing || this.isPreviewOnly || this.global.disablePopupMenu) {
            return;
        }
        switch (c) {
            case 'j': {
                try {
                    this.getPopupMenu();
                    this.jmolpopup.jpiShow(n, n2);
                }
                catch (Throwable throwable) {
                    this.global.disablePopupMenu = true;
                }
                break;
            }
            case 'a': 
            case 'b': 
            case 'm': {
                this.modelkitPopup = this.apiPlatform.getMenuPopup(null, c);
                if (this.modelkitPopup == null) break;
                this.modelkitPopup.jpiShow(n, n2);
            }
        }
    }

    public String getMenu(String string) {
        this.getPopupMenu();
        if (string.equals("\u0000")) {
            this.popupMenu(this.dimScreen.width - 120, 0, 'j');
            return "OK";
        }
        return this.jmolpopup == null ? "" : this.jmolpopup.jpiGetMenuAsString("Jmol version " + Viewer.getJmolVersion() + "|_GET_MENU|" + string);
    }

    private Object getPopupMenu() {
        if (this.jmolpopup == null) {
            GenericMenuInterface genericMenuInterface = this.jmolpopup = this.allowScripting ? this.apiPlatform.getMenuPopup(this.menuStructure, 'j') : null;
            if (this.jmolpopup == null) {
                this.global.disablePopupMenu = true;
                return null;
            }
        }
        return this.jmolpopup.jpiGetMenuAsObject();
    }

    public void setMenu(String string, boolean bl) {
        if (bl) {
            Logger.info("Setting menu " + (string.length() == 0 ? "to Jmol defaults" : "from file " + string));
        }
        if (string.length() == 0) {
            string = null;
        } else if (bl) {
            string = this.getFileAsString(string);
        }
        this.getProperty("DATA_API", "setMenu", string);
        this.statusManager.setCallbackFunction("menu", string);
    }

    void setStatusFrameChanged(boolean bl, boolean bl2) {
        String string;
        String string2;
        int n;
        if (bl) {
            this.prevFrame = Integer.MIN_VALUE;
        }
        int n2 = this.animationManager.getCurrentModelIndex();
        this.transformManager.setVibrationPeriod(Float.NaN);
        int n3 = this.animationManager.firstFrameIndex;
        int n4 = this.animationManager.lastFrameIndex;
        boolean bl3 = this.isMovie();
        int n5 = this.animationManager.currentModelIndex;
        if (n3 == n4 && !bl3) {
            n5 = n3;
        }
        int n6 = this.getModelFileNumber(n5);
        int n7 = this.animationManager.getCurrentModelIndex();
        int n8 = n6;
        int n9 = n6 % 1000000;
        int n10 = bl3 ? n3 : this.getModelFileNumber(n3);
        int n11 = n = bl3 ? n4 : this.getModelFileNumber(n4);
        if (bl3) {
            string2 = "" + (n2 + 1);
        } else if (n8 == 0) {
            string2 = this.getModelNumberDotted(n3);
            if (n3 != n4) {
                string2 = string2 + " - " + this.getModelNumberDotted(n4);
            }
            if (n10 / 1000000 == n / 1000000) {
                n8 = n10;
            }
        } else {
            string2 = this.getModelNumberDotted(n5);
        }
        if (n8 != 0) {
            int n12 = n8 = n8 < 1000000 ? 1 : n8 / 1000000;
        }
        if (!bl3) {
            this.global.setI("_currentFileNumber", n8);
            this.global.setI("_currentModelNumberInFile", n9);
        }
        this.global.setI("_currentFrame", n7);
        this.global.setI("_morphCount", this.animationManager.morphCount);
        this.global.setF("_currentMorphFrame", this.animationManager.currentMorphModel);
        this.global.setI("_frameID", n6);
        this.global.setS("_modelNumber", string2);
        this.global.setS("_modelName", n5 < 0 ? "" : this.getModelName(n5));
        String string3 = n5 < 0 ? "" : this.getModelTitle(n5);
        this.global.setS("_modelTitle", string3 == null ? "" : string3);
        this.global.setS("_modelFile", n5 < 0 ? "" : this.modelSet.getModelFileName(n5));
        this.global.setS("_modelType", n5 < 0 ? "" : this.modelSet.getModelFileType(n5));
        if (n7 == this.prevFrame) {
            return;
        }
        this.prevFrame = n7;
        if (bl3) {
            string = "" + (this.animationManager.getCurrentModelIndex() + 1);
        } else {
            String string4;
            string = this.getModelName(n2);
            if (!string.equals(string4 = "" + this.getModelNumberDotted(n2))) {
                string = string4 + ": " + string;
            }
            if (string.length() > 50) {
                string = string.substring(0, 45) + "...";
            }
        }
        this.statusManager.setStatusFrameChanged(n2, n8, n9, this.animationManager.animationDirection < 0 ? -n10 : n10, this.animationManager.currentDirection < 0 ? -n : n, n7, string);
        if (this.doHaveJDX()) {
            this.getJSV().setModel(n5);
        }
    }

    private boolean doHaveJDX() {
        return this.haveJDX || (this.haveJDX = this.getBooleanProperty("_JSpecView".toLowerCase()));
    }

    private JmolJSpecView getJSV() {
        if (this.jsv == null) {
            this.jsv = (JmolJSpecView)Interface.getOptionInterface("viewer.JSpecView");
            this.jsv.setViewer(this);
        }
        return this.jsv;
    }

    public int getJDXBaseModelIndex(int n) {
        if (!this.doHaveJDX()) {
            return n;
        }
        return this.getJSV().getBaseModelIndex(n);
    }

    public Object getJspecViewProperties(Object object) {
        Map<String, Object> map = this.statusManager.getJspecViewProperties("" + object);
        if (map != null) {
            this.haveJDX = true;
        }
        return map;
    }

    public void scriptEcho(String string) {
        if (!Logger.isActiveLevel(4)) {
            return;
        }
        this.statusManager.setScriptEcho(string, this.isScriptQueued());
        if (this.listCommands && string != null && string.indexOf("$[") == 0) {
            Logger.info(string);
        }
    }

    private boolean isScriptQueued() {
        return this.scriptManager != null && this.scriptManager.isScriptQueued();
    }

    public void notifyError(String string, String string2, String string3) {
        this.global.setS("_errormessage", string3);
        this.statusManager.notifyError(string, string2, string3);
    }

    public String jsEval(String string) {
        return this.statusManager.jsEval(string);
    }

    public void setStatusAtomHovered(int n, String string) {
        this.global.setI("_atomhovered", n);
        this.statusManager.setStatusAtomHovered(n, string);
    }

    public void setStatusObjectHovered(String string, String string2, P3 p3) {
        this.global.setS("_objecthovered", string);
        this.statusManager.setStatusObjectHovered(string, string2, p3);
    }

    private void setFileLoadStatus(EnumFileStatus enumFileStatus, String string, String string2, String string3, String string4, Boolean bl) {
        boolean bl2;
        this.setErrorMessage(string4, null);
        this.global.setI("_loadPoint", enumFileStatus.getCode());
        boolean bl3 = bl2 = enumFileStatus != EnumFileStatus.CREATING_MODELSET;
        if (bl2) {
            this.setStatusFrameChanged(false, false);
        }
        this.statusManager.setFileLoadStatus(string, string2, string3, string4, enumFileStatus.getCode(), bl2, bl);
        if (bl2 && this.doHaveJDX()) {
            this.getJSV().setModel(this.getCurrentModelIndex());
        }
    }

    public String getZapName() {
        return this.global.modelKitMode ? "Jmol Model Kit" : "zapped";
    }

    public void setStatusMeasuring(String string, int n, String string2, float f) {
        this.statusManager.setStatusMeasuring(string, n, string2, f);
    }

    public void notifyMinimizationStatus() {
        Object object = this.getParameter("_minimizationStep");
        String string = (String)this.getParameter("_minimizationForceField");
        this.statusManager.notifyMinimizationStatus((String)this.getParameter("_minimizationStatus"), object instanceof String ? Integer.valueOf(0) : (Integer)object, (Float)this.getParameter("_minimizationEnergy"), object.toString().equals("0") ? Float.valueOf(0.0f) : (Float)this.getParameter("_minimizationEnergyDiff"), string);
    }

    public void setStatusAtomPicked(int n, String string) {
        if (string == null) {
            string = this.global.pickLabel;
            string = string.length() == 0 ? this.getAtomInfoXYZ(n, this.global.messageStyleChime) : this.modelSet.getAtomInfo(n, string);
        }
        this.global.setPicked(n);
        this.global.setS("_pickinfo", string);
        this.statusManager.setStatusAtomPicked(n, string);
        int n2 = this.statusManager.getSyncMode();
        if (n2 != 1 || !this.doHaveJDX()) {
            return;
        }
        this.getJSV().atomPicked(n);
    }

    public void setStatusResized(int n, int n2) {
        this.statusManager.setStatusResized(n, n2);
    }

    public void scriptStatus(String string) {
        this.setScriptStatus(string, "", 0, null);
    }

    public void scriptStatusMsg(String string, String string2) {
        this.setScriptStatus(string, string2, 0, null);
    }

    public void setScriptStatus(String string, String string2, int n, String string3) {
        this.statusManager.setScriptStatus(string, string2, n, string3);
    }

    private String getModelTitle(int n) {
        return this.modelSet == null ? null : this.modelSet.getModelTitle(n);
    }

    @Override
    public String getModelFileName(int n) {
        return this.modelSet == null ? null : this.modelSet.getModelFileName(n);
    }

    String dialogAsk(String string, String string2) {
        return this.isKiosk || !this.haveAccess(ACCESS.ALL) ? null : this.statusManager.dialogAsk(string, string2);
    }

    @Override
    public void showUrl(String string) {
        if (string == null) {
            return;
        }
        if (string.indexOf(":") < 0) {
            String string2 = this.fileManager.getAppletDocumentBase();
            if (string2 == "") {
                string2 = this.fileManager.getFullPathName();
            }
            if (string2.indexOf("/") >= 0) {
                string2 = string2.substring(0, string2.lastIndexOf("/") + 1);
            } else if (string2.indexOf("\\") >= 0) {
                string2 = string2.substring(0, string2.lastIndexOf("\\") + 1);
            }
            string = string2 + string;
        }
        Logger.info("showUrl:" + string);
        this.statusManager.showUrl(string);
    }

    public void setMeshCreator(Object object) {
        this.loadShape(24);
        this.setShapeProperty(24, "meshCreator", object);
    }

    public void showConsole(boolean bl) {
        if (!this.haveDisplay) {
            return;
        }
        try {
            if (this.appConsole == null && bl) {
                this.getProperty("DATA_API", "getAppConsole", Boolean.TRUE);
            }
            this.appConsole.setVisible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void clearConsole() {
        this.statusManager.clearConsole();
    }

    public Object getParameterEscaped(String string) {
        return this.global.getParameterEscaped(string, 0);
    }

    @Override
    public Object getParameter(String string) {
        return this.global.getParameter(string);
    }

    public SV getOrSetNewVariable(String string, boolean bl) {
        return this.global.getOrSetNewVariable(string, bl);
    }

    public SV setUserVariable(String string, SV sV) {
        return this.global.setUserVariable(string, sV);
    }

    public void unsetProperty(String string) {
        if ((string = string.toLowerCase()).equals("all") || string.equals("variables")) {
            this.fileManager.setPathForAllFiles("");
        }
        this.global.unsetUserVariable(string);
    }

    public Object getVariableList() {
        return this.global.getVariableList();
    }

    @Override
    public void notifyStatusReady(boolean bl) {
        System.out.println("Jmol applet " + this.fullName + (bl ? " ready" : " destroyed"));
        if (!bl) {
            this.setModeMouse(-1);
        }
        this.statusManager.setStatusAppletReady(this.fullName, bl);
    }

    @Override
    public boolean getBooleanProperty(String string) {
        if (this.global.htBooleanParameterFlags.containsKey(string = string.toLowerCase())) {
            return this.global.htBooleanParameterFlags.get(string);
        }
        if (string.endsWith("p!")) {
            if (this.actionManager == null) {
                return false;
            }
            String string2 = this.actionManager.getPickingState().toLowerCase();
            return string2.indexOf(string = string.substring(0, string.length() - 2) + ";") >= 0;
        }
        if (string.equalsIgnoreCase("executionPaused")) {
            return this.eval != null && this.eval.isPaused();
        }
        if (string.equalsIgnoreCase("executionStepping")) {
            return this.eval != null && this.eval.isStepping();
        }
        if (string.equalsIgnoreCase("haveBFactors")) {
            return this.modelSet.getBFactors() != null;
        }
        if (string.equalsIgnoreCase("colorRasmol")) {
            return this.colorManager.getDefaultColorRasmol();
        }
        if (string.equalsIgnoreCase("frank")) {
            return this.getShowFrank();
        }
        if (string.equalsIgnoreCase("spinOn")) {
            return this.getSpinOn();
        }
        if (string.equalsIgnoreCase("isNavigating")) {
            return this.isNavigating();
        }
        if (string.equalsIgnoreCase("showSelections")) {
            return this.modelSet.getSelectionHaloEnabled();
        }
        if (this.global.htUserVariables.containsKey(string)) {
            SV sV = this.global.getUserVariable(string);
            if (sV.tok == 0x10000D) {
                return true;
            }
            if (sV.tok == 0x10000C) {
                return false;
            }
        }
        Logger.error("viewer.getBooleanProperty(" + string + ") - unrecognized");
        return false;
    }

    @Override
    public int getInt(int n) {
        switch (n) {
            case 553648132: {
                return this.animationManager.animationFps;
            }
            case 553648143: {
                return this.global.dotDensity;
            }
            case 0x21000010: {
                return this.global.dotScale;
            }
            case 0x21000012: {
                return this.global.helixStep;
            }
            case 553648151: {
                return this.global.meshScale;
            }
            case 553648153: {
                return this.global.minPixelSelRadius;
            }
            case 553648154: {
                return this.global.percentVdwAtom;
            }
            case 553648157: {
                return this.global.pickingSpinRate;
            }
            case 553648158: {
                return this.global.platformSpeed;
            }
            case 553648166: {
                return this.global.ribbonAspectRatio;
            }
            case 0x2000000A: {
                return this.global.scriptDelay;
            }
            case 553648170: {
                return this.global.smallMoleculeMaxAtoms;
            }
            case 553648184: {
                return this.global.strutSpacing;
            }
        }
        Logger.error("viewer.getInt(" + T.nameOf(n) + ") - not listed");
        return 0;
    }

    public int getDelayMaximumMs() {
        return this.haveDisplay ? this.global.delayMaximumMs : 1;
    }

    public int getHermiteLevel() {
        return this.getSpinOn() ? 0 : this.global.hermiteLevel;
    }

    public int getHoverDelay() {
        return this.global.modelKitMode ? 20 : this.global.hoverDelayMs;
    }

    @Override
    public boolean getBoolean(int n) {
        switch (n) {
            case 1074790662: {
                return this.modelSet.getModelSetAuxiliaryInfoBoolean("isPDB");
            }
            case 0x24000004: {
                return this.global.allowGestures;
            }
            case 603979784: {
                return this.global.allowMultiTouch;
            }
            case 603979785: {
                return this.global.allowRotateSelected;
            }
            case 603979792: {
                return this.global.appendNew;
            }
            case 603979794: {
                return this.global.applySymmetryToBonds;
            }
            case 603979796: {
                return this.global.atomPicking;
            }
            case 603979798: {
                return this.global.autoBond;
            }
            case 603979800: {
                return this.global.autoFps;
            }
            case 603979806: {
                return this.global.axesOrientationRasmol;
            }
            case 0x24000024: {
                return this.global.bondModeOr;
            }
            case 603979817: {
                return this.global.cartoonBaseEdges;
            }
            case 603979819: {
                return this.global.cartoonFancy;
            }
            case 603979820: {
                return this.global.cartoonLadders;
            }
            case 603979818: {
                return this.global.cartoonRockets;
            }
            case 603979822: {
                return this.global.chainCaseSensitive || this.chainList.size() > 0;
            }
            case 603979824: {
                return this.global.debugScript;
            }
            case 603979825: {
                return this.global.defaultStructureDSSP;
            }
            case 603979826: {
                return this.global.disablePopupMenu;
            }
            case 603979828: {
                return this.global.displayCellParameters;
            }
            case 603979830: {
                return this.global.dotSurface;
            }
            case 603979829: {
                return this.global.dotsSelectedOnly;
            }
            case 603979833: {
                return this.global.drawPicking;
            }
            case 0x24000044: {
                return this.global.fontCaching;
            }
            case 603979845: {
                return this.global.fontScaling;
            }
            case 603979846: {
                return this.global.forceAutoBond;
            }
            case 603979848: {
                return this.global.fractionalRelative;
            }
            case 603979850: {
                return this.global.greyscaleRendering;
            }
            case 603979852: {
                return this.global.hbondsBackbone;
            }
            case 603979853: {
                return this.global.hbondsRasmol;
            }
            case 603979854: {
                return this.global.hbondsSolid;
            }
            case 0x60300006: {
                return this.global.rasmolHeteroSetting;
            }
            case 603979858: {
                return this.global.hideNameInPopup;
            }
            case 603979864: {
                return this.global.highResolutionFlag;
            }
            case 1613758476: {
                return this.global.rasmolHydrogenSetting;
            }
            case 603979870: {
                return this.global.isosurfaceKey;
            }
            case 603979872: {
                return this.global.justifyMeasurements;
            }
            case 603979874: {
                return this.global.legacyAutoBonding;
            }
            case 603979875: {
                return this.global.legacyHAddition;
            }
            case 603979877: {
                return this.global.logGestures;
            }
            case 603979878: {
                return this.global.measureAllModels;
            }
            case 603979879: {
                return this.global.measurementLabels;
            }
            case 603979880: {
                return this.global.messageStyleChime;
            }
            case 603979883: {
                return this.global.modelKitMode;
            }
            case 603979887: {
                return this.global.navigationMode;
            }
            case 603979888: {
                return this.global.navigationPeriodic;
            }
            case 603979889: {
                return this.global.partialDots;
            }
            case 603979892: {
                return this.global.pdbSequential;
            }
            case 603979894: {
                return this.global.preserveState;
            }
            case 603979898: {
                return this.global.ribbonBorder;
            }
            case 603979900: {
                return this.global.rocketBarrels;
            }
            case 603979906: {
                return this.global.selectAllModels;
            }
            case 603979920: {
                return this.global.showHiddenSelectionHalos;
            }
            case 603979922: {
                return this.global.showHydrogens;
            }
            case 603979926: {
                return this.global.showMeasurements;
            }
            case 603979928: {
                return this.global.showMultipleBonds;
            }
            case 603979934: {
                return this.global.showTiming;
            }
            case 603979938: {
                return this.global.slabByAtom;
            }
            case 603979940: {
                return this.global.slabByMolecule;
            }
            case 603979944: {
                return this.global.smartAromatic;
            }
            case 1613758488: {
                return this.global.solventOn;
            }
            case 603979952: {
                return this.global.ssbondsBackbone;
            }
            case 603979955: {
                return this.global.strutsMultiple;
            }
            case 603979966: {
                return this.global.traceAlpha;
            }
            case 603979967: {
                return this.global.translucent;
            }
            case 603979968: {
                return this.global.twistedSheets;
            }
            case 603979973: {
                return this.global.vectorSymmetry;
            }
            case 603979974: {
                return this.global.waitForMoveTo;
            }
            case 603979978: {
                return this.global.zeroBasedXyzRasmol;
            }
        }
        Logger.error("viewer.getBoolean(" + T.nameOf(n) + ") - not listed");
        return false;
    }

    public boolean allowEmbeddedScripts() {
        return this.global.allowEmbeddedScripts && !this.isPreviewOnly;
    }

    boolean getDragSelected() {
        return this.global.dragSelected && !this.global.modelKitMode;
    }

    boolean getBondPicking() {
        return this.global.bondPicking || this.global.modelKitMode;
    }

    public boolean useMinimizationThread() {
        return this.global.useMinimizationThread && !this.autoExit;
    }

    @Override
    public float getFloat(int n) {
        switch (n) {
            case 0x44100001: {
                return this.global.particleRadius;
            }
            case 0x22000002: {
                return this.global.axesScale;
            }
            case 0x22000004: {
                return this.global.bondTolerance;
            }
            case 0x2200000A: {
                return this.global.defaultTranslucent;
            }
            case 0x22000008: {
                return this.global.defaultDrawArrowScale;
            }
            case 0x2200000B: {
                return this.global.dipoleScale;
            }
            case 0x2200000C: {
                return this.global.drawFontSize;
            }
            case 0x2200000E: {
                return this.global.exportScale;
            }
            case 0x22000010: {
                return this.global.hbondsAngleMinimum;
            }
            case 0x22000011: {
                return this.global.hbondsDistanceMaximum;
            }
            case 570425363: {
                return this.global.loadAtomDataTolerance;
            }
            case 570425364: {
                return this.global.minBondDistance;
            }
            case 1276121113: {
                return this.global.modulationScale;
            }
            case 570425370: {
                return this.global.multipleBondSpacing;
            }
            case 570425369: {
                return this.global.multipleBondRadiusFactor;
            }
            case 570425374: {
                return this.global.navigationSpeed;
            }
            case 0x22000026: {
                return this.global.pointGroupDistanceTolerance;
            }
            case 0x22000028: {
                return this.global.pointGroupLinearTolerance;
            }
            case 0x2200002C: {
                return this.transformManager.getRotationRadius();
            }
            case 0x22000030: {
                return this.global.sheetSmoothing;
            }
            case 0x22000032: {
                return this.global.solventProbeRadius;
            }
            case 570425403: {
                return this.global.starScale;
            }
            case 570425406: {
                return this.global.strutDefaultRadius;
            }
            case 0x22000040: {
                return this.global.strutLengthMaximum;
            }
            case 1649410049: {
                return this.global.vectorScale;
            }
            case 0x22000044: {
                return this.global.vibrationPeriod;
            }
        }
        Logger.error("viewer.getFloat(" + T.nameOf(n) + ") - not listed");
        return 0.0f;
    }

    @Override
    public void setStringProperty(String string, String string2) {
        if (string2 == null) {
            return;
        }
        if (string.charAt(0) == '_') {
            this.global.setS(string, string2);
            return;
        }
        int n = T.getTokFromName(string);
        switch (T.getParamType(n)) {
            case 0x24000000: {
                this.setBooleanPropertyTok(string, n, SV.newV(4, string2).asBoolean());
                break;
            }
            case 0x21000000: {
                this.setIntPropertyTok(string, n, SV.newV(4, string2).asInt());
                break;
            }
            case 0x22000000: {
                this.setFloatPropertyTok(string, n, PT.parseFloat(string2));
                break;
            }
            default: {
                this.setStringPropertyTok(string, n, string2);
            }
        }
    }

    private void setStringPropertyTok(String string, int n, String string2) {
        switch (n) {
            case 545259521: {
                this.setAnimationMode(string2);
                return;
            }
            case 545259569: {
                this.global.nmrPredictFormat = string2;
                break;
            }
            case 545259548: {
                this.global.defaultDropScript = string2;
                break;
            }
            case 545259571: {
                string2 = this.fileManager.setPathForAllFiles(string2);
                break;
            }
            case 545259558: {
                this.setUnits(string2, false);
                return;
            }
            case 0x20800028: {
                string2 = "UFF".equalsIgnoreCase(string2) ? "UFF" : "MMFF";
                this.global.forceField = string2;
                this.minimizer = null;
                break;
            }
            case 545259570: {
                this.global.nmrUrlFormat = string2;
                break;
            }
            case 545259568: {
                this.setUnits(string2, true);
                return;
            }
            case 545259566: {
                this.global.loadLigandFormat = string2;
                break;
            }
            case 545259543: {
                this.global.defaultLabelPDB = string2;
                break;
            }
            case 545259544: {
                this.global.defaultLabelXYZ = string2;
                break;
            }
            case 545259549: {
                this.global.defaultLoadFilter = string2;
                break;
            }
            case 545259567: {
                string2 = this.getOutputManager().setLogFile(string2);
                if (string2 != null) break;
                return;
            }
            case 545259559: {
                break;
            }
            case 545259524: {
                this.global.atomTypes = string2;
                break;
            }
            case 545259538: {
                break;
            }
            case 545259576: {
                this.global.pickLabel = string2;
                break;
            }
            case 545259580: {
                this.global.quaternionFrame = string2.length() == 2 && string2.startsWith("R") ? string2.substring(0, 2) : "" + (string2.toLowerCase() + "p").charAt(0);
                if (!PT.isOneOf(this.global.quaternionFrame, "RC;RP;a;b;c;n;p;q;x;")) {
                    this.global.quaternionFrame = "p";
                }
                this.modelSet.setHaveStraightness(false);
                break;
            }
            case 545259555: {
                this.setVdwStr(string2);
                return;
            }
            case 545259564: {
                new GT(this, string2);
                this.language = GT.getLanguage();
                this.modelkitPopup = null;
                if (this.jmolpopup != null) {
                    this.jmolpopup.jpiDispose();
                    this.jmolpopup = null;
                    this.getPopupMenu();
                }
                this.statusManager.setCallbackFunction("language", this.language);
                string2 = GT.getLanguage();
                break;
            }
            case 545259565: {
                this.global.loadFormat = string2;
                break;
            }
            case 545259534: {
                this.setObjectColor("background", string2);
                return;
            }
            case 0x20800008: {
                this.setObjectColor("axis1", string2);
                return;
            }
            case 545259530: {
                this.setObjectColor("axis2", string2);
                return;
            }
            case 545259532: {
                this.setObjectColor("axis3", string2);
                return;
            }
            case 545259536: {
                this.setObjectColor("boundbox", string2);
                return;
            }
            case 545259586: {
                this.setObjectColor("unitcell", string2);
                return;
            }
            case 545259578: {
                this.setPropertyColorScheme(string2, false, false);
                break;
            }
            case 545259562: {
                this.setShapeProperty(34, "atomLabel", string2);
                break;
            }
            case 545259547: {
                this.global.defaultDistanceLabel = string2;
                break;
            }
            case 545259542: {
                this.global.defaultAngleLabel = string2;
                break;
            }
            case 0x20800022: {
                this.global.defaultTorsionLabel = string2;
                break;
            }
            case 545259550: {
                this.global.defaultLoadScript = string2;
                break;
            }
            case 0x20800002: {
                this.fileManager.setAppletProxy(string2);
                break;
            }
            case 545259546: {
                if (string2 == null) {
                    string2 = "";
                }
                this.global.defaultDirectory = string2 = string2.replace('\\', '/');
                break;
            }
            case 545259561: {
                this.global.helpPath = string2;
                break;
            }
            case 0x20800020: {
                if (!string2.equalsIgnoreCase("RasMol") && !string2.equalsIgnoreCase("PyMOL")) {
                    string2 = "Jmol";
                }
                this.setDefaultsType(string2);
                break;
            }
            case 545259545: {
                this.setDefaultColors(string2.equalsIgnoreCase("rasmol"));
                return;
            }
            case 545259572: {
                this.setPickingMode(string2, 0);
                return;
            }
            case 545259574: {
                this.setPickingStyle(string2, 0);
                return;
            }
            case 545259540: {
                break;
            }
            default: {
                if (string.toLowerCase().endsWith("callback")) {
                    this.statusManager.setCallbackFunction(string, string2.length() == 0 || string2.equalsIgnoreCase("none") ? null : string2);
                    break;
                }
                if (this.global.htNonbooleanParameterValues.containsKey(string.toLowerCase())) break;
                this.global.setUserVariable(string, SV.newV(4, string2));
                return;
            }
        }
        this.global.setS(string, string2);
    }

    @Override
    public void setFloatProperty(String string, float f) {
        if (Float.isNaN(f)) {
            return;
        }
        if (string.charAt(0) == '_') {
            this.global.setF(string, f);
            return;
        }
        int n = T.getTokFromName(string);
        switch (T.getParamType(n)) {
            case 0x20800000: {
                this.setStringPropertyTok(string, n, "" + f);
                break;
            }
            case 0x24000000: {
                this.setBooleanPropertyTok(string, n, f != 0.0f);
                break;
            }
            case 0x21000000: {
                this.setIntPropertyTok(string, n, (int)f);
                break;
            }
            default: {
                this.setFloatPropertyTok(string, n, f);
            }
        }
    }

    private void setFloatPropertyTok(String string, int n, float f) {
        switch (n) {
            case 570425366: {
                this.modelSet.setModulation(null, false, null, false);
                this.global.modulationScale = Math.max(1.0f, f);
                this.modelSet.setModulation(null, true, null, false);
                break;
            }
            case 0x22000025: {
                this.global.particleRadius = Math.abs(f);
                break;
            }
            case 0x2200000C: {
                this.global.drawFontSize = f;
                break;
            }
            case 0x2200000E: {
                this.global.exportScale = f;
                break;
            }
            case 570425403: {
                this.global.starScale = f;
                break;
            }
            case 570425369: {
                this.global.multipleBondRadiusFactor = f;
                break;
            }
            case 570425370: {
                this.global.multipleBondSpacing = f;
                break;
            }
            case 570425393: {
                this.transformManager.setSlabRange(f);
                break;
            }
            case 570425365: {
                this.global.minimizationCriterion = f;
                break;
            }
            case 0x2200000F: {
                if (!this.haveDisplay) break;
                this.actionManager.setGestureSwipeFactor(f);
                break;
            }
            case 570425367: {
                if (!this.haveDisplay) break;
                this.actionManager.setMouseDragFactor(f);
                break;
            }
            case 570425368: {
                if (!this.haveDisplay) break;
                this.actionManager.setMouseWheelFactor(f);
                break;
            }
            case 0x22000040: {
                this.global.strutLengthMaximum = f;
                break;
            }
            case 570425406: {
                this.global.strutDefaultRadius = f;
                break;
            }
            case 0x22000020: {
                this.setSpin("X", (int)f);
                break;
            }
            case 0x22000022: {
                this.setSpin("Y", (int)f);
                break;
            }
            case 0x22000024: {
                this.setSpin("Z", (int)f);
                break;
            }
            case 570425371: {
                if (Float.isNaN(f)) {
                    return;
                }
                this.setSpin("FPS", (int)f);
                break;
            }
            case 570425363: {
                this.global.loadAtomDataTolerance = f;
                break;
            }
            case 0x22000010: {
                this.global.hbondsAngleMinimum = f;
                break;
            }
            case 0x22000011: {
                this.global.hbondsDistanceMaximum = f;
                break;
            }
            case 0x22000026: {
                this.global.pointGroupDistanceTolerance = f;
                break;
            }
            case 0x22000028: {
                this.global.pointGroupLinearTolerance = f;
                break;
            }
            case 0x2200000D: {
                this.global.ellipsoidAxisDiameter = f;
                break;
            }
            case 570425398: {
                this.setSpin("x", (int)f);
                break;
            }
            case 570425400: {
                this.setSpin("y", (int)f);
                break;
            }
            case 570425402: {
                this.setSpin("z", (int)f);
                break;
            }
            case 570425396: {
                this.setSpin("fps", (int)f);
                break;
            }
            case 0x22000008: {
                this.global.defaultDrawArrowScale = f;
                break;
            }
            case 0x2200000A: {
                this.global.defaultTranslucent = f;
                break;
            }
            case 0x22000002: {
                this.setAxesScale(f);
                break;
            }
            case 570425416: {
                this.transformManager.setVisualRange(f);
                this.refresh(1, "set visualRange");
                break;
            }
            case 570425372: {
                this.setNavigationDepthPercent(f);
                break;
            }
            case 570425374: {
                this.global.navigationSpeed = f;
                break;
            }
            case 570425373: {
                this.transformManager.setNavigationSlabOffsetPercent(f);
                break;
            }
            case 0x22000006: {
                this.transformManager.setCameraDepthPercent(f, false);
                this.refresh(1, "set cameraDepth");
                return;
            }
            case 0x2200002C: {
                this.setRotationRadius(f, true);
                return;
            }
            case 0x22000012: {
                this.global.hoverDelayMs = (int)(f * 1000.0f);
                break;
            }
            case 0x22000030: {
                this.global.sheetSmoothing = f;
                break;
            }
            case 0x2200000B: {
                this.global.dipoleScale = f = Viewer.checkFloatRange(f, -10.0f, 10.0f);
                break;
            }
            case 570425404: {
                this.transformManager.setStereoDegrees(f);
                break;
            }
            case 1649410049: {
                this.setVectorScale(f);
                return;
            }
            case 0x22000044: {
                this.setVibrationPeriod(f);
                return;
            }
            case 570425414: {
                this.setVibrationScale(f);
                return;
            }
            case 0x22000004: {
                this.setBondTolerance(f);
                return;
            }
            case 570425364: {
                this.setMinBondDistance(f);
                return;
            }
            case 0x2200002E: {
                this.transformManager.setScaleAngstromsPerInch(f);
                break;
            }
            case 0x22000032: {
                this.global.solventProbeRadius = f = Viewer.checkFloatRange(f, 0.0f, 10.0f);
                break;
            }
            default: {
                if (this.global.htNonbooleanParameterValues.containsKey(string.toLowerCase())) break;
                this.global.setUserVariable(string, SV.newV(3, Float.valueOf(f)));
                return;
            }
        }
        this.global.setF(string, f);
    }

    @Override
    public void setIntProperty(String string, int n) {
        if (n == Integer.MIN_VALUE) {
            return;
        }
        if (string.charAt(0) == '_') {
            this.global.setI(string, n);
            return;
        }
        int n2 = T.getTokFromName(string);
        switch (T.getParamType(n2)) {
            case 0x20800000: {
                this.setStringPropertyTok(string, n2, "" + n);
                break;
            }
            case 0x24000000: {
                this.setBooleanPropertyTok(string, n2, n != 0);
                break;
            }
            case 0x22000000: {
                this.setFloatPropertyTok(string, n2, n);
                break;
            }
            default: {
                this.setIntPropertyTok(string, n2, n);
            }
        }
    }

    private void setIntPropertyTok(String string, int n, int n2) {
        switch (n) {
            case 553648137: {
                this.global.celShadingPower = n2;
                this.gdata.setCelPower(n2);
                break;
            }
            case 0x21000001: {
                this.gdata.setAmbientOcclusion(n2);
                break;
            }
            case 553648158: {
                this.global.platformSpeed = Math.min(Math.max(n2, 0), 10);
                break;
            }
            case 553648151: {
                this.global.meshScale = n2;
                break;
            }
            case 553648153: {
                this.global.minPixelSelRadius = n2;
                break;
            }
            case 553648149: {
                this.global.isosurfacePropertySmoothingPower = n2;
                break;
            }
            case 553648165: {
                this.global.repaintWaitMs = n2;
                break;
            }
            case 553648170: {
                this.global.smallMoleculeMaxAtoms = n2;
                break;
            }
            case 553648152: {
                this.global.minimizationSteps = n2;
                break;
            }
            case 553648184: {
                this.global.strutSpacing = n2;
                break;
            }
            case 553648156: {
                n2 = Viewer.checkIntRange(n2, 0, 1000);
                this.gdata.setPhongExponent(n2);
                break;
            }
            case 0x21000012: {
                this.global.helixStep = n2;
                this.modelSet.setHaveStraightness(false);
                break;
            }
            case 0x21000010: {
                this.global.dotScale = n2;
                break;
            }
            case 553648143: {
                this.global.dotDensity = n2;
                break;
            }
            case 553648138: {
                this.global.delayMaximumMs = n2;
                break;
            }
            case 553648150: {
                Logger.setLogLevel(n2);
                Logger.info("logging level set to " + n2);
                this.global.setI("logLevel", n2);
                if (this.eval != null) {
                    this.eval.setDebugging();
                }
                return;
            }
            case 553648134: {
                switch (EnumAxesMode.getAxesMode(n2)) {
                    case MOLECULAR: {
                        this.setAxesModeMolecular(true);
                        return;
                    }
                    case BOUNDBOX: {
                        this.setAxesModeMolecular(false);
                        return;
                    }
                    case UNITCELL: {
                        this.setAxesModeUnitCell(true);
                        return;
                    }
                }
                return;
            }
            case 553648178: {
                this.setStrandCount(0, n2);
                return;
            }
            case 553648182: {
                this.setStrandCount(12, n2);
                return;
            }
            case 553648180: {
                this.setStrandCount(13, n2);
                return;
            }
            case 553648155: {
                return;
            }
            case 0x2000000A: {
                this.global.scriptDelay = n2;
                break;
            }
            case 553648176: {
                n2 = n2 < 0 ? Viewer.checkIntRange(n2, -10, -1) : Viewer.checkIntRange(n2, 0, 100);
                this.gdata.setSpecularPower(n2);
                break;
            }
            case 553648172: {
                n2 = Viewer.checkIntRange(-n2, -10, -1);
                this.gdata.setSpecularPower(n2);
                break;
            }
            case 553648136: {
                this.setMarBond((short)n2);
                return;
            }
            case 0x2000000C: {
                this.setBooleanPropertyTok(string, n, n2 == 1);
                return;
            }
            case 553648174: {
                n2 = Viewer.checkIntRange(n2, 0, 100);
                this.gdata.setSpecularPercent(n2);
                break;
            }
            case 553648142: {
                n2 = Viewer.checkIntRange(n2, 0, 100);
                this.gdata.setDiffusePercent(n2);
                break;
            }
            case 0x21000002: {
                n2 = Viewer.checkIntRange(n2, 0, 100);
                this.gdata.setAmbientPercent(n2);
                break;
            }
            case 553648186: {
                this.transformManager.zDepthToPercent(n2);
                break;
            }
            case 553648188: {
                this.transformManager.zSlabToPercent(n2);
                break;
            }
            case 554176526: {
                this.transformManager.depthToPercent(n2);
                break;
            }
            case 554176565: {
                this.transformManager.slabToPercent(n2);
                break;
            }
            case 553648190: {
                this.global.zShadePower = Math.max(n2, 1);
                break;
            }
            case 553648166: {
                this.global.ribbonAspectRatio = n2;
                break;
            }
            case 553648157: {
                this.global.pickingSpinRate = n2 < 1 ? 1 : n2;
                break;
            }
            case 553648132: {
                this.setAnimationFps(n2);
                return;
            }
            case 553648154: {
                this.setPercentVdwAtom(n2);
                break;
            }
            case 553648147: {
                this.global.hermiteLevel = n2;
                break;
            }
            case 0x21000011: 
            case 553648148: 
            case 553648159: 
            case 0x21000020: 
            case 0x21000022: 
            case 553648164: {
                break;
            }
            default: {
                if (this.global.htNonbooleanParameterValues.containsKey(string)) break;
                this.global.setUserVariable(string, SV.newI(n2));
                return;
            }
        }
        this.global.setI(string, n2);
    }

    private static int checkIntRange(int n, int n2, int n3) {
        return n < n2 ? n2 : (n > n3 ? n3 : n);
    }

    private static float checkFloatRange(float f, float f2, float f3) {
        return f < f2 ? f2 : (f > f3 ? f3 : f);
    }

    @Override
    public void setBooleanProperty(String string, boolean bl) {
        if (string.charAt(0) == '_') {
            this.global.setB(string, bl);
            return;
        }
        int n = T.getTokFromName(string);
        switch (T.getParamType(n)) {
            case 0x20800000: {
                this.setStringPropertyTok(string, n, "");
                break;
            }
            case 0x21000000: {
                this.setIntPropertyTok(string, n, bl ? 1 : 0);
                break;
            }
            case 0x22000000: {
                this.setFloatPropertyTok(string, n, bl ? 1.0f : 0.0f);
                break;
            }
            default: {
                this.setBooleanPropertyTok(string, n, bl);
            }
        }
    }

    private void setBooleanPropertyTok(String string, int n, boolean bl) {
        boolean bl2 = true;
        switch (n) {
            case 603979837: {
                this.global.ellipsoidArrows = bl;
                break;
            }
            case 603979967: {
                this.global.translucent = bl;
                break;
            }
            case 603979820: {
                this.global.cartoonLadders = bl;
                break;
            }
            case 603979968: {
                boolean bl3 = this.global.twistedSheets;
                this.global.twistedSheets = bl;
                if (bl3 == bl) break;
                this.checkCoordinatesChanged();
                break;
            }
            case 603979821: {
                this.global.celShading = bl;
                this.gdata.setCel(bl);
                break;
            }
            case 603979819: {
                this.global.cartoonFancy = bl;
                break;
            }
            case 603979934: {
                this.global.showTiming = bl;
                break;
            }
            case 603979973: {
                this.global.vectorSymmetry = bl;
                break;
            }
            case 603979870: {
                this.global.isosurfaceKey = bl;
                break;
            }
            case 603979889: {
                this.global.partialDots = bl;
                break;
            }
            case 603979874: {
                this.global.legacyAutoBonding = bl;
                break;
            }
            case 603979825: {
                this.global.defaultStructureDSSP = bl;
                break;
            }
            case 603979834: {
                this.global.dsspCalcHydrogen = bl;
                break;
            }
            case 603979782: {
                this.global.allowModelkit = bl;
                if (bl) break;
                this.setModelKitMode(false);
                break;
            }
            case 603979883: {
                this.setModelKitMode(bl);
                break;
            }
            case 603979885: {
                this.global.multiProcessor = bl && nProcessors > 1;
                break;
            }
            case 603979884: {
                this.global.monitorEnergy = bl;
                break;
            }
            case 603979853: {
                this.global.hbondsRasmol = bl;
                break;
            }
            case 603979881: {
                this.global.minimizationRefresh = bl;
                break;
            }
            case 603979882: {
                this.global.minimizationSilent = bl;
                break;
            }
            case 603979969: {
                this.global.useArcBall = bl;
                break;
            }
            case 603979869: {
                if (!bl) break;
                this.isKiosk = true;
                this.global.disablePopupMenu = true;
                if (this.display == null) break;
                this.apiPlatform.setTransparentCursor(this.display);
                break;
            }
            case 603979974: {
                this.global.waitForMoveTo = bl;
                break;
            }
            case 603979876: {
                this.global.logCommands = true;
                break;
            }
            case 603979877: {
                this.global.logGestures = true;
                break;
            }
            case 603979784: {
                this.global.allowMultiTouch = bl;
                break;
            }
            case 603979894: {
                this.global.preserveState = bl;
                this.modelSet.setPreserveState(bl);
                this.undoClear();
                break;
            }
            case 603979955: {
                this.global.strutsMultiple = bl;
                break;
            }
            case 0x24000042: {
                break;
            }
            case 603979938: {
                this.global.slabByAtom = bl;
                break;
            }
            case 603979940: {
                this.global.slabByMolecule = bl;
                break;
            }
            case 603979902: {
                this.global.saveProteinStructureState = bl;
                break;
            }
            case 0x24000004: {
                this.global.allowGestures = bl;
                break;
            }
            case 603979868: {
                this.global.imageState = bl;
                break;
            }
            case 603979970: {
                this.global.useMinimizationThread = bl;
                break;
            }
            case 603979781: {
                if (this.global.disablePopupMenu) {
                    bl = false;
                }
                this.global.allowKeyStrokes = bl;
                break;
            }
            case 603979831: {
                this.global.dragSelected = bl;
                this.showSelected = false;
                break;
            }
            case 603979924: {
                this.global.showKeyStrokes = bl;
                break;
            }
            case 0x24000044: {
                this.global.fontCaching = bl;
                break;
            }
            case 603979796: {
                this.global.atomPicking = bl;
                break;
            }
            case 603979814: {
                this.highlight(null);
                this.global.bondPicking = bl;
                break;
            }
            case 603979906: {
                this.global.selectAllModels = bl;
                break;
            }
            case 603979880: {
                this.global.messageStyleChime = bl;
                break;
            }
            case 603979892: {
                this.global.pdbSequential = bl;
                break;
            }
            case 603979890: {
                this.global.pdbAddHydrogens = bl;
                break;
            }
            case 603979891: {
                this.global.pdbGetHeader = bl;
                break;
            }
            case 603979838: {
                this.global.ellipsoidAxes = bl;
                break;
            }
            case 603979836: {
                this.global.ellipsoidArcs = bl;
                break;
            }
            case 603979839: {
                this.global.ellipsoidBall = bl;
                break;
            }
            case 0x24000040: {
                this.global.ellipsoidDots = bl;
                break;
            }
            case 603979841: {
                this.global.ellipsoidFill = bl;
                break;
            }
            case 603979845: {
                this.global.fontScaling = bl;
                break;
            }
            case 603979956: {
                this.setSyncTarget(0, bl);
                break;
            }
            case 603979958: {
                this.setSyncTarget(1, bl);
                break;
            }
            case 603979976: {
                this.global.wireframeRotation = bl;
                break;
            }
            case 603979871: {
                this.global.isosurfacePropertySmoothing = bl;
                break;
            }
            case 603979833: {
                this.global.drawPicking = bl;
                break;
            }
            case 603979786: 
            case 603979788: 
            case 603979790: {
                this.setAntialias(n, bl);
                break;
            }
            case 603979944: {
                this.global.smartAromatic = bl;
                break;
            }
            case 603979794: {
                this.setApplySymmetryToBonds(bl);
                break;
            }
            case 603979792: {
                this.setAppendNew(bl);
                break;
            }
            case 603979800: {
                this.global.autoFps = bl;
                break;
            }
            case 603979972: {
                this.global.useNumberLocalization = bl;
                DF.setUseNumberLocalization(this.global.useNumberLocalization);
                break;
            }
            case 1611272202: {
                string = "showFrank";
                this.setFrankOn(bl);
                break;
            }
            case 603979918: {
                this.setFrankOn(bl);
                break;
            }
            case 1613758488: {
                string = "solventProbe";
                this.global.solventOn = bl;
                break;
            }
            case 603979948: {
                this.global.solventOn = bl;
                break;
            }
            case 603979785: {
                this.global.allowRotateSelected = bl;
                break;
            }
            case 603979783: {
                this.global.allowMoveAtoms = bl;
                this.global.allowRotateSelected = bl;
                this.global.dragSelected = bl;
                this.showSelected = false;
                break;
            }
            case 0x2000000A: {
                this.setIntPropertyTok("showScript", n, bl ? 1 : 0);
                return;
            }
            case 0x24000002: {
                this.global.allowEmbeddedScripts = bl;
                break;
            }
            case 603979888: {
                this.global.navigationPeriodic = bl;
                break;
            }
            case 603979984: {
                this.transformManager.setZShadeEnabled(bl);
                return;
            }
            case 603979832: {
                if (!this.haveDisplay) break;
                this.global.drawHover = bl;
                break;
            }
            case 603979887: {
                this.setNavigationMode(bl);
                break;
            }
            case 603979886: {
                return;
            }
            case 603979860: {
                this.global.hideNavigationPoint = bl;
                break;
            }
            case 603979930: {
                this.global.showNavigationPointAlways = bl;
                break;
            }
            case 603979896: {
                this.setRefreshing(bl);
                break;
            }
            case 603979872: {
                this.global.justifyMeasurements = bl;
                break;
            }
            case 603979952: {
                this.global.ssbondsBackbone = bl;
                break;
            }
            case 603979852: {
                this.global.hbondsBackbone = bl;
                break;
            }
            case 603979854: {
                this.global.hbondsSolid = bl;
                break;
            }
            case 0x2000000C: {
                this.gdata.setSpecular(bl);
                break;
            }
            case 603979942: {
                this.transformManager.setSlabEnabled(bl);
                return;
            }
            case 603979980: {
                this.transformManager.setZoomEnabled(bl);
                return;
            }
            case 603979864: {
                this.global.highResolutionFlag = bl;
                break;
            }
            case 603979966: {
                this.global.traceAlpha = bl;
                break;
            }
            case 603979983: {
                this.global.zoomLarge = bl;
                this.transformManager.setZoomHeight(this.global.zoomHeight, bl);
                break;
            }
            case 603979982: {
                this.global.zoomHeight = bl;
                this.transformManager.setZoomHeight(bl, this.global.zoomLarge);
                break;
            }
            case 603979873: {
                GT.setDoTranslate(bl);
                break;
            }
            case 603979862: {
                this.selectionManager.setHideNotSelected(bl);
                break;
            }
            case 603979904: {
                this.setScriptQueue(bl);
                break;
            }
            case 603979830: {
                this.global.dotSurface = bl;
                break;
            }
            case 603979829: {
                this.global.dotsSelectedOnly = bl;
                break;
            }
            case 1611141171: {
                this.setSelectionHalos(bl);
                break;
            }
            case 603979910: {
                this.global.rasmolHydrogenSetting = bl;
                break;
            }
            case 603979908: {
                this.global.rasmolHeteroSetting = bl;
                break;
            }
            case 603979928: {
                this.global.showMultipleBonds = bl;
                break;
            }
            case 603979920: {
                this.global.showHiddenSelectionHalos = bl;
                break;
            }
            case 603979975: {
                this.transformManager.setWindowCentered(bl);
                break;
            }
            case 603979828: {
                this.global.displayCellParameters = bl;
                break;
            }
            case 603979960: {
                this.global.testFlag1 = bl;
                break;
            }
            case 603979962: {
                this.global.testFlag2 = bl;
                break;
            }
            case 603979964: {
                this.global.testFlag3 = bl;
                break;
            }
            case 603979965: {
                this.jmolTest();
                this.global.testFlag4 = bl;
                break;
            }
            case 603979898: {
                this.global.ribbonBorder = bl;
                break;
            }
            case 603979817: {
                this.global.cartoonBaseEdges = bl;
                break;
            }
            case 603979818: {
                this.global.cartoonRockets = bl;
                break;
            }
            case 603979900: {
                this.global.rocketBarrels = bl;
                break;
            }
            case 603979850: {
                this.global.greyscaleRendering = bl;
                this.gdata.setGreyscaleMode(this.global.greyscaleRendering);
                break;
            }
            case 603979879: {
                this.global.measurementLabels = bl;
                break;
            }
            case 0x24000022: {
                this.setAxesModeMolecular(!bl);
                return;
            }
            case 603979804: {
                this.setAxesModeMolecular(bl);
                return;
            }
            case 0x24000020: {
                this.setAxesModeUnitCell(bl);
                return;
            }
            case 603979806: {
                this.setAxesOrientationRasmol(bl);
                return;
            }
            case 603979823: {
                this.setStringPropertyTok("defaultcolorscheme", 545259545, bl ? "rasmol" : "jmol");
                return;
            }
            case 603979824: {
                this.setDebugScript(bl);
                return;
            }
            case 603979893: {
                this.setPerspectiveDepth(bl);
                return;
            }
            case 603979798: {
                this.setAutoBond(bl);
                return;
            }
            case 603979914: {
                this.setShowAxes(bl);
                return;
            }
            case 603979916: {
                this.setShowBbcage(bl);
                return;
            }
            case 603979922: {
                this.setShowHydrogens(bl);
                return;
            }
            case 603979926: {
                this.setShowMeasurements(bl);
                return;
            }
            case 603979936: {
                this.setShowUnitCell(bl);
                return;
            }
            case 0x24000024: {
                bl2 = false;
                this.global.bondModeOr = bl;
                break;
            }
            case 603979978: {
                bl2 = false;
                this.global.zeroBasedXyzRasmol = bl;
                this.reset(true);
                break;
            }
            case 603979895: {
                bl2 = false;
                this.global.rangeSelected = bl;
                break;
            }
            case 603979878: {
                bl2 = false;
                this.global.measureAllModels = bl;
                break;
            }
            case 603979954: {
                bl2 = false;
                this.statusManager.setAllowStatusReporting(bl);
                break;
            }
            case 603979822: {
                bl2 = false;
                this.global.chainCaseSensitive = bl;
                break;
            }
            case 603979858: {
                bl2 = false;
                this.global.hideNameInPopup = bl;
                break;
            }
            case 603979826: {
                bl2 = false;
                this.global.disablePopupMenu = bl;
                break;
            }
            case 603979846: {
                bl2 = false;
                this.global.forceAutoBond = bl;
                break;
            }
            case 603979848: {
                bl2 = false;
                this.global.fractionalRelative = bl;
                break;
            }
            default: {
                if (this.global.htBooleanParameterFlags.containsKey(string.toLowerCase())) break;
                this.global.setUserVariable(string, SV.getBoolean(bl));
                return;
            }
        }
        this.global.setB(string, bl);
        if (bl2) {
            this.setTainted(true);
        }
    }

    private void setModelKitMode(boolean bl) {
        if (this.actionManager == null || !this.allowScripting) {
            return;
        }
        if (bl || this.global.modelKitMode) {
            this.setPickingMode(null, bl ? 33 : 1);
            this.setPickingMode(null, bl ? 32 : 1);
        }
        boolean bl2 = this.global.modelKitMode != bl;
        this.global.modelKitMode = bl;
        this.highlight(null);
        if (bl) {
            this.setNavigationMode(false);
            this.selectAll();
            this.setAtomPickingOption("C");
            this.setBondPickingOption("p");
            if (!this.isApplet) {
                this.popupMenu(0, 0, 'm');
            }
            if (bl2) {
                this.statusManager.setCallbackFunction("modelkit", "ON");
            }
            this.global.modelKitMode = true;
            if (this.getAtomCount() == 0) {
                this.zap(false, true, true);
            }
        } else {
            this.actionManager.setPickingMode(-1);
            this.setStringProperty("pickingStyle", "toggle");
            this.setBooleanProperty("bondPicking", false);
            if (bl2) {
                this.statusManager.setCallbackFunction("modelkit", "OFF");
            }
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public void setSmilesString(String string) {
        if (string == null) {
            this.global.removeParam("_smilesString");
        } else {
            this.global.setS("_smilesString", string);
        }
    }

    public void removeUserVariable(String string) {
        this.global.removeUserVariable(string);
        if (string.endsWith("callback")) {
            this.statusManager.setCallbackFunction(string, null);
        }
    }

    public boolean isJmolVariable(String string) {
        return this.global.isJmolVariable(string);
    }

    private void jmolTest() {
    }

    public void showParameter(String string, boolean bl, int n) {
        String string2 = "" + this.global.getParameterEscaped(string, n);
        if (bl || string2.indexOf("<not defined>") < 0) {
            this.showString(string + " = " + string2, false);
        }
    }

    public void showString(String string, boolean bl) {
        if (this.isScriptQueued() && (!this.isSilent || bl) && !this.isJS) {
            Logger.warn(string);
        }
        this.scriptEcho(string);
    }

    public String getAllSettings(String string) {
        return this.getStateCreator().getAllSettings(string);
    }

    public String getBindingInfo(String string) {
        return this.haveDisplay ? this.actionManager.getBindingInfo(string) : "";
    }

    public int getIsosurfacePropertySmoothing(boolean bl) {
        return bl ? this.global.isosurfacePropertySmoothingPower : (this.global.isosurfacePropertySmoothing ? 1 : 0);
    }

    public void setNavigationDepthPercent(float f) {
        this.transformManager.setNavigationDepthPercent(f);
        this.refresh(1, "set navigationDepth");
    }

    public boolean getShowNavigationPoint() {
        if (!this.global.navigationMode || !this.transformManager.canNavigate()) {
            return false;
        }
        return this.isNavigating() && !this.global.hideNavigationPoint || this.global.showNavigationPointAlways || this.getInMotion(true);
    }

    public float getCurrentSolventProbeRadius() {
        return this.global.solventOn ? this.global.solventProbeRadius : 0.0f;
    }

    public boolean getTestFlag(int n) {
        switch (n) {
            case 1: {
                return this.global.testFlag1;
            }
            case 2: {
                return this.global.testFlag2;
            }
            case 3: {
                return this.global.testFlag3;
            }
            case 4: {
                return this.global.testFlag4;
            }
        }
        return false;
    }

    @Override
    public void setPerspectiveDepth(boolean bl) {
        this.transformManager.setPerspectiveDepth(bl);
    }

    @Override
    public void setAxesOrientationRasmol(boolean bl) {
        this.global.setB("axesOrientationRasmol", bl);
        this.global.axesOrientationRasmol = bl;
        this.reset(true);
    }

    void setAxesScale(float f) {
        this.global.axesScale = f = Viewer.checkFloatRange(f, -100.0f, 100.0f);
        this.axesAreTainted = true;
    }

    public P3[] getAxisPoints() {
        return this.getObjectMad(1) == 0 || this.getAxesMode() != EnumAxesMode.UNITCELL || (Boolean)this.getShapeProperty(31, "axesTypeXY") != false || this.getShapeProperty(31, "origin") != null ? null : (P3[])this.getShapeProperty(31, "axisPoints");
    }

    public void resetError() {
        this.global.removeParam("_errormessage");
    }

    private void setAxesModeMolecular(boolean bl) {
        this.global.axesMode = bl ? EnumAxesMode.MOLECULAR : EnumAxesMode.BOUNDBOX;
        this.axesAreTainted = true;
        this.global.removeParam("axesunitcell");
        this.global.removeParam(bl ? "axeswindow" : "axesmolecular");
        this.global.setI("axesMode", this.global.axesMode.getCode());
        this.global.setB(bl ? "axesMolecular" : "axesWindow", true);
    }

    void setAxesModeUnitCell(boolean bl) {
        this.global.axesMode = bl ? EnumAxesMode.UNITCELL : EnumAxesMode.BOUNDBOX;
        this.axesAreTainted = true;
        this.global.removeParam("axesmolecular");
        this.global.removeParam(bl ? "axeswindow" : "axesunitcell");
        this.global.setB(bl ? "axesUnitcell" : "axesWindow", true);
        this.global.setI("axesMode", this.global.axesMode.getCode());
    }

    public EnumAxesMode getAxesMode() {
        return this.global.axesMode;
    }

    @Override
    public boolean getPerspectiveDepth() {
        return this.transformManager.getPerspectiveDepth();
    }

    @Override
    public void setSelectionHalos(boolean bl) {
        if (this.modelSet == null || bl == this.modelSet.getSelectionHaloEnabled()) {
            return;
        }
        this.global.setB("selectionHalos", bl);
        this.loadShape(8);
        this.modelSet.setSelectionHaloEnabled(bl);
    }

    public boolean getSelectionHaloEnabled(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = this.modelSet.getSelectionHaloEnabled() || bl && this.showSelected;
        if (bl) {
            this.showSelected = false;
        }
        return bl2;
    }

    private void setStrandCount(int n, int n2) {
        n2 = Viewer.checkIntRange(n2, 0, 20);
        switch (n) {
            case 12: {
                this.global.strandCountForStrands = n2;
                break;
            }
            case 13: {
                this.global.strandCountForMeshRibbon = n2;
                break;
            }
            default: {
                this.global.strandCountForStrands = n2;
                this.global.strandCountForMeshRibbon = n2;
            }
        }
        this.global.setI("strandCount", n2);
        this.global.setI("strandCountForStrands", this.global.strandCountForStrands);
        this.global.setI("strandCountForMeshRibbon", this.global.strandCountForMeshRibbon);
    }

    public int getStrandCount(int n) {
        return n == 12 ? this.global.strandCountForStrands : this.global.strandCountForMeshRibbon;
    }

    public void setNavigationMode(boolean bl) {
        this.global.navigationMode = bl;
        this.transformManager.setNavigationMode(bl);
    }

    private void setTransformManagerDefaults() {
        this.transformManager.setCameraDepthPercent(this.global.defaultCameraDepth, true);
        this.transformManager.setPerspectiveDepth(this.global.defaultPerspectiveDepth);
        this.transformManager.setStereoDegrees(-5.0f);
        this.transformManager.setVisualRange(this.global.visualRange);
        this.transformManager.setSpinOff();
        this.transformManager.setVibrationPeriod(0.0f);
        this.transformManager.setFrameOffsets(this.frameOffsets);
    }

    public P3[] getCameraFactors() {
        return this.transformManager.getCameraFactors();
    }

    public float getCameraDepth() {
        return this.transformManager.getCameraDepth();
    }

    String getLoadState(Map<String, Object> map) {
        return this.getStateCreator().getLoadState(map);
    }

    @Override
    public void setAutoBond(boolean bl) {
        this.global.setB("autobond", bl);
        this.global.autoBond = bl;
    }

    public int[] makeConnections(float f, float f2, int n, int n2, BS bS, BS bS2, BS bS3, boolean bl, boolean bl2, float f3) {
        this.clearModelDependentObjects();
        this.clearMinimization();
        return this.modelSet.makeConnections(f, f2, n, n2, bS, bS2, bS3, bl, bl2, f3);
    }

    @Override
    public void rebond() {
        this.rebondState(false);
    }

    public void rebondState(boolean bl) {
        this.clearModelDependentObjects();
        this.modelSet.deleteAllBonds();
        boolean bl2 = bl && this.global.legacyAutoBonding;
        this.modelSet.autoBondBs4(null, null, null, null, this.getMadBond(), bl2);
        this.addStateScript(bl2 ? "set legacyAutoBonding TRUE;connect;set legacyAutoBonding FALSE;" : "connect;", false, true);
    }

    public void setPdbConectBonding(boolean bl, boolean bl2) {
        this.clearModelDependentObjects();
        this.modelSet.deleteAllBonds();
        BS bS = new BS();
        this.modelSet.setPdbConectBonding(0, 0, bS);
        if (bl) {
            boolean bl3 = bl2 && this.global.legacyAutoBonding;
            this.modelSet.autoBondBs4(null, null, bS, null, this.getMadBond(), bl3);
            this.addStateScript(bl3 ? "set legacyAutoBonding TRUE;connect PDB AUTO;set legacyAutoBonding FALSE;" : "connect PDB auto;", false, true);
            return;
        }
        this.addStateScript("connect PDB;", false, true);
    }

    @Override
    public void setPercentVdwAtom(int n) {
        this.global.setI("percentVdwAtom", n);
        this.global.percentVdwAtom = n;
        this.rd.value = (float)n / 100.0f;
        this.rd.factorType = RadiusData.EnumType.FACTOR;
        this.rd.vdwType = EnumVdw.AUTO;
        this.setShapeSizeRD(0, this.rd, null);
    }

    public RadiusData getDefaultRadiusData() {
        return this.rd;
    }

    @Override
    public short getMadBond() {
        return (short)(this.global.bondRadiusMilliAngstroms * 2);
    }

    public short getMarBond() {
        return this.global.bondRadiusMilliAngstroms;
    }

    public byte getModeMultipleBond() {
        return this.global.modeMultipleBond;
    }

    @Override
    public void setShowHydrogens(boolean bl) {
        this.global.setB("showHydrogens", bl);
        this.global.showHydrogens = bl;
    }

    @Override
    public void setShowBbcage(boolean bl) {
        this.setObjectMad(32, "boundbox", (short)(bl ? -4 : 0));
        this.global.setB("showBoundBox", bl);
    }

    @Override
    public boolean getShowBbcage() {
        return this.getObjectMad(4) != 0;
    }

    public void setShowUnitCell(boolean bl) {
        this.setObjectMad(33, "unitcell", (short)(bl ? -2 : 0));
        this.global.setB("showUnitCell", bl);
    }

    public boolean getShowUnitCell() {
        return this.getObjectMad(5) != 0;
    }

    @Override
    public void setShowAxes(boolean bl) {
        this.setObjectMad(31, "axes", (short)(bl ? -2 : 0));
        this.global.setB("showAxes", bl);
    }

    @Override
    public boolean getShowAxes() {
        return this.getObjectMad(1) != 0;
    }

    @Override
    public void setFrankOn(boolean bl) {
        if (this.isPreviewOnly) {
            bl = false;
        }
        this.frankOn = bl;
        this.setObjectMad(35, "frank", (short)(bl ? 1 : 0));
    }

    public boolean getShowFrank() {
        if (this.isPreviewOnly || this.isApplet && this.creatingImage) {
            return false;
        }
        return !this.isJS && this.isSignedApplet && !this.isSignedAppletLocal || this.frankOn;
    }

    @Override
    public void setShowMeasurements(boolean bl) {
        this.global.setB("showMeasurements", bl);
        this.global.showMeasurements = bl;
    }

    public void setUnits(String string, boolean bl) {
        this.global.setUnits(string);
        if (bl) {
            this.global.setUnits(string);
            this.setShapeProperty(6, "reformatDistances", null);
        }
    }

    public String getMeasureDistanceUnits() {
        return this.global.measureDistanceUnits;
    }

    public String getEnergyUnits() {
        return this.global.energyUnits;
    }

    public void setAppendNew(boolean bl) {
        this.global.appendNew = bl;
    }

    @Override
    public void setRasmolDefaults() {
        this.setDefaultsType("RasMol");
    }

    @Override
    public void setJmolDefaults() {
        this.setDefaults();
    }

    private void setDefaultsType(String string) {
        if (string.equalsIgnoreCase("RasMol")) {
            this.stateManager.setRasMolDefaults();
            return;
        }
        if (string.equalsIgnoreCase("PyMOL")) {
            this.stateManager.setPyMOLDefaults();
            return;
        }
        this.setDefaults();
    }

    private void setDefaults() {
        this.setShapeSizeRD(0, this.rd, this.getAllAtoms());
    }

    private void setAntialias(int n, boolean bl) {
        switch (n) {
            case 603979786: {
                this.global.antialiasDisplay = bl;
                break;
            }
            case 603979790: {
                this.global.antialiasTranslucent = bl;
                break;
            }
            case 603979788: {
                this.global.antialiasImages = bl;
                return;
            }
        }
        this.resizeImage(0, 0, false, false, true);
    }

    public P3[] allocTempPoints(int n) {
        return this.tempArray.allocTempPoints(n);
    }

    public void freeTempPoints(P3[] p3Array) {
        this.tempArray.freeTempPoints(p3Array);
    }

    public P3i[] allocTempScreens(int n) {
        return this.tempArray.allocTempScreens(n);
    }

    public void freeTempScreens(P3i[] p3iArray) {
        this.tempArray.freeTempScreens(p3iArray);
    }

    public EnumStructure[] allocTempEnum(int n) {
        return this.tempArray.allocTempEnum(n);
    }

    public void freeTempEnum(EnumStructure[] enumStructureArray) {
        this.tempArray.freeTempEnum(enumStructureArray);
    }

    public Font getFont3D(String string, String string2, float f) {
        return this.gdata.getFont3DFSS(string, string2, f);
    }

    public String formatText(String string) {
        boolean bl;
        int n = string.indexOf("@{");
        if (n < 0 && (n = string.indexOf("%{")) < 0) {
            return string;
        }
        String string2 = string;
        boolean bl2 = bl = string2.indexOf("\\") >= 0;
        if (bl) {
            string2 = PT.simpleReplace(string2, "\\%", "\u0001");
            bl = !(string2 = PT.simpleReplace(string2, "\\@", "\u0002")).equals(string);
        }
        string2 = PT.simpleReplace(string2, "%{", "@{");
        while ((n = string2.indexOf("@{")) >= 0) {
            int n2 = ++n + 1;
            int n3 = string2.length();
            if ((n = Txt.ichMathTerminator(string2, n, n3)) >= n3) {
                return string2;
            }
            String string3 = string2.substring(n2, n);
            if (string3.length() == 0) {
                return string2;
            }
            Object object = this.evaluateExpression(string3);
            if (object instanceof P3) {
                object = Escape.eP((P3)object);
            }
            string2 = string2.substring(0, n2 - 2) + object.toString() + string2.substring(n + 1);
        }
        if (bl) {
            string2 = PT.simpleReplace(string2, "\u0002", "@");
            string2 = PT.simpleReplace(string2, "\u0001", "%");
        }
        return string2;
    }

    String getElementSymbol(int n) {
        return this.modelSet.getElementSymbol(n);
    }

    int getElementNumber(int n) {
        return this.modelSet.getElementNumber(n);
    }

    @Override
    public String getAtomName(int n) {
        return this.modelSet.getAtomName(n);
    }

    @Override
    public int getAtomNumber(int n) {
        return this.modelSet.getAtomNumber(n);
    }

    public Quaternion[] getAtomGroupQuaternions(BS bS, int n) {
        return this.modelSet.getAtomGroupQuaternions(bS, n, this.getQuaternionFrame());
    }

    public Quaternion getAtomQuaternion(int n) {
        return this.modelSet.getQuaternion(n, this.getQuaternionFrame());
    }

    @Override
    public P3 getAtomPoint3f(int n) {
        return this.modelSet.atoms[n];
    }

    public javajs.util.List<P3> getAtomPointVector(BS bS) {
        return this.modelSet.getAtomPointVector(bS);
    }

    @Override
    public float getAtomRadius(int n) {
        return this.modelSet.getAtomRadius(n);
    }

    @Override
    public int getAtomArgb(int n) {
        return this.gdata.getColorArgbOrGray(this.modelSet.getAtomColix(n));
    }

    @Override
    public int getAtomModelIndex(int n) {
        return this.modelSet.atoms[n].modelIndex;
    }

    @Override
    public float getBondRadius(int n) {
        return this.modelSet.getBondRadius(n);
    }

    @Override
    public int getBondOrder(int n) {
        return this.modelSet.getBondOrder(n);
    }

    public void assignAromaticBonds() {
        this.modelSet.assignAromaticBonds();
    }

    public void resetAromatic() {
        this.modelSet.resetAromatic();
    }

    @Override
    public int getBondArgb1(int n) {
        return this.gdata.getColorArgbOrGray(this.modelSet.getBondColix1(n));
    }

    @Override
    public int getBondModelIndex(int n) {
        return this.modelSet.getBondModelIndex(n);
    }

    @Override
    public int getBondArgb2(int n) {
        return this.gdata.getColorArgbOrGray(this.modelSet.getBondColix2(n));
    }

    @Override
    public P3[] getPolymerLeadMidPoints(int n, int n2) {
        return this.modelSet.getPolymerLeadMidPoints(n, n2);
    }

    public void setStereoMode(int[] nArray, EnumStereoMode enumStereoMode, float f) {
        this.setFloatProperty("stereoDegrees", f);
        this.setBooleanProperty("greyscaleRendering", enumStereoMode.isBiColor());
        if (nArray != null) {
            this.transformManager.setStereoMode2(nArray);
        } else {
            this.transformManager.setStereoMode(enumStereoMode);
        }
    }

    boolean isStereoDouble() {
        return this.transformManager.stereoMode == EnumStereoMode.DOUBLE;
    }

    @Override
    public String getOperatingSystemName() {
        return strOSName + (!this.isJS ? "" : (this.isWebGL ? "(WebGL)" : "(HTML5)"));
    }

    @Override
    public String getJavaVendor() {
        return strJavaVendor;
    }

    @Override
    public String getJavaVersion() {
        return strJavaVersion;
    }

    public GData getGraphicsData() {
        return this.gdata;
    }

    @Override
    public Object getProperty(String string, String string2, Object object) {
        if (!"DATA_API".equals(string)) {
            return this.getPropertyManager().getProperty(string, string2, object);
        }
        switch ("scriptCheck.........consoleText.........scriptEditor........scriptEditorState...getAppConsole.......getScriptEditor.....setMenu.............spaceGroupInfo......disablePopupMenu....defaultDirectory....getPopupMenu........shapeManager........".indexOf(string2)) {
            case 0: {
                return this.scriptCheckRet((String)object, true);
            }
            case 20: {
                return this.appConsole == null ? "" : this.appConsole.getText();
            }
            case 40: {
                this.showEditor((String[])object);
                return null;
            }
            case 60: {
                this.scriptEditorVisible = (Boolean)object;
                return null;
            }
            case 80: {
                if (this.isKiosk) {
                    this.appConsole = null;
                } else if (object instanceof JmolAppConsoleInterface) {
                    this.appConsole = (JmolAppConsoleInterface)object;
                } else if (object != null && !((Boolean)object).booleanValue()) {
                    this.appConsole = null;
                } else if (this.appConsole == null && object != null && ((Boolean)object).booleanValue()) {
                    if (this.isJS) {
                        this.appConsole = (JmolAppConsoleInterface)Interface.getOptionInterface("consolejs.AppletConsole");
                    }
                    for (int i = 0; i < 4 && this.appConsole == null; ++i) {
                        JmolAppConsoleInterface jmolAppConsoleInterface = this.appConsole = this.isApplet ? (JmolAppConsoleInterface)Interface.getOptionInterface("console.AppletConsole") : (JmolAppConsoleInterface)Interface.getApplicationInterface("jmolpanel.console.AppConsole");
                        if (this.appConsole != null) continue;
                        try {
                            System.out.println("Viewer can't start appConsole");
                            Thread.currentThread().wait(100L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (this.appConsole != null) {
                        this.appConsole.start(this);
                    }
                }
                this.scriptEditor = this.isJS || this.appConsole == null ? null : this.appConsole.getScriptEditor();
                return this.appConsole;
            }
            case 100: {
                if (this.appConsole == null && object != null && ((Boolean)object).booleanValue()) {
                    this.getProperty("DATA_API", "getAppConsole", Boolean.TRUE);
                    this.scriptEditor = this.appConsole == null ? null : this.appConsole.getScriptEditor();
                }
                return this.scriptEditor;
            }
            case 120: {
                if (this.jmolpopup != null) {
                    this.jmolpopup.jpiDispose();
                }
                this.jmolpopup = null;
                this.menuStructure = (String)object;
                return this.menuStructure;
            }
            case 140: {
                return this.getSpaceGroupInfo(null);
            }
            case 160: {
                this.global.disablePopupMenu = true;
                return null;
            }
            case 180: {
                return this.global.defaultDirectory;
            }
            case 200: {
                if (object instanceof String) {
                    return this.getMenu((String)object);
                }
                return this.getPopupMenu();
            }
            case 220: {
                return this.shapeManager.getProperty(object);
            }
        }
        Logger.error("ERROR in getProperty DATA_API: " + string2);
        return null;
    }

    public void showEditor(String[] stringArray) {
        JmolScriptEditorInterface jmolScriptEditorInterface = (JmolScriptEditorInterface)this.getProperty("DATA_API", "getScriptEditor", Boolean.TRUE);
        if (jmolScriptEditorInterface == null) {
            return;
        }
        jmolScriptEditorInterface.show(stringArray);
    }

    private JmolPropertyManager getPropertyManager() {
        if (this.pm == null) {
            this.pm = (JmolPropertyManager)Interface.getOptionInterface("viewer.PropertyManager");
            this.pm.setViewer(this);
        }
        return this.pm;
    }

    public String getModelExtract(Object object, boolean bl, boolean bl2, String string) {
        return this.getPropertyManager().getModelExtract(this.getAtomBitSet(object), bl, bl2, string);
    }

    public void setTainted(boolean bl) {
        this.axesAreTainted = bl && (this.refreshing || this.creatingImage);
        this.isTainted = this.axesAreTainted;
    }

    public int notifyMouseClicked(int n, int n2, int n3, int n4) {
        int n5 = Binding.getButtonMods(n3);
        int n6 = Binding.getClickCount(n3);
        this.global.setI("_mouseX", n);
        this.global.setI("_mouseY", this.dimScreen.height - n2);
        this.global.setI("_mouseAction", n3);
        this.global.setI("_mouseModifiers", n5);
        this.global.setI("_clickCount", n6);
        return this.statusManager.setStatusClicked(n, this.dimScreen.height - n2, n3, n6, n4);
    }

    Map<String, Object> checkObjectClicked(int n, int n2, int n3) {
        return this.shapeManager.checkObjectClicked(n, n2, n3, this.getVisibleFramesBitSet(), this.global.drawPicking);
    }

    public boolean checkObjectHovered(int n, int n2) {
        return n >= 0 && this.shapeManager != null && this.shapeManager.checkObjectHovered(n, n2, this.getVisibleFramesBitSet(), this.getBondPicking());
    }

    void checkObjectDragged(int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        switch (this.getPickingMode()) {
            case 2: {
                n6 = 5;
                break;
            }
            case 4: {
                n6 = 22;
            }
        }
        if (this.shapeManager.checkObjectDragged(n, n2, n3, n4, n5, this.getVisibleFramesBitSet(), n6)) {
            this.refresh(1, "checkObjectDragged");
            if (n6 == 22) {
                this.scriptEcho((String)this.getShapeProperty(22, "command"));
            }
        }
    }

    public boolean rotateAxisAngleAtCenter(JmolScriptEvaluator jmolScriptEvaluator, P3 p3, V3 v3, float f, float f2, boolean bl, BS bS) {
        boolean bl2 = this.transformManager.rotateAxisAngleAtCenter(jmolScriptEvaluator, p3, v3, f, f2, bl, bS);
        if (bl2) {
            this.refresh(-1, "rotateAxisAngleAtCenter");
        }
        return bl2;
    }

    public boolean rotateAboutPointsInternal(JmolScriptEvaluator jmolScriptEvaluator, P3 p3, P3 p32, float f, float f2, boolean bl, BS bS, V3 v3, javajs.util.List<P3> list, float[] fArray) {
        boolean bl2 = this.transformManager.rotateAboutPointsInternal(jmolScriptEvaluator, p3, p32, f, f2, false, bl, bS, false, v3, list, fArray);
        if (bl2) {
            this.refresh(-1, "rotateAxisAboutPointsInternal");
        }
        return bl2;
    }

    public void startSpinningAxis(P3 p3, P3 p32, boolean bl) {
        if (this.getSpinOn() || this.getNavOn()) {
            this.setSpinOn(false);
            this.setNavOn(false);
            return;
        }
        this.transformManager.rotateAboutPointsInternal(null, p3, p32, this.global.pickingSpinRate, Float.MAX_VALUE, bl, true, null, false, null, null, null);
    }

    public V3 getModelDipole() {
        return this.modelSet.getModelDipole(this.animationManager.currentModelIndex);
    }

    public V3 calculateMolecularDipole() {
        return this.modelSet.calculateMolecularDipole(this.animationManager.currentModelIndex);
    }

    public void getAtomIdentityInfo(int n, Map<String, Object> map) {
        this.modelSet.getAtomIdentityInfo(n, map);
    }

    public void setDefaultLattice(P3 p3) {
        this.global.setDefaultLattice(p3);
        this.global.setS("defaultLattice", Escape.eP(p3));
    }

    public P3 getDefaultLattice() {
        return this.global.ptDefaultLattice;
    }

    public BS getTaintedAtoms(byte by) {
        return this.modelSet.getTaintedAtoms(by);
    }

    public void setTaintedAtoms(BS bS, byte by) {
        this.modelSet.setTaintedAtoms(bS, by);
    }

    @Override
    public String getData(String string, String string2) {
        String string3 = "";
        if (string2.equalsIgnoreCase("MOL") || string2.equalsIgnoreCase("SDF") || string2.equalsIgnoreCase("V2000") || string2.equalsIgnoreCase("V3000") || string2.equalsIgnoreCase("XYZVIB") || string2.equalsIgnoreCase("CD") || string2.equalsIgnoreCase("JSON")) {
            return this.getModelExtract(string, false, false, string2);
        }
        if (string2.toLowerCase().indexOf("property_") == 0) {
            string3 = "{selected}.label(\"%{" + string2 + "}\")";
        } else {
            if (string2.equalsIgnoreCase("CML")) {
                return this.getModelCml(this.getAtomBitSet(string), Integer.MAX_VALUE, true);
            }
            string3 = string2.equalsIgnoreCase("PDB") ? "{selected and not hetero}.label(\"ATOM  %5i %-4a%1A%3.3n %1c%4R%1E   %8.3x%8.3y%8.3z%6.2Q%6.2b          %2e  \").lines+{selected and hetero}.label(\"HETATM%5i %-4a%1A%3.3n %1c%4R%1E   %8.3x%8.3y%8.3z%6.2Q%6.2b          %2e  \").lines" : (string2.equalsIgnoreCase("XYZRN") ? "\"\" + {selected}.size + \"\n\n\"+{selected}.label(\"%-2e %8.3x %8.3y %8.3z %4.2[vdw] 1 [%n]%r.%a#%i\").lines" : (string2.startsWith("USER:") ? "{selected}.label(\"" + string2.substring(5) + "\").lines" : "\"\" + {selected}.size + \"\n\n\"+{selected}.label(\"%-2e %10.5x %10.5y %10.5z\").lines"));
        }
        if (!string.equals("selected")) {
            string3 = PT.simpleReplace(string3, "selected", string);
        }
        return (String)this.evaluateExpression(string3);
    }

    public String getModelCml(BS bS, int n, boolean bl) {
        return this.modelSet.getModelCml(bS, n, bl);
    }

    public Object getHelixData(BS bS, int n) {
        return this.modelSet.getHelixData(bS, n);
    }

    public String getPdbAtomData(BS bS, OC oC) {
        return this.modelSet.getPdbAtomData(bS == null ? this.getSelectionSet(true) : bS, oC);
    }

    public boolean isJmolDataFrameForModel(int n) {
        return this.modelSet.isJmolDataFrameForModel(n);
    }

    public boolean isJmolDataFrame() {
        return this.modelSet.isJmolDataFrameForModel(this.animationManager.currentModelIndex);
    }

    public int getJmolDataFrameIndex(int n, String string) {
        return this.modelSet.getJmolDataFrameIndex(n, string);
    }

    public void setJmolDataFrame(String string, int n, int n2) {
        this.modelSet.setJmolDataFrame(string, n, n2);
    }

    public void setFrameTitle(int n, String string) {
        this.modelSet.setFrameTitle(BSUtil.newAndSetBit(n), string);
    }

    public void setFrameTitleObj(Object object) {
        this.loadShape(30);
        this.modelSet.setFrameTitle(this.getVisibleFramesBitSet(), object);
    }

    public String getFrameTitle() {
        return this.modelSet.getFrameTitle(this.animationManager.currentModelIndex);
    }

    String getJmolFrameType(int n) {
        return this.modelSet.getJmolFrameType(n);
    }

    public int getJmolDataSourceFrame(int n) {
        return this.modelSet.getJmolDataSourceFrame(n);
    }

    public void setAtomProperty(BS bS, int n, int n2, float f, String string, float[] fArray, String[] stringArray) {
        if (n == 1649412120) {
            this.shapeManager.deleteVdwDependentShapes(bS);
        }
        this.clearMinimization();
        this.modelSet.setAtomProperty(bS, n, n2, f, string, fArray, stringArray);
        switch (n) {
            case 1087375365: 
            case 1112539153: 
            case 1112539154: 
            case 1112539155: 
            case 1112541185: 
            case 1112541186: 
            case 1112541187: 
            case 1112541188: 
            case 1112541189: 
            case 1112541190: {
                this.refreshMeasures(true);
            }
        }
    }

    public void checkCoordinatesChanged() {
        this.modelSet.recalculatePositionDependentQuantities(null, null);
        this.refreshMeasures(true);
    }

    public void setAtomCoord(int n, float f, float f2, float f3) {
        this.modelSet.setAtomCoord(n, f, f2, f3);
    }

    public void setAtomCoordRelative(int n, float f, float f2, float f3) {
        this.modelSet.setAtomCoordRelative(n, f, f2, f3);
    }

    public void setAtomCoords(BS bS, int n, Object object) {
        if (bS.cardinality() == 0) {
            return;
        }
        this.modelSet.setAtomCoords(bS, n, object);
        this.checkMinimization();
        this.statusManager.setStatusAtomMoved(bS);
    }

    public void setAtomCoordsRelative(T3 t3, BS bS) {
        if (bS == null) {
            bS = this.getSelectionSet(false);
        }
        if (bS.cardinality() == 0) {
            return;
        }
        this.modelSet.setAtomCoordsRelative(t3, bS);
        this.checkMinimization();
        this.statusManager.setStatusAtomMoved(bS);
    }

    public void invertAtomCoordPt(P3 p3, BS bS) {
        this.modelSet.invertSelected(p3, null, -1, null, bS);
        this.checkMinimization();
        this.statusManager.setStatusAtomMoved(bS);
    }

    public void invertAtomCoordPlane(P4 p4, BS bS) {
        this.modelSet.invertSelected(null, p4, -1, null, bS);
        this.checkMinimization();
        this.statusManager.setStatusAtomMoved(bS);
    }

    public void invertSelected(P3 p3, P4 p4, int n, BS bS) {
        BS bS2 = this.getSelectionSet(false);
        if (bS2.cardinality() == 0) {
            return;
        }
        this.modelSet.invertSelected(p3, p4, n, bS, bS2);
        this.checkMinimization();
        this.statusManager.setStatusAtomMoved(bS2);
    }

    public void moveAtoms(M3 m3, M3 m32, V3 v3, P3 p3, boolean bl, BS bS, boolean bl2) {
        if (bS.cardinality() == 0) {
            return;
        }
        this.modelSet.moveAtoms(m3, m32, v3, bS, p3, bl, bl2);
        this.checkMinimization();
        this.statusManager.setStatusAtomMoved(bS);
    }

    public void moveSelected(int n, int n2, int n3, int n4, int n5, BS bS, boolean bl, boolean bl2) {
        if (n3 == 0) {
            return;
        }
        if (n4 == Integer.MIN_VALUE) {
            this.rotateBondIndex = -1;
        }
        if (this.isJmolDataFrame()) {
            return;
        }
        if (n == Integer.MIN_VALUE) {
            this.showSelected = true;
            this.loadShape(8);
            this.refresh(6, "moveSelected");
            return;
        }
        if (n == Integer.MAX_VALUE) {
            if (!this.showSelected) {
                return;
            }
            this.showSelected = false;
            this.refresh(6, "moveSelected");
            return;
        }
        if (this.movingSelected) {
            return;
        }
        this.movingSelected = true;
        this.stopMinimization();
        if (this.rotateBondIndex >= 0 && n4 != Integer.MIN_VALUE) {
            this.actionRotateBond(n, n2, n4, n5);
        } else if ((bS = this.setMovableBitSet(bS, !bl2)).cardinality() != 0) {
            if (bl) {
                P3 p3 = this.getAtomSetCenter(bS);
                this.transformManager.finalizeTransformParameters();
                float f = this.global.antialiasDisplay ? 2 : 1;
                P3i p3i = this.transformPt(p3);
                P3 p32 = n3 != Integer.MIN_VALUE ? P3.new3(p3i.x, p3i.y, (float)(p3i.z + n3) + 0.5f) : P3.new3((float)p3i.x + (float)n * f + 0.5f, (float)p3i.y + (float)n2 * f + 0.5f, p3i.z);
                P3 p33 = new P3();
                this.unTransformPoint(p32, p33);
                p33.sub(p3);
                this.setAtomCoordsRelative(p33, bS);
            } else {
                this.transformManager.rotateXYBy(n, n2, bS);
            }
        }
        this.refresh(2, "");
        this.movingSelected = false;
    }

    public void highlightBond(int n, boolean bl) {
        if (bl && !this.hoverEnabled) {
            return;
        }
        BS bS = null;
        if (n >= 0) {
            Bond bond = this.modelSet.bonds[n];
            int n2 = bond.getAtomIndex2();
            if (!this.isAtomAssignable(n2)) {
                return;
            }
            bS = BSUtil.newAndSetBit(n2);
            bS.set(bond.getAtomIndex1());
        }
        this.highlight(bS);
        this.refresh(3, "highlightBond");
    }

    public void highlight(BS bS) {
        if (bS != null) {
            this.loadShape(8);
        }
        this.setShapeProperty(8, "highlight", bS);
    }

    void setRotateBondIndex(int n) {
        boolean bl;
        boolean bl2 = bl = this.rotateBondIndex >= 0;
        if (!bl && n < 0) {
            return;
        }
        this.rotatePrev1 = -1;
        this.bsRotateBranch = null;
        if (n == Integer.MIN_VALUE) {
            return;
        }
        this.rotateBondIndex = n;
        this.highlightBond(n, false);
    }

    int getRotateBondIndex() {
        return this.rotateBondIndex;
    }

    void actionRotateBond(int n, int n2, int n3, int n4) {
        T3 t3;
        Atom atom;
        Atom atom2;
        Object object;
        if (this.rotateBondIndex < 0) {
            return;
        }
        BS bS = this.bsRotateBranch;
        if (bS == null) {
            object = this.modelSet.bonds[this.rotateBondIndex];
            atom2 = ((Bond)object).getAtom1();
            atom = ((Bond)object).getAtom2();
            this.undoMoveActionClear(atom2.index, 2, true);
            t3 = P3.new3(n3, n4, (atom2.sZ + atom.sZ) / 2);
            this.transformManager.unTransformPoint((P3)t3, (P3)t3);
            if (atom.getCovalentBondCount() == 1 || t3.distance(atom2) < t3.distance(atom) && atom2.getCovalentBondCount() != 1) {
                Atom atom3 = atom2;
                atom2 = atom;
                atom = atom3;
            }
            if (Measure.computeAngleABC(t3, atom2, atom, true) > 90.0f || Measure.computeAngleABC(t3, atom, atom2, true) > 90.0f) {
                bS = this.getBranchBitSet(atom.index, atom2.index, true);
            }
            if (bS != null) {
                int n5 = 0;
                int n6 = atom2.getBonds().length;
                while (--n6 >= 0) {
                    if (!bS.get(atom2.getBondedAtomIndex(n6)) || ++n5 != 2) continue;
                    bS = null;
                    break;
                }
            }
            if (bS == null) {
                bS = this.getMoleculeBitSet(atom2.index);
            }
            this.bsRotateBranch = bS;
            this.rotatePrev1 = atom2.index;
            this.rotatePrev2 = atom.index;
        } else {
            atom2 = this.modelSet.atoms[this.rotatePrev1];
            atom = this.modelSet.atoms[this.rotatePrev2];
        }
        object = V3.new3(atom.sX - atom2.sX, atom.sY - atom2.sY, 0.0f);
        t3 = V3.new3(n, n2, 0.0f);
        ((V3)object).cross((V3)object, (V3)t3);
        float f = (float)(((V3)object).z > 0.0f ? 1 : -1) * t3.length();
        BS bS2 = BSUtil.copy(bS);
        bS2.andNot(this.selectionManager.getMotionFixedAtoms());
        this.rotateAboutPointsInternal(this.eval, atom2, atom, 0.0f, f, false, bS2, null, null, null);
    }

    public void refreshMeasures(boolean bl) {
        this.setShapeProperty(6, "refresh", null);
        if (bl) {
            this.stopMinimization();
        }
    }

    public float[][] functionXY(String string, int n, int n2) {
        float[][] fArray;
        String string2 = null;
        if (string.indexOf("file:") == 0) {
            string2 = this.getFileAsString(string.substring(5));
        } else if (string.indexOf("data2d_") != 0) {
            return this.statusManager.functionXY(string, n, n2);
        }
        n = Math.abs(n);
        n2 = Math.abs(n2);
        if (string2 == null) {
            fArray = this.getDataFloat2D(string);
            if (fArray != null) {
                return fArray;
            }
            string2 = "";
        }
        fArray = new float[n][n2];
        float[] fArray2 = new float[n * n2];
        Parser.parseStringInfestedFloatArray(string2, null, fArray2);
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                fArray[i][j] = fArray2[n3++];
            }
        }
        return fArray;
    }

    public float[][][] functionXYZ(String string, int n, int n2, int n3) {
        float[][][] fArray;
        String string2 = null;
        if (string.indexOf("file:") == 0) {
            string2 = this.getFileAsString(string.substring(5));
        } else if (string.indexOf("data3d_") != 0) {
            return this.statusManager.functionXYZ(string, n, n2, n3);
        }
        n = Math.abs(n);
        n2 = Math.abs(n2);
        n3 = Math.abs(n3);
        if (string2 == null) {
            fArray = this.getDataFloat3D(string);
            if (fArray != null) {
                return fArray;
            }
            string2 = "";
        }
        fArray = new float[n][n2][n3];
        float[] fArray2 = new float[n * n2 * n3];
        Parser.parseStringInfestedFloatArray(string2, null, fArray2);
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    fArray[i][j][k] = fArray2[n4++];
                }
            }
        }
        return fArray;
    }

    @Override
    public String extractMolData(String string) {
        if (string == null) {
            int n = this.getCurrentModelIndex();
            if (n < 0) {
                return null;
            }
            string = this.getModelNumberDotted(n);
        }
        return this.getModelExtract(string, true, false, "V2000");
    }

    public String getNMRPredict(boolean bl) {
        String string = this.getModelExtract("selected", true, false, "V2000");
        int n = string.indexOf("\n");
        string = "Jmol " + version_date + string.substring(n);
        if (bl) {
            if (this.isApplet) {
                this.showUrl(this.global.nmrUrlFormat + string);
            } else {
                this.syncScript("true", "*", 0);
                this.syncScript("JSpecView:", ".", 0);
            }
            return null;
        }
        String string2 = this.global.nmrPredictFormat + string;
        return this.getFileAsString(string2);
    }

    public void getHelp(String string) {
        if (this.global.helpPath.indexOf("?") < 0) {
            if (string.length() > 0 && string.indexOf("?") != 0) {
                string = "?search=" + PT.simpleReplace(string, " ", "%20");
            }
            string = string + (string.length() == 0 ? "?ver=" : "&ver=") + JC.version;
        } else {
            string = "&" + string;
        }
        this.showUrl(this.global.helpPath + string);
    }

    public void show2D(String string) {
        this.showUrl((String)this.setLoadFormat("_" + string, '2', false));
    }

    public String getChemicalInfo(String string, char c, String string2) {
        String string3 = (String)this.setLoadFormat("_" + string, c, false);
        if (c == '/') {
            string3 = string3 + PT.simpleReplace(string2, " ", "%20");
        }
        return this.getFileAsString4(string3, -1, false, false, false);
    }

    public void addCommand(String string) {
        if (this.autoExit || !this.haveDisplay || !this.getPreserveState()) {
            return;
        }
        this.commandHistory.addCommand(PT.replaceAllCharacters(string, "\r\n\t", " "));
    }

    public String removeCommand() {
        return this.commandHistory.removeCommand();
    }

    @Override
    public String getSetHistory(int n) {
        return this.commandHistory.getSetHistory(n);
    }

    public OC getOutputChannel(String string, String[] stringArray) {
        return this.getOutputManager().getOutputChannel(string, stringArray);
    }

    @Override
    public void writeTextFile(String string, String string2) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("fileName", string);
        hashtable.put("type", "txt");
        hashtable.put("text", string2);
        this.outputToFile(hashtable);
    }

    @Override
    public String clipImageOrPasteText(String string) {
        if (!this.haveAccess(ACCESS.ALL)) {
            return "no";
        }
        return this.getOutputManager().clipImageOrPasteText(string);
    }

    @Override
    public String getClipboardText() {
        if (!this.haveAccess(ACCESS.ALL)) {
            return "no";
        }
        try {
            return this.getOutputManager().getClipboardText();
        }
        catch (Error error) {
            return GT._("clipboard is not accessible -- use signed applet");
        }
    }

    public String processWriteOrCapture(Map<String, Object> map) {
        return this.getOutputManager().processWriteOrCapture(map);
    }

    public String createZip(String string, String string2, String[] stringArray) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("fileName", string);
        hashtable.put("type", string2);
        hashtable.put("text", this.getStateInfo());
        if (stringArray != null) {
            hashtable.put("scripts", stringArray);
        }
        return this.getOutputManager().outputToFile(hashtable);
    }

    @Override
    public String outputToFile(Map<String, Object> map) {
        return this.getOutputManager().outputToFile(map);
    }

    private OutputManager getOutputManager() {
        if (this.outputManager != null) {
            return this.outputManager;
        }
        this.outputManager = (OutputManager)Interface.getOptionInterface(this.isJS && !this.isWebGL ? "viewer.OutputManagerJS" : "viewer.OutputManagerAwt");
        return this.outputManager.setViewer(this, this.privateKey);
    }

    private void setSyncTarget(int n, boolean bl) {
        switch (n) {
            case 0: {
                this.statusManager.syncingMouse = bl;
                break;
            }
            case 1: {
                this.statusManager.syncingScripts = bl;
                break;
            }
            case 2: {
                this.statusManager.syncSend(bl ? SYNC_GRAPHICS_MESSAGE : SYNC_NO_GRAPHICS_MESSAGE, "*", 0);
                if (Float.isNaN(this.transformManager.stereoDegrees)) {
                    this.setFloatProperty("stereoDegrees", -5.0f);
                }
                if (bl) {
                    this.setBooleanProperty("_syncMouse", false);
                    this.setBooleanProperty("_syncScript", false);
                }
                return;
            }
        }
        if (!this.statusManager.syncingScripts && !this.statusManager.syncingMouse) {
            this.refresh(-1, "set sync");
        }
    }

    @Override
    public void syncScript(String string, String string2, int n) {
        this.getStateCreator().syncScript(string, string2, n);
    }

    public int getModelIndexFromId(String string) {
        return this.modelSet.getModelIndexFromId(string);
    }

    public void setSyncDriver(int n) {
        this.statusManager.setSyncDriver(n);
    }

    public float[] getPartialCharges() {
        return this.modelSet.getPartialCharges();
    }

    public void setProteinType(EnumStructure enumStructure, BS bS) {
        this.modelSet.setProteinType(bS == null ? this.getSelectionSet(false) : bS, enumStructure);
    }

    @Override
    public P3 getBondPoint3f1(int n) {
        return this.modelSet.getBondAtom1(n);
    }

    @Override
    public P3 getBondPoint3f2(int n) {
        return this.modelSet.getBondAtom2(n);
    }

    public Vibration getVibration(int n) {
        return this.modelSet.getVibration(n, false);
    }

    public int getVanderwaalsMar(int n) {
        return this.defaultVdw == EnumVdw.USER ? this.userVdwMars[n] : Elements.getVanderwaalsMar(n, this.defaultVdw);
    }

    public int getVanderwaalsMarType(int n, EnumVdw enumVdw) {
        if (enumVdw == null) {
            enumVdw = this.defaultVdw;
        } else {
            switch (enumVdw) {
                case USER: {
                    if (this.bsUserVdws == null) {
                        enumVdw = this.defaultVdw;
                        break;
                    }
                    return this.userVdwMars[n & 0x7F];
                }
                case AUTO: 
                case JMOL: 
                case BABEL: 
                case RASMOL: {
                    if (this.defaultVdw == EnumVdw.AUTO) break;
                    enumVdw = this.defaultVdw;
                }
            }
        }
        return Elements.getVanderwaalsMar(n, enumVdw);
    }

    void setVdwStr(String string) {
        EnumVdw enumVdw = EnumVdw.getVdwType(string);
        if (enumVdw == null) {
            enumVdw = EnumVdw.AUTO;
        }
        switch (enumVdw) {
            case USER: 
            case AUTO: 
            case JMOL: 
            case BABEL: 
            case RASMOL: {
                break;
            }
            default: {
                enumVdw = EnumVdw.JMOL;
            }
        }
        if (enumVdw != this.defaultVdw && enumVdw == EnumVdw.USER && this.bsUserVdws == null) {
            this.setUserVdw(this.defaultVdw);
        }
        this.defaultVdw = enumVdw;
        this.global.setS("defaultVDW", enumVdw.getVdwLabel());
    }

    void setUserVdw(EnumVdw enumVdw) {
        this.userVdwMars = new int[Elements.elementNumberMax];
        this.userVdws = new float[Elements.elementNumberMax];
        this.bsUserVdws = new BS();
        if (enumVdw == EnumVdw.USER) {
            enumVdw = EnumVdw.JMOL;
        }
        for (int i = 1; i < Elements.elementNumberMax; ++i) {
            this.userVdwMars[i] = Elements.getVanderwaalsMar(i, enumVdw);
            this.userVdws[i] = (float)this.userVdwMars[i] / 1000.0f;
        }
    }

    public String getDefaultVdwNameOrData(int n, EnumVdw enumVdw, BS bS) {
        switch (n) {
            case -2147483648: {
                return this.defaultVdw.getVdwLabel();
            }
            case 0x7FFFFFFF: {
                bS = this.bsUserVdws;
                if (bS == null) {
                    return "";
                }
                enumVdw = EnumVdw.USER;
            }
        }
        if (enumVdw == null || enumVdw == EnumVdw.AUTO) {
            enumVdw = this.defaultVdw;
        }
        if (enumVdw == EnumVdw.USER && this.bsUserVdws == null) {
            this.setUserVdw(this.defaultVdw);
        }
        return this.getDataManager().getDefaultVdwNameOrData(enumVdw, bS);
    }

    public int deleteAtoms(BS bS, boolean bl) {
        int n;
        int n2 = n = bS == null ? -1 : bS.nextSetBit(0);
        if (n < 0) {
            return 0;
        }
        this.clearModelDependentObjects();
        if (!bl) {
            this.statusManager.modifySend(n, this.modelSet.atoms[n].modelIndex, 4);
            this.modelSet.deleteAtoms(bS);
            int n3 = this.selectionManager.deleteAtoms(bS);
            this.setTainted(true);
            this.statusManager.modifySend(n, this.modelSet.atoms[n].modelIndex, -4);
            return n3;
        }
        short s = this.modelSet.atoms[n].modelIndex;
        this.statusManager.modifySend(-1, s, 5);
        this.setCurrentModelIndexClear(0, false);
        this.animationManager.setAnimationOn(false);
        BS bS2 = BSUtil.copy(this.getDeletedAtoms());
        BS bS3 = this.modelSet.deleteModels(bS);
        this.selectionManager.processDeletedModelAtoms(bS3);
        this.setAnimationRange(0, 0);
        if (this.eval != null) {
            this.eval.deleteAtomsInVariables(bS3);
        }
        this.clearRepaintManager(-1);
        this.animationManager.clear();
        this.animationManager.initializePointers(1);
        this.setCurrentModelIndexClear(this.getModelCount() > 1 ? -1 : 0, this.getModelCount() > 1);
        this.hoverAtomIndex = -1;
        this.setFileLoadStatus(EnumFileStatus.DELETED, null, null, null, null, null);
        this.refreshMeasures(true);
        if (bS2 != null) {
            bS3.andNot(bS2);
        }
        this.statusManager.modifySend(-1, s, -5);
        return BSUtil.cardinalityOf(bS3);
    }

    public void deleteBonds(BS bS) {
        this.modelSet.deleteBonds(bS, false);
    }

    public void deleteModelAtoms(int n, int n2, BS bS) {
        this.selectionManager.deleteModelAtoms(bS);
        BSUtil.deleteBits(this.getFrameOffsets(), bS);
        this.setFrameOffsets(this.getFrameOffsets());
        this.getDataManager().deleteModelAtoms(n, n2, bS);
    }

    public BS getDeletedAtoms() {
        return this.selectionManager.getDeletedAtoms();
    }

    public char getQuaternionFrame() {
        return this.global.quaternionFrame.charAt(this.global.quaternionFrame.length() == 2 ? 1 : 0);
    }

    public String calculatePointGroup() {
        return this.modelSet.calculatePointGroup(this.getSelectionSet(false));
    }

    public Map<String, Object> getPointGroupInfo(Object object) {
        return this.modelSet.getPointGroupInfo(this.getAtomBitSet(object));
    }

    public String getPointGroupAsString(boolean bl, String string, int n, float f) {
        return this.modelSet.getPointGroupAsString(this.getSelectionSet(false), bl, string, n, f);
    }

    public void loadImage(String string, String string2) {
        this.fileManager.loadImage(string, string2);
    }

    void loadImageData(Object object, String string, String string2, ScriptContext scriptContext) {
        if (string == null) {
            return;
        }
        if (object == null) {
            Logger.info(string);
        }
        if (string2 == null) {
            this.setBackgroundImage(object == null ? null : string, object);
        } else {
            this.loadShape(30);
            this.setShapeProperty(30, "text", string);
            if (object != null) {
                this.setShapeProperty(30, "image", object);
            }
        }
        if (scriptContext != null) {
            scriptContext.mustResumeEval = true;
            this.eval.resumeEval(scriptContext);
        }
    }

    public String cd(String string) {
        String string2;
        if (string == null) {
            string = ".";
        } else if (string.length() == 0) {
            this.setStringProperty("defaultDirectory", "");
            string = ".";
        }
        string = this.fileManager.getDefaultDirectory(string + (string.equals("=") ? "" : (string.endsWith("/") ? "X.spt" : "/X.spt")));
        if (string.length() > 0) {
            this.setStringProperty("defaultDirectory", string);
        }
        if ((string2 = this.fileManager.getFilePath(string + "/", true, false)).startsWith("file:/")) {
            FileManager.setLocalPath(this, string, false);
        }
        return string;
    }

    public String setErrorMessage(String string, String string2) {
        this.errorMessageUntranslated = string2;
        if (string != null) {
            this.eval.stopScriptThreads();
        }
        this.errorMessage = string;
        return this.errorMessage;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public String getErrorMessageUn() {
        return this.errorMessageUntranslated == null ? this.errorMessage : this.errorMessageUntranslated;
    }

    public void setShapeErrorState(int n, String string) {
        this.currentShapeID = n;
        this.currentShapeState = string;
    }

    public String getShapeErrorState() {
        if (this.currentShapeID < 0) {
            return "";
        }
        if (this.modelSet != null) {
            this.shapeManager.releaseShape(this.currentShapeID);
        }
        this.clearRepaintManager(this.currentShapeID);
        return JC.getShapeClassName(this.currentShapeID, false) + " " + this.currentShapeState;
    }

    public void handleError(Error error, boolean bl) {
        try {
            if (bl) {
                this.zapMsg("" + error);
            }
            this.undoClear();
            if (Logger.getLogLevel() == 0) {
                Logger.setLogLevel(4);
            }
            this.setCursor(0);
            this.setBooleanProperty("refreshing", true);
            this.fileManager.setPathForAllFiles("");
            Logger.error("viewer handling error condition: " + error + "  ");
            if (!this.isJS) {
                error.printStackTrace();
            }
            this.notifyError("Error", "doClear=" + bl + "; " + error, "" + error);
        }
        catch (Throwable throwable) {
            try {
                Logger.error("Could not notify error " + error + ": due to " + throwable);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
    }

    public float[] getAtomicCharges() {
        return this.modelSet.getAtomicCharges();
    }

    public Map<String, JmolScriptFunction> getFunctions(boolean bl) {
        return bl ? staticFunctions : this.localFunctions;
    }

    public void removeFunction(String string) {
        JmolScriptFunction jmolScriptFunction = this.getFunction(string);
        if (jmolScriptFunction == null) {
            return;
        }
        staticFunctions.remove(string);
        this.localFunctions.remove(string);
    }

    public JmolScriptFunction getFunction(String string) {
        if (string == null) {
            return null;
        }
        JmolScriptFunction jmolScriptFunction = (Viewer.isStaticFunction(string) ? staticFunctions : this.localFunctions).get(string);
        return jmolScriptFunction == null || jmolScriptFunction.geTokens() == null ? null : jmolScriptFunction;
    }

    private static boolean isStaticFunction(String string) {
        return string.startsWith("static_");
    }

    public boolean isFunction(String string) {
        return (Viewer.isStaticFunction(string) ? staticFunctions : this.localFunctions).containsKey(string);
    }

    public void clearFunctions() {
        staticFunctions.clear();
        this.localFunctions.clear();
    }

    public void addFunction(JmolScriptFunction jmolScriptFunction) {
        String string = jmolScriptFunction.getName();
        (Viewer.isStaticFunction(string) ? staticFunctions : this.localFunctions).put(string, jmolScriptFunction);
    }

    public String getFunctionCalls(String string) {
        return this.getStateCreator().getFunctionCalls(string);
    }

    public void showMessage(String string) {
        if (!this.isPrintOnly) {
            Logger.warn(string);
        }
    }

    public String getMoInfo(int n) {
        return this.modelSet.getMoInfo(n);
    }

    public boolean checkPrivateKey(double d) {
        return d == this.privateKey;
    }

    public void bindAction(String string, String string2) {
        if (this.haveDisplay) {
            this.actionManager.bindAction(string, string2);
        }
    }

    public void unBindAction(String string, String string2) {
        if (this.haveDisplay) {
            this.actionManager.unbindAction(string, string2);
        }
    }

    public Object getMouseInfo() {
        return this.haveDisplay ? this.actionManager.getMouseInfo() : null;
    }

    public int getFrontPlane() {
        return this.transformManager.getFrontPlane();
    }

    public javajs.util.List<Object> getPlaneIntersection(int n, P4 p4, float f, int n2) {
        return this.modelSet.getPlaneIntersection(n, p4, f, n2, this.animationManager.currentModelIndex);
    }

    public int calculateStruts(BS bS, BS bS2) {
        return this.modelSet.calculateStruts(bS == null ? this.getSelectionSet(false) : bS, bS2 == null ? this.getSelectionSet(false) : bS2);
    }

    public boolean getPreserveState() {
        return this.global.preserveState && this.scriptManager != null;
    }

    boolean isKiosk() {
        return this.isKiosk;
    }

    public boolean hasFocus() {
        return this.haveDisplay && (this.isKiosk || this.apiPlatform.hasFocus(this.display));
    }

    public void setFocus() {
        if (this.haveDisplay && !this.apiPlatform.hasFocus(this.display)) {
            this.apiPlatform.requestFocusInWindow(this.display);
        }
    }

    public MinimizerInterface getMinimizer(boolean bl) {
        if (this.minimizer == null && bl) {
            this.minimizer = (MinimizerInterface)Interface.getOptionInterface("minimize.Minimizer");
            this.minimizer.setProperty("viewer", this);
        }
        return this.minimizer;
    }

    void stopMinimization() {
        if (this.minimizer != null) {
            this.minimizer.setProperty("stop", null);
        }
    }

    void clearMinimization() {
        if (this.minimizer != null) {
            this.minimizer.setProperty("clear", null);
        }
    }

    public String getMinimizationInfo() {
        return this.minimizer == null ? "" : (String)this.minimizer.getProperty("log", 0);
    }

    private void checkMinimization() {
        this.refreshMeasures(true);
        if (!this.global.monitorEnergy) {
            return;
        }
        this.minimize(0, 0.0f, this.getAllAtoms(), null, 0.0f, false, false, true, false);
        this.echoMessage(this.getParameter("_minimizationForceField") + " Energy = " + this.getParameter("_minimizationEnergy"));
    }

    public void minimize(int n, float f, BS bS, BS bS2, float f2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        block11: {
            boolean bl5;
            String string = this.global.forceField;
            BS bS3 = this.getModelUndeletedAtomsBitSetBs(this.getVisibleFramesBitSet());
            if (bS == null) {
                bS = this.getModelUndeletedAtomsBitSet(this.getVisibleFramesBitSet().length() - 1);
            } else {
                bS.and(bS3);
            }
            if (f2 <= 0.0f) {
                f2 = 5.0f;
            }
            BS bS4 = BSUtil.copy(bS2 == null ? this.selectionManager.getMotionFixedAtoms() : bS2);
            boolean bl6 = bl5 = bS4.cardinality() > 0;
            if (bl5) {
                bS.andNot(bS4);
            }
            BS bS5 = bl2 ? new BS() : this.getAtomsWithinRadius(f2, bS, true, null);
            bS5.andNot(bS);
            if (bl5) {
                bS4.and(bS5);
            } else {
                bS4 = bS5;
            }
            bS4.and(bS3);
            if (bl) {
                bS.or(this.addHydrogens(bS, bl4, bl3));
            }
            if (bS.cardinality() > 200) {
                Logger.error("Too many atoms for minimization (>200)");
                return;
            }
            try {
                if (!bl3) {
                    Logger.info("Minimizing " + bS.cardinality() + " atoms");
                }
                this.getMinimizer(true).minimize(n, f, bS, bS4, bl5, bl3, string);
            }
            catch (Exception exception) {
                Logger.error("Minimization error: " + exception.toString());
                if (this.isJS) break block11;
                exception.printStackTrace();
            }
        }
    }

    public void setMotionFixedAtoms(BS bS) {
        this.selectionManager.setMotionFixedAtoms(bS);
    }

    public BS getMotionFixedAtoms() {
        return this.selectionManager.getMotionFixedAtoms();
    }

    void rotateArcBall(int n, int n2, float f) {
        this.transformManager.rotateArcBall(n, n2, f);
        this.refresh(2, this.statusManager.syncingMouse ? "Mouse: rotateArcBall " + n + " " + n2 + " " + f : "");
    }

    void getAtomicPropertyState(SB sB, byte by, BS bS, String string, float[] fArray) {
        this.getStateCreator().getAtomicPropertyStateBuffer(sB, by, bS, string, fArray);
    }

    public P3[][] getCenterAndPoints(javajs.util.List<Object[]> list, boolean bl) {
        return this.modelSet.getCenterAndPoints(list, bl);
    }

    public String writeFileData(String string, String string2, int n, Object[] objectArray) {
        return this.getOutputManager().writeFileData(string, string2, n, objectArray);
    }

    public String getPdbData(int n, String string, Object[] objectArray) {
        return this.modelSet.getPdbData(n, string, this.getSelectionSet(false), objectArray, null);
    }

    public BS getGroupsWithin(int n, BS bS) {
        return this.modelSet.getGroupsWithin(n, bS);
    }

    public Object getExecutor() {
        if (this.executor != null || nProcessors < 2) {
            return this.executor;
        }
        try {
            this.executor = ((JmolParallelProcessor)Interface.getOptionInterface("parallel.ScriptParallelProcessor")).getExecutor();
        }
        catch (Exception exception) {
            this.executor = null;
        }
        catch (Error error) {
            this.executor = null;
        }
        if (this.executor == null) {
            Logger.error("parallel processing is not available");
        }
        return this.executor;
    }

    public Map<String, Object> getShapeInfo() {
        return this.shapeManager.getShapeInfo();
    }

    public void togglePickingLabel(BS bS) {
        if (bS == null) {
            bS = this.getSelectionSet(false);
        }
        this.loadShape(5);
        this.shapeManager.setShapePropertyBs(5, "toggleLabel", null, bS);
    }

    public void loadShape(int n) {
        this.shapeManager.loadShape(n);
    }

    public void setShapeSize(int n, int n2, BS bS) {
        if (bS == null) {
            bS = this.getSelectionSet(false);
        }
        this.shapeManager.setShapeSizeBs(n, n2, null, bS);
    }

    public void setShapeSizeRD(int n, RadiusData radiusData, BS bS) {
        this.shapeManager.setShapeSizeBs(n, 0, radiusData, bS);
    }

    public void setShapeProperty(int n, String string, Object object) {
        if (n < 0) {
            return;
        }
        this.shapeManager.setShapePropertyBs(n, string, object, null);
    }

    public Object getShapeProperty(int n, String string) {
        return this.shapeManager.getShapePropertyIndex(n, string, Integer.MIN_VALUE);
    }

    public boolean getShapePropertyData(int n, String string, Object[] objectArray) {
        return this.shapeManager.getShapePropertyData(n, string, objectArray);
    }

    public Object getShapePropertyIndex(int n, String string, int n2) {
        return this.shapeManager.getShapePropertyIndex(n, string, n2);
    }

    private int getShapePropertyAsInt(int n, String string) {
        Object object = this.getShapeProperty(n, string);
        return object == null || !(object instanceof Integer) ? Integer.MIN_VALUE : (Integer)object;
    }

    public void setModelVisibility() {
        if (this.shapeManager == null) {
            return;
        }
        this.shapeManager.setModelVisibility();
    }

    public void resetShapes(boolean bl) {
        this.shapeManager.resetShapes();
        if (bl) {
            this.shapeManager.loadDefaultShapes(this.modelSet);
            this.clearRepaintManager(-1);
        }
    }

    public void setAtomLabel(String string, int n) {
        this.shapeManager.setAtomLabel(string, n);
    }

    public void deleteShapeAtoms(Object[] objectArray, BS bS) {
        this.shapeManager.deleteShapeAtoms(objectArray, bS);
    }

    public void resetBioshapes(BS bS) {
        this.shapeManager.resetBioshapes(bS);
    }

    public float getAtomShapeValue(int n, Group group, int n2) {
        return this.shapeManager.getAtomShapeValue(n, group, n2);
    }

    public void mergeShapes(Shape[] shapeArray) {
        this.shapeManager.mergeShapes(shapeArray);
    }

    public ShapeManager getShapeManager() {
        return this.shapeManager;
    }

    public boolean setParallel(boolean bl) {
        this.isParallel = this.global.multiProcessor && bl;
        return this.isParallel;
    }

    public boolean isParallel() {
        return this.global.multiProcessor && this.isParallel;
    }

    public BS getRenderableBitSet() {
        return this.shapeManager.getRenderableBitSet();
    }

    private void setAtomPickingOption(String string) {
        if (this.haveDisplay) {
            this.actionManager.setAtomPickingOption(string);
        }
    }

    private void setBondPickingOption(String string) {
        if (this.haveDisplay) {
            this.actionManager.setBondPickingOption(string);
        }
    }

    void undoClear() {
        this.actionStates.clear();
        this.actionStatesRedo.clear();
    }

    public void undoMoveAction(int n, int n2) {
        this.getStateCreator().undoMoveAction(n, n2);
    }

    void undoMoveActionClear(int n, int n2, boolean bl) {
        if (!this.global.preserveState) {
            return;
        }
        this.getStateCreator().undoMoveActionClear(n, n2, bl);
    }

    public void assignBond(int n, char c) {
        try {
            BS bS = this.modelSet.setBondOrder(n, c);
            if (bS == null || c == '0') {
                this.refresh(3, "setBondOrder");
            } else {
                this.addHydrogens(bS, false, true);
            }
        }
        catch (Exception exception) {
            Logger.error("assignBond failed");
        }
    }

    public void assignAtom(int n, P3 p3, String string) {
        if (string.equals("X")) {
            this.setRotateBondIndex(-1);
        }
        if (this.modelSet.atoms[n].modelIndex != this.modelSet.modelCount - 1) {
            return;
        }
        this.clearModelDependentObjects();
        if (p3 == null) {
            this.statusManager.modifySend(n, this.modelSet.atoms[n].modelIndex, 1);
            int n2 = this.modelSet.getAtomCount();
            this.modelSet.assignAtom(n, string, true);
            if (!PT.isOneOf(string, ";Mi;Pl;X;")) {
                this.modelSet.setAtomNamesAndNumbers(n, -n2, null);
            }
            this.statusManager.modifySend(n, this.modelSet.atoms[n].modelIndex, -1);
            this.refresh(3, "assignAtom");
            return;
        }
        Atom atom = this.modelSet.atoms[n];
        BS bS = BSUtil.newAndSetBit(n);
        P3[] p3Array = new P3[]{p3};
        javajs.util.List<Atom> list = new javajs.util.List<Atom>();
        list.addLast(atom);
        short s = atom.modelIndex;
        this.statusManager.modifySend(n, s, 3);
        try {
            bS = this.addHydrogensInline(bS, list, p3Array);
            n = bS.nextSetBit(0);
            this.modelSet.assignAtom(n, string, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.modelSet.setAtomNamesAndNumbers(n, -1, null);
        this.statusManager.modifySend(n, s, -3);
    }

    public void assignConnect(int n, int n2) {
        this.clearModelDependentObjects();
        float[][] fArray = AU.newFloat2(1);
        fArray[0] = new float[]{n, n2};
        short s = this.modelSet.atoms[n].modelIndex;
        this.statusManager.modifySend(n, s, 2);
        this.modelSet.connect(fArray);
        this.modelSet.assignAtom(n, ".", true);
        this.modelSet.assignAtom(n2, ".", true);
        this.statusManager.modifySend(n, s, -2);
        this.refresh(3, "assignConnect");
    }

    protected void moveAtomWithHydrogens(int n, int n2, int n3, int n4, BS bS) {
        this.stopMinimization();
        if (bS == null) {
            Atom atom = this.modelSet.atoms[n];
            bS = BSUtil.newAndSetBit(n);
            Bond[] bondArray = atom.getBonds();
            if (bondArray != null) {
                for (int i = 0; i < bondArray.length; ++i) {
                    Atom atom2 = bondArray[i].getOtherAtom(atom);
                    if (atom2.getElementNumber() != 1) continue;
                    bS.set(atom2.index);
                }
            }
        }
        this.moveSelected(n2, n3, n4, Integer.MIN_VALUE, Integer.MIN_VALUE, bS, true, true);
    }

    public boolean isAtomPDB(int n) {
        return this.modelSet.isAtomPDB(n);
    }

    public boolean isModelPDB(int n) {
        return this.modelSet.models[n].isBioModel;
    }

    boolean isAtomAssignable(int n) {
        return this.modelSet.isAtomAssignable(n);
    }

    @Override
    public void deleteMeasurement(int n) {
        this.setShapeProperty(6, "delete", n);
    }

    boolean haveModelKit() {
        return this.modelSet.haveModelKit();
    }

    BS getModelKitStateBitSet(BS bS, BS bS2) {
        return this.modelSet.getModelKitStateBitset(bS, bS2);
    }

    public String getSmiles(int n, int n2, BS bS, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        JmolNode[] jmolNodeArray = this.modelSet.atoms;
        if (bS == null) {
            if (n < 0 || n2 < 0) {
                bS = this.getSelectionSet(true);
            } else {
                if (bl) {
                    if (n > n2) {
                        int n3 = n;
                        n = n2;
                        n2 = n3;
                    }
                    n = jmolNodeArray[n].getGroup().firstAtomIndex;
                    n2 = ((Atom)jmolNodeArray[n2]).getGroup().lastAtomIndex;
                }
                bS = new BS();
                bS.setBits(n, n2 + 1);
            }
        }
        String string = bl4 ? Viewer.getJmolVersion() + " " + this.getModelName(this.getCurrentModelIndex()) : null;
        return this.getSmilesMatcher().getSmiles(jmolNodeArray, this.getAtomCount(), bS, bl, bl2, bl3, string);
    }

    public void connect(float[][] fArray) {
        this.modelSet.connect(fArray);
    }

    public String prompt(String string, String string2, String[] stringArray, boolean bl) {
        return this.isKiosk ? "null" : this.apiPlatform.prompt(string, string2, stringArray, bl);
    }

    public ColorEncoder getColorEncoder(String string) {
        return this.colorManager.getColorEncoder(string);
    }

    public void displayBonds(BondSet bondSet, boolean bl) {
        this.modelSet.displayBonds(bondSet, bl);
    }

    public String getModelAtomProperty(Atom atom, String string) {
        return this.modelSet.getModelAtomProperty(atom, string);
    }

    public void setStateScriptVersion(String string) {
        if (string != null) {
            String[] stringArray = PT.getTokens(string.replace('.', ' ').replace('_', ' '));
            try {
                int n = PT.parseInt(stringArray[0]);
                int n2 = PT.parseInt(stringArray[1]);
                int n3 = PT.parseInt(stringArray[2]);
                if (n3 == Integer.MIN_VALUE) {
                    n3 = 0;
                }
                if (n != Integer.MIN_VALUE && n2 != Integer.MIN_VALUE) {
                    this.stateScriptVersionInt = n * 10000 + n2 * 100 + n3;
                    this.global.legacyAutoBonding = this.stateScriptVersionInt < 110924;
                    this.global.legacyHAddition = this.stateScriptVersionInt < 130117;
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setBooleanProperty("legacyautobonding", false);
        this.stateScriptVersionInt = Integer.MAX_VALUE;
    }

    public JmolRendererInterface initializeExporter(Map<String, Object> map) {
        Object object;
        Object object2;
        String string;
        boolean bl = map.get("type").equals("JS");
        if (bl) {
            if (this.jsExporter3D != null) {
                this.jsExporter3D.initializeOutput(this, this.privateKey, this.gdata, map);
                return this.jsExporter3D;
            }
            string = "org.jmol.exportjs.Export3D";
        } else {
            object2 = (String)map.get("fileName");
            OC oC = this.getOutputChannel((String)object2, (String[])(object = (String[])map.get("fullPath")));
            if (oC == null) {
                return null;
            }
            map.put("outputChannel", oC);
            string = "org.jmol.export.Export3D";
        }
        object2 = null;
        try {
            object = Class.forName(string);
            object2 = (JmolRendererInterface)((Class)object).newInstance();
        }
        catch (Exception exception) {
            return null;
        }
        object = object2.initializeExporter(this, this.privateKey, this.gdata, map);
        if (bl && object != null) {
            this.jsExporter3D = object2;
        }
        return object == null ? null : object2;
    }

    public boolean getMouseEnabled() {
        return this.refreshing && !this.creatingImage;
    }

    public void setZslabPoint(P3 p3) {
        this.transformManager.setZslabPoint(p3);
    }

    @Override
    public void calcAtomsMinMax(BS bS, BoxInfo boxInfo) {
        this.modelSet.calcAtomsMinMax(bS, boxInfo);
    }

    public void getObjectMap(Map<String, ?> map, char c) {
        switch (c) {
            case '{': {
                if (this.getScriptManager() != null) {
                    Map<String, Object> map2 = map;
                    Map<String, Object> map3 = this.eval.getDefinedAtomSets();
                    if (map3 != null) {
                        map2.putAll(map3);
                    }
                    T.getTokensType(map2, 0x300000);
                }
                return;
            }
            case '$': 
            case '0': {
                this.shapeManager.getObjectMap(map, c == '$');
                return;
            }
        }
    }

    public String[][] getPdbBondInfo(String string) {
        String[][] stringArray;
        if (this.htPdbBondInfo == null) {
            this.htPdbBondInfo = new Hashtable<String, String[][]>();
        }
        if ((stringArray = this.htPdbBondInfo.get(string)) != null) {
            return stringArray;
        }
        stringArray = JC.getPdbBondInfo(Group.lookupGroupID(string), this.global.legacyHAddition);
        this.htPdbBondInfo.put(string, stringArray);
        return stringArray;
    }

    public void setPicked(int n) {
        this.global.setPicked(n);
    }

    @Override
    public String runScript(String string) {
        SB sB = new SB();
        try {
            if (this.getScriptManager() == null) {
                return null;
            }
            this.eval.runScriptBuffer(string, sB);
        }
        catch (Exception exception) {
            return this.eval.getErrorMessage();
        }
        return sB.toString();
    }

    public boolean allowSpecAtom() {
        return this.modelSet.allowSpecAtom();
    }

    public void setFrameDelayMs(long l) {
        this.modelSet.setFrameDelayMs(l, this.getVisibleFramesBitSet());
    }

    public long getFrameDelayMs(int n) {
        return this.modelSet.getFrameDelayMs(n);
    }

    public BS getBaseModelBitSet() {
        return this.modelSet.getModelAtomBitSetIncludingDeleted(this.getJDXBaseModelIndex(this.getCurrentModelIndex()), true);
    }

    public Map<String, Object> getTimeouts() {
        return this.timeouts;
    }

    public void clearTimeouts() {
        if (this.timeouts != null) {
            TimeoutThread.clear(this.timeouts);
        }
    }

    public void setTimeout(String string, int n, String string2) {
        if (!this.haveDisplay || this.isHeadless() || this.autoExit) {
            return;
        }
        if (string == null) {
            this.clearTimeouts();
            return;
        }
        if (this.timeouts == null) {
            this.timeouts = new Hashtable<String, Object>();
        }
        TimeoutThread.setTimeout(this, this.timeouts, string, n, string2);
    }

    public void triggerTimeout(String string) {
        if (!this.haveDisplay || this.timeouts == null) {
            return;
        }
        TimeoutThread.trigger(this.timeouts, string);
    }

    public void clearTimeout(String string) {
        this.setTimeout(string, 0, null);
    }

    public String showTimeout(String string) {
        return this.haveDisplay ? TimeoutThread.showTimeout(this.timeouts, string) : "";
    }

    public void calculatePartialCharges(BS bS) {
        if (bS == null || bS.cardinality() == 0) {
            bS = this.getModelUndeletedAtomsBitSetBs(this.getVisibleFramesBitSet());
        }
        this.getMinimizer(true).calculatePartialCharges(this.modelSet.bonds, this.modelSet.bondCount, this.modelSet.atoms, bS);
    }

    public void setCurrentModelID(String string) {
        int n = this.getCurrentModelIndex();
        if (n >= 0) {
            this.modelSet.setModelAuxiliaryInfo(n, "modelID", string);
        }
    }

    public void setCentroid(BS bS, int[] nArray) {
        this.modelSet.setCentroid(bS, nArray);
    }

    public String getPathForAllFiles() {
        return this.fileManager.getPathForAllFiles();
    }

    public Object cacheGet(String string) {
        return this.fileManager.cacheGet(string, false);
    }

    public void cacheClear() {
        this.fileManager.cacheClear();
    }

    @Override
    public void cachePut(String string, Object object) {
        Logger.info("Viewer cachePut " + string);
        this.fileManager.cachePut(string, object);
    }

    @Override
    public int cacheFileByName(String string, boolean bl) {
        return this.fileManager.cacheFileByNameAdd(string, bl);
    }

    public Map<String, Integer> cacheList() {
        return this.fileManager.cacheList();
    }

    public void clearThreads() {
        if (this.eval != null) {
            this.eval.stopScriptThreads();
        }
        this.stopMinimization();
        this.setVibrationOff();
        this.setSpinOn(false);
        this.setNavOn(false);
        this.setAnimationOn(false);
    }

    public ScriptContext getEvalContextAndHoldQueue(JmolScriptEvaluator jmolScriptEvaluator) {
        ScriptContext scriptContext;
        if (jmolScriptEvaluator == null || !this.isJS) {
            return null;
        }
        jmolScriptEvaluator.pushContextDown("getEvalContextAndHoldQueue");
        ScriptContext scriptContext2 = scriptContext = jmolScriptEvaluator.getThisContext();
        while (scriptContext2 != null) {
            scriptContext2.mustResumeEval = true;
            scriptContext2 = scriptContext2.parentContext;
        }
        scriptContext.isJSThread = true;
        this.queueOnHold = true;
        return scriptContext;
    }

    public void checkInheritedShapes() {
        this.shapeManager.checkInheritedShapes();
    }

    @Override
    public Dimension resizeInnerPanel(int n, int n2) {
        if (this.autoExit || !this.haveDisplay) {
            this.setScreenDimension(n, n2);
            return this.dimScreen;
        }
        return this.statusManager.resizeInnerPanel(n, n2);
    }

    public String getFontLineShapeState(String string, String string2, TickInfo[] tickInfoArray) {
        return this.getStateCreator().getFontLineShapeState(string, string2, tickInfoArray);
    }

    public void getShapeSetState(AtomShape atomShape, Shape shape, int n, Group[] groupArray, BS bS, Map<String, BS> map, Map<String, BS> map2) {
        this.getStateCreator().getShapeSetState(atomShape, shape, n, groupArray, bS, map, map2);
    }

    public String getMeasurementState(Measures measures, javajs.util.List<Measurement> list, int n, Font font, TickInfo tickInfo) {
        return this.getStateCreator().getMeasurementState(measures, list, n, font, tickInfo);
    }

    public String getBondState(Shape shape, BS bS, boolean bl) {
        return this.getStateCreator().getBondState(shape, bS, bl);
    }

    public String getAtomShapeSetState(Shape shape, AtomShape[] atomShapeArray) {
        return this.getStateCreator().getAtomShapeSetState(shape, atomShapeArray);
    }

    public String getShapeState(Shape shape) {
        return this.getStateCreator().getShapeState(shape);
    }

    public String getAtomShapeState(AtomShape atomShape) {
        return this.getStateCreator().getAtomShapeState(atomShape);
    }

    public String getDefaultPropertyParam(int n) {
        return this.getPropertyManager().getDefaultPropertyParam(n);
    }

    public int getPropertyNumber(String string) {
        return this.getPropertyManager().getPropertyNumber(string);
    }

    public boolean checkPropertyParameter(String string) {
        return this.getPropertyManager().checkPropertyParameter(string);
    }

    public Object extractProperty(Object object, SV[] sVArray, int n) {
        return this.getPropertyManager().extractProperty(object, sVArray, n);
    }

    public BS addHydrogens(BS bS, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = bS == null;
        if (bS == null) {
            bS = this.getModelUndeletedAtomsBitSet(this.getVisibleFramesBitSet().length() - 1);
        }
        BS bS2 = new BS();
        if (bS.cardinality() == 0) {
            return bS2;
        }
        short s = this.modelSet.atoms[bS.nextSetBit((int)0)].modelIndex;
        if (s != this.modelSet.modelCount - 1) {
            return bS2;
        }
        javajs.util.List<Atom> list = new javajs.util.List<Atom>();
        P3[] p3Array = this.getAdditionalHydrogens(bS, bl3, false, list);
        boolean bl5 = false;
        bl5 = this.global.appendNew;
        if (p3Array.length > 0) {
            this.clearModelDependentObjects();
            try {
                bS2 = bl ? this.modelSet.addHydrogens(list, p3Array) : this.addHydrogensInline(bS, list, p3Array);
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
            if (bl5) {
                this.setAppendNew(true);
            }
        }
        if (!bl2) {
            this.scriptStatus(GT.i(GT._("{0} hydrogens added"), p3Array.length));
        }
        return bS2;
    }

    private BS addHydrogensInline(BS bS, javajs.util.List<Atom> list, P3[] p3Array) throws Exception {
        if (this.getScriptManager() == null) {
            return null;
        }
        return this.eval.addHydrogensInline(bS, list, p3Array);
    }

    @Override
    public float evalFunctionFloat(Object object, Object object2, float[] fArray) {
        return this.getScriptManager() == null ? 0.0f : this.eval.evalFunctionFloat(object, object2, fArray);
    }

    public boolean evalParallel(ScriptContext scriptContext, ShapeManager shapeManager) {
        this.displayLoadErrors = false;
        boolean bl = this.getScriptManager() != null && this.eval.evaluateParallel(scriptContext, shapeManager == null ? this.shapeManager : shapeManager);
        this.displayLoadErrors = true;
        return bl;
    }

    @Override
    public Object evaluateExpression(Object object) {
        if (this.getScriptManager() == null) {
            return null;
        }
        return this.eval.evaluateExpression(object, false);
    }

    public SV evaluateExpressionAsVariable(Object object) {
        if (this.getScriptManager() == null) {
            return null;
        }
        return (SV)this.eval.evaluateExpression(object, true);
    }

    public BS getAtomBitSet(Object object) {
        if (object instanceof BS) {
            return (BS)object;
        }
        this.getScriptManager();
        return this.getAtomBitSetEval(this.eval, object);
    }

    javajs.util.List<Integer> getAtomBitSetVector(Object object) {
        if (this.getScriptManager() == null) {
            return null;
        }
        return this.eval.getAtomBitSetVector(this.getAtomCount(), object);
    }

    public Map<String, SV> getContextVariables() {
        if (this.getScriptManager() == null) {
            return null;
        }
        return this.eval.getContextVariables();
    }

    public ScriptContext getScriptContext(String string) {
        return this.getScriptManager() == null ? null : this.eval.getScriptContext(string);
    }

    @Override
    public String getAtomDefs(Map<String, Object> map) {
        return this.getStateCreator().getAtomDefs(map);
    }

    public void createModels(int n) {
        this.modelSet.createModels(n);
    }

    public void setCGO(javajs.util.List<Object> list) {
        this.shapeManager.loadShape(23);
        this.shapeManager.setShapePropertyBs(23, "setCGO", list, null);
    }

    public void setFrame(int n) {
        this.animationManager.setFrame(n - 1);
    }

    public boolean movePyMOL(JmolScriptEvaluator jmolScriptEvaluator, float f, float[] fArray) {
        this.transformManager.moveToPyMOL(jmolScriptEvaluator, f, fArray);
        return true;
    }

    public P3 getCamera() {
        return this.transformManager.camera;
    }

    public void setModelSet(ModelSet modelSet) {
        this.modelSet = this.modelManager.modelSet = modelSet;
    }

    public String setObjectProp(String string, int n) {
        this.getScriptManager();
        if (string == null) {
            string = "*";
        }
        return this.eval == null ? null : this.eval.setObjectPropSafe(string, n, -1);
    }

    public String[] getSceneList() {
        try {
            return (String[])this.getModelSetAuxiliaryInfoValue("scenes");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setBondParameters(int n, int n2, BS bS, float f, float f2, int n3, float f3) {
        this.modelSet.setBondParametersBS(n, n2, bS, f, f2, n3, f3);
    }

    public int[][] getDihedralMap(int[] nArray) {
        return this.modelSet.getDihedralMap(nArray);
    }

    public void setDihedrals(float[] fArray, BS[] bSArray, float f) {
        if (bSArray == null) {
            bSArray = this.getBsBranches(fArray);
        }
        this.modelSet.setDihedrals(fArray, bSArray, f);
    }

    public BS[] getBsBranches(float[] fArray) {
        return this.modelSet.getBsBranches(fArray);
    }

    public int getChainID(String string) {
        Integer n = (Integer)this.chainMap.get(string);
        if (n != null) {
            return n;
        }
        int n2 = string.charAt(0);
        if (string.length() > 1) {
            n2 = 256 + this.chainList.size();
            this.chainList.addLast(string);
        }
        n = n2;
        this.chainMap.put(n, string);
        this.chainMap.put(string, n);
        return n2;
    }

    public String getChainIDStr(int n) {
        return (String)this.chainMap.get(n);
    }

    public Boolean getScriptQueueInfo() {
        return this.scriptManager != null && this.scriptManager.isQueueProcessing() ? Boolean.TRUE : Boolean.FALSE;
    }

    public JmolNMRInterface getNMRCalculation() {
        JmolNMRInterface jmolNMRInterface;
        if (this.nmrCalculation == null) {
            this.nmrCalculation = (JmolNMRInterface)Interface.getOptionInterface("quantum.NMRCalculation");
            jmolNMRInterface = this.nmrCalculation.setViewer(this);
        } else {
            jmolNMRInterface = this.nmrCalculation;
        }
        return jmolNMRInterface;
    }

    public String getDistanceUnits(String string) {
        int n;
        if (string == null) {
            string = this.getDefaultMeasurementLabel(2);
        }
        return (n = string.indexOf("//")) < 0 ? this.getMeasureDistanceUnits() : string.substring(n + 2);
    }

    public int calculateFormalCharges(BS bS) {
        if (bS == null) {
            bS = this.getSelectionSet(false);
        }
        return this.modelSet.fixFormalCharges(bS);
    }

    public boolean cachePngFiles() {
        return !this.getTestFlag(1);
    }

    public void setModulation(BS bS, boolean bl, P3 p3, boolean bl2) {
        if (bl2) {
            this.global.setS("_modt", Escape.eP(p3));
        }
        this.modelSet.setModulation(bS == null ? this.getAllAtoms() : bS, bl, p3, bl2);
        this.refreshMeasures(true);
    }

    public void checkInMotion(int n) {
        switch (n) {
            case 0: {
                this.setTimeout("_SET_IN_MOTION_", 0, null);
                break;
            }
            case 1: {
                if (this.inMotion) break;
                this.setTimeout("_SET_IN_MOTION_", this.global.hoverDelayMs * 2, "!setInMotion");
                break;
            }
            case 2: {
                this.setInMotion(true);
                this.refresh(3, "timeoutThread set in motion");
            }
        }
    }

    public boolean checkMotionRendering(int n) {
        if (!(this.getInMotion(true) || this.transformManager.spinOn || this.transformManager.vibrationOn || this.animationManager.animationOn)) {
            return true;
        }
        if (this.global.wireframeRotation) {
            return false;
        }
        int n2 = 0;
        switch (n) {
            case 0x44100001: 
            case 1678770178: {
                n2 = 2;
                break;
            }
            case 1113198596: {
                n2 = 3;
                break;
            }
            case 1113198597: {
                n2 = 4;
                break;
            }
            case 1113200642: {
                n2 = 5;
                break;
            }
            case 1073742018: {
                n2 = 6;
                break;
            }
            case 603979967: {
                n2 = 7;
                break;
            }
            case 603979786: {
                n2 = 8;
            }
        }
        return this.global.platformSpeed >= n2;
    }

    public OC openExportChannel(double d, String string, boolean bl) throws IOException {
        return this.getOutputManager().openOutputChannel(d, string, bl, false);
    }

    @Override
    public void log(String string) {
        if (string != null) {
            this.getOutputManager().logToFile(string);
        }
    }

    public String getLogFileName() {
        return this.logFileName == null ? "" : this.logFileName;
    }

    public String getCommands(Map<String, BS> map, Map<String, BS> map2, String string) {
        return this.getStateCreator().getCommands(map, map2, string);
    }

    public boolean allowCapture() {
        return !this.isApplet || this.isSignedApplet;
    }

    public MeasurementPending getMP() {
        return ((MeasurementPending)Interface.getOptionInterface("modelset.MeasurementPending")).set(this.modelSet);
    }

    @Override
    public Object getApplet() {
        return this.applet;
    }

    public javajs.util.List<Object> getModulationList(BS bS, String string, P3 p3) {
        return this.modelSet.getModulationList(bS, string, p3);
    }

    public Point3fi getVibrationPoint(Vibration vibration, Point3fi point3fi) {
        return this.transformManager.getVibrationPoint(vibration, point3fi);
    }

    static {
        staticFunctions = new Hashtable<String, JmolScriptFunction>();
        nProcessors = 1;
        nProcessors = Runtime.getRuntime().availableProcessors();
    }

    public static enum ACCESS {
        NONE,
        READSPT,
        ALL;

    }
}

