/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import java.util.Map;
import javajs.util.List;
import org.jmol.minimize.MinAngle;
import org.jmol.minimize.MinAtom;
import org.jmol.minimize.MinBond;
import org.jmol.minimize.MinObject;
import org.jmol.minimize.MinPosition;
import org.jmol.minimize.MinTorsion;
import org.jmol.minimize.forcefield.Calculation;
import org.jmol.minimize.forcefield.Calculations;
import org.jmol.minimize.forcefield.ForceField;
import org.jmol.minimize.forcefield.ForceFieldMMFF;
import org.jmol.util.Txt;

class CalculationsMMFF
extends Calculations {
    static final double FPAR = 143.9325;
    public static final int DA_D = 68;
    public static final int DA_DA = 133;
    private Map<Integer, Object> ffParams;
    DistanceCalc bondCalc;
    AngleCalc angleCalc;
    TorsionCalc torsionCalc;
    OOPCalc oopCalc;
    VDWCalc vdwCalc;
    ESCalc esCalc;
    SBCalc sbCalc;
    ForceFieldMMFF mmff;

    CalculationsMMFF(ForceField forceField, Map<Integer, Object> map, MinAtom[] minAtomArray, MinBond[] minBondArray, MinAngle[] minAngleArray, MinTorsion[] minTorsionArray, MinPosition[] minPositionArray, List<Object[]> list) {
        super(forceField, minAtomArray, minBondArray, minAngleArray, minTorsionArray, minPositionArray, list);
        this.mmff = (ForceFieldMMFF)forceField;
        this.ffParams = map;
        this.bondCalc = new DistanceCalc();
        this.angleCalc = new AngleCalc();
        this.sbCalc = new SBCalc();
        this.torsionCalc = new TorsionCalc();
        this.oopCalc = new OOPCalc();
        this.vdwCalc = new VDWCalc();
        this.esCalc = new ESCalc();
    }

    @Override
    String getUnits() {
        return "kcal";
    }

    @Override
    boolean setupCalculations() {
        DistanceCalc distanceCalc = new DistanceCalc();
        List list = this.calculations[0] = new List();
        for (int i = 0; i < this.bondCount; ++i) {
            distanceCalc.setData((List<Object[]>)list, this.minBonds[i]);
        }
        list = this.calculations[1] = new List();
        AngleCalc angleCalc = new AngleCalc();
        for (int i = 0; i < this.angleCount; ++i) {
            angleCalc.setData((List<Object[]>)list, this.minAngles[i]);
        }
        list = this.calculations[2] = new List();
        SBCalc sBCalc = new SBCalc();
        for (int i = 0; i < this.angleCount; ++i) {
            sBCalc.setData((List<Object[]>)list, this.minAngles[i]);
        }
        list = this.calculations[3] = new List();
        TorsionCalc torsionCalc = new TorsionCalc();
        for (int i = 0; i < this.torsionCount; ++i) {
            torsionCalc.setData((List<Object[]>)list, this.minTorsions[i]);
        }
        list = this.calculations[4] = new List();
        OOPCalc oOPCalc = new OOPCalc();
        for (int i = 0; i < this.atomCount; ++i) {
            if (!CalculationsMMFF.isInvertible(this.minAtoms[i])) continue;
            oOPCalc.setData((List<Object[]>)list, i);
        }
        this.calculations[5] = new List();
        this.calculations[6] = new List();
        this.pairSearch((List<Object[]>)this.calculations[5], new VDWCalc(), (List<Object[]>)this.calculations[6], new ESCalc());
        return true;
    }

    protected boolean isLinear(int n) {
        return MinAtom.isLinear(this.minAtoms[n]);
    }

    private static boolean isInvertible(MinAtom minAtom) {
        switch (minAtom.ffType) {
            default: {
                return false;
            }
            case 2: 
            case 3: 
            case 10: 
            case 30: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 45: 
            case 49: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 63: 
            case 64: 
            case 67: 
            case 69: 
            case 78: 
            case 80: 
            case 81: 
        }
        return true;
    }

    @Override
    double compute(int n, Object[] objectArray) {
        switch (n) {
            case 0: {
                return this.bondCalc.compute(objectArray);
            }
            case 1: {
                return this.angleCalc.compute(objectArray);
            }
            case 2: {
                return this.sbCalc.compute(objectArray);
            }
            case 3: {
                return this.torsionCalc.compute(objectArray);
            }
            case 4: {
                return this.oopCalc.compute(objectArray);
            }
            case 5: {
                return this.vdwCalc.compute(objectArray);
            }
            case 6: {
                return this.esCalc.compute(objectArray);
            }
        }
        return 0.0;
    }

    Object getParameterObj(MinObject minObject) {
        return minObject.key == null || minObject.ddata != null ? minObject.ddata : (double[])this.ffParams.get(minObject.key);
    }

    Object getParameter(Integer n) {
        return this.ffParams.get(n);
    }

    @Override
    String getDebugHeader(int n) {
        switch (n) {
            case -1: {
                return "MMFF94 Force Field -- T. A. Halgren, J. Comp. Chem. 5 & 6 490-519ff (1996).\n";
            }
            case 3: {
                return "\nT O R S I O N A L (" + this.minTorsions.length + " torsions)\n\n" + "      ATOMS           ATOM TYPES          TORSION\n" + "  I   J   K   L   I     J     K     L      ANGLE       V1       V2       V3     ENERGY\n" + "--------------------------------------------------------------------------------------\n";
            }
        }
        return this.getDebugHeader2(n);
    }

    @Override
    String getDebugLine(int n, Calculation calculation) {
        float f = this.ff.toUserUnits(calculation.energy);
        switch (n) {
            case 1: 
            case 2: {
                return Txt.sprintf((String)"%15s  %-5s %-5s %-5s  %8.3f  %8.3f     %8.3f   %8.3f", (String)"ssssFI", (Object[])new Object[]{MinObject.decodeKey(calculation.key), this.minAtoms[calculation.ia].sType, this.minAtoms[calculation.ib].sType, this.minAtoms[calculation.ic].sType, new float[]{(float)(calculation.theta * 57.29577951308232), (float)calculation.dData[1], (float)calculation.dData[0], f}, new int[]{this.minAtoms[calculation.ia].atom.getAtomNumber(), this.minAtoms[calculation.ib].atom.getAtomNumber(), this.minAtoms[calculation.ic].atom.getAtomNumber()}});
            }
            case 3: {
                return Txt.sprintf((String)"%15s  %-5s %-5s %-5s %-5s  %8.3f %8.3f %8.3f %8.3f %8.3f", (String)"sssssF", (Object[])new Object[]{MinObject.decodeKey(calculation.key), this.minAtoms[calculation.ia].sType, this.minAtoms[calculation.ib].sType, this.minAtoms[calculation.ic].sType, this.minAtoms[calculation.id].sType, new float[]{(float)(calculation.theta * 57.29577951308232), (float)calculation.dData[0], (float)calculation.dData[1], (float)calculation.dData[2], f}});
            }
        }
        return this.getDebugLineC(n, calculation);
    }

    class ESCalc
    extends Calculations.PairCalc {
        private static final double BUFF = 0.05;

        ESCalc() {
        }

        @Override
        void setData(List<Object[]> list, int n, int n2) {
            if (CalculationsMMFF.this.minAtoms[n].partialCharge == 0.0 || CalculationsMMFF.this.minAtoms[n2].partialCharge == 0.0) {
                return;
            }
            list.addLast((Object)new Object[]{new int[]{n, n2}, new double[]{CalculationsMMFF.this.minAtoms[n].partialCharge, CalculationsMMFF.this.minAtoms[n2].partialCharge, CalculationsMMFF.this.minAtoms[n].bs14.get(n2) ? 249.0537 : 332.0716}});
        }

        @Override
        double compute(Object[] objectArray) {
            this.getPointers(objectArray);
            double d = this.dData[0] * this.dData[1] * this.dData[2];
            CalculationsMMFF.this.setPairVariables(this);
            double d2 = this.rab + 0.05;
            this.energy = d / d2;
            if (CalculationsMMFF.this.gradients) {
                this.dE = -this.energy / d2;
                CalculationsMMFF.this.addForces(this, 2);
            }
            if (CalculationsMMFF.this.logging && Math.abs(this.energy) > 20.0) {
                CalculationsMMFF.this.appendLogData(CalculationsMMFF.this.getDebugLine(6, this));
            }
            return this.energy;
        }
    }

    class VDWCalc
    extends Calculations.PairCalc {
        VDWCalc() {
        }

        @Override
        void setData(List<Object[]> list, int n, int n2) {
            this.a = CalculationsMMFF.this.minAtoms[n];
            this.b = CalculationsMMFF.this.minAtoms[n2];
            double[] dArray = (double[])CalculationsMMFF.this.getParameter(this.a.vdwKey);
            double[] dArray2 = (double[])CalculationsMMFF.this.getParameter(this.b.vdwKey);
            if (dArray == null || dArray2 == null) {
                return;
            }
            double d = dArray[0];
            double d2 = dArray[1];
            double d3 = dArray[2];
            double d4 = dArray[3];
            int n3 = (int)dArray[4];
            double d5 = dArray2[0];
            double d6 = dArray2[1];
            double d7 = dArray2[2];
            double d8 = dArray2[3];
            int n4 = (int)dArray2[4];
            double d9 = d3 * Math.pow(d, 0.25);
            double d10 = d7 * Math.pow(d5, 0.25);
            double d11 = (d9 - d10) / (d9 + d10);
            double d12 = 0.5 * (d9 + d10);
            if (n3 != 68 && n4 != 68) {
                d12 *= 1.0 + 0.2 * (1.0 - Math.exp(-12.0 * d11 * d11));
            }
            double d13 = 181.16 * d4 * d8 * d * d5 / (Math.sqrt(d / d2) + Math.sqrt(d5 / d6)) * Math.pow(d12, -6.0);
            if (n3 + n4 == 133) {
                d12 *= 0.8;
                d13 *= 0.5;
            }
            list.addLast((Object)new Object[]{new int[]{n, n2}, new double[]{d12, d13}});
        }

        @Override
        double compute(Object[] objectArray) {
            this.getPointers(objectArray);
            CalculationsMMFF.this.setPairVariables(this);
            double d = this.dData[0];
            double d2 = this.dData[1];
            double d3 = this.rab / d;
            double d4 = 1.07 / (d3 + 0.07);
            double d5 = 1.12 / (Math.pow(d3, 7.0) + 0.12);
            this.energy = d2 * Math.pow(d4, 7.0) * (d5 - 2.0);
            if (CalculationsMMFF.this.gradients) {
                this.dE = -7.0 * d2 * Math.pow(d4, 7.0) / d * (d4 / 1.07 * (d5 - 2.0) + d5 * d5 * Math.pow(d3, 6.0));
                CalculationsMMFF.this.addForces(this, 2);
            }
            if (CalculationsMMFF.this.logging && Math.abs(this.energy) > 0.1) {
                CalculationsMMFF.this.appendLogData(CalculationsMMFF.this.getDebugLine(5, this));
            }
            return this.energy;
        }
    }

    class OOPCalc
    extends Calculation {
        static final double FOOPD = 2.5120761569715815;
        static final double FOOP = 71.96568080495746;
        int[] list = new int[4];

        OOPCalc() {
        }

        void setData(List<Object[]> list, int n) {
            if (CalculationsMMFF.this.minAtoms[n].nBonds != 3) {
                return;
            }
            int[] nArray = CalculationsMMFF.this.minAtoms[n].getBondedAtomIndexes();
            this.list[0] = nArray[2];
            this.list[1] = n;
            this.list[2] = nArray[1];
            this.list[3] = nArray[0];
            double d = CalculationsMMFF.this.mmff.getOutOfPlaneParameter(this.list);
            if (d == 0.0) {
                return;
            }
            double[] dArray = new double[]{d};
            list.addLast((Object)new Object[]{new int[]{nArray[0], n, nArray[1], nArray[2]}, dArray});
            list.addLast((Object)new Object[]{new int[]{nArray[1], n, nArray[2], nArray[0]}, dArray});
            list.addLast((Object)new Object[]{new int[]{nArray[2], n, nArray[0], nArray[1]}, dArray});
        }

        @Override
        double compute(Object[] objectArray) {
            this.getPointers(objectArray);
            CalculationsMMFF.this.setOopVariables(this, false);
            double d = this.dData[0];
            this.energy = 71.96568080495746 * d * this.theta * this.theta;
            if (CalculationsMMFF.this.gradients) {
                this.dE = 2.5120761569715815 * d * this.theta;
                CalculationsMMFF.this.addForces(this, 4);
            }
            if (CalculationsMMFF.this.logging) {
                CalculationsMMFF.this.appendLogData(CalculationsMMFF.this.getDebugLine(4, this));
            }
            return this.energy;
        }
    }

    class TorsionCalc
    extends Calculation {
        TorsionCalc() {
        }

        void setData(List<Object[]> list, MinTorsion minTorsion) {
            if (CalculationsMMFF.this.isLinear(minTorsion.data[1]) || CalculationsMMFF.this.isLinear(minTorsion.data[2])) {
                return;
            }
            Object object = CalculationsMMFF.this.getParameterObj(minTorsion);
            if (object == null) {
                return;
            }
            list.addLast((Object)new Object[]{minTorsion.data, object, minTorsion.key});
        }

        @Override
        double compute(Object[] objectArray) {
            this.key = (Integer)objectArray[2];
            this.getPointers(objectArray);
            double d = this.dData[0];
            double d2 = this.dData[1];
            double d3 = this.dData[2];
            CalculationsMMFF.this.setTorsionVariables(this);
            double d4 = Math.cos(this.theta);
            double d5 = d4 * d4;
            this.energy = 0.5 * (d * (1.0 + d4) + d2 * (2.0 - 2.0 * d5) + d3 * (1.0 + d4 * (4.0 * d5 - 3.0)));
            if (CalculationsMMFF.this.gradients) {
                double d6 = Math.sin(this.theta);
                this.dE = 0.5 * (-d * d6 + 4.0 * d2 * d6 * d4 + 3.0 * d3 * d6 * (1.0 - 4.0 * d5));
                CalculationsMMFF.this.addForces(this, 4);
            }
            if (CalculationsMMFF.this.logging) {
                CalculationsMMFF.this.appendLogData(CalculationsMMFF.this.getDebugLine(3, this));
            }
            return this.energy;
        }
    }

    class SBCalc
    extends Calculation {
        SBCalc() {
        }

        void setData(List<Object[]> list, MinAngle minAngle) {
            if (CalculationsMMFF.this.isLinear(minAngle.data[1])) {
                return;
            }
            double[] dArray = (double[])CalculationsMMFF.this.getParameter(minAngle.sbKey);
            double[] dArray2 = (double[])CalculationsMMFF.this.getParameterObj(minAngle);
            double[] dArray3 = (double[])CalculationsMMFF.this.getParameterObj(CalculationsMMFF.this.minBonds[minAngle.data[3]]);
            double[] dArray4 = (double[])CalculationsMMFF.this.getParameterObj(CalculationsMMFF.this.minBonds[minAngle.data[4]]);
            if (dArray == null || dArray2 == null || dArray3 == null || dArray4 == null) {
                return;
            }
            double d = dArray2[1];
            double d2 = dArray3[1];
            double d3 = dArray4[1];
            list.addLast((Object)new Object[]{minAngle.data, new double[]{dArray[0], d, d2}});
            list.addLast((Object)new Object[]{new int[]{minAngle.data[2], minAngle.data[1], minAngle.data[0]}, new double[]{dArray[1], d, d3}});
        }

        @Override
        double compute(Object[] objectArray) {
            this.getPointers(objectArray);
            double d = 2.5121 * this.dData[0];
            double d2 = this.dData[1];
            double d3 = this.dData[2];
            CalculationsMMFF.this.setPairVariables(this);
            CalculationsMMFF.this.setAngleVariables(this);
            double d4 = this.rab - d3;
            this.delta = this.theta * 57.29577951308232 - d2;
            this.energy = d * d4 * this.delta;
            if (CalculationsMMFF.this.logging) {
                CalculationsMMFF.this.appendLogData(CalculationsMMFF.this.getDebugLine(2, this));
            }
            if (CalculationsMMFF.this.gradients) {
                this.dE = d * d4;
                CalculationsMMFF.this.addForces(this, 3);
                CalculationsMMFF.this.setPairVariables(this);
                this.dE = d * this.delta;
                CalculationsMMFF.this.addForces(this, 2);
            }
            return this.energy;
        }
    }

    class AngleCalc
    extends Calculation {
        static final double CB = -0.006981317007977318;

        AngleCalc() {
        }

        void setData(List<Object[]> list, MinAngle minAngle) {
            Object object = CalculationsMMFF.this.getParameterObj(minAngle);
            if (object == null) {
                return;
            }
            list.addLast((Object)new Object[]{minAngle.data, object, minAngle.key});
        }

        @Override
        double compute(Object[] objectArray) {
            this.key = (Integer)objectArray[2];
            this.getPointers(objectArray);
            double d = this.dData[0];
            double d2 = this.dData[1];
            CalculationsMMFF.this.setAngleVariables(this);
            double d3 = this.theta * 57.29577951308232 - d2;
            if (d2 == 180.0) {
                this.energy = 143.9325 * d * (1.0 + Math.cos(this.theta));
                if (CalculationsMMFF.this.gradients) {
                    this.dE = -143.9325 * d * Math.sin(this.theta);
                }
            } else {
                this.energy = 0.021922 * d * Math.pow(d3, 2.0) * (1.0 + -0.006981317007977318 * d3);
                if (CalculationsMMFF.this.gradients) {
                    this.dE = 0.021922 * d * d3 * (2.0 + -0.020943951023931956 * d3);
                }
            }
            if (CalculationsMMFF.this.gradients) {
                CalculationsMMFF.this.addForces(this, 3);
            }
            if (CalculationsMMFF.this.logging) {
                CalculationsMMFF.this.appendLogData(CalculationsMMFF.this.getDebugLine(1, this));
            }
            return this.energy;
        }
    }

    class DistanceCalc
    extends Calculation {
        static final double FSTRETCH = 71.96625;
        static final double CS = -2.0;
        static final double CS2 = 2.3333333333333335;
        double r0;
        double kb;
        double delta2;

        DistanceCalc() {
        }

        void setData(List<Object[]> list, MinBond minBond) {
            this.ia = minBond.data[0];
            this.ib = minBond.data[1];
            Object object = CalculationsMMFF.this.getParameterObj(minBond);
            if (object == null) {
                return;
            }
            list.addLast((Object)new Object[]{new int[]{this.ia, this.ib}, object});
        }

        @Override
        double compute(Object[] objectArray) {
            this.getPointers(objectArray);
            this.kb = this.dData[0];
            this.r0 = this.dData[1];
            CalculationsMMFF.this.setPairVariables(this);
            this.delta = this.rab - this.r0;
            this.delta2 = this.delta * this.delta;
            this.energy = 71.96625 * this.kb * this.delta2 * (1.0 + -2.0 * this.delta + 2.3333333333333335 * this.delta2);
            if (CalculationsMMFF.this.gradients) {
                this.dE = 71.96625 * this.kb * this.delta * (2.0 + -6.0 * this.delta + 9.333333333333334 * this.delta2);
                CalculationsMMFF.this.addForces(this, 2);
            }
            if (CalculationsMMFF.this.logging) {
                CalculationsMMFF.this.appendLogData(CalculationsMMFF.this.getDebugLine(0, this));
            }
            return this.energy;
        }
    }
}

