/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.navigate;

import javajs.util.List;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.JmolNavigatorInterface;
import org.jmol.api.JmolScriptEvaluator;
import org.jmol.thread.JmolThread;
import org.jmol.util.Escape;
import org.jmol.util.Hermite;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.Viewer;

public final class Navigator
extends JmolThread
implements JmolNavigatorInterface {
    private TransformManager tm;
    private int nHits;
    private int multiplier = 1;
    private boolean isPathGuide;
    private P3[] points;
    private P3[] pointGuides;
    private int frameTimeMillis;
    private float floatSecondsTotal;
    private V3 axis;
    private float degrees;
    private P3 center;
    private float depthPercent;
    private float xTrans;
    private float yTrans;
    private float depthStart;
    private float depthDelta;
    private float xTransStart;
    private float xTransDelta;
    private float yTransStart;
    private float yTransDelta;
    private float degreeStep;
    private P3 centerStart;
    private int totalSteps;
    private V3 aaStepCenter;
    private boolean isNavTo;
    private int iStep;
    private List<Object[]> navigationList;
    private int iList;
    private boolean isStep;

    public void set(TransformManager transformManager, Viewer viewer) {
        this.tm = transformManager;
        this.setViewer(viewer, "navigator");
    }

    public void navigateList(JmolScriptEvaluator jmolScriptEvaluator, List<Object[]> list) {
        this.setEval(jmolScriptEvaluator);
        this.navigationList = list;
        this.iList = 0;
        this.isStep = false;
        this.run();
    }

    private void nextList(int n, P3 p3) {
        Object[] objectArray = (Object[])this.navigationList.get(n);
        float f = ((Float)objectArray[1]).floatValue();
        int n2 = (Integer)objectArray[0];
        switch (n2) {
            case 0x8100010: {
                P3 p32 = (P3)objectArray[2];
                if (f == 0.0f) {
                    this.tm.setNavigatePt(p32);
                    this.viewer.moveUpdate(0.0f);
                    return;
                }
                this.navigateTo(f, null, Float.NaN, p32, Float.NaN, Float.NaN, Float.NaN);
                break;
            }
            case 0x40000104: {
                P3[] p3Array = (P3[])objectArray[2];
                float[] fArray = (float[])objectArray[3];
                int n3 = ((int[])objectArray[4])[0];
                int n4 = ((int[])objectArray[4])[1];
                this.navigate(f, null, p3Array, fArray, n3, n4);
                break;
            }
            case 1113200654: {
                P3[][] p3Array = (P3[][])objectArray[2];
                this.navigate(f, p3Array, null, null, 0, Integer.MAX_VALUE);
                break;
            }
            case 528432: {
                V3 v3 = (V3)objectArray[2];
                float f2 = ((Float)objectArray[3]).floatValue();
                if (f == 0.0f) {
                    this.navigateAxis(v3, f2);
                    this.viewer.moveUpdate(0.0f);
                    return;
                }
                this.navigateTo(f, v3, f2, null, Float.NaN, Float.NaN, Float.NaN);
                break;
            }
            case 4160: 
            case 269484210: {
                if (n2 == 4160) {
                    this.tm.transformPoint2((P3)objectArray[2], p3);
                } else {
                    p3.x = ((Float)objectArray[2]).floatValue();
                    p3.y = ((Float)objectArray[3]).floatValue();
                    this.setNavPercent(p3);
                }
                if (f == 0.0f) {
                    this.navTranslatePercentOrTo(-1.0f, p3.x, p3.y);
                    this.viewer.moveUpdate(0.0f);
                    return;
                }
                this.navigateTo(f, null, Float.NaN, null, Float.NaN, p3.x, p3.y);
                break;
            }
            case 554176526: {
                float f3 = ((Float)objectArray[2]).floatValue();
                this.navigateTo(f, null, Float.NaN, null, f3, Float.NaN, Float.NaN);
            }
        }
    }

    private void setNavPercent(P3 p3) {
        this.tm.transformPoint2(this.tm.navigationCenter, this.tm.navigationOffset);
        float f = p3.x;
        float f2 = p3.y;
        if (!Float.isNaN(f)) {
            f = (float)this.tm.width * f / 100.0f + (Float.isNaN(f2) ? this.tm.navigationOffset.x : (float)this.tm.width / 2.0f);
        }
        if (!Float.isNaN(f2)) {
            f2 = (float)this.tm.height * f2 / 100.0f + (Float.isNaN(f) ? this.tm.navigationOffset.y : this.tm.getNavPtHeight());
        }
        p3.x = f;
        p3.y = f2;
    }

    public void navigateTo(float f, V3 v3, float f2, P3 p3, float f3, float f4, float f5) {
        this.floatSecondsTotal = f;
        this.axis = v3;
        this.degrees = f2;
        this.center = p3;
        this.depthPercent = f3;
        this.xTrans = f4;
        this.yTrans = f5;
        this.setupNavTo();
        this.isStep = true;
        this.run();
    }

    public void navigate(float f, P3[][] p3Array, P3[] p3Array2, float[] fArray, int n, int n2) {
        this.floatSecondsTotal = f;
        this.setupNav(f, p3Array, p3Array2, n, n2);
        this.isStep = true;
        this.run();
    }

    protected void run1(int n) throws InterruptedException {
        P3 p3 = new P3();
        while (this.isJS || this.viewer.isScriptExecuting()) {
            switch (n) {
                case -1: {
                    if (this.isStep) {
                        this.targetTime = this.startTime;
                        this.iStep = 0;
                        n = this.totalSteps <= 0 && this.isNavTo ? 1 : 0;
                        break;
                    }
                    n = 2;
                    break;
                }
                case 2: {
                    this.nextList(this.iList, p3);
                    return;
                }
                case 0: {
                    if (this.stopped || this.iStep >= this.totalSteps) {
                        n = -2;
                        break;
                    }
                    this.doNavStep(this.iStep++);
                    this.viewer.requestRepaintAndWait("navigatorThread");
                    int n2 = (int)(this.targetTime - System.currentTimeMillis());
                    if (!this.runSleep(n2, 0)) {
                        return;
                    }
                    n = 0;
                    break;
                }
                case 1: {
                    if (!this.runSleep((int)(this.floatSecondsTotal * 1000.0f) - 30, -2)) {
                        return;
                    }
                    n = -2;
                    break;
                }
                case -2: {
                    if (this.isNavTo) {
                        if (!Float.isNaN(this.xTrans) || !Float.isNaN(this.yTrans)) {
                            this.navTranslatePercentOrTo(-1.0f, this.xTrans, this.yTrans);
                        }
                        if (!Float.isNaN(this.depthPercent)) {
                            this.setNavigationDepthPercent(this.depthPercent);
                        }
                    }
                    this.viewer.setInMotion(false);
                    this.viewer.moveUpdate(this.floatSecondsTotal);
                    if (!this.stopped && ++this.iList < this.navigationList.size()) {
                        n = 2;
                        break;
                    }
                    this.resumeEval();
                    return;
                }
            }
        }
    }

    private void doNavStep(int n) {
        if (!this.isNavTo) {
            this.tm.setNavigatePt(this.points[n]);
            if (this.isPathGuide) {
                this.alignZX(this.points[n], this.points[n + 1], this.pointGuides[n]);
            }
            this.targetTime += (long)this.frameTimeMillis;
            return;
        }
        this.tm.navigating = true;
        float f = ((float)n + 1.0f) / (float)this.totalSteps;
        if (!Float.isNaN(this.degrees)) {
            this.tm.navigateAxis(this.axis, this.degreeStep);
        }
        if (this.center != null) {
            this.centerStart.add((T3)this.aaStepCenter);
            this.tm.setNavigatePt(this.centerStart);
        }
        if (!Float.isNaN(this.xTrans) || !Float.isNaN(this.yTrans)) {
            float f2 = Float.NaN;
            float f3 = Float.NaN;
            if (!Float.isNaN(this.xTrans)) {
                f2 = this.xTransStart + this.xTransDelta * f;
            }
            if (!Float.isNaN(this.yTrans)) {
                f3 = this.yTransStart + this.yTransDelta * f;
            }
            this.navTranslatePercentOrTo(-1.0f, f2, f3);
        }
        if (!Float.isNaN(this.depthPercent)) {
            this.setNavigationDepthPercent(this.depthStart + this.depthDelta * f);
        }
        this.tm.navigating = false;
        this.targetTime += (long)this.frameTimeMillis;
    }

    private void setupNavTo() {
        this.isNavTo = true;
        if (!this.viewer.haveDisplay) {
            this.floatSecondsTotal = 0.0f;
        }
        int n = 30;
        this.totalSteps = (int)(this.floatSecondsTotal * (float)n) - 1;
        if (this.floatSecondsTotal > 0.0f) {
            this.viewer.setInMotion(true);
        }
        if (this.degrees == 0.0f) {
            this.degrees = Float.NaN;
        }
        if (this.totalSteps > 0) {
            this.frameTimeMillis = 1000 / n;
            this.depthStart = this.tm.getNavigationDepthPercent();
            this.depthDelta = this.depthPercent - this.depthStart;
            this.xTransStart = this.tm.navigationOffset.x;
            this.xTransDelta = this.xTrans - this.xTransStart;
            this.yTransStart = this.tm.navigationOffset.y;
            this.yTransDelta = this.yTrans - this.yTransStart;
            this.degreeStep = this.degrees / (float)(this.totalSteps + 1);
            this.aaStepCenter = V3.newVsub((T3)(this.center == null ? this.tm.navigationCenter : this.center), (T3)this.tm.navigationCenter);
            this.aaStepCenter.scale(1.0f / (float)(this.totalSteps + 1));
            this.centerStart = P3.newP((T3)this.tm.navigationCenter);
        }
    }

    private void setupNav(float f, P3[][] p3Array, P3[] p3Array2, int n, int n2) {
        int n3;
        this.isNavTo = false;
        if (f <= 0.0f) {
            f = 2.0f;
        }
        if (!this.viewer.haveDisplay) {
            f = 0.0f;
        }
        this.isPathGuide = p3Array != null;
        if (!this.isPathGuide) {
            for (n3 = Math.min((this.isPathGuide ? p3Array.length : p3Array2.length) - 1, n2); n3 > 0 && p3Array2[n3] == null; --n3) {
            }
        }
        if ((n3 -= n) < 1) {
            return;
        }
        int n4 = (int)Math.floor(10.0f * f);
        int n5 = n3 * n4 + 1;
        this.points = new P3[n5 + 2];
        this.pointGuides = new P3[this.isPathGuide ? n5 + 2 : 0];
        for (int i = 0; i < n3; ++i) {
            int n6 = Math.max(i - 1, 0) + n;
            int n7 = i + n;
            int n8 = Math.min(i + 1, n3) + n;
            int n9 = Math.min(i + 2, n3) + n;
            int n10 = Math.min(i + 3, n3) + n;
            if (this.isPathGuide) {
                Hermite.getHermiteList((int)7, (T3)p3Array[n6][0], (T3)p3Array[n7][0], (T3)p3Array[n8][0], (T3)p3Array[n9][0], (T3)p3Array[n10][0], (T3[])this.points, (int)(i * n4), (int)(n4 + 1), (boolean)true);
                Hermite.getHermiteList((int)7, (T3)p3Array[n6][1], (T3)p3Array[n7][1], (T3)p3Array[n8][1], (T3)p3Array[n9][1], (T3)p3Array[n10][1], (T3[])this.pointGuides, (int)(i * n4), (int)(n4 + 1), (boolean)true);
                continue;
            }
            Hermite.getHermiteList((int)7, (T3)p3Array2[n6], (T3)p3Array2[n7], (T3)p3Array2[n8], (T3)p3Array2[n9], (T3)p3Array2[n10], (T3[])this.points, (int)(i * n4), (int)(n4 + 1), (boolean)true);
        }
        this.viewer.setInMotion(true);
        this.frameTimeMillis = (int)(1000.0f / this.tm.navFps);
        this.totalSteps = n5;
    }

    private void alignZX(P3 p3, P3 p32, P3 p33) {
        P3 p34 = new P3();
        P3 p35 = new P3();
        M3 m3 = this.tm.getMatrixRotate();
        m3.transform2((T3)p3, (T3)p34);
        m3.transform2((T3)p32, (T3)p35);
        V3 v3 = V3.newVsub((T3)p34, (T3)p35);
        V3 v32 = V3.new3((float)0.0f, (float)0.0f, (float)1.0f);
        float f = v3.angle(v32);
        v32.cross(v3, v32);
        if (f != 0.0f) {
            this.tm.navigateAxis(v32, (float)((double)f * 57.29577951308232));
        }
        m3.transform2((T3)p3, (T3)p34);
        P3 p36 = P3.newP((T3)p33);
        p36.add((T3)p3);
        P3 p37 = new P3();
        m3.transform2((T3)p36, (T3)p37);
        v3.sub2((T3)p37, (T3)p34);
        v3.z = 0.0f;
        v32.set(-1.0f, 0.0f, 0.0f);
        f = v3.angle(v32);
        if (v3.y < 0.0f) {
            f = -f;
        }
        v32.set(0.0f, 0.0f, 1.0f);
        if (f != 0.0f) {
            this.tm.navigateAxis(v32, (float)((double)f * 57.29577951308232));
        }
        m3.transform2((T3)p3, (T3)p34);
        m3.transform2((T3)p32, (T3)p35);
        m3.transform2((T3)p33, (T3)p37);
    }

    public void zoomByFactor(float f, int n, int n2) {
        float f2 = this.tm.navZ;
        if (f2 > 0.0f) {
            if ((f2 /= f) < 5.0f) {
                f2 = -5.0f;
            } else if (f2 > 200.0f) {
                f2 = 200.0f;
            }
        } else if (f2 == 0.0f) {
            f2 = f < 1.0f ? 5 : -5;
        } else if ((f2 *= f) > -5.0f) {
            f2 = 5.0f;
        } else if (f2 < -200.0f) {
            f2 = -200.0f;
        }
        this.tm.navZ = f2;
    }

    public void calcNavigationPoint() {
        float f;
        P3 p3;
        this.calcNavigationDepthPercent();
        if (!this.tm.navigating && this.tm.navMode != 1) {
            this.tm.navMode = this.tm.navigationDepth < 100.0f && this.tm.navigationDepth > 0.0f && !Float.isNaN(this.tm.previousX) && this.tm.previousX == this.tm.fixedTranslation.x && this.tm.previousY == this.tm.fixedTranslation.y && this.tm.navMode != -1 ? 3 : 0;
        }
        switch (this.tm.navMode) {
            case 1: {
                this.tm.navigationOffset.set((float)this.tm.width / 2.0f, this.tm.getNavPtHeight(), this.tm.referencePlaneOffset);
                this.tm.zoomFactor = Float.MAX_VALUE;
                this.tm.calcCameraFactors();
                this.tm.calcTransformMatrix();
                this.newNavigationCenter();
                break;
            }
            case -1: 
            case 0: {
                this.tm.fixedRotationOffset.setT((T3)this.tm.fixedTranslation);
                this.newNavigationCenter();
                break;
            }
            case 2: {
                this.newNavigationCenter();
                break;
            }
            case -2: 
            case 3: {
                p3 = new P3();
                this.tm.matrixTransform.transform2((T3)this.tm.navigationCenter, (T3)p3);
                f = p3.z;
                this.tm.matrixTransform.transform2((T3)this.tm.fixedRotationCenter, (T3)p3);
                this.tm.modelCenterOffset = this.tm.referencePlaneOffset + (p3.z - f);
                this.tm.calcCameraFactors();
                this.tm.calcTransformMatrix();
                break;
            }
            case 4: {
                this.tm.navigationOffset.z = this.tm.referencePlaneOffset;
                this.tm.unTransformPoint(this.tm.navigationOffset, this.tm.navigationCenter);
            }
        }
        this.tm.matrixTransform.transform2((T3)this.tm.navigationCenter, (T3)this.tm.navigationShiftXY);
        if (this.viewer.getBoolean(603979888)) {
            p3 = P3.newP((T3)this.tm.navigationCenter);
            this.viewer.toUnitCell(this.tm.navigationCenter, null);
            if ((double)p3.distance((T3)this.tm.navigationCenter) > 0.01) {
                this.tm.matrixTransform.transform2((T3)this.tm.navigationCenter, (T3)p3);
                f = this.tm.navigationShiftXY.z - p3.z;
                this.tm.modelCenterOffset += f;
                this.tm.calcCameraFactors();
                this.tm.calcTransformMatrix();
                this.tm.matrixTransform.transform2((T3)this.tm.navigationCenter, (T3)this.tm.navigationShiftXY);
            }
        }
        this.tm.transformPoint2(this.tm.fixedRotationCenter, this.tm.fixedTranslation);
        this.tm.fixedRotationOffset.setT((T3)this.tm.fixedTranslation);
        this.tm.previousX = this.tm.fixedTranslation.x;
        this.tm.previousY = this.tm.fixedTranslation.y;
        this.tm.transformPoint2(this.tm.navigationCenter, this.tm.navigationOffset);
        this.tm.navigationOffset.z = this.tm.referencePlaneOffset;
        this.tm.navMode = 0;
        this.calcNavSlabAndDepthValues();
    }

    private void calcNavSlabAndDepthValues() {
        this.tm.calcSlabAndDepthValues();
        if (this.tm.slabEnabled) {
            this.tm.slabValue = (this.tm.mode == 1 ? -100 : 0) + (int)(this.tm.referencePlaneOffset - this.tm.navigationSlabOffset);
            if (this.tm.zSlabPercentSetting == this.tm.zDepthPercentSetting) {
                this.tm.zSlabValue = this.tm.slabValue;
            }
        }
    }

    private void newNavigationCenter() {
        this.tm.mode = this.tm.defaultMode;
        P3 p3 = new P3();
        this.tm.transformPoint2(this.tm.fixedRotationCenter, p3);
        p3.x -= this.tm.navigationOffset.x;
        p3.y -= this.tm.navigationOffset.y;
        float f = -this.tm.getPerspectiveFactor(p3.z);
        p3.x /= f;
        p3.y /= f;
        p3.z = this.tm.referencePlaneOffset;
        this.tm.matrixTransformInv.transform2((T3)p3, (T3)this.tm.navigationCenter);
        this.tm.mode = 1;
    }

    public void setNavigationOffsetRelative() {
        if (this.tm.navigationDepth < 0.0f && this.tm.navZ > 0.0f || this.tm.navigationDepth > 100.0f && this.tm.navZ < 0.0f) {
            this.tm.navZ = 0.0f;
        }
        this.tm.rotateXRadians(-3.4906584E-4f * this.tm.navY, null);
        this.tm.rotateYRadians(3.4906584E-4f * this.tm.navX, null);
        P3 p3 = this.tm.getNavigationCenter();
        P3 p32 = new P3();
        this.tm.transformPoint2(p3, p32);
        p32.z += this.tm.navZ;
        this.tm.unTransformPoint(p32, p3);
        this.tm.setNavigatePt(p3);
    }

    public void navigateKey(int n, int n2) {
        String string = null;
        float f = 0.0f;
        if (this.tm.mode != 1) {
            return;
        }
        if (n == 0) {
            this.nHits = 0;
            this.multiplier = 1;
            if (!this.tm.navigating) {
                return;
            }
            this.tm.navigating = false;
            return;
        }
        ++this.nHits;
        if (this.nHits % 10 == 0) {
            this.multiplier *= this.multiplier == 4 ? 1 : 2;
        }
        boolean bl = (n2 & 1) > 0;
        boolean bl2 = (n2 & 8) > 0;
        boolean bl3 = (n2 & 2) > 0;
        float f2 = this.viewer.getFloat(570425374) * (float)(bl3 ? 10 : 1);
        switch (n) {
            case 46: {
                this.tm.navZ = 0.0f;
                this.tm.navY = 0.0f;
                this.tm.navX = 0.0f;
                this.tm.homePosition(true);
                return;
            }
            case 32: {
                if (!this.tm.navOn) {
                    return;
                }
                this.tm.navZ = 0.0f;
                this.tm.navY = 0.0f;
                this.tm.navX = 0.0f;
                return;
            }
            case 38: {
                if (this.tm.navOn) {
                    if (bl2) {
                        this.tm.navY += (float)this.multiplier;
                        f = this.tm.navY;
                        string = "navY";
                        break;
                    }
                    this.tm.navZ += (float)this.multiplier;
                    f = this.tm.navZ;
                    string = "navZ";
                    break;
                }
                if (bl) {
                    this.tm.navigationOffset.y -= (float)(2 * this.multiplier);
                    this.tm.navMode = 2;
                    break;
                }
                if (bl2) {
                    this.tm.rotateXRadians(-0.0034906585f * (float)this.multiplier, null);
                    this.tm.navMode = 3;
                    break;
                }
                this.tm.modelCenterOffset = this.tm.modelCenterOffset - f2 * (float)(this.viewer.getBoolean(603979888) ? 1 : this.multiplier);
                this.tm.navMode = 4;
                break;
            }
            case 40: {
                if (this.tm.navOn) {
                    if (bl2) {
                        this.tm.navY -= (float)this.multiplier;
                        f = this.tm.navY;
                        string = "navY";
                        break;
                    }
                    this.tm.navZ -= (float)this.multiplier;
                    f = this.tm.navZ;
                    string = "navZ";
                    break;
                }
                if (bl) {
                    this.tm.navigationOffset.y += (float)(2 * this.multiplier);
                    this.tm.navMode = 2;
                    break;
                }
                if (bl2) {
                    this.tm.rotateXRadians(0.0034906585f * (float)this.multiplier, null);
                    this.tm.navMode = 3;
                    break;
                }
                this.tm.modelCenterOffset = this.tm.modelCenterOffset + f2 * (float)(this.viewer.getBoolean(603979888) ? 1 : this.multiplier);
                this.tm.navMode = 4;
                break;
            }
            case 37: {
                if (this.tm.navOn) {
                    this.tm.navX -= (float)this.multiplier;
                    f = this.tm.navX;
                    string = "navX";
                    break;
                }
                if (bl) {
                    this.tm.navigationOffset.x -= (float)(2 * this.multiplier);
                    this.tm.navMode = 2;
                    break;
                }
                this.tm.rotateYRadians(-0.010471976f * (float)this.multiplier, null);
                this.tm.navMode = 3;
                break;
            }
            case 39: {
                if (this.tm.navOn) {
                    this.tm.navX += (float)this.multiplier;
                    f = this.tm.navX;
                    string = "navX";
                    break;
                }
                if (bl) {
                    this.tm.navigationOffset.x += (float)(2 * this.multiplier);
                    this.tm.navMode = 2;
                    break;
                }
                this.tm.rotateYRadians(0.010471976f * (float)this.multiplier, null);
                this.tm.navMode = 3;
                break;
            }
            default: {
                this.tm.navigating = false;
                this.tm.navMode = 0;
                return;
            }
        }
        if (string != null) {
            this.viewer.global.setF(string, f);
        }
        this.tm.navigating = true;
        this.tm.finalizeTransformParameters();
    }

    public void setNavigationDepthPercent(float f) {
        this.viewer.global.setF("navigationDepth", f);
        this.tm.calcCameraFactors();
        this.tm.modelCenterOffset = this.tm.referencePlaneOffset - (1.0f - f / 50.0f) * this.tm.modelRadiusPixels;
        this.tm.calcCameraFactors();
        this.tm.navMode = -1;
    }

    private void calcNavigationDepthPercent() {
        this.tm.calcCameraFactors();
        this.tm.navigationDepth = this.tm.modelRadiusPixels == 0.0f ? 50.0f : 50.0f * (1.0f + (this.tm.modelCenterOffset - this.tm.referencePlaneOffset) / this.tm.modelRadiusPixels);
    }

    public String getNavigationState() {
        return "# navigation state;\nnavigate 0 center " + Escape.eP((T3)this.tm.getNavigationCenter()) + ";\nnavigate 0 translate " + this.tm.getNavigationOffsetPercent('X') + " " + this.tm.getNavigationOffsetPercent('Y') + ";\nset navigationDepth " + this.tm.getNavigationDepthPercent() + ";\nset navigationSlab " + this.getNavigationSlabOffsetPercent() + ";\n\n";
    }

    private float getNavigationSlabOffsetPercent() {
        this.tm.calcCameraFactors();
        return 50.0f * this.tm.navigationSlabOffset / this.tm.modelRadiusPixels;
    }

    public void navigateAxis(V3 v3, float f) {
        if (f == 0.0f) {
            return;
        }
        this.tm.rotateAxisAngle(v3, (float)((double)f / 57.29577951308232));
        this.tm.navMode = 3;
        this.tm.navigating = true;
        this.tm.finalizeTransformParameters();
        this.tm.navigating = false;
    }

    public void navTranslatePercentOrTo(float f, float f2, float f3) {
        P3 p3 = P3.new3((float)f2, (float)f3, (float)0.0f);
        if (f >= 0.0f) {
            this.setNavPercent(p3);
        }
        if (!Float.isNaN(p3.x)) {
            this.tm.navigationOffset.x = p3.x;
        }
        if (!Float.isNaN(p3.y)) {
            this.tm.navigationOffset.y = p3.y;
        }
        this.tm.navMode = 2;
        this.tm.navigating = true;
        this.tm.finalizeTransformParameters();
        this.tm.navigating = false;
    }

    protected void oops(Exception exception) {
        super.oops(exception);
        this.tm.navigating = false;
    }
}

