/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import javajs.util.DF;
import javajs.util.List;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class VaspOutcarReader
extends AtomSetCollectionReader {
    private String[] atomNames;
    private List<String> elementNames;
    private int atomCount = 0;
    private boolean inputOnly;
    private boolean mDsimulation = false;
    private boolean isVersion5 = false;
    private float[] unitCellData = new float[18];
    private Double gibbsEnergy;
    private Double gibbsEntropy;
    private Double electronEne;
    private Double kinEne;
    private Double totEne;
    private float temp;

    protected void initializeReader() {
        this.setSpaceGroupName("P1");
        this.setFractionalCoordinates(true);
        this.inputOnly = this.checkFilterKey("INPUT");
    }

    protected boolean checkLine() throws Exception {
        if (this.line.contains(" vasp.5")) {
            this.isVersion5 = true;
        } else if (this.line.toUpperCase().contains("INCAR:")) {
            this.readElementNames();
        } else if (this.line.contains("ions per type")) {
            this.readAtomCountAndSetNames();
        } else if (this.line.contains("molecular dynamics for ions")) {
            this.mDsimulation = true;
        } else if (this.line.contains("direct lattice vectors")) {
            this.readUnitCellVectors();
        } else if (this.line.contains("position of ions in fractional coordinates")) {
            this.readInitialCoordinates();
            if (this.inputOnly) {
                this.continuing = false;
            }
        } else {
            if (this.line.contains("POSITION")) {
                this.readPOSITION();
                return true;
            }
            if (this.line.startsWith("  FREE ENERGIE") && !this.mDsimulation) {
                this.readEnergy();
            } else if (this.line.contains("ENERGIE OF THE ELECTRON-ION-THERMOSTAT") && this.mDsimulation) {
                this.readMdyn();
            } else if (this.line.startsWith(" Eigenvectors and eigenvalues of the dynamical matrix")) {
                this.readFrequency();
            }
        }
        return true;
    }

    protected void finalizeReader() throws Exception {
        this.setSymmetry();
    }

    private void readElementNames() throws Exception {
        this.elementNames = new List();
        String string = "";
        while (this.readLine() != null && this.line.indexOf("VRHFIN") < 0) {
            int n;
            int n2 = n = this.line.contains("_") ? 2 : 1;
            if (n == 2) {
                this.line = this.line.replace('_', ' ');
            }
            String[] stringArray = VaspOutcarReader.getTokensStr((String)this.line.substring(this.line.indexOf(":") + 1));
            String string2 = stringArray[n];
            String string3 = ";" + string2 + ";";
            if (string.indexOf(string3) >= 0) continue;
            string = string + string3;
            this.elementNames.addLast((Object)string2);
        }
    }

    private void readAtomCountAndSetNames() throws Exception {
        int n;
        int[] nArray = new int[100];
        String[] stringArray = VaspOutcarReader.getTokensStr((String)this.line.substring(this.line.indexOf("=") + 1));
        this.atomCount = 0;
        for (n = 0; n < stringArray.length; ++n) {
            nArray[n] = this.parseIntStr(stringArray[n].trim());
            this.atomCount += nArray[n];
        }
        this.atomNames = new String[this.atomCount];
        n = this.elementNames.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < nArray[i]; ++j) {
                this.atomNames[n2++] = (String)this.elementNames.get(i);
            }
        }
    }

    private void readUnitCellVectors() throws Exception {
        if (this.atomSetCollection.getAtomCount() > 0) {
            this.setSymmetry();
            this.atomSetCollection.newAtomSet();
            this.setAtomSetInfo();
        }
        this.fillFloatArray(null, 0, this.unitCellData);
        this.setUnitCell();
    }

    private void setUnitCell() {
        this.addPrimitiveLatticeVector(0, this.unitCellData, 0);
        this.addPrimitiveLatticeVector(1, this.unitCellData, 6);
        this.addPrimitiveLatticeVector(2, this.unitCellData, 12);
    }

    private void setSymmetry() throws Exception {
        this.applySymmetryAndSetTrajectory();
        this.setSpaceGroupName("P1");
        this.setFractionalCoordinates(false);
    }

    private void readInitialCoordinates() throws Exception {
        int n = 0;
        while (this.readLine() != null && this.line.length() > 10) {
            Atom atom = this.atomSetCollection.addNewAtom();
            String[] stringArray = this.getTokens();
            atom.atomName = this.atomNames[n++];
            float f = this.parseFloatStr(stringArray[0]);
            float f2 = this.parseFloatStr(stringArray[1]);
            float f3 = this.parseFloatStr(stringArray[2]);
            this.setAtomCoordXYZ(atom, f, f2, f3);
        }
        this.atomSetCollection.setAtomSetName("Initial Coordinates");
    }

    private void readPOSITION() throws Exception {
        int n = 0;
        this.readLines(1);
        while (this.readLine() != null && this.line.indexOf("----------") < 0) {
            Atom atom = this.atomSetCollection.addNewAtom();
            String[] stringArray = this.getTokens();
            atom.atomName = this.atomNames[n];
            float f = this.parseFloatStr(stringArray[0]);
            float f2 = this.parseFloatStr(stringArray[1]);
            float f3 = this.parseFloatStr(stringArray[2]);
            this.setAtomCoordXYZ(atom, f, f2, f3);
            ++n;
        }
    }

    private void readEnergy() throws Exception {
        this.readLine();
        String[] stringArray = VaspOutcarReader.getTokensStr((String)this.readLine());
        this.gibbsEnergy = Double.parseDouble(stringArray[4]);
        this.readLine();
        stringArray = VaspOutcarReader.getTokensStr((String)this.readLine());
        double d = Double.parseDouble(stringArray[3]);
        this.gibbsEntropy = d - this.gibbsEnergy;
    }

    private void setAtomSetInfo() {
        if (this.gibbsEnergy == null) {
            return;
        }
        this.atomSetCollection.setAtomSetEnergy("" + this.gibbsEnergy, this.gibbsEnergy.floatValue());
        this.atomSetCollection.setAtomSetAuxiliaryInfo("Energy", (Object)this.gibbsEnergy);
        this.atomSetCollection.setAtomSetAuxiliaryInfo("Entropy", (Object)this.gibbsEntropy);
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("Energy", (Object)this.gibbsEnergy);
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("Entropy", (Object)this.gibbsEntropy);
        this.atomSetCollection.setAtomSetName("G = " + this.gibbsEnergy + " eV, T*S = " + this.gibbsEntropy + " eV");
    }

    private void readMdyn() throws Exception {
        String[] stringArray = this.getTokens();
        this.readLine();
        stringArray = VaspOutcarReader.getTokensStr((String)this.readLine());
        this.electronEne = Double.parseDouble(stringArray[4]);
        stringArray = VaspOutcarReader.getTokensStr((String)this.readLine());
        this.kinEne = Double.parseDouble(stringArray[4]);
        this.temp = this.parseFloatStr(stringArray[6]);
        this.readLines(3);
        stringArray = VaspOutcarReader.getTokensStr((String)this.readLine());
        this.totEne = Double.parseDouble(stringArray[4]);
        this.setAtomSetInfoMd();
    }

    private void setAtomSetInfoMd() {
        this.atomSetCollection.setAtomSetName("Temp. = " + DF.formatDecimal((float)this.temp, (int)2) + " K, Energy = " + this.totEne + " eV");
        this.atomSetCollection.setAtomSetAuxiliaryInfo("Energy", (Object)this.totEne);
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("Energy", (Object)this.totEne);
        this.atomSetCollection.setAtomSetAuxiliaryInfo("EleEnergy", (Object)this.kinEne);
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("EleEnergy", (Object)this.electronEne);
        this.atomSetCollection.setAtomSetAuxiliaryInfo("Kinetic", (Object)this.electronEne);
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("Kinetic", (Object)this.kinEne);
        this.atomSetCollection.setAtomSetAuxiliaryInfo("Temperature", (Object)DF.formatDecimal((float)this.temp, (int)2));
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("Temperature", (Object)DF.formatDecimal((float)this.temp, (int)2));
    }

    private void readFrequency() throws Exception {
        int n = this.atomSetCollection.getCurrentAtomSetIndex();
        this.atomSetCollection.setBaseSymmetryAtomCount(this.atomCount);
        if (this.isVersion5) {
            this.readLines(3);
        } else {
            this.discardLinesUntilContains("Eigenvectors after division by SQRT(mass)");
            this.readLines(5);
        }
        boolean[] blArray = new boolean[1];
        while (this.readLine() != null && (this.line.contains("f  = ") || this.line.contains("f/i= "))) {
            this.applySymmetryAndSetTrajectory();
            int n2 = this.atomSetCollection.getAtomCount();
            this.cloneLastAtomSet(this.atomCount, null);
            if (!blArray[0]) {
                this.atomSetCollection.setCurrentAtomSetIndex(++n);
                this.atomSetCollection.setAtomSetFrequency(null, null, this.line.substring(this.line.indexOf("2PiTHz") + 6, this.line.indexOf("c") - 1).trim(), null);
            }
            this.readLine();
            this.fillFrequencyData(n2, this.atomCount, this.atomCount, blArray, true, 35, 12, null, 0);
            this.readLine();
        }
    }
}

