/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.List;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.P4;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.AtomIndexIterator;
import org.jmol.java.BS;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.readers.AtomDataReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.BSUtil;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.MeshSurface;
import org.jmol.util.TempArray;

class IsoSolventReader
extends AtomDataReader {
    private float cavityRadius;
    private float envelopeRadius;
    private P3[] dots;
    private boolean doCalculateTroughs;
    private boolean isCavity;
    private boolean isPocket;
    protected float solventRadius;
    private AtomIndexIterator iter;
    private BS bsSurfacePoints;
    private BS bsSurfaceDone;
    private BS[] bsLocale;
    private Map<String, Edge> htEdges;
    private List<Edge> vEdges;
    private List<Face> vFaces;
    protected V3 vTemp = new V3();
    protected P4 plane = new P4();
    protected P3 ptTemp2 = new P3();
    private P3 ptS1 = new P3();
    private P3 ptS2 = new P3();
    protected V3 vTemp2 = new V3();
    private V3 vTemp3 = new V3();
    private float dPX;
    protected final P3 p = new P3();
    private float maxRadius;
    private BS[] bsAtomMinMax;
    private boolean isSurfacePoint;
    private int iAtomSurface;
    private static boolean testLinear = false;

    IsoSolventReader() {
    }

    @Override
    void init(SurfaceGenerator surfaceGenerator) {
        this.initADR(surfaceGenerator);
    }

    @Override
    protected boolean readVolumeParameters(boolean bl) {
        this.setup(bl);
        this.initializeVolumetricData();
        if (this.isProgressive) {
            this.volumeData.setUnitVectors();
            this.volumeData.getYzCount();
            this.bsAtomMinMax = new BS[this.nPointsX];
            this.getAtomMinMax(null, this.bsAtomMinMax);
            this.voxelSource = new int[this.volumeData.nPoints];
        }
        return true;
    }

    @Override
    protected void setup(boolean bl) {
        this.setup2();
        if (this.contactPair == null) {
            this.cavityRadius = this.params.cavityRadius;
            this.envelopeRadius = this.params.envelopeRadius;
            this.solventRadius = this.params.solventRadius;
            this.point = this.params.point;
            this.isCavity = this.params.isCavity && this.meshDataServer != null;
            this.isPocket = this.params.pocket != null && this.meshDataServer != null;
            this.doUseIterator = this.doCalculateTroughs = !bl && this.atomDataServer != null && !this.isCavity && this.solventRadius > 0.0f && (this.dataType == 1195 || this.dataType == 1203);
            this.getAtoms(this.params.bsSelected, this.doAddHydrogens, true, false, false, true, false, Float.NaN);
            if (this.isCavity || this.isPocket) {
                this.dots = this.meshDataServer.calculateGeodesicSurface(this.bsMySelected, this.envelopeRadius);
            }
            this.setHeader("solvent/molecular surface", this.params.calculationType);
            if (this.havePlane || !bl) {
                float f = 0.0f;
                this.setRanges(this.params.solvent_ptsPerAngstrom, this.params.solvent_gridMax, f);
                this.volumeData.getYzCount();
                this.margin = this.volumeData.maxGrid * 2.0f;
            }
            if (this.bsNearby != null) {
                this.bsMySelected.or(this.bsNearby);
            }
        } else if (!bl) {
            this.setVolumeData();
        }
        if (!this.doCalculateTroughs) {
            if (bl) {
                this.precalculateVoxelData = false;
                this.volumeData.sr = this;
            } else if (!this.isCavity) {
                this.isXLowToHigh = true;
                this.isProgressive = true;
            }
        }
        if (this.thisAtomSet == null) {
            this.thisAtomSet = BSUtil.setAll((int)this.myAtomCount);
        }
    }

    @Override
    protected void generateCube() {
        if (this.isCavity && this.params.theProperty != null) {
            return;
        }
        this.getMaxRadius();
        if (this.isCavity && this.dataType != 1205 && this.dataType != 1206) {
            this.params.vertexSource = null;
            this.newVoxelDataCube();
            this.resetVoxelData(Float.MAX_VALUE);
            this.markSphereVoxels(this.cavityRadius, this.params.distance);
            this.generateSolventCavity();
            this.resetVoxelData(Float.MAX_VALUE);
            this.markSphereVoxels(0.0f, Float.NaN);
        } else {
            this.voxelSource = new int[this.volumeData.nPoints];
            this.generateSolventCube();
        }
        this.unsetVoxelData();
        List<Object[]> list = this.params.slabInfo;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                if (!((Boolean)((Object[])list.get(i))[2]).booleanValue() || !(((Object[])list.get(i))[0] instanceof P4)) continue;
                this.volumeData.capData((P4)((Object[])list.get(i))[0], this.params.cutoff);
                list.remove(i--);
            }
        }
    }

    @Override
    protected float getSurfacePointAndFraction(float f, boolean bl, float f2, float f3, P3 p3, V3 v3, int n, int n2, int n3, int n4, int n5, float[] fArray, P3 p32) {
        int n6 = this.marchingCubes.getLinearOffset(n, n2, n3, n4);
        int n7 = this.marchingCubes.getLinearOffset(n, n2, n3, n5);
        boolean bl2 = this.isSurfacePoint = this.bsSurfaceVoxels != null && (this.bsSurfaceVoxels.get(n6) || this.bsSurfaceVoxels.get(n7));
        if (testLinear || this.voxelSource == null || this.voxelSource[n6] == 0 || this.voxelSource[n6] != this.voxelSource[n7]) {
            return this.getSPF(f, bl, f2, f3, p3, v3, n, n2, n3, n6, n7, fArray, p32);
        }
        int n8 = Math.abs(f2 < f3 ? this.voxelSource[n6] : this.voxelSource[n7]);
        this.iAtomSurface = this.atomIndex[n8 - 1];
        float f4 = fArray[0] = MeshSurface.getSphericalInterpolationFraction((double)(this.voxelSource[n6] < 0 ? this.solventRadius : this.atomRadius[this.voxelSource[n6] - 1]), (double)f2, (double)f3, (double)v3.length());
        p32.scaleAdd2(f4, (T3)v3, (T3)p3);
        float f5 = f3 - f2;
        return f2 + f4 * f5;
    }

    @Override
    public int addVertexCopy(P3 p3, float f, int n) {
        int n2 = this.addVC(p3, f, n);
        if (n2 < 0) {
            return n2;
        }
        if (this.isSurfacePoint) {
            this.bsSurfacePoints.set(n2);
        }
        if (this.params.vertexSource != null) {
            this.params.vertexSource[n2] = this.iAtomSurface;
        }
        return n2;
    }

    @Override
    public void selectPocket(boolean bl) {
        int n;
        int n2;
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
        }
        P3[] p3Array = this.meshData.vertices;
        int n3 = this.meshData.vertexCount;
        float[] fArray = this.meshData.vertexValues;
        int n4 = this.dots.length;
        for (n2 = 0; n2 < n3; ++n2) {
            for (int i = 0; i < n4; ++i) {
                if (!(this.dots[i].distance((T3)p3Array[n2]) < this.envelopeRadius)) continue;
                fArray[n2] = Float.NaN;
            }
        }
        this.meshData.getSurfaceSet();
        n2 = this.meshData.nSets;
        BS bS = BSUtil.newBitSet((int)n2);
        block2: for (n = 0; n < n2; ++n) {
            BS bS2 = this.meshData.surfaceSet[n];
            if (bS2 == null) continue;
            int n5 = bS2.nextSetBit(0);
            while (n5 >= 0) {
                if (Float.isNaN(this.meshData.vertexValues[n5])) {
                    bS.set(n);
                    continue block2;
                }
                n5 = bS2.nextSetBit(n5 + 1);
            }
        }
        for (n = 0; n < n2; ++n) {
            if (this.meshData.surfaceSet[n] == null || bS.get(n) != bl) continue;
            this.meshData.invalidateSurfaceSet(n);
        }
        this.updateSurfaceData();
        if (!bl) {
            this.meshData.surfaceSet = null;
        }
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 3, null);
            this.meshData = new MeshData();
        }
    }

    @Override
    protected void postProcessVertices() {
        this.setVertexSource();
        if (this.doCalculateTroughs && this.bsSurfacePoints != null) {
            BS bS = new BS();
            BS[] bSArray = this.meshData.getSurfaceSet();
            BS[] bSArray2 = null;
            double[] dArray = (double[])(this.isPocket ? null : this.meshData.calculateVolumeOrArea(Integer.MIN_VALUE, false, false));
            float f = (float)(4.71238898038469 * Math.pow(this.solventRadius, 3.0));
            double d = 0.0;
            boolean bl = false;
            if (dArray != null && !this.isCavity) {
                for (int i = 0; i < this.meshData.nSets; ++i) {
                    double d2 = dArray[i];
                    if (!(Math.abs(d2) > d)) continue;
                    d = Math.abs(d2);
                    bl = d2 < 0.0;
                }
            }
            double d3 = bl ? -1 : 1;
            for (int i = 0; i < this.meshData.nSets; ++i) {
                BS bS2 = bSArray[i];
                if (bS2.intersects(this.bsSurfacePoints) && (dArray == null || dArray[i] * d3 > (double)f) && this.params.vertexSource != null) {
                    BS bS3 = new BS();
                    if (bSArray2 == null) {
                        bSArray2 = new BS[bSArray.length];
                    }
                    int n = bS2.nextSetBit(0);
                    while (n >= 0) {
                        int n2 = this.params.vertexSource[n];
                        if (n2 >= 0) {
                            if (bS.get(n2)) {
                                this.meshData.invalidateSurfaceSet(i);
                                break;
                            }
                            bS3.set(n2);
                        }
                        n = bS2.nextSetBit(n + 1);
                    }
                    bS.or(bS3);
                    continue;
                }
                this.meshData.invalidateSurfaceSet(i);
            }
            this.updateSurfaceData();
            if (this.meshDataServer != null) {
                this.meshDataServer.fillMeshData(this.meshData, 3, null);
                this.meshData = new MeshData();
            }
        }
        if (this.params.thePlane != null && this.params.slabInfo == null) {
            this.params.addSlabInfo(TempArray.getSlabWithinRange((float)-100.0f, (float)0.0f));
        }
    }

    private void generateSolventCavity() {
        int n;
        int n2;
        int n3;
        int n4;
        BS bS = BSUtil.newBitSet((int)(this.nPointsX * this.nPointsY * this.nPointsZ));
        int n5 = 0;
        int n6 = this.dots.length;
        int n7 = 0;
        float f = this.envelopeRadius;
        for (n4 = 0; n4 < this.nPointsX; ++n4) {
            for (n3 = 0; n3 < this.nPointsY; ++n3) {
                n2 = 0;
                while (n2 < this.nPointsZ) {
                    block9: {
                        float f2;
                        float f3 = this.voxelData[n4][n3][n2];
                        if (f2 < Float.MAX_VALUE && f3 >= this.cavityRadius) {
                            this.volumeData.voxelPtToXYZ(n4, n3, n2, this.ptXyzTemp);
                            for (n = 0; n < n6; ++n) {
                                if (!(this.dots[n].distance((T3)this.ptXyzTemp) < f)) {
                                    continue;
                                }
                                break block9;
                            }
                            bS.set(n5);
                            ++n7;
                        }
                    }
                    ++n2;
                    ++n5;
                }
            }
        }
        Logger.info((String)("cavities include " + n7 + " voxel points"));
        this.atomRadius = new float[n7];
        this.atomXyz = new P3[n7];
        n3 = 0;
        n2 = 0;
        for (n4 = 0; n4 < this.nPointsX; ++n4) {
            for (n = 0; n < this.nPointsY; ++n) {
                for (int i = 0; i < this.nPointsZ; ++i) {
                    if (!bS.get(n3++)) continue;
                    this.atomXyz[n2] = new P3();
                    this.volumeData.voxelPtToXYZ(n4, n, i, this.atomXyz[n2]);
                    this.atomRadius[n2++] = this.voxelData[n4][n][i];
                }
            }
        }
        this.myAtomCount = this.firstNearbyAtom = n7;
        this.thisAtomSet = BSUtil.setAll((int)this.myAtomCount);
    }

    private void generateSolventCube() {
        if (this.dataType == 1205) {
            return;
        }
        this.params.vertexSource = new int[this.volumeData.nPoints];
        this.bsSurfaceDone = new BS();
        this.bsSurfaceVoxels = new BS();
        this.bsSurfacePoints = new BS();
        if (this.doCalculateTroughs) {
            this.iter = this.atomDataServer.getSelectedAtomIterator(this.bsMySelected, true, false, false);
            this.vEdges = new List();
            this.bsLocale = new BS[this.myAtomCount];
            this.htEdges = new Hashtable<String, Edge>();
            this.getEdges();
            Logger.info((String)(this.vEdges.size() + " edges"));
            this.vFaces = new List();
            this.getFaces();
            Logger.info((String)(this.vFaces.size() + " faces"));
            this.bsLocale = null;
            this.htEdges = null;
            this.iter.release();
            this.iter = null;
            this.newVoxelDataCube();
            this.resetVoxelData(Float.MAX_VALUE);
            this.markFaceVoxels(true);
            this.markToroidVoxels();
            this.vEdges = null;
            this.markFaceVoxels(false);
            this.vFaces = null;
        } else {
            this.newVoxelDataCube();
            this.resetVoxelData(Float.MAX_VALUE);
        }
        this.markSphereVoxels(0.0f, this.doCalculateTroughs ? Float.MAX_VALUE : this.params.distance);
        this.noFaceSpheres = null;
        this.validSpheres = null;
    }

    private void getEdges() {
        for (int i = 0; i < this.myAtomCount; ++i) {
            this.bsLocale[i] = new BS();
        }
        float f = this.solventRadius + this.maxRadius;
        for (int i = 0; i < this.myAtomCount; ++i) {
            P3 p3 = this.atomXyz[i];
            float f2 = this.atomRadius[i] + this.solventRadius;
            this.atomDataServer.setIteratorForAtom(this.iter, this.atomIndex[i], f2 + f);
            while (this.iter.hasNext()) {
                int n = this.iter.next();
                int n2 = this.myIndex[n];
                if (i >= this.firstNearbyAtom && n2 >= this.firstNearbyAtom) continue;
                P3 p32 = this.atomXyz[n2];
                float f3 = this.atomRadius[n2] + this.solventRadius;
                float f4 = p3.distance((T3)p32);
                if (f4 >= f2 + f3) continue;
                Edge edge = new Edge(i, n2);
                this.vEdges.addLast((Object)edge);
                this.bsLocale[i].set(n2);
                this.bsLocale[n2].set(i);
                this.htEdges.put(edge.toString(), edge);
            }
        }
    }

    protected Edge findEdge(int n, int n2) {
        return this.htEdges.get(n < n2 ? n + "_" + n2 : n2 + "_" + n);
    }

    private void getFaces() {
        BS bS = new BS();
        this.validSpheres = new BS();
        this.noFaceSpheres = BSUtil.setAll((int)this.myAtomCount);
        int n = this.vEdges.size();
        while (--n >= 0) {
            Edge edge = (Edge)this.vEdges.get(n);
            int n2 = edge.ia;
            int n3 = edge.ib;
            bS.clearAll();
            bS.or(this.bsLocale[n2]);
            bS.and(this.bsLocale[n3]);
            int n4 = bS.nextSetBit(n3 + 1);
            while (n4 >= 0) {
                if (this.getSolventPoints(n2, n3, n4)) {
                    boolean bl = false;
                    Face face = new Face(n2, n3, n4, edge, this.ptS1);
                    if (this.validateFace(face)) {
                        this.vFaces.addLast((Object)face);
                        bl = true;
                    }
                    if (this.validateFace(face = new Face(n2, n3, n4, edge, this.ptS2))) {
                        this.vFaces.addLast((Object)face);
                        bl = true;
                    }
                    if (bl) {
                        this.noFaceSpheres.clear(n2);
                        this.noFaceSpheres.clear(n3);
                        this.noFaceSpheres.clear(n4);
                    }
                }
                n4 = bS.nextSetBit(n4 + 1);
            }
        }
    }

    private boolean getSolventPoints(int n, int n2, int n3) {
        double d = this.getPointP(n, n2);
        P3 p3 = this.atomXyz[n3];
        float f = this.atomRadius[n3] + this.solventRadius;
        float f2 = Measure.distanceToPlane((P4)this.plane, (P3)p3);
        if (Math.abs(f2) >= f * 0.9f) {
            return false;
        }
        double d2 = Math.sqrt(f * f - f2 * f2);
        this.ptTemp.scaleAdd2(-f2, (T3)this.vTemp, (T3)p3);
        double d3 = this.p.distance((T3)this.ptTemp);
        float f3 = (float)(d * d);
        double d4 = ((double)f3 + d3 * d3 - d2 * d2) / (2.0 * d * d3);
        if (Math.abs(d4) >= 0.99) {
            return false;
        }
        V3 v3 = this.vTemp2;
        v3.sub2((T3)this.ptTemp, (T3)this.p);
        v3.normalize();
        this.dPX = (float)(d * d4);
        this.ptTemp.scaleAdd2(this.dPX, (T3)v3, (T3)this.p);
        v3.cross(this.vTemp, v3);
        v3.normalize();
        v3.scale((float)(Math.sqrt(1.0 - d4 * d4) * d));
        this.ptS1.add2((T3)this.ptTemp, (T3)v3);
        this.ptS2.add2((T3)this.ptTemp, (T3)v3);
        return true;
    }

    private boolean validateFace(Face face) {
        int n;
        float f = this.solventRadius + this.maxRadius;
        this.atomDataServer.setIteratorForPoint(this.iter, this.modelIndex, face.pS, f);
        face.isValid = true;
        while (this.iter.hasNext()) {
            float f2;
            n = this.iter.next();
            int n2 = this.myIndex[n];
            if (n2 == face.ia || n2 == face.ib || n2 == face.ic || !((f2 = this.atomData.atomXyz[n].distance((T3)face.pS)) < this.atomData.atomRadius[n] + this.solventRadius)) continue;
            face.isValid = false;
            break;
        }
        face.setEdges();
        if (!face.isValid) {
            return false;
        }
        for (n = 0; n < 3; ++n) {
            this.validSpheres.set(face.edges[n].ia);
            this.validSpheres.set(face.edges[n].ib);
        }
        face.edges = null;
        return true;
    }

    private void markFaceVoxels(boolean bl) {
        BS bS = new BS();
        int n = this.vFaces.size();
        while (--n >= 0) {
            Face face = (Face)this.vFaces.get(n);
            if (!face.isValid) continue;
            this.setGridLimitsForAtom(face.pS, this.solventRadius, this.pt0, this.pt1);
            this.volumeData.voxelPtToXYZ(this.pt0.x, this.pt0.y, this.pt0.z, this.ptXyzTemp);
            P3 p3 = this.atomXyz[face.ia];
            P3 p32 = this.atomXyz[face.ib];
            P3 p33 = this.atomXyz[face.ic];
            P3 p34 = face.pS;
            for (int i = this.pt0.x; i < this.pt1.x; ++i) {
                this.ptY0.setT((T3)this.ptXyzTemp);
                for (int j = this.pt0.y; j < this.pt1.y; ++j) {
                    this.ptZ0.setT((T3)this.ptXyzTemp);
                    for (int k = this.pt0.z; k < this.pt1.z; ++k) {
                        float f = this.solventRadius - this.ptXyzTemp.distance((T3)p34);
                        float f2 = this.voxelData[i][j][k];
                        int n2 = this.volumeData.getPointIndex(i, j, k);
                        if (bl && f > 0.0f) {
                            this.bsSurfaceDone.set(n2);
                        }
                        if (Measure.isInTetrahedron((P3)this.ptXyzTemp, (P3)p3, (P3)p32, (P3)p33, (P3)p34, (P4)this.plane, (V3)this.vTemp, (V3)this.vTemp2, (V3)this.vTemp3, (boolean)false) && (!bl ? !this.bsSurfaceDone.get(n2) && f < 0.0f && f > -this.volumeData.maxGrid * 1.8f && f > f2 == bS.get(n2) : f > 0.0f && (f2 < 0.0f || f2 == Float.MAX_VALUE || f > f2 == bS.get(n2)))) {
                            bS.set(n2);
                            this.setVoxel(i, j, k, n2, f);
                            if (this.voxelSource != null) {
                                this.voxelSource[n2] = -1 - face.ia;
                            }
                            if (f > 0.0f) {
                                this.bsSurfaceVoxels.set(n2);
                            }
                        }
                        this.ptXyzTemp.add((T3)this.volumetricVectors[2]);
                    }
                    this.ptXyzTemp.scaleAdd2(1.0f, (T3)this.volumetricVectors[1], (T3)this.ptZ0);
                }
                this.ptXyzTemp.scaleAdd2(1.0f, (T3)this.volumetricVectors[0], (T3)this.ptY0);
            }
        }
    }

    private void markToroidVoxels() {
        P3i p3i = new P3i();
        P3i p3i2 = new P3i();
        P3i p3i3 = new P3i();
        P3i p3i4 = new P3i();
        int n = this.vEdges.size();
        while (--n >= 0) {
            Edge edge = (Edge)this.vEdges.get(n);
            int n2 = edge.ia;
            int n3 = edge.ib;
            P3 p3 = this.atomXyz[n2];
            P3 p32 = this.atomXyz[n3];
            float f = this.atomRadius[n2] + this.solventRadius;
            float f2 = this.atomRadius[n3] + this.solventRadius;
            float f3 = p32.distance((T3)p3);
            this.setGridLimitsForAtom(p3, this.atomRadius[n2] + this.solventRadius, p3i, p3i3);
            this.setGridLimitsForAtom(p32, this.atomRadius[n3] + this.solventRadius, p3i2, p3i4);
            IsoSolventReader.mergeLimits(p3i, p3i2, this.pt0, null);
            IsoSolventReader.mergeLimits(p3i3, p3i4, null, this.pt1);
            this.volumeData.voxelPtToXYZ(this.pt0.x, this.pt0.y, this.pt0.z, this.ptXyzTemp);
            for (int i = this.pt0.x; i < this.pt1.x; ++i) {
                this.ptY0.setT((T3)this.ptXyzTemp);
                for (int j = this.pt0.y; j < this.pt1.y; ++j) {
                    this.ptZ0.setT((T3)this.ptXyzTemp);
                    for (int k = this.pt0.z; k < this.pt1.z; ++k) {
                        float f4;
                        float f5 = this.checkSpecialVoxel(p3, f, p32, f2, f3, this.ptXyzTemp);
                        if (!Float.isNaN(f5) && (f4 = this.solventRadius - f5) < this.voxelData[i][j][k]) {
                            int n4 = this.volumeData.getPointIndex(i, j, k);
                            this.setVoxel(i, j, k, n4, f4);
                            if (this.voxelSource != null) {
                                this.voxelSource[n4] = -1 - n2;
                            }
                        }
                        this.ptXyzTemp.add((T3)this.volumetricVectors[2]);
                    }
                    this.ptXyzTemp.scaleAdd2(1.0f, (T3)this.volumetricVectors[1], (T3)this.ptZ0);
                }
                this.ptXyzTemp.scaleAdd2(1.0f, (T3)this.volumetricVectors[0], (T3)this.ptY0);
            }
        }
        this.validSpheres.or(this.noFaceSpheres);
    }

    @Override
    protected void unsetVoxelData() {
        if (!this.havePlane) {
            this.unsetVoxelData2();
            return;
        }
        if (this.isProgressive) {
            for (int i = 0; i < this.yzCount; ++i) {
                if (this.thisPlane[i] < 0.001f) continue;
                this.thisPlane[i] = 0.001f;
            }
        } else {
            for (int i = 0; i < this.nPointsX; ++i) {
                for (int j = 0; j < this.nPointsY; ++j) {
                    for (int k = 0; k < this.nPointsZ; ++k) {
                        if (this.voxelData[i][j][k] < 0.001f) continue;
                        this.voxelData[i][j][k] = 0.001f;
                    }
                }
            }
        }
    }

    void getMaxRadius() {
        this.maxRadius = 0.0f;
        for (int i = 0; i < this.myAtomCount; ++i) {
            float f = this.atomRadius[i];
            if (!(f > this.maxRadius)) continue;
            this.maxRadius = f;
        }
    }

    private static void mergeLimits(P3i p3i, P3i p3i2, P3i p3i3, P3i p3i4) {
        if (p3i3 != null) {
            p3i3.x = Math.min(p3i.x, p3i2.x);
            p3i3.y = Math.min(p3i.y, p3i2.y);
            p3i3.z = Math.min(p3i.z, p3i2.z);
        }
        if (p3i4 != null) {
            p3i4.x = Math.max(p3i.x, p3i2.x);
            p3i4.y = Math.max(p3i.y, p3i2.y);
            p3i4.z = Math.max(p3i.z, p3i2.z);
        }
    }

    private float checkSpecialVoxel(P3 p3, float f, P3 p32, float f2, float f3, P3 p33) {
        float f4;
        float f5 = p3.distance((T3)p33);
        float f6 = p32.distance((T3)p33);
        float f7 = f / f5;
        if (f7 > 1.0f) {
            this.p.set(p3.x + (p33.x - p3.x) * f7, p3.y + (p33.y - p3.y) * f7, p3.z + (p33.z - p3.z) * f7);
            if (p32.distance((T3)this.p) >= f2) {
                return Float.NaN;
            }
            float f8 = this.solventDistance(f, f2, f3, f5, f6);
            return IsoSolventReader.voxelIsInTrough(f8, f * f, f2, f3, f5) ? f8 : Float.NaN;
        }
        f7 = f2 / f6;
        if (f4 > 1.0f) {
            this.p.set(p32.x + (p33.x - p32.x) * f7, p32.y + (p33.y - p32.y) * f7, p32.z + (p33.z - p32.z) * f7);
            if (p3.distance((T3)this.p) >= f) {
                return Float.NaN;
            }
            float f9 = this.solventDistance(f2, f, f3, f6, f5);
            return IsoSolventReader.voxelIsInTrough(f9, f2 * f2, f, f3, f6) ? f9 : Float.NaN;
        }
        return Float.NaN;
    }

    private static boolean voxelIsInTrough(float f, float f2, float f3, float f4, float f5) {
        float f6 = (f2 + f3 * f3 - f4 * f4) / f3;
        float f7 = (f2 + f * f - f5 * f5) / f;
        return f6 < f7;
    }

    private float solventDistance(float f, float f2, float f3, float f4, float f5) {
        double d = f4 * f4;
        double d2 = f * f;
        double d3 = f3 * f3;
        double d4 = Math.acos((d + d3 - (double)(f5 * f5)) / (double)(2.0f * f4 * f3));
        double d5 = Math.acos((d3 + d2 - (double)(f2 * f2)) / (double)(2.0f * f3 * f));
        float f6 = (float)Math.sqrt(d2 + d - (double)(2.0f * f * f4) * Math.cos(d5 - d4));
        return f6;
    }

    protected double getPointP(int n, int n2) {
        P3 p3 = this.atomXyz[n];
        P3 p32 = this.atomXyz[n2];
        float f = this.atomRadius[n] + this.solventRadius;
        float f2 = this.atomRadius[n2] + this.solventRadius;
        this.vTemp.sub2((T3)p32, (T3)p3);
        float f3 = this.vTemp.length();
        this.vTemp.normalize();
        double d = f * f;
        double d2 = f3 * f3;
        double d3 = (d2 + d - (double)(f2 * f2)) / (double)(2.0f * f3 * f);
        double d4 = Math.acos(d3);
        this.p.scaleAdd2((float)(d3 * (double)f), (T3)this.vTemp, (T3)p3);
        Measure.getPlaneThroughPoint((P3)this.p, (V3)this.vTemp, (P4)this.plane);
        return Math.sin(d4) * (double)f;
    }

    @Override
    public float getValueAtPoint(P3 p3, boolean bl) {
        if (this.contactPair != null) {
            return p3.distance((T3)this.contactPair.myAtoms[1]) - this.contactPair.radii[1];
        }
        float f = Float.MAX_VALUE;
        for (int i = 0; i < this.firstNearbyAtom; ++i) {
            float f2 = p3.distance((T3)this.atomXyz[i]) - this.atomRadius[i] - this.solventRadius;
            if (!(f2 < f)) continue;
            f = f2;
        }
        return f == Float.MAX_VALUE ? Float.NaN : f;
    }

    @Override
    public float[] getPlane(int n) {
        if (this.yzCount == 0) {
            this.initPlanes();
        }
        this.thisX = n;
        this.thisPlane = this.yzPlanes[n % 2];
        if (this.contactPair == null) {
            this.resetPlane(Float.MAX_VALUE);
            this.thisAtomSet = this.bsAtomMinMax[n];
            this.markSphereVoxels(0.0f, this.params.distance);
            this.unsetVoxelData();
        } else {
            this.markPlaneVoxels((P3)this.contactPair.myAtoms[0], this.contactPair.radii[0]);
        }
        return this.thisPlane;
    }

    private class Face {
        int ia;
        int ib;
        int ic;
        boolean isValid;
        P3 pS;
        Edge[] edges = new Edge[3];

        Face(int n, int n2, int n3, Edge edge, P3 p3) {
            this.ia = n;
            this.ib = n2;
            this.ic = n3;
            this.pS = P3.newP((T3)p3);
            this.edges[0] = edge;
        }

        void setEdges() {
            if (this.edges[1] == null) {
                this.edges[1] = IsoSolventReader.this.findEdge(this.ib, this.ic);
                this.edges[2] = IsoSolventReader.this.findEdge(this.ic, this.ia);
            }
            Face face = this.isValid ? this : null;
            for (int i = 0; i < 3; ++i) {
                this.edges[i].addFace(face);
            }
        }
    }

    private class Edge {
        int ia;
        int ib;
        private List<Face> aFaces;

        Edge(int n, int n2) {
            this.ia = Math.min(n, n2);
            this.ib = Math.max(n, n2);
        }

        void addFace(Face face) {
            if (face == null) {
                return;
            }
            if (this.aFaces == null) {
                this.aFaces = new List();
            }
            this.aFaces.addLast((Object)face);
        }

        public String toString() {
            return this.ia + "_" + this.ib;
        }
    }
}

