/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.List;
import javajs.util.P3;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.util.BSUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Quaternion;
import org.jmol.util.Txt;

class PointGroup {
    private static final int[] axesMaxN = new int[]{15, 0, 0, 1, 3, 1, 10, 0, 1, 0, 6, 0, 1, 0, 0, 0, 15, 10, 6, 6, 10, 0, 1};
    private static final int[] nUnique = new int[]{1, 0, 0, 2, 2, 4, 2, 0, 4, 0, 4, 0, 4, 0, 0, 0, 1, 2, 2, 4, 2, 0, 4};
    private static final int s3 = 3;
    private static final int s4 = 4;
    private static final int s5 = 5;
    private static final int s6 = 6;
    private static final int s8 = 8;
    private static final int s10 = 10;
    private static final int s12 = 12;
    private static final int firstProper = 14;
    private static final int c2 = 16;
    private static final int c3 = 17;
    private static final int c4 = 18;
    private static final int c5 = 19;
    private static final int c6 = 20;
    private static final int c8 = 22;
    private static final int maxAxis = axesMaxN.length;
    String drawInfo;
    Map<String, Object> info;
    String textInfo;
    private String drawType = "";
    private int drawIndex;
    private float scale = Float.NaN;
    private int[] nAxes = new int[maxAxis];
    private Operation[][] axes = new Operation[maxAxis][];
    private int nAtoms;
    private float radius;
    private float distanceTolerance = 0.2f;
    private float linearTolerance = 8.0f;
    private float cosTolerance = 0.99f;
    private String name = "C_1?";
    private Operation principalAxis;
    private Operation principalPlane;
    private final V3 vTemp = new V3();
    private int centerAtomIndex = -1;
    private boolean haveInversionCenter;
    private final P3 center = new P3();
    private P3[] points;
    private Atom[] atoms;
    private int[] elements;
    private BS bsAtoms;
    private static final int ATOM_COUNT_MAX = 100;
    int maxElement = 0;
    int[] eCounts;
    static final int OPERATION_PLANE = 0;
    static final int OPERATION_PROPER_AXIS = 1;
    static final int OPERATION_IMPROPER_AXIS = 2;
    static final int OPERATION_INVERSION_CENTER = 3;
    static final String[] typeNames = new String[]{"plane", "proper axis", "improper axis", "center of inversion"};
    int nOps = 0;

    String getName() {
        return this.name;
    }

    static PointGroup getPointGroup(PointGroup pointGroup, Atom[] atomArray, BS bS, boolean bl, float f, float f2) {
        PointGroup pointGroup2 = new PointGroup();
        return pointGroup2.set(pointGroup, atomArray, bS, bl, f, f2) ? pointGroup2 : pointGroup;
    }

    private PointGroup() {
    }

    private boolean isEqual(PointGroup pointGroup) {
        if (pointGroup == null) {
            return false;
        }
        if (this.linearTolerance != pointGroup.linearTolerance || this.distanceTolerance != pointGroup.distanceTolerance || this.nAtoms != pointGroup.nAtoms || !this.bsAtoms.equals((Object)pointGroup.bsAtoms)) {
            return false;
        }
        for (int i = 0; i < this.nAtoms; ++i) {
            if (this.elements[i] == pointGroup.elements[i] && this.points[i].distance((T3)pointGroup.points[i]) == 0.0f) continue;
            return false;
        }
        return true;
    }

    private boolean set(PointGroup pointGroup, Atom[] atomArray, BS bS, boolean bl, float f, float f2) {
        int n;
        this.distanceTolerance = f;
        this.linearTolerance = f2;
        this.bsAtoms = bS;
        this.cosTolerance = (float)Math.cos((double)(f2 / 180.0f) * Math.PI);
        if (!this.getAtomsAndElements(atomArray, bS)) {
            Logger.error((String)"Too many atoms for point group calculation");
            this.name = "point group not determined -- atomCount > 100 -- select fewer atoms and try again.";
            return true;
        }
        this.getElementCounts();
        if (bl) {
            P3[] p3Array = new P3[this.points.length];
            n = this.points.length;
            while (--n >= 0) {
                p3Array[n] = P3.newP((T3)this.points[n]);
                V3 v3 = this.atoms[n].getVibrationVector();
                if (v3 == null) continue;
                p3Array[n].add((T3)v3);
            }
            this.points = p3Array;
        }
        if (this.isEqual(pointGroup)) {
            return false;
        }
        this.findInversionCenter();
        if (this.isLinear(this.points)) {
            this.name = this.haveInversionCenter ? "D(infinity)h" : "C(infinity)v";
            this.vTemp.sub2((T3)this.points[1], (T3)this.points[0]);
            this.addAxis(16, this.vTemp);
            this.principalAxis = this.axes[16][0];
            if (this.haveInversionCenter) {
                this.axes[0] = new Operation[1];
                int n2 = this.nAxes[0];
                this.nAxes[0] = n2 + 1;
                Operation operation = new Operation(this.vTemp);
                this.axes[0][n2] = operation;
                this.principalPlane = operation;
            }
            return true;
        }
        this.axes[0] = new Operation[15];
        int n3 = 0;
        this.findCAxes();
        n3 = this.findPlanes();
        this.findAdditionalAxes(n3);
        n = this.getHighestOrder();
        if (this.nAxes[17] > 1) {
            this.name = this.nAxes[19] > 1 ? (this.haveInversionCenter ? "Ih" : "I") : (this.nAxes[18] > 1 ? (this.haveInversionCenter ? "Oh" : "O") : (n3 > 0 ? (this.haveInversionCenter ? "Th" : "Td") : "T"));
        } else if (n < 2) {
            if (n3 == 1) {
                this.name = "Cs";
                return true;
            }
            if (this.haveInversionCenter) {
                this.name = "Ci";
                return true;
            }
            this.name = "C1";
        } else if (n % 2 == 1 && this.nAxes[16] > 0 || n % 2 == 0 && this.nAxes[16] > 1) {
            this.principalAxis = this.setPrincipalAxis(n, n3);
            if (n3 == 0) {
                this.name = n < 14 ? "S" + n : "D" + (n - 14);
            } else {
                n = n < 14 ? (n /= 2) : (n -= 14);
                this.name = n3 == n ? "D" + n + "d" : "D" + n + "h";
            }
        } else if (n3 == 0) {
            this.principalAxis = this.axes[n][0];
            this.name = n < 14 ? "S" + n : "C" + (n - 14);
        } else if (n3 == n - 14) {
            this.principalAxis = this.axes[n][0];
            this.name = "C" + n3 + "v";
        } else {
            this.principalAxis = this.axes[n < 14 ? n + 14 : n][0];
            this.principalPlane = this.axes[0][0];
            n = n < 14 ? (n /= 2) : (n -= 14);
            this.name = "C" + n + "h";
        }
        return true;
    }

    private Operation setPrincipalAxis(int n, int n2) {
        Operation operation = this.setPrincipalPlane(n, n2);
        if (n2 == 0 && n < 14 || this.nAxes[n] == 1) {
            if (n2 > 0 && n < 14) {
                n = 14 + n / 2;
            }
            return this.axes[n][0];
        }
        if (operation == null) {
            return null;
        }
        for (int i = 0; i < this.nAxes[16]; ++i) {
            if (!this.isParallel(operation.normalOrAxis, this.axes[16][i].normalOrAxis)) continue;
            if (i != 0) {
                Operation operation2 = this.axes[16][0];
                this.axes[16][0] = this.axes[16][i];
                this.axes[16][i] = operation2;
            }
            return this.axes[16][0];
        }
        return null;
    }

    private Operation setPrincipalPlane(int n, int n2) {
        if (n2 == 1) {
            this.principalPlane = this.axes[0][0];
            return this.principalPlane;
        }
        if (n2 == 0 || n2 == n - 14) {
            return null;
        }
        for (int i = 0; i < n2; ++i) {
            int n3 = 0;
            for (int j = 0; j < n2; ++j) {
                if (!this.isPerpendicular(this.axes[0][i].normalOrAxis, this.axes[0][j].normalOrAxis) || ++n3 <= 2) continue;
                if (i != 0) {
                    Operation operation = this.axes[0][0];
                    this.axes[0][0] = this.axes[0][i];
                    this.axes[0][i] = operation;
                }
                this.principalPlane = this.axes[0][0];
                return this.principalPlane;
            }
        }
        return null;
    }

    private boolean getAtomsAndElements(Atom[] atomArray, BS bS) {
        int n = BSUtil.cardinalityOf((BS)bS);
        if (n > 100) {
            return false;
        }
        this.points = new P3[n];
        this.atoms = new Atom[n];
        this.elements = new int[n];
        if (n == 0) {
            return true;
        }
        this.nAtoms = 0;
        int n2 = bS.nextSetBit(0);
        while (n2 >= 0) {
            this.points[this.nAtoms] = P3.newP((T3)atomArray[n2]);
            this.atoms[this.nAtoms] = atomArray[n2];
            int n3 = 1 + Math.max(3, atomArray[n2].getCovalentBondCount());
            this.elements[this.nAtoms] = atomArray[n2].getElementNumber() * n3;
            this.center.add((T3)this.points[this.nAtoms++]);
            n2 = bS.nextSetBit(n2 + 1);
        }
        this.center.scale(1.0f / (float)this.nAtoms);
        n2 = this.nAtoms;
        while (--n2 >= 0) {
            float f = this.center.distance((T3)this.points[n2]);
            if (f < this.distanceTolerance) {
                this.centerAtomIndex = n2;
            }
            this.radius = Math.max(this.radius, f);
        }
        return true;
    }

    private void findInversionCenter() {
        this.haveInversionCenter = this.checkOperation(null, this.center, -1);
        if (this.haveInversionCenter) {
            this.axes[1] = new Operation[1];
            this.axes[1][0] = new Operation();
        }
    }

    private boolean checkOperation(Quaternion quaternion, P3 p3, int n) {
        P3 p32 = new P3();
        int n2 = 0;
        boolean bl = n < 14;
        int n3 = this.points.length;
        block0: while (--n3 >= 0 && n2 < this.points.length) {
            if (n3 == this.centerAtomIndex) {
                ++n2;
                continue;
            }
            P3 p33 = this.points[n3];
            int n4 = this.elements[n3];
            if (quaternion != null) {
                p32.sub2((T3)p33, (T3)p3);
                quaternion.transformP2((T3)p32, (T3)p32).add((T3)p3);
            } else {
                p32.setT((T3)p33);
            }
            if (bl) {
                this.vTemp.sub2((T3)p3, (T3)p32);
                p32.scaleAdd2(2.0f, (T3)this.vTemp, (T3)p32);
            }
            if ((quaternion != null || bl) && p32.distance((T3)p33) < this.distanceTolerance) {
                ++n2;
                continue;
            }
            int n5 = this.points.length;
            while (--n5 >= 0) {
                P3 p34;
                if (n5 == n3 || this.elements[n5] != n4 || !(p32.distance((T3)(p34 = this.points[n5])) < this.distanceTolerance)) continue;
                ++n2;
                continue block0;
            }
        }
        return n2 == this.points.length;
    }

    private boolean isLinear(P3[] p3Array) {
        V3 v3 = null;
        if (p3Array.length < 2) {
            return false;
        }
        int n = p3Array.length;
        while (--n >= 0) {
            if (n == this.centerAtomIndex) continue;
            if (v3 == null) {
                v3 = new V3();
                v3.sub2((T3)p3Array[n], (T3)this.center);
                v3.normalize();
                this.vTemp.setT((T3)v3);
                continue;
            }
            this.vTemp.sub2((T3)p3Array[n], (T3)this.center);
            this.vTemp.normalize();
            if (this.isParallel(v3, this.vTemp)) continue;
            return false;
        }
        return true;
    }

    private boolean isParallel(V3 v3, V3 v32) {
        return Math.abs(v3.dot((T3)v32)) >= this.cosTolerance;
    }

    private boolean isPerpendicular(V3 v3, V3 v32) {
        return Math.abs(v3.dot((T3)v32)) <= 1.0f - this.cosTolerance;
    }

    private void getElementCounts() {
        int n = this.points.length;
        while (--n >= 0) {
            int n2 = this.elements[n];
            if (n2 <= this.maxElement) continue;
            this.maxElement = n2;
        }
        this.eCounts = new int[++this.maxElement];
        n = this.points.length;
        while (--n >= 0) {
            int n3 = this.elements[n];
            this.eCounts[n3] = this.eCounts[n3] + 1;
        }
    }

    private int findCAxes() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        V3 v3 = new V3();
        V3 v32 = new V3();
        V3 v33 = new V3();
        int n6 = this.points.length;
        while (--n6 >= 0) {
            if (n6 == this.centerAtomIndex) continue;
            P3 p3 = this.points[n6];
            n5 = this.elements[n6];
            n4 = this.points.length;
            while (--n4 > n6) {
                float f;
                boolean bl;
                P3 p32 = this.points[n4];
                if (this.elements[n4] != n5) continue;
                v3.sub2((T3)p3, (T3)this.center);
                v32.sub2((T3)p32, (T3)this.center);
                v3.normalize();
                v32.normalize();
                if (this.isParallel(v3, v32)) {
                    this.getAllAxes(v3);
                    continue;
                }
                if (this.nAxes[16] < axesMaxN[16]) {
                    v33.ave((T3)p3, (T3)p32);
                    v33.sub((T3)this.center);
                    this.getAllAxes(v33);
                }
                if (!(bl = (f = (float)(Math.PI * 2 / (double)v3.angle(v32))) - (float)(n3 = (int)Math.floor(f + 0.01f)) <= 0.02f) || (n3 += 14) >= maxAxis || this.nAxes[n3] >= axesMaxN[n3]) continue;
                v33.cross(v3, v32);
                this.checkAxisOrder(n3, v33, this.center);
            }
        }
        V3[] v3Array = new V3[this.nAxes[16] * 2];
        for (n2 = 0; n2 < v3Array.length; ++n2) {
            v3Array[n2] = new V3();
        }
        n2 = 0;
        for (n5 = 0; n5 < this.nAxes[16]; ++n5) {
            v3Array[n2++].setT((T3)this.axes[16][n5].normalOrAxis);
            v3Array[n2].setT((T3)this.axes[16][n5].normalOrAxis);
            v3Array[n2++].scale(-1.0f);
        }
        n5 = v3Array.length;
        while (--n5 >= 2) {
            n4 = n5;
            while (--n4 >= 1) {
                int n7 = n4;
                while (--n7 >= 0) {
                    v33.add2((T3)v3Array[n5], (T3)v3Array[n4]);
                    v33.add((T3)v3Array[n7]);
                    if ((double)v33.length() < 1.0) continue;
                    this.checkAxisOrder(17, v33, this.center);
                }
            }
        }
        n5 = Integer.MAX_VALUE;
        n4 = -1;
        for (n = 0; n < this.maxElement; ++n) {
            if (this.eCounts[n] >= n5 || this.eCounts[n] <= 2) continue;
            n5 = this.eCounts[n];
            n4 = n;
        }
        block8: for (n = 0; n < this.points.length - 2; ++n) {
            if (this.elements[n] != n4) continue;
            for (int i = n + 1; i < this.points.length - 1; ++i) {
                if (this.elements[i] != n4) continue;
                for (n3 = i + 1; n3 < this.points.length; ++n3) {
                    if (this.elements[n3] != n4) continue;
                    v3.sub2((T3)this.points[n], (T3)this.points[i]);
                    v32.sub2((T3)this.points[n], (T3)this.points[n3]);
                    v3.normalize();
                    v32.normalize();
                    v33.cross(v3, v32);
                    this.getAllAxes(v33);
                    v3.add2((T3)this.points[n], (T3)this.points[i]);
                    v3.add((T3)this.points[n3]);
                    v3.normalize();
                    if (!this.isParallel(v3, v33)) {
                        this.getAllAxes(v3);
                    }
                    if (this.nAxes[19] == axesMaxN[19]) break block8;
                }
            }
        }
        v3Array = new V3[this.maxElement];
        n = this.points.length;
        while (--n >= 0) {
            int n8 = this.elements[n];
            if (v3Array[n8] == null) {
                v3Array[n8] = new V3();
            } else if (this.haveInversionCenter) continue;
            v3Array[n8].add((T3)this.points[n]);
        }
        if (!this.haveInversionCenter) {
            for (n = 0; n < this.maxElement; ++n) {
                if (v3Array[n] == null) continue;
                v3Array[n].scale(1.0f / (float)this.eCounts[n]);
            }
        }
        for (n = 0; n < this.maxElement; ++n) {
            if (v3Array[n] == null) continue;
            for (int i = 0; i < this.maxElement; ++i) {
                if (n == i || v3Array[i] == null) continue;
                if (this.haveInversionCenter) {
                    v3.cross(v3Array[n], v3Array[i]);
                } else {
                    v3.sub2((T3)v3Array[n], (T3)v3Array[i]);
                }
                this.checkAxisOrder(16, v3, this.center);
            }
        }
        return this.getHighestOrder();
    }

    private void getAllAxes(V3 v3) {
        for (int i = 16; i < maxAxis; ++i) {
            if (this.nAxes[i] >= axesMaxN[i]) continue;
            this.checkAxisOrder(i, v3, this.center);
        }
    }

    private int getHighestOrder() {
        int n = 0;
        n = 14;
        while (--n > 1 && this.nAxes[n] == 0) {
        }
        if (n > 1) {
            return n + 14 < maxAxis && this.nAxes[n + 14] > 0 ? n + 14 : n;
        }
        n = maxAxis;
        while (--n > 1 && this.nAxes[n] == 0) {
        }
        return n;
    }

    private boolean checkAxisOrder(int n, V3 v3, P3 p3) {
        switch (n) {
            case 22: {
                if (this.nAxes[17] > 0) {
                    return false;
                }
            }
            case 18: 
            case 20: {
                if (this.nAxes[19] <= 0) break;
                return false;
            }
            case 17: {
                if (this.nAxes[22] <= 0) break;
                return false;
            }
            case 19: {
                if (this.nAxes[18] <= 0 && this.nAxes[20] <= 0 && this.nAxes[22] <= 0) break;
                return false;
            }
        }
        v3.normalize();
        if (this.haveAxis(n, v3)) {
            return false;
        }
        Quaternion quaternion = Quaternion.newVA((T3)v3, (float)((n < 14 ? 180 : 0) + 360 / (n % 14)));
        if (!this.checkOperation(quaternion, p3, n)) {
            return false;
        }
        this.addAxis(n, v3);
        switch (n) {
            case 16: {
                this.checkAxisOrder(4, v3, p3);
                break;
            }
            case 17: {
                this.checkAxisOrder(3, v3, p3);
                if (!this.haveInversionCenter) break;
                this.addAxis(6, v3);
                break;
            }
            case 18: {
                this.addAxis(16, v3);
                this.checkAxisOrder(4, v3, p3);
                this.checkAxisOrder(8, v3, p3);
                break;
            }
            case 19: {
                this.checkAxisOrder(5, v3, p3);
                if (!this.haveInversionCenter) break;
                this.addAxis(10, v3);
                break;
            }
            case 20: {
                this.addAxis(16, v3);
                this.addAxis(17, v3);
                this.checkAxisOrder(3, v3, p3);
                this.checkAxisOrder(6, v3, p3);
                this.checkAxisOrder(12, v3, p3);
                break;
            }
            case 22: {
                this.addAxis(16, v3);
                this.addAxis(18, v3);
            }
        }
        return true;
    }

    private void addAxis(int n, V3 v3) {
        if (this.haveAxis(n, v3)) {
            return;
        }
        if (this.axes[n] == null) {
            this.axes[n] = new Operation[axesMaxN[n]];
        }
        int n2 = n;
        int n3 = this.nAxes[n2];
        this.nAxes[n2] = n3 + 1;
        this.axes[n][n3] = new Operation(v3, n);
    }

    private boolean haveAxis(int n, V3 v3) {
        if (this.nAxes[n] == axesMaxN[n]) {
            return true;
        }
        if (this.nAxes[n] > 0) {
            int n2 = this.nAxes[n];
            while (--n2 >= 0) {
                if (!this.isParallel(v3, this.axes[n][n2].normalOrAxis)) continue;
                return true;
            }
        }
        return false;
    }

    private int findPlanes() {
        P3 p3 = new P3();
        V3 v3 = new V3();
        V3 v32 = new V3();
        V3 v33 = new V3();
        int n = 0;
        boolean bl = this.getHighestOrder() > 1;
        int n2 = this.points.length;
        while (--n2 >= 0) {
            if (n2 == this.centerAtomIndex) continue;
            P3 p32 = this.points[n2];
            int n3 = this.elements[n2];
            int n4 = this.points.length;
            while (--n4 > n2) {
                if (bl && this.elements[n4] != n3) continue;
                P3 p33 = this.points[n4];
                p3.add2((T3)p32, (T3)p33);
                p3.scale(0.5f);
                v3.sub2((T3)p32, (T3)this.center);
                v32.sub2((T3)p33, (T3)this.center);
                if (!this.isParallel(v3, v32)) {
                    v33.cross(v3, v32);
                    v33.normalize();
                    n = this.getPlane(v33);
                }
                v33.sub2((T3)p33, (T3)p32);
                v33.normalize();
                n = this.getPlane(v33);
                if (n != axesMaxN[0]) continue;
                return n;
            }
        }
        if (bl) {
            for (n2 = 16; n2 < maxAxis; ++n2) {
                for (int i = 0; i < this.nAxes[n2]; ++i) {
                    n = this.getPlane(this.axes[n2][i].normalOrAxis);
                }
            }
        }
        return n;
    }

    private int getPlane(V3 v3) {
        if (!this.haveAxis(0, v3) && this.checkOperation(Quaternion.newVA((T3)v3, (float)180.0f), this.center, -1)) {
            int n = this.nAxes[0];
            this.nAxes[0] = n + 1;
            this.axes[0][n] = new Operation(v3);
        }
        return this.nAxes[0];
    }

    private void findAdditionalAxes(int n) {
        Operation[] operationArray = this.axes[0];
        int n2 = 0;
        if (n > 1 && (n2 = n + 14) < maxAxis && this.nAxes[n2] == 0) {
            this.vTemp.cross(operationArray[0].normalOrAxis, operationArray[1].normalOrAxis);
            if (!this.checkAxisOrder(n2, this.vTemp, this.center) && n > 2) {
                this.vTemp.cross(operationArray[1].normalOrAxis, operationArray[2].normalOrAxis);
                this.checkAxisOrder(n2 - 1, this.vTemp, this.center);
            }
        }
        if (this.nAxes[16] == 0 && n > 2) {
            for (int i = 0; i < n - 1; ++i) {
                for (int j = i + 1; j < n; ++j) {
                    this.vTemp.add2((T3)operationArray[1].normalOrAxis, (T3)operationArray[2].normalOrAxis);
                    this.checkAxisOrder(16, this.vTemp, this.center);
                }
            }
        }
    }

    Object getInfo(int n, boolean bl, boolean bl2, String string, int n2, float f) {
        String string2;
        int n3;
        this.info = bl2 ? new Hashtable() : null;
        V3 v3 = new V3();
        if (f == 0.0f) {
            f = 1.0f;
        }
        this.scale = f;
        int[][] nArray = new int[4][2];
        for (int i = 1; i < maxAxis; ++i) {
            n3 = this.nAxes[i];
            while (--n3 >= 0) {
                int[] nArray2 = nArray[this.axes[i][n3].type];
                nArray2[0] = nArray2[0] + 1;
            }
        }
        SB sB = new SB().append("# ").appendI(this.nAtoms).append(" atoms\n");
        if (bl) {
            Operation operation;
            int n4;
            n3 = string != null && string.length() > 0 ? 1 : 0;
            string = n3 != 0 ? string : "";
            this.drawType = string;
            this.drawIndex = n2;
            boolean bl3 = string.equalsIgnoreCase("Cn");
            boolean bl4 = string.equalsIgnoreCase("Sn");
            sB.append("set perspectivedepth off;\n");
            String string3 = "_" + n + "_";
            if (n3 == 0) {
                sB.append("draw pg0").append(string3).append("* delete;draw pgva").append(string3).append("* delete;draw pgvp").append(string3).append("* delete;");
            }
            if (n3 == 0 || string.equalsIgnoreCase("Ci")) {
                sB.append("draw pg0").append(string3).append(this.haveInversionCenter ? "inv " : " ").append(Escape.eP((T3)this.center)).append(this.haveInversionCenter ? "\"i\";\n" : ";\n");
            }
            float f2 = 0.1f;
            for (n4 = 2; n4 < maxAxis; ++n4) {
                if (n4 == 14) {
                    f2 = 0.1f;
                }
                if (this.nAxes[n4] == 0) continue;
                String string4 = this.axes[n4][0].getLabel();
                float f3 = f * this.radius + (f2 += 0.25f);
                if (n3 != 0 && !string.equalsIgnoreCase(string4) && (!bl3 || n4 < 14) && (!bl4 || n4 >= 14)) continue;
                for (int i = 0; i < this.nAxes[n4]; ++i) {
                    if (n2 > 0 && i + 1 != n2) continue;
                    operation = this.axes[n4][i];
                    v3.add2((T3)operation.normalOrAxis, (T3)this.center);
                    if (operation.type == 2) {
                        f3 = -f3;
                    }
                    sB.append("draw pgva").append(string3).append(string4).append("_").appendI(i + 1).append(" width 0.05 scale ").appendF(f3).append(" ").append(Escape.eP((T3)v3));
                    v3.scaleAdd2(-2.0f, (T3)operation.normalOrAxis, (T3)v3);
                    boolean bl5 = this.principalAxis != null && operation.index == this.principalAxis.index;
                    sB.append(Escape.eP((T3)v3)).append("\"").append(string4).append(bl5 ? "*" : "").append("\" color ").append(bl5 ? "red" : (operation.type == 2 ? "blue" : "yellow")).append(";\n");
                }
            }
            if (n3 == 0 || string.equalsIgnoreCase("Cs")) {
                for (n4 = 0; n4 < this.nAxes[0]; ++n4) {
                    if (n2 > 0 && n4 + 1 != n2) continue;
                    operation = this.axes[0][n4];
                    sB.append("draw pgvp").append(string3).appendI(n4 + 1).append("disk scale ").appendF(f * this.radius * 2.0f).append(" CIRCLE PLANE ").append(Escape.eP((T3)this.center));
                    v3.add2((T3)operation.normalOrAxis, (T3)this.center);
                    sB.append(Escape.eP((T3)v3)).append(" color translucent yellow;\n");
                    v3.add2((T3)operation.normalOrAxis, (T3)this.center);
                    sB.append("draw pgvp").append(string3).appendI(n4 + 1).append("ring width 0.05 scale ").appendF(f * this.radius * 2.0f).append(" arc ").append(Escape.eP((T3)v3));
                    v3.scaleAdd2(-2.0f, (T3)operation.normalOrAxis, (T3)v3);
                    sB.append(Escape.eP((T3)v3));
                    v3.x = (float)((double)v3.x + 0.011);
                    v3.y = (float)((double)v3.y + 0.012);
                    v3.z = (float)((double)v3.z + 0.013);
                    sB.append(Escape.eP((T3)v3)).append("{0 360 0.5} color ").append(this.principalPlane != null && operation.index == this.principalPlane.index ? "red" : "blue").append(";\n");
                }
            }
            sB.append("# name=").append(this.name);
            sB.append(", nCi=").appendI(this.haveInversionCenter ? 1 : 0);
            sB.append(", nCs=").appendI(this.nAxes[0]);
            sB.append(", nCn=").appendI(nArray[1][0]);
            sB.append(", nSn=").appendI(nArray[2][0]);
            sB.append(": ");
            n4 = maxAxis;
            while (--n4 >= 2) {
                if (this.nAxes[n4] <= 0) continue;
                sB.append(" n").append(n4 < 14 ? "S" : "C").appendI(n4 % 14);
                sB.append("=").appendI(this.nAxes[n4]);
            }
            sB.append(";\n");
            this.drawInfo = sB.toString();
            return this.drawInfo;
        }
        n3 = 0;
        int n5 = 1;
        String string5 = string2 = this.haveInversionCenter ? "Ci" : "center";
        if (this.haveInversionCenter) {
            ++n5;
        }
        if (this.info == null) {
            sB.append("\n\n").append(this.name).append("\t").append(string2).append("\t").append(Escape.eP((T3)this.center));
        } else {
            this.info.put(string2, this.center);
        }
        int n6 = maxAxis;
        while (--n6 >= 0) {
            if (this.nAxes[n6] <= 0) continue;
            n3 = nUnique[n6];
            String string6 = this.axes[n6][0].getLabel();
            if (this.info == null) {
                sB.append("\n\n").append(this.name).append("\tn").append(string6).append("\t").appendI(this.nAxes[n6]).append("\t").appendI(n3);
            } else {
                this.info.put("n" + string6, this.nAxes[n6]);
            }
            n5 += (n3 *= this.nAxes[n6]);
            int[] nArray3 = nArray[this.axes[n6][0].type];
            nArray3[1] = nArray3[1] + n3;
            List list = this.info == null ? null : new List();
            for (int i = 0; i < this.nAxes[n6]; ++i) {
                if (list == null) {
                    sB.append("\n").append(this.name).append("\t").append(string6).append("_").appendI(i + 1).append("\t").appendO((Object)this.axes[n6][i].normalOrAxis);
                    continue;
                }
                list.addLast((Object)this.axes[n6][i].normalOrAxis);
            }
            if (this.info == null) continue;
            this.info.put(string6, list);
        }
        if (this.info == null) {
            sB.append("\n");
            sB.append("\n").append(this.name).append("\ttype\tnType\tnUnique");
            sB.append("\n").append(this.name).append("\tE\t  1\t  1");
            n3 = this.haveInversionCenter ? 1 : 0;
            sB.append("\n").append(this.name).append("\tCi\t  ").appendI(n3).append("\t  ").appendI(n3);
            sB.append("\n").append(this.name).append("\tCs\t");
            Txt.rightJustify((SB)sB, (String)"    ", (String)(this.nAxes[0] + "\t"));
            Txt.rightJustify((SB)sB, (String)"    ", (String)(this.nAxes[0] + "\n"));
            sB.append(this.name).append("\tCn\t");
            Txt.rightJustify((SB)sB, (String)"    ", (String)(nArray[1][0] + "\t"));
            Txt.rightJustify((SB)sB, (String)"    ", (String)(nArray[1][1] + "\n"));
            sB.append(this.name).append("\tSn\t");
            Txt.rightJustify((SB)sB, (String)"    ", (String)(nArray[2][0] + "\t"));
            Txt.rightJustify((SB)sB, (String)"    ", (String)(nArray[2][1] + "\n"));
            sB.append(this.name).append("\t\tTOTAL\t");
            Txt.rightJustify((SB)sB, (String)"    ", (String)(n5 + "\n"));
            this.textInfo = sB.toString();
            return this.textInfo;
        }
        this.info.put("name", this.name);
        this.info.put("nAtoms", this.nAtoms);
        this.info.put("nTotal", n5);
        this.info.put("nCi", this.haveInversionCenter ? 1 : 0);
        this.info.put("nCs", this.nAxes[0]);
        this.info.put("nCn", nArray[1][0]);
        this.info.put("nSn", nArray[2][0]);
        this.info.put("distanceTolerance", Float.valueOf(this.distanceTolerance));
        this.info.put("linearTolerance", Float.valueOf(this.linearTolerance));
        this.info.put("detail", sB.toString().replace('\n', ';'));
        if (this.principalAxis != null && this.principalAxis.index > 0) {
            this.info.put("principalAxis", this.principalAxis.normalOrAxis);
        }
        if (this.principalPlane != null && this.principalPlane.index > 0) {
            this.info.put("principalPlane", this.principalPlane.normalOrAxis);
        }
        return this.info;
    }

    boolean isDrawType(String string, int n, float f) {
        return this.drawInfo != null && this.drawType.equals(string == null ? "" : string) && this.drawIndex == n && this.scale == f;
    }

    private class Operation {
        int type;
        int order;
        int index;
        V3 normalOrAxis;

        Operation() {
            this.index = ++PointGroup.this.nOps;
            this.type = 3;
            this.order = 1;
            if (Logger.debugging) {
                Logger.debug((String)("new operation -- " + typeNames[this.type]));
            }
        }

        Operation(V3 v3, int n) {
            this.index = ++PointGroup.this.nOps;
            this.type = n < 14 ? 2 : 1;
            this.order = n % 14;
            this.normalOrAxis = Quaternion.newVA((T3)v3, (float)180.0f).getNormal();
            if (Logger.debugging) {
                Logger.debug((String)("new operation -- " + (this.order == n ? "S" : "C") + this.order + " " + this.normalOrAxis));
            }
        }

        Operation(V3 v3) {
            if (v3 == null) {
                return;
            }
            this.index = ++PointGroup.this.nOps;
            this.type = 0;
            this.normalOrAxis = Quaternion.newVA((T3)v3, (float)180.0f).getNormal();
            if (Logger.debugging) {
                Logger.debug((String)("new operation -- plane " + this.normalOrAxis));
            }
        }

        String getLabel() {
            switch (this.type) {
                case 0: {
                    return "Cs";
                }
                case 2: {
                    return "S" + this.order;
                }
            }
            return "C" + this.order;
        }
    }
}

