#pragma once

#include "Types.h"

class Face {
public:
	// constructor
	Face();

	// one of the halfedges associated with this face
	HalfEdgeIter he;

	// flag to indicate whether this face is incident to the north
	// pole of a stereographic projection from the disk to a sphere
	bool inNorthPoleVicinity;

	// id between 0 and |F|-1
	int index;

	// returns face normal
	Vector normal(bool normalize = true) const;

	// returns face area
	double area() const;

	// returns face normal based on position2
	Vector normal2(bool normalize = true) const;

	// returns face area based on position2
	double area2() const;

	// checks if this face is real
	bool isReal() const;
};

inline Face::Face():
inNorthPoleVicinity(false),
index(-1)
{

}

inline Vector Face::normal(bool normalize) const
{
	if (!isReal()) return Vector();

	const Vector& a = he->vertex->position;
	const Vector& b = he->next->vertex->position;
	const Vector& c = he->prev->vertex->position;

	Vector n = cross(b - a, c - a);
	if (normalize) n.normalize();

	return n;
}

inline Vector Face::normal2(bool normalize) const
{
	if (!isReal()) return Vector();

	const Vector& a = he->vertex->position2;
	const Vector& b = he->next->vertex->position2;
	const Vector& c = he->prev->vertex->position2;

	Vector n = cross(b - a, c - a);
	if (normalize) n.normalize();

	return n;
}

inline double Face::area() const
{
	return 0.5*normal(false).norm();
}

inline double Face::area2() const
{
	return 0.5*normal2(false).norm();
}

inline bool Face::isReal() const
{
	return !he->onBoundary && !inNorthPoleVicinity;
}
