#pragma once

#include <fstream>
#include <sstream>
#include <tuple>

class AdjacencyTable {
public:
	// constructs table
	void construct(int n, const std::vector<int>& indices);

	// returns unique index corresponding to entry (i, j)
	int getIndex(int i, int j) const;

	// returns table size
	int getSize() const;

private:
	// members
	std::vector<std::set<int> > data;
	std::vector<int> iMap;
	int size;
};

class Soup {
public:
        std::vector<Vector> positions;
        std::vector<Vector> positions2;
        std::vector<int> indices;
        AdjacencyTable table; // construct after filling positions and indices
};

void AdjacencyTable::construct(int n, const std::vector<int>& indices)
{
	data.resize(n);
	iMap.resize(n);
	size = 0;

	// build table
	for (int I = 0; I < (int)indices.size(); I += 3) {
		for (int J = 0; J < 3; J++) {
			int K = (J + 1) % 3;
			int i = indices[I + J];
			int j = indices[I + K];

			if (i > j) std::swap(i, j);
			data[i].insert(j);
		}
	}

	// build iMap
	for (int i = 0; i < n; i++) {
		iMap[i] = size;
		size += data[i].size();
	}
}

int AdjacencyTable::getIndex(int i, int j) const
{
	if (i > j) std::swap(i, j);

	int k = 0;
	for (std::set<int>::iterator it = data[i].begin(); it != data[i].end(); it++) {
		if (*it == j) break;
		k++;
	}

	return iMap[i] + k;
}

int AdjacencyTable::getSize() const
{
	return size;
}
