/* ===============================================================================================
 *
 * Links.h
 * 
 * Author: Patrice Koehl
 *
 * Class that contains all the information about a link in the elastic network
 * of interest
 *
 *  =============================================================================================== */

#include <string>

#ifndef _LINKS_H_
#define _LINKS_H_

/* ======================================================================================
 *  LINKS class:
 *  ==================================================================================== */
      
class Links
{
	public:
		int atm1, atm2;
		int ires1, ires2;
		double kconst;
		double rij0;

		Links(int atm1_, int atm2_, int ires1_, int ires2_, double kconst_, 
		double rij0_);
		~Links();
};

/* ======================================================================================
 *  Creator 
 *  ==================================================================================== */
      
Links::Links(int atm1_, int atm2_, int ires1_, int ires2_, double kconst_, double rij0_)
{
	atm1 = atm1_;
	atm2 = atm2_;
	ires1 = ires1_;
	ires2 = ires2_;
	kconst= kconst_;
	rij0  = rij0_;
}

/* ======================================================================================
 *  Destructor
 *  ==================================================================================== */
      
Links::~Links()
{
}

#endif
