/* ===============================================================================================
 *
 * Atoms.h
 * 
 * Author: Patrice Koehl
 *
 * Class that contains all the information about the atoms ("vertices") of the molecule
 * of interest
 *
 *  =============================================================================================== */

#include <string>

#ifndef _ATOMS_H_
#define _ATOMS_H_

/* ===============================================================================================
 *
 *  Atoms class:
 *
 *  PUBLIC OPERATIONS:

	void setXYZ(x,y,z)      	--> Set coordinates X, Y, and Z to x, y, and z, respectively
        void setMass(Firstletter )      --> Set mass M based on first letter of the atom name
        void setUniMass(m )      	--> Set uniform mass M for all atoms
	void setLine(line)		--> Set info based on corresponding line in PDB
	void setBfact(bfact)		--> Set bfactor if present in PDB file
	void setResId(ires)		--> Label atom with residue number
	void setChainId(ichain)		--> Label atom with chain it belongs to
 *
 *  =============================================================================================== */
      
class Atoms
{
	public:
		double coord[3], mass, bfact;
		double U[6];
		int resid, chainid;
		double kconst;
		double k_bond, k_angle, k_dihed;
  		std::string line;

  		void setXYZ(double userX, double userY, double userZ);
  		void setMass(char letter);
  		void setUniMass(double Mass);
  		void setLine(std::string line);
		void setBfact(double bfact);
		void setResId(int ires);
		void setChainId(int ichain);

};

/* ===============================================================================================
   Copy corresponding line from PDB
 *  =============================================================================================== */

void Atoms::setLine(std::string Line)
{
	line = Line;
}

/* ===============================================================================================
   Set Bfactor
 *  =============================================================================================== */

void Atoms::setBfact(double Bfact)
{
	bfact = Bfact;
}

/* ===============================================================================================
   Set Residue ID
 *  =============================================================================================== */

void Atoms::setResId(int ires)
{
	resid = ires;
}

/* ===============================================================================================
   Set Chain ID
 *  =============================================================================================== */

void Atoms::setChainId(int ichain)
{
	chainid = ichain;
}

/* ===============================================================================================
   Set coordinates X, Y, and Z
 *  =============================================================================================== */

void Atoms::setXYZ(double X, double Y, double Z)
{
	coord[0]=X;
	coord[1]=Y;
	coord[2]=Z;
} 

/* ===============================================================================================
   Set Mass based on the first letter of the name of the atom
 *  =============================================================================================== */

void Atoms::setMass(char letter)
{
	switch (letter) {
	case 'N':
		mass = 14.007;
		break;
	case 'C':
		mass = 12.012;
		break;
	case 'O':
		mass = 15.999;
		break;
	case 'H':
		mass = 1.008;
		break;
	case 'P':
		mass = 31.0;
		break;
	case 'S':
		mass = 32.06;
		break;
  	}
}

/* ===============================================================================================
   Set Uniform Mass
 *  =============================================================================================== */

void Atoms::setUniMass(double M)
{
	mass = M;
}

#endif
