/* ========================================================================================
   Definitions for multithreading
   ======================================================================================== */

typedef struct derivs_data {
        int N1;
        int N2;
	double facb;
	int nmode1;
	int nmode2;
	double lambda;
	double lambda_ent;
        double *eigVect;
        double *eigVal;
        double *bfact;
        std::vector<Atoms> atoms;
        std::vector<Links> pairs;
        double *Uij;
        double *Work;
        double *G;
} derivs_data;

derivs_data derivs[NUM_THREADS];

/* ========================================================================================
   Computes derivative of energy on one thread
   ======================================================================================== */

  void* deriv_thread(void* data)
  {
	int threadid = *((int *) data);

	int natoms = derivs[threadid].atoms.size();
	int npairs = derivs[threadid].pairs.size();
	int npar = 3*natoms;
	int N1 = derivs[threadid].N1;
	int N2 = derivs[threadid].N2;
	double *w = &derivs[threadid].Work[0];
	double *r = &derivs[threadid].Work[npar];
	double *t = &derivs[threadid].Work[2*npar];
	double *dDiagHm1 = &derivs[threadid].Work[3*npar];
	double *eigVect = derivs[threadid].eigVect;
	double *eigVal = derivs[threadid].eigVal;
	double *Uij = derivs[threadid].Uij;

	int iat, jat;
	double a, b, sum;
	int inc=1;
	double *u, *e1, *e2;

	for(int k = N1; k < N2; k++) {
		memset(w, 0, npar*sizeof(double));
		memset(r, 0, npar*sizeof(double));
		memset(t, 0, npar*sizeof(double));
		memset(dDiagHm1, 0, npar*sizeof(double));
		u = &Uij[3*k];
		iat = derivs[threadid].pairs[k].atm1;
		jat = derivs[threadid].pairs[k].atm2;

		for(int i = 0; i < derivs[threadid].nmode1; i++) {
			e1 = &eigVect[i*npar + 3*iat];
			e2 = &eigVect[i*npar + 3*jat];
			a = u[0]*(e1[0]-e2[0]) + u[1]*(e1[1]-e2[1]) + u[2]*(e1[2]-e2[2]);
			daxpy_(&npar, &a, &eigVect[i*npar], &inc, t, &inc);
		}

		for(int i = derivs[threadid].nmode1; i < derivs[threadid].nmode2; i++) {
			e1 = &eigVect[i*npar + 3*iat];
			e2 = &eigVect[i*npar + 3*jat];
			a = u[0]*(e1[0]-e2[0]) + u[1]*(e1[1]-e2[1]) + u[2]*(e1[2]-e2[2]);
			a = a/eigVal[i];
			daxpy_(&npar, &a, &eigVect[i*npar], &inc, w, &inc);
			a = a/eigVal[i];
			daxpy_(&npar, &a, &eigVect[i*npar], &inc, r, &inc);
		}

		for(int i = 0; i < npar; i++) {
			if(k==10) {
				std::cout << "i = " << i << " term1 = " << -w[i]*w[i] << " term2 = " << r[i]*t[i] << std::endl;
				std::cout << "r[i] = " << r[i] << " t[i] = " << t[i] << std::endl;
			}
			dDiagHm1[i] = -w[i]*w[i] + 2*r[i]*t[i];
		}

		sum = 0.;
		for(int i = 0; i < natoms; i++)
		{
			a = derivs[threadid].bfact[i] - derivs[threadid].atoms[i].bfact;
			b = derivs[threadid].facb*(dDiagHm1[3*i] + dDiagHm1[3*i+1] + dDiagHm1[3*i+2]);
			sum += a*b;
		}
		derivs[threadid].G[k-N1] = 2*sum*derivs[threadid].lambda;

		sum = 0.;
		for(int i = derivs[threadid].nmode1; i < derivs[threadid].nmode2; i++) {
			e1 = &eigVect[i*npar + 3*iat];
			e2 = &eigVect[i*npar + 3*jat];
			a = u[0]*(e1[0]-e2[0]) + u[1]*(e1[1]-e2[1]) + u[2]*(e1[2]-e2[2]);
			a = (a*a)/eigVal[i];
			sum += a;
		}
		derivs[threadid].G[k-N1] += sum*derivs[threadid].lambda_ent;
	}
	return 0;
  }
