/* ===============================================================================================
   Map2Sphere: Conformal mapping of a genus zero surface represented by a triangular mesh onto
               the sphere.
               Different methods are implemented:
		1) Intrinsic methods:
			1.a: Tutte embedding
			1.b: Yamabe flow (Springborn et al, 2007)
			1.c: Ricci flow
                2) Extrinsic method:
			2.a: conformalized Mean Curvature Flow

   Author:  Patrice Koehl
   Date:    5/10/2019
   Version: 1
   =============================================================================================== */

#ifndef _MAP2SPHERE_H_
#define _MAP2SPHERE_H_

/* ===============================================================================================
   system includes
   =============================================================================================== */

#include <iostream>
#include <iomanip>
#include <sstream>
#include <string>
#include <stdlib.h>
#include <fstream>
#include <cmath>
#include <ctime>
#include <unistd.h>
#include <cstdlib>
#include <limits>

/* ===============================================================================================
   Includes 
   =============================================================================================== */

#include <Eigen/Core>
#include <Eigen/Sparse>
#include <Eigen/CholmodSupport>
#include <Eigen/UmfPackSupport>

#include "MeshIO.h"
#include "MeshGeometry.h"
#include "Tutte.h"
#include "Normalize.h"
#include "Distortion.h"
#include "RicciFlow.h"
#include "RicciFlowIDT.h"
#include "YamabeFlow.h"
#include "YamabeFlowIDT.h"
#include "cMCF.h"
#include "WillmoreFlow.h"
#include "BeltramiFlow.h"
#include "ConformalError.h"

/* ===============================================================================================
   Prototypes
   =============================================================================================== */

static void usage(char** argv);
bool parse_args(int argc, char *argv[], std::string *INfile, std::string *OUTfile, int *type, 
	int *rtype, double *dt);

#endif
