#pragma once

#include "Types.h"

class HalfEdge {
public:
	// constructor
	HalfEdge();

	// next halfegde (in CCW order) associated with this halfedge's face
	HalfEdgeIter next;

	// prev halfegde associated with this halfedge's face
	HalfEdgeIter prev;

	// other halfedge associated with this halfedge's edge
	HalfEdgeIter flip;

	// vertex at the base of this halfedge
	VertexIter vertex;

	// edge associated with this halfedge
	EdgeIter edge;

	// face associated with this halfedge
	FaceIter face;

	// id between 0 and |H|-1
	int index;

	// boolean flag to indicate if halfedge is on the boundary
	bool onBoundary;

	// returns cotan weight associated with this halfedge
	double cotan() const;
};

#include "Vertex.h"

inline HalfEdge::HalfEdge():
index(-1)
{

}

inline double HalfEdge::cotan() const
{
	if (onBoundary) return 0.0;

	const Vector& a = vertex->position;
	const Vector& b = next->vertex->position;
	const Vector& c = prev->vertex->position;

	Vector u = a - c;
	Vector v = b - c;

	return dot(u, v)/cross(u, v).norm();
}
