#pragma once

#include "Mesh.h"

template <typename T>
class VertexData {
public:
	// constructor
	VertexData(const Mesh& mesh);

	// constructor
	VertexData(const Mesh& mesh, const T& initVal);

	// operator[]
	T& operator[](VertexCIter v);
	const T& operator[](VertexCIter v) const;

private:
	// members
	const Mesh& mesh;
	std::vector<T> data;
};

template <typename T>
class EdgeData {
public:
	// constructor
	EdgeData(const Mesh& mesh);

	// constructor
	EdgeData(const Mesh& mesh, const T& initVal);

	// operator[]
	T& operator[](EdgeCIter e);
	const T& operator[](EdgeCIter e) const;

private:
	// members
	const Mesh& mesh;
	std::vector<T> data;
};

template <typename T>
class FaceData {
public:
	// constructor
	FaceData(const Mesh& mesh);

	// constructor
	FaceData(const Mesh& mesh, const T& initVal);

	// operator[]
	T& operator[](FaceCIter f);
	const T& operator[](FaceCIter f) const;

private:
	// members
	const Mesh& mesh;
	std::vector<T> data;
};

template <typename T>
class BoundaryData {
public:
	// constructor
	BoundaryData(const Mesh& mesh);

	// constructor
	BoundaryData(const Mesh& mesh, const T& initVal);

	// operator[]
	T& operator[](BoundaryCIter b);
	const T& operator[](BoundaryCIter b) const;

private:
	// members
	const Mesh& mesh;
	std::vector<T> data;
};

template <typename T>
class HalfEdgeData {
public:
	// constructor
	HalfEdgeData(const Mesh& mesh);

	// constructor
	HalfEdgeData(const Mesh& mesh, const T& initVal);

	// operator[]
	T& operator[](HalfEdgeCIter he);
	const T& operator[](HalfEdgeCIter he) const;

private:
	// members
	const Mesh& mesh;
	std::vector<T> data;
};

template <typename T>
VertexData<T>::VertexData(const Mesh& mesh_):
mesh(mesh_),
data(mesh.vertices.size())
{

}

template <typename T>
VertexData<T>::VertexData(const Mesh& mesh_, const T& initVal):
mesh(mesh_),
data(mesh.vertices.size(), initVal)
{

}

template <typename T>
T& VertexData<T>::operator[](VertexCIter v)
{
	return data[v->index];
}

template <typename T>
const T& VertexData<T>::operator[](VertexCIter v) const
{
	return data[v->index];
}

template <typename T>
EdgeData<T>::EdgeData(const Mesh& mesh_):
mesh(mesh_),
data(mesh.edges.size())
{

}

template <typename T>
EdgeData<T>::EdgeData(const Mesh& mesh_, const T& initVal):
mesh(mesh_),
data(mesh.edges.size(), initVal)
{

}

template <typename T>
T& EdgeData<T>::operator[](EdgeCIter e)
{
	return data[e->index];
}

template <typename T>
const T& EdgeData<T>::operator[](EdgeCIter e) const
{
	return data[e->index];
}

template <typename T>
FaceData<T>::FaceData(const Mesh& mesh_):
mesh(mesh_),
data(mesh.faces.size())
{

}

template <typename T>
FaceData<T>::FaceData(const Mesh& mesh_, const T& initVal):
mesh(mesh_),
data(mesh.faces.size(), initVal)
{

}

template <typename T>
T& FaceData<T>::operator[](FaceCIter f)
{
	return data[f->index];
}

template <typename T>
const T& FaceData<T>::operator[](FaceCIter f) const
{
	return data[f->index];
}

template <typename T>
BoundaryData<T>::BoundaryData(const Mesh& mesh_):
mesh(mesh_),
data(mesh.boundaries.size())
{

}

template <typename T>
BoundaryData<T>::BoundaryData(const Mesh& mesh_, const T& initVal):
mesh(mesh_),
data(mesh.boundaries.size(), initVal)
{

}

template <typename T>
T& BoundaryData<T>::operator[](BoundaryCIter b)
{
	return data[b->index];
}

template <typename T>
const T& BoundaryData<T>::operator[](BoundaryCIter b) const
{
	return data[b->index];
}

template <typename T>
HalfEdgeData<T>::HalfEdgeData(const Mesh& mesh_):
mesh(mesh_),
data(mesh.halfEdges.size())
{

}

template <typename T>
HalfEdgeData<T>::HalfEdgeData(const Mesh& mesh_, const T& initVal):
mesh(mesh_),
data(mesh.halfEdges.size(), initVal)
{

}

template <typename T>
T& HalfEdgeData<T>::operator[](HalfEdgeCIter he)
{
	return data[he->index];
}

template <typename T>
const T& HalfEdgeData<T>::operator[](HalfEdgeCIter he) const
{
	return data[he->index];
}
