/* ===============================================================================================
 *
 * Atoms.h
 * 
 * Author: Patrice Koehl
 *
 * Class that contains all the information about the atoms ("vertices") of the molecule
 * of interest
 *
 *  =============================================================================================== */

#include <string>

#ifndef _ATOMS_H_
#define _ATOMS_H_

/* ===============================================================================================
 *
 *  Atoms class:
 *
 *  =============================================================================================== */
      
template <typename T>
class Atoms
{
	public:
		int index;
		T coord[3], mass, bfact;
		int resid, chainid;
		int endmdl;
		T Radius;
  		std::string line;

		Atoms() {
		}

		Atoms(std::string name, int idx, T x, T y, T z, T radius, T bfact); 
                ~Atoms();

  		void setMass(char letter);
  		void setUniMass(T Mass);

};

/*********************************************************************************
        Constructor: set coordinates to specific components
 *********************************************************************************/

template <typename T>
Atoms<T>::Atoms(std::string name, int idx, T x, T y, T z, T radius, T bfact) {


	this->index = idx;
	this->coord[0] = x;
	this->coord[1] = y;
	this->coord[2] = z;
	this->Radius = radius;
	this->bfact = bfact;
	this->line = name;

  }

/*********************************************************************************
        Destructor
 *********************************************************************************/

template <typename T>
  Atoms<T>::~Atoms() {
  }

/* ===============================================================================================
   Set Mass based on the first letter of the name of the atom
 *  =============================================================================================== */

template <typename T>
void Atoms<T>::setMass(char letter)
{
	switch (letter) {
	case 'N':
		mass = 14.007;
		break;
	case 'C':
		mass = 12.012;
		break;
	case 'O':
		mass = 15.999;
		break;
	case 'H':
		mass = 1.008;
		break;
	case 'P':
		mass = 31.0;
		break;
	case 'S':
		mass = 32.06;
		break;
  	}
}

/* ===============================================================================================
   Set Uniform Mass
 *  =============================================================================================== */

template <typename T>
void Atoms<T>::setUniMass(T M)
{
	mass = M;
}

#endif
