/*********************************************************************************
 *	The Vertex class
 *********************************************************************************/

#ifndef VERTEX_H
#define VERTEX_H

  #include <gmp.h>
  #include <bitset>
  #include <vector>

/*********************************************************************************
  Class that characterizes each vertex of the Delaunay/Alpha complex
 *********************************************************************************/

  class Vertex {
	public:
		double Radius;
		double Coordinates[3];
		double Weight;

		std::bitset<8> info;
		bool status;

		Vertex() {
		}

		Vertex(double x, double y, double z, double radius);
		~Vertex();

	private:
  };


/*********************************************************************************
        Constructor: set coordinates to specific components
 *********************************************************************************/

Vertex::Vertex(double x, double y, double z, double radius) {

	this->Coordinates[0] = x;
	this->Coordinates[1] = y;
	this->Coordinates[2] = z;
	this->Radius = radius;

	std::bitset<8> b(std::string("00000000"));
	this->info = b;
	this->info[1] = 1;

	this->Weight = x*x + y*y + z*z -radius*radius;

  }

/*********************************************************************************
        Destructor
 *********************************************************************************/

  Vertex::~Vertex() {
  }

#endif // VERTEX_H
