/* ===============================================================================================
   Read from CIF file for each atom selected:
	- coordinates x,y, and z
	- Assign radius, ASP based on standard geometry, using OPLS
   =============================================================================================== */

  template <typename T>
  void readFromCIF(std::string fileName, int flag, int flag_mass, std::vector<Atoms<T> >& atoms, int *nchains)
  {
	std::string line;

  	std::ifstream inFile;
	inFile.open(fileName);

	std::string name;
	T x, y, z;
	T r, b;
	T M = 1;
	int index=0;
	std::string curr_chain = "x";
	std::string chain;
	int nchain = -1;
	std::string curr_res = "     ";
	std::string res;
	int nres = -1;

	std::string coord;
	std::string resname, atmname;
	std::string satom, satn, stype, spoint, schain, s1, sresnum, s2, sx, sy, sz, so, sb;

	std::string l = "                              ";
	
	std::cout << "in CIF file..." << fileName << std::endl;
	while (getline(inFile, line)) // until reach the end of file 
	{
		std::cout << line << std::endl;
		if (line.substr(0,5) == "ATOM ") // only read lines with ATOM at position 0
		{
			std::cout << line << std::endl;
			if(line.substr(21,1)==" ") line[21] = 'A';
			std::istringstream iss(line);
			iss >> satom;
			iss >> satn;
			iss >> stype;
			iss >> atmname;
			iss >> spoint;
			iss >> resname;
			iss >> schain;
			iss >> s1;
			iss >>sresnum;
			iss >> s2;
			iss >> sx;
			iss >> sy;
			iss >> sz;
			iss >> so;
			iss >> sb;
			name = l;
			name.replace(21,1,schain.substr(0,1));
			name.replace(22,4,sresnum.substr(0,4));
			int i = atmname.length();
			if(i==1) {
				name.replace(13,1,atmname.substr(0,1));
				atmname += "   ";
			} else if(i==2) {
				name.replace(13,2,atmname.substr(0,2));
				atmname += "  ";
			} else if(i==3) {
				name.replace(13,3,atmname.substr(0,3));
				atmname += " ";
			}
			i = resname.length();
			if(i==1) {
				name.replace(17,1,resname.substr(0,1));
				resname += "   ";
			} else if(i==2) {
				name.replace(17,2,resname.substr(0,2));
				resname += "  ";
			} else if(i==3) {
				name.replace(17,3,resname.substr(0,3));
				resname += " ";
			}
			x = std::stof(sx);
			y = std::stof(sy);
			z = std::stof(sz);
			b = std::stof(sb);

			if(schain != curr_chain) {
				nchain++;
				curr_chain = schain;
			}
			if(resname != curr_res) {
				nres++;
				curr_res = resname;
			}
			if(flag == 1) {
				setRadius(resname, atmname, &r);
				if(r<0.1) {
					setRadiusBasic(atmname, &r);
				}
				Atoms<T> atm(name, index, x, y, z, r, b);
				atm.endmdl = 0;
				if(flag_mass == 0) {
					atm.setUniMass(M);
				} else {
					atm.setMass(atmname[0]);
				}
				atm.chainid = nchain;
				atm.resid = nres;
				atoms.push_back(atm);
				index++;
			}
			else {
				if(atmname.find("CA")!= std::string::npos) {
					setRadius(resname, atmname, &r);
					Atoms<T> atm(name, index, x, y, z, r, b);
					atm.endmdl = 0;
					if(flag_mass == 0) {
						atm.setUniMass(M);
					} else {
						atm.setMass(atmname[0]);
					}
					atm.chainid = nchain;
					atm.resid = nres;
					atoms.push_back(atm);
					index++;
				}
			}
		}
		else if (line.substr(0,6) == "ENDMDL")
		{
			atoms.back().endmdl=1;
		}
	}

	*nchains = nchain + 1;
	inFile.close();

  }
