#ifndef _EIGINFO_H_
#define _EIGINFO_H_

#include <time.h>        /* clock_t */

/*==========================================================================
   The data structure to store the current information about
   the eigenvalue problem and the progress of the eigensolver
 ==========================================================================*/

template <typename T>
struct eig_info {

/*==========================================================================
    	method for computing eigenvalues / eigenvectors:
	(ED: explicit deflation; caED: explicit deflation, communication avoiding)
		0: Chebishev Thick restart Lanczos
		1: Chebishev Thick restart Lanczos with ED
		2: Chebishev Thick restart Lanczos with caED
 ==========================================================================*/

	int method;

/*==========================================================================
    	Size of the problem (i.e. nrow / ncol of the matrix)
 ==========================================================================*/

	int n;

/*==========================================================================
    	Total number of eigenpairs wanted. 
 ==========================================================================*/

	int nev;

/*==========================================================================
    	Number of eigenpairs wanted in each ED cycle
 ==========================================================================*/

	int nev_d;

/*==========================================================================
    	Number of deflation cycles. 
 ==========================================================================*/

	int ned;
	int current_slice;

/*==========================================================================
	Convergence tolerance.  An eigenpair is declared converged if its
	residual norm is less than tol*||OP||. 

	orthogonalization tolerance: orthTol

	epsilon tolerance for a eigenvalue to be in the target interval
 ==========================================================================*/

	T tol;
	T orthTol;
	T epsilon;

/*==========================================================================
	The size of the active space used. 
 ==========================================================================*/

	int act_max;

/*==========================================================================
	The block size considered.
 ==========================================================================*/

	int block;

/*==========================================================================
	flag_start: if 0, fresh (re)start and initial vector random
	      if 1, hot restart and uses vectors provided as input
	      in eigVect[:, 1:Nblock]

	flag_zero: 
 ==========================================================================*/

	int flag_start;
	int flag_zero;

/*==========================================================================
	flag: if 1, (re) define the Chebyshev filter
	      if 0, keep "old" filter
 ==========================================================================*/

	int set_filter;

/*==========================================================================
	some information about the progress and resouce comsumption  
	The number of MATVEC used by TRLAN.
 ==========================================================================*/

	int mvp;

/*==========================================================================
	The number of full orthogonalization invoked.
 ==========================================================================*/

	int north;

/*==========================================================================
	How much information is printed while chebDav runs
 ==========================================================================*/

	int verbose;

/*==========================================================================
 	variables to store timing results and numbers of iterations

	Assumes that system clock is available
 ==========================================================================*/

	/** Total time spent in TRLAN (in clock ticks)      */
	clock_t clk_tot;
	/** Time in applying the operator (MATVEC)          */
	clock_t clk_op;
	/** Time in re-orthogonalization                    */
	clock_t clk_orth;

	double walltime;
	int niter;
	int itmax;

/*==========================================================================
 	Norm of the operator used.  This is an estimate based on the
        largest absolute value of a Rayleigh quotient.
 ==========================================================================*/

	T anrm;
	T sigma;
	T sigmaC;

/*==========================================================================
 	Type of Chebishev filtering Y = p(A) X:
		0:	unfiltered, i.e. Y = A X
		1:	shifted, scaled filtering that dampens on an interval [a, b]
		2:	shifted, scaled filtering that dampens on an interval [a, b],
			communication avoiding (CA) version
		3:	polynomial expansion that highlights an interval [a, b]
		4:	polynomial expansion that highlights an interval [a, b]
			communication avoiding (CA) version
 ==========================================================================*/

	int filter_type;
	int nolock;

/*==========================================================================
	This parameter is only used by the matrix-vector multiplication op
 ==========================================================================*/

	void* mvparams;

/*==========================================================================
	Number of threads available
 ==========================================================================*/

	int nthreads;

/*==========================================================================
	Information about Chebyshev filtering
 ==========================================================================*/

	int mpoly; // order of polynomial
	T lmin;
	T lmax;
	T a;
	T b;
	T a0;
	T bar;
	T *mu;

/*==========================================================================
	Information about deflation
 ==========================================================================*/

	std::vector<T> slices;

/*==========================================================================
	space for dsyev for GPU
 ==========================================================================*/

	int bufferSize;

};

#endif
