template <typename T>
void transferCSR2GPU(hessianMat<T> *csrMat, hessianMat<T> *csrMat_GPU)
{
        int nnz   = csrMat->nnz;
	int nrows = csrMat->nrows;
	int N     = nrows;

        csrMat_GPU->nnz = nnz;
        csrMat_GPU->nrows = nrows;
        csrMat_GPU->ncols = csrMat->ncols;

	cudaMalloc((void **)&csrMat_GPU->ia, (N+1)*sizeof(int));
	cudaMalloc((void **)&csrMat_GPU->ja, nnz*sizeof(int));
	cudaMalloc((void **)&csrMat_GPU->val, 3*nnz*sizeof(T));

	cudaMemcpy(csrMat_GPU->ia, csrMat->ia, (N+1)*sizeof(int), cudaMemcpyHostToDevice);
	cudaMemcpy(csrMat_GPU->ja, csrMat->ja, nnz*sizeof(int), cudaMemcpyHostToDevice);
	cudaMemcpy(csrMat_GPU->val, csrMat->val, 3*nnz*sizeof(T), cudaMemcpyHostToDevice);

}
