/*================================================================================================
  Network_thread_tools.h
  Version 1: 9/29/2019

  Purpose: Computes number of points within a given cutoff, using a grid approach

Copyright (c) Patrice Koehl.

================================================================================================== */

#ifndef _NETWORK_THREAD_TOOLS_
#define _NETWORK_THREAD_TOOLS_

/*================================================================================================
 Includes
================================================================================================== */

#include <cmath>
#include <cstdlib>
#include <algorithm>
#include <pthread.h>
#include "Atoms.h"

/*================================================================================================
 Compares links
================================================================================================== */

template <typename T>
bool sortEdges(const Edges<T> &a, 
              const Edges<T> &b) 
{ 
	if(a.atm1 < b.atm1) {
		return true;
	} else if (a.atm1 > b.atm1) {
		return false;
	} else {
		return (a.atm2 < b.atm2);
	}
} 

/*================================================================================================
 Computes the distance (squared) between two atoms
================================================================================================== */

template <typename T>
T distancesq(std::vector<Atoms<T> >& atoms, int i, int j)
{
	T d;
	T dx,dy,dz;

	dx = atoms[i].coord[0] - atoms[j].coord[0];
	dy = atoms[i].coord[1] - atoms[j].coord[1];
	dz = atoms[i].coord[2] - atoms[j].coord[2];

	d = dx*dx + dy*dy + dz*dz;

	return d;
}
/*================================================================================================
  Procedure that finds the neighbours of a cell in a grid
  ================================================================================================*/

void Neighbours(int Ic, int Nx, int Ny, int Nz, int *n_neighbours, int *list_neighbours)
{
        *n_neighbours = 0;
	int Nc = Nx * Ny * Nz;
	int icell;

        for(int ival = 1; ival < 3; ival++) 
	{
		icell = Ic + ival;
		if(icell >= 0 && icell < Nc) {
                	list_neighbours[*n_neighbours] = icell;
                	*n_neighbours = *n_neighbours + 1;
		}
        }

	int offset = 0;
        for(int jval = 1; jval < 3; jval++) 
	{
		offset = offset + Nx;
                for(int ival = -2; ival < 3; ival++)
                {
			icell = Ic + offset + ival;
			if(icell >= 0 && icell < Nc) {
                        	list_neighbours[*n_neighbours] = icell;
                        	*n_neighbours = *n_neighbours + 1;
			}
                }
        }

	int offsetz = 0;
        for(int kval = 1; kval < 3; kval++)
	{
		offsetz = offsetz + Nx*Ny;
		offset = -3*Nx;
                for(int jval = -2; jval < 3; jval++)
                {
			offset = offset + Nx;
                        for(int ival = -2; ival < 3; ival++)
                        {
				icell = Ic + offsetz + offset + ival;
				if(icell >= 0 && icell < Nc) {
                                	list_neighbours[*n_neighbours] = icell;
                                	*n_neighbours = *n_neighbours + 1;
				}
                        }
                }
        }
}

/*================================================================================================
 Define neighbor list, using a multi-threaded algorithm:
================================================================================================== */

template <typename T>
void* neighbours_thread(void* data)
{
	int threadid = *((int *) data);

	int EMPTY = -1;
	int i, j, Icell, Jcell;
	int i1,j1;
	int N;
	int List[100];
	T dist;

	int Nx = grids[threadid].Nx;
	int Ny = grids[threadid].Ny;
	int Nz = grids[threadid].Nz;

	T cut2 = grids[threadid].cutoff2;
	int mindiff = grids[threadid].mindiff;

	for (int c = grids[threadid].firstcell; c < grids[threadid].lastcell; c++) {
		Icell = grids[threadid].Cells[c];
		i = grids[threadid].Head[Icell];
		while ( i != EMPTY) {
			j = grids[threadid].Head[Icell];
			while ( j != EMPTY) {
				if ((i < j) && ((grids[threadid].atoms[i].chainid != grids[threadid].atoms[j].chainid) || (std::abs(grids[threadid].atoms[i].resid-grids[threadid].atoms[j].resid) >= mindiff))) {
					dist = distancesq(grids[threadid].atoms, i, j);
					if(dist < cut2) {
						Edges<T> l(i, j);
						grids[threadid].Contacts.push_back(l);
					}
				}
				j = grids[threadid].ListCell[j];
			}
			Neighbours(Icell, Nx, Ny, Nz, &N, List);
			for(int k = 0; k < N; k++) {
				Jcell = List[k];
				j = grids[threadid].Head[Jcell];
				while ( j != EMPTY) {
				     if ((grids[threadid].atoms[i].chainid != grids[threadid].atoms[j].chainid) || (std::abs(grids[threadid].atoms[i].resid-grids[threadid].atoms[j].resid) >= mindiff)) {
					dist = distancesq(grids[threadid].atoms, i, j);
					if(dist < cut2) {
						i1 = std::min(i,j);
						j1 = std::max(i,j);
						Edges<T> l(i1, j1);
						grids[threadid].Contacts.push_back(l);
					}
				     }
				     j = grids[threadid].ListCell[j];
				}
			}
			i = grids[threadid].ListCell[i];
		}
	}
	std::sort(grids[threadid].Contacts.begin(),grids[threadid].Contacts.end(), sortEdges<T>);
	return 0;

}

#endif
