
/*================================================================================================
 Hessian-vect: bond contribution
================================================================================================== */

	int iatm2, iatm1, iat0, iat1, iat2;
	int natoms = m;

	iat0 = atom-1; iat1 = atom; iat2 = atom+1;
	if(atom > 0) {
		for(int k = 0; k < 3; k++) {
			vi[k]   = bonds[3*iat0+k];
			vi[k+3] = -vi[k];
			Xi[k]   = X[col*M+3*iat0+k];
			Xi[k+3] = X[col*M+3*iat1+k];
		}
		val = 0.0;
		for(int k = 0; k < 6; k++) val += Xi[k]*vi[k];
		for(int k = 0; k < 3; k++) Y[col*M+3*iat1+k] += val*vi[k+3];
	}
	if(atom < natoms-1) {
		for(int k = 0; k < 3; k++) {
			vi[k]   = bonds[3*iat1+k];
			vi[k+3] = -vi[k];
			Xi[k]   = X[col*M+3*iat1+k];
			Xi[k+3] = X[col*M+3*iat2+k];
		}
		val = 0.0;
		for(int k = 0; k < 6; k++) val += Xi[k]*vi[k];
		for(int k = 0; k < 3; k++) Y[col*M+3*iat1+k] += val*vi[k];
	}

/*================================================================================================
 Hessian-vect: angle contribution
================================================================================================== */

	iatm1 = atom-2; iat0 = atom-1; iat1 = atom; iat2 = atom+1;
	if(atom > 1) {
		for(int k = 0; k < 9; k++) {
			vi[k]   = angles[9*iatm1+k];
			Xi[k]   = X[col*M+3*iatm1+k];
		}
		val = 0.0;
		for(int k = 0; k < 9; k++) val += Xi[k]*vi[k];
		for(int k = 0; k < 3; k++) Y[col*M+3*iat1+k] += val*vi[k+6];
	}
	if(atom>0 && atom < natoms-1) {
		for(int k = 0; k < 9; k++) {
			vi[k]   = angles[9*iat0+k];
			Xi[k]   = X[col*M+3*iat0+k];
		}
		val = 0.0;
		for(int k = 0; k < 9; k++) val += Xi[k]*vi[k];
		for(int k = 0; k < 3; k++) Y[col*M+3*iat1+k] += val*vi[k+3];
	}
	if(atom < natoms-2) {
		for(int k = 0; k < 9; k++) {
			vi[k]   = angles[9*iat1+k];
			Xi[k]   = X[col*M+3*iat1+k];
		}
		val = 0.0;
		for(int k = 0; k < 9; k++) val += Xi[k]*vi[k];
		for(int k = 0; k < 3; k++) Y[col*M+3*iat1+k] += val*vi[k];
	}

/*================================================================================================
 Hessian-vect: dihedral angle contribution
================================================================================================== */

	iatm2 = atom -3; iatm1 = atom - 2; iat0 = atom - 1; iat1 = atom;

	if(atom > 2) {
		for(int k = 0; k < 12; k++) {
			vi[k]   = diheds[12*iatm2+k];
			Xi[k]   = X[col*M+3*iatm2+k];
		}

		val = 0;
		for(int k = 0; k < 12; k++) val += vi[k]*Xi[k];
		for(int k = 0; k < 3; k++) Y[col*M+3*iat1+k] += val*vi[k+9];
	}

	if(atom > 1 && atom < natoms-1) {
		for(int k = 0; k < 12; k++) {
			vi[k]   = diheds[12*iatm1+k];
			Xi[k]   = X[col*M+3*iatm1+k];
		}

		val = 0;
		for(int k = 0; k < 12; k++) val += vi[k]*Xi[k];
		for(int k = 0; k < 3; k++) Y[col*M+3*iat1+k] += val*vi[k+6];
	}

	if(atom > 0 && atom < natoms - 2) {
		for(int k = 0; k < 12; k++) {
			vi[k]   = diheds[12*iat0+k];
			Xi[k]   = X[col*M+3*iat0+k];
		}

		val = 0;
		for(int k = 0; k < 12; k++) val += vi[k]*Xi[k];
		for(int k = 0; k < 3; k++) Y[col*M+3*iat1+k] += val*vi[k+3];
	}

	if(atom < natoms - 3) {
		for(int k = 0; k < 12; k++) {
			vi[k]   = diheds[12*iat1+k];
			Xi[k]   = X[col*M+3*iat1+k];
		}

		val = 0;
		for(int k = 0; k < 12; k++) val += vi[k]*Xi[k];
		for(int k = 0; k < 3; k++) Y[col*M+3*iat1+k] += val*vi[k];
	}

	return 0;

}
