/*================================================================================================

  ProteinNM.h

================================================================================================== */

#ifndef _EIGENP_H_
#define _EIGENP_H_

/*================================================================================================
  Global includes
================================================================================================== */

  #include <iostream>
  #include <iomanip>
  #include <fstream>
  #include <string>
  #include <math.h>
  #include <cstdlib>
  #include <unistd.h>
  #include <vector>
  #include <algorithm>
  #include <string.h>
  #include <cstring>
  #include <cmath>
  #include <float.h>
  #include <sys/time.h>

#if defined(GPU)
  #include <cublas_v2.h>
  #include <cusparse.h>
  #include <curand.h>
  #include <cusolverDn.h>
#endif

/*================================================================================================
  Define precision based on Makefile flag
================================================================================================== */

#if defined(DOUBLE)
typedef double T;
#else
typedef float T;
#endif

/*================================================================================================
  Define maximum number of threads
================================================================================================== */

 #define NUM_THREADS 64
 pthread_t threads[NUM_THREADS];
 int threadids[NUM_THREADS];

/*================================================================================================
 Definitions for GPU
================================================================================================== */

#if defined(GPU)
  #define THREADS_PER_BLOCK 1024
  #define BlockDim 1024

  curandGenerator_t gen;
  cublasHandle_t handle;
  cusolverDnHandle_t cusolverH;
#endif

/*================================================================================================
  Matrix structures
================================================================================================== */

  #include "Atoms.h"
  #include "Edges.h"

  #include "Struct.h"

#if !defined(GPU)
  threads_params<T> thparams[NUM_THREADS];
  threads_mat<T> thmat[NUM_THREADS];
#endif

grid_data<T> grids[NUM_THREADS];

/*================================================================================================
  Eigenvalue info structure
================================================================================================== */

  #include "eig_info.h"

/*================================================================================================
  Local includes
================================================================================================== */

  #include "BlasWrapper.h"

#if defined(GPU)
  #include "Kernels.h"
#endif

  #include "ReadInput.h"
  ReadInput<T> readinput;

  #include "Network.h"
  #include "filterNet.h"
  #include "rcm.h"
  #include "Hessian.h"

  Network<T> net;
  Hessian<T> hess;
  RCM<T> rcm;
  filterNet<T> filterR;

  #include "MatVect.h"

  #include "Init.h"
  INIT<T> core;

  #include "Filter.h"
  FILTER<T> filter;
  #include "setFilter.h"
  SETFILTER<T> setfilter;

  #include "chebDav.h"
  CHEBDAV<T> dav;
  #include "chebDavED.h"
  CHEBDAVED<T> davED;

  #include "WriteResults.h"
  WriteResults<T> wres;

  #include "Analysis.h"
  Analysis<T> anal;

/*================================================================================================
  Prototypes
================================================================================================== */

  static void usage(char** argv);
  void read_flags(int argc, char** argv, std::string *fileIN, std::string *fileOUT, std::string *fileIN2,
	int *atom_type, int *ene_type, int *enm_type, T *cutoff, T *kconst, int *filter, int *order,
	int *nev, int *nd, int *method, int *maxlan, int *mpoly, int *nblocks, int *nthreads);

#endif
