/*================================================================================================
  structures
================================================================================================== */

template <typename T>
struct grid_data {
        int firstcell;
        int lastcell;
        int Nx;
        int Ny;
        int Nz;
        T cutoff2;
        int mindiff;
        int *Cells;
        int *ListCell;
        int *Head;
        std::vector<Atoms<T> > atoms;
        std::vector <Edges<T> > Contacts;
};

template <typename T>
struct hessianMat {
	int type;
	int nrows,
	    ncols,
	    nnz,
	    *ia,
	    *ja;
	T *val;
	T *bonds,
	  *angles,
	  *diheds;
};

template <typename T>
struct opparams {
#if defined(GPU)
	T *d_sigma;
	T *d_sigma2;
#endif
	hessianMat<T> *csrHessian;
	T *Ud;
	T *eigVal;
	T *sigma;
	T *sigma2;
	T *space;
	int need;
	int nthreads;
};

#if !defined(GPU)
template <typename T>
struct threads_params {
	int *ia;
	int *ja;
	T *val;
	int N,
	    Nvec;
	int start,
	    end;
	int Ncoord;
	T *bonds;
	T *angles;
	T *diheds;
	T *X;
	T *Y;
};

template <typename T>
struct threads_mat {
	int N, M;
	int start, end;
	T *A;
	int lda;
	T *B;
	int ldb;
	T *row;
};


#endif
