#ifndef GL_WIDGET_H
#define GL_WIDGET_H

#include "GLArrayBuffer.h"
#include "GLShaderProgram.h"
#include "GLTexture.h"
#include "GLVertexArray.h"
#include "Mat.h"
#include "Vec.h"
#include <QApplication>
#include <QDir>
#include <QFileDialog>
#include <QGLWidget>
#include <QMenu>
#include <QMenuBar>
#include <QMouseEvent>
#include <QGLWidget>

class GLWidget : public QGLWidget
{
    Q_OBJECT

public:
    GLWidget(const QGLFormat &format = QGLFormat::defaultFormat(), QWidget *parent = 0);

protected:
    virtual void initializeGL();
    virtual void resizeGL(int w, int h);
    virtual void paintGL();
    virtual void mouseMoveEvent(QMouseEvent *event);
    virtual void mousePressEvent(QMouseEvent *event);
    virtual void mouseReleaseEvent(QMouseEvent *event);
    virtual void wheelEvent(QWheelEvent *event);

protected:
    QPointF mousePos;
    Mat3f rotation;
    Vec3f translation;
    Mat4f modelViewMatrix;
    Mat4f projectionMatrix;

    Vec3i volumeDim;
    GLTexture::Ptr volumeTex;
    GLTexture::Ptr transferFuncTex;
    GLArrayBuffer::Ptr rectVertexBuffer;
    GLArrayBuffer::Ptr rectIndexBuffer;
    GLVertexArray::Ptr rectVertexArray;
    GLShaderProgram::Ptr volumeRayCastingProgram;
};

#endif // GLWIDGET_H
