#ifndef MATH_UTIL_H
#define MATH_UTIL_H

#include <limits>

//#define 	M_E   2.7182818284590452354
//#define 	M_LOG2E   1.4426950408889634074	/* log_2 e */
//#define 	M_LOG10E   0.43429448190325182765	/* log_10 e */
//#define 	M_LN2   0.69314718055994530942	/* log_e 2 */
//#define 	M_LN10   2.30258509299404568402	/* log_e 10 */
//#define 	M_PI   3.14159265358979323846	/* pi */
//#define 	M_PI_2   1.57079632679489661923	/* pi/2 */
//#define 	M_PI_4   0.78539816339744830962	/* pi/4 */
//#define 	M_1_PI   0.31830988618379067154	/* 1/pi */
//#define 	M_2_PI   0.63661977236758134308	/* 2/pi */
//#define 	M_2_SQRTPI   1.12837916709551257390	/* 2/sqrt(pi) */
//#define 	M_SQRT2   1.41421356237309504880	/* sqrt(2) */
//#define 	M_SQRT1_2   0.70710678118654752440	/* 1/sqrt(2) */

class Math
{
public:
    template<typename T>
    static T eps()
    {
        return std::numeric_limits<T>::epsilon();
    }

    template<typename T>
    static T inf()
    {
        return std::numeric_limits<T>::infinity();
    }

    template<typename T>
    static T nan(bool quiet = false)
    {
        if(quiet)
            return std::numeric_limits<T>::quiet_NaN();
        else
            return std::numeric_limits<T>::signaling_NaN();
    }

    template<typename T>
    static T pi()
    {
        return T(3.14159265358979323846);
    }

    template<typename T>
    static T pi_2()
    {
        return T(1.57079632679489661923);
    }

    template<typename T>
    static T pi_4()
    {
        return T(0.78539816339744830962);
    }
};

#endif // MATH_H
