\name{BDGraphs-package}
\alias{BDGraphs-package}
\alias{BDGraphs}
\docType{package}

\title{
Novel graphical methods for large data sets.
}

\description{

Graphics package for data sets large enough to suffer from the "black
screen" problem, i.e. heavy overplotting.  Includes a method for
comparing boundary curves, and a new approach to parallel coordinates
plots.  Parallel computation is used throughout.

}

\details{
\tabular{ll}{
Package: \tab BDGraphs\cr
Type: \tab Package\cr
Version: \tab 0.2.0\cr
Date: \tab 2013-09-09\cr
License: \tab GPL (>= 2)\cr
}

List of functions:

   \preformatted{
   descriptive graphical methods:

      boundary():  draws boundary curves
      freqparcoord():  parallel coordinates plotting
      ratioest():  plots ratios of regression function values
      resdisp():  regression residual analysis

   smoothing:  

      smoothz():  does nearest-neighbor smoothing for regression or density
                  estimation
      knnreg():  called by smoothz() for regression case
      knndens():  called by smoothz() for density case
      smoothzpred():  predict new data from training set, previously smoothed
      shmcls():  create a Snow cluster for parallel computing

   utilities:

      findtop():  for input z, idxs and m, finds the indices within z[idxs] 
                  of the elements that have the m highest values; indices 
                  are respect to z overall, not respect to z[idxs]
      shmcls():  create a Snow cluster for parallel computing

   }

}

\author{
Norm Matloff <matloff@cs.ucdavis.edu>
}

\keyword{
big data
visualization
parallel computation
}

\seealso{
   \code{\link{freqparcoord}}
   \code{\link{boundary}}
   \code{\link{smoothz}}
}

\examples{
}


