\name{lock}
\alias{lock}
\alias{unlock}
\title{lock}

\description{Client-side code.  Classical lock function.}

\usage{
lock(lockvar)
unlock(lockvar)
}

\arguments{
\item{lockvar}{lock variable.}
}

\details{When a client calls \code{lock} on \code{lockvar}, Rdsm will
check whether \code{lockvar} is locked.  Internally, this condition is
equivalent to whether a queue exists for this variable.  The client
currently using this lock, if any, is at the head of the queue.  If the
lock is unlocked, Rdsm will lock it, and \code{lock} will immediately
return.  If on the other hand the variable is locked, this client will
join the queue for the lock, and its call to \code{lock} will block.

When a client calls \code{unlock}, the call will immediately return.
Rdsm will then remove that client from the queue, and will check whether
the queue for the lock is still nonempty.  If so, then the call to
\code{lock} made previously by the new head of the queue will now
return.
}

% \seealso{
%     \code{\link[srvrloop]{srvrloop}}
% }

\author{Norm Matloff}

% \examples{
% }

% \keyword{utilities}
}
