\name{srvrinit}
\alias{srvrinit}
\title{srvrinit}

\description{Server-side code.  Activates the Rdsm server.}  

\usage{
srvrloop() 
}

\arguments{
None.
}

\details{Should be run each time an Rdsm application function is to be
run.  The pattern is different for the two run modes:

\itemize{

   \item In MPI mode, working at the server, one uses
   \code{mpi.bcast.cmd} to execute one's application function at the
   clients, then runs \code{srvrloop} to have the server process the
   resulting requests from the clients.  

   \item In socket mode, the order is reversed.  First, at the server
   one calls \code{srvrloop}.  Then, at each client one calls one's
   application function }

In each mode, the process can be repeated through multiple runs.
Application-program global variables etc. will be retained from one run
to the next.

}

% \seealso{
%    \code{\link[init]{init}}
% }

\examples{
\dontrun{
# for MPI mode
mpi.bcast.cmd(test1())
srvrloop()
# test2() will make use of variables created by test1()
mpi.bcast.cmd(test2())
srvrloop()
}
}

\author{Norm Matloff}

% \keyword{utilities}
}
