\name{getmatrix}
\alias{getmatrix}

\title{
Referencing a matrix via different forms.
}

\description{
Returns a matrix, whether requested in R matrix, \code{bigmemory}
object, \code{bigmemory} descriptor or quoted name form.
}

\usage{
getmatrix(m)
}

\arguments{
  \item{m}{
  Specification of the matrix, as either an R matrix, \code{bigmemory} 
  object, \code{bigmemory} descriptor or quoted name.
  }
}

\details{

}

\value{
The requested matrix.
}

\examples{
c2 <- makeCluster(2)
mgrmakevar(c2,"u",2,2)  # u is a 2x2 bigmemory matrix
u[] <- 8  # fill u with 8s
u[]  # prints a 2x2 matrix of 8s
v <- getmatrix(u)  # get u and assign it to v
v[]  # v is now a 2x2 bigmemory matrix, another name for u
v[2,1] <- 3
u[]  # yep, u changed too
w <- getmatrix("u")  # w will also be a copy of u
w[]  # same as u
}

\author{
Norm Matloff
}

