;;;;;;;;;;;;;;;;;;;;;;;;; factorial in Mac-1 ;;;;;;;;;;;;;;;;;;;;;;;;; 
;                                          mgk
;
arg         EQU 4		; factorial( 3 )
fact        EQU 100	        ; address of factorial( 3 )
part        EQU 101		; address of partial results
count       EQU 102		; address of loop counter
decr   	    EQU 103		; address of 1, amount decremented
top 	    EQU 104		; stack offset
zero 	    EQU 0               ; value of zero  (not a variable)
one 	    EQU 1               ; value of one (not a variable)
;
	loco  zero              ; initialize
	stod  part              ; part = 0;
	loco  one
	stod  decr              ; decr = 1;
;;;;; store initial argument and counter
	loco  arg
	jzer  base		; argument equals zero (base case)
	stod  fact  		; else store here...
	stod  count		; ...and here
;;;;; start the computation -- Done starts each iteration
	jump  isdone 	        ; test for counter equals zero
;;;;; compute partial results
loop 	lodd  part 
	addd  fact         	; add factorial to partial answer ...
	stod  part	        ; ...and store it
	lodl  top	        ; load counter ...
	subd  decr	        ; ...and decrement it
	jzer  update		; update partial for next iteration
	stol  top	        ; push new counter	
	jump  loop	        
;;;;; set current loop counter 
setcn   stol  top  		; push counter 
	jump  loop	     	
;;;;; set factorial to 1 if argument equals zero
base  	lodd  one
	stod  part
	jump  didit	  	; stop
;;;;; set argument for next iteration 
update  lodd  part
	stod  fact  		; factorial equals old partial
	loco  zero		
	stod  part		; new partial equals zero
	jump  isdone		; any more iterations?
;;;;; test global counter
isdone	lodd  count		
	subd  decr		
	jzer  didit 	      	; if counter equals zero, halt
	stod  count		; otherwise store new counter
	jump  setcn	      	
;;;;; halt
didit   stop			; normal termination
	end
