#include <stdio.h>
#include <string.h>
#include "metastr.h"
extern INSTR_FORMAT format[20];
extern LEVEL2_REGS mac;
extern OPCODE_TABLE ot;
extern PUNCT_TABLE pt;
extern int correct;

extern int kfield,kformat;

FILE *fp;                              /* file pointer for "instr.log"    */
/**************************************************************************/
void pr_format()
/**************************************************************************/
/*
   basically a debugging routine.  Prints the contents of the data
   structure related to defining the fields within an instruction format
                                                                          */
{
  int i,j,k;
  FIELD *p;
  for(i=0;i<20;++i)
  { p = format[i].f;
    if(p == 0) goto printops;
    fprintf(fp,"format \# %d number of words %d\n",i,format[i].nwords);
    for(j=0;j<format[i].nfields;++j)
     {fprintf(fp,"  field \# %d\n",j);
      fprintf(fp,"  field name %s  begin %d end %d\n", p->fname,
                           p->begin,p->end);
      fprintf(fp,"      keyword? %1d punct? %1d constant? %1d register? %1d\n",
                p->key, p->punct, p->constant, p->reg);
      p = p->next;
     }
   }
printops:
   fprintf(fp,"   --- opcode table  --- \n");
   fprintf(fp,"  symbol value format \n");
   for(i=0;i<ot.n;++i)
     fprintf(fp,"%s     %x   %d\n",ot.op[i].sym,ot.op[i].value,
                                     ot.op[i].format);
   fprintf(fp,"  punctuation table   \n");
   for(i=0;i<pt.n;++i)
      fprintf(fp,"%s %d \n", pt.p[i].sym,pt.p[i].value);
   return;
}
/**************************************************************************/
void print_regs()
/**************************************************************************/
{
  int j;
  static char *filename = "instr.log";

  if((fp = fopen(filename,"w")) == (FILE *) NULL)
    {fprintf(stderr,"error opening %s\n",filename);
     exit(1);
    }

  fprintf(fp," regname    value     sprindex\n");
  for(j=0;j<mac.nregs;++j)
    fprintf(fp," %s         %d       %d\n",mac.regtup[j].sym,
                   mac.regtup[j].value,mac.regtup[j].sprno);
  return;
}
/**************************************************************************/
void load_format(fp)
/**************************************************************************/
/*
    initializes the instruction format data structure from input
                                                                          */
FILE *fp;
{ int i,j,k;
  FIELD *p, *plast;
  int nformats, nops;

  for(i=0;i<20;++i)
   {format[i].f = (FIELD *) 0;
    format[i].nfields = 0;
   }
  i = 0;

  fscanf(fp,"%d", &nformats);                /* number of formats        */
  for(i=0;i<nformats;++i)
   {fscanf(fp,"%d %d",&(format[i].nfields), /* number of fields in inst */
                      &(format[i].nwords)); /* number of words occupied */ 
    for(j=0;j<format[i].nfields;++j)
      {p = (FIELD *) calloc(1, sizeof(FIELD));
       if(j==0)
         format[i].f = p;
       else
         plast->next = p;
       plast = p;
       fscanf(fp, "%s", p->fname);
       fscanf(fp, "%d %d %d %d %d %d ", &(p->begin),&(p->end),
                 &(p->key), &(p->punct), &(p->constant), &(p->reg));
      }   /*end processing field */
   } 
  fscanf(fp,"%d",&(mac.nregs));               /* number of registers    */
  for(i=0;i<mac.nregs;++i)
    {fscanf(fp,"%d %d %s",&(mac.regtup[i].value),
                    &(mac.regtup[i].sprno), mac.regtup[i].sym);
    }
  fscanf(fp,"%d", &(ot.n));                  /* number of opcodes      */
  for(i=0;i<ot.n;++i)
    fscanf(fp,"%d %x %s",&(ot.op[i].format),&(ot.op[i].value),
                    ot.op[i].sym);
  fscanf(fp,"%d",&(pt.n));                   /* number of punctuation  */
  for(i=0;i<pt.n;++i)
    fscanf(fp,"%d %s",&(pt.p[i].value),pt.p[i].sym);
}

/**************************************************************************/
void dump_format(fpout)
/**************************************************************************/
/*
   dumps contents of instruction-format data structure to output
                                                                          */
FILE *fpout;
{
  int i,j,k;
  FIELD *p;
  int nformat;

  if(!correct)
    {fprintf(stderr,"**** errors in input.  instr.set file not written\n");
     exit(1);
    }
  i = 0;
  while((format[i].f != (FIELD *) 0) && (i < 20)) ++i;
  nformat = i;
  fprintf(fpout,"%d\n",nformat);
  for(i=0;i<nformat;++i)
     {fprintf(fpout,"%d %d\n",format[i].nfields,format[i].nwords);
      p = format[i].f;
      for(j=0;j<format[i].nfields;++j)
        {fprintf(fpout,"%s\n", p->fname);
         fprintf(fpout,"%d %d %d %d %d %d \n", 
                      p->begin, p->end, p->key, p->punct,
                      p->constant, p->reg);
         p = p->next;
        }
     }
  fprintf(fpout,"%d\n",mac.nregs);               /* number of registers    */
  for(i=0;i<mac.nregs;++i)
    {fprintf(fpout,"%d %d %s\n",mac.regtup[i].value,
                    mac.regtup[i].sprno, mac.regtup[i].sym);
    }
  fprintf(fpout,"%d\n", ot.n);                  /* number of opcodes      */
  for(i=0;i<ot.n;++i)
    {fprintf(fpout,"%d %x %s\n",ot.op[i].format,ot.op[i].value,
                    ot.op[i].sym);
    }
  fprintf(fpout,"%d\n", pt.n);                 /* number of punctuation  */
  for(i=0;i<pt.n;++i)
    fprintf(fpout,"%d %s\n",pt.p[i].value,pt.p[i].sym);
  return;
}
/**************************************************************************/
int tods(begin,end,key,punct,constant,reg,name)
/**************************************************************************/
/*
  sets the values for field number "kfield" in instruction number
  "kformat".
                return 1 -- sucess
                       0 -- damaged data structure
                                                                          */
int begin,end,key,punct,constant,reg;
char *name;
{
  FIELD *p;
  int i;

  i = 1;
  if(kfield == 0)
    {format[kformat].f = (FIELD *) calloc (1,sizeof(FIELD));
     p = format[kformat].f;
    }
  else
    {p = format[kformat].f;
     while(p->next != (FIELD *) 0)
       { p = p->next;
         ++i;
       }
     if(i != kfield) warning("trying to initialize a preinit'd field");
     p->next = (FIELD *) calloc(1,sizeof(FIELD));
     p = p->next;
    }
  if(begin <= end)
    {p->begin = begin;
     p->end = end;
    }
  else
    {p->end = begin;
     p->begin = end;
    }
  p->key = key;
  p->punct = punct;
  p->constant = constant;
  p->reg = reg;
  strcpy(p->fname,name);
  format[kformat].nfields = kfield + 1;
  return 1;
}
/**************************************************************************/
void tooptable(name,value,isop)
/**************************************************************************/
char *name;
int value, isop;
/*
  puts opcode name and value into next available location in opcode table
                                                                          */
{
  char str[80];
  int i;
  int j;

  i = ot.n;
 /*  check for duplication of symbols   */
  for(j=0;j<ot.n;++j)
    if(!strcmp(name,ot.op[j].sym))
        {sprintf(str, "%s is multiply defined ", name);
         warning(str);
         return;
        }
  strcpy(ot.op[i].sym,name);
  ot.op[i].value = value;
  if(isop)
    ot.op[i].format = kformat;
  else
    ot.op[i].format = -1;
  ++(ot.n);
  return;
}
/**************************************************************************/
void topuncttable(sym,value)
/**************************************************************************/
char *sym;
int value;
{
  int j;

  for(j=0;j<pt.n;++j)
    if(!strcmp(sym,pt.p[j].sym))
         return;
  j = pt.n;
  strcpy(pt.p[j].sym,sym);
  pt.p[j].value = value;
  ++(pt.n);
  return;
}
/**************************************************************************/
void finish_format()
/**************************************************************************/
/*
  calcuate the number of 16-bit words occupied by this instruction
  fill in the ".nwords" field in the format d.s.
                                                                         */
{
    int i,j;
    int big, nformat;
    FIELD *p;

    i = 0;
    while((format[i].f != (FIELD *) 0) && (i < 20)) ++i;

    nformat = i;
    for(i=0;i<nformat;++i)
     {big = 0;
      p = format[i].f;
      for(j=0;j<format[i].nfields;++j)
         {if(p->end > big) big = p->end;
          p = p->next;
         }
      format[i].nwords = (big / 16) + 1;
     }
}
