#include <stdio.h>
#include <string.h>
#include "arch.h"
#include "user.h"
 
extern int arch_level;
extern MICROINSTRUCTION cs[LENGTHCS];
extern MACINSTRUCTION mac[LENGTHMAC];

extern int nummacops;
extern OP_ENTRY opct[500];
extern int nummacregs;
extern SVP regt[16];

void response();

/****************************************************************************/
int proc_load(initial)
/****************************************************************************/
  int initial;
/*
  loads level-2 and control store from named files
                                                                            */
{
  char str[80],str2[80];
  FILE *binp;
  void get_any(), response();

  if(initial)
    {if(arch_level == MICRO)
      strcpy(str,"control.mic");
     else 
      strcpy(str,"loadst.mac");
     goto tryread;
    }

  if(span_white() <= 0)
    {response("load what?");
     return 0;
    }
  else
    get_any(str);

  if(!nameok(str))
    {if(arch_level == MACRO)
         sprintf(str2,"%s illegal as level-2 code",str);
     else
         sprintf(str2,"%s illegal as microcode",str);
     response(str2);
     fflush(stdin);
     if(initial) exit(1);
     return 0;
    }
 tryread:
  binp = fopen(str,"r");
  if(binp == (FILE *) NULL)
   {sprintf(str2, "can't open %s",str);
    fclose(binp);
    response(str2);
    fflush(stdin);
    if(initial) exit(1);
    return 0; 
   }
 doread(str,binp,initial);
 fflush(stdin);
 return 0;
}
/**************************************************************************/
int doread(str,binp,initial)
/**************************************************************************/
 char *str;
 FILE *binp;
 int initial;
{
  int nline,ul,j,status;
  MACINSTRUCTION temp;
  char str2[80];

  nline = 0;
  if(arch_level == MICRO)
   {ul = LENGTHCS;
    while(get_mic_instr(binp,&(cs[nline])) != 0)
      {++nline;
       if(nline >= ul)
        {response("too many instructions for control store\n");
         fclose(binp);
         if(initial) exit(1);
         return 0;
        }
      }
    sprintf(str2, "%s read successfully. program length: %d",str, nline);
    if(!initial)response(str2);
    fclose(binp);
    return 0;
   }
  else            /* dealing with mac-level instructions   */
   { ul = LENGTHMAC;
     status =load_mac(binp,ul); 
     if(status == 0)
        {response("too many instructions for level-2 memory\n");
         fclose(binp);
         if(initial) exit(1);
         return 0;
        }
    if(status == -1) return 0;
    sprintf(str2,"%s read successfully. program length: %d",str,status);
    if(!initial)response(str2);
    fclose(binp);
    return 0;
   }
}
/**************************************************************/
int preload(f1,f2)
/**************************************************************/
 char *f1, *f2;
/*
  processes command-line arguments, which should be 
  names of mac and mic files
                                                              */
{ int temp_level;
  FILE *fp;
  char *mic, *mac;
  char msg[80];
  int j;
 
  arch_level = MICRO;
  if(nameok(f1))
      mic = f1;
  else if(nameok(f2))
           mic = f2;
       else
          {response("no valid microcode file name in command line arguments");
           return 0;
          }
  fp = fopen(mic,"r");
  if(fp == (FILE *) NULL)
    {sprintf(msg,"can't open %s \n", mic);
     fclose(fp);
     response(msg);
     return 0;
    }
  doread(mic,fp,0);
  arch_level = MACRO;
  if(nameok(f1))
      mac = f1;
  else if(nameok(f2))
           mac = f2;
       else
          {response("no valid level-2 file name in command line arguments");
           return 0;
          }
  fp = fopen(mac,"r");
  if(fp == (FILE *) NULL)
    {sprintf(msg,"can't open %s \n", mac);
     fclose(fp);
     response(msg);
     return 0;
    }
  doread(mac,fp,0);
  return 1;
}
/**************************************************************/
int nameok(str)
/**************************************************************/
/*
  checks for correct dot extensions, depending on the user
  is loading a mic binary into control store or a mac binary
  into level-2 memory.  There really should be something
  internally embedded in the files themselves, but this
  will have to do for now                  
                                                              */
 char *str;
{
  int slen;

  slen = strlen(str);
  slen = slen -4;    /* backing up to check extension */
  if(arch_level == MACRO)
   if(!strncmp(str+slen, ".mac",4))
     return 1;
   else
      return 0;
  else
   if(!strncmp(str+slen, ".mic",4))
     return 1;
   else
     return 0;
}
void get_any(str)
  char *str;

{ int j;
  char ch;
  j = 0;
  while((ch=getc(stdin)) != EOF)
   {if(ch <= ' ' || ch == '\n')
      {str[j] = '\0';
       ungetc(ch,stdin); 
       return;
      }
    else
      str[j++] = ch;
   }
}
/*****************************************************************/
int load_mac(fp,ul)
/*****************************************************************/
/*
   reads assembled code from file.  reads some prepended symbol 
   tables for use by the simulator
                                                                 */
FILE *fp;
int ul;
{
  int j;
  int numinst;
  char str[80];

  fgets(str,80,fp);
  if(strncmp(str,"mac",3))
     {response("not a legal assembly language file");
      return -1;
     }
  fscanf(fp, "%d", &nummacops);        /* get number of opcodes  */
  for(j=0;j<nummacops;++j)
     {                                 /* get opcode name,       */
      fscanf(fp,"%s %d %d %d",opct[j].sym,      /* value, and bit*/
             &(opct[j].value),&(opct[j].begin),
                         &(opct[j].end));       /* positions     */
     }
  fscanf(fp,"%d", &(nummacregs));       /* number of registers   */
  for(j=0;j<nummacregs;++j)             /* record register name  */
                                /* and scratchpad register index */
     fscanf(fp,"%s %d",regt[j].sym,&(regt[j].value));
  fscanf(fp,"%d",&numinst);             /* number of assembled   */
  if(numinst > ul) return 0;          
  for(j=0;j<numinst;++j)                      /* instructions    */
     fscanf(fp,"%x",&(mac[j]));                   /* instruction */
  return numinst; 
}
