/*
   This is the table-driven assembler ("assem") which is part of
   the IST software package.  It takes as arguments the user-defined
   instruction set and an assembly-language program.  If necessary,
   "assem" execs "meta" (the meta-assembler) to create the tables
   necessary for "assem"  to properly assembly an assembly-language
   source file.  The assembly-language source file is assumed to
   have a ".asm" extension.  The assembly-language object file
   has an extension of ".mac"
                                                      rjn
                                                                      */
#include <stdio.h>
#include "../frend/ist.h"
extern int correct;

main(argc,argv)
int argc;
char *argv[];
{
  FILE *srcp, *setp, *objp;
  char source[50], binary[50];

  if(argc < 3)
   {fprintf(stderr,
	    "usage:  assem <instruction-set-file> <source-file> \n");
    exit(1);
   }
  initialize(); 
  if(!dateok(argv[1],"instr.set"))
    if(!dofork(METAPATH,"meta",argv[1],0))
       exit(1);
  setp = fopen("instr.set", "r");
  if(setp == (FILE *) NULL)
   {fprintf(stderr, 
            "problems opening %s as instruction set file \n", 
             "instr.set");
    exit(1);
   }
  load_format(setp);
  strcpy(source,argv[2]);
  strcat(source,".asm");
  strcpy(binary,argv[2]);
  strcat(binary,".mac");
  if(dateok(source,binary))        /* if both source and instruction set */
    if(dateok("instr.set",binary)) /* have earlier dates than binary     */
     {printf("%s is up to date\n",binary);
      exit(0);                     /* no need to assemble                */
     }

  srcp = fopen(source, "r");
  if(srcp == (FILE *) NULL)
   {fprintf(stderr, "can't open %s as input \n", source);
    exit(1);
   }
  pass_one(srcp);
  check_table();
  if(!correct)
    {fprintf(stderr, "***** errors in input.  no object file created\n");
     exit(1);
    }
  srcp = freopen(source,"r",srcp);
  pass_two(srcp);
  objp = fopen(binary,"w");
  if(objp == (FILE *) NULL)
     {fprintf(stderr,"can't open %s as output\n",binary);
      exit(1);
     }
  write_obj(objp);
  printf(" successful assembly\n");
  printf(" assembly object written on %s \n",binary);
  exit(0);
}
