;
;  program written in one-address assembly language
;  to bubble sort 10 numbers.  Array name is 'array'
;					rjn  2 Jul 91
;
arg     equ    10          ;number of elements in array
last    equ    90          ;address of number of elements
nxtl    equ    99          ;address of one less than number of elements
one     equ    92	   ;address of increment
i       equ    98          ;address of variable i
j       equ    97          ;address of variable j
ivalue  equ    96          ;address of copy of array[i]
jvalue  equ    95          ;address of copy of array[j]
;
;  first, let's get the two index counters working
;
        loco   1
	stod   one         ;initialize increment
	loco   arg
        stod   last        ;initialize upper bound
	subd   one
	stod   nxtl
        loco   0
	stod   i
;
;  initialize inner loop variables
;
outer   lodd   i
	addd   one
	stod   j	  
inner   lodd   j	   ;for(j=i+1;
        swap   
	lodl   array       ;get a[j]
	stod   jvalue
	lodd   i
	swap
	lodl   array       ;get a[i]
	subd   jvalue      ;ac = a[i] - a[j]
        jneg   incr        ;jump if a[i] <= a[j]
	jzer   incr
;
;  swap the two array elements
;
	lodl   array       ;get a[i];
	stod   ivalue      ;save a[i] in ivalue
	lodd   jvalue      ;ac = a[j]
	stol   array       ;array[i] = array[j]
	lodd   j           ;index on j
	swap
	lodd   ivalue      ;get old value of a[i]
        stol   array       ;array[j] = old value of a[i]
;
; increment and test the inner loop variable
;
incr    lodd   j
	addd   one
	stod   j           ;                 ;++j)
	subd   last                   ;j< last;
	jneg   inner
;
; increment & test outer loop variable
;
        lodd   i
	addd   one
	stod   i
	subd   nxtl
        jneg   outer
        stop
array   org    100         ; array values
	const  10
	const  9
	const  8
	const  7
	const  6
	const  5
	const  4
	const  3
	const  2
	const  1
        end
