#include <stdio.h>
#include <string.h>
extern int srclines, kformat,kfield;
/****************************************************************/
void proc_op(line,fp)
/****************************************************************/
char *line;
FILE *fp;
/*
 processes all lines associated with declaring opcodes
                                                                */
{
  char fname[40], symbol[40];
  int begin,end, nch, value;
  char ch;
  int ich;
  void parse_dir();

/*
  current line holds the opcode directive.  Have parse break
  it into its components
                                                                */
  parse_dir(line,fname,&begin,&end);
/*
  gather opcode, value pairs until we hit another directive 
                                                                */
loop:if(feof(fp))
       {tods(begin,end,1,0,0,0,fname);
        ++kfield;
        return;
       }
     ich = fgetc(fp);
     if(ich == EOF)
       {tods(begin,end,1,0,0,0,fname);
        ++kfield;
        return;
       }
     ch = ich;
     ungetc(ch,fp);
     if(ch == '#')         /* have hit another directive       */
        {tods(begin,end,1,0,0,0,fname);
         ++kfield;
         return;
        }
     fgets(line,81,fp);++srclines;convert_lc(line);
     if(ch == ';') goto loop;        /* comment line           */
     nch = 0;
     if(an_str(line,&nch,symbol) < 1)
        {error("opcode name is missing or nonalphanumeric");
         goto loop;
        }
     if(get_num(line,&nch,&value) < 1)
        {error("opcode value is missing or nonnumeric");
         goto loop;
        }
     if(strlen(symbol) > 7)
        {warning("opcode name has been truncated to 7 characters");
         symbol[7] = '\0';
        }
/*
   have opcode symbol and value.  Put it in the opcode name table
                                                               */
     tooptable(symbol,value,1);
     goto loop;
}

/****************************************************************/
void parse_dir(line,fname,begin,end)
/****************************************************************/
char *line;
char *fname;
int *begin, *end;
/*
   process a field definition  
   gets field name -- fname
        beginning bit position -- begin
        ending bit position  -- end
                                                                */
{ int nch;
  char punct[2];
  
  nch = 1;                       /* since we know str[0] == '#' */
  *end = 0;
  *begin = 0;
  if(an_str(line,&nch,fname) < 1)
    fatal_error("field name must be alphanumeric"); 
  if(get_num(line,&nch,begin) < 1)
    error("beginning bit position must be numeric");
  if(get_punct(line,&nch,punct) < 1)
    error("missing colon between bit fields");
  if(get_num(line,&nch,end) < 1)
    error("ending bit position must be numeric");
  return;
} 

