#include <string.h>
#include "arch.h"
#define z_ oreg[6]
#define n_ oreg[5]
#define mpc oreg[4]
#define alatch oreg[2]
#define blatch oreg[3]
#define mbr_ oreg[1]
#define mar_ oreg[0]

#define YES 1
#define NO  -1

extern MACINSTRUCTION mac[LENGTHMAC];
extern MICROINSTRUCTION mir, cs[LENGTHCS];
extern int rdstate, wrstate;
extern int stats, cycles1, cycles2, nwfetches, nwstores;
extern SCRATCHPAD spr[16];
extern SCRATCHPAD oreg[7];
extern SVP regt[16];

void perfs_1(), perfs_2(),perfs_3(), perfs_4();

/********************************************************************/
void ex_mic_instr()
/********************************************************************/
/*
   performs one complete cycle in the data paths of the
   microarchtecture
                                                                    */
{
  int n,z, shiftout;     /* n,z are the output signals from shifter */
                         /* shiftout is the output from the shifter */
  perfs_1();             /* subcycle 1*/
  perfs_2();             /* subcycle 2*/
  perfs_3(&n,&z,&shiftout); /*scycle 3*/
  perfs_4(n,z,shiftout); /* subcycle 4*/
  if(stats == YES)       /* update number of cycles elapsed         */
      ++cycles1;  
  return;
}
 
/********************************************************************/
void perfs_1()
/********************************************************************/
/*
   performs subcycle-1 tasks
                                                                    */
{
   mir = cs[mpc];      /* load microinstruction register            */
   return;
}
/********************************************************************/
void perfs_2()
/********************************************************************/
/*
  performs subcycle-2 tasks
                                                                    */
{ int gotpc,gotone;
  char name[10];

  gotpc = 0;
  gotone = 0; 
  if(mir.areg != '*')
    alatch = spr[(int)mir.areg];  /*   load a-latch from scratchpad */
  else
    alatch = spr[0];
  if(mir.breg != '*')
    blatch = spr[(int)mir.breg];  /*   load b-latch  "    "         */
  else
    blatch = spr[0];

  /*  closest parameter to number of assembly-level instructions
      executed is the number of times the pc is incremented         */

  if((int)mir.areg == ONE) gotone = 1;
  if((int)mir.breg == ONE) gotone = 1;
  macname((int)mir.areg,name);
  if(!strncmp(name,"pc",2)) gotpc = 1;
  macname((int)mir.breg,name);
  if(!strncmp(name, "pc",2)) gotpc = 1;
  macname((int)mir.creg,name);
  if(!strncmp(name, "pc",2))
    if (gotpc & gotone & (stats == YES))
       { ++cycles2;
       }
  return;
}
/********************************************************************/
void perfs_3(n,z,shiftout)
/********************************************************************/
/*
  performs subcycle-3 tasks
                                                                    */
 int *n,*z;                   /* status outputs from alu            */
 int *shiftout;               /* output from shifter                */
{
 SCRATCHPAD amux,alu;

 if(mir.amux == 1)            /* determine intput for A-side of alu */
    amux = mbr_;
 else
    amux = alatch;
 switch(mir.alu)              /* perform alu operation              */
  {case 0: alu = (amux + blatch) & 0x0ffff;               /* a + b  */
           break;
   case 1: alu = amux & blatch;                           /* a and b*/
           break;
   case 2: alu = amux;                                    /* pass a */
           break;
   case 3: alu = ~amux;                                   /* not a  */
	   break;
   case 42: alu = amux;            /* an 'unused' ie, '*' is really */
           break;                                         /* pass a */
  }
 *n = 0; *z = 0;
 if(alu == 0) *z = 1;
 if(alu & 0x8000) *n = 1;
 switch(mir.sh)              /* perform shifter operation          */
  {case 0: *shiftout = (int) alu;                        /* pass   */
           break;
   case 1: *shiftout = (int)((alu >> 1) & 0x07fff);      /* right s*/
           break;
   case 2: *shiftout = (int)((alu << 1) & 0x0fffe);      /* left sh*/
           break;
   case 42: *shiftout = (int) alu;                /* really a pass */
  }
 if(mir.mar == 1)            /* load mar, if needed                */
   mar_ = (blatch & 0x0fff); /* recall that mar has only 12 bits   */
 return;
}
/********************************************************************/
void perfs_4(n,z,shiftout)
/********************************************************************/
/*
  performs subcycle 4 tasks
                                                                    */
int n,z,shiftout;                    /* from alu, shifter           */
{
  n_ = n;                            /* record values of n, z in    */
  z_ = z;                            /* pseudo-reg that can be      */
                                     /* displayed                   */
  if(mir.enc == 1)                   /* write scratchpad from shift?*/
   spr[mir.creg] = (SCRATCHPAD) (shiftout & 0x0ffff);
  if(mir.mbr == 1)                   /* load mbr from shifter?      */
   mbr_ = (SCRATCHPAD) (shiftout & 0x0ffff);
  switch(mir.cond)                   /* determining mpc             */
   {case 0: ++mpc;		                      /* no jump    */         
            break;
    case 1: if(n)				      /* jump if neg*/
              mpc = mir.addr & 0x0ff;
            else
              ++mpc;
            break;
    case 2: if(z)				      /* jump if 0  */
              mpc = mir.addr & 0x0ff;
            else
              ++mpc;
            break;
    case 3: mpc = mir.addr & 0x0ff;                   /* uncond jump*/
            break;
    case 42: ++mpc;                                   /* unset==nojm*/
   }
  /*                          handle read, write to level-2 memory  */
  /*  read signal must be on for two clock cycles
      possibilities: no read -- reset rdstate
                        read  if(rdstate)
                                 do read
                              else
                                 set rdstate
                                                                    */
  if(mir.rd == 1)
    if(rdstate)
       {mbr_ = (SCRATCHPAD) (mac[mar_] & 0x0ffff); 
        ++nwfetches;
       }
    else
       rdstate = 1;
  else
    rdstate = 0;
  if(mir.wr == 1)
    if(wrstate)
       {mac[mar_] = (MACINSTRUCTION) mbr_;
        ++nwstores;
       }
    else
       wrstate = 1;
  else
    wrstate = 0;
 return;
} 
