#include "arch.h"
#include <stdio.h>
#include <string.h>
/*
    all routines that set or examine any register or memory
    in either the microarchitecture or at the assembly-language
    level
                                                                  */
/*
    microarchitecture
                                                                  */
SCRATCHPAD spr[16];                 /* scratchpad register        */
SCRATCHPAD oreg[7];                 /* other registers in micro 
                                       architecture               */
MICROINSTRUCTION mir, cs[LENGTHCS]; /* micro instruction reg,
                                       control store              */
int rdstate, wrstate;               /* has r/w signal been 
                                       sustained long enough      */

char *sprnames[16]=
  {"pc    ","ac    ","sp    ","ir    ",
   "tir   ","zero  ","one   ","neg1  ",
   "amask ","smask ","a     ","b     ",
   "c     ","d     ","e     ","f     "};
char *ornames[7] =
  {"mar   ","mbr   ","alatch","blatch",
   "mpc   ","n     ","z     " };
/*
  level-2 (conventional machine-level) architecture
                                                                  */
MACINSTRUCTION mac[LENGTHMAC];
/*
  level-2 register names, opcode names
                                                                  */
SVP regt[16];
int nummacregs;
OP_ENTRY opct[500];
int nummacops;

void bit_string();
 
int set_mac_reg(in,value)
/*
   sets level-2 registers
                                                                  */
 int in;
 SCRATCHPAD value;
{ if(!(ZERO <= in  && in <= MONE))
    spr[in] = value;
  return 1;
}
int set_mac_mem(in,value)
/*
  sets level-2 memory words
                                                                  */
{
 if(0 <= in && in <= LENGTHMAC)
  {mac[in] = value;
   return 1;
  }
 return 0;
}
int examine_mac(addr,l2name)
 int addr;
 int l2name;

{char str[80],str2[40];
  bit_string(str2,(int)spr[addr], 16);
  sprintf(str,"%s: %s",regt[l2name].sym,str2);
  response(str);
  return 1;
}
int dump_mac(addr)
 int addr;

 {char str[80], str2[40];

  bit_string(str2,(int)mac[addr], 16);
  sprintf(str,"mem[%d]: %s ", addr, str2);
  get_opc((int)mac[addr],str2);
  strcat(str, "    ");
  strcat(str,str2);
  response(str);
  return 1;
  }
int set_mic_register(regtype,in,value)
int regtype;
int in;
SCRATCHPAD value;
/*
  sets a value in the scratchpad registers
                                                                 */
{char str[80];
 switch(regtype)
  {case 0:if(PC <= in && in <=TIR) 
            {spr[in] = value;
             return 1;
            }
          if(SMASK < in && in < F)
            {spr[in] = value;
             return 1;
            }
          sprintf(str,"can't set value in constant register %s",sprnames[in]);
          response(str);
          return 0;
   case 1:if(MAR <= in && in <= MPC)
            {oreg[in] = value;
             return 1;
            }
          if(N <= in && in <= Z)
             {sprintf(str,"%s is not a settable register ",ornames[in]);
              response(str);
              return 0;
             }
          response("system err -- set-mic-register");
          return 0;
   default: response("systerm err -- set-mic-register");
          return 0;
}
}
int set_mic_constants()
/*
  puts values in constant registers (called once)
                                                                 */
{
   spr[ZERO];
   spr[ONE] = 1;
   spr[MONE] = -1;
   spr[AMASK] = 0x0fff;
   spr[SMASK] = 0x00ff;
   return 1;
}
int examine_mic(addr,regtype)
 int addr, regtype;
/*
   prints specified micro arch register 
                                                                 */
{ char str[80], str2[80], str3[40];
  switch(regtype)
   {case 0: /*  scratchpad register */
           bit_string(str3,(int)spr[addr],16);
           sprintf(str, "%s: %s ", sprnames[addr],str3);
           break;
    case 1: /*  other 16-bit register */
           if(addr < 5)
             bit_string(str3,(int)oreg[addr],16);
           else
             sprintf(str3,"%1x              ",(int)oreg[addr]);
           sprintf(str, "%s: %s ", ornames[addr],str3);
           break;
    case 2: /*  the dreaded mir */
           disassemble(mir,str2);
           sprintf(str,"mir  : %s",str2);
           break;
   }
    response(str);
    return 1;
}
int dump_mic(addr)
 int addr;
/*
   prints specified control-store location
                                                                 */
{ char str[80], str2[80];
  
  disassemble(cs[addr],str2);
  sprintf(str,"cs[%d]:%s",addr,str2);
  response(str);
  return 1;
}
int get_mic_instr(fp,i)
FILE *fp;
MICROINSTRUCTION *i;
{
 
  if(feof(fp)) return 0;
  fscanf(fp,"%c%c%c%c%c%c%c%c%c%c%c%c%c ",
            &(i->amux),&(i->cond),&(i->alu), &(i->sh), 
            &(i->mbr), &(i->mar), &(i->rd), &(i->wr), 
            &(i->enc), &(i->creg), &(i->breg), 
            &(i->areg), &(i->addr));
  return 1;
}
int put_instr(fp,i)
FILE *fp;
MICROINSTRUCTION i;
{
  fprintf(fp,"%c%c%c%c%c%c%c%c%c%c%c%c%c\n",
            i.amux,i.cond,i.alu, i.sh, i.mbr, i.mar, i.rd, i.wr, 
            i.enc, i.creg, i.breg, i.areg, i.addr);
}
int bformat(str, i)
char *str;
MICROINSTRUCTION i;
{
  sprintf(str,"%1x %1x %1x %1x %1x %1x %1x %1x %1x %1x %1x %1x %4x",
            i.amux,i.cond,i.alu, i.sh, i.mbr, i.mar, i.rd, i.wr, 
            i.enc, i.creg, i.breg, i.areg, i.addr);
  return 1;
}
int get_mac_instr(fp,i)
 FILE *fp;
 MACINSTRUCTION *i;
{
   if((fscanf(fp,"%x",i))== EOF)
      return 0;
   *i = *i & 0x0ffff;
   return 1;
}

