#include <stdio.h>
#include "metastr.h"
 
extern OPCODE_TABLE ot;
extern LEVEL2_REGS mac;
extern INSTR_FORMAT format[20];
extern int curloc;
extern int *objcode;

void write_obj(fp)
/*
   writes assembled code to file.  Prepends some symbol tables
   for use by the simulator
                                                                 */
FILE *fp;
{
  int j;
  int numops;
  FIELD *p;

  fprintf(fp,"mac\n");
  numops = 0;
  for(j=0;j<ot.n;++j)
   if(ot.op[j].format >= 0) ++numops;
  fprintf(fp,"%d\n",numops);           /* number of opcodes     */
  for(j=0;j<ot.n;++j)
   if(ot.op[j].format >= 0)
     {p = format[ot.op[j].format].f;   /* record opcode name,   */
      fprintf(fp,"%s %d %d %d\n",ot.op[j].sym, /* value, and bit*/
             ot.op[j].value,p->begin,p->end);  /* positions     */
     }
  fprintf(fp,"%d\n", mac.nregs);       /* number of registers   */
  for(j=0;j<mac.nregs;++j)             /* record register name  */
                               /* and scratchpad register index */
     fprintf(fp,"%s %d\n",mac.regtup[j].sym, 
            mac.regtup[j].sprno);
  fprintf(fp,"%d\n",curloc);           /* number of assembled   */
  for(j=0;j<curloc;++j)                      /* instructions    */
     fprintf(fp,"%x\n",0x0ffff & *(objcode+j));  /* instruction */
  fclose(fp);
  return;
}
