/*
    This is IST, the Instruction Set Testbed.  

    This module invokes the other four modules, which are
                1) the meta assembler, which generates the table for
                2) the (table-driven) assembler.
                3) the microcode assembler
                4) the simulator
    If the assembly and the microcode assembly are sucessful, then
    ist invokes the simulator.

    The "ist.h" file contains five absolute pathnames that you will 
    have to change in order to install the package on your system. 
    The pathnames are for 1) the meta assembler
                          2) the assembler
                          3) the microcode assembler
	                  4) the simulator
			  5) the online help text file

    If you are running on a Unix system, the only thing that you
    may have to change in this module is the "more" command --
    it may be "pg" on your system.  You'll need to make this
    change in the file "unix.c" (in subdirectory frend).

    NB: the executable holding the simulator is assumed to be "sim"
        the executable holding the assembler is assumed to be "assem"
        the executable holding the microcode assembler is 
						assumed to be "ma"
        the executable holding the meta assembler is
						assumed to be "meta"

    Please send bug reports, etc. to

	Rosalee Nerheim-Wolfe
	DePaul University
	(312) 362-6248
        nerheim@cscvax.depaul.edu
                                                                         */
#define INSTR 1
#define ASM 2
#define MAL 3
#include "ist.h"
#include <stdio.h>

main(argc,argv)
  int argc;
  char *argv[];
{
   char asmname[30], instrname[30], malname[30];

   /* if user doesn't give command line arguments naming
      the instruction set, assembly program, and microcode
      program, prompt for each.
                                                           */
   if(argc < 2)
       {getname("instruction set?", instrname, INSTR);
        getname("assembly program?",  asmname,  ASM);
        getname("microcode program?", malname,  MAL);
       }
   else
                                    /* figure out which argument is which. */
      whadduwegot(argc,argv, instrname, asmname, malname);

   asmname[strlen(asmname)-4] = '\0';
   malname[strlen(malname)-4] = '\0';
                                         /* assemble the assembly program  */
   if(!dofork(ASMPATH,"assem", instrname, asmname))
       {fprintf(stderr, "not running simulation\n");
        exit(1);
       }
				         /* "assemble" the microcode       */
    if(!dofork(MAPATH,"ma",malname, 0))
        {fprintf(stderr, "not running simulation\n");
         exit(1);
         }
                          /* we've passed all the hurdles; run simulator!  */
    strcat(malname,".mic");
    strcat(asmname,".mac");
    dofork(SIMPATH,"sim",malname, asmname);
    exit(0);
}
/**************************************************************************/
int getname(prompt,filename, whichone)
/**************************************************************************/
/*
   prompts user for one of a) the instruction set
                           b) the assembly program
                           c) the microcode program

   returns one for successfully obtaining a filename
           zero for failure
                                                                          */
   char *prompt;
   char *filename;
   int  whichone;     /* 1 --> instruction set; 2 --> assembly program
                         3 --> microcode program                          */
{
 char sext[5];
 int  len; 
 extern int errno, sys_nerr;
 /* extern char *sys_errlist[]; */
 extern const char *const sys_errlist[];  /* changed by NM */

 printf("%s",prompt);
 switch(whichone)
 {
   case INSTR:scanf("%s", filename);
              if(access(filename,0))   /* does file exist? */
                {fprintf(stderr,
                   "error opening %s as instruction set file \n",
                   filename);
                 if(errno > 0 && errno < sys_nerr)
                     fprintf(stderr,"%s\n", sys_errlist[errno]); 
                 exit(1);
                }
              return 1;
     /* for ".asm", ".mal" files, system supplies the
        dot extension.  The assembler and microcode
        assembler will do the error checking on the file
        contents.
                                                             */
   case ASM:strcpy(sext,".asm");
   case MAL:if(whichone == MAL)
               {strcpy(sext,".mal");
               }
            scanf("%s", filename);
            len = strlen(filename);
            if(len < 5 || strncmp(filename + len -4, sext, 4))
                {strcat(filename,sext);
                }
            return 1;
      }
  return 0;
}
/************************************************************************/
int whadduwegot(c,v,instr, nasm, nmal)
/************************************************************************/
/* Assume that microcode source has dot extension ".mal" 
        and that assembly source has dot extension ".asm"
        The remaining command line argument is assumed
        to be the instruction set.

   If user goofed up command line args, whadduwegot() will
        prompt user for each file.

   Returns 1 
                                                                        */
   int c;
   char *v[];
   char *instr, *nasm, *nmal;
{
  int j, len, offset;
  int gotinstr, gotasm, gotmal, leftover;
 
  gotinstr = 0;
  gotasm = 0;
  gotmal = 0; 
  for(j=1;j<c;++j)           /* are any of the args a microcode file?*/
    {len = strlen(v[j]);
     offset = len - 4;
     if(offset > 0)
       if(!strcmp(v[j]+offset, ".mal"))
         {gotmal = j;
          strcpy(nmal, v[j]);
         }
    }
  for(j=1;j<c;++j)        /* are any of the args an assembly program?*/
    {len = strlen(v[j]);
     offset = len - 4;
     if(offset > 0)
       if(!strcmp(v[j]+offset, ".asm"))
         {gotasm = j;
          strcpy(nasm, v[j]);
         }
    }
  leftover = 0;
  for(j=1;j<c;++j)
    {if(j != gotasm && j!= gotmal)
        leftover = j;
    }
  if(leftover)
    {gotinstr = leftover;
     strcpy(instr, v[leftover]);
    }
  if(!gotinstr)
     getname("instruction set?", instr, INSTR);
  if(!gotasm)
     getname("assembly program?",  nasm,  ASM);
  if(!gotmal)
     getname("microcode program?", nmal,  MAL);
  return 1;
}
