#include <stdio.h>
#include <string.h>
#include <sys/file.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "ist.h"
/**********************************************************************/
int domove(tempfile,fullmal)
/**********************************************************************/
/*
   overwrites file at pathname "fullmal" with the contents of the
   file at "tempfile"
   
   unix system call: system()
   unix command:     mv
                                                                      */
  char *tempfile, *fullmal;
{
  char cmd[256];

   sprintf(cmd,"mv %s %s\n",tempfile,fullmal);
   system(cmd);
   return 1;
}
/*********************************************************************/
int dateok(source, binary)
/*********************************************************************/
   char *source;
   char *binary;
/*
  checks the time stamps of the source file (".mal") and the
  object file (".mic") 
      returns 1 if files are up-to-date
      returns 0 if files need updating (recompile .mal file)
  exits if the named source file doesn't exist.

  Unix system calls:  stat()
  Unix global variables:
                      errno, sys_nerr
                      err_list
                                                                     */
{
  struct stat sbuf, bbuf;                 /* for checking time stamps*/
  extern int errno, sys_nerr;
  /* extern char *sys_errlist[]; */
  extern const char *const sys_errlist[];  /* changed by NM */


   if(stat(source,&sbuf))
     {fprintf(stderr, "error opening %s \n", source);
      if(errno > 0 && errno < sys_nerr)
         fprintf(stderr, "%s\n", sys_errlist[errno]);
      exit(1);
     }
   if(stat(binary,&bbuf))
      {fprintf(stderr," no previous file %s.  Creating it\n", binary);
       return 0;
      }
   else 
     if(sbuf.st_mtime < bbuf.st_mtime)
        return 1;
}
/**********************************************************************/
int dounlink(path)
/**********************************************************************/
   char *path;       /* pathname of file to be deleted                */
/*
  deletes path.
  Unix call:    unlink()
                                                                      */
{
  unlink(path);
  return 1;
}
/**********************************************************************/
int dofork(path,executable,arg1,arg2)
/**********************************************************************/
   char *path;
   char *executable;
   char *arg1;
   char *arg2;  
/*
   executes the program whose path is <path> and whose executable
   file is <executable>.  We will only have at most two arguments,
   which are <arg1> and <arg2>.

        returns 1 -- fork succeed
        returns 0 -- fork failed

   Unix calls:  fork(), wait(), execl()
  
                                                                       */
{
   int   exitvalue;
   int   fail;
   int   pid;
   union wait status;

   fail = 0;
   if((pid = fork()) == 0)
      execl(path,executable, arg1, arg2, 0);
   else 
     {while((pid = wait(&status))== -1)
          printf("early return\n");
      exitvalue = (status.w_status >> 8) & 0177;
      fail = fail | exitvalue;
     }
   if(!fail) return 1;
   return 0;
}
/******************************************************************/
int proc_shell()
/******************************************************************/
/*
  escape to the shell
  Unix system calls: system()
                                                                  */
{
   char line[80];

   fgets(line,80,stdin);
   system(line);
   return 1;
}
/******************************************************************/
int dohelp()
/******************************************************************/
/*
   on-line help:  just puts person in "more" with the pathname
   for the help file
   
   Unix system calls: system()
   Unix commands:     more   (may need to be changed to "pg"
                              on some systems)
                                                                  */ 
{
  char cmd[256];
  sprintf(cmd,"more %s", HELPPATH);
  system(cmd);
  return 1;
}
