#include <stdio.h>
#include "metastr.h"
void proc_regs(fp)
FILE *fp;
{
  char str[81],symbol[80],numstr[80];
  extern int srclines;
  extern LEVEL2_REGS mac;
  int nregs,regvalue,value,spno,nch,nch2,status;
  void fatal_error(), error(), warning();
  char ch;
/*
   processes the input lines that define the level-2 registers
                                                                */
preloop:
  if(feof(fp))fatal_error("premature end of file");
  fgets(str,81,fp); ++srclines;
  convert_lc(str);
  if(!strncmp(str,";",1))goto preloop;      /* ignore comments  */
  if(strncmp(str,"#register",strlen("#register")))
     fatal_error("begin file with a #register command");
  nregs = 0;
/*
   past #register command line.  process register declarations.
   they are in the form
     <sym> <obj> <sprno>
   where <sym> is the symbol name in the assembly language,
   <obj> is the bit string it maps to, and <sprno> is the
  scratchpad register it will occup.  <obj> can be the word
  "null" if the symbolic name does not correspond to a bit
  string in the instruction format
                                                                */
loop: if(feof(fp)) fatal_error("premature end of file");
      ch=getc(fp);                   /* peek at first ch in line*/
      if(ch == ';')
        {++srclines;                 /* comment                 */
         fflush(fp);
         goto loop;
        }
      if(ch == '#')                  /* another command         */
        {if(nregs <1) fatal_error("no register declared");
         if(nregs <3) warning("less then 3 registers declared");
         ungetc(ch,fp);
         mac.nregs = nregs;    
         return;                     /* done processing regs    */
        }
      ungetc(ch,fp);
      fgets(str,81,fp);convert_lc(str);++srclines;
      nch = 0;
      status = an_str(str,&nch,symbol);  /*  get register name  */
      if(status == 0)
        {error("begin register declaration with alphanumeric name");
         goto loop;
        }
      if(status == -1) goto loop;    /* ignore blank lines      */
      if(strlen(symbol) > 8)
        {warning("register name truncated to first 7 characters");
         symbol[7] = '\0';
        }
      status = an_str(str,&nch,numstr); /* get register value   */
      if(status == -1)
        {error("missing value for register name");
         goto loop; 
        } 
      if(status == 0)
        {error("value for register must be numeric or 'null'");
         goto loop;
        }
      value = 0;
      if(!strncmp("null",numstr,4))
           ;
      else
         {nch2 = 0;
          status = get_num(numstr,&nch2,&value);
          if(status ==0)
             {error("register value must be numeric");
              goto loop;
             }
          if(status == -1)
             fatal_error(
               "proc_regs: numstr guar nonnul, but now empty.  see progr");
         }
      regvalue = value;
      status = get_num(str,&nch,&value);  /*  get scratchpad index */
      if(status == -1)
          {error("scratchpad register index missing");
           goto loop;
          }
      if(status == 0)
          {error("scratchpad register index must be numeric");
           goto loop;
          }
      if(value > 15)
          {error("scratchpad register index out of bounds");
           goto loop;
          }
      if(value > 4 && value < 10)
       warning("scratchpad register specified is a constant register");  
 /*
         here we have the register name, the value and the scratchpad
         index.  Record in register data structure.
                                                                       */
      if(nregs > 15)
        fatal_error("can't have more than 16 registers!");
      mac.regtup[nregs].value = regvalue;
      mac.regtup[nregs].sprno = value;
      strcpy(mac.regtup[nregs].sym,symbol);
      ++nregs;
      goto loop;
}
